/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.UserHandle;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AppSecurityPermissions
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int WHICH_NEW = 4;
    public static int WHICH_ALL = 65535;
    private static String TAG = "AppSecurityPermissions";
    private static boolean localLOGV = false;
    private Context mContext;
    private LayoutInflater mInflater;
    private PackageManager mPm;
    private Map<String, MyPermissionGroupInfo> mPermGroups;
    private List<MyPermissionGroupInfo> mPermGroupsList;
    private PermissionGroupInfoComparator mPermGroupComparator;
    private PermissionInfoComparator mPermComparator;
    private List<MyPermissionInfo> mPermsList;
    private CharSequence mNewPermPrefix;
    private String mPackageName;

    private void $$robo$$android_widget_AppSecurityPermissions$__constructor__(Context context) {
        this.mPermGroups = new HashMap<String, MyPermissionGroupInfo>();
        this.mPermGroupsList = new ArrayList<MyPermissionGroupInfo>();
        this.mPermGroupComparator = new PermissionGroupInfoComparator();
        this.mPermComparator = new PermissionInfoComparator();
        this.mPermsList = new ArrayList<MyPermissionInfo>();
        this.mContext = context;
        this.mInflater = (LayoutInflater)this.mContext.getSystemService("layout_inflater");
        this.mPm = this.mContext.getPackageManager();
        this.mNewPermPrefix = this.mContext.getText(17040592);
    }

    private void $$robo$$android_widget_AppSecurityPermissions$__constructor__(Context context, String packageName) {
        PackageInfo pkgInfo;
        this.mPackageName = packageName;
        HashSet<MyPermissionInfo> permSet = new HashSet<MyPermissionInfo>();
        try {
            pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("AppSecurityPermissions", "Couldn't retrieve permissions for package:" + packageName);
            return;
        }
        if (pkgInfo.applicationInfo != null && pkgInfo.applicationInfo.uid != -1) {
            this.getAllUsedPermissions(pkgInfo.applicationInfo.uid, permSet);
        }
        this.mPermsList.addAll(permSet);
        this.setPermissions(this.mPermsList);
    }

    private void $$robo$$android_widget_AppSecurityPermissions$__constructor__(Context context, PackageInfo info) {
        HashSet<MyPermissionInfo> permSet = new HashSet<MyPermissionInfo>();
        if (info == null) {
            return;
        }
        this.mPackageName = info.packageName;
        PackageInfo installedPkgInfo = null;
        if (info.requestedPermissions != null) {
            try {
                installedPkgInfo = this.mPm.getPackageInfo(info.packageName, 4096);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            this.extractPerms(info, permSet, installedPkgInfo);
        }
        if (info.sharedUserId != null) {
            try {
                int sharedUid = this.mPm.getUidForSharedUser(info.sharedUserId);
                this.getAllUsedPermissions(sharedUid, permSet);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w("AppSecurityPermissions", "Couldn't retrieve shared user id for: " + info.packageName);
            }
        }
        this.mPermsList.addAll(permSet);
        this.setPermissions(this.mPermsList);
    }

    private static final View $$robo$$android_widget_AppSecurityPermissions$getPermissionItemView(Context context, CharSequence grpName, CharSequence description, boolean dangerous) {
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        Drawable icon = context.getDrawable(dangerous ? 17302282 : 17302621);
        return AppSecurityPermissions.getPermissionItemViewOld(context, inflater, grpName, description, dangerous, icon);
    }

    private final void $$robo$$android_widget_AppSecurityPermissions$getAllUsedPermissions(int sharedUid, Set<MyPermissionInfo> permSet) {
        String[] sharedPkgList = this.mPm.getPackagesForUid(sharedUid);
        if (sharedPkgList == null || sharedPkgList.length == 0) {
            return;
        }
        for (String sharedPkg : sharedPkgList) {
            this.getPermissionsForPackage(sharedPkg, permSet);
        }
    }

    private final void $$robo$$android_widget_AppSecurityPermissions$getPermissionsForPackage(String packageName, Set<MyPermissionInfo> permSet) {
        try {
            PackageInfo pkgInfo = this.mPm.getPackageInfo(packageName, 4096);
            this.extractPerms(pkgInfo, permSet, pkgInfo);
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.w("AppSecurityPermissions", "Couldn't retrieve permissions for package: " + packageName);
        }
    }

    private final void $$robo$$android_widget_AppSecurityPermissions$extractPerms(PackageInfo info, Set<MyPermissionInfo> permSet, PackageInfo installedPkgInfo) {
        String[] strList = info.requestedPermissions;
        int[] flagsList = info.requestedPermissionsFlags;
        if (strList == null || strList.length == 0) {
            return;
        }
        for (int i = 0; i < strList.length; ++i) {
            String permName = strList[i];
            try {
                MyPermissionGroupInfo group;
                int existingFlags;
                PermissionInfo tmpPermInfo = this.mPm.getPermissionInfo(permName, 0);
                if (tmpPermInfo == null) continue;
                int existingIndex = -1;
                if (installedPkgInfo != null && installedPkgInfo.requestedPermissions != null) {
                    for (int j = 0; j < installedPkgInfo.requestedPermissions.length; ++j) {
                        if (!permName.equals(installedPkgInfo.requestedPermissions[j])) continue;
                        existingIndex = j;
                        break;
                    }
                }
                int n = existingFlags = existingIndex >= 0 ? installedPkgInfo.requestedPermissionsFlags[existingIndex] : 0;
                if (!this.isDisplayablePermission(tmpPermInfo, flagsList[i], existingFlags)) continue;
                String origGroupName = tmpPermInfo.group;
                String groupName = origGroupName;
                if (groupName == null) {
                    tmpPermInfo.group = groupName = tmpPermInfo.packageName;
                }
                if ((group = this.mPermGroups.get(groupName)) == null) {
                    PermissionGroupInfo grp = null;
                    if (origGroupName != null) {
                        grp = this.mPm.getPermissionGroupInfo(origGroupName, 0);
                    }
                    if (grp != null) {
                        group = new MyPermissionGroupInfo(grp);
                    } else {
                        tmpPermInfo.group = tmpPermInfo.packageName;
                        group = this.mPermGroups.get(tmpPermInfo.group);
                        if (group == null) {
                            group = new MyPermissionGroupInfo(tmpPermInfo);
                        }
                        group = new MyPermissionGroupInfo(tmpPermInfo);
                    }
                    this.mPermGroups.put(tmpPermInfo.group, group);
                }
                boolean newPerm = installedPkgInfo != null && (existingFlags & 2) == 0;
                MyPermissionInfo myPerm = new MyPermissionInfo(tmpPermInfo);
                myPerm.mNewReqFlags = flagsList[i];
                myPerm.mExistingReqFlags = existingFlags;
                myPerm.mNew = newPerm;
                permSet.add(myPerm);
                continue;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.i("AppSecurityPermissions", "Ignoring unknown permission:" + permName);
            }
        }
    }

    private final int $$robo$$android_widget_AppSecurityPermissions$getPermissionCount() {
        return this.getPermissionCount(65535);
    }

    private final List<MyPermissionInfo> $$robo$$android_widget_AppSecurityPermissions$getPermissionList(MyPermissionGroupInfo grp, int which) {
        if (which == 4) {
            return grp.mNewPermissions;
        }
        return grp.mAllPermissions;
    }

    private final int $$robo$$android_widget_AppSecurityPermissions$getPermissionCount(int which) {
        int N = 0;
        for (int i = 0; i < this.mPermGroupsList.size(); ++i) {
            N += this.getPermissionList(this.mPermGroupsList.get(i), which).size();
        }
        return N;
    }

    private final View $$robo$$android_widget_AppSecurityPermissions$getPermissionsView() {
        return this.getPermissionsView(65535, false);
    }

    private final View $$robo$$android_widget_AppSecurityPermissions$getPermissionsViewWithRevokeButtons() {
        return this.getPermissionsView(65535, true);
    }

    private final View $$robo$$android_widget_AppSecurityPermissions$getPermissionsView(int which) {
        return this.getPermissionsView(which, false);
    }

    private final View $$robo$$android_widget_AppSecurityPermissions$getPermissionsView(int which, boolean showRevokeUI) {
        LinearLayout permsView = (LinearLayout)this.mInflater.inflate(17367098, null);
        LinearLayout displayList = (LinearLayout)permsView.findViewById(16909144);
        Object noPermsView = permsView.findViewById(16909082);
        this.displayPermissions(this.mPermGroupsList, displayList, which, showRevokeUI);
        if (displayList.getChildCount() <= 0) {
            ((View)noPermsView).setVisibility(0);
        }
        return permsView;
    }

    private final void $$robo$$android_widget_AppSecurityPermissions$displayPermissions(List<MyPermissionGroupInfo> groups, LinearLayout permListView, int which, boolean showRevokeUI) {
        permListView.removeAllViews();
        int spacing = (int)(8.0f * this.mContext.getResources().getDisplayMetrics().density);
        for (int i = 0; i < groups.size(); ++i) {
            MyPermissionGroupInfo grp = groups.get(i);
            List<MyPermissionInfo> perms = this.getPermissionList(grp, which);
            for (int j = 0; j < perms.size(); ++j) {
                MyPermissionInfo perm = perms.get(j);
                PermissionItemView view = this.getPermissionItemView(grp, perm, j == 0, which != 4 ? this.mNewPermPrefix : null, showRevokeUI);
                LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, -2);
                if (j == 0) {
                    lp.topMargin = spacing;
                }
                if (j == grp.mAllPermissions.size() - 1) {
                    lp.bottomMargin = spacing;
                }
                if (permListView.getChildCount() == 0) {
                    lp.topMargin *= 2;
                }
                permListView.addView((View)view, lp);
            }
        }
    }

    private final PermissionItemView $$robo$$android_widget_AppSecurityPermissions$getPermissionItemView(MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix, boolean showRevokeUI) {
        return AppSecurityPermissions.getPermissionItemView(this.mContext, this.mInflater, grp, perm, first, newPermPrefix, this.mPackageName, showRevokeUI);
    }

    private static final PermissionItemView $$robo$$android_widget_AppSecurityPermissions$getPermissionItemView(Context context, LayoutInflater inflater, MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix, String packageName, boolean showRevokeUI) {
        PermissionItemView permView = (PermissionItemView)inflater.inflate((perm.flags & 1) != 0 ? 17367096 : 17367095, null);
        permView.setPermission(grp, perm, first, newPermPrefix, packageName, showRevokeUI);
        return permView;
    }

    private static final View $$robo$$android_widget_AppSecurityPermissions$getPermissionItemViewOld(Context context, LayoutInflater inflater, CharSequence grpName, CharSequence permList, boolean dangerous, Drawable icon) {
        View permView = inflater.inflate(17367097, null);
        TextView permGrpView = (TextView)permView.findViewById(16909141);
        TextView permDescView = (TextView)permView.findViewById(16909143);
        ImageView imgView = (ImageView)permView.findViewById(16909137);
        imgView.setImageDrawable(icon);
        if (grpName != null) {
            permGrpView.setText(grpName);
            permDescView.setText(permList);
        } else {
            permGrpView.setText(permList);
            permDescView.setVisibility(8);
        }
        return permView;
    }

    private final boolean $$robo$$android_widget_AppSecurityPermissions$isDisplayablePermission(PermissionInfo pInfo, int newReqFlags, int existingReqFlags) {
        boolean isGranted;
        boolean isNormal;
        int base = pInfo.protectionLevel & 0xF;
        boolean bl = isNormal = base == 0;
        if (isNormal) {
            return false;
        }
        boolean isDangerous = base == 1 || (pInfo.protectionLevel & 0x80) != 0;
        boolean isRequired = (newReqFlags & 1) != 0;
        boolean isDevelopment = (pInfo.protectionLevel & 0x20) != 0;
        boolean wasGranted = (existingReqFlags & 2) != 0;
        boolean bl2 = isGranted = (newReqFlags & 2) != 0;
        if (isDangerous && (isRequired || wasGranted || isGranted)) {
            return true;
        }
        return isDevelopment && wasGranted;
    }

    private final void $$robo$$android_widget_AppSecurityPermissions$addPermToList(List<MyPermissionInfo> permList, MyPermissionInfo pInfo) {
        int idx;
        if (pInfo.mLabel == null) {
            pInfo.mLabel = pInfo.loadLabel(this.mPm);
        }
        if ((idx = Collections.binarySearch(permList, pInfo, this.mPermComparator)) < 0) {
            idx = -idx - 1;
            permList.add(idx, pInfo);
        }
    }

    private final void $$robo$$android_widget_AppSecurityPermissions$setPermissions(List<MyPermissionInfo> permList) {
        if (permList != null) {
            for (MyPermissionInfo pInfo : permList) {
                MyPermissionGroupInfo group;
                if (!this.isDisplayablePermission(pInfo, pInfo.mNewReqFlags, pInfo.mExistingReqFlags) || (group = this.mPermGroups.get(pInfo.group)) == null) continue;
                pInfo.mLabel = pInfo.loadLabel(this.mPm);
                this.addPermToList(group.mAllPermissions, pInfo);
                if (!pInfo.mNew) continue;
                this.addPermToList(group.mNewPermissions, pInfo);
            }
        }
        for (MyPermissionGroupInfo pgrp : this.mPermGroups.values()) {
            if (pgrp.labelRes != 0 || pgrp.nonLocalizedLabel != null) {
                pgrp.mLabel = pgrp.loadLabel(this.mPm);
            } else {
                try {
                    ApplicationInfo app = this.mPm.getApplicationInfo(pgrp.packageName, 0);
                    pgrp.mLabel = app.loadLabel(this.mPm);
                }
                catch (PackageManager.NameNotFoundException e) {
                    pgrp.mLabel = pgrp.loadLabel(this.mPm);
                }
            }
            this.mPermGroupsList.add(pgrp);
        }
        Collections.sort(this.mPermGroupsList, this.mPermGroupComparator);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AppSecurityPermissions$__constructor__(context);
    }

    private AppSecurityPermissions(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, String string2) {
        this.$$robo$$android_widget_AppSecurityPermissions$__constructor__(context, string2);
    }

    public AppSecurityPermissions(Context context, String string2) {
        this(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions$__constructor__(android.content.Context java.lang.String ), 0, this, context, string2);
    }

    private void __constructor__(Context context, PackageInfo packageInfo) {
        this.$$robo$$android_widget_AppSecurityPermissions$__constructor__(context, packageInfo);
    }

    public AppSecurityPermissions(Context context, PackageInfo packageInfo) {
        this(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions$__constructor__(android.content.Context android.content.pm.PackageInfo ), 0, this, context, packageInfo);
    }

    public static View getPermissionItemView(Context context, CharSequence charSequence, CharSequence charSequence2, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("getPermissionItemView", $$robo$$android_widget_AppSecurityPermissions$getPermissionItemView(android.content.Context java.lang.CharSequence java.lang.CharSequence boolean ), 0, (Context)context, (CharSequence)charSequence, (CharSequence)charSequence2, (boolean)bl);
    }

    private void getAllUsedPermissions(int n, Set<MyPermissionInfo> set) {
        InvokeDynamicSupport.bootstrap("getAllUsedPermissions", $$robo$$android_widget_AppSecurityPermissions$getAllUsedPermissions(int java.util.Set<android.widget.AppSecurityPermissions$MyPermissionInfo> ), 0, this, n, set);
    }

    private void getPermissionsForPackage(String string2, Set<MyPermissionInfo> set) {
        InvokeDynamicSupport.bootstrap("getPermissionsForPackage", $$robo$$android_widget_AppSecurityPermissions$getPermissionsForPackage(java.lang.String java.util.Set<android.widget.AppSecurityPermissions$MyPermissionInfo> ), 0, this, string2, set);
    }

    private void extractPerms(PackageInfo packageInfo, Set<MyPermissionInfo> set, PackageInfo packageInfo2) {
        InvokeDynamicSupport.bootstrap("extractPerms", $$robo$$android_widget_AppSecurityPermissions$extractPerms(android.content.pm.PackageInfo java.util.Set<android.widget.AppSecurityPermissions$MyPermissionInfo> android.content.pm.PackageInfo ), 0, this, packageInfo, set, packageInfo2);
    }

    public int getPermissionCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPermissionCount", $$robo$$android_widget_AppSecurityPermissions$getPermissionCount(), 0, this);
    }

    private List<MyPermissionInfo> getPermissionList(MyPermissionGroupInfo myPermissionGroupInfo, int n) {
        return InvokeDynamicSupport.bootstrap("getPermissionList", $$robo$$android_widget_AppSecurityPermissions$getPermissionList(android.widget.AppSecurityPermissions$MyPermissionGroupInfo int ), 0, this, myPermissionGroupInfo, n);
    }

    public int getPermissionCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPermissionCount", $$robo$$android_widget_AppSecurityPermissions$getPermissionCount(int ), 0, this, n);
    }

    public View getPermissionsView() {
        return InvokeDynamicSupport.bootstrap("getPermissionsView", $$robo$$android_widget_AppSecurityPermissions$getPermissionsView(), 0, this);
    }

    public View getPermissionsViewWithRevokeButtons() {
        return InvokeDynamicSupport.bootstrap("getPermissionsViewWithRevokeButtons", $$robo$$android_widget_AppSecurityPermissions$getPermissionsViewWithRevokeButtons(), 0, this);
    }

    public View getPermissionsView(int n) {
        return InvokeDynamicSupport.bootstrap("getPermissionsView", $$robo$$android_widget_AppSecurityPermissions$getPermissionsView(int ), 0, this, n);
    }

    private View getPermissionsView(int n, boolean bl) {
        return InvokeDynamicSupport.bootstrap("getPermissionsView", $$robo$$android_widget_AppSecurityPermissions$getPermissionsView(int boolean ), 0, this, n, bl);
    }

    private void displayPermissions(List<MyPermissionGroupInfo> list, LinearLayout linearLayout, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("displayPermissions", $$robo$$android_widget_AppSecurityPermissions$displayPermissions(java.util.List<android.widget.AppSecurityPermissions$MyPermissionGroupInfo> android.widget.LinearLayout int boolean ), 0, this, list, linearLayout, n, bl);
    }

    private PermissionItemView getPermissionItemView(MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionInfo myPermissionInfo, boolean bl, CharSequence charSequence, boolean bl2) {
        return InvokeDynamicSupport.bootstrap("getPermissionItemView", $$robo$$android_widget_AppSecurityPermissions$getPermissionItemView(android.widget.AppSecurityPermissions$MyPermissionGroupInfo android.widget.AppSecurityPermissions$MyPermissionInfo boolean java.lang.CharSequence boolean ), 0, this, myPermissionGroupInfo, myPermissionInfo, bl, charSequence, bl2);
    }

    private static PermissionItemView getPermissionItemView(Context context, LayoutInflater layoutInflater, MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionInfo myPermissionInfo, boolean bl, CharSequence charSequence, String string2, boolean bl2) {
        return InvokeDynamicSupport.bootstrapStatic("getPermissionItemView", $$robo$$android_widget_AppSecurityPermissions$getPermissionItemView(android.content.Context android.view.LayoutInflater android.widget.AppSecurityPermissions$MyPermissionGroupInfo android.widget.AppSecurityPermissions$MyPermissionInfo boolean java.lang.CharSequence java.lang.String boolean ), 0, (Context)context, (LayoutInflater)layoutInflater, (MyPermissionGroupInfo)myPermissionGroupInfo, (MyPermissionInfo)myPermissionInfo, (boolean)bl, (CharSequence)charSequence, (String)string2, (boolean)bl2);
    }

    private static View getPermissionItemViewOld(Context context, LayoutInflater layoutInflater, CharSequence charSequence, CharSequence charSequence2, boolean bl, Drawable drawable2) {
        return InvokeDynamicSupport.bootstrapStatic("getPermissionItemViewOld", $$robo$$android_widget_AppSecurityPermissions$getPermissionItemViewOld(android.content.Context android.view.LayoutInflater java.lang.CharSequence java.lang.CharSequence boolean android.graphics.drawable.Drawable ), 0, (Context)context, (LayoutInflater)layoutInflater, (CharSequence)charSequence, (CharSequence)charSequence2, (boolean)bl, (Drawable)drawable2);
    }

    private boolean isDisplayablePermission(PermissionInfo permissionInfo, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isDisplayablePermission", $$robo$$android_widget_AppSecurityPermissions$isDisplayablePermission(android.content.pm.PermissionInfo int int ), 0, this, permissionInfo, n, n2);
    }

    private void addPermToList(List<MyPermissionInfo> list, MyPermissionInfo myPermissionInfo) {
        InvokeDynamicSupport.bootstrap("addPermToList", $$robo$$android_widget_AppSecurityPermissions$addPermToList(java.util.List<android.widget.AppSecurityPermissions$MyPermissionInfo> android.widget.AppSecurityPermissions$MyPermissionInfo ), 0, this, list, myPermissionInfo);
    }

    private void setPermissions(List<MyPermissionInfo> list) {
        InvokeDynamicSupport.bootstrap("setPermissions", $$robo$$android_widget_AppSecurityPermissions$setPermissions(java.util.List<android.widget.AppSecurityPermissions$MyPermissionInfo> ), 0, this, list);
    }

    public /* synthetic */ AppSecurityPermissions() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AppSecurityPermissions)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class PermissionInfoComparator
    implements Comparator<MyPermissionInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private Collator sCollator;

        private void $$robo$$android_widget_AppSecurityPermissions_PermissionInfoComparator$__constructor__() {
            this.sCollator = Collator.getInstance();
        }

        private final int $$robo$$android_widget_AppSecurityPermissions_PermissionInfoComparator$compare(MyPermissionInfo a, MyPermissionInfo b) {
            return this.sCollator.compare(a.mLabel, b.mLabel);
        }

        private void __constructor__() {
            this.$$robo$$android_widget_AppSecurityPermissions_PermissionInfoComparator$__constructor__();
        }

        PermissionInfoComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_PermissionInfoComparator$__constructor__(), 0, this);
        }

        @Override
        public int compare(MyPermissionInfo myPermissionInfo, MyPermissionInfo myPermissionInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_widget_AppSecurityPermissions_PermissionInfoComparator$compare(android.widget.AppSecurityPermissions$MyPermissionInfo android.widget.AppSecurityPermissions$MyPermissionInfo ), 0, this, myPermissionInfo, myPermissionInfo2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionInfoComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class PermissionGroupInfoComparator
    implements Comparator<MyPermissionGroupInfo> {
        public transient /* synthetic */ Object __robo_data__;
        private Collator sCollator;

        private void $$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$__constructor__() {
            this.sCollator = Collator.getInstance();
        }

        private final int $$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$compare(MyPermissionGroupInfo a, MyPermissionGroupInfo b) {
            return this.sCollator.compare(a.mLabel, b.mLabel);
        }

        private /* synthetic */ void $$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$__constructor__();
        }

        private PermissionGroupInfoComparator() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$__constructor__(), 0, this);
        }

        @Override
        public int compare(MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionGroupInfo myPermissionGroupInfo2) {
            return (int)InvokeDynamicSupport.bootstrap("compare", $$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$compare(android.widget.AppSecurityPermissions$MyPermissionGroupInfo android.widget.AppSecurityPermissions$MyPermissionGroupInfo ), 0, this, myPermissionGroupInfo, myPermissionGroupInfo2);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_widget_AppSecurityPermissions_PermissionGroupInfoComparator$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionGroupInfoComparator)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class PermissionItemView
    extends LinearLayout
    implements View.OnClickListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        MyPermissionGroupInfo mGroup;
        MyPermissionInfo mPerm;
        AlertDialog mDialog;
        private boolean mShowRevokeUI;
        private String mPackageName;

        private void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$__constructor__(Context context, AttributeSet attrs) {
            this.mShowRevokeUI = false;
            this.setClickable(true);
        }

        private final void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$setPermission(MyPermissionGroupInfo grp, MyPermissionInfo perm, boolean first, CharSequence newPermPrefix, String packageName, boolean showRevokeUI) {
            this.mGroup = grp;
            this.mPerm = perm;
            this.mShowRevokeUI = showRevokeUI;
            this.mPackageName = packageName;
            ImageView permGrpIcon = (ImageView)this.findViewById(16909137);
            TextView permNameView = (TextView)this.findViewById(16909140);
            PackageManager pm = this.getContext().getPackageManager();
            Drawable icon = null;
            if (first) {
                icon = grp.loadGroupIcon(this.getContext(), pm);
            }
            CharSequence label = perm.mLabel;
            if (perm.mNew && newPermPrefix != null) {
                SpannableStringBuilder builder = new SpannableStringBuilder();
                Parcel parcel = Parcel.obtain();
                TextUtils.writeToParcel(newPermPrefix, parcel, 0);
                parcel.setDataPosition(0);
                CharSequence newStr = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
                parcel.recycle();
                builder.append(newStr);
                builder.append(label);
                label = builder;
            }
            permGrpIcon.setImageDrawable(icon);
            permNameView.setText(label);
            this.setOnClickListener(this);
        }

        private final void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$onClick(View v) {
            if (this.mGroup != null && this.mPerm != null) {
                if (this.mDialog != null) {
                    this.mDialog.dismiss();
                }
                PackageManager pm = this.getContext().getPackageManager();
                AlertDialog.Builder builder = new AlertDialog.Builder(this.getContext());
                builder.setTitle(this.mGroup.mLabel);
                if (this.mPerm.descriptionRes != 0) {
                    builder.setMessage(this.mPerm.loadDescription(pm));
                } else {
                    CharSequence appName;
                    try {
                        ApplicationInfo app = pm.getApplicationInfo(this.mPerm.packageName, 0);
                        appName = app.loadLabel(pm);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        appName = this.mPerm.packageName;
                    }
                    StringBuilder sbuilder = new StringBuilder(128);
                    sbuilder.append(this.getContext().getString(17040591, appName));
                    sbuilder.append("\n\n");
                    sbuilder.append(this.mPerm.name);
                    builder.setMessage(sbuilder.toString());
                }
                builder.setCancelable(true);
                builder.setIcon(this.mGroup.loadGroupIcon(this.getContext(), pm));
                this.addRevokeUIIfNecessary(builder);
                this.mDialog = builder.show();
                this.mDialog.setCanceledOnTouchOutside(true);
            }
        }

        private final void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$onDetachedFromWindow() {
            super.onDetachedFromWindow();
            if (this.mDialog != null) {
                this.mDialog.dismiss();
            }
        }

        private final void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$addRevokeUIIfNecessary(AlertDialog.Builder builder) {
            boolean isRequired;
            if (!this.mShowRevokeUI) {
                return;
            }
            boolean bl = isRequired = (this.mPerm.mExistingReqFlags & 1) != 0;
            if (isRequired) {
                return;
            }
            DialogInterface.OnClickListener ocl = new DialogInterface.OnClickListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ PermissionItemView this$0;

                private void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView_1$__constructor__(PermissionItemView this$0) {
                }

                private final void $$robo$$android_widget_AppSecurityPermissions_PermissionItemView_1$onClick(DialogInterface dialog, int which) {
                    PackageManager pm = this.this$0.getContext().getPackageManager();
                    pm.revokeRuntimePermission(this.this$0.mPackageName, this.this$0.mPerm.name, new UserHandle(this.this$0.mContext.getUserId()));
                    this.this$0.setVisibility(8);
                }

                private void __constructor__(PermissionItemView permissionItemView) {
                    this.$$robo$$android_widget_AppSecurityPermissions_PermissionItemView_1$__constructor__(permissionItemView);
                }
                {
                    this.this$0 = permissionItemView;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView_1$__constructor__(android.widget.AppSecurityPermissions$PermissionItemView ), 0, this, permissionItemView);
                }

                @Override
                public void onClick(DialogInterface dialogInterface, int n) {
                    InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView_1$onClick(android.content.DialogInterface int ), 0, this, dialogInterface, n);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
            builder.setNegativeButton(17040701, ocl);
            builder.setPositiveButton(17039370, null);
        }

        private void __constructor__(Context context, AttributeSet attributeSet) {
            this.$$robo$$android_widget_AppSecurityPermissions_PermissionItemView$__constructor__(context, attributeSet);
        }

        public PermissionItemView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
        }

        public void setPermission(MyPermissionGroupInfo myPermissionGroupInfo, MyPermissionInfo myPermissionInfo, boolean bl, CharSequence charSequence, String string2, boolean bl2) {
            InvokeDynamicSupport.bootstrap("setPermission", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$setPermission(android.widget.AppSecurityPermissions$MyPermissionGroupInfo android.widget.AppSecurityPermissions$MyPermissionInfo boolean java.lang.CharSequence java.lang.String boolean ), 0, this, myPermissionGroupInfo, myPermissionInfo, bl, charSequence, string2, bl2);
        }

        @Override
        public void onClick(View view) {
            InvokeDynamicSupport.bootstrap("onClick", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$onClick(android.view.View ), 0, this, view);
        }

        @Override
        protected void onDetachedFromWindow() {
            InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$onDetachedFromWindow(), 0, this);
        }

        private void addRevokeUIIfNecessary(AlertDialog.Builder builder) {
            InvokeDynamicSupport.bootstrap("addRevokeUIIfNecessary", $$robo$$android_widget_AppSecurityPermissions_PermissionItemView$addRevokeUIIfNecessary(android.app.AlertDialog$Builder ), 0, this, builder);
        }

        public /* synthetic */ PermissionItemView() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PermissionItemView)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class MyPermissionInfo
    extends PermissionInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CharSequence mLabel;
        int mNewReqFlags;
        int mExistingReqFlags;
        boolean mNew;

        private void $$robo$$android_widget_AppSecurityPermissions_MyPermissionInfo$__constructor__(PermissionInfo info) {
        }

        private void __constructor__(PermissionInfo permissionInfo) {
            this.$$robo$$android_widget_AppSecurityPermissions_MyPermissionInfo$__constructor__(permissionInfo);
        }

        MyPermissionInfo(PermissionInfo permissionInfo) {
            super(permissionInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_MyPermissionInfo$__constructor__(android.content.pm.PermissionInfo ), 0, this, permissionInfo);
        }

        public /* synthetic */ MyPermissionInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyPermissionInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class MyPermissionGroupInfo
    extends PermissionGroupInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        CharSequence mLabel;
        ArrayList<MyPermissionInfo> mNewPermissions;
        ArrayList<MyPermissionInfo> mAllPermissions;

        private void $$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$__constructor__(PermissionInfo perm) {
            this.mNewPermissions = new ArrayList();
            this.mAllPermissions = new ArrayList();
            this.name = perm.packageName;
            this.packageName = perm.packageName;
        }

        private void $$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$__constructor__(PermissionGroupInfo info) {
            this.mNewPermissions = new ArrayList();
            this.mAllPermissions = new ArrayList();
        }

        private final Drawable $$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$loadGroupIcon(Context context, PackageManager pm) {
            if (this.icon != 0) {
                return this.loadUnbadgedIcon(pm);
            }
            return context.getDrawable(17302555);
        }

        private void __constructor__(PermissionInfo permissionInfo) {
            this.$$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$__constructor__(permissionInfo);
        }

        MyPermissionGroupInfo(PermissionInfo permissionInfo) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$__constructor__(android.content.pm.PermissionInfo ), 0, this, permissionInfo);
        }

        private void __constructor__(PermissionGroupInfo permissionGroupInfo) {
            this.$$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$__constructor__(permissionGroupInfo);
        }

        MyPermissionGroupInfo(PermissionGroupInfo permissionGroupInfo) {
            super(permissionGroupInfo);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$__constructor__(android.content.pm.PermissionGroupInfo ), 0, this, permissionGroupInfo);
        }

        public Drawable loadGroupIcon(Context context, PackageManager packageManager) {
            return InvokeDynamicSupport.bootstrap("loadGroupIcon", $$robo$$android_widget_AppSecurityPermissions_MyPermissionGroupInfo$loadGroupIcon(android.content.Context android.content.pm.PackageManager ), 0, this, context, packageManager);
        }

        public /* synthetic */ MyPermissionGroupInfo() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyPermissionGroupInfo)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

