/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.database.DataSetObserver;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.ContextMenu;
import android.view.RemotableViewMethod;
import android.view.View;
import android.view.ViewDebug;
import android.view.ViewGroup;
import android.view.ViewHierarchyEncoder;
import android.view.ViewStructure;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.autofill.AutofillManager;
import android.widget.Adapter;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AdapterView<T extends Adapter>
extends ViewGroup {
    public transient /* synthetic */ Object __robo_data__;
    public static int ITEM_VIEW_TYPE_IGNORE = -1;
    public static int ITEM_VIEW_TYPE_HEADER_OR_FOOTER = -2;
    @ViewDebug.ExportedProperty(category="scrolling")
    int mFirstPosition;
    int mSpecificTop;
    int mSyncPosition;
    long mSyncRowId;
    long mSyncHeight;
    boolean mNeedSync;
    int mSyncMode;
    private int mLayoutHeight;
    static int SYNC_SELECTED_POSITION = 0;
    static int SYNC_FIRST_POSITION = 1;
    static int SYNC_MAX_DURATION_MILLIS = 100;
    boolean mInLayout;
    OnItemSelectedListener mOnItemSelectedListener;
    OnItemClickListener mOnItemClickListener;
    OnItemLongClickListener mOnItemLongClickListener;
    boolean mDataChanged;
    @ViewDebug.ExportedProperty(category="list")
    int mNextSelectedPosition;
    long mNextSelectedRowId;
    @ViewDebug.ExportedProperty(category="list")
    int mSelectedPosition;
    long mSelectedRowId;
    private View mEmptyView;
    @ViewDebug.ExportedProperty(category="list")
    int mItemCount;
    int mOldItemCount;
    public static int INVALID_POSITION = -1;
    public static long INVALID_ROW_ID = Long.MIN_VALUE;
    int mOldSelectedPosition;
    long mOldSelectedRowId;
    private int mDesiredFocusableState;
    private boolean mDesiredFocusableInTouchModeState;
    private SelectionNotifier mSelectionNotifier;
    private SelectionNotifier mPendingSelectionNotifier;
    boolean mBlockLayoutRequests;

    private void $$robo$$android_widget_AdapterView$__constructor__(Context context) {
    }

    private void $$robo$$android_widget_AdapterView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_AdapterView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AdapterView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mFirstPosition = 0;
        this.mSyncRowId = Long.MIN_VALUE;
        this.mNeedSync = false;
        this.mInLayout = false;
        this.mNextSelectedPosition = -1;
        this.mNextSelectedRowId = Long.MIN_VALUE;
        this.mSelectedPosition = -1;
        this.mSelectedRowId = Long.MIN_VALUE;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.mDesiredFocusableState = 16;
        this.mBlockLayoutRequests = false;
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
        this.mDesiredFocusableState = this.getFocusable();
        if (this.mDesiredFocusableState == 16) {
            super.setFocusable(0);
        }
    }

    private final void $$robo$$android_widget_AdapterView$setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    private final OnItemClickListener $$robo$$android_widget_AdapterView$getOnItemClickListener() {
        return this.mOnItemClickListener;
    }

    private final boolean $$robo$$android_widget_AdapterView$performItemClick(View view, int position, long id2) {
        boolean result;
        if (this.mOnItemClickListener != null) {
            this.playSoundEffect(0);
            this.mOnItemClickListener.onItemClick(this, view, position, id2);
            result = true;
        } else {
            result = false;
        }
        if (view != null) {
            view.sendAccessibilityEvent(1);
        }
        return result;
    }

    private final void $$robo$$android_widget_AdapterView$setOnItemLongClickListener(OnItemLongClickListener listener) {
        if (!this.isLongClickable()) {
            this.setLongClickable(true);
        }
        this.mOnItemLongClickListener = listener;
    }

    private final OnItemLongClickListener $$robo$$android_widget_AdapterView$getOnItemLongClickListener() {
        return this.mOnItemLongClickListener;
    }

    private final void $$robo$$android_widget_AdapterView$setOnItemSelectedListener(OnItemSelectedListener listener) {
        this.mOnItemSelectedListener = listener;
    }

    private final OnItemSelectedListener $$robo$$android_widget_AdapterView$getOnItemSelectedListener() {
        return this.mOnItemSelectedListener;
    }

    public abstract T getAdapter();

    public abstract void setAdapter(T var1);

    private final void $$robo$$android_widget_AdapterView$addView(View child) {
        throw new UnsupportedOperationException("addView(View) is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$addView(View child, int index) {
        throw new UnsupportedOperationException("addView(View, int) is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$addView(View child, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("addView(View, LayoutParams) is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$addView(View child, int index, ViewGroup.LayoutParams params) {
        throw new UnsupportedOperationException("addView(View, int, LayoutParams) is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$removeView(View child) {
        throw new UnsupportedOperationException("removeView(View) is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$removeViewAt(int index) {
        throw new UnsupportedOperationException("removeViewAt(int) is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$removeAllViews() {
        throw new UnsupportedOperationException("removeAllViews() is not supported in AdapterView");
    }

    private final void $$robo$$android_widget_AdapterView$onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mLayoutHeight = this.getHeight();
    }

    @ViewDebug.CapturedViewProperty
    private final int $$robo$$android_widget_AdapterView$getSelectedItemPosition() {
        return this.mNextSelectedPosition;
    }

    @ViewDebug.CapturedViewProperty
    private final long $$robo$$android_widget_AdapterView$getSelectedItemId() {
        return this.mNextSelectedRowId;
    }

    public abstract View getSelectedView();

    private final Object $$robo$$android_widget_AdapterView$getSelectedItem() {
        T adapter = this.getAdapter();
        int selection = this.getSelectedItemPosition();
        if (adapter != null && adapter.getCount() > 0 && selection >= 0) {
            return adapter.getItem(selection);
        }
        return null;
    }

    @ViewDebug.CapturedViewProperty
    private final int $$robo$$android_widget_AdapterView$getCount() {
        return this.mItemCount;
    }

    private final int $$robo$$android_widget_AdapterView$getPositionForView(View view) {
        View listItem = view;
        try {
            View v;
            while ((v = (View)((Object)listItem.getParent())) != null && !v.equals(this)) {
                listItem = v;
            }
        }
        catch (ClassCastException e) {
            return -1;
        }
        if (listItem != null) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                if (!this.getChildAt(i).equals(listItem)) continue;
                return this.mFirstPosition + i;
            }
        }
        return -1;
    }

    private final int $$robo$$android_widget_AdapterView$getFirstVisiblePosition() {
        return this.mFirstPosition;
    }

    private final int $$robo$$android_widget_AdapterView$getLastVisiblePosition() {
        return this.mFirstPosition + this.getChildCount() - 1;
    }

    public abstract void setSelection(int var1);

    @RemotableViewMethod
    private final void $$robo$$android_widget_AdapterView$setEmptyView(View emptyView) {
        T adapter;
        this.mEmptyView = emptyView;
        if (emptyView != null && emptyView.getImportantForAccessibility() == 0) {
            emptyView.setImportantForAccessibility(1);
        }
        boolean empty = (adapter = this.getAdapter()) == null || adapter.isEmpty();
        this.updateEmptyStatus(empty);
    }

    private final View $$robo$$android_widget_AdapterView$getEmptyView() {
        return this.mEmptyView;
    }

    private final boolean $$robo$$android_widget_AdapterView$isInFilterMode() {
        return false;
    }

    private final void $$robo$$android_widget_AdapterView$setFocusable(int focusable) {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        this.mDesiredFocusableState = focusable;
        if ((focusable & 0x11) == 0) {
            this.mDesiredFocusableInTouchModeState = false;
        }
        super.setFocusable(!empty || this.isInFilterMode() ? focusable : 0);
    }

    private final void $$robo$$android_widget_AdapterView$setFocusableInTouchMode(boolean focusable) {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        this.mDesiredFocusableInTouchModeState = focusable;
        if (focusable) {
            this.mDesiredFocusableState = 1;
        }
        super.setFocusableInTouchMode(focusable && (!empty || this.isInFilterMode()));
    }

    private final void $$robo$$android_widget_AdapterView$checkFocus() {
        T adapter = this.getAdapter();
        boolean empty = adapter == null || adapter.getCount() == 0;
        boolean focusable = !empty || this.isInFilterMode();
        super.setFocusableInTouchMode(focusable && this.mDesiredFocusableInTouchModeState);
        super.setFocusable(focusable ? this.mDesiredFocusableState : 0);
        if (this.mEmptyView != null) {
            this.updateEmptyStatus(adapter == null || adapter.isEmpty());
        }
    }

    private final void $$robo$$android_widget_AdapterView$updateEmptyStatus(boolean empty) {
        if (this.isInFilterMode()) {
            empty = false;
        }
        if (empty) {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(0);
                this.setVisibility(8);
            } else {
                this.setVisibility(0);
            }
            if (this.mDataChanged) {
                this.onLayout(false, this.mLeft, this.mTop, this.mRight, this.mBottom);
            }
        } else {
            if (this.mEmptyView != null) {
                this.mEmptyView.setVisibility(8);
            }
            this.setVisibility(0);
        }
    }

    private final Object $$robo$$android_widget_AdapterView$getItemAtPosition(int position) {
        T adapter = this.getAdapter();
        return adapter == null || position < 0 ? null : adapter.getItem(position);
    }

    private final long $$robo$$android_widget_AdapterView$getItemIdAtPosition(int position) {
        T adapter = this.getAdapter();
        return adapter == null || position < 0 ? Long.MIN_VALUE : adapter.getItemId(position);
    }

    private final void $$robo$$android_widget_AdapterView$setOnClickListener(View.OnClickListener l) {
        throw new RuntimeException("Don't call setOnClickListener for an AdapterView. You probably want setOnItemClickListener instead");
    }

    private final void $$robo$$android_widget_AdapterView$dispatchSaveInstanceState(SparseArray<Parcelable> container) {
        this.dispatchFreezeSelfOnly(container);
    }

    private final void $$robo$$android_widget_AdapterView$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        this.dispatchThawSelfOnly(container);
    }

    private final void $$robo$$android_widget_AdapterView$onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeCallbacks(this.mSelectionNotifier);
    }

    private final void $$robo$$android_widget_AdapterView$selectionChanged() {
        AutofillManager afm;
        this.mPendingSelectionNotifier = null;
        if (this.mOnItemSelectedListener != null || AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            if (this.mInLayout || this.mBlockLayoutRequests) {
                if (this.mSelectionNotifier == null) {
                    this.mSelectionNotifier = new SelectionNotifier(this);
                } else {
                    this.removeCallbacks(this.mSelectionNotifier);
                }
                this.post(this.mSelectionNotifier);
            } else {
                this.dispatchOnItemSelected();
            }
        }
        if ((afm = this.mContext.getSystemService(AutofillManager.class)) != null) {
            afm.notifyValueChanged(this);
        }
    }

    private final void $$robo$$android_widget_AdapterView$dispatchOnItemSelected() {
        this.fireOnSelected();
        this.performAccessibilityActionsOnSelected();
    }

    private final void $$robo$$android_widget_AdapterView$fireOnSelected() {
        if (this.mOnItemSelectedListener == null) {
            return;
        }
        int selection = this.getSelectedItemPosition();
        if (selection >= 0) {
            View v = this.getSelectedView();
            this.mOnItemSelectedListener.onItemSelected(this, v, selection, this.getAdapter().getItemId(selection));
        } else {
            this.mOnItemSelectedListener.onNothingSelected(this);
        }
    }

    private final void $$robo$$android_widget_AdapterView$performAccessibilityActionsOnSelected() {
        if (!AccessibilityManager.getInstance(this.mContext).isEnabled()) {
            return;
        }
        int position = this.getSelectedItemPosition();
        if (position >= 0) {
            this.sendAccessibilityEvent(4);
        }
    }

    private final boolean $$robo$$android_widget_AdapterView$dispatchPopulateAccessibilityEventInternal(AccessibilityEvent event) {
        View selectedView = this.getSelectedView();
        return selectedView != null && selectedView.getVisibility() == 0 && selectedView.dispatchPopulateAccessibilityEvent(event);
    }

    private final boolean $$robo$$android_widget_AdapterView$onRequestSendAccessibilityEventInternal(View child, AccessibilityEvent event) {
        if (super.onRequestSendAccessibilityEventInternal(child, event)) {
            AccessibilityEvent record = AccessibilityEvent.obtain();
            this.onInitializeAccessibilityEvent(record);
            child.dispatchPopulateAccessibilityEvent(record);
            event.appendRecord(record);
            return true;
        }
        return false;
    }

    private final CharSequence $$robo$$android_widget_AdapterView$getAccessibilityClassName() {
        return AdapterView.class.getName();
    }

    private final void $$robo$$android_widget_AdapterView$onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfoInternal(info);
        info.setScrollable(this.isScrollableForAccessibility());
        View selectedView = this.getSelectedView();
        if (selectedView != null) {
            info.setEnabled(selectedView.isEnabled());
        }
    }

    private final void $$robo$$android_widget_AdapterView$onInitializeAccessibilityEventInternal(AccessibilityEvent event) {
        super.onInitializeAccessibilityEventInternal(event);
        event.setScrollable(this.isScrollableForAccessibility());
        View selectedView = this.getSelectedView();
        if (selectedView != null) {
            event.setEnabled(selectedView.isEnabled());
        }
        event.setCurrentItemIndex(this.getSelectedItemPosition());
        event.setFromIndex(this.getFirstVisiblePosition());
        event.setToIndex(this.getLastVisiblePosition());
        event.setItemCount(this.getCount());
    }

    private final boolean $$robo$$android_widget_AdapterView$isScrollableForAccessibility() {
        T adapter = this.getAdapter();
        if (adapter != null) {
            int itemCount = adapter.getCount();
            return itemCount > 0 && (this.getFirstVisiblePosition() > 0 || this.getLastVisiblePosition() < itemCount - 1);
        }
        return false;
    }

    private final boolean $$robo$$android_widget_AdapterView$canAnimate() {
        return super.canAnimate() && this.mItemCount > 0;
    }

    private final void $$robo$$android_widget_AdapterView$handleDataChanged() {
        int count = this.mItemCount;
        boolean found = false;
        if (count > 0) {
            int selectablePos;
            int newPos;
            if (this.mNeedSync) {
                this.mNeedSync = false;
                newPos = this.findSyncPosition();
                if (newPos >= 0 && (selectablePos = this.lookForSelectablePosition(newPos, true)) == newPos) {
                    this.setNextSelectedPositionInt(newPos);
                    found = true;
                }
            }
            if (!found) {
                newPos = this.getSelectedItemPosition();
                if (newPos >= count) {
                    newPos = count - 1;
                }
                if (newPos < 0) {
                    newPos = 0;
                }
                if ((selectablePos = this.lookForSelectablePosition(newPos, true)) < 0) {
                    selectablePos = this.lookForSelectablePosition(newPos, false);
                }
                if (selectablePos >= 0) {
                    this.setNextSelectedPositionInt(selectablePos);
                    this.checkSelectionChanged();
                    found = true;
                }
            }
        }
        if (!found) {
            this.mSelectedPosition = -1;
            this.mSelectedRowId = Long.MIN_VALUE;
            this.mNextSelectedPosition = -1;
            this.mNextSelectedRowId = Long.MIN_VALUE;
            this.mNeedSync = false;
            this.checkSelectionChanged();
        }
        this.notifySubtreeAccessibilityStateChangedIfNeeded();
    }

    private final void $$robo$$android_widget_AdapterView$checkSelectionChanged() {
        if (this.mSelectedPosition != this.mOldSelectedPosition || this.mSelectedRowId != this.mOldSelectedRowId) {
            this.selectionChanged();
            this.mOldSelectedPosition = this.mSelectedPosition;
            this.mOldSelectedRowId = this.mSelectedRowId;
        }
        if (this.mPendingSelectionNotifier != null) {
            this.mPendingSelectionNotifier.run();
        }
    }

    private final int $$robo$$android_widget_AdapterView$findSyncPosition() {
        int count = this.mItemCount;
        if (count == 0) {
            return -1;
        }
        long idToMatch = this.mSyncRowId;
        int seed = this.mSyncPosition;
        if (idToMatch == Long.MIN_VALUE) {
            return -1;
        }
        seed = Math.max(0, seed);
        seed = Math.min(count - 1, seed);
        long endTime = SystemClock.uptimeMillis() + 100L;
        int first = seed;
        int last = seed;
        boolean next = false;
        T adapter = this.getAdapter();
        if (adapter == null) {
            return -1;
        }
        while (SystemClock.uptimeMillis() <= endTime) {
            boolean hitFirst;
            long rowId = adapter.getItemId(seed);
            if (rowId == idToMatch) {
                return seed;
            }
            boolean hitLast = last == count - 1;
            boolean bl = hitFirst = first == 0;
            if (hitLast && hitFirst) break;
            if (hitFirst || next && !hitLast) {
                seed = ++last;
                next = false;
                continue;
            }
            if (!hitLast && (next || hitFirst)) continue;
            seed = --first;
            next = true;
        }
        return -1;
    }

    private final int $$robo$$android_widget_AdapterView$lookForSelectablePosition(int position, boolean lookDown) {
        return position;
    }

    private final void $$robo$$android_widget_AdapterView$setSelectedPositionInt(int position) {
        this.mSelectedPosition = position;
        this.mSelectedRowId = this.getItemIdAtPosition(position);
    }

    private final void $$robo$$android_widget_AdapterView$setNextSelectedPositionInt(int position) {
        this.mNextSelectedPosition = position;
        this.mNextSelectedRowId = this.getItemIdAtPosition(position);
        if (this.mNeedSync && this.mSyncMode == 0 && position >= 0) {
            this.mSyncPosition = position;
            this.mSyncRowId = this.mNextSelectedRowId;
        }
    }

    private final void $$robo$$android_widget_AdapterView$rememberSyncState() {
        if (this.getChildCount() > 0) {
            this.mNeedSync = true;
            this.mSyncHeight = this.mLayoutHeight;
            if (this.mSelectedPosition >= 0) {
                View v = this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
                this.mSyncRowId = this.mNextSelectedRowId;
                this.mSyncPosition = this.mNextSelectedPosition;
                if (v != null) {
                    this.mSpecificTop = v.getTop();
                }
                this.mSyncMode = 0;
            } else {
                View v = this.getChildAt(0);
                T adapter = this.getAdapter();
                this.mSyncRowId = this.mFirstPosition >= 0 && this.mFirstPosition < adapter.getCount() ? adapter.getItemId(this.mFirstPosition) : -1L;
                this.mSyncPosition = this.mFirstPosition;
                if (v != null) {
                    this.mSpecificTop = v.getTop();
                }
                this.mSyncMode = 1;
            }
        }
    }

    private final void $$robo$$android_widget_AdapterView$encodeProperties(ViewHierarchyEncoder encoder) {
        super.encodeProperties(encoder);
        encoder.addProperty("scrolling:firstPosition", this.mFirstPosition);
        encoder.addProperty("list:nextSelectedPosition", this.mNextSelectedPosition);
        encoder.addProperty("list:nextSelectedRowId", this.mNextSelectedRowId);
        encoder.addProperty("list:selectedPosition", this.mSelectedPosition);
        encoder.addProperty("list:itemCount", this.mItemCount);
    }

    private final void $$robo$$android_widget_AdapterView$onProvideAutofillStructure(ViewStructure structure, int flags) {
        super.onProvideAutofillStructure(structure, flags);
        T adapter = this.getAdapter();
        if (adapter == null) {
            return;
        }
        CharSequence[] options = adapter.getAutofillOptions();
        if (options != null) {
            structure.setAutofillOptions(options);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AdapterView$__constructor__(context);
    }

    public AdapterView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AdapterView$__constructor__(context, attributeSet);
    }

    public AdapterView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AdapterView$__constructor__(context, attributeSet, n);
    }

    public AdapterView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AdapterView$__constructor__(context, attributeSet, n, n2);
    }

    public AdapterView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public void setOnItemClickListener(OnItemClickListener onItemClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemClickListener", $$robo$$android_widget_AdapterView$setOnItemClickListener(android.widget.AdapterView$OnItemClickListener ), 0, this, onItemClickListener);
    }

    public OnItemClickListener getOnItemClickListener() {
        return InvokeDynamicSupport.bootstrap("getOnItemClickListener", $$robo$$android_widget_AdapterView$getOnItemClickListener(), 0, this);
    }

    public boolean performItemClick(View view, int n, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("performItemClick", $$robo$$android_widget_AdapterView$performItemClick(android.view.View int long ), 0, this, view, n, l);
    }

    public void setOnItemLongClickListener(OnItemLongClickListener onItemLongClickListener) {
        InvokeDynamicSupport.bootstrap("setOnItemLongClickListener", $$robo$$android_widget_AdapterView$setOnItemLongClickListener(android.widget.AdapterView$OnItemLongClickListener ), 0, this, onItemLongClickListener);
    }

    public OnItemLongClickListener getOnItemLongClickListener() {
        return InvokeDynamicSupport.bootstrap("getOnItemLongClickListener", $$robo$$android_widget_AdapterView$getOnItemLongClickListener(), 0, this);
    }

    public void setOnItemSelectedListener(OnItemSelectedListener onItemSelectedListener) {
        InvokeDynamicSupport.bootstrap("setOnItemSelectedListener", $$robo$$android_widget_AdapterView$setOnItemSelectedListener(android.widget.AdapterView$OnItemSelectedListener ), 0, this, onItemSelectedListener);
    }

    public OnItemSelectedListener getOnItemSelectedListener() {
        return InvokeDynamicSupport.bootstrap("getOnItemSelectedListener", $$robo$$android_widget_AdapterView$getOnItemSelectedListener(), 0, this);
    }

    @Override
    public void addView(View view) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_AdapterView$addView(android.view.View ), 0, this, view);
    }

    @Override
    public void addView(View view, int n) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_AdapterView$addView(android.view.View int ), 0, this, view, n);
    }

    @Override
    public void addView(View view, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_AdapterView$addView(android.view.View android.view.ViewGroup$LayoutParams ), 0, this, view, layoutParams);
    }

    @Override
    public void addView(View view, int n, ViewGroup.LayoutParams layoutParams) {
        InvokeDynamicSupport.bootstrap("addView", $$robo$$android_widget_AdapterView$addView(android.view.View int android.view.ViewGroup$LayoutParams ), 0, this, view, n, layoutParams);
    }

    @Override
    public void removeView(View view) {
        InvokeDynamicSupport.bootstrap("removeView", $$robo$$android_widget_AdapterView$removeView(android.view.View ), 0, this, view);
    }

    @Override
    public void removeViewAt(int n) {
        InvokeDynamicSupport.bootstrap("removeViewAt", $$robo$$android_widget_AdapterView$removeViewAt(int ), 0, this, n);
    }

    @Override
    public void removeAllViews() {
        InvokeDynamicSupport.bootstrap("removeAllViews", $$robo$$android_widget_AdapterView$removeAllViews(), 0, this);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onLayout", $$robo$$android_widget_AdapterView$onLayout(boolean int int int int ), 0, this, bl, n, n2, n3, n4);
    }

    @ViewDebug.CapturedViewProperty
    public int getSelectedItemPosition() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectedItemPosition", $$robo$$android_widget_AdapterView$getSelectedItemPosition(), 0, this);
    }

    @ViewDebug.CapturedViewProperty
    public long getSelectedItemId() {
        return (long)InvokeDynamicSupport.bootstrap("getSelectedItemId", $$robo$$android_widget_AdapterView$getSelectedItemId(), 0, this);
    }

    public Object getSelectedItem() {
        return InvokeDynamicSupport.bootstrap("getSelectedItem", $$robo$$android_widget_AdapterView$getSelectedItem(), 0, this);
    }

    @ViewDebug.CapturedViewProperty
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_AdapterView$getCount(), 0, this);
    }

    public int getPositionForView(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getPositionForView", $$robo$$android_widget_AdapterView$getPositionForView(android.view.View ), 0, this, view);
    }

    public int getFirstVisiblePosition() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstVisiblePosition", $$robo$$android_widget_AdapterView$getFirstVisiblePosition(), 0, this);
    }

    public int getLastVisiblePosition() {
        return (int)InvokeDynamicSupport.bootstrap("getLastVisiblePosition", $$robo$$android_widget_AdapterView$getLastVisiblePosition(), 0, this);
    }

    @RemotableViewMethod
    public void setEmptyView(View view) {
        InvokeDynamicSupport.bootstrap("setEmptyView", $$robo$$android_widget_AdapterView$setEmptyView(android.view.View ), 0, this, view);
    }

    public View getEmptyView() {
        return InvokeDynamicSupport.bootstrap("getEmptyView", $$robo$$android_widget_AdapterView$getEmptyView(), 0, this);
    }

    boolean isInFilterMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInFilterMode", $$robo$$android_widget_AdapterView$isInFilterMode(), 0, this);
    }

    @Override
    public void setFocusable(int n) {
        InvokeDynamicSupport.bootstrap("setFocusable", $$robo$$android_widget_AdapterView$setFocusable(int ), 0, this, n);
    }

    @Override
    public void setFocusableInTouchMode(boolean bl) {
        InvokeDynamicSupport.bootstrap("setFocusableInTouchMode", $$robo$$android_widget_AdapterView$setFocusableInTouchMode(boolean ), 0, this, bl);
    }

    void checkFocus() {
        InvokeDynamicSupport.bootstrap("checkFocus", $$robo$$android_widget_AdapterView$checkFocus(), 0, this);
    }

    private void updateEmptyStatus(boolean bl) {
        InvokeDynamicSupport.bootstrap("updateEmptyStatus", $$robo$$android_widget_AdapterView$updateEmptyStatus(boolean ), 0, this, bl);
    }

    public Object getItemAtPosition(int n) {
        return InvokeDynamicSupport.bootstrap("getItemAtPosition", $$robo$$android_widget_AdapterView$getItemAtPosition(int ), 0, this, n);
    }

    public long getItemIdAtPosition(int n) {
        return (long)InvokeDynamicSupport.bootstrap("getItemIdAtPosition", $$robo$$android_widget_AdapterView$getItemIdAtPosition(int ), 0, this, n);
    }

    @Override
    public void setOnClickListener(View.OnClickListener onClickListener) {
        InvokeDynamicSupport.bootstrap("setOnClickListener", $$robo$$android_widget_AdapterView$setOnClickListener(android.view.View$OnClickListener ), 0, this, onClickListener);
    }

    @Override
    protected void dispatchSaveInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchSaveInstanceState", $$robo$$android_widget_AdapterView$dispatchSaveInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_widget_AdapterView$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_widget_AdapterView$onDetachedFromWindow(), 0, this);
    }

    void selectionChanged() {
        InvokeDynamicSupport.bootstrap("selectionChanged", $$robo$$android_widget_AdapterView$selectionChanged(), 0, this);
    }

    private void dispatchOnItemSelected() {
        InvokeDynamicSupport.bootstrap("dispatchOnItemSelected", $$robo$$android_widget_AdapterView$dispatchOnItemSelected(), 0, this);
    }

    private void fireOnSelected() {
        InvokeDynamicSupport.bootstrap("fireOnSelected", $$robo$$android_widget_AdapterView$fireOnSelected(), 0, this);
    }

    private void performAccessibilityActionsOnSelected() {
        InvokeDynamicSupport.bootstrap("performAccessibilityActionsOnSelected", $$robo$$android_widget_AdapterView$performAccessibilityActionsOnSelected(), 0, this);
    }

    @Override
    public boolean dispatchPopulateAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("dispatchPopulateAccessibilityEventInternal", $$robo$$android_widget_AdapterView$dispatchPopulateAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    @Override
    public boolean onRequestSendAccessibilityEventInternal(View view, AccessibilityEvent accessibilityEvent) {
        return (boolean)InvokeDynamicSupport.bootstrap("onRequestSendAccessibilityEventInternal", $$robo$$android_widget_AdapterView$onRequestSendAccessibilityEventInternal(android.view.View android.view.accessibility.AccessibilityEvent ), 0, this, view, accessibilityEvent);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_AdapterView$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void onInitializeAccessibilityNodeInfoInternal(AccessibilityNodeInfo accessibilityNodeInfo) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityNodeInfoInternal", $$robo$$android_widget_AdapterView$onInitializeAccessibilityNodeInfoInternal(android.view.accessibility.AccessibilityNodeInfo ), 0, this, accessibilityNodeInfo);
    }

    @Override
    public void onInitializeAccessibilityEventInternal(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onInitializeAccessibilityEventInternal", $$robo$$android_widget_AdapterView$onInitializeAccessibilityEventInternal(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private boolean isScrollableForAccessibility() {
        return (boolean)InvokeDynamicSupport.bootstrap("isScrollableForAccessibility", $$robo$$android_widget_AdapterView$isScrollableForAccessibility(), 0, this);
    }

    @Override
    protected boolean canAnimate() {
        return (boolean)InvokeDynamicSupport.bootstrap("canAnimate", $$robo$$android_widget_AdapterView$canAnimate(), 0, this);
    }

    void handleDataChanged() {
        InvokeDynamicSupport.bootstrap("handleDataChanged", $$robo$$android_widget_AdapterView$handleDataChanged(), 0, this);
    }

    void checkSelectionChanged() {
        InvokeDynamicSupport.bootstrap("checkSelectionChanged", $$robo$$android_widget_AdapterView$checkSelectionChanged(), 0, this);
    }

    int findSyncPosition() {
        return (int)InvokeDynamicSupport.bootstrap("findSyncPosition", $$robo$$android_widget_AdapterView$findSyncPosition(), 0, this);
    }

    int lookForSelectablePosition(int n, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("lookForSelectablePosition", $$robo$$android_widget_AdapterView$lookForSelectablePosition(int boolean ), 0, this, n, bl);
    }

    void setSelectedPositionInt(int n) {
        InvokeDynamicSupport.bootstrap("setSelectedPositionInt", $$robo$$android_widget_AdapterView$setSelectedPositionInt(int ), 0, this, n);
    }

    void setNextSelectedPositionInt(int n) {
        InvokeDynamicSupport.bootstrap("setNextSelectedPositionInt", $$robo$$android_widget_AdapterView$setNextSelectedPositionInt(int ), 0, this, n);
    }

    void rememberSyncState() {
        InvokeDynamicSupport.bootstrap("rememberSyncState", $$robo$$android_widget_AdapterView$rememberSyncState(), 0, this);
    }

    @Override
    protected void encodeProperties(ViewHierarchyEncoder viewHierarchyEncoder) {
        InvokeDynamicSupport.bootstrap("encodeProperties", $$robo$$android_widget_AdapterView$encodeProperties(android.view.ViewHierarchyEncoder ), 0, this, viewHierarchyEncoder);
    }

    @Override
    public void onProvideAutofillStructure(ViewStructure viewStructure, int n) {
        InvokeDynamicSupport.bootstrap("onProvideAutofillStructure", $$robo$$android_widget_AdapterView$onProvideAutofillStructure(android.view.ViewStructure int ), 0, this, viewStructure, n);
    }

    public /* synthetic */ AdapterView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private class SelectionNotifier
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ AdapterView this$0;

        private void $$robo$$android_widget_AdapterView_SelectionNotifier$__constructor__(AdapterView adapterView) {
        }

        private final void $$robo$$android_widget_AdapterView_SelectionNotifier$run() {
            this.this$0.mPendingSelectionNotifier = null;
            if (this.this$0.mDataChanged && this.this$0.getViewRootImpl() != null && this.this$0.getViewRootImpl().isLayoutRequested()) {
                if (this.this$0.getAdapter() != null) {
                    this.this$0.mPendingSelectionNotifier = this;
                }
            } else {
                this.this$0.dispatchOnItemSelected();
            }
        }

        private /* synthetic */ void $$robo$$android_widget_AdapterView_SelectionNotifier$__constructor__(AdapterView x0, 1 x1) {
        }

        private void __constructor__(AdapterView adapterView) {
            this.$$robo$$android_widget_AdapterView_SelectionNotifier$__constructor__(adapterView);
        }

        private SelectionNotifier(AdapterView adapterView) {
            this.this$0 = adapterView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView_SelectionNotifier$__constructor__(android.widget.AdapterView ), 0, this, adapterView);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_widget_AdapterView_SelectionNotifier$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(AdapterView adapterView, 1 var2_2) {
            this.$$robo$$android_widget_AdapterView_SelectionNotifier$__constructor__(adapterView, var2_2);
        }

        public /* synthetic */ SelectionNotifier() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SelectionNotifier)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public class AdapterDataSetObserver
    extends DataSetObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Parcelable mInstanceState;
        /* synthetic */ AdapterView this$0;

        private void $$robo$$android_widget_AdapterView_AdapterDataSetObserver$__constructor__(AdapterView this$0) {
            this.mInstanceState = null;
        }

        private final void $$robo$$android_widget_AdapterView_AdapterDataSetObserver$onChanged() {
            this.this$0.mDataChanged = true;
            this.this$0.mOldItemCount = this.this$0.mItemCount;
            this.this$0.mItemCount = this.this$0.getAdapter().getCount();
            if (this.this$0.getAdapter().hasStableIds() && this.mInstanceState != null && this.this$0.mOldItemCount == 0 && this.this$0.mItemCount > 0) {
                this.this$0.onRestoreInstanceState(this.mInstanceState);
                this.mInstanceState = null;
            } else {
                this.this$0.rememberSyncState();
            }
            this.this$0.checkFocus();
            this.this$0.requestLayout();
        }

        private final void $$robo$$android_widget_AdapterView_AdapterDataSetObserver$onInvalidated() {
            this.this$0.mDataChanged = true;
            if (this.this$0.getAdapter().hasStableIds()) {
                this.mInstanceState = this.this$0.onSaveInstanceState();
            }
            this.this$0.mOldItemCount = this.this$0.mItemCount;
            this.this$0.mItemCount = 0;
            this.this$0.mSelectedPosition = -1;
            this.this$0.mSelectedRowId = Long.MIN_VALUE;
            this.this$0.mNextSelectedPosition = -1;
            this.this$0.mNextSelectedRowId = Long.MIN_VALUE;
            this.this$0.mNeedSync = false;
            this.this$0.checkFocus();
            this.this$0.requestLayout();
        }

        private final void $$robo$$android_widget_AdapterView_AdapterDataSetObserver$clearSavedState() {
            this.mInstanceState = null;
        }

        private void __constructor__(AdapterView adapterView) {
            this.$$robo$$android_widget_AdapterView_AdapterDataSetObserver$__constructor__(adapterView);
        }

        AdapterDataSetObserver(AdapterView adapterView) {
            this.this$0 = adapterView;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView_AdapterDataSetObserver$__constructor__(android.widget.AdapterView ), 0, this, adapterView);
        }

        @Override
        public void onChanged() {
            InvokeDynamicSupport.bootstrap("onChanged", $$robo$$android_widget_AdapterView_AdapterDataSetObserver$onChanged(), 0, this);
        }

        @Override
        public void onInvalidated() {
            InvokeDynamicSupport.bootstrap("onInvalidated", $$robo$$android_widget_AdapterView_AdapterDataSetObserver$onInvalidated(), 0, this);
        }

        public void clearSavedState() {
            InvokeDynamicSupport.bootstrap("clearSavedState", $$robo$$android_widget_AdapterView_AdapterDataSetObserver$clearSavedState(), 0, this);
        }

        public /* synthetic */ AdapterDataSetObserver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterDataSetObserver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class AdapterContextMenuInfo
    implements ContextMenu.ContextMenuInfo,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public View targetView;
        public int position;
        public long id;

        private void $$robo$$android_widget_AdapterView_AdapterContextMenuInfo$__constructor__(View targetView, int position, long id2) {
            this.targetView = targetView;
            this.position = position;
            this.id = id2;
        }

        private void __constructor__(View view, int n, long l) {
            this.$$robo$$android_widget_AdapterView_AdapterContextMenuInfo$__constructor__(view, n, l);
        }

        public AdapterContextMenuInfo(View view, int n, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AdapterView_AdapterContextMenuInfo$__constructor__(android.view.View int long ), 0, this, view, n, l);
        }

        public /* synthetic */ AdapterContextMenuInfo() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AdapterContextMenuInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnItemSelectedListener
    extends InstrumentedInterface {
        public void onItemSelected(AdapterView<?> var1, View var2, int var3, long var4);

        public void onNothingSelected(AdapterView<?> var1);
    }

    public static interface OnItemLongClickListener
    extends InstrumentedInterface {
        public boolean onItemLongClick(AdapterView<?> var1, View var2, int var3, long var4);
    }

    public static interface OnItemClickListener
    extends InstrumentedInterface {
        public void onItemClick(AdapterView<?> var1, View var2, int var3, long var4);
    }
}

