/*
 * Decompiled with CFR 0.152.
 */
package android.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.autofill.AutofillValue;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.SpinnerAdapter;
import com.android.internal.R;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AbsSpinner
extends AdapterView<SpinnerAdapter> {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG;
    SpinnerAdapter mAdapter;
    int mHeightMeasureSpec;
    int mWidthMeasureSpec;
    int mSelectionLeftPadding;
    int mSelectionTopPadding;
    int mSelectionRightPadding;
    int mSelectionBottomPadding;
    Rect mSpinnerPadding;
    RecycleBin mRecycler;
    private DataSetObserver mDataSetObserver;
    private Rect mTouchFrame;

    private void $$robo$$android_widget_AbsSpinner$__constructor__(Context context) {
        this.mSelectionLeftPadding = 0;
        this.mSelectionTopPadding = 0;
        this.mSelectionRightPadding = 0;
        this.mSelectionBottomPadding = 0;
        this.mSpinnerPadding = new Rect();
        this.mRecycler = new RecycleBin(this);
        this.initAbsSpinner();
    }

    private void $$robo$$android_widget_AbsSpinner$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_widget_AbsSpinner$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_widget_AbsSpinner$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mSelectionLeftPadding = 0;
        this.mSelectionTopPadding = 0;
        this.mSelectionRightPadding = 0;
        this.mSelectionBottomPadding = 0;
        this.mSpinnerPadding = new Rect();
        this.mRecycler = new RecycleBin(this);
        if (this.getImportantForAutofill() == 0) {
            this.setImportantForAutofill(1);
        }
        this.initAbsSpinner();
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.AbsSpinner, defStyleAttr, defStyleRes);
        CharSequence[] entries = a.getTextArray(0);
        if (entries != null) {
            ArrayAdapter<CharSequence> adapter = new ArrayAdapter<CharSequence>(context, 17367048, entries);
            adapter.setDropDownViewResource(0x1090009);
            this.setAdapter(adapter);
        }
        a.recycle();
    }

    private final void $$robo$$android_widget_AbsSpinner$initAbsSpinner() {
        this.setFocusable(true);
        this.setWillNotDraw(false);
    }

    private final void $$robo$$android_widget_AbsSpinner$setAdapter(SpinnerAdapter adapter) {
        if (null != this.mAdapter) {
            this.mAdapter.unregisterDataSetObserver(this.mDataSetObserver);
            this.resetList();
        }
        this.mAdapter = adapter;
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        if (this.mAdapter != null) {
            this.mOldItemCount = this.mItemCount;
            this.mItemCount = this.mAdapter.getCount();
            this.checkFocus();
            this.mDataSetObserver = new AdapterView.AdapterDataSetObserver(this);
            this.mAdapter.registerDataSetObserver(this.mDataSetObserver);
            int position = this.mItemCount > 0 ? 0 : -1;
            this.setSelectedPositionInt(position);
            this.setNextSelectedPositionInt(position);
            if (this.mItemCount == 0) {
                this.checkSelectionChanged();
            }
        } else {
            this.checkFocus();
            this.resetList();
            this.checkSelectionChanged();
        }
        this.requestLayout();
    }

    private final void $$robo$$android_widget_AbsSpinner$resetList() {
        this.mDataChanged = false;
        this.mNeedSync = false;
        this.removeAllViewsInLayout();
        this.mOldSelectedPosition = -1;
        this.mOldSelectedRowId = Long.MIN_VALUE;
        this.setSelectedPositionInt(-1);
        this.setNextSelectedPositionInt(-1);
        this.invalidate();
    }

    private final void $$robo$$android_widget_AbsSpinner$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int widthMode = View.MeasureSpec.getMode(widthMeasureSpec);
        this.mSpinnerPadding.left = this.mPaddingLeft > this.mSelectionLeftPadding ? this.mPaddingLeft : this.mSelectionLeftPadding;
        this.mSpinnerPadding.top = this.mPaddingTop > this.mSelectionTopPadding ? this.mPaddingTop : this.mSelectionTopPadding;
        this.mSpinnerPadding.right = this.mPaddingRight > this.mSelectionRightPadding ? this.mPaddingRight : this.mSelectionRightPadding;
        int n = this.mSpinnerPadding.bottom = this.mPaddingBottom > this.mSelectionBottomPadding ? this.mPaddingBottom : this.mSelectionBottomPadding;
        if (this.mDataChanged) {
            this.handleDataChanged();
        }
        int preferredHeight = 0;
        int preferredWidth = 0;
        boolean needsMeasuring = true;
        int selectedPosition = this.getSelectedItemPosition();
        if (selectedPosition >= 0 && this.mAdapter != null && selectedPosition < this.mAdapter.getCount()) {
            View view = this.mRecycler.get(selectedPosition);
            if (view == null && (view = this.mAdapter.getView(selectedPosition, null, this)).getImportantForAccessibility() == 0) {
                view.setImportantForAccessibility(1);
            }
            if (view != null) {
                this.mRecycler.put(selectedPosition, view);
                if (view.getLayoutParams() == null) {
                    this.mBlockLayoutRequests = true;
                    view.setLayoutParams(this.generateDefaultLayoutParams());
                    this.mBlockLayoutRequests = false;
                }
                this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
                preferredHeight = this.getChildHeight(view) + this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
                preferredWidth = this.getChildWidth(view) + this.mSpinnerPadding.left + this.mSpinnerPadding.right;
                needsMeasuring = false;
            }
        }
        if (needsMeasuring) {
            preferredHeight = this.mSpinnerPadding.top + this.mSpinnerPadding.bottom;
            if (widthMode == 0) {
                preferredWidth = this.mSpinnerPadding.left + this.mSpinnerPadding.right;
            }
        }
        preferredHeight = Math.max(preferredHeight, this.getSuggestedMinimumHeight());
        preferredWidth = Math.max(preferredWidth, this.getSuggestedMinimumWidth());
        int heightSize = AbsSpinner.resolveSizeAndState(preferredHeight, heightMeasureSpec, 0);
        int widthSize = AbsSpinner.resolveSizeAndState(preferredWidth, widthMeasureSpec, 0);
        this.setMeasuredDimension(widthSize, heightSize);
        this.mHeightMeasureSpec = heightMeasureSpec;
        this.mWidthMeasureSpec = widthMeasureSpec;
    }

    private final int $$robo$$android_widget_AbsSpinner$getChildHeight(View child) {
        return child.getMeasuredHeight();
    }

    private final int $$robo$$android_widget_AbsSpinner$getChildWidth(View child) {
        return child.getMeasuredWidth();
    }

    private final ViewGroup.LayoutParams $$robo$$android_widget_AbsSpinner$generateDefaultLayoutParams() {
        return new ViewGroup.LayoutParams(-1, -2);
    }

    private final void $$robo$$android_widget_AbsSpinner$recycleAllViews() {
        int childCount = this.getChildCount();
        RecycleBin recycleBin = this.mRecycler;
        int position = this.mFirstPosition;
        for (int i = 0; i < childCount; ++i) {
            View v = this.getChildAt(i);
            int index = position + i;
            recycleBin.put(index, v);
        }
    }

    private final void $$robo$$android_widget_AbsSpinner$setSelection(int position, boolean animate) {
        boolean shouldAnimate = animate && this.mFirstPosition <= position && position <= this.mFirstPosition + this.getChildCount() - 1;
        this.setSelectionInt(position, shouldAnimate);
    }

    private final void $$robo$$android_widget_AbsSpinner$setSelection(int position) {
        this.setNextSelectedPositionInt(position);
        this.requestLayout();
        this.invalidate();
    }

    private final void $$robo$$android_widget_AbsSpinner$setSelectionInt(int position, boolean animate) {
        if (position != this.mOldSelectedPosition) {
            this.mBlockLayoutRequests = true;
            int delta = position - this.mSelectedPosition;
            this.setNextSelectedPositionInt(position);
            this.layout(delta, animate);
            this.mBlockLayoutRequests = false;
        }
    }

    abstract void layout(int var1, boolean var2);

    private final View $$robo$$android_widget_AbsSpinner$getSelectedView() {
        if (this.mItemCount > 0 && this.mSelectedPosition >= 0) {
            return this.getChildAt(this.mSelectedPosition - this.mFirstPosition);
        }
        return null;
    }

    private final void $$robo$$android_widget_AbsSpinner$requestLayout() {
        if (!this.mBlockLayoutRequests) {
            super.requestLayout();
        }
    }

    private final SpinnerAdapter $$robo$$android_widget_AbsSpinner$getAdapter() {
        return this.mAdapter;
    }

    private final int $$robo$$android_widget_AbsSpinner$getCount() {
        return this.mItemCount;
    }

    private final int $$robo$$android_widget_AbsSpinner$pointToPosition(int x, int y) {
        Rect frame = this.mTouchFrame;
        if (frame == null) {
            frame = this.mTouchFrame = new Rect();
        }
        int count = this.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0) continue;
            child.getHitRect(frame);
            if (!frame.contains(x, y)) continue;
            return this.mFirstPosition + i;
        }
        return -1;
    }

    private final void $$robo$$android_widget_AbsSpinner$dispatchRestoreInstanceState(SparseArray<Parcelable> container) {
        super.dispatchRestoreInstanceState(container);
        this.handleDataChanged();
    }

    private final Parcelable $$robo$$android_widget_AbsSpinner$onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.selectedId = this.getSelectedItemId();
        ss.position = ss.selectedId >= 0L ? this.getSelectedItemPosition() : -1;
        return ss;
    }

    private final void $$robo$$android_widget_AbsSpinner$onRestoreInstanceState(Parcelable state) {
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (ss.selectedId >= 0L) {
            this.mDataChanged = true;
            this.mNeedSync = true;
            this.mSyncRowId = ss.selectedId;
            this.mSyncPosition = ss.position;
            this.mSyncMode = 0;
            this.requestLayout();
        }
    }

    private final CharSequence $$robo$$android_widget_AbsSpinner$getAccessibilityClassName() {
        return AbsSpinner.class.getName();
    }

    private final void $$robo$$android_widget_AbsSpinner$autofill(AutofillValue value) {
        if (!this.isEnabled()) {
            return;
        }
        if (!value.isList()) {
            Log.w(LOG_TAG, value + " could not be autofilled into " + this);
            return;
        }
        this.setSelection(value.getListValue());
    }

    private final int $$robo$$android_widget_AbsSpinner$getAutofillType() {
        return this.isEnabled() ? 3 : 0;
    }

    private final AutofillValue $$robo$$android_widget_AbsSpinner$getAutofillValue() {
        return this.isEnabled() ? AutofillValue.forList(this.getSelectedItemPosition()) : null;
    }

    static void __staticInitializer__() {
        LOG_TAG = AbsSpinner.class.getSimpleName();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_widget_AbsSpinner$__constructor__(context);
    }

    public AbsSpinner(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_widget_AbsSpinner$__constructor__(context, attributeSet);
    }

    public AbsSpinner(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_widget_AbsSpinner$__constructor__(context, attributeSet, n);
    }

    public AbsSpinner(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_widget_AbsSpinner$__constructor__(context, attributeSet, n, n2);
    }

    public AbsSpinner(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    private void initAbsSpinner() {
        InvokeDynamicSupport.bootstrap("initAbsSpinner", $$robo$$android_widget_AbsSpinner$initAbsSpinner(), 0, this);
    }

    @Override
    public void setAdapter(SpinnerAdapter spinnerAdapter) {
        InvokeDynamicSupport.bootstrap("setAdapter", $$robo$$android_widget_AbsSpinner$setAdapter(android.widget.SpinnerAdapter ), 0, this, spinnerAdapter);
    }

    void resetList() {
        InvokeDynamicSupport.bootstrap("resetList", $$robo$$android_widget_AbsSpinner$resetList(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_widget_AbsSpinner$onMeasure(int int ), 0, this, n, n2);
    }

    int getChildHeight(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getChildHeight", $$robo$$android_widget_AbsSpinner$getChildHeight(android.view.View ), 0, this, view);
    }

    int getChildWidth(View view) {
        return (int)InvokeDynamicSupport.bootstrap("getChildWidth", $$robo$$android_widget_AbsSpinner$getChildWidth(android.view.View ), 0, this, view);
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return InvokeDynamicSupport.bootstrap("generateDefaultLayoutParams", $$robo$$android_widget_AbsSpinner$generateDefaultLayoutParams(), 0, this);
    }

    void recycleAllViews() {
        InvokeDynamicSupport.bootstrap("recycleAllViews", $$robo$$android_widget_AbsSpinner$recycleAllViews(), 0, this);
    }

    public void setSelection(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_AbsSpinner$setSelection(int boolean ), 0, this, n, bl);
    }

    @Override
    public void setSelection(int n) {
        InvokeDynamicSupport.bootstrap("setSelection", $$robo$$android_widget_AbsSpinner$setSelection(int ), 0, this, n);
    }

    void setSelectionInt(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSelectionInt", $$robo$$android_widget_AbsSpinner$setSelectionInt(int boolean ), 0, this, n, bl);
    }

    @Override
    public View getSelectedView() {
        return InvokeDynamicSupport.bootstrap("getSelectedView", $$robo$$android_widget_AbsSpinner$getSelectedView(), 0, this);
    }

    @Override
    public void requestLayout() {
        InvokeDynamicSupport.bootstrap("requestLayout", $$robo$$android_widget_AbsSpinner$requestLayout(), 0, this);
    }

    @Override
    public SpinnerAdapter getAdapter() {
        return InvokeDynamicSupport.bootstrap("getAdapter", $$robo$$android_widget_AbsSpinner$getAdapter(), 0, this);
    }

    @Override
    public int getCount() {
        return (int)InvokeDynamicSupport.bootstrap("getCount", $$robo$$android_widget_AbsSpinner$getCount(), 0, this);
    }

    public int pointToPosition(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("pointToPosition", $$robo$$android_widget_AbsSpinner$pointToPosition(int int ), 0, this, n, n2);
    }

    @Override
    protected void dispatchRestoreInstanceState(SparseArray<Parcelable> sparseArray) {
        InvokeDynamicSupport.bootstrap("dispatchRestoreInstanceState", $$robo$$android_widget_AbsSpinner$dispatchRestoreInstanceState(android.util.SparseArray<android.os.Parcelable> ), 0, this, sparseArray);
    }

    @Override
    public Parcelable onSaveInstanceState() {
        return InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_widget_AbsSpinner$onSaveInstanceState(), 0, this);
    }

    @Override
    public void onRestoreInstanceState(Parcelable parcelable) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_widget_AbsSpinner$onRestoreInstanceState(android.os.Parcelable ), 0, this, parcelable);
    }

    @Override
    public CharSequence getAccessibilityClassName() {
        return InvokeDynamicSupport.bootstrap("getAccessibilityClassName", $$robo$$android_widget_AbsSpinner$getAccessibilityClassName(), 0, this);
    }

    @Override
    public void autofill(AutofillValue autofillValue) {
        InvokeDynamicSupport.bootstrap("autofill", $$robo$$android_widget_AbsSpinner$autofill(android.view.autofill.AutofillValue ), 0, this, autofillValue);
    }

    @Override
    public int getAutofillType() {
        return (int)InvokeDynamicSupport.bootstrap("getAutofillType", $$robo$$android_widget_AbsSpinner$getAutofillType(), 0, this);
    }

    @Override
    public AutofillValue getAutofillValue() {
        return InvokeDynamicSupport.bootstrap("getAutofillValue", $$robo$$android_widget_AbsSpinner$getAutofillValue(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(AbsSpinner.class);
    }

    public /* synthetic */ AbsSpinner() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AbsSpinner)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class RecycleBin
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SparseArray<View> mScrapHeap;
        /* synthetic */ AbsSpinner this$0;

        private void $$robo$$android_widget_AbsSpinner_RecycleBin$__constructor__(AbsSpinner this$0) {
            this.mScrapHeap = new SparseArray();
        }

        private final void $$robo$$android_widget_AbsSpinner_RecycleBin$put(int position, View v) {
            this.mScrapHeap.put(position, v);
        }

        private final View $$robo$$android_widget_AbsSpinner_RecycleBin$get(int position) {
            View result = this.mScrapHeap.get(position);
            if (result != null) {
                this.mScrapHeap.delete(position);
            }
            return result;
        }

        private final void $$robo$$android_widget_AbsSpinner_RecycleBin$clear() {
            SparseArray<View> scrapHeap = this.mScrapHeap;
            int count = scrapHeap.size();
            for (int i = 0; i < count; ++i) {
                View view = scrapHeap.valueAt(i);
                if (view == null) continue;
                this.this$0.removeDetachedView(view, true);
            }
            scrapHeap.clear();
        }

        private void __constructor__(AbsSpinner absSpinner) {
            this.$$robo$$android_widget_AbsSpinner_RecycleBin$__constructor__(absSpinner);
        }

        RecycleBin(AbsSpinner absSpinner) {
            this.this$0 = absSpinner;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner_RecycleBin$__constructor__(android.widget.AbsSpinner ), 0, this, absSpinner);
        }

        public void put(int n, View view) {
            InvokeDynamicSupport.bootstrap("put", $$robo$$android_widget_AbsSpinner_RecycleBin$put(int android.view.View ), 0, this, n, view);
        }

        View get(int n) {
            return InvokeDynamicSupport.bootstrap("get", $$robo$$android_widget_AbsSpinner_RecycleBin$get(int ), 0, this, n);
        }

        void clear() {
            InvokeDynamicSupport.bootstrap("clear", $$robo$$android_widget_AbsSpinner_RecycleBin$clear(), 0, this);
        }

        public /* synthetic */ RecycleBin() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecycleBin)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class SavedState
    extends View.BaseSavedState
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        long selectedId;
        int position;
        public static Parcelable.Creator<SavedState> CREATOR;

        private void $$robo$$android_widget_AbsSpinner_SavedState$__constructor__(Parcelable superState) {
        }

        private void $$robo$$android_widget_AbsSpinner_SavedState$__constructor__(Parcel in) {
            this.selectedId = in.readLong();
            this.position = in.readInt();
        }

        private final void $$robo$$android_widget_AbsSpinner_SavedState$writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeLong(this.selectedId);
            out.writeInt(this.position);
        }

        private final String $$robo$$android_widget_AbsSpinner_SavedState$toString() {
            return "AbsSpinner.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " selectedId=" + this.selectedId + " position=" + this.position + "}";
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<SavedState>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_widget_AbsSpinner_SavedState_1$__constructor__() {
                }

                private final SavedState $$robo$$android_widget_AbsSpinner_SavedState_1$createFromParcel(Parcel in) {
                    return new SavedState(in);
                }

                private final SavedState[] $$robo$$android_widget_AbsSpinner_SavedState_1$newArray(int size) {
                    return new SavedState[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_widget_AbsSpinner_SavedState_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner_SavedState_1$__constructor__(), 0, this);
                }

                @Override
                public SavedState createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_widget_AbsSpinner_SavedState_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public SavedState[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_widget_AbsSpinner_SavedState_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(Parcelable parcelable) {
            this.$$robo$$android_widget_AbsSpinner_SavedState$__constructor__(parcelable);
        }

        SavedState(Parcelable parcelable) {
            super(parcelable);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner_SavedState$__constructor__(android.os.Parcelable ), 0, this, parcelable);
        }

        private void __constructor__(Parcel parcel) {
            this.$$robo$$android_widget_AbsSpinner_SavedState$__constructor__(parcel);
        }

        SavedState(Parcel parcel) {
            super(parcel);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_widget_AbsSpinner_SavedState$__constructor__(android.os.Parcel ), 0, this, parcel);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_widget_AbsSpinner_SavedState$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_widget_AbsSpinner_SavedState$toString(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(SavedState.class);
        }

        public /* synthetic */ SavedState() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SavedState)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

