/*
 * Decompiled with CFR 0.152.
 */
package android.view.inputmethod;

import android.graphics.Matrix;
import android.graphics.RectF;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.SpannedString;
import android.text.TextUtils;
import android.view.inputmethod.SparseRectFArray;
import com.google.errorprone.annotations.DoNotMock;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class CursorAnchorInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mHashCode;
    private int mSelectionStart;
    private int mSelectionEnd;
    private int mComposingTextStart;
    private CharSequence mComposingText;
    private int mInsertionMarkerFlags;
    private float mInsertionMarkerHorizontal;
    private float mInsertionMarkerTop;
    private float mInsertionMarkerBaseline;
    private float mInsertionMarkerBottom;
    private SparseRectFArray mCharacterBoundsArray;
    private float[] mMatrixValues;
    public static int FLAG_HAS_VISIBLE_REGION = 1;
    public static int FLAG_HAS_INVISIBLE_REGION = 2;
    public static int FLAG_IS_RTL = 4;
    public static Parcelable.Creator<CursorAnchorInfo> CREATOR;

    private void $$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(Parcel source) {
        this.mHashCode = source.readInt();
        this.mSelectionStart = source.readInt();
        this.mSelectionEnd = source.readInt();
        this.mComposingTextStart = source.readInt();
        this.mComposingText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(source);
        this.mInsertionMarkerFlags = source.readInt();
        this.mInsertionMarkerHorizontal = source.readFloat();
        this.mInsertionMarkerTop = source.readFloat();
        this.mInsertionMarkerBaseline = source.readFloat();
        this.mInsertionMarkerBottom = source.readFloat();
        this.mCharacterBoundsArray = (SparseRectFArray)source.readParcelable(SparseRectFArray.class.getClassLoader());
        this.mMatrixValues = source.createFloatArray();
    }

    private final void $$robo$$android_view_inputmethod_CursorAnchorInfo$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mHashCode);
        dest.writeInt(this.mSelectionStart);
        dest.writeInt(this.mSelectionEnd);
        dest.writeInt(this.mComposingTextStart);
        TextUtils.writeToParcel(this.mComposingText, dest, flags);
        dest.writeInt(this.mInsertionMarkerFlags);
        dest.writeFloat(this.mInsertionMarkerHorizontal);
        dest.writeFloat(this.mInsertionMarkerTop);
        dest.writeFloat(this.mInsertionMarkerBaseline);
        dest.writeFloat(this.mInsertionMarkerBottom);
        dest.writeParcelable(this.mCharacterBoundsArray, flags);
        dest.writeFloatArray(this.mMatrixValues);
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$hashCode() {
        return this.mHashCode;
    }

    private static final boolean $$robo$$android_view_inputmethod_CursorAnchorInfo$areSameFloatImpl(float a, float b) {
        if (Float.isNaN(a) && Float.isNaN(b)) {
            return true;
        }
        return a == b;
    }

    private final boolean $$robo$$android_view_inputmethod_CursorAnchorInfo$equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof CursorAnchorInfo)) {
            return false;
        }
        CursorAnchorInfo that = (CursorAnchorInfo)obj;
        if (this.hashCode() != that.hashCode()) {
            return false;
        }
        if (this.mSelectionStart != that.mSelectionStart || this.mSelectionEnd != that.mSelectionEnd) {
            return false;
        }
        if (!(this.mInsertionMarkerFlags == that.mInsertionMarkerFlags && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerHorizontal, that.mInsertionMarkerHorizontal) && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerTop, that.mInsertionMarkerTop) && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerBaseline, that.mInsertionMarkerBaseline) && CursorAnchorInfo.areSameFloatImpl(this.mInsertionMarkerBottom, that.mInsertionMarkerBottom))) {
            return false;
        }
        if (!Objects.equals(this.mCharacterBoundsArray, that.mCharacterBoundsArray)) {
            return false;
        }
        if (this.mComposingTextStart != that.mComposingTextStart || !Objects.equals(this.mComposingText, that.mComposingText)) {
            return false;
        }
        if (this.mMatrixValues.length != that.mMatrixValues.length) {
            return false;
        }
        for (int i = 0; i < this.mMatrixValues.length; ++i) {
            if (this.mMatrixValues[i] == that.mMatrixValues[i]) continue;
            return false;
        }
        return true;
    }

    private final String $$robo$$android_view_inputmethod_CursorAnchorInfo$toString() {
        return "CursorAnchorInfo{mHashCode=" + this.mHashCode + " mSelection=" + this.mSelectionStart + "," + this.mSelectionEnd + " mComposingTextStart=" + this.mComposingTextStart + " mComposingText=" + Objects.toString(this.mComposingText) + " mInsertionMarkerFlags=" + this.mInsertionMarkerFlags + " mInsertionMarkerHorizontal=" + this.mInsertionMarkerHorizontal + " mInsertionMarkerTop=" + this.mInsertionMarkerTop + " mInsertionMarkerBaseline=" + this.mInsertionMarkerBaseline + " mInsertionMarkerBottom=" + this.mInsertionMarkerBottom + " mCharacterBoundsArray=" + Objects.toString(this.mCharacterBoundsArray) + " mMatrix=" + Arrays.toString(this.mMatrixValues) + "}";
    }

    private void $$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(Builder builder) {
        this.mSelectionStart = builder.mSelectionStart;
        this.mSelectionEnd = builder.mSelectionEnd;
        this.mComposingTextStart = builder.mComposingTextStart;
        this.mComposingText = builder.mComposingText;
        this.mInsertionMarkerFlags = builder.mInsertionMarkerFlags;
        this.mInsertionMarkerHorizontal = builder.mInsertionMarkerHorizontal;
        this.mInsertionMarkerTop = builder.mInsertionMarkerTop;
        this.mInsertionMarkerBaseline = builder.mInsertionMarkerBaseline;
        this.mInsertionMarkerBottom = builder.mInsertionMarkerBottom;
        this.mCharacterBoundsArray = builder.mCharacterBoundsArrayBuilder != null ? builder.mCharacterBoundsArrayBuilder.build() : null;
        this.mMatrixValues = new float[9];
        if (builder.mMatrixInitialized) {
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (float[])builder.mMatrixValues, (int)0, (float[])this.mMatrixValues, (int)0, (int)9);
        } else {
            Matrix.IDENTITY_MATRIX.getValues(this.mMatrixValues);
        }
        int hash = Objects.hashCode(this.mComposingText);
        hash *= 31;
        this.mHashCode = hash += Arrays.hashCode(this.mMatrixValues);
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$getSelectionStart() {
        return this.mSelectionStart;
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$getSelectionEnd() {
        return this.mSelectionEnd;
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$getComposingTextStart() {
        return this.mComposingTextStart;
    }

    private final CharSequence $$robo$$android_view_inputmethod_CursorAnchorInfo$getComposingText() {
        return this.mComposingText;
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerFlags() {
        return this.mInsertionMarkerFlags;
    }

    private final float $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerHorizontal() {
        return this.mInsertionMarkerHorizontal;
    }

    private final float $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerTop() {
        return this.mInsertionMarkerTop;
    }

    private final float $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerBaseline() {
        return this.mInsertionMarkerBaseline;
    }

    private final float $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerBottom() {
        return this.mInsertionMarkerBottom;
    }

    private final RectF $$robo$$android_view_inputmethod_CursorAnchorInfo$getCharacterBounds(int index) {
        if (this.mCharacterBoundsArray == null) {
            return null;
        }
        return this.mCharacterBoundsArray.get(index);
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$getCharacterBoundsFlags(int index) {
        if (this.mCharacterBoundsArray == null) {
            return 0;
        }
        return this.mCharacterBoundsArray.getFlags(index, 0);
    }

    private final Matrix $$robo$$android_view_inputmethod_CursorAnchorInfo$getMatrix() {
        Matrix matrix = new Matrix();
        matrix.setValues(this.mMatrixValues);
        return matrix;
    }

    private final int $$robo$$android_view_inputmethod_CursorAnchorInfo$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(Builder x0, 1 x1) {
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<CursorAnchorInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_inputmethod_CursorAnchorInfo_1$__constructor__() {
            }

            private final CursorAnchorInfo $$robo$$android_view_inputmethod_CursorAnchorInfo_1$createFromParcel(Parcel source) {
                return new CursorAnchorInfo(source);
            }

            private final CursorAnchorInfo[] $$robo$$android_view_inputmethod_CursorAnchorInfo_1$newArray(int size) {
                return new CursorAnchorInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_inputmethod_CursorAnchorInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_CursorAnchorInfo_1$__constructor__(), 0, this);
            }

            @Override
            public CursorAnchorInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_inputmethod_CursorAnchorInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public CursorAnchorInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_inputmethod_CursorAnchorInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(parcel);
    }

    public CursorAnchorInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_inputmethod_CursorAnchorInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_view_inputmethod_CursorAnchorInfo$hashCode(), 0, this);
    }

    private static boolean areSameFloatImpl(float f, float f2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areSameFloatImpl", $$robo$$android_view_inputmethod_CursorAnchorInfo$areSameFloatImpl(float float ), 0, (float)f, (float)f2);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_view_inputmethod_CursorAnchorInfo$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_view_inputmethod_CursorAnchorInfo$toString(), 0, this);
    }

    private void __constructor__(Builder builder) {
        this.$$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(builder);
    }

    private CursorAnchorInfo(Builder builder) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(android.view.inputmethod.CursorAnchorInfo$Builder ), 0, this, builder);
    }

    public int getSelectionStart() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionStart", $$robo$$android_view_inputmethod_CursorAnchorInfo$getSelectionStart(), 0, this);
    }

    public int getSelectionEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getSelectionEnd", $$robo$$android_view_inputmethod_CursorAnchorInfo$getSelectionEnd(), 0, this);
    }

    public int getComposingTextStart() {
        return (int)InvokeDynamicSupport.bootstrap("getComposingTextStart", $$robo$$android_view_inputmethod_CursorAnchorInfo$getComposingTextStart(), 0, this);
    }

    public CharSequence getComposingText() {
        return InvokeDynamicSupport.bootstrap("getComposingText", $$robo$$android_view_inputmethod_CursorAnchorInfo$getComposingText(), 0, this);
    }

    public int getInsertionMarkerFlags() {
        return (int)InvokeDynamicSupport.bootstrap("getInsertionMarkerFlags", $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerFlags(), 0, this);
    }

    public float getInsertionMarkerHorizontal() {
        return (float)InvokeDynamicSupport.bootstrap("getInsertionMarkerHorizontal", $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerHorizontal(), 0, this);
    }

    public float getInsertionMarkerTop() {
        return (float)InvokeDynamicSupport.bootstrap("getInsertionMarkerTop", $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerTop(), 0, this);
    }

    public float getInsertionMarkerBaseline() {
        return (float)InvokeDynamicSupport.bootstrap("getInsertionMarkerBaseline", $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerBaseline(), 0, this);
    }

    public float getInsertionMarkerBottom() {
        return (float)InvokeDynamicSupport.bootstrap("getInsertionMarkerBottom", $$robo$$android_view_inputmethod_CursorAnchorInfo$getInsertionMarkerBottom(), 0, this);
    }

    public RectF getCharacterBounds(int n) {
        return InvokeDynamicSupport.bootstrap("getCharacterBounds", $$robo$$android_view_inputmethod_CursorAnchorInfo$getCharacterBounds(int ), 0, this, n);
    }

    public int getCharacterBoundsFlags(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCharacterBoundsFlags", $$robo$$android_view_inputmethod_CursorAnchorInfo$getCharacterBoundsFlags(int ), 0, this, n);
    }

    public Matrix getMatrix() {
        return InvokeDynamicSupport.bootstrap("getMatrix", $$robo$$android_view_inputmethod_CursorAnchorInfo$getMatrix(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_inputmethod_CursorAnchorInfo$describeContents(), 0, this);
    }

    private /* synthetic */ void __constructor__(Builder builder, 1 var2_2) {
        this.$$robo$$android_view_inputmethod_CursorAnchorInfo$__constructor__(builder, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(CursorAnchorInfo.class);
    }

    public /* synthetic */ CursorAnchorInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CursorAnchorInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private int mSelectionStart;
        private int mSelectionEnd;
        private int mComposingTextStart;
        private CharSequence mComposingText;
        private float mInsertionMarkerHorizontal;
        private float mInsertionMarkerTop;
        private float mInsertionMarkerBaseline;
        private float mInsertionMarkerBottom;
        private int mInsertionMarkerFlags;
        private SparseRectFArray.SparseRectFArrayBuilder mCharacterBoundsArrayBuilder;
        private float[] mMatrixValues;
        private boolean mMatrixInitialized;

        private void $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$__constructor__() {
            this.mSelectionStart = -1;
            this.mSelectionEnd = -1;
            this.mComposingTextStart = -1;
            this.mComposingText = null;
            this.mInsertionMarkerHorizontal = Float.NaN;
            this.mInsertionMarkerTop = Float.NaN;
            this.mInsertionMarkerBaseline = Float.NaN;
            this.mInsertionMarkerBottom = Float.NaN;
            this.mInsertionMarkerFlags = 0;
            this.mCharacterBoundsArrayBuilder = null;
            this.mMatrixValues = null;
            this.mMatrixInitialized = false;
        }

        private final Builder $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setSelectionRange(int newStart, int newEnd) {
            this.mSelectionStart = newStart;
            this.mSelectionEnd = newEnd;
            return this;
        }

        private final Builder $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setComposingText(int composingTextStart, CharSequence composingText) {
            this.mComposingTextStart = composingTextStart;
            this.mComposingText = composingText == null ? null : new SpannedString(composingText);
            return this;
        }

        private final Builder $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setInsertionMarkerLocation(float horizontalPosition, float lineTop, float lineBaseline, float lineBottom, int flags) {
            this.mInsertionMarkerHorizontal = horizontalPosition;
            this.mInsertionMarkerTop = lineTop;
            this.mInsertionMarkerBaseline = lineBaseline;
            this.mInsertionMarkerBottom = lineBottom;
            this.mInsertionMarkerFlags = flags;
            return this;
        }

        private final Builder $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$addCharacterBounds(int index, float left, float top, float right, float bottom, int flags) {
            if (index < 0) {
                throw new IllegalArgumentException("index must not be a negative integer.");
            }
            if (this.mCharacterBoundsArrayBuilder == null) {
                this.mCharacterBoundsArrayBuilder = new SparseRectFArray.SparseRectFArrayBuilder();
            }
            this.mCharacterBoundsArrayBuilder.append(index, left, top, right, bottom, flags);
            return this;
        }

        private final Builder $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setMatrix(Matrix matrix) {
            if (this.mMatrixValues == null) {
                this.mMatrixValues = new float[9];
            }
            (matrix != null ? matrix : Matrix.IDENTITY_MATRIX).getValues(this.mMatrixValues);
            this.mMatrixInitialized = true;
            return this;
        }

        private final CursorAnchorInfo $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$build() {
            if (!this.mMatrixInitialized) {
                boolean hasCharacterBounds;
                boolean bl = hasCharacterBounds = this.mCharacterBoundsArrayBuilder != null && !this.mCharacterBoundsArrayBuilder.isEmpty();
                if (!(!hasCharacterBounds && Float.isNaN(this.mInsertionMarkerHorizontal) && Float.isNaN(this.mInsertionMarkerTop) && Float.isNaN(this.mInsertionMarkerBaseline) && Float.isNaN(this.mInsertionMarkerBottom))) {
                    throw new IllegalArgumentException("Coordinate transformation matrix is required when positional parameters are specified.");
                }
            }
            return new CursorAnchorInfo(this);
        }

        private final void $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$reset() {
            this.mSelectionStart = -1;
            this.mSelectionEnd = -1;
            this.mComposingTextStart = -1;
            this.mComposingText = null;
            this.mInsertionMarkerFlags = 0;
            this.mInsertionMarkerHorizontal = Float.NaN;
            this.mInsertionMarkerTop = Float.NaN;
            this.mInsertionMarkerBaseline = Float.NaN;
            this.mInsertionMarkerBottom = Float.NaN;
            this.mMatrixInitialized = false;
            if (this.mCharacterBoundsArrayBuilder != null) {
                this.mCharacterBoundsArrayBuilder.reset();
            }
        }

        private void __constructor__() {
            this.$$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$__constructor__(), 0, this);
        }

        public Builder setSelectionRange(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setSelectionRange", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setSelectionRange(int int ), 0, this, n, n2);
        }

        public Builder setComposingText(int n, CharSequence charSequence) {
            return InvokeDynamicSupport.bootstrap("setComposingText", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setComposingText(int java.lang.CharSequence ), 0, this, n, charSequence);
        }

        public Builder setInsertionMarkerLocation(float f, float f2, float f3, float f4, int n) {
            return InvokeDynamicSupport.bootstrap("setInsertionMarkerLocation", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setInsertionMarkerLocation(float float float float int ), 0, this, f, f2, f3, f4, n);
        }

        public Builder addCharacterBounds(int n, float f, float f2, float f3, float f4, int n2) {
            return InvokeDynamicSupport.bootstrap("addCharacterBounds", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$addCharacterBounds(int float float float float int ), 0, this, n, f, f2, f3, f4, n2);
        }

        public Builder setMatrix(Matrix matrix) {
            return InvokeDynamicSupport.bootstrap("setMatrix", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$setMatrix(android.graphics.Matrix ), 0, this, matrix);
        }

        public CursorAnchorInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$build(), 0, this);
        }

        public void reset() {
            InvokeDynamicSupport.bootstrap("reset", $$robo$$android_view_inputmethod_CursorAnchorInfo_Builder$reset(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

