/*
 * Decompiled with CFR 0.152.
 */
package android.view.accessibility;

import android.accessibilityservice.IAccessibilityServiceConnection;
import android.os.Binder;
import android.os.Build;
import android.os.Bundle;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.SystemClock;
import android.util.Log;
import android.util.LongSparseArray;
import android.util.SparseArray;
import android.view.accessibility.AccessibilityCache;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityWindowInfo;
import android.view.accessibility.IAccessibilityInteractionConnectionCallback;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class AccessibilityInteractionClient
extends IAccessibilityInteractionConnectionCallback.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int NO_ID = -1;
    private static String LOG_TAG = "AccessibilityInteractionClient";
    private static boolean DEBUG = false;
    private static boolean CHECK_INTEGRITY = true;
    private static long TIMEOUT_INTERACTION_MILLIS = 5000L;
    private static Object sStaticLock;
    private static LongSparseArray<AccessibilityInteractionClient> sClients;
    private AtomicInteger mInteractionIdCounter;
    private Object mInstanceLock;
    private volatile int mInteractionId;
    private AccessibilityNodeInfo mFindAccessibilityNodeInfoResult;
    private List<AccessibilityNodeInfo> mFindAccessibilityNodeInfosResult;
    private boolean mPerformAccessibilityActionResult;
    private Message mSameThreadMessage;
    private static SparseArray<IAccessibilityServiceConnection> sConnectionCache;
    private static AccessibilityCache sAccessibilityCache;

    private static final AccessibilityInteractionClient $$robo$$android_view_accessibility_AccessibilityInteractionClient$getInstance() {
        long threadId = Thread.currentThread().getId();
        return AccessibilityInteractionClient.getInstanceForThread(threadId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final AccessibilityInteractionClient $$robo$$android_view_accessibility_AccessibilityInteractionClient$getInstanceForThread(long threadId) {
        Object object = sStaticLock;
        synchronized (object) {
            AccessibilityInteractionClient client = sClients.get(threadId);
            if (client == null) {
                client = new AccessibilityInteractionClient();
                sClients.put(threadId, client);
            }
            return client;
        }
    }

    private void $$robo$$android_view_accessibility_AccessibilityInteractionClient$__constructor__() {
        this.mInteractionIdCounter = new AtomicInteger();
        this.mInstanceLock = new Object();
        this.mInteractionId = -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$setSameThreadMessage(Message message) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            this.mSameThreadMessage = message;
            this.mInstanceLock.notifyAll();
        }
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityInteractionClient$getRootInActiveWindow(int connectionId) {
        return this.findAccessibilityNodeInfoByAccessibilityId(connectionId, Integer.MAX_VALUE, AccessibilityNodeInfo.ROOT_NODE_ID, false, 4, null);
    }

    private final AccessibilityWindowInfo $$robo$$android_view_accessibility_AccessibilityInteractionClient$getWindow(int connectionId, int accessibilityWindowId) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                AccessibilityWindowInfo window = sAccessibilityCache.getWindow(accessibilityWindowId);
                if (window != null) {
                    return window;
                }
                long identityToken = Binder.clearCallingIdentity();
                window = connection.getWindow(accessibilityWindowId);
                Binder.restoreCallingIdentity(identityToken);
                if (window != null) {
                    sAccessibilityCache.addWindow(window);
                    return window;
                }
            }
        }
        catch (RemoteException re) {
            Log.e("AccessibilityInteractionClient", "Error while calling remote getWindow", re);
        }
        return null;
    }

    private final List<AccessibilityWindowInfo> $$robo$$android_view_accessibility_AccessibilityInteractionClient$getWindows(int connectionId) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                List<AccessibilityWindowInfo> windows = sAccessibilityCache.getWindows();
                if (windows != null) {
                    return windows;
                }
                long identityToken = Binder.clearCallingIdentity();
                windows = connection.getWindows();
                Binder.restoreCallingIdentity(identityToken);
                if (windows != null) {
                    sAccessibilityCache.setWindows(windows);
                    return windows;
                }
            }
        }
        catch (RemoteException re) {
            Log.e("AccessibilityInteractionClient", "Error while calling remote getWindows", re);
        }
        return Collections.emptyList();
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityInteractionClient$findAccessibilityNodeInfoByAccessibilityId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, boolean bypassCache, int prefetchFlags, Bundle arguments) {
        if ((prefetchFlags & 2) != 0 && (prefetchFlags & 1) == 0) {
            throw new IllegalArgumentException("FLAG_PREFETCH_SIBLINGS requires FLAG_PREFETCH_PREDECESSORS");
        }
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                AccessibilityNodeInfo cachedInfo;
                if (!bypassCache && (cachedInfo = sAccessibilityCache.getNode(accessibilityWindowId, accessibilityNodeId)) != null) {
                    return cachedInfo;
                }
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                boolean success = connection.findAccessibilityNodeInfoByAccessibilityId(accessibilityWindowId, accessibilityNodeId, interactionId, this, prefetchFlags, Thread.currentThread().getId(), arguments);
                Binder.restoreCallingIdentity(identityToken);
                if (success) {
                    List<AccessibilityNodeInfo> infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId);
                    if (infos != null && !infos.isEmpty()) {
                        for (int i = 1; i < infos.size(); ++i) {
                            infos.get(i).recycle();
                        }
                        return infos.get(0);
                    }
                }
            }
        }
        catch (RemoteException re) {
            Log.e("AccessibilityInteractionClient", "Error while calling remote findAccessibilityNodeInfoByAccessibilityId", re);
        }
        return null;
    }

    private final List<AccessibilityNodeInfo> $$robo$$android_view_accessibility_AccessibilityInteractionClient$findAccessibilityNodeInfosByViewId(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String viewId) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                List<AccessibilityNodeInfo> infos;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                boolean success = connection.findAccessibilityNodeInfosByViewId(accessibilityWindowId, accessibilityNodeId, viewId, interactionId, this, Thread.currentThread().getId());
                Binder.restoreCallingIdentity(identityToken);
                if (success && (infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId)) != null) {
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId);
                    return infos;
                }
            }
        }
        catch (RemoteException re) {
            Log.w("AccessibilityInteractionClient", "Error while calling remote findAccessibilityNodeInfoByViewIdInActiveWindow", re);
        }
        return Collections.emptyList();
    }

    private final List<AccessibilityNodeInfo> $$robo$$android_view_accessibility_AccessibilityInteractionClient$findAccessibilityNodeInfosByText(int connectionId, int accessibilityWindowId, long accessibilityNodeId, String text) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                List<AccessibilityNodeInfo> infos;
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                boolean success = connection.findAccessibilityNodeInfosByText(accessibilityWindowId, accessibilityNodeId, text, interactionId, this, Thread.currentThread().getId());
                Binder.restoreCallingIdentity(identityToken);
                if (success && (infos = this.getFindAccessibilityNodeInfosResultAndClear(interactionId)) != null) {
                    this.finalizeAndCacheAccessibilityNodeInfos(infos, connectionId);
                    return infos;
                }
            }
        }
        catch (RemoteException re) {
            Log.w("AccessibilityInteractionClient", "Error while calling remote findAccessibilityNodeInfosByViewText", re);
        }
        return Collections.emptyList();
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityInteractionClient$findFocus(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int focusType) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                boolean success = connection.findFocus(accessibilityWindowId, accessibilityNodeId, focusType, interactionId, this, Thread.currentThread().getId());
                Binder.restoreCallingIdentity(identityToken);
                if (success) {
                    AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId);
                    return info;
                }
            }
        }
        catch (RemoteException re) {
            Log.w("AccessibilityInteractionClient", "Error while calling remote findFocus", re);
        }
        return null;
    }

    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityInteractionClient$focusSearch(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int direction) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                boolean success = connection.focusSearch(accessibilityWindowId, accessibilityNodeId, direction, interactionId, this, Thread.currentThread().getId());
                Binder.restoreCallingIdentity(identityToken);
                if (success) {
                    AccessibilityNodeInfo info = this.getFindAccessibilityNodeInfoResultAndClear(interactionId);
                    this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId);
                    return info;
                }
            }
        }
        catch (RemoteException re) {
            Log.w("AccessibilityInteractionClient", "Error while calling remote accessibilityFocusSearch", re);
        }
        return null;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityInteractionClient$performAccessibilityAction(int connectionId, int accessibilityWindowId, long accessibilityNodeId, int action, Bundle arguments) {
        try {
            IAccessibilityServiceConnection connection = this.getConnection(connectionId);
            if (connection != null) {
                int interactionId = this.mInteractionIdCounter.getAndIncrement();
                long identityToken = Binder.clearCallingIdentity();
                boolean success = connection.performAccessibilityAction(accessibilityWindowId, accessibilityNodeId, action, arguments, interactionId, this, Thread.currentThread().getId());
                Binder.restoreCallingIdentity(identityToken);
                if (success) {
                    return this.getPerformAccessibilityActionResultAndClear(interactionId);
                }
            }
        }
        catch (RemoteException re) {
            Log.w("AccessibilityInteractionClient", "Error while calling remote performAccessibilityAction", re);
        }
        return false;
    }

    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$clearCache() {
        sAccessibilityCache.clear();
    }

    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$onAccessibilityEvent(AccessibilityEvent event) {
        sAccessibilityCache.onAccessibilityEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final AccessibilityNodeInfo $$robo$$android_view_accessibility_AccessibilityInteractionClient$getFindAccessibilityNodeInfoResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            AccessibilityNodeInfo result = success ? this.mFindAccessibilityNodeInfoResult : null;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo info, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mFindAccessibilityNodeInfoResult = info;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<AccessibilityNodeInfo> $$robo$$android_view_accessibility_AccessibilityInteractionClient$getFindAccessibilityNodeInfosResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            List<AccessibilityNodeInfo> result = null;
            result = success ? this.mFindAccessibilityNodeInfosResult : Collections.emptyList();
            this.clearResultLocked();
            if (Build.IS_DEBUGGABLE) {
                this.checkFindAccessibilityNodeInfoResultIntegrity(result);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> infos, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                if (infos != null) {
                    boolean isIpcCall;
                    boolean bl = isIpcCall = Binder.getCallingPid() != Process.myPid();
                    this.mFindAccessibilityNodeInfosResult = !isIpcCall ? new ArrayList<AccessibilityNodeInfo>(infos) : infos;
                } else {
                    this.mFindAccessibilityNodeInfosResult = Collections.emptyList();
                }
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_view_accessibility_AccessibilityInteractionClient$getPerformAccessibilityActionResultAndClear(int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            boolean success = this.waitForResultTimedLocked(interactionId);
            boolean result = success ? this.mPerformAccessibilityActionResult : false;
            this.clearResultLocked();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$setPerformAccessibilityActionResult(boolean succeeded, int interactionId) {
        Object object = this.mInstanceLock;
        synchronized (object) {
            if (interactionId > this.mInteractionId) {
                this.mPerformAccessibilityActionResult = succeeded;
                this.mInteractionId = interactionId;
            }
            this.mInstanceLock.notifyAll();
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$clearResultLocked() {
        this.mInteractionId = -1;
        this.mFindAccessibilityNodeInfoResult = null;
        this.mFindAccessibilityNodeInfosResult = null;
        this.mPerformAccessibilityActionResult = false;
    }

    private final boolean $$robo$$android_view_accessibility_AccessibilityInteractionClient$waitForResultTimedLocked(int interactionId) {
        long waitTimeMillis = 5000L;
        long startTimeMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Message sameProcessMessage;
                    if ((sameProcessMessage = this.getSameProcessMessageAndClear()) != null) {
                        sameProcessMessage.getTarget().handleMessage(sameProcessMessage);
                    }
                    if (this.mInteractionId == interactionId) {
                        return true;
                    }
                    if (this.mInteractionId > interactionId) {
                        return false;
                    }
                    long elapsedTimeMillis = SystemClock.uptimeMillis() - startTimeMillis;
                    waitTimeMillis = 5000L - elapsedTimeMillis;
                    if (waitTimeMillis <= 0L) {
                        return false;
                    }
                    this.mInstanceLock.wait(waitTimeMillis);
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$finalizeAndCacheAccessibilityNodeInfo(AccessibilityNodeInfo info, int connectionId) {
        if (info != null) {
            info.setConnectionId(connectionId);
            info.setSealed(true);
            sAccessibilityCache.add(info);
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$finalizeAndCacheAccessibilityNodeInfos(List<AccessibilityNodeInfo> infos, int connectionId) {
        if (infos != null) {
            int infosCount = infos.size();
            for (int i = 0; i < infosCount; ++i) {
                AccessibilityNodeInfo info = infos.get(i);
                this.finalizeAndCacheAccessibilityNodeInfo(info, connectionId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Message $$robo$$android_view_accessibility_AccessibilityInteractionClient$getSameProcessMessageAndClear() {
        Object object = this.mInstanceLock;
        synchronized (object) {
            Message result = this.mSameThreadMessage;
            this.mSameThreadMessage = null;
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final IAccessibilityServiceConnection $$robo$$android_view_accessibility_AccessibilityInteractionClient$getConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            return sConnectionCache.get(connectionId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$addConnection(int connectionId, IAccessibilityServiceConnection connection) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.put(connectionId, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$removeConnection(int connectionId) {
        SparseArray<IAccessibilityServiceConnection> sparseArray = sConnectionCache;
        synchronized (sparseArray) {
            sConnectionCache.remove(connectionId);
        }
    }

    private final void $$robo$$android_view_accessibility_AccessibilityInteractionClient$checkFindAccessibilityNodeInfoResultIntegrity(List<AccessibilityNodeInfo> infos) {
        if (infos.size() == 0) {
            return;
        }
        AccessibilityNodeInfo root = infos.get(0);
        int infoCount = infos.size();
        block0: for (int i = 1; i < infoCount; ++i) {
            for (int j = i; j < infoCount; ++j) {
                AccessibilityNodeInfo candidate = infos.get(j);
                if (root.getParentNodeId() != candidate.getSourceNodeId()) continue;
                root = candidate;
                continue block0;
            }
        }
        if (root == null) {
            Log.e("AccessibilityInteractionClient", "No root.");
        }
        HashSet<AccessibilityNodeInfo> seen = new HashSet<AccessibilityNodeInfo>();
        LinkedList<AccessibilityNodeInfo> fringe = new LinkedList<AccessibilityNodeInfo>();
        fringe.add(root);
        while (!fringe.isEmpty()) {
            AccessibilityNodeInfo current = (AccessibilityNodeInfo)fringe.poll();
            if (!seen.add(current)) {
                Log.e("AccessibilityInteractionClient", "Duplicate node.");
                return;
            }
            int childCount = current.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                long childId = current.getChildId(i);
                for (int j = 0; j < infoCount; ++j) {
                    AccessibilityNodeInfo child = infos.get(j);
                    if (child.getSourceNodeId() != childId) continue;
                    fringe.add(child);
                }
            }
        }
        int disconnectedCount = infos.size() - seen.size();
        if (disconnectedCount > 0) {
            Log.e("AccessibilityInteractionClient", disconnectedCount + " Disconnected nodes.");
        }
    }

    static void __staticInitializer__() {
        sStaticLock = new Object();
        sClients = new LongSparseArray();
        sConnectionCache = new SparseArray();
        sAccessibilityCache = new AccessibilityCache(new AccessibilityCache.AccessibilityNodeRefresher());
    }

    public static AccessibilityInteractionClient getInstance() {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getInstance(), 0);
    }

    public static AccessibilityInteractionClient getInstanceForThread(long l) {
        return InvokeDynamicSupport.bootstrapStatic("getInstanceForThread", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getInstanceForThread(long ), 0, (long)l);
    }

    private void __constructor__() {
        this.$$robo$$android_view_accessibility_AccessibilityInteractionClient$__constructor__();
    }

    private AccessibilityInteractionClient() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_accessibility_AccessibilityInteractionClient$__constructor__(), 0, this);
    }

    public void setSameThreadMessage(Message message) {
        InvokeDynamicSupport.bootstrap("setSameThreadMessage", $$robo$$android_view_accessibility_AccessibilityInteractionClient$setSameThreadMessage(android.os.Message ), 0, this, message);
    }

    public AccessibilityNodeInfo getRootInActiveWindow(int n) {
        return InvokeDynamicSupport.bootstrap("getRootInActiveWindow", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getRootInActiveWindow(int ), 0, this, n);
    }

    public AccessibilityWindowInfo getWindow(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getWindow", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getWindow(int int ), 0, this, n, n2);
    }

    public List<AccessibilityWindowInfo> getWindows(int n) {
        return InvokeDynamicSupport.bootstrap("getWindows", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getWindows(int ), 0, this, n);
    }

    public AccessibilityNodeInfo findAccessibilityNodeInfoByAccessibilityId(int n, int n2, long l, boolean bl, int n3, Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfoByAccessibilityId", $$robo$$android_view_accessibility_AccessibilityInteractionClient$findAccessibilityNodeInfoByAccessibilityId(int int long boolean int android.os.Bundle ), 0, this, n, n2, l, bl, n3, bundle);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByViewId(int n, int n2, long l, String string2) {
        return InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByViewId", $$robo$$android_view_accessibility_AccessibilityInteractionClient$findAccessibilityNodeInfosByViewId(int int long java.lang.String ), 0, this, n, n2, l, string2);
    }

    public List<AccessibilityNodeInfo> findAccessibilityNodeInfosByText(int n, int n2, long l, String string2) {
        return InvokeDynamicSupport.bootstrap("findAccessibilityNodeInfosByText", $$robo$$android_view_accessibility_AccessibilityInteractionClient$findAccessibilityNodeInfosByText(int int long java.lang.String ), 0, this, n, n2, l, string2);
    }

    public AccessibilityNodeInfo findFocus(int n, int n2, long l, int n3) {
        return InvokeDynamicSupport.bootstrap("findFocus", $$robo$$android_view_accessibility_AccessibilityInteractionClient$findFocus(int int long int ), 0, this, n, n2, l, n3);
    }

    public AccessibilityNodeInfo focusSearch(int n, int n2, long l, int n3) {
        return InvokeDynamicSupport.bootstrap("focusSearch", $$robo$$android_view_accessibility_AccessibilityInteractionClient$focusSearch(int int long int ), 0, this, n, n2, l, n3);
    }

    public boolean performAccessibilityAction(int n, int n2, long l, int n3, Bundle bundle) {
        return (boolean)InvokeDynamicSupport.bootstrap("performAccessibilityAction", $$robo$$android_view_accessibility_AccessibilityInteractionClient$performAccessibilityAction(int int long int android.os.Bundle ), 0, this, n, n2, l, n3, bundle);
    }

    public void clearCache() {
        InvokeDynamicSupport.bootstrap("clearCache", $$robo$$android_view_accessibility_AccessibilityInteractionClient$clearCache(), 0, this);
    }

    public void onAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        InvokeDynamicSupport.bootstrap("onAccessibilityEvent", $$robo$$android_view_accessibility_AccessibilityInteractionClient$onAccessibilityEvent(android.view.accessibility.AccessibilityEvent ), 0, this, accessibilityEvent);
    }

    private AccessibilityNodeInfo getFindAccessibilityNodeInfoResultAndClear(int n) {
        return InvokeDynamicSupport.bootstrap("getFindAccessibilityNodeInfoResultAndClear", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getFindAccessibilityNodeInfoResultAndClear(int ), 0, this, n);
    }

    @Override
    public void setFindAccessibilityNodeInfoResult(AccessibilityNodeInfo accessibilityNodeInfo, int n) {
        InvokeDynamicSupport.bootstrap("setFindAccessibilityNodeInfoResult", $$robo$$android_view_accessibility_AccessibilityInteractionClient$setFindAccessibilityNodeInfoResult(android.view.accessibility.AccessibilityNodeInfo int ), 0, this, accessibilityNodeInfo, n);
    }

    private List<AccessibilityNodeInfo> getFindAccessibilityNodeInfosResultAndClear(int n) {
        return InvokeDynamicSupport.bootstrap("getFindAccessibilityNodeInfosResultAndClear", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getFindAccessibilityNodeInfosResultAndClear(int ), 0, this, n);
    }

    @Override
    public void setFindAccessibilityNodeInfosResult(List<AccessibilityNodeInfo> list, int n) {
        InvokeDynamicSupport.bootstrap("setFindAccessibilityNodeInfosResult", $$robo$$android_view_accessibility_AccessibilityInteractionClient$setFindAccessibilityNodeInfosResult(java.util.List<android.view.accessibility.AccessibilityNodeInfo> int ), 0, this, list, n);
    }

    private boolean getPerformAccessibilityActionResultAndClear(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getPerformAccessibilityActionResultAndClear", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getPerformAccessibilityActionResultAndClear(int ), 0, this, n);
    }

    @Override
    public void setPerformAccessibilityActionResult(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setPerformAccessibilityActionResult", $$robo$$android_view_accessibility_AccessibilityInteractionClient$setPerformAccessibilityActionResult(boolean int ), 0, this, bl, n);
    }

    private void clearResultLocked() {
        InvokeDynamicSupport.bootstrap("clearResultLocked", $$robo$$android_view_accessibility_AccessibilityInteractionClient$clearResultLocked(), 0, this);
    }

    private boolean waitForResultTimedLocked(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("waitForResultTimedLocked", $$robo$$android_view_accessibility_AccessibilityInteractionClient$waitForResultTimedLocked(int ), 0, this, n);
    }

    private void finalizeAndCacheAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo, int n) {
        InvokeDynamicSupport.bootstrap("finalizeAndCacheAccessibilityNodeInfo", $$robo$$android_view_accessibility_AccessibilityInteractionClient$finalizeAndCacheAccessibilityNodeInfo(android.view.accessibility.AccessibilityNodeInfo int ), 0, this, accessibilityNodeInfo, n);
    }

    private void finalizeAndCacheAccessibilityNodeInfos(List<AccessibilityNodeInfo> list, int n) {
        InvokeDynamicSupport.bootstrap("finalizeAndCacheAccessibilityNodeInfos", $$robo$$android_view_accessibility_AccessibilityInteractionClient$finalizeAndCacheAccessibilityNodeInfos(java.util.List<android.view.accessibility.AccessibilityNodeInfo> int ), 0, this, list, n);
    }

    private Message getSameProcessMessageAndClear() {
        return InvokeDynamicSupport.bootstrap("getSameProcessMessageAndClear", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getSameProcessMessageAndClear(), 0, this);
    }

    public IAccessibilityServiceConnection getConnection(int n) {
        return InvokeDynamicSupport.bootstrap("getConnection", $$robo$$android_view_accessibility_AccessibilityInteractionClient$getConnection(int ), 0, this, n);
    }

    public void addConnection(int n, IAccessibilityServiceConnection iAccessibilityServiceConnection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$android_view_accessibility_AccessibilityInteractionClient$addConnection(int android.accessibilityservice.IAccessibilityServiceConnection ), 0, this, n, iAccessibilityServiceConnection);
    }

    public void removeConnection(int n) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$android_view_accessibility_AccessibilityInteractionClient$removeConnection(int ), 0, this, n);
    }

    private void checkFindAccessibilityNodeInfoResultIntegrity(List<AccessibilityNodeInfo> list) {
        InvokeDynamicSupport.bootstrap("checkFindAccessibilityNodeInfoResultIntegrity", $$robo$$android_view_accessibility_AccessibilityInteractionClient$checkFindAccessibilityNodeInfoResultIntegrity(java.util.List<android.view.accessibility.AccessibilityNodeInfo> ), 0, this, list);
    }

    static {
        RobolectricInternals.classInitializing(AccessibilityInteractionClient.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AccessibilityInteractionClient)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

