/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.annotation.IntDef;
import android.app.ActivityManager;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.drawable.AnimatedVectorDrawable;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.Trace;
import android.util.Log;
import android.view.Choreographer;
import android.view.DisplayListCanvas;
import android.view.FrameMetricsObserver;
import android.view.HardwareLayer;
import android.view.IGraphicsStats;
import android.view.IGraphicsStatsCallback;
import android.view.RenderNode;
import android.view.Surface;
import android.view.View;
import com.android.internal.R;
import com.android.internal.util.VirtualRefBasePtr;
import com.google.errorprone.annotations.DoNotMock;
import java.io.File;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ThreadedRenderer
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "ThreadedRenderer";
    private static String CACHE_PATH_SHADERS = "com.android.opengl.shaders_cache";
    public static String PROFILE_PROPERTY = "debug.hwui.profile";
    public static String PROFILE_PROPERTY_VISUALIZE_BARS = "visual_bars";
    static String PROFILE_MAXFRAMES_PROPERTY = "debug.hwui.profile.maxframes";
    static String PRINT_CONFIG_PROPERTY = "debug.hwui.print_config";
    public static String DEBUG_DIRTY_REGIONS_PROPERTY = "debug.hwui.show_dirty_regions";
    public static String DEBUG_SHOW_LAYERS_UPDATES_PROPERTY = "debug.hwui.show_layers_updates";
    public static String DEBUG_OVERDRAW_PROPERTY = "debug.hwui.overdraw";
    public static String OVERDRAW_PROPERTY_SHOW = "show";
    public static String DEBUG_RENDERER_PROPERTY = "debug.hwui.renderer";
    public static String DEBUG_SHOW_NON_RECTANGULAR_CLIP_PROPERTY = "debug.hwui.show_non_rect_clip";
    public static boolean sRendererDisabled;
    public static boolean sSystemRendererDisabled;
    public static boolean sTrimForeground;
    private static boolean sSupportsOpenGL;
    private static int SYNC_OK = 0;
    private static int SYNC_INVALIDATE_REQUIRED = 1;
    private static int SYNC_LOST_SURFACE_REWARD_IF_FOUND = 2;
    private static int SYNC_CONTEXT_IS_STOPPED = 4;
    private static String[] VISUALIZERS;
    private static int FLAG_DUMP_FRAMESTATS = 1;
    private static int FLAG_DUMP_RESET = 2;
    private int mWidth;
    private int mHeight;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mInsetTop;
    private int mInsetLeft;
    private boolean mHasInsets;
    private float mLightY;
    private float mLightZ;
    private float mLightRadius;
    private int mAmbientShadowAlpha;
    private int mSpotShadowAlpha;
    private long mNativeProxy;
    private boolean mInitialized;
    private RenderNode mRootNode;
    private Choreographer mChoreographer;
    private boolean mRootNodeNeedsUpdate;
    private boolean mEnabled;
    private boolean mRequested;
    private boolean mIsOpaque;

    private static final void $$robo$$android_view_ThreadedRenderer$disable(boolean system) {
        sRendererDisabled = true;
        if (system) {
            sSystemRendererDisabled = true;
        }
    }

    private static final void $$robo$$android_view_ThreadedRenderer$enableForegroundTrimming() {
        sTrimForeground = true;
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nSupportsOpenGL() {
        return false;
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$isAvailable() {
        return sSupportsOpenGL;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$setupDiskCache(File cacheDir) {
        ThreadedRenderer.setupShadersDiskCache(new File(cacheDir, "com.android.opengl.shaders_cache").getAbsolutePath());
    }

    private static final ThreadedRenderer $$robo$$android_view_ThreadedRenderer$create(Context context, boolean translucent, String name) {
        ThreadedRenderer renderer = null;
        if (ThreadedRenderer.isAvailable()) {
            renderer = new ThreadedRenderer(context, translucent, name);
        }
        return renderer;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$trimMemory(int level) {
        ThreadedRenderer.nTrimMemory(level);
    }

    private static final void $$robo$$android_view_ThreadedRenderer$overrideProperty(String name, String value) {
        if (name == null || value == null) {
            throw new IllegalArgumentException("name and value must be non-null");
        }
        ThreadedRenderer.nOverrideProperty(name, value);
    }

    private void $$robo$$android_view_ThreadedRenderer$__constructor__(Context context, boolean translucent, String name) {
        this.mInitialized = false;
        this.mRequested = true;
        this.mIsOpaque = false;
        TypedArray a = context.obtainStyledAttributes(null, R.styleable.Lighting, 0, 0);
        this.mLightY = a.getDimension(3, 0.0f);
        this.mLightZ = a.getDimension(4, 0.0f);
        this.mLightRadius = a.getDimension(2, 0.0f);
        this.mAmbientShadowAlpha = (int)(255.0f * a.getFloat(0, 0.0f) + 0.5f);
        this.mSpotShadowAlpha = (int)(255.0f * a.getFloat(1, 0.0f) + 0.5f);
        a.recycle();
        long rootNodePtr = ThreadedRenderer.nCreateRootRenderNode();
        this.mRootNode = RenderNode.adopt(rootNodePtr);
        this.mRootNode.setClipToBounds(false);
        this.mIsOpaque = !translucent;
        this.mNativeProxy = ThreadedRenderer.nCreateProxy(translucent, rootNodePtr);
        ThreadedRenderer.nSetName(this.mNativeProxy, name);
        ProcessInitializer.sInstance.init(context, this.mNativeProxy);
        this.loadSystemProperties();
    }

    private final void $$robo$$android_view_ThreadedRenderer$destroy() {
        this.mInitialized = false;
        this.updateEnabledState(null);
        ThreadedRenderer.nDestroy(this.mNativeProxy, this.mRootNode.mNativeRenderNode);
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$isEnabled() {
        return this.mEnabled;
    }

    private final void $$robo$$android_view_ThreadedRenderer$setEnabled(boolean enabled) {
        this.mEnabled = enabled;
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$isRequested() {
        return this.mRequested;
    }

    private final void $$robo$$android_view_ThreadedRenderer$setRequested(boolean requested) {
        this.mRequested = requested;
    }

    private final void $$robo$$android_view_ThreadedRenderer$updateEnabledState(Surface surface) {
        if (surface == null || !surface.isValid()) {
            this.setEnabled(false);
        } else {
            this.setEnabled(this.mInitialized);
        }
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$initialize(Surface surface) throws Surface.OutOfResourcesException {
        boolean status = !this.mInitialized;
        this.mInitialized = true;
        this.updateEnabledState(surface);
        ThreadedRenderer.nInitialize(this.mNativeProxy, surface);
        return status;
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$initializeIfNeeded(int width, int height, View.AttachInfo attachInfo, Surface surface, Rect surfaceInsets) throws Surface.OutOfResourcesException {
        if (this.isRequested() && !this.isEnabled() && this.initialize(surface)) {
            this.setup(width, height, attachInfo, surfaceInsets);
            return true;
        }
        return false;
    }

    private final void $$robo$$android_view_ThreadedRenderer$updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        this.updateEnabledState(surface);
        ThreadedRenderer.nUpdateSurface(this.mNativeProxy, surface);
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$pauseSurface(Surface surface) {
        return ThreadedRenderer.nPauseSurface(this.mNativeProxy, surface);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setStopped(boolean stopped) {
        ThreadedRenderer.nSetStopped(this.mNativeProxy, stopped);
    }

    private final void $$robo$$android_view_ThreadedRenderer$destroyHardwareResources(View view) {
        ThreadedRenderer.destroyResources(view);
        ThreadedRenderer.nDestroyHardwareResources(this.mNativeProxy);
    }

    private static final void $$robo$$android_view_ThreadedRenderer$destroyResources(View view) {
        view.destroyHardwareResources();
    }

    private final void $$robo$$android_view_ThreadedRenderer$detachSurfaceTexture(long hardwareLayer) {
        ThreadedRenderer.nDetachSurfaceTexture(this.mNativeProxy, hardwareLayer);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setup(int width, int height, View.AttachInfo attachInfo, Rect surfaceInsets) {
        this.mWidth = width;
        this.mHeight = height;
        if (surfaceInsets != null && (surfaceInsets.left != 0 || surfaceInsets.right != 0 || surfaceInsets.top != 0 || surfaceInsets.bottom != 0)) {
            this.mHasInsets = true;
            this.mInsetLeft = surfaceInsets.left;
            this.mInsetTop = surfaceInsets.top;
            this.mSurfaceWidth = width + this.mInsetLeft + surfaceInsets.right;
            this.mSurfaceHeight = height + this.mInsetTop + surfaceInsets.bottom;
            this.setOpaque(false);
        } else {
            this.mHasInsets = false;
            this.mInsetLeft = 0;
            this.mInsetTop = 0;
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
        }
        this.mRootNode.setLeftTopRightBottom(-this.mInsetLeft, -this.mInsetTop, this.mSurfaceWidth, this.mSurfaceHeight);
        ThreadedRenderer.nSetup(this.mNativeProxy, this.mLightRadius, this.mAmbientShadowAlpha, this.mSpotShadowAlpha);
        this.setLightCenter(attachInfo);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setLightCenter(View.AttachInfo attachInfo) {
        Point displaySize = attachInfo.mPoint;
        attachInfo.mDisplay.getRealSize(displaySize);
        float lightX = (float)displaySize.x / 2.0f - (float)attachInfo.mWindowLeft;
        float lightY = this.mLightY - (float)attachInfo.mWindowTop;
        ThreadedRenderer.nSetLightCenter(this.mNativeProxy, lightX, lightY, this.mLightZ);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setOpaque(boolean opaque) {
        this.mIsOpaque = opaque && !this.mHasInsets;
        ThreadedRenderer.nSetOpaque(this.mNativeProxy, this.mIsOpaque);
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$isOpaque() {
        return this.mIsOpaque;
    }

    private final int $$robo$$android_view_ThreadedRenderer$getWidth() {
        return this.mWidth;
    }

    private final int $$robo$$android_view_ThreadedRenderer$getHeight() {
        return this.mHeight;
    }

    private final void $$robo$$android_view_ThreadedRenderer$dumpGfxInfo(PrintWriter pw, FileDescriptor fd, String[] args) {
        pw.flush();
        int flags = 0;
        block8: for (int i = 0; i < args.length; ++i) {
            switch (args[i]) {
                case "framestats": {
                    flags |= 1;
                    continue block8;
                }
                case "reset": {
                    flags |= 2;
                }
            }
        }
        ThreadedRenderer.nDumpProfileInfo(this.mNativeProxy, fd, flags);
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$loadSystemProperties() {
        boolean changed = ThreadedRenderer.nLoadSystemProperties(this.mNativeProxy);
        if (changed) {
            this.invalidateRoot();
        }
        return changed;
    }

    private final void $$robo$$android_view_ThreadedRenderer$updateViewTreeDisplayList(View view) {
        view.mPrivateFlags |= 0x20;
        view.mRecreateDisplayList = (view.mPrivateFlags & Integer.MIN_VALUE) == Integer.MIN_VALUE;
        view.mPrivateFlags &= Integer.MAX_VALUE;
        view.updateDisplayListIfDirty();
        view.mRecreateDisplayList = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_ThreadedRenderer$updateRootDisplayList(View view, DrawCallbacks callbacks) {
        Trace.traceBegin(8L, "Record View#draw()");
        this.updateViewTreeDisplayList(view);
        if (this.mRootNodeNeedsUpdate || !this.mRootNode.isValid()) {
            DisplayListCanvas canvas = this.mRootNode.start(this.mSurfaceWidth, this.mSurfaceHeight);
            try {
                int saveCount = canvas.save();
                canvas.translate(this.mInsetLeft, this.mInsetTop);
                callbacks.onPreDraw(canvas);
                canvas.insertReorderBarrier();
                canvas.drawRenderNode(view.updateDisplayListIfDirty());
                canvas.insertInorderBarrier();
                callbacks.onPostDraw(canvas);
                canvas.restoreToCount(saveCount);
                this.mRootNodeNeedsUpdate = false;
            }
            finally {
                this.mRootNode.end(canvas);
            }
        }
        Trace.traceEnd(8L);
    }

    private final void $$robo$$android_view_ThreadedRenderer$addRenderNode(RenderNode node, boolean placeFront) {
        ThreadedRenderer.nAddRenderNode(this.mNativeProxy, node.mNativeRenderNode, placeFront);
    }

    private final void $$robo$$android_view_ThreadedRenderer$removeRenderNode(RenderNode node) {
        ThreadedRenderer.nRemoveRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    private final void $$robo$$android_view_ThreadedRenderer$drawRenderNode(RenderNode node) {
        ThreadedRenderer.nDrawRenderNode(this.mNativeProxy, node.mNativeRenderNode);
    }

    private final void $$robo$$android_view_ThreadedRenderer$setContentDrawBounds(int left, int top, int right, int bottom) {
        ThreadedRenderer.nSetContentDrawBounds(this.mNativeProxy, left, top, right, bottom);
    }

    private final void $$robo$$android_view_ThreadedRenderer$invalidateRoot() {
        this.mRootNodeNeedsUpdate = true;
    }

    private final void $$robo$$android_view_ThreadedRenderer$draw(View view, View.AttachInfo attachInfo, DrawCallbacks callbacks) {
        long[] frameInfo;
        int syncResult;
        attachInfo.mIgnoreDirtyState = true;
        Choreographer choreographer = attachInfo.mViewRootImpl.mChoreographer;
        choreographer.mFrameInfo.markDrawStart();
        this.updateRootDisplayList(view, callbacks);
        attachInfo.mIgnoreDirtyState = false;
        if (attachInfo.mPendingAnimatingRenderNodes != null) {
            int count = attachInfo.mPendingAnimatingRenderNodes.size();
            for (int i = 0; i < count; ++i) {
                this.registerAnimatingRenderNode(attachInfo.mPendingAnimatingRenderNodes.get(i));
            }
            attachInfo.mPendingAnimatingRenderNodes.clear();
            attachInfo.mPendingAnimatingRenderNodes = null;
        }
        if (((syncResult = ThreadedRenderer.nSyncAndDrawFrame(this.mNativeProxy, frameInfo = choreographer.mFrameInfo.mFrameInfo, frameInfo.length)) & 2) != 0) {
            this.setEnabled(false);
            attachInfo.mViewRootImpl.mSurface.release();
            attachInfo.mViewRootImpl.invalidate();
        }
        if ((syncResult & 1) != 0) {
            attachInfo.mViewRootImpl.invalidate();
        }
    }

    private static final void $$robo$$android_view_ThreadedRenderer$invokeFunctor(long functor, boolean waitForCompletion) {
        ThreadedRenderer.nInvokeFunctor(functor, waitForCompletion);
    }

    private final HardwareLayer $$robo$$android_view_ThreadedRenderer$createTextureLayer() {
        long layer = ThreadedRenderer.nCreateTextureLayer(this.mNativeProxy);
        return HardwareLayer.adoptTextureLayer(this, layer);
    }

    private final void $$robo$$android_view_ThreadedRenderer$buildLayer(RenderNode node) {
        ThreadedRenderer.nBuildLayer(this.mNativeProxy, node.getNativeDisplayList());
    }

    private final boolean $$robo$$android_view_ThreadedRenderer$copyLayerInto(HardwareLayer layer, Bitmap bitmap) {
        return ThreadedRenderer.nCopyLayerInto(this.mNativeProxy, layer.getDeferredLayerUpdater(), bitmap);
    }

    private final void $$robo$$android_view_ThreadedRenderer$pushLayerUpdate(HardwareLayer layer) {
        ThreadedRenderer.nPushLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    private final void $$robo$$android_view_ThreadedRenderer$onLayerDestroyed(HardwareLayer layer) {
        ThreadedRenderer.nCancelLayerUpdate(this.mNativeProxy, layer.getDeferredLayerUpdater());
    }

    private final void $$robo$$android_view_ThreadedRenderer$fence() {
        ThreadedRenderer.nFence(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$stopDrawing() {
        ThreadedRenderer.nStopDrawing(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$notifyFramePending() {
        ThreadedRenderer.nNotifyFramePending(this.mNativeProxy);
    }

    private final void $$robo$$android_view_ThreadedRenderer$registerAnimatingRenderNode(RenderNode animator2) {
        ThreadedRenderer.nRegisterAnimatingRenderNode(this.mRootNode.mNativeRenderNode, animator2.mNativeRenderNode);
    }

    private final void $$robo$$android_view_ThreadedRenderer$registerVectorDrawableAnimator(AnimatedVectorDrawable.VectorDrawableAnimatorRT animator2) {
        ThreadedRenderer.nRegisterVectorDrawableAnimator(this.mRootNode.mNativeRenderNode, animator2.getAnimatorNativePtr());
    }

    private final void $$robo$$android_view_ThreadedRenderer$serializeDisplayListTree() {
        ThreadedRenderer.nSerializeDisplayListTree(this.mNativeProxy);
    }

    private static final int $$robo$$android_view_ThreadedRenderer$copySurfaceInto(Surface surface, Rect srcRect, Bitmap bitmap) {
        if (srcRect == null) {
            return ThreadedRenderer.nCopySurfaceInto(surface, 0, 0, 0, 0, bitmap);
        }
        return ThreadedRenderer.nCopySurfaceInto(surface, srcRect.left, srcRect.top, srcRect.right, srcRect.bottom, bitmap);
    }

    private static final Bitmap $$robo$$android_view_ThreadedRenderer$createHardwareBitmap(RenderNode node, int width, int height) {
        return ThreadedRenderer.nCreateHardwareBitmap(node.getNativeDisplayList(), width, height);
    }

    private final void $$robo$$android_view_ThreadedRenderer$finalize() throws Throwable {
        try {
            ThreadedRenderer.nDeleteProxy(this.mNativeProxy);
            this.mNativeProxy = 0L;
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_view_ThreadedRenderer$addFrameMetricsObserver(FrameMetricsObserver observer) {
        long nativeObserver = ThreadedRenderer.nAddFrameMetricsObserver(this.mNativeProxy, observer);
        observer.mNative = new VirtualRefBasePtr(nativeObserver);
    }

    private final void $$robo$$android_view_ThreadedRenderer$removeFrameMetricsObserver(FrameMetricsObserver observer) {
        ThreadedRenderer.nRemoveFrameMetricsObserver(this.mNativeProxy, observer.mNative.get());
        observer.mNative = null;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$disableVsync() {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$setupShadersDiskCache(String string2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nRotateProcessStatsBuffer() {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetProcessStatsBuffer(int n) {
    }

    private static final int $$robo$$android_view_ThreadedRenderer$nGetRenderThreadTid(long l) {
        return 0;
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nCreateRootRenderNode() {
        return 0L;
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nCreateProxy(boolean bl, long l) {
        return 0L;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDeleteProxy(long l) {
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nLoadSystemProperties(long l) {
        return false;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetName(long l, String string2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nInitialize(long l, Surface surface) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nUpdateSurface(long l, Surface surface) {
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nPauseSurface(long l, Surface surface) {
        return false;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetStopped(long l, boolean bl) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetup(long l, float f, int n, int n2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetLightCenter(long l, float f, float f2, float f3) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetOpaque(long l, boolean bl) {
    }

    private static final int $$robo$$android_view_ThreadedRenderer$nSyncAndDrawFrame(long l, long[] lArray, int n) {
        return 0;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDestroy(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nRegisterAnimatingRenderNode(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nRegisterVectorDrawableAnimator(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nInvokeFunctor(long l, boolean bl) {
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nCreateTextureLayer(long l) {
        return 0L;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nBuildLayer(long l, long l2) {
    }

    private static final boolean $$robo$$android_view_ThreadedRenderer$nCopyLayerInto(long l, long l2, Bitmap bitmap) {
        return false;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nPushLayerUpdate(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nCancelLayerUpdate(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDetachSurfaceTexture(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDestroyHardwareResources(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nTrimMemory(int n) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nOverrideProperty(String string2, String string3) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nFence(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nStopDrawing(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nNotifyFramePending(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSerializeDisplayListTree(long l) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDumpProfileInfo(long l, FileDescriptor fileDescriptor, int n) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nAddRenderNode(long l, long l2, boolean bl) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nRemoveRenderNode(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nDrawRenderNode(long l, long l2) {
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nSetContentDrawBounds(long l, int n, int n2, int n3, int n4) {
    }

    private static final long $$robo$$android_view_ThreadedRenderer$nAddFrameMetricsObserver(long l, FrameMetricsObserver frameMetricsObserver) {
        return 0L;
    }

    private static final void $$robo$$android_view_ThreadedRenderer$nRemoveFrameMetricsObserver(long l, long l2) {
    }

    private static final int $$robo$$android_view_ThreadedRenderer$nCopySurfaceInto(Surface surface, int n, int n2, int n3, int n4, Bitmap bitmap) {
        return 0;
    }

    private static final Bitmap $$robo$$android_view_ThreadedRenderer$nCreateHardwareBitmap(long l, int n, int n2) {
        return null;
    }

    static void __staticInitializer__() {
        sRendererDisabled = false;
        sSystemRendererDisabled = false;
        sTrimForeground = false;
        sSupportsOpenGL = ThreadedRenderer.nSupportsOpenGL();
        VISUALIZERS = new String[]{"visual_bars"};
    }

    public static void disable(boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("disable", $$robo$$android_view_ThreadedRenderer$disable(boolean ), 0, (boolean)bl);
    }

    public static void enableForegroundTrimming() {
        InvokeDynamicSupport.bootstrapStatic("enableForegroundTrimming", $$robo$$android_view_ThreadedRenderer$enableForegroundTrimming(), 0);
    }

    private static final native /* synthetic */ boolean $$robo$$nSupportsOpenGL$nativeBinding();

    private static boolean nSupportsOpenGL() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nSupportsOpenGL", $$robo$$android_view_ThreadedRenderer$nSupportsOpenGL(), 1);
    }

    public static boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isAvailable", $$robo$$android_view_ThreadedRenderer$isAvailable(), 0);
    }

    public static void setupDiskCache(File file) {
        InvokeDynamicSupport.bootstrapStatic("setupDiskCache", $$robo$$android_view_ThreadedRenderer$setupDiskCache(java.io.File ), 0, (File)file);
    }

    public static ThreadedRenderer create(Context context, boolean bl, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("create", $$robo$$android_view_ThreadedRenderer$create(android.content.Context boolean java.lang.String ), 0, (Context)context, (boolean)bl, (String)string2);
    }

    public static void trimMemory(int n) {
        InvokeDynamicSupport.bootstrapStatic("trimMemory", $$robo$$android_view_ThreadedRenderer$trimMemory(int ), 0, (int)n);
    }

    public static void overrideProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("overrideProperty", $$robo$$android_view_ThreadedRenderer$overrideProperty(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void __constructor__(Context context, boolean bl, String string2) {
        this.$$robo$$android_view_ThreadedRenderer$__constructor__(context, bl, string2);
    }

    ThreadedRenderer(Context context, boolean bl, String string2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ThreadedRenderer$__constructor__(android.content.Context boolean java.lang.String ), 0, this, context, bl, string2);
    }

    void destroy() {
        InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_view_ThreadedRenderer$destroy(), 0, this);
    }

    boolean isEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isEnabled", $$robo$$android_view_ThreadedRenderer$isEnabled(), 0, this);
    }

    void setEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setEnabled", $$robo$$android_view_ThreadedRenderer$setEnabled(boolean ), 0, this, bl);
    }

    boolean isRequested() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRequested", $$robo$$android_view_ThreadedRenderer$isRequested(), 0, this);
    }

    void setRequested(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRequested", $$robo$$android_view_ThreadedRenderer$setRequested(boolean ), 0, this, bl);
    }

    private void updateEnabledState(Surface surface) {
        InvokeDynamicSupport.bootstrap("updateEnabledState", $$robo$$android_view_ThreadedRenderer$updateEnabledState(android.view.Surface ), 0, this, surface);
    }

    boolean initialize(Surface surface) throws Surface.OutOfResourcesException {
        return (boolean)InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_view_ThreadedRenderer$initialize(android.view.Surface ), 0, this, surface);
    }

    boolean initializeIfNeeded(int n, int n2, View.AttachInfo attachInfo, Surface surface, Rect rect) throws Surface.OutOfResourcesException {
        return (boolean)InvokeDynamicSupport.bootstrap("initializeIfNeeded", $$robo$$android_view_ThreadedRenderer$initializeIfNeeded(int int android.view.View$AttachInfo android.view.Surface android.graphics.Rect ), 0, this, n, n2, attachInfo, surface, rect);
    }

    void updateSurface(Surface surface) throws Surface.OutOfResourcesException {
        InvokeDynamicSupport.bootstrap("updateSurface", $$robo$$android_view_ThreadedRenderer$updateSurface(android.view.Surface ), 0, this, surface);
    }

    boolean pauseSurface(Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrap("pauseSurface", $$robo$$android_view_ThreadedRenderer$pauseSurface(android.view.Surface ), 0, this, surface);
    }

    void setStopped(boolean bl) {
        InvokeDynamicSupport.bootstrap("setStopped", $$robo$$android_view_ThreadedRenderer$setStopped(boolean ), 0, this, bl);
    }

    void destroyHardwareResources(View view) {
        InvokeDynamicSupport.bootstrap("destroyHardwareResources", $$robo$$android_view_ThreadedRenderer$destroyHardwareResources(android.view.View ), 0, this, view);
    }

    private static void destroyResources(View view) {
        InvokeDynamicSupport.bootstrapStatic("destroyResources", $$robo$$android_view_ThreadedRenderer$destroyResources(android.view.View ), 0, (View)view);
    }

    void detachSurfaceTexture(long l) {
        InvokeDynamicSupport.bootstrap("detachSurfaceTexture", $$robo$$android_view_ThreadedRenderer$detachSurfaceTexture(long ), 0, this, l);
    }

    void setup(int n, int n2, View.AttachInfo attachInfo, Rect rect) {
        InvokeDynamicSupport.bootstrap("setup", $$robo$$android_view_ThreadedRenderer$setup(int int android.view.View$AttachInfo android.graphics.Rect ), 0, this, n, n2, attachInfo, rect);
    }

    void setLightCenter(View.AttachInfo attachInfo) {
        InvokeDynamicSupport.bootstrap("setLightCenter", $$robo$$android_view_ThreadedRenderer$setLightCenter(android.view.View$AttachInfo ), 0, this, attachInfo);
    }

    void setOpaque(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOpaque", $$robo$$android_view_ThreadedRenderer$setOpaque(boolean ), 0, this, bl);
    }

    boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_view_ThreadedRenderer$isOpaque(), 0, this);
    }

    int getWidth() {
        return (int)InvokeDynamicSupport.bootstrap("getWidth", $$robo$$android_view_ThreadedRenderer$getWidth(), 0, this);
    }

    int getHeight() {
        return (int)InvokeDynamicSupport.bootstrap("getHeight", $$robo$$android_view_ThreadedRenderer$getHeight(), 0, this);
    }

    void dumpGfxInfo(PrintWriter printWriter, FileDescriptor fileDescriptor, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dumpGfxInfo", $$robo$$android_view_ThreadedRenderer$dumpGfxInfo(java.io.PrintWriter java.io.FileDescriptor java.lang.String[] ), 0, this, printWriter, fileDescriptor, stringArray);
    }

    boolean loadSystemProperties() {
        return (boolean)InvokeDynamicSupport.bootstrap("loadSystemProperties", $$robo$$android_view_ThreadedRenderer$loadSystemProperties(), 0, this);
    }

    private void updateViewTreeDisplayList(View view) {
        InvokeDynamicSupport.bootstrap("updateViewTreeDisplayList", $$robo$$android_view_ThreadedRenderer$updateViewTreeDisplayList(android.view.View ), 0, this, view);
    }

    private void updateRootDisplayList(View view, DrawCallbacks drawCallbacks) {
        InvokeDynamicSupport.bootstrap("updateRootDisplayList", $$robo$$android_view_ThreadedRenderer$updateRootDisplayList(android.view.View android.view.ThreadedRenderer$DrawCallbacks ), 0, this, view, drawCallbacks);
    }

    public void addRenderNode(RenderNode renderNode, boolean bl) {
        InvokeDynamicSupport.bootstrap("addRenderNode", $$robo$$android_view_ThreadedRenderer$addRenderNode(android.view.RenderNode boolean ), 0, this, renderNode, bl);
    }

    public void removeRenderNode(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("removeRenderNode", $$robo$$android_view_ThreadedRenderer$removeRenderNode(android.view.RenderNode ), 0, this, renderNode);
    }

    public void drawRenderNode(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("drawRenderNode", $$robo$$android_view_ThreadedRenderer$drawRenderNode(android.view.RenderNode ), 0, this, renderNode);
    }

    public void setContentDrawBounds(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("setContentDrawBounds", $$robo$$android_view_ThreadedRenderer$setContentDrawBounds(int int int int ), 0, this, n, n2, n3, n4);
    }

    void invalidateRoot() {
        InvokeDynamicSupport.bootstrap("invalidateRoot", $$robo$$android_view_ThreadedRenderer$invalidateRoot(), 0, this);
    }

    void draw(View view, View.AttachInfo attachInfo, DrawCallbacks drawCallbacks) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_view_ThreadedRenderer$draw(android.view.View android.view.View$AttachInfo android.view.ThreadedRenderer$DrawCallbacks ), 0, this, view, attachInfo, drawCallbacks);
    }

    static void invokeFunctor(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("invokeFunctor", $$robo$$android_view_ThreadedRenderer$invokeFunctor(long boolean ), 0, (long)l, (boolean)bl);
    }

    HardwareLayer createTextureLayer() {
        return InvokeDynamicSupport.bootstrap("createTextureLayer", $$robo$$android_view_ThreadedRenderer$createTextureLayer(), 0, this);
    }

    void buildLayer(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("buildLayer", $$robo$$android_view_ThreadedRenderer$buildLayer(android.view.RenderNode ), 0, this, renderNode);
    }

    boolean copyLayerInto(HardwareLayer hardwareLayer, Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrap("copyLayerInto", $$robo$$android_view_ThreadedRenderer$copyLayerInto(android.view.HardwareLayer android.graphics.Bitmap ), 0, this, hardwareLayer, bitmap);
    }

    void pushLayerUpdate(HardwareLayer hardwareLayer) {
        InvokeDynamicSupport.bootstrap("pushLayerUpdate", $$robo$$android_view_ThreadedRenderer$pushLayerUpdate(android.view.HardwareLayer ), 0, this, hardwareLayer);
    }

    void onLayerDestroyed(HardwareLayer hardwareLayer) {
        InvokeDynamicSupport.bootstrap("onLayerDestroyed", $$robo$$android_view_ThreadedRenderer$onLayerDestroyed(android.view.HardwareLayer ), 0, this, hardwareLayer);
    }

    void fence() {
        InvokeDynamicSupport.bootstrap("fence", $$robo$$android_view_ThreadedRenderer$fence(), 0, this);
    }

    void stopDrawing() {
        InvokeDynamicSupport.bootstrap("stopDrawing", $$robo$$android_view_ThreadedRenderer$stopDrawing(), 0, this);
    }

    public void notifyFramePending() {
        InvokeDynamicSupport.bootstrap("notifyFramePending", $$robo$$android_view_ThreadedRenderer$notifyFramePending(), 0, this);
    }

    void registerAnimatingRenderNode(RenderNode renderNode) {
        InvokeDynamicSupport.bootstrap("registerAnimatingRenderNode", $$robo$$android_view_ThreadedRenderer$registerAnimatingRenderNode(android.view.RenderNode ), 0, this, renderNode);
    }

    void registerVectorDrawableAnimator(AnimatedVectorDrawable.VectorDrawableAnimatorRT vectorDrawableAnimatorRT) {
        InvokeDynamicSupport.bootstrap("registerVectorDrawableAnimator", $$robo$$android_view_ThreadedRenderer$registerVectorDrawableAnimator(android.graphics.drawable.AnimatedVectorDrawable$VectorDrawableAnimatorRT ), 0, this, vectorDrawableAnimatorRT);
    }

    public void serializeDisplayListTree() {
        InvokeDynamicSupport.bootstrap("serializeDisplayListTree", $$robo$$android_view_ThreadedRenderer$serializeDisplayListTree(), 0, this);
    }

    public static int copySurfaceInto(Surface surface, Rect rect, Bitmap bitmap) {
        return (int)InvokeDynamicSupport.bootstrapStatic("copySurfaceInto", $$robo$$android_view_ThreadedRenderer$copySurfaceInto(android.view.Surface android.graphics.Rect android.graphics.Bitmap ), 0, (Surface)surface, (Rect)rect, (Bitmap)bitmap);
    }

    public static Bitmap createHardwareBitmap(RenderNode renderNode, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("createHardwareBitmap", $$robo$$android_view_ThreadedRenderer$createHardwareBitmap(android.view.RenderNode int int ), 0, (RenderNode)renderNode, (int)n, (int)n2);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_ThreadedRenderer$finalize(), 0, this);
    }

    void addFrameMetricsObserver(FrameMetricsObserver frameMetricsObserver) {
        InvokeDynamicSupport.bootstrap("addFrameMetricsObserver", $$robo$$android_view_ThreadedRenderer$addFrameMetricsObserver(android.view.FrameMetricsObserver ), 0, this, frameMetricsObserver);
    }

    void removeFrameMetricsObserver(FrameMetricsObserver frameMetricsObserver) {
        InvokeDynamicSupport.bootstrap("removeFrameMetricsObserver", $$robo$$android_view_ThreadedRenderer$removeFrameMetricsObserver(android.view.FrameMetricsObserver ), 0, this, frameMetricsObserver);
    }

    private static final native /* synthetic */ void $$robo$$disableVsync$nativeBinding();

    public static void disableVsync() {
        InvokeDynamicSupport.bootstrapStatic("disableVsync", $$robo$$android_view_ThreadedRenderer$disableVsync(), 1);
    }

    private static final native /* synthetic */ void $$robo$$setupShadersDiskCache$nativeBinding(String var0);

    static void setupShadersDiskCache(String string2) {
        InvokeDynamicSupport.bootstrapStatic("setupShadersDiskCache", $$robo$$android_view_ThreadedRenderer$setupShadersDiskCache(java.lang.String ), 1, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nRotateProcessStatsBuffer$nativeBinding();

    private static void nRotateProcessStatsBuffer() {
        InvokeDynamicSupport.bootstrapStatic("nRotateProcessStatsBuffer", $$robo$$android_view_ThreadedRenderer$nRotateProcessStatsBuffer(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nSetProcessStatsBuffer$nativeBinding(int var0);

    private static void nSetProcessStatsBuffer(int n) {
        InvokeDynamicSupport.bootstrapStatic("nSetProcessStatsBuffer", $$robo$$android_view_ThreadedRenderer$nSetProcessStatsBuffer(int ), 1, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nGetRenderThreadTid$nativeBinding(long var0);

    private static int nGetRenderThreadTid(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nGetRenderThreadTid", $$robo$$android_view_ThreadedRenderer$nGetRenderThreadTid(long ), 1, (long)l);
    }

    private static final native /* synthetic */ long $$robo$$nCreateRootRenderNode$nativeBinding();

    private static long nCreateRootRenderNode() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateRootRenderNode", $$robo$$android_view_ThreadedRenderer$nCreateRootRenderNode(), 1);
    }

    private static final native /* synthetic */ long $$robo$$nCreateProxy$nativeBinding(boolean var0, long var1);

    private static long nCreateProxy(boolean bl, long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateProxy", $$robo$$android_view_ThreadedRenderer$nCreateProxy(boolean long ), 1, (boolean)bl, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nDeleteProxy$nativeBinding(long var0);

    private static void nDeleteProxy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nDeleteProxy", $$robo$$android_view_ThreadedRenderer$nDeleteProxy(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nLoadSystemProperties$nativeBinding(long var0);

    private static boolean nLoadSystemProperties(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nLoadSystemProperties", $$robo$$android_view_ThreadedRenderer$nLoadSystemProperties(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSetName$nativeBinding(long var0, String var2);

    private static void nSetName(long l, String string2) {
        InvokeDynamicSupport.bootstrapStatic("nSetName", $$robo$$android_view_ThreadedRenderer$nSetName(long java.lang.String ), 1, (long)l, (String)string2);
    }

    private static final native /* synthetic */ void $$robo$$nInitialize$nativeBinding(long var0, Surface var2);

    private static void nInitialize(long l, Surface surface) {
        InvokeDynamicSupport.bootstrapStatic("nInitialize", $$robo$$android_view_ThreadedRenderer$nInitialize(long android.view.Surface ), 1, (long)l, (Surface)surface);
    }

    private static final native /* synthetic */ void $$robo$$nUpdateSurface$nativeBinding(long var0, Surface var2);

    private static void nUpdateSurface(long l, Surface surface) {
        InvokeDynamicSupport.bootstrapStatic("nUpdateSurface", $$robo$$android_view_ThreadedRenderer$nUpdateSurface(long android.view.Surface ), 1, (long)l, (Surface)surface);
    }

    private static final native /* synthetic */ boolean $$robo$$nPauseSurface$nativeBinding(long var0, Surface var2);

    private static boolean nPauseSurface(long l, Surface surface) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nPauseSurface", $$robo$$android_view_ThreadedRenderer$nPauseSurface(long android.view.Surface ), 1, (long)l, (Surface)surface);
    }

    private static final native /* synthetic */ void $$robo$$nSetStopped$nativeBinding(long var0, boolean var2);

    private static void nSetStopped(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetStopped", $$robo$$android_view_ThreadedRenderer$nSetStopped(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nSetup$nativeBinding(long var0, float var2, int var3, int var4);

    private static void nSetup(long l, float f, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nSetup", $$robo$$android_view_ThreadedRenderer$nSetup(long float int int ), 1, (long)l, (float)f, (int)n, (int)n2);
    }

    private static final native /* synthetic */ void $$robo$$nSetLightCenter$nativeBinding(long var0, float var2, float var3, float var4);

    private static void nSetLightCenter(long l, float f, float f2, float f3) {
        InvokeDynamicSupport.bootstrapStatic("nSetLightCenter", $$robo$$android_view_ThreadedRenderer$nSetLightCenter(long float float float ), 1, (long)l, (float)f, (float)f2, (float)f3);
    }

    private static final native /* synthetic */ void $$robo$$nSetOpaque$nativeBinding(long var0, boolean var2);

    private static void nSetOpaque(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nSetOpaque", $$robo$$android_view_ThreadedRenderer$nSetOpaque(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ int $$robo$$nSyncAndDrawFrame$nativeBinding(long var0, long[] var2, int var3);

    private static int nSyncAndDrawFrame(long l, long[] lArray, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nSyncAndDrawFrame", $$robo$$android_view_ThreadedRenderer$nSyncAndDrawFrame(long long[] int ), 1, (long)l, (long[])lArray, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nDestroy$nativeBinding(long var0, long var2);

    private static void nDestroy(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDestroy", $$robo$$android_view_ThreadedRenderer$nDestroy(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nRegisterAnimatingRenderNode$nativeBinding(long var0, long var2);

    private static void nRegisterAnimatingRenderNode(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nRegisterAnimatingRenderNode", $$robo$$android_view_ThreadedRenderer$nRegisterAnimatingRenderNode(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nRegisterVectorDrawableAnimator$nativeBinding(long var0, long var2);

    private static void nRegisterVectorDrawableAnimator(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nRegisterVectorDrawableAnimator", $$robo$$android_view_ThreadedRenderer$nRegisterVectorDrawableAnimator(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nInvokeFunctor$nativeBinding(long var0, boolean var2);

    private static void nInvokeFunctor(long l, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nInvokeFunctor", $$robo$$android_view_ThreadedRenderer$nInvokeFunctor(long boolean ), 1, (long)l, (boolean)bl);
    }

    private static final native /* synthetic */ long $$robo$$nCreateTextureLayer$nativeBinding(long var0);

    private static long nCreateTextureLayer(long l) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nCreateTextureLayer", $$robo$$android_view_ThreadedRenderer$nCreateTextureLayer(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nBuildLayer$nativeBinding(long var0, long var2);

    private static void nBuildLayer(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nBuildLayer", $$robo$$android_view_ThreadedRenderer$nBuildLayer(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ boolean $$robo$$nCopyLayerInto$nativeBinding(long var0, long var2, Bitmap var4);

    private static boolean nCopyLayerInto(long l, long l2, Bitmap bitmap) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nCopyLayerInto", $$robo$$android_view_ThreadedRenderer$nCopyLayerInto(long long android.graphics.Bitmap ), 1, (long)l, (long)l2, (Bitmap)bitmap);
    }

    private static final native /* synthetic */ void $$robo$$nPushLayerUpdate$nativeBinding(long var0, long var2);

    private static void nPushLayerUpdate(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nPushLayerUpdate", $$robo$$android_view_ThreadedRenderer$nPushLayerUpdate(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nCancelLayerUpdate$nativeBinding(long var0, long var2);

    private static void nCancelLayerUpdate(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nCancelLayerUpdate", $$robo$$android_view_ThreadedRenderer$nCancelLayerUpdate(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nDetachSurfaceTexture$nativeBinding(long var0, long var2);

    private static void nDetachSurfaceTexture(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDetachSurfaceTexture", $$robo$$android_view_ThreadedRenderer$nDetachSurfaceTexture(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nDestroyHardwareResources$nativeBinding(long var0);

    private static void nDestroyHardwareResources(long l) {
        InvokeDynamicSupport.bootstrapStatic("nDestroyHardwareResources", $$robo$$android_view_ThreadedRenderer$nDestroyHardwareResources(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nTrimMemory$nativeBinding(int var0);

    private static void nTrimMemory(int n) {
        InvokeDynamicSupport.bootstrapStatic("nTrimMemory", $$robo$$android_view_ThreadedRenderer$nTrimMemory(int ), 1, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nOverrideProperty$nativeBinding(String var0, String var1);

    private static void nOverrideProperty(String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("nOverrideProperty", $$robo$$android_view_ThreadedRenderer$nOverrideProperty(java.lang.String java.lang.String ), 1, (String)string2, (String)string3);
    }

    private static final native /* synthetic */ void $$robo$$nFence$nativeBinding(long var0);

    private static void nFence(long l) {
        InvokeDynamicSupport.bootstrapStatic("nFence", $$robo$$android_view_ThreadedRenderer$nFence(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nStopDrawing$nativeBinding(long var0);

    private static void nStopDrawing(long l) {
        InvokeDynamicSupport.bootstrapStatic("nStopDrawing", $$robo$$android_view_ThreadedRenderer$nStopDrawing(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nNotifyFramePending$nativeBinding(long var0);

    private static void nNotifyFramePending(long l) {
        InvokeDynamicSupport.bootstrapStatic("nNotifyFramePending", $$robo$$android_view_ThreadedRenderer$nNotifyFramePending(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nSerializeDisplayListTree$nativeBinding(long var0);

    private static void nSerializeDisplayListTree(long l) {
        InvokeDynamicSupport.bootstrapStatic("nSerializeDisplayListTree", $$robo$$android_view_ThreadedRenderer$nSerializeDisplayListTree(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nDumpProfileInfo$nativeBinding(long var0, FileDescriptor var2, int var3);

    private static void nDumpProfileInfo(long l, FileDescriptor fileDescriptor, int n) {
        InvokeDynamicSupport.bootstrapStatic("nDumpProfileInfo", $$robo$$android_view_ThreadedRenderer$nDumpProfileInfo(long java.io.FileDescriptor int ), 1, (long)l, (FileDescriptor)fileDescriptor, (int)n);
    }

    private static final native /* synthetic */ void $$robo$$nAddRenderNode$nativeBinding(long var0, long var2, boolean var4);

    private static void nAddRenderNode(long l, long l2, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("nAddRenderNode", $$robo$$android_view_ThreadedRenderer$nAddRenderNode(long long boolean ), 1, (long)l, (long)l2, (boolean)bl);
    }

    private static final native /* synthetic */ void $$robo$$nRemoveRenderNode$nativeBinding(long var0, long var2);

    private static void nRemoveRenderNode(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nRemoveRenderNode", $$robo$$android_view_ThreadedRenderer$nRemoveRenderNode(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nDrawRenderNode$nativeBinding(long var0, long var2);

    private static void nDrawRenderNode(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nDrawRenderNode", $$robo$$android_view_ThreadedRenderer$nDrawRenderNode(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ void $$robo$$nSetContentDrawBounds$nativeBinding(long var0, int var2, int var3, int var4, int var5);

    private static void nSetContentDrawBounds(long l, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrapStatic("nSetContentDrawBounds", $$robo$$android_view_ThreadedRenderer$nSetContentDrawBounds(long int int int int ), 1, (long)l, (int)n, (int)n2, (int)n3, (int)n4);
    }

    private static final native /* synthetic */ long $$robo$$nAddFrameMetricsObserver$nativeBinding(long var0, FrameMetricsObserver var2);

    private static long nAddFrameMetricsObserver(long l, FrameMetricsObserver frameMetricsObserver) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nAddFrameMetricsObserver", $$robo$$android_view_ThreadedRenderer$nAddFrameMetricsObserver(long android.view.FrameMetricsObserver ), 1, (long)l, (FrameMetricsObserver)frameMetricsObserver);
    }

    private static final native /* synthetic */ void $$robo$$nRemoveFrameMetricsObserver$nativeBinding(long var0, long var2);

    private static void nRemoveFrameMetricsObserver(long l, long l2) {
        InvokeDynamicSupport.bootstrapStatic("nRemoveFrameMetricsObserver", $$robo$$android_view_ThreadedRenderer$nRemoveFrameMetricsObserver(long long ), 1, (long)l, (long)l2);
    }

    private static final native /* synthetic */ int $$robo$$nCopySurfaceInto$nativeBinding(Surface var0, int var1, int var2, int var3, int var4, Bitmap var5);

    private static int nCopySurfaceInto(Surface surface, int n, int n2, int n3, int n4, Bitmap bitmap) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nCopySurfaceInto", $$robo$$android_view_ThreadedRenderer$nCopySurfaceInto(android.view.Surface int int int int android.graphics.Bitmap ), 1, (Surface)surface, (int)n, (int)n2, (int)n3, (int)n4, (Bitmap)bitmap);
    }

    private static final native /* synthetic */ Bitmap $$robo$$nCreateHardwareBitmap$nativeBinding(long var0, int var2, int var3);

    private static Bitmap nCreateHardwareBitmap(long l, int n, int n2) {
        return InvokeDynamicSupport.bootstrapStatic("nCreateHardwareBitmap", $$robo$$android_view_ThreadedRenderer$nCreateHardwareBitmap(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    static {
        RobolectricInternals.classInitializing(ThreadedRenderer.class);
    }

    public /* synthetic */ ThreadedRenderer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ThreadedRenderer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ProcessInitializer
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        static ProcessInitializer sInstance;
        private boolean mInitialized;
        private Context mAppContext;
        private IGraphicsStats mGraphicsStatsService;
        private IGraphicsStatsCallback mGraphicsStatsCallback;

        private void $$robo$$android_view_ThreadedRenderer_ProcessInitializer$__constructor__() {
            this.mInitialized = false;
            this.mGraphicsStatsCallback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ ProcessInitializer this$0;

                private void $$robo$$android_view_ThreadedRenderer_ProcessInitializer_1$__constructor__(ProcessInitializer this$0) {
                }

                private final void $$robo$$android_view_ThreadedRenderer_ProcessInitializer_1$onRotateGraphicsStatsBuffer() throws RemoteException {
                    this.this$0.rotateBuffer();
                }

                private void __constructor__(ProcessInitializer processInitializer) {
                    this.$$robo$$android_view_ThreadedRenderer_ProcessInitializer_1$__constructor__(processInitializer);
                }
                {
                    this.this$0 = processInitializer;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ThreadedRenderer_ProcessInitializer_1$__constructor__(android.view.ThreadedRenderer$ProcessInitializer ), 0, this, processInitializer);
                }

                @Override
                public void onRotateGraphicsStatsBuffer() throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onRotateGraphicsStatsBuffer", $$robo$$android_view_ThreadedRenderer_ProcessInitializer_1$onRotateGraphicsStatsBuffer(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private final synchronized void $$robo$$android_view_ThreadedRenderer_ProcessInitializer$init(Context context, long renderProxy) {
            if (this.mInitialized) {
                return;
            }
            this.mInitialized = true;
            this.mAppContext = context.getApplicationContext();
            this.initSched(context, renderProxy);
            this.initGraphicsStats();
        }

        private final void $$robo$$android_view_ThreadedRenderer_ProcessInitializer$initSched(Context context, long renderProxy) {
            try {
                int tid = ThreadedRenderer.nGetRenderThreadTid(renderProxy);
                ActivityManager.getService().setRenderThread(tid);
            }
            catch (Throwable t) {
                Log.w("ThreadedRenderer", "Failed to set scheduler for RenderThread", t);
            }
        }

        private final void $$robo$$android_view_ThreadedRenderer_ProcessInitializer$initGraphicsStats() {
            try {
                IBinder binder = ServiceManager.getService("graphicsstats");
                if (binder == null) {
                    return;
                }
                this.mGraphicsStatsService = IGraphicsStats.Stub.asInterface(binder);
                this.requestBuffer();
            }
            catch (Throwable t) {
                Log.w("ThreadedRenderer", "Could not acquire gfx stats buffer", t);
            }
        }

        private final void $$robo$$android_view_ThreadedRenderer_ProcessInitializer$rotateBuffer() {
            ThreadedRenderer.nRotateProcessStatsBuffer();
            this.requestBuffer();
        }

        private final void $$robo$$android_view_ThreadedRenderer_ProcessInitializer$requestBuffer() {
            try {
                String pkg = this.mAppContext.getApplicationInfo().packageName;
                ParcelFileDescriptor pfd = this.mGraphicsStatsService.requestBufferForProcess(pkg, this.mGraphicsStatsCallback);
                ThreadedRenderer.nSetProcessStatsBuffer(pfd.getFd());
                pfd.close();
            }
            catch (Throwable t) {
                Log.w("ThreadedRenderer", "Could not acquire gfx stats buffer", t);
            }
        }

        static void __staticInitializer__() {
            sInstance = new ProcessInitializer();
        }

        private void __constructor__() {
            this.$$robo$$android_view_ThreadedRenderer_ProcessInitializer$__constructor__();
        }

        private ProcessInitializer() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_ThreadedRenderer_ProcessInitializer$__constructor__(), 0, this);
        }

        synchronized void init(Context context, long l) {
            InvokeDynamicSupport.bootstrap("init", $$robo$$android_view_ThreadedRenderer_ProcessInitializer$init(android.content.Context long ), 0, this, context, l);
        }

        private void initSched(Context context, long l) {
            InvokeDynamicSupport.bootstrap("initSched", $$robo$$android_view_ThreadedRenderer_ProcessInitializer$initSched(android.content.Context long ), 0, this, context, l);
        }

        private void initGraphicsStats() {
            InvokeDynamicSupport.bootstrap("initGraphicsStats", $$robo$$android_view_ThreadedRenderer_ProcessInitializer$initGraphicsStats(), 0, this);
        }

        private void rotateBuffer() {
            InvokeDynamicSupport.bootstrap("rotateBuffer", $$robo$$android_view_ThreadedRenderer_ProcessInitializer$rotateBuffer(), 0, this);
        }

        private void requestBuffer() {
            InvokeDynamicSupport.bootstrap("requestBuffer", $$robo$$android_view_ThreadedRenderer_ProcessInitializer$requestBuffer(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(ProcessInitializer.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProcessInitializer)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    static interface DrawCallbacks
    extends InstrumentedInterface {
        public void onPreDraw(DisplayListCanvas var1);

        public void onPostDraw(DisplayListCanvas var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    public static @interface DumpFlags {
    }
}

