/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.DisplayListCanvas;
import android.view.HardwareLayer;
import android.view.View;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextureView
extends View
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "TextureView";
    private HardwareLayer mLayer;
    private SurfaceTexture mSurface;
    private SurfaceTextureListener mListener;
    private boolean mHadSurface;
    private boolean mOpaque;
    private Matrix mMatrix;
    private boolean mMatrixChanged;
    private Object[] mLock;
    private boolean mUpdateLayer;
    private boolean mUpdateSurface;
    private Canvas mCanvas;
    private int mSaveCount;
    private Object[] mNativeWindowLock;
    private long mNativeWindow;
    private SurfaceTexture.OnFrameAvailableListener mUpdateListener;

    private void $$robo$$android_view_TextureView$__constructor__(Context context) {
        this.mOpaque = true;
        this.mMatrix = new Matrix();
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new SurfaceTexture.OnFrameAvailableListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextureView this$0;

            private void $$robo$$android_view_TextureView_1$__constructor__(TextureView this$0) {
            }

            private final void $$robo$$android_view_TextureView_1$onFrameAvailable(SurfaceTexture surfaceTexture) {
                this.this$0.updateLayer();
                this.this$0.invalidate();
            }

            private void __constructor__(TextureView textureView) {
                this.$$robo$$android_view_TextureView_1$__constructor__(textureView);
            }
            {
                this.this$0 = textureView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_TextureView_1$__constructor__(android.view.TextureView ), 0, this, textureView);
            }

            @Override
            public void onFrameAvailable(SurfaceTexture surfaceTexture) {
                InvokeDynamicSupport.bootstrap("onFrameAvailable", $$robo$$android_view_TextureView_1$onFrameAvailable(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void $$robo$$android_view_TextureView$__constructor__(Context context, AttributeSet attrs) {
        this.mOpaque = true;
        this.mMatrix = new Matrix();
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new /* invalid duplicate definition of identical inner class */;
    }

    private void $$robo$$android_view_TextureView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
        this.mOpaque = true;
        this.mMatrix = new Matrix();
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new /* invalid duplicate definition of identical inner class */;
    }

    private void $$robo$$android_view_TextureView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mOpaque = true;
        this.mMatrix = new Matrix();
        this.mLock = new Object[0];
        this.mNativeWindowLock = new Object[0];
        this.mUpdateListener = new /* invalid duplicate definition of identical inner class */;
    }

    private final boolean $$robo$$android_view_TextureView$isOpaque() {
        return this.mOpaque;
    }

    private final void $$robo$$android_view_TextureView$setOpaque(boolean opaque) {
        if (opaque != this.mOpaque) {
            this.mOpaque = opaque;
            if (this.mLayer != null) {
                this.updateLayerAndInvalidate();
            }
        }
    }

    private final void $$robo$$android_view_TextureView$onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isHardwareAccelerated()) {
            Log.w("TextureView", "A TextureView or a subclass can only be used with hardware acceleration enabled.");
        }
        if (this.mHadSurface) {
            this.invalidate(true);
            this.mHadSurface = false;
        }
    }

    private final void $$robo$$android_view_TextureView$onDetachedFromWindowInternal() {
        this.destroyHardwareLayer();
        this.releaseSurfaceTexture();
        super.onDetachedFromWindowInternal();
    }

    private final void $$robo$$android_view_TextureView$destroyHardwareResources() {
        super.destroyHardwareResources();
        this.destroyHardwareLayer();
    }

    private final void $$robo$$android_view_TextureView$destroyHardwareLayer() {
        if (this.mLayer != null) {
            this.mLayer.detachSurfaceTexture();
            this.mLayer.destroy();
            this.mLayer = null;
            this.mMatrixChanged = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_view_TextureView$releaseSurfaceTexture() {
        if (this.mSurface == null) return;
        boolean shouldRelease = true;
        if (this.mListener != null) {
            shouldRelease = this.mListener.onSurfaceTextureDestroyed(this.mSurface);
        }
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (this.mNativeWindowLock) {
            this.nDestroyNativeWindow();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (shouldRelease) {
                this.mSurface.release();
            }
            this.mSurface = null;
            this.mHadSurface = true;
            return;
        }
    }

    private final void $$robo$$android_view_TextureView$setLayerType(int layerType, Paint paint) {
        this.setLayerPaint(paint);
    }

    private final void $$robo$$android_view_TextureView$setLayerPaint(Paint paint) {
        if (paint != this.mLayerPaint) {
            this.mLayerPaint = paint;
            this.invalidate();
        }
    }

    private final int $$robo$$android_view_TextureView$getLayerType() {
        return 2;
    }

    private final void $$robo$$android_view_TextureView$buildLayer() {
    }

    private final void $$robo$$android_view_TextureView$setForeground(Drawable foreground) {
        if (foreground != null && !sTextureViewIgnoresDrawableSetters) {
            throw new UnsupportedOperationException("TextureView doesn't support displaying a foreground drawable");
        }
    }

    private final void $$robo$$android_view_TextureView$setBackgroundDrawable(Drawable background) {
        if (background != null && !sTextureViewIgnoresDrawableSetters) {
            throw new UnsupportedOperationException("TextureView doesn't support displaying a background drawable");
        }
    }

    private final void $$robo$$android_view_TextureView$draw(Canvas canvas) {
        this.mPrivateFlags = this.mPrivateFlags & 0xFF9FFFFF | 0x20;
        if (canvas.isHardwareAccelerated()) {
            DisplayListCanvas displayListCanvas = (DisplayListCanvas)canvas;
            HardwareLayer layer = this.getHardwareLayer();
            if (layer != null) {
                this.applyUpdate();
                this.applyTransformMatrix();
                this.mLayer.setLayerPaint(this.mLayerPaint);
                displayListCanvas.drawHardwareLayer(layer);
            }
        }
    }

    private final void $$robo$$android_view_TextureView$onDraw(Canvas canvas) {
    }

    private final void $$robo$$android_view_TextureView$onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mSurface != null) {
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.updateLayer();
            if (this.mListener != null) {
                this.mListener.onSurfaceTextureSizeChanged(this.mSurface, this.getWidth(), this.getHeight());
            }
        }
    }

    private final HardwareLayer $$robo$$android_view_TextureView$getHardwareLayer() {
        if (this.mLayer == null) {
            boolean createNewSurface;
            if (this.mAttachInfo == null || this.mAttachInfo.mThreadedRenderer == null) {
                return null;
            }
            this.mLayer = this.mAttachInfo.mThreadedRenderer.createTextureLayer();
            boolean bl = createNewSurface = this.mSurface == null;
            if (createNewSurface) {
                this.mSurface = new SurfaceTexture(false);
                this.nCreateNativeWindow(this.mSurface);
            }
            this.mLayer.setSurfaceTexture(this.mSurface);
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
            this.mSurface.setOnFrameAvailableListener(this.mUpdateListener, this.mAttachInfo.mHandler);
            if (this.mListener != null && createNewSurface) {
                this.mListener.onSurfaceTextureAvailable(this.mSurface, this.getWidth(), this.getHeight());
            }
            this.mLayer.setLayerPaint(this.mLayerPaint);
        }
        if (this.mUpdateSurface) {
            this.mUpdateSurface = false;
            this.updateLayer();
            this.mMatrixChanged = true;
            this.mLayer.setSurfaceTexture(this.mSurface);
            this.mSurface.setDefaultBufferSize(this.getWidth(), this.getHeight());
        }
        return this.mLayer;
    }

    private final void $$robo$$android_view_TextureView$onVisibilityChanged(View changedView, int visibility) {
        super.onVisibilityChanged(changedView, visibility);
        if (this.mSurface != null) {
            if (visibility == 0) {
                if (this.mLayer != null) {
                    this.mSurface.setOnFrameAvailableListener(this.mUpdateListener, this.mAttachInfo.mHandler);
                }
                this.updateLayerAndInvalidate();
            } else {
                this.mSurface.setOnFrameAvailableListener(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_TextureView$updateLayer() {
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            this.mUpdateLayer = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_TextureView$updateLayerAndInvalidate() {
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            this.mUpdateLayer = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.invalidate();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_TextureView$applyUpdate() {
        if (this.mLayer == null) {
            return;
        }
        Object[] objectArray = this.mLock;
        synchronized (this.mLock) {
            if (!this.mUpdateLayer) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.mUpdateLayer = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.mLayer.prepare(this.getWidth(), this.getHeight(), this.mOpaque);
            this.mLayer.updateSurfaceTexture();
            if (this.mListener != null) {
                this.mListener.onSurfaceTextureUpdated(this.mSurface);
            }
            return;
        }
    }

    private final void $$robo$$android_view_TextureView$setTransform(Matrix transform) {
        this.mMatrix.set(transform);
        this.mMatrixChanged = true;
        this.invalidateParentIfNeeded();
    }

    private final Matrix $$robo$$android_view_TextureView$getTransform(Matrix transform) {
        if (transform == null) {
            transform = new Matrix();
        }
        transform.set(this.mMatrix);
        return transform;
    }

    private final void $$robo$$android_view_TextureView$applyTransformMatrix() {
        if (this.mMatrixChanged && this.mLayer != null) {
            this.mLayer.setTransform(this.mMatrix);
            this.mMatrixChanged = false;
        }
    }

    private final Bitmap $$robo$$android_view_TextureView$getBitmap() {
        return this.getBitmap(this.getWidth(), this.getHeight());
    }

    private final Bitmap $$robo$$android_view_TextureView$getBitmap(int width, int height) {
        if (this.isAvailable() && width > 0 && height > 0) {
            return this.getBitmap(Bitmap.createBitmap(this.getResources().getDisplayMetrics(), width, height, Bitmap.Config.ARGB_8888));
        }
        return null;
    }

    private final Bitmap $$robo$$android_view_TextureView$getBitmap(Bitmap bitmap) {
        if (bitmap != null && this.isAvailable()) {
            this.applyUpdate();
            this.applyTransformMatrix();
            if (this.mLayer == null && this.mUpdateSurface) {
                this.getHardwareLayer();
            }
            if (this.mLayer != null) {
                this.mLayer.copyInto(bitmap);
            }
        }
        return bitmap;
    }

    private final boolean $$robo$$android_view_TextureView$isAvailable() {
        return this.mSurface != null;
    }

    private final Canvas $$robo$$android_view_TextureView$lockCanvas() {
        return this.lockCanvas(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Canvas $$robo$$android_view_TextureView$lockCanvas(Rect dirty) {
        if (!this.isAvailable()) {
            return null;
        }
        if (this.mCanvas == null) {
            this.mCanvas = new Canvas();
        }
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (this.mNativeWindowLock) {
            if (!TextureView.nLockCanvas(this.mNativeWindow, this.mCanvas, dirty)) {
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.mSaveCount = this.mCanvas.save();
            return this.mCanvas;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final void $$robo$$android_view_TextureView$unlockCanvasAndPost(Canvas canvas) {
        if (this.mCanvas == null || canvas != this.mCanvas) return;
        canvas.restoreToCount(this.mSaveCount);
        this.mSaveCount = 0;
        Object[] objectArray = this.mNativeWindowLock;
        synchronized (this.mNativeWindowLock) {
            TextureView.nUnlockCanvasAndPost(this.mNativeWindow, this.mCanvas);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private final SurfaceTexture $$robo$$android_view_TextureView$getSurfaceTexture() {
        return this.mSurface;
    }

    private final void $$robo$$android_view_TextureView$setSurfaceTexture(SurfaceTexture surfaceTexture) {
        if (surfaceTexture == null) {
            throw new NullPointerException("surfaceTexture must not be null");
        }
        if (surfaceTexture == this.mSurface) {
            throw new IllegalArgumentException("Trying to setSurfaceTexture to the same SurfaceTexture that's already set.");
        }
        if (surfaceTexture.isReleased()) {
            throw new IllegalArgumentException("Cannot setSurfaceTexture to a released SurfaceTexture");
        }
        if (this.mSurface != null) {
            this.nDestroyNativeWindow();
            this.mSurface.release();
        }
        this.mSurface = surfaceTexture;
        this.nCreateNativeWindow(this.mSurface);
        if ((this.mViewFlags & 0xC) == 0 && this.mLayer != null) {
            this.mSurface.setOnFrameAvailableListener(this.mUpdateListener, this.mAttachInfo.mHandler);
        }
        this.mUpdateSurface = true;
        this.invalidateParentIfNeeded();
    }

    private final SurfaceTextureListener $$robo$$android_view_TextureView$getSurfaceTextureListener() {
        return this.mListener;
    }

    private final void $$robo$$android_view_TextureView$setSurfaceTextureListener(SurfaceTextureListener listener) {
        this.mListener = listener;
    }

    private final void $$robo$$android_view_TextureView$nCreateNativeWindow(SurfaceTexture surfaceTexture) {
    }

    private final void $$robo$$android_view_TextureView$nDestroyNativeWindow() {
    }

    private static final boolean $$robo$$android_view_TextureView$nLockCanvas(long l, Canvas canvas, Rect rect) {
        return false;
    }

    private static final void $$robo$$android_view_TextureView$nUnlockCanvasAndPost(long l, Canvas canvas) {
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_TextureView$__constructor__(context);
    }

    public TextureView(Context context) {
        super(context);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_TextureView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_TextureView$__constructor__(context, attributeSet);
    }

    public TextureView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_TextureView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_view_TextureView$__constructor__(context, attributeSet, n);
    }

    public TextureView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_TextureView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_view_TextureView$__constructor__(context, attributeSet, n, n2);
    }

    public TextureView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_TextureView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    @Override
    public boolean isOpaque() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOpaque", $$robo$$android_view_TextureView$isOpaque(), 0, this);
    }

    public void setOpaque(boolean bl) {
        InvokeDynamicSupport.bootstrap("setOpaque", $$robo$$android_view_TextureView$setOpaque(boolean ), 0, this, bl);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_view_TextureView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onDetachedFromWindowInternal() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindowInternal", $$robo$$android_view_TextureView$onDetachedFromWindowInternal(), 0, this);
    }

    @Override
    protected void destroyHardwareResources() {
        InvokeDynamicSupport.bootstrap("destroyHardwareResources", $$robo$$android_view_TextureView$destroyHardwareResources(), 0, this);
    }

    private void destroyHardwareLayer() {
        InvokeDynamicSupport.bootstrap("destroyHardwareLayer", $$robo$$android_view_TextureView$destroyHardwareLayer(), 0, this);
    }

    private void releaseSurfaceTexture() {
        InvokeDynamicSupport.bootstrap("releaseSurfaceTexture", $$robo$$android_view_TextureView$releaseSurfaceTexture(), 0, this);
    }

    @Override
    public void setLayerType(int n, Paint paint) {
        InvokeDynamicSupport.bootstrap("setLayerType", $$robo$$android_view_TextureView$setLayerType(int android.graphics.Paint ), 0, this, n, paint);
    }

    @Override
    public void setLayerPaint(Paint paint) {
        InvokeDynamicSupport.bootstrap("setLayerPaint", $$robo$$android_view_TextureView$setLayerPaint(android.graphics.Paint ), 0, this, paint);
    }

    @Override
    public int getLayerType() {
        return (int)InvokeDynamicSupport.bootstrap("getLayerType", $$robo$$android_view_TextureView$getLayerType(), 0, this);
    }

    @Override
    public void buildLayer() {
        InvokeDynamicSupport.bootstrap("buildLayer", $$robo$$android_view_TextureView$buildLayer(), 0, this);
    }

    @Override
    public void setForeground(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setForeground", $$robo$$android_view_TextureView$setForeground(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void setBackgroundDrawable(Drawable drawable2) {
        InvokeDynamicSupport.bootstrap("setBackgroundDrawable", $$robo$$android_view_TextureView$setBackgroundDrawable(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_view_TextureView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("onDraw", $$robo$$android_view_TextureView$onDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void onSizeChanged(int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("onSizeChanged", $$robo$$android_view_TextureView$onSizeChanged(int int int int ), 0, this, n, n2, n3, n4);
    }

    HardwareLayer getHardwareLayer() {
        return InvokeDynamicSupport.bootstrap("getHardwareLayer", $$robo$$android_view_TextureView$getHardwareLayer(), 0, this);
    }

    @Override
    protected void onVisibilityChanged(View view, int n) {
        InvokeDynamicSupport.bootstrap("onVisibilityChanged", $$robo$$android_view_TextureView$onVisibilityChanged(android.view.View int ), 0, this, view, n);
    }

    private void updateLayer() {
        InvokeDynamicSupport.bootstrap("updateLayer", $$robo$$android_view_TextureView$updateLayer(), 0, this);
    }

    private void updateLayerAndInvalidate() {
        InvokeDynamicSupport.bootstrap("updateLayerAndInvalidate", $$robo$$android_view_TextureView$updateLayerAndInvalidate(), 0, this);
    }

    private void applyUpdate() {
        InvokeDynamicSupport.bootstrap("applyUpdate", $$robo$$android_view_TextureView$applyUpdate(), 0, this);
    }

    public void setTransform(Matrix matrix) {
        InvokeDynamicSupport.bootstrap("setTransform", $$robo$$android_view_TextureView$setTransform(android.graphics.Matrix ), 0, this, matrix);
    }

    public Matrix getTransform(Matrix matrix) {
        return InvokeDynamicSupport.bootstrap("getTransform", $$robo$$android_view_TextureView$getTransform(android.graphics.Matrix ), 0, this, matrix);
    }

    private void applyTransformMatrix() {
        InvokeDynamicSupport.bootstrap("applyTransformMatrix", $$robo$$android_view_TextureView$applyTransformMatrix(), 0, this);
    }

    public Bitmap getBitmap() {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_view_TextureView$getBitmap(), 0, this);
    }

    public Bitmap getBitmap(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_view_TextureView$getBitmap(int int ), 0, this, n, n2);
    }

    public Bitmap getBitmap(Bitmap bitmap) {
        return InvokeDynamicSupport.bootstrap("getBitmap", $$robo$$android_view_TextureView$getBitmap(android.graphics.Bitmap ), 0, this, bitmap);
    }

    public boolean isAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAvailable", $$robo$$android_view_TextureView$isAvailable(), 0, this);
    }

    public Canvas lockCanvas() {
        return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_view_TextureView$lockCanvas(), 0, this);
    }

    public Canvas lockCanvas(Rect rect) {
        return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_view_TextureView$lockCanvas(android.graphics.Rect ), 0, this, rect);
    }

    public void unlockCanvasAndPost(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("unlockCanvasAndPost", $$robo$$android_view_TextureView$unlockCanvasAndPost(android.graphics.Canvas ), 0, this, canvas);
    }

    public SurfaceTexture getSurfaceTexture() {
        return InvokeDynamicSupport.bootstrap("getSurfaceTexture", $$robo$$android_view_TextureView$getSurfaceTexture(), 0, this);
    }

    public void setSurfaceTexture(SurfaceTexture surfaceTexture) {
        InvokeDynamicSupport.bootstrap("setSurfaceTexture", $$robo$$android_view_TextureView$setSurfaceTexture(android.graphics.SurfaceTexture ), 0, this, surfaceTexture);
    }

    public SurfaceTextureListener getSurfaceTextureListener() {
        return InvokeDynamicSupport.bootstrap("getSurfaceTextureListener", $$robo$$android_view_TextureView$getSurfaceTextureListener(), 0, this);
    }

    public void setSurfaceTextureListener(SurfaceTextureListener surfaceTextureListener) {
        InvokeDynamicSupport.bootstrap("setSurfaceTextureListener", $$robo$$android_view_TextureView$setSurfaceTextureListener(android.view.TextureView$SurfaceTextureListener ), 0, this, surfaceTextureListener);
    }

    private final native /* synthetic */ void $$robo$$nCreateNativeWindow$nativeBinding(SurfaceTexture var1);

    private void nCreateNativeWindow(SurfaceTexture surfaceTexture) {
        InvokeDynamicSupport.bootstrap("nCreateNativeWindow", $$robo$$android_view_TextureView$nCreateNativeWindow(android.graphics.SurfaceTexture ), 1, this, surfaceTexture);
    }

    private final native /* synthetic */ void $$robo$$nDestroyNativeWindow$nativeBinding();

    private void nDestroyNativeWindow() {
        InvokeDynamicSupport.bootstrap("nDestroyNativeWindow", $$robo$$android_view_TextureView$nDestroyNativeWindow(), 1, this);
    }

    private static final native /* synthetic */ boolean $$robo$$nLockCanvas$nativeBinding(long var0, Canvas var2, Rect var3);

    private static boolean nLockCanvas(long l, Canvas canvas, Rect rect) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nLockCanvas", $$robo$$android_view_TextureView$nLockCanvas(long android.graphics.Canvas android.graphics.Rect ), 1, (long)l, (Canvas)canvas, (Rect)rect);
    }

    private static final native /* synthetic */ void $$robo$$nUnlockCanvasAndPost$nativeBinding(long var0, Canvas var2);

    private static void nUnlockCanvasAndPost(long l, Canvas canvas) {
        InvokeDynamicSupport.bootstrapStatic("nUnlockCanvasAndPost", $$robo$$android_view_TextureView$nUnlockCanvasAndPost(long android.graphics.Canvas ), 1, (long)l, (Canvas)canvas);
    }

    public /* synthetic */ TextureView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextureView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface SurfaceTextureListener
    extends InstrumentedInterface {
        public void onSurfaceTextureAvailable(SurfaceTexture var1, int var2, int var3);

        public void onSurfaceTextureSizeChanged(SurfaceTexture var1, int var2, int var3);

        public boolean onSurfaceTextureDestroyed(SurfaceTexture var1);

        public void onSurfaceTextureUpdated(SurfaceTexture var1);
    }
}

