/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.content.res.CompatibilityInfo;
import android.content.res.Configuration;
import android.graphics.Canvas;
import android.graphics.PixelFormat;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.SurfaceHolder;
import android.view.SurfaceSession;
import android.view.View;
import android.view.ViewRootImpl;
import android.view.ViewTreeObserver;
import com.android.internal.view.SurfaceCallbackHelper;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SurfaceView
extends View
implements ViewRootImpl.WindowStoppedCallback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SurfaceView";
    private static boolean DEBUG = false;
    ArrayList<SurfaceHolder.Callback> mCallbacks;
    int[] mLocation;
    ReentrantLock mSurfaceLock;
    Surface mSurface;
    boolean mDrawingStopped;
    boolean mDrawFinished;
    Rect mScreenRect;
    SurfaceSession mSurfaceSession;
    SurfaceControl mSurfaceControl;
    SurfaceControl mDeferredDestroySurfaceControl;
    Rect mTmpRect;
    Configuration mConfiguration;
    int mSubLayer;
    boolean mIsCreating;
    private volatile boolean mRtHandlingPositionUpdates;
    private ViewTreeObserver.OnScrollChangedListener mScrollChangedListener;
    private ViewTreeObserver.OnPreDrawListener mDrawListener;
    boolean mRequestedVisible;
    boolean mWindowVisibility;
    boolean mLastWindowVisibility;
    boolean mViewVisibility;
    boolean mWindowStopped;
    int mRequestedWidth;
    int mRequestedHeight;
    int mRequestedFormat;
    boolean mHaveFrame;
    boolean mSurfaceCreated;
    long mLastLockTime;
    boolean mVisible;
    int mWindowSpaceLeft;
    int mWindowSpaceTop;
    int mSurfaceWidth;
    int mSurfaceHeight;
    int mFormat;
    Rect mSurfaceFrame;
    int mLastSurfaceWidth;
    int mLastSurfaceHeight;
    private CompatibilityInfo.Translator mTranslator;
    private boolean mGlobalListenersAdded;
    private boolean mAttachedToWindow;
    private int mSurfaceFlags;
    private int mPendingReportDraws;
    private Rect mRTLastReportedPosition;
    private SurfaceHolder mSurfaceHolder;

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context) {
    }

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context, AttributeSet attrs) {
    }

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr) {
    }

    private void $$robo$$android_view_SurfaceView$__constructor__(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        this.mCallbacks = new ArrayList();
        this.mLocation = new int[2];
        this.mSurfaceLock = new ReentrantLock();
        this.mSurface = new Surface();
        this.mDrawingStopped = true;
        this.mDrawFinished = false;
        this.mScreenRect = new Rect();
        this.mTmpRect = new Rect();
        this.mConfiguration = new Configuration();
        this.mSubLayer = -2;
        this.mIsCreating = false;
        this.mRtHandlingPositionUpdates = false;
        this.mScrollChangedListener = new ViewTreeObserver.OnScrollChangedListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_1$__constructor__(SurfaceView this$0) {
            }

            private final void $$robo$$android_view_SurfaceView_1$onScrollChanged() {
                this.this$0.updateSurface();
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_1$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_1$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public void onScrollChanged() {
                InvokeDynamicSupport.bootstrap("onScrollChanged", $$robo$$android_view_SurfaceView_1$onScrollChanged(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mDrawListener = new ViewTreeObserver.OnPreDrawListener(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_2$__constructor__(SurfaceView this$0) {
            }

            private final boolean $$robo$$android_view_SurfaceView_2$onPreDraw() {
                this.this$0.mHaveFrame = this.this$0.getWidth() > 0 && this.this$0.getHeight() > 0;
                this.this$0.updateSurface();
                return true;
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_2$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_2$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public boolean onPreDraw() {
                return (boolean)InvokeDynamicSupport.bootstrap("onPreDraw", $$robo$$android_view_SurfaceView_2$onPreDraw(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRequestedVisible = false;
        this.mWindowVisibility = false;
        this.mLastWindowVisibility = false;
        this.mViewVisibility = false;
        this.mWindowStopped = false;
        this.mRequestedWidth = -1;
        this.mRequestedHeight = -1;
        this.mRequestedFormat = 4;
        this.mHaveFrame = false;
        this.mSurfaceCreated = false;
        this.mLastLockTime = 0L;
        this.mVisible = false;
        this.mWindowSpaceLeft = -1;
        this.mWindowSpaceTop = -1;
        this.mSurfaceWidth = -1;
        this.mSurfaceHeight = -1;
        this.mFormat = -1;
        this.mSurfaceFrame = new Rect();
        this.mLastSurfaceWidth = -1;
        this.mLastSurfaceHeight = -1;
        this.mSurfaceFlags = 4;
        this.mRTLastReportedPosition = new Rect();
        this.mSurfaceHolder = new SurfaceHolder(this){
            public transient /* synthetic */ Object __robo_data__;
            private static String LOG_TAG = "SurfaceHolder";
            /* synthetic */ SurfaceView this$0;

            private void $$robo$$android_view_SurfaceView_3$__constructor__(SurfaceView this$0) {
            }

            private final boolean $$robo$$android_view_SurfaceView_3$isCreating() {
                return this.this$0.mIsCreating;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_view_SurfaceView_3$addCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = this.this$0.mCallbacks;
                synchronized (arrayList) {
                    if (!this.this$0.mCallbacks.contains(callback)) {
                        this.this$0.mCallbacks.add(callback);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_view_SurfaceView_3$removeCallback(SurfaceHolder.Callback callback) {
                ArrayList<SurfaceHolder.Callback> arrayList = this.this$0.mCallbacks;
                synchronized (arrayList) {
                    this.this$0.mCallbacks.remove(callback);
                }
            }

            private final void $$robo$$android_view_SurfaceView_3$setFixedSize(int width, int height) {
                if (this.this$0.mRequestedWidth != width || this.this$0.mRequestedHeight != height) {
                    this.this$0.mRequestedWidth = width;
                    this.this$0.mRequestedHeight = height;
                    this.this$0.requestLayout();
                }
            }

            private final void $$robo$$android_view_SurfaceView_3$setSizeFromLayout() {
                if (this.this$0.mRequestedWidth != -1 || this.this$0.mRequestedHeight != -1) {
                    this.this$0.mRequestedHeight = -1;
                    this.this$0.mRequestedWidth = -1;
                    this.this$0.requestLayout();
                }
            }

            private final void $$robo$$android_view_SurfaceView_3$setFormat(int format) {
                if (format == -1) {
                    format = 4;
                }
                this.this$0.mRequestedFormat = format;
                if (this.this$0.mSurfaceControl != null) {
                    this.this$0.updateSurface();
                }
            }

            @Deprecated
            private final void $$robo$$android_view_SurfaceView_3$setType(int type) {
            }

            private final void $$robo$$android_view_SurfaceView_3$setKeepScreenOn(boolean screenOn) {
                this.this$0.runOnUiThread(() -> this.this$0.setKeepScreenOn(screenOn));
            }

            private final Canvas $$robo$$android_view_SurfaceView_3$lockCanvas() {
                return this.internalLockCanvas(null, false);
            }

            private final Canvas $$robo$$android_view_SurfaceView_3$lockCanvas(Rect inOutDirty) {
                return this.internalLockCanvas(inOutDirty, false);
            }

            private final Canvas $$robo$$android_view_SurfaceView_3$lockHardwareCanvas() {
                return this.internalLockCanvas(null, true);
            }

            private final Canvas $$robo$$android_view_SurfaceView_3$internalLockCanvas(Rect dirty, boolean hardware) {
                this.this$0.mSurfaceLock.lock();
                Canvas c = null;
                if (!this.this$0.mDrawingStopped && this.this$0.mSurfaceControl != null) {
                    try {
                        c = hardware ? this.this$0.mSurface.lockHardwareCanvas() : this.this$0.mSurface.lockCanvas(dirty);
                    }
                    catch (Exception e) {
                        Log.e("SurfaceHolder", "Exception locking surface", e);
                    }
                }
                if (c != null) {
                    this.this$0.mLastLockTime = SystemClock.uptimeMillis();
                    return c;
                }
                long nextTime = this.this$0.mLastLockTime + 100L;
                long now = SystemClock.uptimeMillis();
                if (nextTime > now) {
                    try {
                        Thread.sleep(nextTime - now);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    now = SystemClock.uptimeMillis();
                }
                this.this$0.mLastLockTime = now;
                this.this$0.mSurfaceLock.unlock();
                return null;
            }

            private final void $$robo$$android_view_SurfaceView_3$unlockCanvasAndPost(Canvas canvas) {
                this.this$0.mSurface.unlockCanvasAndPost(canvas);
                this.this$0.mSurfaceLock.unlock();
            }

            private final Surface $$robo$$android_view_SurfaceView_3$getSurface() {
                return this.this$0.mSurface;
            }

            private final Rect $$robo$$android_view_SurfaceView_3$getSurfaceFrame() {
                return this.this$0.mSurfaceFrame;
            }

            private void __constructor__(SurfaceView surfaceView) {
                this.$$robo$$android_view_SurfaceView_3$__constructor__(surfaceView);
            }
            {
                this.this$0 = surfaceView;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_3$__constructor__(android.view.SurfaceView ), 0, this, surfaceView);
            }

            @Override
            public boolean isCreating() {
                return (boolean)InvokeDynamicSupport.bootstrap("isCreating", $$robo$$android_view_SurfaceView_3$isCreating(), 0, this);
            }

            @Override
            public void addCallback(SurfaceHolder.Callback callback) {
                InvokeDynamicSupport.bootstrap("addCallback", $$robo$$android_view_SurfaceView_3$addCallback(android.view.SurfaceHolder$Callback ), 0, this, callback);
            }

            @Override
            public void removeCallback(SurfaceHolder.Callback callback) {
                InvokeDynamicSupport.bootstrap("removeCallback", $$robo$$android_view_SurfaceView_3$removeCallback(android.view.SurfaceHolder$Callback ), 0, this, callback);
            }

            @Override
            public void setFixedSize(int n, int n2) {
                InvokeDynamicSupport.bootstrap("setFixedSize", $$robo$$android_view_SurfaceView_3$setFixedSize(int int ), 0, this, n, n2);
            }

            @Override
            public void setSizeFromLayout() {
                InvokeDynamicSupport.bootstrap("setSizeFromLayout", $$robo$$android_view_SurfaceView_3$setSizeFromLayout(), 0, this);
            }

            @Override
            public void setFormat(int n) {
                InvokeDynamicSupport.bootstrap("setFormat", $$robo$$android_view_SurfaceView_3$setFormat(int ), 0, this, n);
            }

            @Override
            @Deprecated
            public void setType(int n) {
                InvokeDynamicSupport.bootstrap("setType", $$robo$$android_view_SurfaceView_3$setType(int ), 0, this, n);
            }

            @Override
            public void setKeepScreenOn(boolean bl) {
                InvokeDynamicSupport.bootstrap("setKeepScreenOn", $$robo$$android_view_SurfaceView_3$setKeepScreenOn(boolean ), 0, this, bl);
            }

            @Override
            public Canvas lockCanvas() {
                return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_view_SurfaceView_3$lockCanvas(), 0, this);
            }

            @Override
            public Canvas lockCanvas(Rect rect) {
                return InvokeDynamicSupport.bootstrap("lockCanvas", $$robo$$android_view_SurfaceView_3$lockCanvas(android.graphics.Rect ), 0, this, rect);
            }

            @Override
            public Canvas lockHardwareCanvas() {
                return InvokeDynamicSupport.bootstrap("lockHardwareCanvas", $$robo$$android_view_SurfaceView_3$lockHardwareCanvas(), 0, this);
            }

            private Canvas internalLockCanvas(Rect rect, boolean bl) {
                return InvokeDynamicSupport.bootstrap("internalLockCanvas", $$robo$$android_view_SurfaceView_3$internalLockCanvas(android.graphics.Rect boolean ), 0, this, rect, bl);
            }

            @Override
            public void unlockCanvasAndPost(Canvas canvas) {
                InvokeDynamicSupport.bootstrap("unlockCanvasAndPost", $$robo$$android_view_SurfaceView_3$unlockCanvasAndPost(android.graphics.Canvas ), 0, this, canvas);
            }

            @Override
            public Surface getSurface() {
                return InvokeDynamicSupport.bootstrap("getSurface", $$robo$$android_view_SurfaceView_3$getSurface(), 0, this);
            }

            @Override
            public Rect getSurfaceFrame() {
                return InvokeDynamicSupport.bootstrap("getSurfaceFrame", $$robo$$android_view_SurfaceView_3$getSurfaceFrame(), 0, this);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        this.mRenderNode.requestPositionUpdates(this);
        this.setWillNotDraw(true);
    }

    private final SurfaceHolder $$robo$$android_view_SurfaceView$getHolder() {
        return this.mSurfaceHolder;
    }

    private final void $$robo$$android_view_SurfaceView$updateRequestedVisibility() {
        this.mRequestedVisible = this.mViewVisibility && this.mWindowVisibility && !this.mWindowStopped;
    }

    private final void $$robo$$android_view_SurfaceView$windowStopped(boolean stopped) {
        this.mWindowStopped = stopped;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    private final void $$robo$$android_view_SurfaceView$onAttachedToWindow() {
        super.onAttachedToWindow();
        this.getViewRootImpl().addWindowStoppedCallback(this);
        this.mWindowStopped = false;
        this.mViewVisibility = this.getVisibility() == 0;
        this.updateRequestedVisibility();
        this.mAttachedToWindow = true;
        if (!this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.addOnScrollChangedListener(this.mScrollChangedListener);
            observer.addOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = true;
        }
    }

    private final void $$robo$$android_view_SurfaceView$onWindowVisibilityChanged(int visibility) {
        super.onWindowVisibilityChanged(visibility);
        this.mWindowVisibility = visibility == 0;
        this.updateRequestedVisibility();
        this.updateSurface();
    }

    private final void $$robo$$android_view_SurfaceView$setVisibility(int visibility) {
        boolean newRequestedVisible;
        super.setVisibility(visibility);
        this.mViewVisibility = visibility == 0;
        boolean bl = newRequestedVisible = this.mWindowVisibility && this.mViewVisibility && !this.mWindowStopped;
        if (newRequestedVisible != this.mRequestedVisible) {
            this.requestLayout();
        }
        this.mRequestedVisible = newRequestedVisible;
        this.updateSurface();
    }

    private final void $$robo$$android_view_SurfaceView$performDrawFinished() {
        if (this.mPendingReportDraws > 0) {
            this.mDrawFinished = true;
            if (this.mAttachedToWindow) {
                this.mParent.requestTransparentRegion(this);
                this.notifyDrawFinished();
                this.invalidate();
            }
        } else {
            Log.e("SurfaceView", System.identityHashCode(this) + "finished drawing but no pending report draw (extra call to draw completion runnable?)");
        }
    }

    private final void $$robo$$android_view_SurfaceView$notifyDrawFinished() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.pendingDrawFinished();
        }
        --this.mPendingReportDraws;
    }

    private final void $$robo$$android_view_SurfaceView$onDetachedFromWindow() {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot != null) {
            viewRoot.removeWindowStoppedCallback(this);
        }
        this.mAttachedToWindow = false;
        if (this.mGlobalListenersAdded) {
            ViewTreeObserver observer = this.getViewTreeObserver();
            observer.removeOnScrollChangedListener(this.mScrollChangedListener);
            observer.removeOnPreDrawListener(this.mDrawListener);
            this.mGlobalListenersAdded = false;
        }
        while (this.mPendingReportDraws > 0) {
            this.notifyDrawFinished();
        }
        this.mRequestedVisible = false;
        this.updateSurface();
        if (this.mSurfaceControl != null) {
            this.mSurfaceControl.destroy();
        }
        this.mSurfaceControl = null;
        this.mHaveFrame = false;
        super.onDetachedFromWindow();
    }

    private final void $$robo$$android_view_SurfaceView$onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int width = this.mRequestedWidth >= 0 ? SurfaceView.resolveSizeAndState(this.mRequestedWidth, widthMeasureSpec, 0) : SurfaceView.getDefaultSize(0, widthMeasureSpec);
        int height = this.mRequestedHeight >= 0 ? SurfaceView.resolveSizeAndState(this.mRequestedHeight, heightMeasureSpec, 0) : SurfaceView.getDefaultSize(0, heightMeasureSpec);
        this.setMeasuredDimension(width, height);
    }

    private final boolean $$robo$$android_view_SurfaceView$setFrame(int left, int top, int right, int bottom) {
        boolean result = super.setFrame(left, top, right, bottom);
        this.updateSurface();
        return result;
    }

    private final boolean $$robo$$android_view_SurfaceView$gatherTransparentRegion(Region region) {
        if (this.isAboveParent() || !this.mDrawFinished) {
            return super.gatherTransparentRegion(region);
        }
        boolean opaque = true;
        if ((this.mPrivateFlags & 0x80) == 0) {
            opaque = super.gatherTransparentRegion(region);
        } else if (region != null) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (w > 0 && h > 0) {
                this.getLocationInWindow(this.mLocation);
                int l = this.mLocation[0];
                int t = this.mLocation[1];
                region.op(l, t, l + w, t + h, Region.Op.UNION);
            }
        }
        if (PixelFormat.formatHasAlpha(this.mRequestedFormat)) {
            opaque = false;
        }
        return opaque;
    }

    private final void $$robo$$android_view_SurfaceView$draw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 0) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.draw(canvas);
    }

    private final void $$robo$$android_view_SurfaceView$dispatchDraw(Canvas canvas) {
        if (this.mDrawFinished && !this.isAboveParent() && (this.mPrivateFlags & 0x80) == 128) {
            canvas.drawColor(0, PorterDuff.Mode.CLEAR);
        }
        super.dispatchDraw(canvas);
    }

    private final void $$robo$$android_view_SurfaceView$setZOrderMediaOverlay(boolean isMediaOverlay) {
        this.mSubLayer = isMediaOverlay ? -1 : -2;
    }

    private final void $$robo$$android_view_SurfaceView$setZOrderOnTop(boolean onTop) {
        this.mSubLayer = onTop ? 1 : -2;
    }

    private final void $$robo$$android_view_SurfaceView$setSecure(boolean isSecure) {
        this.mSurfaceFlags = isSecure ? (this.mSurfaceFlags |= 0x80) : (this.mSurfaceFlags &= 0xFFFFFF7F);
    }

    private final void $$robo$$android_view_SurfaceView$updateOpaqueFlag() {
        this.mSurfaceFlags = !PixelFormat.formatHasAlpha(this.mRequestedFormat) ? (this.mSurfaceFlags |= 0x400) : (this.mSurfaceFlags &= 0xFFFFFBFF);
    }

    private final Rect $$robo$$android_view_SurfaceView$getParentSurfaceInsets() {
        ViewRootImpl root = this.getViewRootImpl();
        if (root == null) {
            return null;
        }
        return root.mWindowAttributes.surfaceInsets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_SurfaceView$updateSurface() {
        int myHeight;
        int myWidth;
        if (!this.mHaveFrame) {
            return;
        }
        ViewRootImpl viewRoot = this.getViewRootImpl();
        if (viewRoot == null || viewRoot.mSurface == null || !viewRoot.mSurface.isValid()) {
            return;
        }
        this.mTranslator = viewRoot.mTranslator;
        if (this.mTranslator != null) {
            this.mSurface.setCompatibilityTranslator(this.mTranslator);
        }
        if ((myWidth = this.mRequestedWidth) <= 0) {
            myWidth = this.getWidth();
        }
        if ((myHeight = this.mRequestedHeight) <= 0) {
            myHeight = this.getHeight();
        }
        boolean formatChanged = this.mFormat != this.mRequestedFormat;
        boolean visibleChanged = this.mVisible != this.mRequestedVisible;
        boolean creating = (this.mSurfaceControl == null || formatChanged || visibleChanged) && this.mRequestedVisible;
        boolean sizeChanged = this.mSurfaceWidth != myWidth || this.mSurfaceHeight != myHeight;
        boolean windowVisibleChanged = this.mWindowVisibility != this.mLastWindowVisibility;
        boolean redrawNeeded = false;
        if (creating || formatChanged || sizeChanged || visibleChanged || windowVisibleChanged) {
            this.getLocationInWindow(this.mLocation);
            try {
                boolean visible = this.mVisible = this.mRequestedVisible;
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mSurfaceWidth = myWidth;
                this.mSurfaceHeight = myHeight;
                this.mFormat = this.mRequestedFormat;
                this.mLastWindowVisibility = this.mWindowVisibility;
                this.mScreenRect.left = this.mWindowSpaceLeft;
                this.mScreenRect.top = this.mWindowSpaceTop;
                this.mScreenRect.right = this.mWindowSpaceLeft + this.getWidth();
                this.mScreenRect.bottom = this.mWindowSpaceTop + this.getHeight();
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                Rect surfaceInsets = this.getParentSurfaceInsets();
                this.mScreenRect.offset(surfaceInsets.left, surfaceInsets.top);
                if (creating) {
                    this.mSurfaceSession = new SurfaceSession(viewRoot.mSurface);
                    this.mDeferredDestroySurfaceControl = this.mSurfaceControl;
                    this.updateOpaqueFlag();
                    this.mSurfaceControl = new SurfaceControlWithBackground(this, this.mSurfaceSession, "SurfaceView - " + viewRoot.getTitle().toString(), this.mSurfaceWidth, this.mSurfaceHeight, this.mFormat, this.mSurfaceFlags);
                } else if (this.mSurfaceControl == null) {
                    return;
                }
                boolean realSizeChanged = false;
                this.mSurfaceLock.lock();
                try {
                    this.mDrawingStopped = !visible;
                    SurfaceControl.openTransaction();
                    try {
                        this.mSurfaceControl.setLayer(this.mSubLayer);
                        if (this.mViewVisibility) {
                            this.mSurfaceControl.show();
                        } else {
                            this.mSurfaceControl.hide();
                        }
                        if (sizeChanged || creating || !this.mRtHandlingPositionUpdates) {
                            this.mSurfaceControl.setPosition(this.mScreenRect.left, this.mScreenRect.top);
                            this.mSurfaceControl.setMatrix((float)this.mScreenRect.width() / (float)this.mSurfaceWidth, 0.0f, 0.0f, (float)this.mScreenRect.height() / (float)this.mSurfaceHeight);
                        }
                        if (sizeChanged) {
                            this.mSurfaceControl.setSize(this.mSurfaceWidth, this.mSurfaceHeight);
                        }
                    }
                    finally {
                        SurfaceControl.closeTransaction();
                    }
                    if (sizeChanged || creating) {
                        redrawNeeded = true;
                    }
                    this.mSurfaceFrame.left = 0;
                    this.mSurfaceFrame.top = 0;
                    if (this.mTranslator == null) {
                        this.mSurfaceFrame.right = this.mSurfaceWidth;
                        this.mSurfaceFrame.bottom = this.mSurfaceHeight;
                    } else {
                        float appInvertedScale = this.mTranslator.applicationInvertedScale;
                        this.mSurfaceFrame.right = (int)((float)this.mSurfaceWidth * appInvertedScale + 0.5f);
                        this.mSurfaceFrame.bottom = (int)((float)this.mSurfaceHeight * appInvertedScale + 0.5f);
                    }
                    int surfaceWidth = this.mSurfaceFrame.right;
                    int surfaceHeight = this.mSurfaceFrame.bottom;
                    realSizeChanged = this.mLastSurfaceWidth != surfaceWidth || this.mLastSurfaceHeight != surfaceHeight;
                    this.mLastSurfaceWidth = surfaceWidth;
                    this.mLastSurfaceHeight = surfaceHeight;
                }
                finally {
                    this.mSurfaceLock.unlock();
                }
                try {
                    redrawNeeded |= visible && !this.mDrawFinished;
                    SurfaceHolder.Callback[] callbacks = null;
                    boolean surfaceChanged = creating;
                    if (this.mSurfaceCreated && (surfaceChanged || !visible && visibleChanged)) {
                        this.mSurfaceCreated = false;
                        if (this.mSurface.isValid()) {
                            for (SurfaceHolder.Callback c : callbacks = this.getSurfaceCallbacks()) {
                                c.surfaceDestroyed(this.mSurfaceHolder);
                            }
                            if (this.mSurface.isValid()) {
                                this.mSurface.forceScopedDisconnect();
                            }
                        }
                    }
                    if (creating) {
                        this.mSurface.copyFrom(this.mSurfaceControl);
                    }
                    if (sizeChanged && this.getContext().getApplicationInfo().targetSdkVersion < 26) {
                        this.mSurface.createFrom(this.mSurfaceControl);
                    }
                    if (visible && this.mSurface.isValid()) {
                        if (!this.mSurfaceCreated && (surfaceChanged || visibleChanged)) {
                            this.mSurfaceCreated = true;
                            this.mIsCreating = true;
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceCreated(this.mSurfaceHolder);
                            }
                        }
                        if (creating || formatChanged || sizeChanged || visibleChanged || realSizeChanged) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            for (SurfaceHolder.Callback c : callbacks) {
                                c.surfaceChanged(this.mSurfaceHolder, this.mFormat, myWidth, myHeight);
                            }
                        }
                        if (redrawNeeded) {
                            if (callbacks == null) {
                                callbacks = this.getSurfaceCallbacks();
                            }
                            ++this.mPendingReportDraws;
                            viewRoot.drawPending();
                            SurfaceCallbackHelper sch = new SurfaceCallbackHelper(this::onDrawFinished);
                            sch.dispatchSurfaceRedrawNeededAsync(this.mSurfaceHolder, callbacks);
                        }
                    }
                }
                finally {
                    this.mIsCreating = false;
                    if (this.mSurfaceControl != null && !this.mSurfaceCreated) {
                        this.mSurface.release();
                        if (!this.mWindowStopped) {
                            this.mSurfaceControl.destroy();
                            this.mSurfaceControl = null;
                        }
                    }
                }
            }
            catch (Exception ex) {
                Log.e("SurfaceView", "Exception configuring surface", ex);
            }
        } else {
            boolean layoutSizeChanged;
            this.getLocationInSurface(this.mLocation);
            boolean positionChanged = this.mWindowSpaceLeft != this.mLocation[0] || this.mWindowSpaceTop != this.mLocation[1];
            boolean bl = layoutSizeChanged = this.getWidth() != this.mScreenRect.width() || this.getHeight() != this.mScreenRect.height();
            if (positionChanged || layoutSizeChanged) {
                this.mWindowSpaceLeft = this.mLocation[0];
                this.mWindowSpaceTop = this.mLocation[1];
                this.mLocation[0] = this.getWidth();
                this.mLocation[1] = this.getHeight();
                this.mScreenRect.set(this.mWindowSpaceLeft, this.mWindowSpaceTop, this.mLocation[0], this.mLocation[1]);
                if (this.mTranslator != null) {
                    this.mTranslator.translateRectInAppWindowToScreen(this.mScreenRect);
                }
                if (this.mSurfaceControl == null) {
                    return;
                }
                if (!this.isHardwareAccelerated() || !this.mRtHandlingPositionUpdates) {
                    try {
                        this.setParentSpaceRectangle(this.mScreenRect, -1L);
                    }
                    catch (Exception ex) {
                        Log.e("SurfaceView", "Exception configuring surface", ex);
                    }
                }
            }
        }
    }

    private final void $$robo$$android_view_SurfaceView$onDrawFinished() {
        if (this.mDeferredDestroySurfaceControl != null) {
            this.mDeferredDestroySurfaceControl.destroy();
            this.mDeferredDestroySurfaceControl = null;
        }
        this.runOnUiThread(() -> this.performDrawFinished());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_view_SurfaceView$setParentSpaceRectangle(Rect position, long frameNumber) {
        ViewRootImpl viewRoot = this.getViewRootImpl();
        SurfaceControl.openTransaction();
        try {
            if (frameNumber > 0L) {
                this.mSurfaceControl.deferTransactionUntil(viewRoot.mSurface, frameNumber);
            }
            this.mSurfaceControl.setPosition(position.left, position.top);
            this.mSurfaceControl.setMatrix((float)position.width() / (float)this.mSurfaceWidth, 0.0f, 0.0f, (float)position.height() / (float)this.mSurfaceHeight);
        }
        finally {
            SurfaceControl.closeTransaction();
        }
    }

    private final void $$robo$$android_view_SurfaceView$updateSurfacePosition_renderWorker(long frameNumber, int left, int top, int right, int bottom) {
        if (this.mSurfaceControl == null) {
            return;
        }
        this.mRtHandlingPositionUpdates = true;
        if (this.mRTLastReportedPosition.left == left && this.mRTLastReportedPosition.top == top && this.mRTLastReportedPosition.right == right && this.mRTLastReportedPosition.bottom == bottom) {
            return;
        }
        try {
            this.mRTLastReportedPosition.set(left, top, right, bottom);
            this.setParentSpaceRectangle(this.mRTLastReportedPosition, frameNumber);
        }
        catch (Exception ex) {
            Log.e("SurfaceView", "Exception from repositionChild", ex);
        }
    }

    private final void $$robo$$android_view_SurfaceView$surfacePositionLost_uiRtSync(long frameNumber) {
        this.mRTLastReportedPosition.setEmpty();
        if (this.mSurfaceControl == null) {
            return;
        }
        if (this.mRtHandlingPositionUpdates) {
            this.mRtHandlingPositionUpdates = false;
            if (!this.mScreenRect.isEmpty() && !this.mScreenRect.equals(this.mRTLastReportedPosition)) {
                try {
                    this.setParentSpaceRectangle(this.mScreenRect, frameNumber);
                }
                catch (Exception ex) {
                    Log.e("SurfaceView", "Exception configuring surface", ex);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final SurfaceHolder.Callback[] $$robo$$android_view_SurfaceView$getSurfaceCallbacks() {
        SurfaceHolder.Callback[] callbacks;
        ArrayList<SurfaceHolder.Callback> arrayList = this.mCallbacks;
        synchronized (arrayList) {
            callbacks = new SurfaceHolder.Callback[this.mCallbacks.size()];
            this.mCallbacks.toArray(callbacks);
        }
        return callbacks;
    }

    @Deprecated
    private final void $$robo$$android_view_SurfaceView$setWindowType(int type) {
        if (this.getContext().getApplicationInfo().targetSdkVersion >= 26) {
            throw new UnsupportedOperationException("SurfaceView#setWindowType() has never been a public API.");
        }
        if (type == 1000) {
            Log.e("SurfaceView", "If you are calling SurfaceView#setWindowType(TYPE_APPLICATION_PANEL) just to make the SurfaceView to be placed on top of its window, you must call setZOrderOnTop(true) instead.", new Throwable());
            this.setZOrderOnTop(true);
            return;
        }
        Log.e("SurfaceView", "SurfaceView#setWindowType(int) is deprecated and now does nothing. type=" + type, new Throwable());
    }

    private final void $$robo$$android_view_SurfaceView$runOnUiThread(Runnable runnable) {
        Handler handler = this.getHandler();
        if (handler != null && handler.getLooper() != Looper.myLooper()) {
            handler.post(runnable);
        } else {
            runnable.run();
        }
    }

    private final boolean $$robo$$android_view_SurfaceView$isFixedSize() {
        return this.mRequestedWidth != -1 || this.mRequestedHeight != -1;
    }

    private final boolean $$robo$$android_view_SurfaceView$isAboveParent() {
        return this.mSubLayer >= 0;
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context);
    }

    public SurfaceView(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context, attributeSet);
    }

    public SurfaceView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context, attributeSet, n);
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context android.util.AttributeSet int ), 0, this, context, attributeSet, n);
    }

    private void __constructor__(Context context, AttributeSet attributeSet, int n, int n2) {
        this.$$robo$$android_view_SurfaceView$__constructor__(context, attributeSet, n, n2);
    }

    public SurfaceView(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView$__constructor__(android.content.Context android.util.AttributeSet int int ), 0, this, context, attributeSet, n, n2);
    }

    public SurfaceHolder getHolder() {
        return InvokeDynamicSupport.bootstrap("getHolder", $$robo$$android_view_SurfaceView$getHolder(), 0, this);
    }

    private void updateRequestedVisibility() {
        InvokeDynamicSupport.bootstrap("updateRequestedVisibility", $$robo$$android_view_SurfaceView$updateRequestedVisibility(), 0, this);
    }

    @Override
    public void windowStopped(boolean bl) {
        InvokeDynamicSupport.bootstrap("windowStopped", $$robo$$android_view_SurfaceView$windowStopped(boolean ), 0, this, bl);
    }

    @Override
    protected void onAttachedToWindow() {
        InvokeDynamicSupport.bootstrap("onAttachedToWindow", $$robo$$android_view_SurfaceView$onAttachedToWindow(), 0, this);
    }

    @Override
    protected void onWindowVisibilityChanged(int n) {
        InvokeDynamicSupport.bootstrap("onWindowVisibilityChanged", $$robo$$android_view_SurfaceView$onWindowVisibilityChanged(int ), 0, this, n);
    }

    @Override
    public void setVisibility(int n) {
        InvokeDynamicSupport.bootstrap("setVisibility", $$robo$$android_view_SurfaceView$setVisibility(int ), 0, this, n);
    }

    private void performDrawFinished() {
        InvokeDynamicSupport.bootstrap("performDrawFinished", $$robo$$android_view_SurfaceView$performDrawFinished(), 0, this);
    }

    void notifyDrawFinished() {
        InvokeDynamicSupport.bootstrap("notifyDrawFinished", $$robo$$android_view_SurfaceView$notifyDrawFinished(), 0, this);
    }

    @Override
    protected void onDetachedFromWindow() {
        InvokeDynamicSupport.bootstrap("onDetachedFromWindow", $$robo$$android_view_SurfaceView$onDetachedFromWindow(), 0, this);
    }

    @Override
    protected void onMeasure(int n, int n2) {
        InvokeDynamicSupport.bootstrap("onMeasure", $$robo$$android_view_SurfaceView$onMeasure(int int ), 0, this, n, n2);
    }

    @Override
    protected boolean setFrame(int n, int n2, int n3, int n4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setFrame", $$robo$$android_view_SurfaceView$setFrame(int int int int ), 0, this, n, n2, n3, n4);
    }

    @Override
    public boolean gatherTransparentRegion(Region region) {
        return (boolean)InvokeDynamicSupport.bootstrap("gatherTransparentRegion", $$robo$$android_view_SurfaceView$gatherTransparentRegion(android.graphics.Region ), 0, this, region);
    }

    @Override
    public void draw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("draw", $$robo$$android_view_SurfaceView$draw(android.graphics.Canvas ), 0, this, canvas);
    }

    @Override
    protected void dispatchDraw(Canvas canvas) {
        InvokeDynamicSupport.bootstrap("dispatchDraw", $$robo$$android_view_SurfaceView$dispatchDraw(android.graphics.Canvas ), 0, this, canvas);
    }

    public void setZOrderMediaOverlay(boolean bl) {
        InvokeDynamicSupport.bootstrap("setZOrderMediaOverlay", $$robo$$android_view_SurfaceView$setZOrderMediaOverlay(boolean ), 0, this, bl);
    }

    public void setZOrderOnTop(boolean bl) {
        InvokeDynamicSupport.bootstrap("setZOrderOnTop", $$robo$$android_view_SurfaceView$setZOrderOnTop(boolean ), 0, this, bl);
    }

    public void setSecure(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSecure", $$robo$$android_view_SurfaceView$setSecure(boolean ), 0, this, bl);
    }

    private void updateOpaqueFlag() {
        InvokeDynamicSupport.bootstrap("updateOpaqueFlag", $$robo$$android_view_SurfaceView$updateOpaqueFlag(), 0, this);
    }

    private Rect getParentSurfaceInsets() {
        return InvokeDynamicSupport.bootstrap("getParentSurfaceInsets", $$robo$$android_view_SurfaceView$getParentSurfaceInsets(), 0, this);
    }

    protected void updateSurface() {
        InvokeDynamicSupport.bootstrap("updateSurface", $$robo$$android_view_SurfaceView$updateSurface(), 0, this);
    }

    private void onDrawFinished() {
        InvokeDynamicSupport.bootstrap("onDrawFinished", $$robo$$android_view_SurfaceView$onDrawFinished(), 0, this);
    }

    private void setParentSpaceRectangle(Rect rect, long l) {
        InvokeDynamicSupport.bootstrap("setParentSpaceRectangle", $$robo$$android_view_SurfaceView$setParentSpaceRectangle(android.graphics.Rect long ), 0, this, rect, l);
    }

    public void updateSurfacePosition_renderWorker(long l, int n, int n2, int n3, int n4) {
        InvokeDynamicSupport.bootstrap("updateSurfacePosition_renderWorker", $$robo$$android_view_SurfaceView$updateSurfacePosition_renderWorker(long int int int int ), 0, this, l, n, n2, n3, n4);
    }

    public void surfacePositionLost_uiRtSync(long l) {
        InvokeDynamicSupport.bootstrap("surfacePositionLost_uiRtSync", $$robo$$android_view_SurfaceView$surfacePositionLost_uiRtSync(long ), 0, this, l);
    }

    private SurfaceHolder.Callback[] getSurfaceCallbacks() {
        return InvokeDynamicSupport.bootstrap("getSurfaceCallbacks", $$robo$$android_view_SurfaceView$getSurfaceCallbacks(), 0, this);
    }

    @Deprecated
    public void setWindowType(int n) {
        InvokeDynamicSupport.bootstrap("setWindowType", $$robo$$android_view_SurfaceView$setWindowType(int ), 0, this, n);
    }

    private void runOnUiThread(Runnable runnable) {
        InvokeDynamicSupport.bootstrap("runOnUiThread", $$robo$$android_view_SurfaceView$runOnUiThread(java.lang.Runnable ), 0, this, runnable);
    }

    public boolean isFixedSize() {
        return (boolean)InvokeDynamicSupport.bootstrap("isFixedSize", $$robo$$android_view_SurfaceView$isFixedSize(), 0, this);
    }

    private boolean isAboveParent() {
        return (boolean)InvokeDynamicSupport.bootstrap("isAboveParent", $$robo$$android_view_SurfaceView$isAboveParent(), 0, this);
    }

    public /* synthetic */ SurfaceView() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceView)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class SurfaceControlWithBackground
    extends SurfaceControl
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private SurfaceControl mBackgroundControl;
        private boolean mOpaque;
        public boolean mVisible;
        /* synthetic */ SurfaceView this$0;

        private void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$__constructor__(SurfaceView this$0, SurfaceSession s, String name, int w, int h, int format, int flags) throws Exception {
            this.mOpaque = true;
            this.mVisible = false;
            this.mBackgroundControl = new SurfaceControl(s, "Background for - " + name, w, h, -1, flags | 0x20000);
            this.mOpaque = (flags & 0x400) != 0;
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setAlpha(float alpha) {
            super.setAlpha(alpha);
            this.mBackgroundControl.setAlpha(alpha);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setLayer(int zorder) {
            super.setLayer(zorder);
            this.mBackgroundControl.setLayer(-3);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setPosition(float x, float y) {
            super.setPosition(x, y);
            this.mBackgroundControl.setPosition(x, y);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setSize(int w, int h) {
            super.setSize(w, h);
            this.mBackgroundControl.setSize(w, h);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setWindowCrop(Rect crop) {
            super.setWindowCrop(crop);
            this.mBackgroundControl.setWindowCrop(crop);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setFinalCrop(Rect crop) {
            super.setFinalCrop(crop);
            this.mBackgroundControl.setFinalCrop(crop);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setLayerStack(int layerStack) {
            super.setLayerStack(layerStack);
            this.mBackgroundControl.setLayerStack(layerStack);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setOpaque(boolean isOpaque) {
            super.setOpaque(isOpaque);
            this.mOpaque = isOpaque;
            this.updateBackgroundVisibility();
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setSecure(boolean isSecure) {
            super.setSecure(isSecure);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setMatrix(float dsdx, float dtdx, float dsdy, float dtdy) {
            super.setMatrix(dsdx, dtdx, dsdy, dtdy);
            this.mBackgroundControl.setMatrix(dsdx, dtdx, dsdy, dtdy);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$hide() {
            super.hide();
            this.mVisible = false;
            this.updateBackgroundVisibility();
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$show() {
            super.show();
            this.mVisible = true;
            this.updateBackgroundVisibility();
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$destroy() {
            super.destroy();
            this.mBackgroundControl.destroy();
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$release() {
            super.release();
            this.mBackgroundControl.release();
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setTransparentRegionHint(Region region) {
            super.setTransparentRegionHint(region);
            this.mBackgroundControl.setTransparentRegionHint(region);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$deferTransactionUntil(IBinder handle, long frame) {
            super.deferTransactionUntil(handle, frame);
            this.mBackgroundControl.deferTransactionUntil(handle, frame);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$deferTransactionUntil(Surface barrier, long frame) {
            super.deferTransactionUntil(barrier, frame);
            this.mBackgroundControl.deferTransactionUntil(barrier, frame);
        }

        private final void $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$updateBackgroundVisibility() {
            if (this.mOpaque && this.mVisible) {
                this.mBackgroundControl.show();
            } else {
                this.mBackgroundControl.hide();
            }
        }

        private void __constructor__(SurfaceView surfaceView, SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4) throws Exception {
            this.$$robo$$android_view_SurfaceView_SurfaceControlWithBackground$__constructor__(surfaceView, surfaceSession, string2, n, n2, n3, n4);
        }

        public SurfaceControlWithBackground(SurfaceView surfaceView, SurfaceSession surfaceSession, String string2, int n, int n2, int n3, int n4) throws Exception {
            this.this$0 = surfaceView;
            super(surfaceSession, string2, n, n2, n3, n4);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$__constructor__(android.view.SurfaceView android.view.SurfaceSession java.lang.String int int int int ), 0, this, surfaceView, surfaceSession, string2, n, n2, n3, n4);
        }

        @Override
        public void setAlpha(float f) {
            InvokeDynamicSupport.bootstrap("setAlpha", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setAlpha(float ), 0, this, f);
        }

        @Override
        public void setLayer(int n) {
            InvokeDynamicSupport.bootstrap("setLayer", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setLayer(int ), 0, this, n);
        }

        @Override
        public void setPosition(float f, float f2) {
            InvokeDynamicSupport.bootstrap("setPosition", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setPosition(float float ), 0, this, f, f2);
        }

        @Override
        public void setSize(int n, int n2) {
            InvokeDynamicSupport.bootstrap("setSize", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setSize(int int ), 0, this, n, n2);
        }

        @Override
        public void setWindowCrop(Rect rect) {
            InvokeDynamicSupport.bootstrap("setWindowCrop", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setWindowCrop(android.graphics.Rect ), 0, this, rect);
        }

        @Override
        public void setFinalCrop(Rect rect) {
            InvokeDynamicSupport.bootstrap("setFinalCrop", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setFinalCrop(android.graphics.Rect ), 0, this, rect);
        }

        @Override
        public void setLayerStack(int n) {
            InvokeDynamicSupport.bootstrap("setLayerStack", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setLayerStack(int ), 0, this, n);
        }

        @Override
        public void setOpaque(boolean bl) {
            InvokeDynamicSupport.bootstrap("setOpaque", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setOpaque(boolean ), 0, this, bl);
        }

        @Override
        public void setSecure(boolean bl) {
            InvokeDynamicSupport.bootstrap("setSecure", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setSecure(boolean ), 0, this, bl);
        }

        @Override
        public void setMatrix(float f, float f2, float f3, float f4) {
            InvokeDynamicSupport.bootstrap("setMatrix", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setMatrix(float float float float ), 0, this, f, f2, f3, f4);
        }

        @Override
        public void hide() {
            InvokeDynamicSupport.bootstrap("hide", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$hide(), 0, this);
        }

        @Override
        public void show() {
            InvokeDynamicSupport.bootstrap("show", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$show(), 0, this);
        }

        @Override
        public void destroy() {
            InvokeDynamicSupport.bootstrap("destroy", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$destroy(), 0, this);
        }

        @Override
        public void release() {
            InvokeDynamicSupport.bootstrap("release", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$release(), 0, this);
        }

        @Override
        public void setTransparentRegionHint(Region region) {
            InvokeDynamicSupport.bootstrap("setTransparentRegionHint", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$setTransparentRegionHint(android.graphics.Region ), 0, this, region);
        }

        @Override
        public void deferTransactionUntil(IBinder iBinder, long l) {
            InvokeDynamicSupport.bootstrap("deferTransactionUntil", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$deferTransactionUntil(android.os.IBinder long ), 0, this, iBinder, l);
        }

        @Override
        public void deferTransactionUntil(Surface surface, long l) {
            InvokeDynamicSupport.bootstrap("deferTransactionUntil", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$deferTransactionUntil(android.view.Surface long ), 0, this, surface, l);
        }

        void updateBackgroundVisibility() {
            InvokeDynamicSupport.bootstrap("updateBackgroundVisibility", $$robo$$android_view_SurfaceView_SurfaceControlWithBackground$updateBackgroundVisibility(), 0, this);
        }

        public /* synthetic */ SurfaceControlWithBackground() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SurfaceControlWithBackground)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

