/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.util.Log;
import android.view.OrientationListener;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class OrientationEventListener
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "OrientationEventListener";
    private static boolean DEBUG = false;
    private static boolean localLOGV = false;
    private int mOrientation;
    private SensorManager mSensorManager;
    private boolean mEnabled;
    private int mRate;
    private Sensor mSensor;
    private SensorEventListener mSensorEventListener;
    private OrientationListener mOldListener;
    public static int ORIENTATION_UNKNOWN = -1;

    private void $$robo$$android_view_OrientationEventListener$__constructor__(Context context) {
    }

    private void $$robo$$android_view_OrientationEventListener$__constructor__(Context context, int rate) {
        this.mOrientation = -1;
        this.mEnabled = false;
        this.mSensorManager = (SensorManager)context.getSystemService("sensor");
        this.mRate = rate;
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        if (this.mSensor != null) {
            this.mSensorEventListener = new SensorEventListenerImpl(this);
        }
    }

    private final void $$robo$$android_view_OrientationEventListener$registerListener(OrientationListener lis) {
        this.mOldListener = lis;
    }

    private final void $$robo$$android_view_OrientationEventListener$enable() {
        if (this.mSensor == null) {
            Log.w("OrientationEventListener", "Cannot detect sensors. Not enabled");
            return;
        }
        if (!this.mEnabled) {
            this.mSensorManager.registerListener(this.mSensorEventListener, this.mSensor, this.mRate);
            this.mEnabled = true;
        }
    }

    private final void $$robo$$android_view_OrientationEventListener$disable() {
        if (this.mSensor == null) {
            Log.w("OrientationEventListener", "Cannot detect sensors. Invalid disable");
            return;
        }
        if (this.mEnabled) {
            this.mSensorManager.unregisterListener(this.mSensorEventListener);
            this.mEnabled = false;
        }
    }

    private final boolean $$robo$$android_view_OrientationEventListener$canDetectOrientation() {
        return this.mSensor != null;
    }

    public abstract void onOrientationChanged(int var1);

    private void __constructor__(Context context) {
        this.$$robo$$android_view_OrientationEventListener$__constructor__(context);
    }

    public OrientationEventListener(Context context) {
        this(context, 3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_OrientationEventListener$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_view_OrientationEventListener$__constructor__(context, n);
    }

    public OrientationEventListener(Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_OrientationEventListener$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    void registerListener(OrientationListener orientationListener) {
        InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_view_OrientationEventListener$registerListener(android.view.OrientationListener ), 0, this, orientationListener);
    }

    public void enable() {
        InvokeDynamicSupport.bootstrap("enable", $$robo$$android_view_OrientationEventListener$enable(), 0, this);
    }

    public void disable() {
        InvokeDynamicSupport.bootstrap("disable", $$robo$$android_view_OrientationEventListener$disable(), 0, this);
    }

    public boolean canDetectOrientation() {
        return (boolean)InvokeDynamicSupport.bootstrap("canDetectOrientation", $$robo$$android_view_OrientationEventListener$canDetectOrientation(), 0, this);
    }

    public /* synthetic */ OrientationEventListener() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (OrientationEventListener)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class SensorEventListenerImpl
    implements SensorEventListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int _DATA_X = 0;
        private static int _DATA_Y = 1;
        private static int _DATA_Z = 2;
        /* synthetic */ OrientationEventListener this$0;

        private void $$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$__constructor__(OrientationEventListener this$0) {
        }

        private final void $$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$onSensorChanged(SensorEvent event) {
            float[] values = event.values;
            int orientation = -1;
            float X = -values[0];
            float Y = -values[1];
            float magnitude = X * X + Y * Y;
            float Z = -values[2];
            if (magnitude * 4.0f >= Z * Z) {
                float OneEightyOverPi = 57.29578f;
                float angle = (float)Math.atan2(-Y, X) * OneEightyOverPi;
                for (orientation = 90 - Math.round(angle); orientation >= 360; orientation -= 360) {
                }
                while (orientation < 0) {
                    orientation += 360;
                }
            }
            if (this.this$0.mOldListener != null) {
                this.this$0.mOldListener.onSensorChanged(1, event.values);
            }
            if (orientation != this.this$0.mOrientation) {
                this.this$0.mOrientation = orientation;
                this.this$0.onOrientationChanged(orientation);
            }
        }

        private final void $$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$onAccuracyChanged(Sensor sensor, int accuracy) {
        }

        private void __constructor__(OrientationEventListener orientationEventListener) {
            this.$$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$__constructor__(orientationEventListener);
        }

        SensorEventListenerImpl(OrientationEventListener orientationEventListener) {
            this.this$0 = orientationEventListener;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$__constructor__(android.view.OrientationEventListener ), 0, this, orientationEventListener);
        }

        @Override
        public void onSensorChanged(SensorEvent sensorEvent) {
            InvokeDynamicSupport.bootstrap("onSensorChanged", $$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$onSensorChanged(android.hardware.SensorEvent ), 0, this, sensorEvent);
        }

        @Override
        public void onAccuracyChanged(Sensor sensor, int n) {
            InvokeDynamicSupport.bootstrap("onAccuracyChanged", $$robo$$android_view_OrientationEventListener_SensorEventListenerImpl$onAccuracyChanged(android.hardware.Sensor int ), 0, this, sensor, n);
        }

        public /* synthetic */ SensorEventListenerImpl() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SensorEventListenerImpl)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

