/*
 * Decompiled with CFR 0.152.
 */
package android.view;

import android.hardware.input.InputManager;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AndroidRuntimeException;
import android.util.SparseIntArray;
import android.view.InputDevice;
import android.view.KeyEvent;
import com.google.errorprone.annotations.DoNotMock;
import java.text.Normalizer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class KeyCharacterMap
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    @Deprecated
    public static int BUILT_IN_KEYBOARD = 0;
    public static int VIRTUAL_KEYBOARD = -1;
    public static int NUMERIC = 1;
    public static int PREDICTIVE = 2;
    public static int ALPHA = 3;
    public static int FULL = 4;
    public static int SPECIAL_FUNCTION = 5;
    public static char HEX_INPUT = '\uef00';
    public static char PICKER_DIALOG_INPUT = '\uef01';
    public static int MODIFIER_BEHAVIOR_CHORDED = 0;
    public static int MODIFIER_BEHAVIOR_CHORDED_OR_TOGGLED = 1;
    public static int COMBINING_ACCENT = Integer.MIN_VALUE;
    public static int COMBINING_ACCENT_MASK = Integer.MAX_VALUE;
    private static int ACCENT_ACUTE = 180;
    private static int ACCENT_BREVE = 728;
    private static int ACCENT_CARON = 711;
    private static int ACCENT_CEDILLA = 184;
    private static int ACCENT_CIRCUMFLEX = 710;
    private static int ACCENT_COMMA_ABOVE = 8125;
    private static int ACCENT_COMMA_ABOVE_RIGHT = 700;
    private static int ACCENT_DOT_ABOVE = 729;
    private static int ACCENT_DOT_BELOW = 46;
    private static int ACCENT_DOUBLE_ACUTE = 733;
    private static int ACCENT_GRAVE = 715;
    private static int ACCENT_HOOK_ABOVE = 704;
    private static int ACCENT_HORN = 39;
    private static int ACCENT_MACRON = 175;
    private static int ACCENT_MACRON_BELOW = 717;
    private static int ACCENT_OGONEK = 731;
    private static int ACCENT_REVERSED_COMMA_ABOVE = 701;
    private static int ACCENT_RING_ABOVE = 730;
    private static int ACCENT_STROKE = 45;
    private static int ACCENT_TILDE = 732;
    private static int ACCENT_TURNED_COMMA_ABOVE = 699;
    private static int ACCENT_UMLAUT = 168;
    private static int ACCENT_VERTICAL_LINE_ABOVE = 712;
    private static int ACCENT_VERTICAL_LINE_BELOW = 716;
    private static int ACCENT_GRAVE_LEGACY = 96;
    private static int ACCENT_CIRCUMFLEX_LEGACY = 94;
    private static int ACCENT_TILDE_LEGACY = 126;
    private static int CHAR_SPACE = 32;
    private static SparseIntArray sCombiningToAccent;
    private static SparseIntArray sAccentToCombining;
    private static SparseIntArray sDeadKeyCache;
    private static StringBuilder sDeadKeyBuilder;
    public static Parcelable.Creator<KeyCharacterMap> CREATOR;
    private long mPtr;

    private static final void $$robo$$android_view_KeyCharacterMap$addCombining(int combining, int accent) {
        sCombiningToAccent.append(combining, accent);
        sAccentToCombining.append(accent, combining);
    }

    private static final void $$robo$$android_view_KeyCharacterMap$addDeadKey(int accent, int c, int result) {
        int combining = sAccentToCombining.get(accent);
        if (combining == 0) {
            throw new IllegalStateException("Invalid dead key declaration.");
        }
        int combination = combining << 16 | c;
        sDeadKeyCache.put(combination, result);
    }

    private static final long $$robo$$android_view_KeyCharacterMap$nativeReadFromParcel(Parcel parcel) {
        return 0L;
    }

    private static final void $$robo$$android_view_KeyCharacterMap$nativeWriteToParcel(long l, Parcel parcel) {
    }

    private static final void $$robo$$android_view_KeyCharacterMap$nativeDispose(long l) {
    }

    private static final char $$robo$$android_view_KeyCharacterMap$nativeGetCharacter(long l, int n, int n2) {
        return '\u0000';
    }

    private static final boolean $$robo$$android_view_KeyCharacterMap$nativeGetFallbackAction(long l, int n, int n2, FallbackAction fallbackAction) {
        return false;
    }

    private static final char $$robo$$android_view_KeyCharacterMap$nativeGetNumber(long l, int n) {
        return '\u0000';
    }

    private static final char $$robo$$android_view_KeyCharacterMap$nativeGetMatch(long l, int n, char[] cArray, int n2) {
        return '\u0000';
    }

    private static final char $$robo$$android_view_KeyCharacterMap$nativeGetDisplayLabel(long l, int n) {
        return '\u0000';
    }

    private static final int $$robo$$android_view_KeyCharacterMap$nativeGetKeyboardType(long l) {
        return 0;
    }

    private static final KeyEvent[] $$robo$$android_view_KeyCharacterMap$nativeGetEvents(long l, char[] cArray) {
        return null;
    }

    private void $$robo$$android_view_KeyCharacterMap$__constructor__(Parcel in) {
        if (in == null) {
            throw new IllegalArgumentException("parcel must not be null");
        }
        this.mPtr = KeyCharacterMap.nativeReadFromParcel(in);
        if (this.mPtr == 0L) {
            throw new RuntimeException("Could not read KeyCharacterMap from parcel.");
        }
    }

    private void $$robo$$android_view_KeyCharacterMap$__constructor__(long ptr) {
        this.mPtr = ptr;
    }

    private final void $$robo$$android_view_KeyCharacterMap$finalize() throws Throwable {
        if (this.mPtr != 0L) {
            KeyCharacterMap.nativeDispose(this.mPtr);
            this.mPtr = 0L;
        }
    }

    private static final KeyCharacterMap $$robo$$android_view_KeyCharacterMap$load(int deviceId) {
        InputManager im = InputManager.getInstance();
        InputDevice inputDevice = im.getInputDevice(deviceId);
        if (inputDevice == null && (inputDevice = im.getInputDevice(-1)) == null) {
            throw new UnavailableException("Could not load key character map for device " + deviceId);
        }
        return inputDevice.getKeyCharacterMap();
    }

    private final int $$robo$$android_view_KeyCharacterMap$get(int keyCode, int metaState) {
        char ch = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, metaState = KeyEvent.normalizeMetaState(metaState));
        int map = sCombiningToAccent.get(ch);
        if (map != 0) {
            return map | Integer.MIN_VALUE;
        }
        return ch;
    }

    private final FallbackAction $$robo$$android_view_KeyCharacterMap$getFallbackAction(int keyCode, int metaState) {
        FallbackAction action = FallbackAction.obtain();
        if (KeyCharacterMap.nativeGetFallbackAction(this.mPtr, keyCode, metaState = KeyEvent.normalizeMetaState(metaState), action)) {
            action.metaState = KeyEvent.normalizeMetaState(action.metaState);
            return action;
        }
        action.recycle();
        return null;
    }

    private final char $$robo$$android_view_KeyCharacterMap$getNumber(int keyCode) {
        return KeyCharacterMap.nativeGetNumber(this.mPtr, keyCode);
    }

    private final char $$robo$$android_view_KeyCharacterMap$getMatch(int keyCode, char[] chars) {
        return this.getMatch(keyCode, chars, 0);
    }

    private final char $$robo$$android_view_KeyCharacterMap$getMatch(int keyCode, char[] chars, int metaState) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null.");
        }
        metaState = KeyEvent.normalizeMetaState(metaState);
        return KeyCharacterMap.nativeGetMatch(this.mPtr, keyCode, chars, metaState);
    }

    private final char $$robo$$android_view_KeyCharacterMap$getDisplayLabel(int keyCode) {
        return KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final int $$robo$$android_view_KeyCharacterMap$getDeadChar(int accent, int c) {
        int combined;
        if (c == accent || 32 == c) {
            return accent;
        }
        int combining = sAccentToCombining.get(accent);
        if (combining == 0) {
            return 0;
        }
        int combination = combining << 16 | c;
        SparseIntArray sparseIntArray = sDeadKeyCache;
        synchronized (sparseIntArray) {
            combined = sDeadKeyCache.get(combination, -1);
            if (combined == -1) {
                sDeadKeyBuilder.setLength(0);
                sDeadKeyBuilder.append((char)c);
                sDeadKeyBuilder.append((char)combining);
                String result = Normalizer.normalize(sDeadKeyBuilder, Normalizer.Form.NFC);
                combined = result.codePointCount(0, result.length()) == 1 ? result.codePointAt(0) : 0;
                sDeadKeyCache.put(combination, combined);
            }
        }
        return combined;
    }

    @Deprecated
    private final boolean $$robo$$android_view_KeyCharacterMap$getKeyData(int keyCode, KeyData results) {
        if (results.meta.length < 4) {
            throw new IndexOutOfBoundsException("results.meta.length must be >= 4");
        }
        char displayLabel = KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode);
        if (displayLabel == '\u0000') {
            return false;
        }
        results.displayLabel = displayLabel;
        results.number = KeyCharacterMap.nativeGetNumber(this.mPtr, keyCode);
        results.meta[0] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 0);
        results.meta[1] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 1);
        results.meta[2] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 2);
        results.meta[3] = KeyCharacterMap.nativeGetCharacter(this.mPtr, keyCode, 3);
        return true;
    }

    private final KeyEvent[] $$robo$$android_view_KeyCharacterMap$getEvents(char[] chars) {
        if (chars == null) {
            throw new IllegalArgumentException("chars must not be null.");
        }
        return KeyCharacterMap.nativeGetEvents(this.mPtr, chars);
    }

    private final boolean $$robo$$android_view_KeyCharacterMap$isPrintingKey(int keyCode) {
        int type = Character.getType(KeyCharacterMap.nativeGetDisplayLabel(this.mPtr, keyCode));
        switch (type) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                return false;
            }
        }
        return true;
    }

    private final int $$robo$$android_view_KeyCharacterMap$getKeyboardType() {
        return KeyCharacterMap.nativeGetKeyboardType(this.mPtr);
    }

    private final int $$robo$$android_view_KeyCharacterMap$getModifierBehavior() {
        switch (this.getKeyboardType()) {
            case 4: 
            case 5: {
                return 0;
            }
        }
        return 1;
    }

    private static final boolean $$robo$$android_view_KeyCharacterMap$deviceHasKey(int keyCode) {
        return InputManager.getInstance().deviceHasKeys(new int[]{keyCode})[0];
    }

    private static final boolean[] $$robo$$android_view_KeyCharacterMap$deviceHasKeys(int[] keyCodes) {
        return InputManager.getInstance().deviceHasKeys(keyCodes);
    }

    private final void $$robo$$android_view_KeyCharacterMap$writeToParcel(Parcel out, int flags) {
        if (out == null) {
            throw new IllegalArgumentException("parcel must not be null");
        }
        KeyCharacterMap.nativeWriteToParcel(this.mPtr, out);
    }

    private final int $$robo$$android_view_KeyCharacterMap$describeContents() {
        return 0;
    }

    private /* synthetic */ void $$robo$$android_view_KeyCharacterMap$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sCombiningToAccent = new SparseIntArray();
        sAccentToCombining = new SparseIntArray();
        KeyCharacterMap.addCombining(768, 715);
        KeyCharacterMap.addCombining(769, 180);
        KeyCharacterMap.addCombining(770, 710);
        KeyCharacterMap.addCombining(771, 732);
        KeyCharacterMap.addCombining(772, 175);
        KeyCharacterMap.addCombining(774, 728);
        KeyCharacterMap.addCombining(775, 729);
        KeyCharacterMap.addCombining(776, 168);
        KeyCharacterMap.addCombining(777, 704);
        KeyCharacterMap.addCombining(778, 730);
        KeyCharacterMap.addCombining(779, 733);
        KeyCharacterMap.addCombining(780, 711);
        KeyCharacterMap.addCombining(781, 712);
        KeyCharacterMap.addCombining(786, 699);
        KeyCharacterMap.addCombining(787, 8125);
        KeyCharacterMap.addCombining(788, 701);
        KeyCharacterMap.addCombining(789, 700);
        KeyCharacterMap.addCombining(795, 39);
        KeyCharacterMap.addCombining(803, 46);
        KeyCharacterMap.addCombining(807, 184);
        KeyCharacterMap.addCombining(808, 731);
        KeyCharacterMap.addCombining(809, 716);
        KeyCharacterMap.addCombining(817, 717);
        KeyCharacterMap.addCombining(821, 45);
        sCombiningToAccent.append(832, 715);
        sCombiningToAccent.append(833, 180);
        sCombiningToAccent.append(835, 8125);
        sAccentToCombining.append(96, 768);
        sAccentToCombining.append(94, 770);
        sAccentToCombining.append(126, 771);
        sDeadKeyCache = new SparseIntArray();
        sDeadKeyBuilder = new StringBuilder();
        KeyCharacterMap.addDeadKey(45, 68, 272);
        KeyCharacterMap.addDeadKey(45, 71, 484);
        KeyCharacterMap.addDeadKey(45, 72, 294);
        KeyCharacterMap.addDeadKey(45, 73, 407);
        KeyCharacterMap.addDeadKey(45, 76, 321);
        KeyCharacterMap.addDeadKey(45, 79, 216);
        KeyCharacterMap.addDeadKey(45, 84, 358);
        KeyCharacterMap.addDeadKey(45, 100, 273);
        KeyCharacterMap.addDeadKey(45, 103, 485);
        KeyCharacterMap.addDeadKey(45, 104, 295);
        KeyCharacterMap.addDeadKey(45, 105, 616);
        KeyCharacterMap.addDeadKey(45, 108, 322);
        KeyCharacterMap.addDeadKey(45, 111, 248);
        KeyCharacterMap.addDeadKey(45, 116, 359);
        CREATOR = new Parcelable.Creator<KeyCharacterMap>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_view_KeyCharacterMap_1$__constructor__() {
            }

            private final KeyCharacterMap $$robo$$android_view_KeyCharacterMap_1$createFromParcel(Parcel in) {
                return new KeyCharacterMap(in);
            }

            private final KeyCharacterMap[] $$robo$$android_view_KeyCharacterMap_1$newArray(int size) {
                return new KeyCharacterMap[size];
            }

            private void __constructor__() {
                this.$$robo$$android_view_KeyCharacterMap_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_KeyCharacterMap_1$__constructor__(), 0, this);
            }

            @Override
            public KeyCharacterMap createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_view_KeyCharacterMap_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public KeyCharacterMap[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_view_KeyCharacterMap_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private static void addCombining(int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("addCombining", $$robo$$android_view_KeyCharacterMap$addCombining(int int ), 0, (int)n, (int)n2);
    }

    private static void addDeadKey(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrapStatic("addDeadKey", $$robo$$android_view_KeyCharacterMap$addDeadKey(int int int ), 0, (int)n, (int)n2, (int)n3);
    }

    private static final native /* synthetic */ long $$robo$$nativeReadFromParcel$nativeBinding(Parcel var0);

    private static long nativeReadFromParcel(Parcel parcel) {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeReadFromParcel", $$robo$$android_view_KeyCharacterMap$nativeReadFromParcel(android.os.Parcel ), 1, (Parcel)parcel);
    }

    private static final native /* synthetic */ void $$robo$$nativeWriteToParcel$nativeBinding(long var0, Parcel var2);

    private static void nativeWriteToParcel(long l, Parcel parcel) {
        InvokeDynamicSupport.bootstrapStatic("nativeWriteToParcel", $$robo$$android_view_KeyCharacterMap$nativeWriteToParcel(long android.os.Parcel ), 1, (long)l, (Parcel)parcel);
    }

    private static final native /* synthetic */ void $$robo$$nativeDispose$nativeBinding(long var0);

    private static void nativeDispose(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDispose", $$robo$$android_view_KeyCharacterMap$nativeDispose(long ), 1, (long)l);
    }

    private static final native /* synthetic */ char $$robo$$nativeGetCharacter$nativeBinding(long var0, int var2, int var3);

    private static char nativeGetCharacter(long l, int n, int n2) {
        return (char)InvokeDynamicSupport.bootstrapStatic("nativeGetCharacter", $$robo$$android_view_KeyCharacterMap$nativeGetCharacter(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeGetFallbackAction$nativeBinding(long var0, int var2, int var3, FallbackAction var4);

    private static boolean nativeGetFallbackAction(long l, int n, int n2, FallbackAction fallbackAction) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeGetFallbackAction", $$robo$$android_view_KeyCharacterMap$nativeGetFallbackAction(long int int android.view.KeyCharacterMap$FallbackAction ), 1, (long)l, (int)n, (int)n2, (FallbackAction)fallbackAction);
    }

    private static final native /* synthetic */ char $$robo$$nativeGetNumber$nativeBinding(long var0, int var2);

    private static char nativeGetNumber(long l, int n) {
        return (char)InvokeDynamicSupport.bootstrapStatic("nativeGetNumber", $$robo$$android_view_KeyCharacterMap$nativeGetNumber(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ char $$robo$$nativeGetMatch$nativeBinding(long var0, int var2, char[] var3, int var4);

    private static char nativeGetMatch(long l, int n, char[] cArray, int n2) {
        return (char)InvokeDynamicSupport.bootstrapStatic("nativeGetMatch", $$robo$$android_view_KeyCharacterMap$nativeGetMatch(long int char[] int ), 1, (long)l, (int)n, (char[])cArray, (int)n2);
    }

    private static final native /* synthetic */ char $$robo$$nativeGetDisplayLabel$nativeBinding(long var0, int var2);

    private static char nativeGetDisplayLabel(long l, int n) {
        return (char)InvokeDynamicSupport.bootstrapStatic("nativeGetDisplayLabel", $$robo$$android_view_KeyCharacterMap$nativeGetDisplayLabel(long int ), 1, (long)l, (int)n);
    }

    private static final native /* synthetic */ int $$robo$$nativeGetKeyboardType$nativeBinding(long var0);

    private static int nativeGetKeyboardType(long l) {
        return (int)InvokeDynamicSupport.bootstrapStatic("nativeGetKeyboardType", $$robo$$android_view_KeyCharacterMap$nativeGetKeyboardType(long ), 1, (long)l);
    }

    private static final native /* synthetic */ KeyEvent[] $$robo$$nativeGetEvents$nativeBinding(long var0, char[] var2);

    private static KeyEvent[] nativeGetEvents(long l, char[] cArray) {
        return InvokeDynamicSupport.bootstrapStatic("nativeGetEvents", $$robo$$android_view_KeyCharacterMap$nativeGetEvents(long char[] ), 1, (long)l, (char[])cArray);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_view_KeyCharacterMap$__constructor__(parcel);
    }

    private KeyCharacterMap(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_KeyCharacterMap$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    private void __constructor__(long l) {
        this.$$robo$$android_view_KeyCharacterMap$__constructor__(l);
    }

    private KeyCharacterMap(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_KeyCharacterMap$__constructor__(long ), 0, this, l);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_view_KeyCharacterMap$finalize(), 0, this);
    }

    public static KeyCharacterMap load(int n) {
        return InvokeDynamicSupport.bootstrapStatic("load", $$robo$$android_view_KeyCharacterMap$load(int ), 0, (int)n);
    }

    public int get(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("get", $$robo$$android_view_KeyCharacterMap$get(int int ), 0, this, n, n2);
    }

    public FallbackAction getFallbackAction(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getFallbackAction", $$robo$$android_view_KeyCharacterMap$getFallbackAction(int int ), 0, this, n, n2);
    }

    public char getNumber(int n) {
        return (char)InvokeDynamicSupport.bootstrap("getNumber", $$robo$$android_view_KeyCharacterMap$getNumber(int ), 0, this, n);
    }

    public char getMatch(int n, char[] cArray) {
        return (char)InvokeDynamicSupport.bootstrap("getMatch", $$robo$$android_view_KeyCharacterMap$getMatch(int char[] ), 0, this, n, cArray);
    }

    public char getMatch(int n, char[] cArray, int n2) {
        return (char)InvokeDynamicSupport.bootstrap("getMatch", $$robo$$android_view_KeyCharacterMap$getMatch(int char[] int ), 0, this, n, cArray, n2);
    }

    public char getDisplayLabel(int n) {
        return (char)InvokeDynamicSupport.bootstrap("getDisplayLabel", $$robo$$android_view_KeyCharacterMap$getDisplayLabel(int ), 0, this, n);
    }

    public static int getDeadChar(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDeadChar", $$robo$$android_view_KeyCharacterMap$getDeadChar(int int ), 0, (int)n, (int)n2);
    }

    @Deprecated
    public boolean getKeyData(int n, KeyData keyData) {
        return (boolean)InvokeDynamicSupport.bootstrap("getKeyData", $$robo$$android_view_KeyCharacterMap$getKeyData(int android.view.KeyCharacterMap$KeyData ), 0, this, n, keyData);
    }

    public KeyEvent[] getEvents(char[] cArray) {
        return InvokeDynamicSupport.bootstrap("getEvents", $$robo$$android_view_KeyCharacterMap$getEvents(char[] ), 0, this, cArray);
    }

    public boolean isPrintingKey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isPrintingKey", $$robo$$android_view_KeyCharacterMap$isPrintingKey(int ), 0, this, n);
    }

    public int getKeyboardType() {
        return (int)InvokeDynamicSupport.bootstrap("getKeyboardType", $$robo$$android_view_KeyCharacterMap$getKeyboardType(), 0, this);
    }

    public int getModifierBehavior() {
        return (int)InvokeDynamicSupport.bootstrap("getModifierBehavior", $$robo$$android_view_KeyCharacterMap$getModifierBehavior(), 0, this);
    }

    public static boolean deviceHasKey(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deviceHasKey", $$robo$$android_view_KeyCharacterMap$deviceHasKey(int ), 0, (int)n);
    }

    public static boolean[] deviceHasKeys(int[] nArray) {
        return InvokeDynamicSupport.bootstrapStatic("deviceHasKeys", $$robo$$android_view_KeyCharacterMap$deviceHasKeys(int[] ), 0, (int[])nArray);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_view_KeyCharacterMap$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_view_KeyCharacterMap$describeContents(), 0, this);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_view_KeyCharacterMap$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(KeyCharacterMap.class);
    }

    public /* synthetic */ KeyCharacterMap() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyCharacterMap)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class FallbackAction
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int MAX_RECYCLED = 10;
        private static Object sRecycleLock;
        private static FallbackAction sRecycleBin;
        private static int sRecycledCount;
        private FallbackAction next;
        public int keyCode;
        public int metaState;

        private void $$robo$$android_view_KeyCharacterMap_FallbackAction$__constructor__() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static final FallbackAction $$robo$$android_view_KeyCharacterMap_FallbackAction$obtain() {
            FallbackAction target;
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycleBin == null) {
                    target = new FallbackAction();
                } else {
                    target = sRecycleBin;
                    sRecycleBin = target.next;
                    --sRecycledCount;
                    target.next = null;
                }
            }
            return target;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_view_KeyCharacterMap_FallbackAction$recycle() {
            Object object = sRecycleLock;
            synchronized (object) {
                if (sRecycledCount < 10) {
                    this.next = sRecycleBin;
                    sRecycleBin = this;
                    ++sRecycledCount;
                } else {
                    this.next = null;
                }
            }
        }

        static void __staticInitializer__() {
            sRecycleLock = new Object();
        }

        private void __constructor__() {
            this.$$robo$$android_view_KeyCharacterMap_FallbackAction$__constructor__();
        }

        private FallbackAction() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_KeyCharacterMap_FallbackAction$__constructor__(), 0, this);
        }

        public static FallbackAction obtain() {
            return InvokeDynamicSupport.bootstrapStatic("obtain", $$robo$$android_view_KeyCharacterMap_FallbackAction$obtain(), 0);
        }

        public void recycle() {
            InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_view_KeyCharacterMap_FallbackAction$recycle(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(FallbackAction.class);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FallbackAction)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class UnavailableException
    extends AndroidRuntimeException
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_view_KeyCharacterMap_UnavailableException$__constructor__(String msg) {
        }

        private void __constructor__(String string2) {
            this.$$robo$$android_view_KeyCharacterMap_UnavailableException$__constructor__(string2);
        }

        public UnavailableException(String string2) {
            super(string2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_KeyCharacterMap_UnavailableException$__constructor__(java.lang.String ), 0, this, string2);
        }

        public /* synthetic */ UnavailableException() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnavailableException)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static class KeyData
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int META_LENGTH = 4;
        public char displayLabel;
        public char number;
        public char[] meta;

        private void $$robo$$android_view_KeyCharacterMap_KeyData$__constructor__() {
            this.meta = new char[4];
        }

        private void __constructor__() {
            this.$$robo$$android_view_KeyCharacterMap_KeyData$__constructor__();
        }

        public KeyData() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_view_KeyCharacterMap_KeyData$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyData)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

