/*
 * Decompiled with CFR 0.152.
 */
package android.util.jar;

import android.util.jar.StrictJarManifestReader;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class StrictJarManifest
implements Cloneable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int LINE_LENGTH_LIMIT = 72;
    private static byte[] LINE_SEPARATOR;
    private static byte[] VALUE_SEPARATOR;
    private Attributes mainAttributes;
    private HashMap<String, Attributes> entries;
    private HashMap<String, Chunk> chunks;
    private int mainEnd;

    private void $$robo$$android_util_jar_StrictJarManifest$__constructor__() {
        this.entries = new HashMap();
        this.mainAttributes = new Attributes();
    }

    private void $$robo$$android_util_jar_StrictJarManifest$__constructor__(InputStream is) throws IOException {
        this.read(Streams.readFully(is));
    }

    private void $$robo$$android_util_jar_StrictJarManifest$__constructor__(StrictJarManifest man) {
        this.mainAttributes = (Attributes)man.mainAttributes.clone();
        this.entries = (HashMap)((HashMap)man.getEntries()).clone();
    }

    private void $$robo$$android_util_jar_StrictJarManifest$__constructor__(byte[] manifestBytes, boolean readChunks) throws IOException {
        if (readChunks) {
            this.chunks = new HashMap();
        }
        this.read(manifestBytes);
    }

    private final void $$robo$$android_util_jar_StrictJarManifest$clear() {
        this.entries.clear();
        this.mainAttributes.clear();
    }

    private final Attributes $$robo$$android_util_jar_StrictJarManifest$getAttributes(String name) {
        return this.getEntries().get(name);
    }

    private final Map<String, Attributes> $$robo$$android_util_jar_StrictJarManifest$getEntries() {
        return this.entries;
    }

    private final Attributes $$robo$$android_util_jar_StrictJarManifest$getMainAttributes() {
        return this.mainAttributes;
    }

    private final Object $$robo$$android_util_jar_StrictJarManifest$clone() {
        return new StrictJarManifest(this);
    }

    private final void $$robo$$android_util_jar_StrictJarManifest$write(OutputStream os) throws IOException {
        StrictJarManifest.write(this, os);
    }

    private final void $$robo$$android_util_jar_StrictJarManifest$read(InputStream is) throws IOException {
        this.read(Streams.readFullyNoClose(is));
    }

    private final void $$robo$$android_util_jar_StrictJarManifest$read(byte[] buf) throws IOException {
        if (buf.length == 0) {
            return;
        }
        StrictJarManifestReader im = new StrictJarManifestReader(buf, this.mainAttributes);
        this.mainEnd = im.getEndOfMainSection();
        im.readEntries(this.entries, this.chunks);
    }

    private final int $$robo$$android_util_jar_StrictJarManifest$hashCode() {
        return this.mainAttributes.hashCode() ^ this.getEntries().hashCode();
    }

    private final boolean $$robo$$android_util_jar_StrictJarManifest$equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        if (!this.mainAttributes.equals(((StrictJarManifest)o).mainAttributes)) {
            return false;
        }
        return this.getEntries().equals(((StrictJarManifest)o).getEntries());
    }

    private final Chunk $$robo$$android_util_jar_StrictJarManifest$getChunk(String name) {
        return this.chunks.get(name);
    }

    private final void $$robo$$android_util_jar_StrictJarManifest$removeChunks() {
        this.chunks = null;
    }

    private final int $$robo$$android_util_jar_StrictJarManifest$getMainAttributesEnd() {
        return this.mainEnd;
    }

    private static final void $$robo$$android_util_jar_StrictJarManifest$write(StrictJarManifest manifest, OutputStream out) throws IOException {
        CharsetEncoder encoder = StandardCharsets.UTF_8.newEncoder();
        ByteBuffer buffer = ByteBuffer.allocate(72);
        Attributes.Name versionName = Attributes.Name.MANIFEST_VERSION;
        String version = manifest.mainAttributes.getValue(versionName);
        if (version == null) {
            versionName = Attributes.Name.SIGNATURE_VERSION;
            version = manifest.mainAttributes.getValue(versionName);
        }
        if (version != null) {
            StrictJarManifest.writeEntry(out, versionName, version, encoder, buffer);
            for (Attributes.Name name : manifest.mainAttributes.keySet()) {
                if (name.equals(versionName)) continue;
                StrictJarManifest.writeEntry(out, name, manifest.mainAttributes.getValue(name), encoder, buffer);
            }
        }
        out.write(LINE_SEPARATOR);
        for (String string2 : manifest.getEntries().keySet()) {
            StrictJarManifest.writeEntry(out, Attributes.Name.NAME, string2, encoder, buffer);
            Attributes attributes = manifest.entries.get(string2);
            for (Attributes.Name name : attributes.keySet()) {
                StrictJarManifest.writeEntry(out, name, attributes.getValue(name), encoder, buffer);
            }
            out.write(LINE_SEPARATOR);
        }
    }

    private static final void $$robo$$android_util_jar_StrictJarManifest$writeEntry(OutputStream os, Attributes.Name name, String value, CharsetEncoder encoder, ByteBuffer bBuf) throws IOException {
        String nameString = name.toString();
        os.write(nameString.getBytes(StandardCharsets.US_ASCII));
        os.write(VALUE_SEPARATOR);
        encoder.reset();
        bBuf.clear().limit(72 - nameString.length() - 2);
        CharBuffer cBuf = CharBuffer.wrap(value);
        while (true) {
            CoderResult r;
            if (CoderResult.UNDERFLOW == (r = encoder.encode(cBuf, bBuf, true))) {
                r = encoder.flush(bBuf);
            }
            os.write(bBuf.array(), bBuf.arrayOffset(), bBuf.position());
            os.write(LINE_SEPARATOR);
            if (CoderResult.UNDERFLOW == r) break;
            os.write(32);
            bBuf.clear().limit(71);
        }
    }

    static void __staticInitializer__() {
        LINE_SEPARATOR = new byte[]{13, 10};
        VALUE_SEPARATOR = new byte[]{58, 32};
    }

    private void __constructor__() {
        this.$$robo$$android_util_jar_StrictJarManifest$__constructor__();
    }

    public StrictJarManifest() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarManifest$__constructor__(), 0, this);
    }

    private void __constructor__(InputStream inputStream) throws IOException {
        this.$$robo$$android_util_jar_StrictJarManifest$__constructor__(inputStream);
    }

    public StrictJarManifest(InputStream inputStream) throws IOException {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarManifest$__constructor__(java.io.InputStream ), 0, this, inputStream);
    }

    private void __constructor__(StrictJarManifest strictJarManifest) {
        this.$$robo$$android_util_jar_StrictJarManifest$__constructor__(strictJarManifest);
    }

    public StrictJarManifest(StrictJarManifest strictJarManifest) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarManifest$__constructor__(android.util.jar.StrictJarManifest ), 0, this, strictJarManifest);
    }

    private void __constructor__(byte[] byArray, boolean bl) throws IOException {
        this.$$robo$$android_util_jar_StrictJarManifest$__constructor__(byArray, bl);
    }

    StrictJarManifest(byte[] byArray, boolean bl) throws IOException {
        this();
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarManifest$__constructor__(byte[] boolean ), 0, this, byArray, bl);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_jar_StrictJarManifest$clear(), 0, this);
    }

    public Attributes getAttributes(String string2) {
        return InvokeDynamicSupport.bootstrap("getAttributes", $$robo$$android_util_jar_StrictJarManifest$getAttributes(java.lang.String ), 0, this, string2);
    }

    public Map<String, Attributes> getEntries() {
        return InvokeDynamicSupport.bootstrap("getEntries", $$robo$$android_util_jar_StrictJarManifest$getEntries(), 0, this);
    }

    public Attributes getMainAttributes() {
        return InvokeDynamicSupport.bootstrap("getMainAttributes", $$robo$$android_util_jar_StrictJarManifest$getMainAttributes(), 0, this);
    }

    public Object clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_util_jar_StrictJarManifest$clone(), 0, this);
    }

    public void write(OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("write", $$robo$$android_util_jar_StrictJarManifest$write(java.io.OutputStream ), 0, this, outputStream);
    }

    public void read(InputStream inputStream) throws IOException {
        InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarManifest$read(java.io.InputStream ), 0, this, inputStream);
    }

    private void read(byte[] byArray) throws IOException {
        InvokeDynamicSupport.bootstrap("read", $$robo$$android_util_jar_StrictJarManifest$read(byte[] ), 0, this, byArray);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_util_jar_StrictJarManifest$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_util_jar_StrictJarManifest$equals(java.lang.Object ), 0, this, object);
    }

    Chunk getChunk(String string2) {
        return InvokeDynamicSupport.bootstrap("getChunk", $$robo$$android_util_jar_StrictJarManifest$getChunk(java.lang.String ), 0, this, string2);
    }

    void removeChunks() {
        InvokeDynamicSupport.bootstrap("removeChunks", $$robo$$android_util_jar_StrictJarManifest$removeChunks(), 0, this);
    }

    int getMainAttributesEnd() {
        return (int)InvokeDynamicSupport.bootstrap("getMainAttributesEnd", $$robo$$android_util_jar_StrictJarManifest$getMainAttributesEnd(), 0, this);
    }

    static void write(StrictJarManifest strictJarManifest, OutputStream outputStream) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("write", $$robo$$android_util_jar_StrictJarManifest$write(android.util.jar.StrictJarManifest java.io.OutputStream ), 0, (StrictJarManifest)strictJarManifest, (OutputStream)outputStream);
    }

    private static void writeEntry(OutputStream outputStream, Attributes.Name name, String string2, CharsetEncoder charsetEncoder, ByteBuffer byteBuffer) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("writeEntry", $$robo$$android_util_jar_StrictJarManifest$writeEntry(java.io.OutputStream java.util.jar.Attributes$Name java.lang.String java.nio.charset.CharsetEncoder java.nio.ByteBuffer ), 0, (OutputStream)outputStream, (Attributes.Name)name, (String)string2, (CharsetEncoder)charsetEncoder, (ByteBuffer)byteBuffer);
    }

    static {
        RobolectricInternals.classInitializing(StrictJarManifest.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (StrictJarManifest)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Chunk
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        int start;
        int end;

        private void $$robo$$android_util_jar_StrictJarManifest_Chunk$__constructor__(int start, int end) {
            this.start = start;
            this.end = end;
        }

        private void __constructor__(int n, int n2) {
            this.$$robo$$android_util_jar_StrictJarManifest_Chunk$__constructor__(n, n2);
        }

        Chunk(int n, int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_jar_StrictJarManifest_Chunk$__constructor__(int int ), 0, this, n, n2);
        }

        public /* synthetic */ Chunk() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Chunk)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

