/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.os.SystemClock;
import android.util.SparseArray;
import android.util.SparseIntArray;
import com.android.internal.annotations.GuardedBy;
import java.util.concurrent.TimeoutException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;

public abstract class TimedRemoteCaller<T> {
    public transient /* synthetic */ Object __robo_data__;
    public static long DEFAULT_CALL_TIMEOUT_MILLIS = 5000L;
    private Object mLock;
    private long mCallTimeoutMillis;
    @GuardedBy(value="mLock")
    private SparseIntArray mAwaitedCalls;
    @GuardedBy(value="mLock")
    private SparseArray<T> mReceivedCalls;
    @GuardedBy(value="mLock")
    private int mSequenceCounter;

    private void $$robo$$android_util_TimedRemoteCaller$__constructor__(long callTimeoutMillis) {
        this.mLock = new Object();
        this.mAwaitedCalls = new SparseIntArray(1);
        this.mReceivedCalls = new SparseArray(1);
        this.mCallTimeoutMillis = callTimeoutMillis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_util_TimedRemoteCaller$onBeforeRemoteCall() {
        Object object = this.mLock;
        synchronized (object) {
            int sequenceId;
            do {
                ++this.mSequenceCounter;
            } while (this.mAwaitedCalls.get(sequenceId) != 0);
            this.mAwaitedCalls.put(sequenceId, 1);
            return sequenceId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_util_TimedRemoteCaller$onRemoteMethodResult(T result, int sequence) {
        Object object = this.mLock;
        synchronized (object) {
            boolean containedSequenceId;
            boolean bl = containedSequenceId = this.mAwaitedCalls.get(sequence) != 0;
            if (containedSequenceId) {
                this.mAwaitedCalls.delete(sequence);
                this.mReceivedCalls.put(sequence, result);
                this.mLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final T $$robo$$android_util_TimedRemoteCaller$getResultTimed(int sequence) throws TimeoutException {
        long startMillis = SystemClock.uptimeMillis();
        while (true) {
            try {
                while (true) {
                    Object object = this.mLock;
                    synchronized (object) {
                        if (this.mReceivedCalls.indexOfKey(sequence) >= 0) {
                            return this.mReceivedCalls.removeReturnOld(sequence);
                        }
                        long elapsedMillis = SystemClock.uptimeMillis() - startMillis;
                        long waitMillis = this.mCallTimeoutMillis - elapsedMillis;
                        if (waitMillis <= 0L) {
                            this.mAwaitedCalls.delete(sequence);
                            throw new TimeoutException("No response for sequence: " + sequence);
                        }
                        this.mLock.wait(waitMillis);
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private void __constructor__(long l) {
        this.$$robo$$android_util_TimedRemoteCaller$__constructor__(l);
    }

    public TimedRemoteCaller(long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_TimedRemoteCaller$__constructor__(long ), 0, this, l);
    }

    protected int onBeforeRemoteCall() {
        return (int)InvokeDynamicSupport.bootstrap("onBeforeRemoteCall", $$robo$$android_util_TimedRemoteCaller$onBeforeRemoteCall(), 0, this);
    }

    protected void onRemoteMethodResult(T t, int n) {
        InvokeDynamicSupport.bootstrap("onRemoteMethodResult", $$robo$$android_util_TimedRemoteCaller$onRemoteMethodResult(T int ), 0, this, t, n);
    }

    protected T getResultTimed(int n) throws TimeoutException {
        return (T)InvokeDynamicSupport.bootstrap("getResultTimed", $$robo$$android_util_TimedRemoteCaller$getResultTimed(int ), 0, this, n);
    }

    public /* synthetic */ TimedRemoteCaller() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimedRemoteCaller)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

