/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.util.ContainerHelpers;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.GrowingArrayUtils;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;

public class SparseArray<E>
implements Cloneable {
    public transient /* synthetic */ Object __robo_data__;
    private static Object DELETED;
    private boolean mGarbage;
    private int[] mKeys;
    private Object[] mValues;
    private int mSize;

    private void $$robo$$android_util_SparseArray$__constructor__() {
    }

    private void $$robo$$android_util_SparseArray$__constructor__(int initialCapacity) {
        this.mGarbage = false;
        if (initialCapacity == 0) {
            this.mKeys = EmptyArray.INT;
            this.mValues = EmptyArray.OBJECT;
        } else {
            this.mValues = ArrayUtils.newUnpaddedObjectArray(initialCapacity);
            this.mKeys = new int[this.mValues.length];
        }
        this.mSize = 0;
    }

    private final SparseArray<E> $$robo$$android_util_SparseArray$clone() {
        SparseArray clone = null;
        try {
            clone = (SparseArray)super.clone();
            clone.mKeys = (int[])this.mKeys.clone();
            clone.mValues = (Object[])this.mValues.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private final E $$robo$$android_util_SparseArray$get(int key) {
        return this.get(key, null);
    }

    private final E $$robo$$android_util_SparseArray$get(int key, E valueIfKeyNotFound) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i < 0 || this.mValues[i] == DELETED) {
            return valueIfKeyNotFound;
        }
        return (E)this.mValues[i];
    }

    private final void $$robo$$android_util_SparseArray$delete(int key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            this.mValues[i] = DELETED;
            this.mGarbage = true;
        }
    }

    private final E $$robo$$android_util_SparseArray$removeReturnOld(int key) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0 && this.mValues[i] != DELETED) {
            Object old = this.mValues[i];
            this.mValues[i] = DELETED;
            this.mGarbage = true;
            return (E)old;
        }
        return null;
    }

    private final void $$robo$$android_util_SparseArray$remove(int key) {
        this.delete(key);
    }

    private final void $$robo$$android_util_SparseArray$removeAt(int index) {
        if (this.mValues[index] != DELETED) {
            this.mValues[index] = DELETED;
            this.mGarbage = true;
        }
    }

    private final void $$robo$$android_util_SparseArray$removeAtRange(int index, int size) {
        int end = Math.min(this.mSize, index + size);
        for (int i = index; i < end; ++i) {
            this.removeAt(i);
        }
    }

    private final void $$robo$$android_util_SparseArray$gc() {
        int n = this.mSize;
        int o = 0;
        int[] keys = this.mKeys;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            Object val = values[i];
            if (val == DELETED) continue;
            if (i != o) {
                keys[o] = keys[i];
                values[o] = val;
                values[i] = null;
            }
            ++o;
        }
        this.mGarbage = false;
        this.mSize = o;
    }

    private final void $$robo$$android_util_SparseArray$put(int key, E value) {
        int i = ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
        if (i >= 0) {
            this.mValues[i] = value;
        } else {
            if ((i ^= 0xFFFFFFFF) < this.mSize && this.mValues[i] == DELETED) {
                this.mKeys[i] = key;
                this.mValues[i] = value;
                return;
            }
            if (this.mGarbage && this.mSize >= this.mKeys.length) {
                this.gc();
                i = ~ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
            }
            this.mKeys = GrowingArrayUtils.insert(this.mKeys, this.mSize, i, key);
            this.mValues = GrowingArrayUtils.insert(this.mValues, this.mSize, i, value);
            ++this.mSize;
        }
    }

    private final int $$robo$$android_util_SparseArray$size() {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mSize;
    }

    private final int $$robo$$android_util_SparseArray$keyAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return this.mKeys[index];
    }

    private final E $$robo$$android_util_SparseArray$valueAt(int index) {
        if (this.mGarbage) {
            this.gc();
        }
        return (E)this.mValues[index];
    }

    private final void $$robo$$android_util_SparseArray$setValueAt(int index, E value) {
        if (this.mGarbage) {
            this.gc();
        }
        this.mValues[index] = value;
    }

    private final int $$robo$$android_util_SparseArray$indexOfKey(int key) {
        if (this.mGarbage) {
            this.gc();
        }
        return ContainerHelpers.binarySearch(this.mKeys, this.mSize, key);
    }

    private final int $$robo$$android_util_SparseArray$indexOfValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (this.mValues[i] != value) continue;
            return i;
        }
        return -1;
    }

    private final int $$robo$$android_util_SparseArray$indexOfValueByValue(E value) {
        if (this.mGarbage) {
            this.gc();
        }
        for (int i = 0; i < this.mSize; ++i) {
            if (!(value == null ? this.mValues[i] == null : value.equals(this.mValues[i]))) continue;
            return i;
        }
        return -1;
    }

    private final void $$robo$$android_util_SparseArray$clear() {
        int n = this.mSize;
        Object[] values = this.mValues;
        for (int i = 0; i < n; ++i) {
            values[i] = null;
        }
        this.mSize = 0;
        this.mGarbage = false;
    }

    private final void $$robo$$android_util_SparseArray$append(int key, E value) {
        if (this.mSize != 0 && key <= this.mKeys[this.mSize - 1]) {
            this.put(key, value);
            return;
        }
        if (this.mGarbage && this.mSize >= this.mKeys.length) {
            this.gc();
        }
        this.mKeys = GrowingArrayUtils.append(this.mKeys, this.mSize, key);
        this.mValues = GrowingArrayUtils.append(this.mValues, this.mSize, value);
        ++this.mSize;
    }

    private final String $$robo$$android_util_SparseArray$toString() {
        if (this.size() <= 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(this.mSize * 28);
        buffer.append('{');
        for (int i = 0; i < this.mSize; ++i) {
            if (i > 0) {
                buffer.append(", ");
            }
            int key = this.keyAt(i);
            buffer.append(key);
            buffer.append('=');
            E value = this.valueAt(i);
            if (value != this) {
                buffer.append(value);
                continue;
            }
            buffer.append("(this Map)");
        }
        buffer.append('}');
        return buffer.toString();
    }

    static void __staticInitializer__() {
        DELETED = new Object();
    }

    public /* synthetic */ void set(int n, E e) {
        this.put(n, e);
    }

    private void __constructor__() {
        this.$$robo$$android_util_SparseArray$__constructor__();
    }

    public SparseArray() {
        this(10);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_SparseArray$__constructor__(), 0, this);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_util_SparseArray$__constructor__(n);
    }

    public SparseArray(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_SparseArray$__constructor__(int ), 0, this, n);
    }

    public SparseArray<E> clone() {
        return InvokeDynamicSupport.bootstrap("clone", $$robo$$android_util_SparseArray$clone(), 0, this);
    }

    public E get(int n) {
        return (E)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_SparseArray$get(int ), 0, this, n);
    }

    public E get(int n, E e) {
        return (E)InvokeDynamicSupport.bootstrap("get", $$robo$$android_util_SparseArray$get(int E ), 0, this, n, e);
    }

    public void delete(int n) {
        InvokeDynamicSupport.bootstrap("delete", $$robo$$android_util_SparseArray$delete(int ), 0, this, n);
    }

    public E removeReturnOld(int n) {
        return (E)InvokeDynamicSupport.bootstrap("removeReturnOld", $$robo$$android_util_SparseArray$removeReturnOld(int ), 0, this, n);
    }

    public void remove(int n) {
        InvokeDynamicSupport.bootstrap("remove", $$robo$$android_util_SparseArray$remove(int ), 0, this, n);
    }

    public void removeAt(int n) {
        InvokeDynamicSupport.bootstrap("removeAt", $$robo$$android_util_SparseArray$removeAt(int ), 0, this, n);
    }

    public void removeAtRange(int n, int n2) {
        InvokeDynamicSupport.bootstrap("removeAtRange", $$robo$$android_util_SparseArray$removeAtRange(int int ), 0, this, n, n2);
    }

    private void gc() {
        InvokeDynamicSupport.bootstrap("gc", $$robo$$android_util_SparseArray$gc(), 0, this);
    }

    public void put(int n, E e) {
        InvokeDynamicSupport.bootstrap("put", $$robo$$android_util_SparseArray$put(int E ), 0, this, n, e);
    }

    public int size() {
        return (int)InvokeDynamicSupport.bootstrap("size", $$robo$$android_util_SparseArray$size(), 0, this);
    }

    public int keyAt(int n) {
        return (int)InvokeDynamicSupport.bootstrap("keyAt", $$robo$$android_util_SparseArray$keyAt(int ), 0, this, n);
    }

    public E valueAt(int n) {
        return (E)InvokeDynamicSupport.bootstrap("valueAt", $$robo$$android_util_SparseArray$valueAt(int ), 0, this, n);
    }

    public void setValueAt(int n, E e) {
        InvokeDynamicSupport.bootstrap("setValueAt", $$robo$$android_util_SparseArray$setValueAt(int E ), 0, this, n, e);
    }

    public int indexOfKey(int n) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfKey", $$robo$$android_util_SparseArray$indexOfKey(int ), 0, this, n);
    }

    public int indexOfValue(E e) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfValue", $$robo$$android_util_SparseArray$indexOfValue(E ), 0, this, e);
    }

    public int indexOfValueByValue(E e) {
        return (int)InvokeDynamicSupport.bootstrap("indexOfValueByValue", $$robo$$android_util_SparseArray$indexOfValueByValue(E ), 0, this, e);
    }

    public void clear() {
        InvokeDynamicSupport.bootstrap("clear", $$robo$$android_util_SparseArray$clear(), 0, this);
    }

    public void append(int n, E e) {
        InvokeDynamicSupport.bootstrap("append", $$robo$$android_util_SparseArray$append(int E ), 0, this, n, e);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_util_SparseArray$toString(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(SparseArray.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SparseArray)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

