/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.ContentResolver;
import android.content.Context;
import android.content.res.Resources;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.SntpClient;
import android.os.SystemClock;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.TrustedTime;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NtpTrustedTime
implements TrustedTime,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NtpTrustedTime";
    private static boolean LOGD = false;
    private static NtpTrustedTime sSingleton;
    private static Context sContext;
    private String mServer;
    private long mTimeout;
    private ConnectivityManager mCM;
    private boolean mHasCache;
    private long mCachedNtpTime;
    private long mCachedNtpElapsedRealtime;
    private long mCachedNtpCertainty;

    private void $$robo$$android_util_NtpTrustedTime$__constructor__(String server, long timeout) {
        this.mServer = server;
        this.mTimeout = timeout;
    }

    private static final synchronized NtpTrustedTime $$robo$$android_util_NtpTrustedTime$getInstance(Context context) {
        if (sSingleton == null) {
            Resources res = context.getResources();
            ContentResolver resolver = context.getContentResolver();
            String defaultServer = res.getString(17039677);
            long defaultTimeout = res.getInteger(17694832);
            String secureServer = Settings.Global.getString(resolver, "ntp_server");
            long timeout = Settings.Global.getLong(resolver, "ntp_timeout", defaultTimeout);
            String server = secureServer != null ? secureServer : defaultServer;
            sSingleton = new NtpTrustedTime(server, timeout);
            sContext = context;
        }
        return sSingleton;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_util_NtpTrustedTime$forceRefresh() {
        NetworkInfo ni;
        if (TextUtils.isEmpty(this.mServer)) {
            return false;
        }
        NtpTrustedTime ntpTrustedTime = this;
        synchronized (ntpTrustedTime) {
            if (this.mCM == null) {
                this.mCM = (ConnectivityManager)sContext.getSystemService("connectivity");
            }
        }
        NetworkInfo networkInfo = ni = this.mCM == null ? null : this.mCM.getActiveNetworkInfo();
        if (ni == null || !ni.isConnected()) {
            return false;
        }
        SntpClient client = new SntpClient();
        if (client.requestTime(this.mServer, (int)this.mTimeout)) {
            this.mHasCache = true;
            this.mCachedNtpTime = client.getNtpTime();
            this.mCachedNtpElapsedRealtime = client.getNtpTimeReference();
            this.mCachedNtpCertainty = client.getRoundTripTime() / 2L;
            return true;
        }
        return false;
    }

    private final boolean $$robo$$android_util_NtpTrustedTime$hasCache() {
        return this.mHasCache;
    }

    private final long $$robo$$android_util_NtpTrustedTime$getCacheAge() {
        if (this.mHasCache) {
            return SystemClock.elapsedRealtime() - this.mCachedNtpElapsedRealtime;
        }
        return Long.MAX_VALUE;
    }

    private final long $$robo$$android_util_NtpTrustedTime$getCacheCertainty() {
        if (this.mHasCache) {
            return this.mCachedNtpCertainty;
        }
        return Long.MAX_VALUE;
    }

    private final long $$robo$$android_util_NtpTrustedTime$currentTimeMillis() {
        if (!this.mHasCache) {
            throw new IllegalStateException("Missing authoritative time source");
        }
        return this.mCachedNtpTime + this.getCacheAge();
    }

    private final long $$robo$$android_util_NtpTrustedTime$getCachedNtpTime() {
        return this.mCachedNtpTime;
    }

    private final long $$robo$$android_util_NtpTrustedTime$getCachedNtpTimeReference() {
        return this.mCachedNtpElapsedRealtime;
    }

    private void __constructor__(String string2, long l) {
        this.$$robo$$android_util_NtpTrustedTime$__constructor__(string2, l);
    }

    private NtpTrustedTime(String string2, long l) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_NtpTrustedTime$__constructor__(java.lang.String long ), 0, this, string2, l);
    }

    public static synchronized NtpTrustedTime getInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("getInstance", $$robo$$android_util_NtpTrustedTime$getInstance(android.content.Context ), 0, (Context)context);
    }

    @Override
    public boolean forceRefresh() {
        return (boolean)InvokeDynamicSupport.bootstrap("forceRefresh", $$robo$$android_util_NtpTrustedTime$forceRefresh(), 0, this);
    }

    @Override
    public boolean hasCache() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCache", $$robo$$android_util_NtpTrustedTime$hasCache(), 0, this);
    }

    @Override
    public long getCacheAge() {
        return (long)InvokeDynamicSupport.bootstrap("getCacheAge", $$robo$$android_util_NtpTrustedTime$getCacheAge(), 0, this);
    }

    @Override
    public long getCacheCertainty() {
        return (long)InvokeDynamicSupport.bootstrap("getCacheCertainty", $$robo$$android_util_NtpTrustedTime$getCacheCertainty(), 0, this);
    }

    @Override
    public long currentTimeMillis() {
        return (long)InvokeDynamicSupport.bootstrap("currentTimeMillis", $$robo$$android_util_NtpTrustedTime$currentTimeMillis(), 0, this);
    }

    public long getCachedNtpTime() {
        return (long)InvokeDynamicSupport.bootstrap("getCachedNtpTime", $$robo$$android_util_NtpTrustedTime$getCachedNtpTime(), 0, this);
    }

    public long getCachedNtpTimeReference() {
        return (long)InvokeDynamicSupport.bootstrap("getCachedNtpTimeReference", $$robo$$android_util_NtpTrustedTime$getCachedNtpTimeReference(), 0, this);
    }

    public /* synthetic */ NtpTrustedTime() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NtpTrustedTime)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

