/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import java.util.Calendar;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class MonthDisplayHelper
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private int mWeekStartDay;
    private Calendar mCalendar;
    private int mNumDaysInMonth;
    private int mNumDaysInPrevMonth;
    private int mOffset;

    private void $$robo$$android_util_MonthDisplayHelper$__constructor__(int year, int month, int weekStartDay) {
        if (weekStartDay < 1 || weekStartDay > 7) {
            throw new IllegalArgumentException();
        }
        this.mWeekStartDay = weekStartDay;
        this.mCalendar = Calendar.getInstance();
        this.mCalendar.set(1, year);
        this.mCalendar.set(2, month);
        this.mCalendar.set(5, 1);
        this.mCalendar.set(11, 0);
        this.mCalendar.set(12, 0);
        this.mCalendar.set(13, 0);
        this.mCalendar.getTimeInMillis();
        this.recalculate();
    }

    private void $$robo$$android_util_MonthDisplayHelper$__constructor__(int year, int month) {
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getYear() {
        return this.mCalendar.get(1);
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getMonth() {
        return this.mCalendar.get(2);
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getWeekStartDay() {
        return this.mWeekStartDay;
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getFirstDayOfMonth() {
        return this.mCalendar.get(7);
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getNumberOfDaysInMonth() {
        return this.mNumDaysInMonth;
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getOffset() {
        return this.mOffset;
    }

    private final int[] $$robo$$android_util_MonthDisplayHelper$getDigitsForRow(int row) {
        if (row < 0 || row > 5) {
            throw new IllegalArgumentException("row " + row + " out of range (0-5)");
        }
        int[] result = new int[7];
        for (int column = 0; column < 7; ++column) {
            result[column] = this.getDayAt(row, column);
        }
        return result;
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getDayAt(int row, int column) {
        if (row == 0 && column < this.mOffset) {
            return this.mNumDaysInPrevMonth + column - this.mOffset + 1;
        }
        int day = 7 * row + column - this.mOffset + 1;
        return day > this.mNumDaysInMonth ? day - this.mNumDaysInMonth : day;
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getRowOf(int day) {
        return (day + this.mOffset - 1) / 7;
    }

    private final int $$robo$$android_util_MonthDisplayHelper$getColumnOf(int day) {
        return (day + this.mOffset - 1) % 7;
    }

    private final void $$robo$$android_util_MonthDisplayHelper$previousMonth() {
        this.mCalendar.add(2, -1);
        this.recalculate();
    }

    private final void $$robo$$android_util_MonthDisplayHelper$nextMonth() {
        this.mCalendar.add(2, 1);
        this.recalculate();
    }

    private final boolean $$robo$$android_util_MonthDisplayHelper$isWithinCurrentMonth(int row, int column) {
        if (row < 0 || column < 0 || row > 5 || column > 6) {
            return false;
        }
        if (row == 0 && column < this.mOffset) {
            return false;
        }
        int day = 7 * row + column - this.mOffset + 1;
        return day <= this.mNumDaysInMonth;
    }

    private final void $$robo$$android_util_MonthDisplayHelper$recalculate() {
        this.mNumDaysInMonth = this.mCalendar.getActualMaximum(5);
        this.mCalendar.add(2, -1);
        this.mNumDaysInPrevMonth = this.mCalendar.getActualMaximum(5);
        this.mCalendar.add(2, 1);
        int firstDayOfMonth = this.getFirstDayOfMonth();
        int offset = firstDayOfMonth - this.mWeekStartDay;
        if (offset < 0) {
            offset += 7;
        }
        this.mOffset = offset;
    }

    private void __constructor__(int n, int n2, int n3) {
        this.$$robo$$android_util_MonthDisplayHelper$__constructor__(n, n2, n3);
    }

    public MonthDisplayHelper(int n, int n2, int n3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MonthDisplayHelper$__constructor__(int int int ), 0, this, n, n2, n3);
    }

    private void __constructor__(int n, int n2) {
        this.$$robo$$android_util_MonthDisplayHelper$__constructor__(n, n2);
    }

    public MonthDisplayHelper(int n, int n2) {
        this(n, n2, 1);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_MonthDisplayHelper$__constructor__(int int ), 0, this, n, n2);
    }

    public int getYear() {
        return (int)InvokeDynamicSupport.bootstrap("getYear", $$robo$$android_util_MonthDisplayHelper$getYear(), 0, this);
    }

    public int getMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getMonth", $$robo$$android_util_MonthDisplayHelper$getMonth(), 0, this);
    }

    public int getWeekStartDay() {
        return (int)InvokeDynamicSupport.bootstrap("getWeekStartDay", $$robo$$android_util_MonthDisplayHelper$getWeekStartDay(), 0, this);
    }

    public int getFirstDayOfMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getFirstDayOfMonth", $$robo$$android_util_MonthDisplayHelper$getFirstDayOfMonth(), 0, this);
    }

    public int getNumberOfDaysInMonth() {
        return (int)InvokeDynamicSupport.bootstrap("getNumberOfDaysInMonth", $$robo$$android_util_MonthDisplayHelper$getNumberOfDaysInMonth(), 0, this);
    }

    public int getOffset() {
        return (int)InvokeDynamicSupport.bootstrap("getOffset", $$robo$$android_util_MonthDisplayHelper$getOffset(), 0, this);
    }

    public int[] getDigitsForRow(int n) {
        return InvokeDynamicSupport.bootstrap("getDigitsForRow", $$robo$$android_util_MonthDisplayHelper$getDigitsForRow(int ), 0, this, n);
    }

    public int getDayAt(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("getDayAt", $$robo$$android_util_MonthDisplayHelper$getDayAt(int int ), 0, this, n, n2);
    }

    public int getRowOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getRowOf", $$robo$$android_util_MonthDisplayHelper$getRowOf(int ), 0, this, n);
    }

    public int getColumnOf(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getColumnOf", $$robo$$android_util_MonthDisplayHelper$getColumnOf(int ), 0, this, n);
    }

    public void previousMonth() {
        InvokeDynamicSupport.bootstrap("previousMonth", $$robo$$android_util_MonthDisplayHelper$previousMonth(), 0, this);
    }

    public void nextMonth() {
        InvokeDynamicSupport.bootstrap("nextMonth", $$robo$$android_util_MonthDisplayHelper$nextMonth(), 0, this);
    }

    public boolean isWithinCurrentMonth(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isWithinCurrentMonth", $$robo$$android_util_MonthDisplayHelper$isWithinCurrentMonth(int int ), 0, this, n, n2);
    }

    private void recalculate() {
        InvokeDynamicSupport.bootstrap("recalculate", $$robo$$android_util_MonthDisplayHelper$recalculate(), 0, this);
    }

    public /* synthetic */ MonthDisplayHelper() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MonthDisplayHelper)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

