/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.AdaptiveIconDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.LayerDrawable;
import android.util.SparseArray;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class LauncherIcons
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static float ICON_SIZE_BLUR_FACTOR = 0.010416667f;
    private static float ICON_SIZE_KEY_SHADOW_DELTA_FACTOR = 0.020833334f;
    private static int KEY_SHADOW_ALPHA = 61;
    private static int AMBIENT_SHADOW_ALPHA = 30;
    private SparseArray<Bitmap> mShadowCache;
    private int mIconSize;
    private Resources mRes;

    private void $$robo$$android_util_LauncherIcons$__constructor__(Context context) {
        this.mShadowCache = new SparseArray();
        this.mRes = context.getResources();
        this.mIconSize = this.mRes.getDimensionPixelSize(0x1050000);
    }

    private final Drawable $$robo$$android_util_LauncherIcons$wrapIconDrawableWithShadow(Drawable drawable2) {
        if (!(drawable2 instanceof AdaptiveIconDrawable)) {
            return drawable2;
        }
        Bitmap shadow = this.getShadowBitmap((AdaptiveIconDrawable)drawable2);
        return new ShadowDrawable(shadow, drawable2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Bitmap $$robo$$android_util_LauncherIcons$getShadowBitmap(AdaptiveIconDrawable d) {
        int shadowSize = Math.max(this.mIconSize, d.getIntrinsicHeight());
        SparseArray<Bitmap> sparseArray = this.mShadowCache;
        synchronized (sparseArray) {
            Bitmap shadow = this.mShadowCache.get(shadowSize);
            if (shadow != null) {
                return shadow;
            }
        }
        d.setBounds(0, 0, shadowSize, shadowSize);
        float blur = 0.010416667f * (float)shadowSize;
        float keyShadowDistance = 0.020833334f * (float)shadowSize;
        int bitmapSize = (int)((float)shadowSize + 2.0f * blur + keyShadowDistance);
        Bitmap shadow = Bitmap.createBitmap(bitmapSize, bitmapSize, Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(shadow);
        canvas.translate(blur + keyShadowDistance / 2.0f, blur);
        Paint paint = new Paint(1);
        paint.setColor(0);
        paint.setShadowLayer(blur, 0.0f, 0.0f, 0x1E000000);
        canvas.drawPath(d.getIconMask(), paint);
        canvas.translate(0.0f, keyShadowDistance);
        paint.setShadowLayer(blur, 0.0f, 0.0f, 0x3D000000);
        canvas.drawPath(d.getIconMask(), paint);
        canvas.setBitmap(null);
        SparseArray<Bitmap> sparseArray2 = this.mShadowCache;
        synchronized (sparseArray2) {
            this.mShadowCache.put(shadowSize, shadow);
        }
        return shadow;
    }

    private final Drawable $$robo$$android_util_LauncherIcons$getBadgeDrawable(int foregroundRes, int backgroundColor) {
        return this.getBadgedDrawable(null, foregroundRes, backgroundColor);
    }

    private final Drawable $$robo$$android_util_LauncherIcons$getBadgedDrawable(Drawable base, int foregroundRes, int backgroundColor) {
        Drawable[] drawableArray;
        Resources sysRes = Resources.getSystem();
        Drawable badgeShadow = sysRes.getDrawable(17302326);
        Drawable badgeColor = sysRes.getDrawable(17302325).getConstantState().newDrawable().mutate();
        badgeColor.setTint(backgroundColor);
        Drawable badgeForeground = sysRes.getDrawable(foregroundRes);
        if (base == null) {
            Drawable[] drawableArray2 = new Drawable[3];
            drawableArray2[0] = badgeShadow;
            drawableArray2[1] = badgeColor;
            drawableArray = drawableArray2;
            drawableArray2[2] = badgeForeground;
        } else {
            Drawable[] drawableArray3 = new Drawable[4];
            drawableArray3[0] = base;
            drawableArray3[1] = badgeShadow;
            drawableArray3[2] = badgeColor;
            drawableArray = drawableArray3;
            drawableArray3[3] = badgeForeground;
        }
        Drawable[] drawables = drawableArray;
        return new LayerDrawable(drawables);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_util_LauncherIcons$__constructor__(context);
    }

    public LauncherIcons(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LauncherIcons$__constructor__(android.content.Context ), 0, this, context);
    }

    public Drawable wrapIconDrawableWithShadow(Drawable drawable2) {
        return InvokeDynamicSupport.bootstrap("wrapIconDrawableWithShadow", $$robo$$android_util_LauncherIcons$wrapIconDrawableWithShadow(android.graphics.drawable.Drawable ), 0, this, drawable2);
    }

    private Bitmap getShadowBitmap(AdaptiveIconDrawable adaptiveIconDrawable) {
        return InvokeDynamicSupport.bootstrap("getShadowBitmap", $$robo$$android_util_LauncherIcons$getShadowBitmap(android.graphics.drawable.AdaptiveIconDrawable ), 0, this, adaptiveIconDrawable);
    }

    public Drawable getBadgeDrawable(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getBadgeDrawable", $$robo$$android_util_LauncherIcons$getBadgeDrawable(int int ), 0, this, n, n2);
    }

    public Drawable getBadgedDrawable(Drawable drawable2, int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getBadgedDrawable", $$robo$$android_util_LauncherIcons$getBadgedDrawable(android.graphics.drawable.Drawable int int ), 0, this, drawable2, n, n2);
    }

    public /* synthetic */ LauncherIcons() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LauncherIcons)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class ShadowDrawable
    extends DrawableWrapper
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        MyConstantState mState;

        private void $$robo$$android_util_LauncherIcons_ShadowDrawable$__constructor__(Bitmap shadow, Drawable dr) {
            this.mState = new MyConstantState(shadow, dr.getConstantState());
        }

        private void $$robo$$android_util_LauncherIcons_ShadowDrawable$__constructor__(MyConstantState state) {
            this.mState = state;
        }

        private final Drawable.ConstantState $$robo$$android_util_LauncherIcons_ShadowDrawable$getConstantState() {
            return this.mState;
        }

        private final void $$robo$$android_util_LauncherIcons_ShadowDrawable$draw(Canvas canvas) {
            Rect bounds = this.getBounds();
            canvas.drawBitmap(this.mState.mShadow, null, bounds, this.mState.mPaint);
            canvas.save();
            float factor = 0.9599999f;
            canvas.translate((float)bounds.width() * factor * 0.020833334f, (float)bounds.height() * factor * 0.010416667f);
            canvas.scale(factor, factor);
            super.draw(canvas);
            canvas.restore();
        }

        private void __constructor__(Bitmap bitmap, Drawable drawable2) {
            this.$$robo$$android_util_LauncherIcons_ShadowDrawable$__constructor__(bitmap, drawable2);
        }

        public ShadowDrawable(Bitmap bitmap, Drawable drawable2) {
            super(drawable2);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LauncherIcons_ShadowDrawable$__constructor__(android.graphics.Bitmap android.graphics.drawable.Drawable ), 0, this, bitmap, drawable2);
        }

        private void __constructor__(MyConstantState myConstantState) {
            this.$$robo$$android_util_LauncherIcons_ShadowDrawable$__constructor__(myConstantState);
        }

        ShadowDrawable(MyConstantState myConstantState) {
            super(myConstantState.mChildState.newDrawable());
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LauncherIcons_ShadowDrawable$__constructor__(android.util.LauncherIcons$ShadowDrawable$MyConstantState ), 0, this, myConstantState);
        }

        @Override
        public Drawable.ConstantState getConstantState() {
            return InvokeDynamicSupport.bootstrap("getConstantState", $$robo$$android_util_LauncherIcons_ShadowDrawable$getConstantState(), 0, this);
        }

        @Override
        public void draw(Canvas canvas) {
            InvokeDynamicSupport.bootstrap("draw", $$robo$$android_util_LauncherIcons_ShadowDrawable$draw(android.graphics.Canvas ), 0, this, canvas);
        }

        public /* synthetic */ ShadowDrawable() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ShadowDrawable)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private static class MyConstantState
        extends Drawable.ConstantState
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            Paint mPaint;
            Bitmap mShadow;
            Drawable.ConstantState mChildState;

            private void $$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$__constructor__(Bitmap shadow, Drawable.ConstantState childState) {
                this.mPaint = new Paint(2);
                this.mShadow = shadow;
                this.mChildState = childState;
            }

            private final Drawable $$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$newDrawable() {
                return new ShadowDrawable(this);
            }

            private final int $$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$getChangingConfigurations() {
                return this.mChildState.getChangingConfigurations();
            }

            private void __constructor__(Bitmap bitmap, Drawable.ConstantState constantState) {
                this.$$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$__constructor__(bitmap, constantState);
            }

            MyConstantState(Bitmap bitmap, Drawable.ConstantState constantState) {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$__constructor__(android.graphics.Bitmap android.graphics.drawable.Drawable$ConstantState ), 0, this, bitmap, constantState);
            }

            @Override
            public Drawable newDrawable() {
                return InvokeDynamicSupport.bootstrap("newDrawable", $$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$newDrawable(), 0, this);
            }

            @Override
            public int getChangingConfigurations() {
                return (int)InvokeDynamicSupport.bootstrap("getChangingConfigurations", $$robo$$android_util_LauncherIcons_ShadowDrawable_MyConstantState$getChangingConfigurations(), 0, this);
            }

            public /* synthetic */ MyConstantState() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MyConstantState)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }
}

