/*
 * Decompiled with CFR 0.152.
 */
package android.util;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.UserHandle;
import android.os.UserManager;
import android.util.LauncherIcons;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IconDrawableFactory
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected Context mContext;
    protected PackageManager mPm;
    protected UserManager mUm;
    protected LauncherIcons mLauncherIcons;
    protected boolean mEmbedShadow;
    public static int[] CORP_BADGE_COLORS;

    private void $$robo$$android_util_IconDrawableFactory$__constructor__(Context context, boolean embedShadow) {
        this.mContext = context;
        this.mPm = context.getPackageManager();
        this.mUm = context.getSystemService(UserManager.class);
        this.mLauncherIcons = new LauncherIcons(context);
        this.mEmbedShadow = embedShadow;
    }

    private final boolean $$robo$$android_util_IconDrawableFactory$needsBadging(ApplicationInfo appInfo, int userId) {
        return appInfo.isInstantApp() || this.mUm.isManagedProfile(userId);
    }

    private final Drawable $$robo$$android_util_IconDrawableFactory$getBadgedIcon(ApplicationInfo appInfo) {
        return this.getBadgedIcon(appInfo, UserHandle.getUserId(appInfo.uid));
    }

    private final Drawable $$robo$$android_util_IconDrawableFactory$getBadgedIcon(ApplicationInfo appInfo, int userId) {
        return this.getBadgedIcon(appInfo, appInfo, userId);
    }

    private final Drawable $$robo$$android_util_IconDrawableFactory$getBadgedIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo, int userId) {
        Drawable icon = this.mPm.loadUnbadgedItemIcon(itemInfo, appInfo);
        if (!this.mEmbedShadow && !this.needsBadging(appInfo, userId)) {
            return icon;
        }
        icon = this.mLauncherIcons.wrapIconDrawableWithShadow(icon);
        if (appInfo.isInstantApp()) {
            int badgeColor = Resources.getSystem().getColor(17170596, null);
            icon = this.mLauncherIcons.getBadgedDrawable(icon, 17302386, badgeColor);
        }
        if (this.mUm.isManagedProfile(userId)) {
            icon = this.mLauncherIcons.getBadgedDrawable(icon, 17302324, IconDrawableFactory.getUserBadgeColor(this.mUm, userId));
        }
        return icon;
    }

    private static final int $$robo$$android_util_IconDrawableFactory$getUserBadgeColor(UserManager um, int userId) {
        int badge = um.getManagedProfileBadge(userId);
        if (badge < 0) {
            badge = 0;
        }
        int resourceId = CORP_BADGE_COLORS[badge % CORP_BADGE_COLORS.length];
        return Resources.getSystem().getColor(resourceId, null);
    }

    private static final IconDrawableFactory $$robo$$android_util_IconDrawableFactory$newInstance(Context context) {
        return new IconDrawableFactory(context, true);
    }

    private static final IconDrawableFactory $$robo$$android_util_IconDrawableFactory$newInstance(Context context, boolean embedShadow) {
        return new IconDrawableFactory(context, embedShadow);
    }

    static void __staticInitializer__() {
        CORP_BADGE_COLORS = new int[]{17170712, 17170713, 17170714};
    }

    private void __constructor__(Context context, boolean bl) {
        this.$$robo$$android_util_IconDrawableFactory$__constructor__(context, bl);
    }

    private IconDrawableFactory(Context context, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_util_IconDrawableFactory$__constructor__(android.content.Context boolean ), 0, this, context, bl);
    }

    protected boolean needsBadging(ApplicationInfo applicationInfo, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("needsBadging", $$robo$$android_util_IconDrawableFactory$needsBadging(android.content.pm.ApplicationInfo int ), 0, this, applicationInfo, n);
    }

    public Drawable getBadgedIcon(ApplicationInfo applicationInfo) {
        return InvokeDynamicSupport.bootstrap("getBadgedIcon", $$robo$$android_util_IconDrawableFactory$getBadgedIcon(android.content.pm.ApplicationInfo ), 0, this, applicationInfo);
    }

    public Drawable getBadgedIcon(ApplicationInfo applicationInfo, int n) {
        return InvokeDynamicSupport.bootstrap("getBadgedIcon", $$robo$$android_util_IconDrawableFactory$getBadgedIcon(android.content.pm.ApplicationInfo int ), 0, this, applicationInfo, n);
    }

    public Drawable getBadgedIcon(PackageItemInfo packageItemInfo, ApplicationInfo applicationInfo, int n) {
        return InvokeDynamicSupport.bootstrap("getBadgedIcon", $$robo$$android_util_IconDrawableFactory$getBadgedIcon(android.content.pm.PackageItemInfo android.content.pm.ApplicationInfo int ), 0, this, packageItemInfo, applicationInfo, n);
    }

    public static int getUserBadgeColor(UserManager userManager, int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getUserBadgeColor", $$robo$$android_util_IconDrawableFactory$getUserBadgeColor(android.os.UserManager int ), 0, (UserManager)userManager, (int)n);
    }

    public static IconDrawableFactory newInstance(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_util_IconDrawableFactory$newInstance(android.content.Context ), 0, (Context)context);
    }

    public static IconDrawableFactory newInstance(Context context, boolean bl) {
        return InvokeDynamicSupport.bootstrapStatic("newInstance", $$robo$$android_util_IconDrawableFactory$newInstance(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    static {
        RobolectricInternals.classInitializing(IconDrawableFactory.class);
    }

    public /* synthetic */ IconDrawableFactory() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IconDrawableFactory)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

