/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.animation.Animator;
import android.annotation.IntDef;
import android.content.Context;
import android.content.res.TypedArray;
import android.transition.Transition;
import android.transition.TransitionListenerAdapter;
import android.transition.TransitionUtils;
import android.transition.TransitionValues;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewGroupOverlay;
import com.android.internal.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class Visibility
extends Transition
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String PROPNAME_VISIBILITY = "android:visibility:visibility";
    private static String PROPNAME_PARENT = "android:visibility:parent";
    private static String PROPNAME_SCREEN_LOCATION = "android:visibility:screenLocation";
    public static int MODE_IN = 1;
    public static int MODE_OUT = 2;
    private static String[] sTransitionProperties;
    private int mMode;
    private boolean mSuppressLayout;

    private void $$robo$$android_transition_Visibility$__constructor__() {
        this.mMode = 3;
        this.mSuppressLayout = true;
    }

    private void $$robo$$android_transition_Visibility$__constructor__(Context context, AttributeSet attrs) {
        this.mMode = 3;
        this.mSuppressLayout = true;
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.VisibilityTransition);
        int mode = a.getInt(0, 0);
        a.recycle();
        if (mode != 0) {
            this.setMode(mode);
        }
    }

    private final void $$robo$$android_transition_Visibility$setSuppressLayout(boolean suppress) {
        this.mSuppressLayout = suppress;
    }

    private final void $$robo$$android_transition_Visibility$setMode(int mode) {
        if ((mode & 0xFFFFFFFC) != 0) {
            throw new IllegalArgumentException("Only MODE_IN and MODE_OUT flags are allowed");
        }
        this.mMode = mode;
    }

    private final int $$robo$$android_transition_Visibility$getMode() {
        return this.mMode;
    }

    private final String[] $$robo$$android_transition_Visibility$getTransitionProperties() {
        return sTransitionProperties;
    }

    private final void $$robo$$android_transition_Visibility$captureValues(TransitionValues transitionValues) {
        int visibility = transitionValues.view.getVisibility();
        transitionValues.values.put("android:visibility:visibility", visibility);
        transitionValues.values.put("android:visibility:parent", transitionValues.view.getParent());
        int[] loc = new int[2];
        transitionValues.view.getLocationOnScreen(loc);
        transitionValues.values.put("android:visibility:screenLocation", loc);
    }

    private final void $$robo$$android_transition_Visibility$captureStartValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private final void $$robo$$android_transition_Visibility$captureEndValues(TransitionValues transitionValues) {
        this.captureValues(transitionValues);
    }

    private final boolean $$robo$$android_transition_Visibility$isVisible(TransitionValues values) {
        if (values == null) {
            return false;
        }
        int visibility = (Integer)values.values.get("android:visibility:visibility");
        View parent = (View)values.values.get("android:visibility:parent");
        return visibility == 0 && parent != null;
    }

    private static final VisibilityInfo $$robo$$android_transition_Visibility$getVisibilityChangeInfo(TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = new VisibilityInfo();
        visInfo.visibilityChange = false;
        visInfo.fadeIn = false;
        if (startValues != null && startValues.values.containsKey("android:visibility:visibility")) {
            visInfo.startVisibility = (Integer)startValues.values.get("android:visibility:visibility");
            visInfo.startParent = (ViewGroup)startValues.values.get("android:visibility:parent");
        } else {
            visInfo.startVisibility = -1;
            visInfo.startParent = null;
        }
        if (endValues != null && endValues.values.containsKey("android:visibility:visibility")) {
            visInfo.endVisibility = (Integer)endValues.values.get("android:visibility:visibility");
            visInfo.endParent = (ViewGroup)endValues.values.get("android:visibility:parent");
        } else {
            visInfo.endVisibility = -1;
            visInfo.endParent = null;
        }
        if (startValues != null && endValues != null) {
            if (visInfo.startVisibility == visInfo.endVisibility && visInfo.startParent == visInfo.endParent) {
                return visInfo;
            }
            if (visInfo.startVisibility != visInfo.endVisibility) {
                if (visInfo.startVisibility == 0) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.endVisibility == 0) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            } else if (visInfo.startParent != visInfo.endParent) {
                if (visInfo.endParent == null) {
                    visInfo.fadeIn = false;
                    visInfo.visibilityChange = true;
                } else if (visInfo.startParent == null) {
                    visInfo.fadeIn = true;
                    visInfo.visibilityChange = true;
                }
            }
        } else if (startValues == null && visInfo.endVisibility == 0) {
            visInfo.fadeIn = true;
            visInfo.visibilityChange = true;
        } else if (endValues == null && visInfo.startVisibility == 0) {
            visInfo.fadeIn = false;
            visInfo.visibilityChange = true;
        }
        return visInfo;
    }

    private final Animator $$robo$$android_transition_Visibility$createAnimator(ViewGroup sceneRoot, TransitionValues startValues, TransitionValues endValues) {
        VisibilityInfo visInfo = Visibility.getVisibilityChangeInfo(startValues, endValues);
        if (visInfo.visibilityChange && (visInfo.startParent != null || visInfo.endParent != null)) {
            if (visInfo.fadeIn) {
                return this.onAppear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
            }
            return this.onDisappear(sceneRoot, startValues, visInfo.startVisibility, endValues, visInfo.endVisibility);
        }
        return null;
    }

    private final Animator $$robo$$android_transition_Visibility$onAppear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 1) != 1 || endValues == null) {
            return null;
        }
        if (startValues == null) {
            VisibilityInfo parentVisibilityInfo = null;
            View endParent = (View)((Object)endValues.view.getParent());
            TransitionValues startParentValues = this.getMatchedTransitionValues(endParent, false);
            TransitionValues endParentValues = this.getTransitionValues(endParent, false);
            parentVisibilityInfo = Visibility.getVisibilityChangeInfo(startParentValues, endParentValues);
            if (parentVisibilityInfo.visibilityChange) {
                return null;
            }
        }
        return this.onAppear(sceneRoot, endValues.view, startValues, endValues);
    }

    private final Animator $$robo$$android_transition_Visibility$onAppear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    private final Animator $$robo$$android_transition_Visibility$onDisappear(ViewGroup sceneRoot, TransitionValues startValues, int startVisibility, TransitionValues endValues, int endVisibility) {
        if ((this.mMode & 2) != 2) {
            return null;
        }
        View startView = startValues != null ? startValues.view : null;
        View endView = endValues != null ? endValues.view : null;
        View overlayView = null;
        View viewToKeep = null;
        if (endView == null || endView.getParent() == null) {
            if (endView != null) {
                overlayView = endView;
            } else if (startView != null) {
                if (startView.getParent() == null) {
                    overlayView = startView;
                } else if (startView.getParent() instanceof View) {
                    int id2;
                    View startParent = (View)((Object)startView.getParent());
                    TransitionValues startParentValues = this.getTransitionValues(startParent, true);
                    TransitionValues endParentValues = this.getMatchedTransitionValues(startParent, true);
                    VisibilityInfo parentVisibilityInfo = Visibility.getVisibilityChangeInfo(startParentValues, endParentValues);
                    if (!parentVisibilityInfo.visibilityChange) {
                        overlayView = TransitionUtils.copyViewImage(sceneRoot, startView, startParent);
                    } else if (startParent.getParent() == null && (id2 = startParent.getId()) != -1 && sceneRoot.findViewById(id2) != null && this.mCanRemoveViews) {
                        overlayView = startView;
                    }
                }
            }
        } else if (endVisibility == 4) {
            viewToKeep = endView;
        } else if (startView == endView) {
            viewToKeep = endView;
        } else {
            overlayView = startView;
        }
        int finalVisibility = endVisibility;
        ViewGroup finalSceneRoot = sceneRoot;
        if (overlayView != null) {
            int[] screenLoc = (int[])startValues.values.get("android:visibility:screenLocation");
            int screenX = screenLoc[0];
            int screenY = screenLoc[1];
            int[] loc = new int[2];
            sceneRoot.getLocationOnScreen(loc);
            overlayView.offsetLeftAndRight(screenX - loc[0] - overlayView.getLeft());
            overlayView.offsetTopAndBottom(screenY - loc[1] - overlayView.getTop());
            ((ViewGroupOverlay)sceneRoot.getOverlay()).add(overlayView);
            Animator animator2 = this.onDisappear(sceneRoot, overlayView, startValues, endValues);
            if (animator2 == null) {
                ((ViewGroupOverlay)sceneRoot.getOverlay()).remove(overlayView);
            } else {
                View finalOverlayView = overlayView;
                this.addListener((Transition.TransitionListener)new ShadowedObject(this, finalSceneRoot, finalOverlayView){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ ViewGroup val$finalSceneRoot;
                    /* synthetic */ View val$finalOverlayView;
                    /* synthetic */ Visibility this$0;

                    private void $$robo$$android_transition_Visibility_1$__constructor__(Visibility this$0, ViewGroup viewGroup, View view) {
                    }

                    private final void $$robo$$android_transition_Visibility_1$onTransitionEnd(Transition transition2) {
                        ((ViewGroupOverlay)this.val$finalSceneRoot.getOverlay()).remove(this.val$finalOverlayView);
                        transition2.removeListener(this);
                    }

                    private void __constructor__(Visibility visibility, ViewGroup viewGroup, View view) {
                        this.$$robo$$android_transition_Visibility_1$__constructor__(visibility, viewGroup, view);
                    }
                    {
                        this.this$0 = visibility;
                        this.val$finalSceneRoot = viewGroup;
                        this.val$finalOverlayView = view;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility_1$__constructor__(android.transition.Visibility android.view.ViewGroup android.view.View ), 0, this, visibility, viewGroup, view);
                    }

                    @Override
                    public void onTransitionEnd(Transition transition2) {
                        InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_transition_Visibility_1$onTransitionEnd(android.transition.Transition ), 0, this, transition2);
                    }
                    {
                        this.$$robo$init();
                    }

                    @Override
                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    @Override
                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
            return animator2;
        }
        if (viewToKeep != null) {
            int originalVisibility = viewToKeep.getVisibility();
            viewToKeep.setTransitionVisibility(0);
            Animator animator3 = this.onDisappear(sceneRoot, viewToKeep, startValues, endValues);
            if (animator3 != null) {
                DisappearListener disappearListener = new DisappearListener(viewToKeep, finalVisibility, this.mSuppressLayout);
                animator3.addListener(disappearListener);
                animator3.addPauseListener(disappearListener);
                this.addListener(disappearListener);
            } else {
                viewToKeep.setTransitionVisibility(originalVisibility);
            }
            return animator3;
        }
        return null;
    }

    private final boolean $$robo$$android_transition_Visibility$isTransitionRequired(TransitionValues startValues, TransitionValues newValues) {
        if (startValues == null && newValues == null) {
            return false;
        }
        if (startValues != null && newValues != null && newValues.values.containsKey("android:visibility:visibility") != startValues.values.containsKey("android:visibility:visibility")) {
            return false;
        }
        VisibilityInfo changeInfo = Visibility.getVisibilityChangeInfo(startValues, newValues);
        return changeInfo.visibilityChange && (changeInfo.startVisibility == 0 || changeInfo.endVisibility == 0);
    }

    private final Animator $$robo$$android_transition_Visibility$onDisappear(ViewGroup sceneRoot, View view, TransitionValues startValues, TransitionValues endValues) {
        return null;
    }

    static void __staticInitializer__() {
        sTransitionProperties = new String[]{"android:visibility:visibility", "android:visibility:parent"};
    }

    private void __constructor__() {
        this.$$robo$$android_transition_Visibility$__constructor__();
    }

    public Visibility() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility$__constructor__(), 0, this);
    }

    private void __constructor__(Context context, AttributeSet attributeSet) {
        this.$$robo$$android_transition_Visibility$__constructor__(context, attributeSet);
    }

    public Visibility(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility$__constructor__(android.content.Context android.util.AttributeSet ), 0, this, context, attributeSet);
    }

    public void setSuppressLayout(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSuppressLayout", $$robo$$android_transition_Visibility$setSuppressLayout(boolean ), 0, this, bl);
    }

    public void setMode(int n) {
        InvokeDynamicSupport.bootstrap("setMode", $$robo$$android_transition_Visibility$setMode(int ), 0, this, n);
    }

    public int getMode() {
        return (int)InvokeDynamicSupport.bootstrap("getMode", $$robo$$android_transition_Visibility$getMode(), 0, this);
    }

    @Override
    public String[] getTransitionProperties() {
        return InvokeDynamicSupport.bootstrap("getTransitionProperties", $$robo$$android_transition_Visibility$getTransitionProperties(), 0, this);
    }

    private void captureValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureValues", $$robo$$android_transition_Visibility$captureValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureStartValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureStartValues", $$robo$$android_transition_Visibility$captureStartValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    @Override
    public void captureEndValues(TransitionValues transitionValues) {
        InvokeDynamicSupport.bootstrap("captureEndValues", $$robo$$android_transition_Visibility$captureEndValues(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    public boolean isVisible(TransitionValues transitionValues) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisible", $$robo$$android_transition_Visibility$isVisible(android.transition.TransitionValues ), 0, this, transitionValues);
    }

    private static VisibilityInfo getVisibilityChangeInfo(TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrapStatic("getVisibilityChangeInfo", $$robo$$android_transition_Visibility$getVisibilityChangeInfo(android.transition.TransitionValues android.transition.TransitionValues ), 0, (TransitionValues)transitionValues, (TransitionValues)transitionValues2);
    }

    @Override
    public Animator createAnimator(ViewGroup viewGroup, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("createAnimator", $$robo$$android_transition_Visibility$createAnimator(android.view.ViewGroup android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, transitionValues, transitionValues2);
    }

    public Animator onAppear(ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, int n2) {
        return InvokeDynamicSupport.bootstrap("onAppear", $$robo$$android_transition_Visibility$onAppear(android.view.ViewGroup android.transition.TransitionValues int android.transition.TransitionValues int ), 0, this, viewGroup, transitionValues, n, transitionValues2, n2);
    }

    public Animator onAppear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("onAppear", $$robo$$android_transition_Visibility$onAppear(android.view.ViewGroup android.view.View android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, view, transitionValues, transitionValues2);
    }

    public Animator onDisappear(ViewGroup viewGroup, TransitionValues transitionValues, int n, TransitionValues transitionValues2, int n2) {
        return InvokeDynamicSupport.bootstrap("onDisappear", $$robo$$android_transition_Visibility$onDisappear(android.view.ViewGroup android.transition.TransitionValues int android.transition.TransitionValues int ), 0, this, viewGroup, transitionValues, n, transitionValues2, n2);
    }

    @Override
    public boolean isTransitionRequired(TransitionValues transitionValues, TransitionValues transitionValues2) {
        return (boolean)InvokeDynamicSupport.bootstrap("isTransitionRequired", $$robo$$android_transition_Visibility$isTransitionRequired(android.transition.TransitionValues android.transition.TransitionValues ), 0, this, transitionValues, transitionValues2);
    }

    public Animator onDisappear(ViewGroup viewGroup, View view, TransitionValues transitionValues, TransitionValues transitionValues2) {
        return InvokeDynamicSupport.bootstrap("onDisappear", $$robo$$android_transition_Visibility$onDisappear(android.view.ViewGroup android.view.View android.transition.TransitionValues android.transition.TransitionValues ), 0, this, viewGroup, view, transitionValues, transitionValues2);
    }

    static {
        RobolectricInternals.classInitializing(Visibility.class);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Visibility)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class DisappearListener
    extends TransitionListenerAdapter
    implements Animator.AnimatorListener,
    Animator.AnimatorPauseListener,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private View mView;
        private int mFinalVisibility;
        private ViewGroup mParent;
        private boolean mSuppressLayout;
        private boolean mLayoutSuppressed;
        boolean mCanceled;

        private void $$robo$$android_transition_Visibility_DisappearListener$__constructor__(View view, int finalVisibility, boolean suppressLayout) {
            this.mCanceled = false;
            this.mView = view;
            this.mFinalVisibility = finalVisibility;
            this.mParent = (ViewGroup)view.getParent();
            this.mSuppressLayout = suppressLayout;
            this.suppressLayout(true);
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onAnimationPause(Animator animation) {
            if (!this.mCanceled) {
                this.mView.setTransitionVisibility(this.mFinalVisibility);
            }
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onAnimationResume(Animator animation) {
            if (!this.mCanceled) {
                this.mView.setTransitionVisibility(0);
            }
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onAnimationCancel(Animator animation) {
            this.mCanceled = true;
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onAnimationRepeat(Animator animation) {
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onAnimationStart(Animator animation) {
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onAnimationEnd(Animator animation) {
            this.hideViewWhenNotCanceled();
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onTransitionEnd(Transition transition2) {
            this.hideViewWhenNotCanceled();
            transition2.removeListener(this);
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onTransitionPause(Transition transition2) {
            this.suppressLayout(false);
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$onTransitionResume(Transition transition2) {
            this.suppressLayout(true);
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$hideViewWhenNotCanceled() {
            if (!this.mCanceled) {
                this.mView.setTransitionVisibility(this.mFinalVisibility);
                if (this.mParent != null) {
                    this.mParent.invalidate();
                }
            }
            this.suppressLayout(false);
        }

        private final void $$robo$$android_transition_Visibility_DisappearListener$suppressLayout(boolean suppress) {
            if (this.mSuppressLayout && this.mLayoutSuppressed != suppress && this.mParent != null) {
                this.mLayoutSuppressed = suppress;
                this.mParent.suppressLayout(suppress);
            }
        }

        private void __constructor__(View view, int n, boolean bl) {
            this.$$robo$$android_transition_Visibility_DisappearListener$__constructor__(view, n, bl);
        }

        public DisappearListener(View view, int n, boolean bl) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility_DisappearListener$__constructor__(android.view.View int boolean ), 0, this, view, n, bl);
        }

        @Override
        public void onAnimationPause(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationPause", $$robo$$android_transition_Visibility_DisappearListener$onAnimationPause(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationResume(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationResume", $$robo$$android_transition_Visibility_DisappearListener$onAnimationResume(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationCancel", $$robo$$android_transition_Visibility_DisappearListener$onAnimationCancel(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationRepeat", $$robo$$android_transition_Visibility_DisappearListener$onAnimationRepeat(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationStart", $$robo$$android_transition_Visibility_DisappearListener$onAnimationStart(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            InvokeDynamicSupport.bootstrap("onAnimationEnd", $$robo$$android_transition_Visibility_DisappearListener$onAnimationEnd(android.animation.Animator ), 0, this, animator2);
        }

        @Override
        public void onTransitionEnd(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionEnd", $$robo$$android_transition_Visibility_DisappearListener$onTransitionEnd(android.transition.Transition ), 0, this, transition2);
        }

        @Override
        public void onTransitionPause(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionPause", $$robo$$android_transition_Visibility_DisappearListener$onTransitionPause(android.transition.Transition ), 0, this, transition2);
        }

        @Override
        public void onTransitionResume(Transition transition2) {
            InvokeDynamicSupport.bootstrap("onTransitionResume", $$robo$$android_transition_Visibility_DisappearListener$onTransitionResume(android.transition.Transition ), 0, this, transition2);
        }

        private void hideViewWhenNotCanceled() {
            InvokeDynamicSupport.bootstrap("hideViewWhenNotCanceled", $$robo$$android_transition_Visibility_DisappearListener$hideViewWhenNotCanceled(), 0, this);
        }

        private void suppressLayout(boolean bl) {
            InvokeDynamicSupport.bootstrap("suppressLayout", $$robo$$android_transition_Visibility_DisappearListener$suppressLayout(boolean ), 0, this, bl);
        }

        public /* synthetic */ DisappearListener() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DisappearListener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class VisibilityInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        boolean visibilityChange;
        boolean fadeIn;
        int startVisibility;
        int endVisibility;
        ViewGroup startParent;
        ViewGroup endParent;

        private void $$robo$$android_transition_Visibility_VisibilityInfo$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_transition_Visibility_VisibilityInfo$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_transition_Visibility_VisibilityInfo$__constructor__();
        }

        private VisibilityInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_Visibility_VisibilityInfo$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_transition_Visibility_VisibilityInfo$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VisibilityInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(flag=true, value={1L, 2L})
    static @interface VisibilityMode {
    }
}

