/*
 * Decompiled with CFR 0.152.
 */
package android.transition;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.transition.ArcMotion;
import android.transition.AutoTransition;
import android.transition.ChangeBounds;
import android.transition.ChangeClipBounds;
import android.transition.ChangeImageTransform;
import android.transition.ChangeScroll;
import android.transition.ChangeTransform;
import android.transition.Explode;
import android.transition.Fade;
import android.transition.PathMotion;
import android.transition.PatternPathMotion;
import android.transition.Recolor;
import android.transition.Scene;
import android.transition.Slide;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.util.AttributeSet;
import android.util.Xml;
import android.view.InflateException;
import android.view.ViewGroup;
import com.android.internal.R;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class TransitionInflater
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static Class<?>[] sConstructorSignature;
    private static ArrayMap<String, Constructor> sConstructors;
    private Context mContext;

    private void $$robo$$android_transition_TransitionInflater$__constructor__(Context context) {
        this.mContext = context;
    }

    private static final TransitionInflater $$robo$$android_transition_TransitionInflater$from(Context context) {
        return new TransitionInflater(context);
    }

    private final Transition $$robo$$android_transition_TransitionInflater$inflateTransition(int resource) {
        try (XmlResourceParser parser = this.mContext.getResources().getXml(resource);){
            Transition transition2 = this.createTransitionFromXml(parser, Xml.asAttributeSet(parser), null);
            return transition2;
        }
    }

    private final TransitionManager $$robo$$android_transition_TransitionInflater$inflateTransitionManager(int resource, ViewGroup sceneRoot) {
        try (XmlResourceParser parser = this.mContext.getResources().getXml(resource);){
            TransitionManager transitionManager = this.createTransitionManagerFromXml(parser, Xml.asAttributeSet(parser), sceneRoot);
            return transitionManager;
        }
    }

    private final Transition $$robo$$android_transition_TransitionInflater$createTransitionFromXml(XmlPullParser parser, AttributeSet attrs, Transition parent) throws XmlPullParserException, IOException {
        int type;
        TransitionSet transitionSet;
        Transition transition2 = null;
        int depth = parser.getDepth();
        TransitionSet transitionSet2 = transitionSet = parent instanceof TransitionSet ? (TransitionSet)parent : null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if ("fade".equals(name)) {
                transition2 = new Fade(this.mContext, attrs);
            } else if ("changeBounds".equals(name)) {
                transition2 = new ChangeBounds(this.mContext, attrs);
            } else if ("slide".equals(name)) {
                transition2 = new Slide(this.mContext, attrs);
            } else if ("explode".equals(name)) {
                transition2 = new Explode(this.mContext, attrs);
            } else if ("changeImageTransform".equals(name)) {
                transition2 = new ChangeImageTransform(this.mContext, attrs);
            } else if ("changeTransform".equals(name)) {
                transition2 = new ChangeTransform(this.mContext, attrs);
            } else if ("changeClipBounds".equals(name)) {
                transition2 = new ChangeClipBounds(this.mContext, attrs);
            } else if ("autoTransition".equals(name)) {
                transition2 = new AutoTransition(this.mContext, attrs);
            } else if ("recolor".equals(name)) {
                transition2 = new Recolor(this.mContext, attrs);
            } else if ("changeScroll".equals(name)) {
                transition2 = new ChangeScroll(this.mContext, attrs);
            } else if ("transitionSet".equals(name)) {
                transition2 = new TransitionSet(this.mContext, attrs);
            } else if ("transition".equals(name)) {
                transition2 = (Transition)this.createCustom(attrs, Transition.class, "transition");
            } else if ("targets".equals(name)) {
                this.getTargetIds(parser, attrs, parent);
            } else if ("arcMotion".equals(name)) {
                parent.setPathMotion(new ArcMotion(this.mContext, attrs));
            } else if ("pathMotion".equals(name)) {
                parent.setPathMotion((PathMotion)this.createCustom(attrs, PathMotion.class, "pathMotion"));
            } else if ("patternPathMotion".equals(name)) {
                parent.setPathMotion(new PatternPathMotion(this.mContext, attrs));
            } else {
                throw new RuntimeException("Unknown scene name: " + parser.getName());
            }
            if (transition2 == null) continue;
            if (!parser.isEmptyElementTag()) {
                this.createTransitionFromXml(parser, attrs, transition2);
            }
            if (transitionSet != null) {
                transitionSet.addTransition(transition2);
                transition2 = null;
                continue;
            }
            if (parent == null) continue;
            throw new InflateException("Could not add transition to another transition.");
        }
        return transition2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Object $$robo$$android_transition_TransitionInflater$createCustom(AttributeSet attrs, Class expectedType, String tag) {
        String className = attrs.getAttributeValue(null, "class");
        if (className == null) {
            throw new InflateException(tag + " tag must have a 'class' attribute");
        }
        try {
            ArrayMap<String, Constructor> arrayMap = sConstructors;
            synchronized (arrayMap) {
                Class c;
                Constructor constructor = sConstructors.get(className);
                if (constructor == null && (c = this.mContext.getClassLoader().loadClass(className).asSubclass(expectedType)) != null) {
                    constructor = c.getConstructor(sConstructorSignature);
                    constructor.setAccessible(true);
                    sConstructors.put(className, constructor);
                }
                return constructor.newInstance(this.mContext, attrs);
            }
        }
        catch (InstantiationException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, e);
        }
        catch (ClassNotFoundException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, e);
        }
        catch (InvocationTargetException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, e);
        }
        catch (NoSuchMethodException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, e);
        }
        catch (IllegalAccessException e) {
            throw new InflateException("Could not instantiate " + expectedType + " class " + className, e);
        }
    }

    private final void $$robo$$android_transition_TransitionInflater$getTargetIds(XmlPullParser parser, AttributeSet attrs, Transition transition2) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("target")) {
                TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionTarget);
                int id2 = a.getResourceId(1, 0);
                if (id2 != 0) {
                    transition2.addTarget(id2);
                } else {
                    id2 = a.getResourceId(2, 0);
                    if (id2 != 0) {
                        transition2.excludeTarget(id2, true);
                    } else {
                        String transitionName = a.getString(4);
                        if (transitionName != null) {
                            transition2.addTarget(transitionName);
                        } else {
                            transitionName = a.getString(5);
                            if (transitionName != null) {
                                transition2.excludeTarget(transitionName, true);
                            } else {
                                String className = a.getString(3);
                                try {
                                    Class<?> clazz;
                                    if (className != null) {
                                        clazz = Class.forName(className);
                                        transition2.excludeTarget(clazz, true);
                                    } else {
                                        className = a.getString(0);
                                        if (className != null) {
                                            clazz = Class.forName(className);
                                            transition2.addTarget(clazz);
                                        }
                                    }
                                }
                                catch (ClassNotFoundException e) {
                                    a.recycle();
                                    throw new RuntimeException("Could not create " + className, e);
                                }
                            }
                        }
                    }
                }
                a.recycle();
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
    }

    private final TransitionManager $$robo$$android_transition_TransitionInflater$createTransitionManagerFromXml(XmlPullParser parser, AttributeSet attrs, ViewGroup sceneRoot) throws XmlPullParserException, IOException {
        int type;
        int depth = parser.getDepth();
        TransitionManager transitionManager = null;
        while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
            if (type != 2) continue;
            String name = parser.getName();
            if (name.equals("transitionManager")) {
                transitionManager = new TransitionManager();
                continue;
            }
            if (name.equals("transition") && transitionManager != null) {
                this.loadTransition(attrs, sceneRoot, transitionManager);
                continue;
            }
            throw new RuntimeException("Unknown scene name: " + parser.getName());
        }
        return transitionManager;
    }

    private final void $$robo$$android_transition_TransitionInflater$loadTransition(AttributeSet attrs, ViewGroup sceneRoot, TransitionManager transitionManager) throws Resources.NotFoundException {
        Transition transition2;
        Scene toScene;
        TypedArray a = this.mContext.obtainStyledAttributes(attrs, R.styleable.TransitionManager);
        int transitionId = a.getResourceId(2, -1);
        int fromId = a.getResourceId(0, -1);
        Scene fromScene = fromId < 0 ? null : Scene.getSceneForLayout(sceneRoot, fromId, this.mContext);
        int toId = a.getResourceId(1, -1);
        Scene scene = toScene = toId < 0 ? null : Scene.getSceneForLayout(sceneRoot, toId, this.mContext);
        if (transitionId >= 0 && (transition2 = this.inflateTransition(transitionId)) != null) {
            if (toScene == null) {
                throw new RuntimeException("No toScene for transition ID " + transitionId);
            }
            if (fromScene == null) {
                transitionManager.setTransition(toScene, transition2);
            } else {
                transitionManager.setTransition(fromScene, toScene, transition2);
            }
        }
        a.recycle();
    }

    static void __staticInitializer__() {
        sConstructorSignature = new Class[]{Context.class, AttributeSet.class};
        sConstructors = new ArrayMap();
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_transition_TransitionInflater$__constructor__(context);
    }

    private TransitionInflater(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_transition_TransitionInflater$__constructor__(android.content.Context ), 0, this, context);
    }

    public static TransitionInflater from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_transition_TransitionInflater$from(android.content.Context ), 0, (Context)context);
    }

    public Transition inflateTransition(int n) {
        return InvokeDynamicSupport.bootstrap("inflateTransition", $$robo$$android_transition_TransitionInflater$inflateTransition(int ), 0, this, n);
    }

    public TransitionManager inflateTransitionManager(int n, ViewGroup viewGroup) {
        return InvokeDynamicSupport.bootstrap("inflateTransitionManager", $$robo$$android_transition_TransitionInflater$inflateTransitionManager(int android.view.ViewGroup ), 0, this, n, viewGroup);
    }

    private Transition createTransitionFromXml(XmlPullParser xmlPullParser, AttributeSet attributeSet, Transition transition2) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("createTransitionFromXml", $$robo$$android_transition_TransitionInflater$createTransitionFromXml(org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.transition.Transition ), 0, this, xmlPullParser, attributeSet, transition2);
    }

    private Object createCustom(AttributeSet attributeSet, Class clazz, String string2) {
        return InvokeDynamicSupport.bootstrap("createCustom", $$robo$$android_transition_TransitionInflater$createCustom(android.util.AttributeSet java.lang.Class java.lang.String ), 0, this, attributeSet, clazz, string2);
    }

    private void getTargetIds(XmlPullParser xmlPullParser, AttributeSet attributeSet, Transition transition2) throws XmlPullParserException, IOException {
        InvokeDynamicSupport.bootstrap("getTargetIds", $$robo$$android_transition_TransitionInflater$getTargetIds(org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.transition.Transition ), 0, this, xmlPullParser, attributeSet, transition2);
    }

    private TransitionManager createTransitionManagerFromXml(XmlPullParser xmlPullParser, AttributeSet attributeSet, ViewGroup viewGroup) throws XmlPullParserException, IOException {
        return InvokeDynamicSupport.bootstrap("createTransitionManagerFromXml", $$robo$$android_transition_TransitionInflater$createTransitionManagerFromXml(org.xmlpull.v1.XmlPullParser android.util.AttributeSet android.view.ViewGroup ), 0, this, xmlPullParser, attributeSet, viewGroup);
    }

    private void loadTransition(AttributeSet attributeSet, ViewGroup viewGroup, TransitionManager transitionManager) throws Resources.NotFoundException {
        InvokeDynamicSupport.bootstrap("loadTransition", $$robo$$android_transition_TransitionInflater$loadTransition(android.util.AttributeSet android.view.ViewGroup android.transition.TransitionManager ), 0, this, attributeSet, viewGroup, transitionManager);
    }

    static {
        RobolectricInternals.classInitializing(TransitionInflater.class);
    }

    public /* synthetic */ TransitionInflater() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TransitionInflater)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

