/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.annotation.IntDef;
import android.annotation.SuppressLint;
import android.app.ActivityThread;
import android.app.PendingIntent;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.provider.Settings;
import android.service.carrier.CarrierIdentifier;
import android.telecom.PhoneAccount;
import android.telecom.PhoneAccountHandle;
import android.telephony.CarrierConfigManager;
import android.telephony.CellInfo;
import android.telephony.CellLocation;
import android.telephony.ClientRequestStats;
import android.telephony.IccOpenLogicalChannelResponse;
import android.telephony.NeighboringCellInfo;
import android.telephony.PhoneStateListener;
import android.telephony.Rlog;
import android.telephony.ServiceState;
import android.telephony.SubscriptionManager;
import android.telephony.TelephonyHistogram;
import android.telephony.UssdResponse;
import android.telephony.VisualVoicemailSmsFilterSettings;
import android.util.Log;
import com.android.ims.internal.IImsServiceController;
import com.android.ims.internal.IImsServiceFeatureListener;
import com.android.internal.telecom.ITelecomService;
import com.android.internal.telephony.CellNetworkScanResult;
import com.android.internal.telephony.IPhoneSubInfo;
import com.android.internal.telephony.ITelephony;
import com.android.internal.telephony.ITelephonyRegistry;
import com.android.internal.telephony.OperatorInfo;
import com.android.internal.telephony.PhoneConstants;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TelephonyManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TelephonyManager";
    public static String MODEM_ACTIVITY_RESULT_KEY = "controller_activity";
    private static ITelephonyRegistry sRegistry;
    public static int OTASP_UNINITIALIZED = 0;
    public static int OTASP_UNKNOWN = 1;
    public static int OTASP_NEEDED = 2;
    public static int OTASP_NOT_NEEDED = 3;
    public static int OTASP_SIM_UNPROVISIONED = 5;
    private Context mContext;
    private int mSubId;
    private SubscriptionManager mSubscriptionManager;
    private static String multiSimConfig;
    private static TelephonyManager sInstance;
    public static String ACTION_PHONE_STATE_CHANGED = "android.intent.action.PHONE_STATE";
    public static String ACTION_RESPOND_VIA_MESSAGE = "android.intent.action.RESPOND_VIA_MESSAGE";
    public static String ACTION_EMERGENCY_ASSISTANCE = "android.telephony.action.EMERGENCY_ASSISTANCE";
    public static String METADATA_HIDE_VOICEMAIL_SETTINGS_MENU = "android.telephony.HIDE_VOICEMAIL_SETTINGS_MENU";
    public static String ACTION_CONFIGURE_VOICEMAIL = "android.telephony.action.CONFIGURE_VOICEMAIL";
    public static String EXTRA_HIDE_PUBLIC_SETTINGS = "android.telephony.extra.HIDE_PUBLIC_SETTINGS";
    public static boolean EMERGENCY_ASSISTANCE_ENABLED = true;
    public static String EXTRA_STATE = "state";
    public static String EXTRA_STATE_IDLE;
    public static String EXTRA_STATE_RINGING;
    public static String EXTRA_STATE_OFFHOOK;
    public static String EXTRA_INCOMING_NUMBER = "incoming_number";
    public static String ACTION_PRECISE_CALL_STATE_CHANGED = "android.intent.action.PRECISE_CALL_STATE";
    public static String EXTRA_RINGING_CALL_STATE = "ringing_state";
    public static String EXTRA_FOREGROUND_CALL_STATE = "foreground_state";
    public static String EXTRA_BACKGROUND_CALL_STATE = "background_state";
    public static String EXTRA_DISCONNECT_CAUSE = "disconnect_cause";
    public static String EXTRA_PRECISE_DISCONNECT_CAUSE = "precise_disconnect_cause";
    @Deprecated
    public static String ACTION_PRECISE_DATA_CONNECTION_STATE_CHANGED = "android.intent.action.PRECISE_DATA_CONNECTION_STATE_CHANGED";
    public static String EXTRA_DATA_STATE = "state";
    public static String EXTRA_DATA_NETWORK_TYPE = "networkType";
    public static String EXTRA_DATA_APN_TYPE = "apnType";
    public static String EXTRA_DATA_APN = "apn";
    public static String EXTRA_DATA_CHANGE_REASON = "reason";
    public static String EXTRA_DATA_LINK_PROPERTIES_KEY = "linkProperties";
    public static String EXTRA_DATA_FAILURE_CAUSE = "failCause";
    public static String ACTION_SHOW_VOICEMAIL_NOTIFICATION = "android.telephony.action.SHOW_VOICEMAIL_NOTIFICATION";
    public static String EXTRA_PHONE_ACCOUNT_HANDLE = "android.telephony.extra.PHONE_ACCOUNT_HANDLE";
    public static String EXTRA_NOTIFICATION_COUNT = "android.telephony.extra.NOTIFICATION_COUNT";
    public static String EXTRA_VOICEMAIL_NUMBER = "android.telephony.extra.VOICEMAIL_NUMBER";
    public static String EXTRA_CALL_VOICEMAIL_INTENT = "android.telephony.extra.CALL_VOICEMAIL_INTENT";
    public static String EXTRA_LAUNCH_VOICEMAIL_SETTINGS_INTENT = "android.telephony.extra.LAUNCH_VOICEMAIL_SETTINGS_INTENT";
    public static String EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE = "android.telephony.event.EVENT_HANDOVER_VIDEO_FROM_WIFI_TO_LTE";
    public static String EVENT_HANDOVER_TO_WIFI_FAILED = "android.telephony.event.EVENT_HANDOVER_TO_WIFI_FAILED";
    public static String EVENT_DOWNGRADE_DATA_LIMIT_REACHED = "android.telephony.event.EVENT_DOWNGRADE_DATA_LIMIT_REACHED";
    public static String EVENT_DOWNGRADE_DATA_DISABLED = "android.telephony.event.EVENT_DOWNGRADE_DATA_DISABLED";
    public static String EVENT_NOTIFY_INTERNATIONAL_CALL_ON_WFC = "android.telephony.event.EVENT_NOTIFY_INTERNATIONAL_CALL_ON_WFC";
    public static String VVM_TYPE_OMTP = "vvm_type_omtp";
    public static String VVM_TYPE_CVVM = "vvm_type_cvvm";
    public static String EXTRA_VISUAL_VOICEMAIL_ENABLED_BY_USER_BOOL = "android.telephony.extra.VISUAL_VOICEMAIL_ENABLED_BY_USER_BOOL";
    public static String EXTRA_VOICEMAIL_SCRAMBLED_PIN_STRING = "android.telephony.extra.VOICEMAIL_SCRAMBLED_PIN_STRING";
    public static String USSD_RESPONSE = "USSD_RESPONSE";
    public static int USSD_RETURN_SUCCESS = 100;
    public static int USSD_RETURN_FAILURE = -1;
    public static int USSD_ERROR_SERVICE_UNAVAIL = -2;
    public static int PHONE_TYPE_NONE = 0;
    public static int PHONE_TYPE_GSM = 1;
    public static int PHONE_TYPE_CDMA = 2;
    public static int PHONE_TYPE_SIP = 3;
    private static String sKernelCmdLine;
    private static Pattern sProductTypePattern;
    private static String sLteOnCdmaProductType;
    public static int NETWORK_TYPE_UNKNOWN = 0;
    public static int NETWORK_TYPE_GPRS = 1;
    public static int NETWORK_TYPE_EDGE = 2;
    public static int NETWORK_TYPE_UMTS = 3;
    public static int NETWORK_TYPE_CDMA = 4;
    public static int NETWORK_TYPE_EVDO_0 = 5;
    public static int NETWORK_TYPE_EVDO_A = 6;
    public static int NETWORK_TYPE_1xRTT = 7;
    public static int NETWORK_TYPE_HSDPA = 8;
    public static int NETWORK_TYPE_HSUPA = 9;
    public static int NETWORK_TYPE_HSPA = 10;
    public static int NETWORK_TYPE_IDEN = 11;
    public static int NETWORK_TYPE_EVDO_B = 12;
    public static int NETWORK_TYPE_LTE = 13;
    public static int NETWORK_TYPE_EHRPD = 14;
    public static int NETWORK_TYPE_HSPAP = 15;
    public static int NETWORK_TYPE_GSM = 16;
    public static int NETWORK_TYPE_TD_SCDMA = 17;
    public static int NETWORK_TYPE_IWLAN = 18;
    public static int NETWORK_TYPE_LTE_CA = 19;
    public static int NETWORK_CLASS_UNKNOWN = 0;
    public static int NETWORK_CLASS_2_G = 1;
    public static int NETWORK_CLASS_3_G = 2;
    public static int NETWORK_CLASS_4_G = 3;
    public static int SIM_STATE_UNKNOWN = 0;
    public static int SIM_STATE_ABSENT = 1;
    public static int SIM_STATE_PIN_REQUIRED = 2;
    public static int SIM_STATE_PUK_REQUIRED = 3;
    public static int SIM_STATE_NETWORK_LOCKED = 4;
    public static int SIM_STATE_READY = 5;
    public static int SIM_STATE_NOT_READY = 6;
    public static int SIM_STATE_PERM_DISABLED = 7;
    public static int SIM_STATE_CARD_IO_ERROR = 8;
    public static int SIM_STATE_CARD_RESTRICTED = 9;
    public static int SIM_ACTIVATION_STATE_UNKNOWN = 0;
    public static int SIM_ACTIVATION_STATE_ACTIVATING = 1;
    public static int SIM_ACTIVATION_STATE_ACTIVATED = 2;
    public static int SIM_ACTIVATION_STATE_DEACTIVATED = 3;
    public static int SIM_ACTIVATION_STATE_RESTRICTED = 4;
    public static int CALL_STATE_IDLE = 0;
    public static int CALL_STATE_RINGING = 1;
    public static int CALL_STATE_OFFHOOK = 2;
    public static int DATA_ACTIVITY_NONE = 0;
    public static int DATA_ACTIVITY_IN = 1;
    public static int DATA_ACTIVITY_OUT = 2;
    public static int DATA_ACTIVITY_INOUT = 3;
    public static int DATA_ACTIVITY_DORMANT = 4;
    public static int DATA_UNKNOWN = -1;
    public static int DATA_DISCONNECTED = 0;
    public static int DATA_CONNECTING = 1;
    public static int DATA_CONNECTED = 2;
    public static int DATA_SUSPENDED = 3;
    public static int APPTYPE_SIM = 1;
    public static int APPTYPE_USIM = 2;
    public static int APPTYPE_RUIM = 3;
    public static int APPTYPE_CSIM = 4;
    public static int APPTYPE_ISIM = 5;
    public static int AUTHTYPE_EAP_SIM = 128;
    public static int AUTHTYPE_EAP_AKA = 129;
    public static int CARRIER_PRIVILEGE_STATUS_HAS_ACCESS = 1;
    public static int CARRIER_PRIVILEGE_STATUS_NO_ACCESS = 0;
    public static int CARRIER_PRIVILEGE_STATUS_RULES_NOT_LOADED = -1;
    public static int CARRIER_PRIVILEGE_STATUS_ERROR_LOADING_RULES = -2;

    private void $$robo$$android_telephony_TelephonyManager$__constructor__(Context context) {
    }

    private void $$robo$$android_telephony_TelephonyManager$__constructor__(Context context, int subId) {
        this.mSubId = subId;
        Context appContext = context.getApplicationContext();
        this.mContext = appContext != null ? appContext : context;
        this.mSubscriptionManager = SubscriptionManager.from(this.mContext);
        if (sRegistry == null) {
            sRegistry = ITelephonyRegistry.Stub.asInterface(ServiceManager.getService("telephony.registry"));
        }
    }

    private void $$robo$$android_telephony_TelephonyManager$__constructor__() {
        this.mContext = null;
        this.mSubId = -1;
    }

    private static final TelephonyManager $$robo$$android_telephony_TelephonyManager$getDefault() {
        return sInstance;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getOpPackageName() {
        if (this.mContext != null) {
            return this.mContext.getOpPackageName();
        }
        return ActivityThread.currentOpPackageName();
    }

    private final MultiSimVariants $$robo$$android_telephony_TelephonyManager$getMultiSimConfiguration() {
        String mSimConfig = SystemProperties.get("persist.radio.multisim.config");
        if (mSimConfig.equals("dsds")) {
            return MultiSimVariants.DSDS;
        }
        if (mSimConfig.equals("dsda")) {
            return MultiSimVariants.DSDA;
        }
        if (mSimConfig.equals("tsts")) {
            return MultiSimVariants.TSTS;
        }
        return MultiSimVariants.UNKNOWN;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneCount() {
        int phoneCount = 1;
        switch (2.$SwitchMap$android$telephony$TelephonyManager$MultiSimVariants[this.getMultiSimConfiguration().ordinal()]) {
            case 1: {
                if (this.isVoiceCapable() || this.isSmsCapable()) {
                    phoneCount = 1;
                    break;
                }
                if (this.mContext == null) {
                    phoneCount = 1;
                    break;
                }
                ConnectivityManager cm = (ConnectivityManager)this.mContext.getSystemService("connectivity");
                if (cm == null) {
                    phoneCount = 1;
                    break;
                }
                if (cm.isNetworkSupported(0)) {
                    phoneCount = 1;
                    break;
                }
                phoneCount = 0;
                break;
            }
            case 2: 
            case 3: {
                phoneCount = 2;
                break;
            }
            case 4: {
                phoneCount = 3;
            }
        }
        return phoneCount;
    }

    private static final TelephonyManager $$robo$$android_telephony_TelephonyManager$from(Context context) {
        return (TelephonyManager)context.getSystemService("phone");
    }

    private final TelephonyManager $$robo$$android_telephony_TelephonyManager$createForSubscriptionId(int subId) {
        return new TelephonyManager(this.mContext, subId);
    }

    private final TelephonyManager $$robo$$android_telephony_TelephonyManager$createForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        int subId = this.getSubIdForPhoneAccountHandle(phoneAccountHandle);
        if (!SubscriptionManager.isValidSubscriptionId(subId)) {
            return null;
        }
        return new TelephonyManager(this.mContext, subId);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isMultiSimEnabled() {
        return multiSimConfig.equals("dsds") || multiSimConfig.equals("dsda") || multiSimConfig.equals("tsts");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getDeviceSoftwareVersion() {
        return this.getDeviceSoftwareVersion(this.getSlotIndex());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getDeviceSoftwareVersion(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getDeviceSoftwareVersionForSlot(slotIndex, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    private final String $$robo$$android_telephony_TelephonyManager$getDeviceId() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getDeviceId(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    private final String $$robo$$android_telephony_TelephonyManager$getDeviceId(int slotIndex) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getDeviceIdForPhone(slotIndex, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getImei() {
        return this.getImei(this.getSlotIndex());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getImei(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getImeiForSlot(slotIndex, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMeid() {
        return this.getMeid(this.getSlotIndex());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMeid(int slotIndex) {
        ITelephony telephony = this.getITelephony();
        if (telephony == null) {
            return null;
        }
        try {
            return telephony.getMeidForSlot(slotIndex, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNai() {
        return this.getNai(this.getSlotIndex());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNai(int slotIndex) {
        int[] subId = SubscriptionManager.getSubId(slotIndex);
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            String nai = info.getNaiForSubscriber(subId[0], this.mContext.getOpPackageName());
            if (Log.isLoggable("TelephonyManager", 2)) {
                Rlog.v("TelephonyManager", "Nai = " + nai);
            }
            return nai;
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @Deprecated
    private final CellLocation $$robo$$android_telephony_TelephonyManager$getCellLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                Rlog.d("TelephonyManager", "getCellLocation returning null because telephony is null");
                return null;
            }
            Bundle bundle = telephony.getCellLocation(this.mContext.getOpPackageName());
            if (bundle.isEmpty()) {
                Rlog.d("TelephonyManager", "getCellLocation returning null because bundle is empty");
                return null;
            }
            CellLocation cl = CellLocation.newFromBundle(bundle);
            if (cl.isEmpty()) {
                Rlog.d("TelephonyManager", "getCellLocation returning null because CellLocation is empty");
                return null;
            }
            return cl;
        }
        catch (RemoteException ex) {
            Rlog.d("TelephonyManager", "getCellLocation returning null due to RemoteException " + ex);
            return null;
        }
        catch (NullPointerException ex) {
            Rlog.d("TelephonyManager", "getCellLocation returning null due to NullPointerException " + ex);
            return null;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableLocationUpdates() {
        this.enableLocationUpdates(this.getSubId());
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableLocationUpdates(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableLocationUpdatesForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$disableLocationUpdates() {
        this.disableLocationUpdates(this.getSubId());
    }

    private final void $$robo$$android_telephony_TelephonyManager$disableLocationUpdates(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableLocationUpdatesForSubscriber(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Deprecated
    private final List<NeighboringCellInfo> $$robo$$android_telephony_TelephonyManager$getNeighboringCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getNeighboringCellInfo(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType() {
        return this.getCurrentPhoneType(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType(int subId) {
        int phoneId = subId == -1 ? 0 : SubscriptionManager.getPhoneId(subId);
        return this.getCurrentPhoneTypeForSlot(phoneId);
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCurrentPhoneTypeForSlot(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActivePhoneTypeForSlot(slotIndex);
            }
            return this.getPhoneTypeFromProperty(slotIndex);
        }
        catch (RemoteException ex) {
            return this.getPhoneTypeFromProperty(slotIndex);
        }
        catch (NullPointerException ex) {
            return this.getPhoneTypeFromProperty(slotIndex);
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneType() {
        if (!this.isVoiceCapable()) {
            return 0;
        }
        return this.getCurrentPhoneType();
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty() {
        return this.getPhoneTypeFromProperty(this.getPhoneId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty(int phoneId) {
        String type = TelephonyManager.getTelephonyProperty(phoneId, "gsm.current.phone-type", null);
        if (type == null || type.isEmpty()) {
            return this.getPhoneTypeFromNetworkType(phoneId);
        }
        return Integer.parseInt(type);
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType() {
        return this.getPhoneTypeFromNetworkType(this.getPhoneId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType(int phoneId) {
        String mode = TelephonyManager.getTelephonyProperty(phoneId, "ro.telephony.default_network", null);
        if (mode != null && !mode.isEmpty()) {
            return TelephonyManager.getPhoneType(Integer.parseInt(mode));
        }
        return 0;
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getPhoneType(int networkMode) {
        switch (networkMode) {
            case 4: 
            case 5: 
            case 6: {
                return 2;
            }
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 22: {
                return 1;
            }
            case 7: 
            case 8: 
            case 21: {
                return 2;
            }
            case 11: {
                if (TelephonyManager.getLteOnCdmaModeStatic() == 1) {
                    return 2;
                }
                return 1;
            }
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String $$robo$$android_telephony_TelephonyManager$getProcCmdLine() {
        String cmdline = "";
        FileInputStream is = null;
        try {
            is = new FileInputStream("/proc/cmdline");
            byte[] buffer = new byte[2048];
            int count = is.read(buffer);
            if (count > 0) {
                cmdline = new String(buffer, 0, count);
            }
        }
        catch (IOException e) {
            Rlog.d("TelephonyManager", "No /proc/cmdline exception=" + e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Rlog.d("TelephonyManager", "/proc/cmdline=" + cmdline);
        return cmdline;
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getLteOnCdmaModeStatic() {
        String productType = "";
        int curVal = SystemProperties.getInt("telephony.lteOnCdmaDevice", -1);
        int retVal = curVal;
        if (retVal == -1) {
            Matcher matcher = sProductTypePattern.matcher(sKernelCmdLine);
            retVal = matcher.find() ? (sLteOnCdmaProductType.equals(productType = matcher.group(1)) ? 1 : 0) : 0;
        }
        Rlog.d("TelephonyManager", "getLteOnCdmaMode=" + retVal + " curVal=" + curVal + " product_type='" + productType + "' lteOnCdmaProductType='" + sLteOnCdmaProductType + "'");
        return retVal;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName() {
        return this.getNetworkOperatorName(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.alpha", "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperator() {
        return this.getNetworkOperatorForPhone(this.getPhoneId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperator(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getNetworkOperatorForPhone(phoneId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkOperatorForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.numeric", "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkSpecifier() {
        return String.valueOf(this.getSubId());
    }

    private final PersistableBundle $$robo$$android_telephony_TelephonyManager$getCarrierConfig() {
        CarrierConfigManager carrierConfigManager = this.mContext.getSystemService(CarrierConfigManager.class);
        return carrierConfigManager.getConfigForSubId(this.getSubId());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isNetworkRoaming() {
        return this.isNetworkRoaming(this.getSubId());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isNetworkRoaming(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.isroaming", null));
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso() {
        return this.getNetworkCountryIsoForPhone(this.getPhoneId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getNetworkCountryIsoForPhone(phoneId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkCountryIsoForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.operator.iso-country", "");
    }

    private final int $$robo$$android_telephony_TelephonyManager$getNetworkType() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkType();
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataNetworkType() {
        return this.getDataNetworkType(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType() {
        return this.getVoiceNetworkType(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceNetworkTypeForSubscriber(subId, this.getOpPackageName());
            }
            return 0;
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getNetworkClass(int networkType) {
        switch (networkType) {
            case 1: 
            case 2: 
            case 4: 
            case 7: 
            case 11: 
            case 16: {
                return 1;
            }
            case 3: 
            case 5: 
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                return 2;
            }
            case 13: 
            case 18: 
            case 19: {
                return 3;
            }
        }
        return 0;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getNetworkTypeName() {
        return TelephonyManager.getNetworkTypeName(this.getNetworkType());
    }

    private static final String $$robo$$android_telephony_TelephonyManager$getNetworkTypeName(int type) {
        switch (type) {
            case 1: {
                return "GPRS";
            }
            case 2: {
                return "EDGE";
            }
            case 3: {
                return "UMTS";
            }
            case 8: {
                return "HSDPA";
            }
            case 9: {
                return "HSUPA";
            }
            case 10: {
                return "HSPA";
            }
            case 4: {
                return "CDMA";
            }
            case 5: {
                return "CDMA - EvDo rev. 0";
            }
            case 6: {
                return "CDMA - EvDo rev. A";
            }
            case 12: {
                return "CDMA - EvDo rev. B";
            }
            case 7: {
                return "CDMA - 1xRTT";
            }
            case 13: {
                return "LTE";
            }
            case 14: {
                return "CDMA - eHRPD";
            }
            case 11: {
                return "iDEN";
            }
            case 15: {
                return "HSPA+";
            }
            case 16: {
                return "GSM";
            }
            case 17: {
                return "TD_SCDMA";
            }
            case 18: {
                return "IWLAN";
            }
            case 19: {
                return "LTE_CA";
            }
        }
        return "UNKNOWN";
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$hasIccCard() {
        return this.hasIccCard(this.getSlotIndex());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$hasIccCard(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.hasIccCardUsingSlotIndex(slotIndex);
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSimState() {
        int slotIndex = this.getSlotIndex();
        if (slotIndex < 0) {
            for (int i = 0; i < this.getPhoneCount(); ++i) {
                int simState = this.getSimState(i);
                if (simState == 1) continue;
                Rlog.d("TelephonyManager", "getSimState: default sim:" + slotIndex + ", sim state for slotIndex=" + i + " is " + simState + ", return state as unknown");
                return 0;
            }
            Rlog.d("TelephonyManager", "getSimState: default sim:" + slotIndex + ", all SIMs absent, return state as absent");
            return 1;
        }
        return this.getSimState(slotIndex);
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSimState(int slotIndex) {
        int simState = SubscriptionManager.getSimStateForSlotIndex(slotIndex);
        return simState;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperator() {
        return this.getSimOperatorNumeric();
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperator(int subId) {
        return this.getSimOperatorNumeric(subId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorNumeric() {
        int subId = SubscriptionManager.getDefaultDataSubscriptionId();
        if (!(SubscriptionManager.isUsableSubIdValue(subId) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultSmsSubscriptionId()) || SubscriptionManager.isUsableSubIdValue(subId = SubscriptionManager.getDefaultVoiceSubscriptionId()))) {
            subId = SubscriptionManager.getDefaultSubscriptionId();
        }
        return this.getSimOperatorNumeric(subId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorNumeric(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNumericForPhone(phoneId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorNumericForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.numeric", "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorName() {
        return this.getSimOperatorNameForPhone(this.getPhoneId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorName(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimOperatorNameForPhone(phoneId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimOperatorNameForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.alpha", "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimCountryIso() {
        return this.getSimCountryIsoForPhone(this.getPhoneId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimCountryIso(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getSimCountryIsoForPhone(phoneId);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimCountryIsoForPhone(int phoneId) {
        return TelephonyManager.getTelephonyProperty(phoneId, "gsm.sim.operator.iso-country", "");
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimSerialNumber() {
        return this.getSimSerialNumber(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSimSerialNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIccSerialNumberForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode() {
        return this.getLteOnCdmaMode(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getLteOnCdmaModeForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSubscriberId() {
        return this.getSubscriberId(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getSubscriberId(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getSubscriberIdForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1(this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getGroupIdLevel1ForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1Number() {
        return this.getLine1Number(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1Number(int subId) {
        String number = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                number = telephony.getLine1NumberForDisplay(subId, this.mContext.getOpPackageName());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (number != null) {
            return number;
        }
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getLine1NumberForSubscriber(subId, this.mContext.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplay(String alphaTag, String number) {
        return this.setLine1NumberForDisplay(this.getSubId(), alphaTag, number);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplay(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setLine1NumberForDisplayForSubscriber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1AlphaTag() {
        return this.getLine1AlphaTag(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLine1AlphaTag(int subId) {
        String alphaTag = null;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                alphaTag = telephony.getLine1AlphaTagForDisplay(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException telephony) {
        }
        catch (NullPointerException telephony) {
            // empty catch block
        }
        if (alphaTag != null) {
            return alphaTag;
        }
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getLine1AlphaTagForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getMergedSubscriberIds() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getMergedSubscriberIds(this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMsisdn() {
        return this.getMsisdn(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMsisdn(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getMsisdnForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber() {
        return this.getVoiceMailNumber(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailNumberForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber() {
        return this.getCompleteVoiceMailNumber(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getCompleteVoiceMailNumberForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setVoiceMailNumber(String alphaTag, String number) {
        return this.setVoiceMailNumber(this.getSubId(), alphaTag, number);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setVoiceMailNumber(int subId, String alphaTag, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setVoiceMailNumber(subId, alphaTag, number);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_telephony_TelephonyManager$setVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle, boolean enabled) {
    }

    @SuppressLint(value={"Doclava125"})
    private final boolean $$robo$$android_telephony_TelephonyManager$isVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle) {
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    private final Bundle $$robo$$android_telephony_TelephonyManager$getVisualVoicemailSettings() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailSettings(this.mContext.getOpPackageName(), this.mSubId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVisualVoicemailPackageName() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailPackageName(this.mContext.getOpPackageName(), this.getSubId());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setVisualVoicemailSmsFilterSettings(VisualVoicemailSmsFilterSettings settings) {
        if (settings == null) {
            this.disableVisualVoicemailSmsFilter(this.mSubId);
        } else {
            this.enableVisualVoicemailSmsFilter(this.mSubId, settings);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$sendVisualVoicemailSms(String number, int port, String text, PendingIntent sentIntent) {
        this.sendVisualVoicemailSmsForSubscriber(this.mSubId, number, port, text, sentIntent);
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableVisualVoicemailSmsFilter(int subId, VisualVoicemailSmsFilterSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException("Settings cannot be null");
        }
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVisualVoicemailSmsFilter(this.mContext.getOpPackageName(), subId, settings);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$disableVisualVoicemailSmsFilter(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.disableVisualVoicemailSmsFilter(this.mContext.getOpPackageName(), subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final VisualVoicemailSmsFilterSettings $$robo$$android_telephony_TelephonyManager$getVisualVoicemailSmsFilterSettings(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVisualVoicemailSmsFilterSettings(this.mContext.getOpPackageName(), subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final VisualVoicemailSmsFilterSettings $$robo$$android_telephony_TelephonyManager$getActiveVisualVoicemailSmsFilterSettings(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getActiveVisualVoicemailSmsFilterSettings(subId);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final void $$robo$$android_telephony_TelephonyManager$sendVisualVoicemailSmsForSubscriber(int subId, String number, int port, String text, PendingIntent sentIntent) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.sendVisualVoicemailSmsForSubscriber(this.mContext.getOpPackageName(), subId, number, port, text, sentIntent);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setVoiceActivationState(int subId, int activationState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setVoiceActivationState(subId, activationState);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setDataActivationState(int subId, int activationState) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataActivationState(subId, activationState);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceActivationState(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getVoiceActivationState(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataActivationState(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getDataActivationState(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return 0;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount() {
        return this.getVoiceMessageCount(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getVoiceMessageCountForSubscriber(subId);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag() {
        return this.getVoiceMailAlphaTag(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag(int subId) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getVoiceMailAlphaTagForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$sendDialerSpecialCode(String inputCode) {
        try {
            ITelephony telephony = this.getITelephony();
            telephony.sendDialerSpecialCode(this.mContext.getOpPackageName(), inputCode);
        }
        catch (RemoteException ex) {
            ex.rethrowFromSystemServer();
        }
        catch (NullPointerException ex) {
            throw new IllegalStateException("Telephony service unavailable");
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimImpi() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimImpi();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimDomain() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimDomain();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getIsimImpu() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimImpu();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final IPhoneSubInfo $$robo$$android_telephony_TelephonyManager$getSubscriberInfo() {
        return IPhoneSubInfo.Stub.asInterface(ServiceManager.getService("iphonesubinfo"));
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCallState() {
        try {
            ITelecomService telecom = this.getTelecomService();
            if (telecom != null) {
                return telecom.getCallState();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelecomService#getCallState", e);
        }
        return 0;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCallState(int subId) {
        int phoneId = SubscriptionManager.getPhoneId(subId);
        return this.getCallStateForSlot(phoneId);
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCallStateForSlot(int slotIndex) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getCallStateForSlot(slotIndex);
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataActivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataActivity();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getDataState() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return 0;
            }
            return telephony.getDataState();
        }
        catch (RemoteException ex) {
            return 0;
        }
        catch (NullPointerException ex) {
            return 0;
        }
    }

    private final ITelephony $$robo$$android_telephony_TelephonyManager$getITelephony() {
        return ITelephony.Stub.asInterface(ServiceManager.getService("phone"));
    }

    private final ITelecomService $$robo$$android_telephony_TelephonyManager$getTelecomService() {
        return ITelecomService.Stub.asInterface(ServiceManager.getService("telecom"));
    }

    private final void $$robo$$android_telephony_TelephonyManager$listen(PhoneStateListener listener, int events) {
        if (this.mContext == null) {
            return;
        }
        try {
            boolean notifyNow;
            boolean bl = notifyNow = this.getITelephony() != null;
            if (listener.mSubId == null) {
                listener.mSubId = this.mSubId;
            }
            sRegistry.listenForSubscriber(listener.mSubId, this.getOpPackageName(), listener.callback, events, notifyNow);
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex() {
        return this.getCdmaEriIconIndex(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconIndexForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode() {
        return this.getCdmaEriIconMode(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return -1;
            }
            return telephony.getCdmaEriIconModeForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return -1;
        }
        catch (NullPointerException ex) {
            return -1;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaEriText() {
        return this.getCdmaEriText(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaEriText(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaEriTextForSubscriber(subId, this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isVoiceCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17957040);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isSmsCapable() {
        if (this.mContext == null) {
            return true;
        }
        return this.mContext.getResources().getBoolean(17957002);
    }

    private final List<CellInfo> $$robo$$android_telephony_TelephonyManager$getAllCellInfo() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getAllCellInfo(this.getOpPackageName());
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setCellInfoListRate(int rateInMillis) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setCellInfoListRate(rateInMillis);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMmsUserAgent() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039670);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getMmsUAProfUrl() {
        if (this.mContext == null) {
            return null;
        }
        return this.mContext.getResources().getString(17039671);
    }

    @Deprecated
    private final IccOpenLogicalChannelResponse $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(String AID) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID, -1);
    }

    private final IccOpenLogicalChannelResponse $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(String AID, int p2) {
        return this.iccOpenLogicalChannel(this.getSubId(), AID, p2);
    }

    private final IccOpenLogicalChannelResponse $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(int subId, String AID, int p2) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccOpenLogicalChannel(subId, AID, p2);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$iccCloseLogicalChannel(int channel) {
        return this.iccCloseLogicalChannel(this.getSubId(), channel);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$iccCloseLogicalChannel(int subId, int channel) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccCloseLogicalChannel(subId, channel);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    private final String $$robo$$android_telephony_TelephonyManager$iccTransmitApduLogicalChannel(int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduLogicalChannel(this.getSubId(), channel, cla, instruction, p1, p2, p3, data);
    }

    private final String $$robo$$android_telephony_TelephonyManager$iccTransmitApduLogicalChannel(int subId, int channel, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduLogicalChannel(subId, channel, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    private final String $$robo$$android_telephony_TelephonyManager$iccTransmitApduBasicChannel(int cla, int instruction, int p1, int p2, int p3, String data) {
        return this.iccTransmitApduBasicChannel(this.getSubId(), cla, instruction, p1, p2, p3, data);
    }

    private final String $$robo$$android_telephony_TelephonyManager$iccTransmitApduBasicChannel(int subId, int cla, int instruction, int p1, int p2, int p3, String data) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccTransmitApduBasicChannel(subId, cla, instruction, p1, p2, p3, data);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    private final byte[] $$robo$$android_telephony_TelephonyManager$iccExchangeSimIO(int fileID, int command, int p1, int p2, int p3, String filePath) {
        return this.iccExchangeSimIO(this.getSubId(), fileID, command, p1, p2, p3, filePath);
    }

    private final byte[] $$robo$$android_telephony_TelephonyManager$iccExchangeSimIO(int subId, int fileID, int command, int p1, int p2, int p3, String filePath) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.iccExchangeSimIO(subId, fileID, command, p1, p2, p3, filePath);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return null;
    }

    private final String $$robo$$android_telephony_TelephonyManager$sendEnvelopeWithStatus(String content) {
        return this.sendEnvelopeWithStatus(this.getSubId(), content);
    }

    private final String $$robo$$android_telephony_TelephonyManager$sendEnvelopeWithStatus(int subId, String content) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.sendEnvelopeWithStatus(subId, content);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return "";
    }

    private final String $$robo$$android_telephony_TelephonyManager$nvReadItem(int itemID) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvReadItem(itemID);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvReadItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvReadItem NPE", ex);
        }
        return "";
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$nvWriteItem(int itemID, String itemValue) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteItem(itemID, itemValue);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvWriteItem RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvWriteItem NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$nvWriteCdmaPrl(byte[] preferredRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvWriteCdmaPrl(preferredRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvWriteCdmaPrl RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvWriteCdmaPrl NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$nvResetConfig(int resetType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.nvResetConfig(resetType);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "nvResetConfig RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "nvResetConfig NPE", ex);
        }
        return false;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSubId() {
        if (SubscriptionManager.isUsableSubIdValue(this.mSubId)) {
            return this.mSubId;
        }
        return SubscriptionManager.getDefaultSubscriptionId();
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSubId(int preferredSubId) {
        if (SubscriptionManager.isUsableSubIdValue(this.mSubId)) {
            return this.mSubId;
        }
        return preferredSubId;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneId() {
        return SubscriptionManager.getPhoneId(this.getSubId());
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPhoneId(int preferredSubId) {
        return SubscriptionManager.getPhoneId(this.getSubId(preferredSubId));
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSlotIndex() {
        int slotIndex = SubscriptionManager.getSlotIndex(this.getSubId());
        if (slotIndex == -1) {
            slotIndex = Integer.MAX_VALUE;
        }
        return slotIndex;
    }

    private static final void $$robo$$android_telephony_TelephonyManager$setTelephonyProperty(int phoneId, String property, String value) {
        int i;
        String propVal = "";
        String[] p = null;
        String prop = SystemProperties.get(property);
        if (value == null) {
            value = "";
        }
        if (prop != null) {
            p = prop.split(",");
        }
        if (!SubscriptionManager.isValidPhoneId(phoneId)) {
            Rlog.d("TelephonyManager", "setTelephonyProperty: invalid phoneId=" + phoneId + " property=" + property + " value: " + value + " prop=" + prop);
            return;
        }
        for (i = 0; i < phoneId; ++i) {
            String str = "";
            if (p != null && i < p.length) {
                str = p[i];
            }
            propVal = propVal + str + ",";
        }
        propVal = propVal + value;
        if (p != null) {
            for (i = phoneId + 1; i < p.length; ++i) {
                propVal = propVal + "," + p[i];
            }
        }
        if (propVal.length() > 91) {
            Rlog.d("TelephonyManager", "setTelephonyProperty: property too long phoneId=" + phoneId + " property=" + property + " value: " + value + " propVal=" + propVal);
            return;
        }
        Rlog.d("TelephonyManager", "setTelephonyProperty: success phoneId=" + phoneId + " property=" + property + " value: " + value + " propVal=" + propVal);
        SystemProperties.set(property, propVal);
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getIntAtIndex(ContentResolver cr, String name, int index) throws Settings.SettingNotFoundException {
        String v = Settings.Global.getString(cr, name);
        if (v != null) {
            String[] valArray = v.split(",");
            if (index >= 0 && index < valArray.length && valArray[index] != null) {
                try {
                    return Integer.parseInt(valArray[index]);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        throw new Settings.SettingNotFoundException(name);
    }

    private static final boolean $$robo$$android_telephony_TelephonyManager$putIntAtIndex(ContentResolver cr, String name, int index, int value) {
        int i;
        String data = "";
        String[] valArray = null;
        String v = Settings.Global.getString(cr, name);
        if (index == Integer.MAX_VALUE) {
            throw new RuntimeException("putIntAtIndex index == MAX_VALUE index=" + index);
        }
        if (index < 0) {
            throw new RuntimeException("putIntAtIndex index < 0 index=" + index);
        }
        if (v != null) {
            valArray = v.split(",");
        }
        for (i = 0; i < index; ++i) {
            String str = "";
            if (valArray != null && i < valArray.length) {
                str = valArray[i];
            }
            data = data + str + ",";
        }
        data = data + value;
        if (valArray != null) {
            for (i = index + 1; i < valArray.length; ++i) {
                data = data + "," + valArray[i];
            }
        }
        return Settings.Global.putString(cr, name, data);
    }

    private static final String $$robo$$android_telephony_TelephonyManager$getTelephonyProperty(int phoneId, String property, String defaultVal) {
        String propVal = null;
        String prop = SystemProperties.get(property);
        if (prop != null && prop.length() > 0) {
            String[] values = prop.split(",");
            if (phoneId >= 0 && phoneId < values.length && values[phoneId] != null) {
                propVal = values[phoneId];
            }
        }
        return propVal == null ? defaultVal : propVal;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSimCount() {
        if (this.isMultiSimEnabled()) {
            return 2;
        }
        return 1;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimIst() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimIst();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getIsimPcscf() {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimPcscf();
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIsimChallengeResponse(String nonce) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIsimChallengeResponse(nonce);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIccAuthentication(int appType, int authType, String data) {
        return this.getIccAuthentication(this.getSubId(), appType, authType, data);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getIccAuthentication(int subId, int appType, int authType, String data) {
        try {
            IPhoneSubInfo info = this.getSubscriberInfo();
            if (info == null) {
                return null;
            }
            return info.getIccSimChallengeResponse(subId, appType, authType, data);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getForbiddenPlmns() {
        return this.getForbiddenPlmns(this.getSubId(), 2);
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getForbiddenPlmns(int subId, int appType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getForbiddenPlmns(subId, appType);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String[] $$robo$$android_telephony_TelephonyManager$getPcscfAddress(String apnType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return new String[0];
            }
            return telephony.getPcscfAddress(apnType, this.getOpPackageName());
        }
        catch (RemoteException e) {
            return new String[0];
        }
    }

    private final IImsServiceController $$robo$$android_telephony_TelephonyManager$getImsServiceControllerAndListen(int slotIndex, int feature, IImsServiceFeatureListener callback) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getImsServiceControllerAndListen(slotIndex, feature, callback);
            }
        }
        catch (RemoteException e) {
            Rlog.e("TelephonyManager", "getImsServiceControllerAndListen, RemoteException: " + e.getMessage());
        }
        return null;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setImsRegistrationState(boolean registered) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setImsRegistrationState(registered);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getPreferredNetworkType(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPreferredNetworkType(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "getPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "getPreferredNetworkType NPE", ex);
        }
        return -1;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkSelectionModeAutomatic(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setNetworkSelectionModeAutomatic(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setNetworkSelectionModeAutomatic RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setNetworkSelectionModeAutomatic NPE", ex);
        }
    }

    private final CellNetworkScanResult $$robo$$android_telephony_TelephonyManager$getCellNetworkScanResults(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCellNetworkScanResults(subId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "getCellNetworkScanResults RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "getCellNetworkScanResults NPE", ex);
        }
        return null;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setNetworkSelectionModeManual(int subId, OperatorInfo operator, boolean persistSelection) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setNetworkSelectionModeManual(subId, operator, persistSelection);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setNetworkSelectionModeManual RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setNetworkSelectionModeManual NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setPreferredNetworkType(int subId, int networkType) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setPreferredNetworkType(subId, networkType);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setPreferredNetworkType RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setPreferredNetworkType NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setPreferredNetworkTypeToGlobal() {
        return this.setPreferredNetworkTypeToGlobal(this.getSubId());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setPreferredNetworkTypeToGlobal(int subId) {
        return this.setPreferredNetworkType(subId, 10);
    }

    private final int $$robo$$android_telephony_TelephonyManager$getTetherApnRequired() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getTetherApnRequired();
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "hasMatchedTetherApnSetting RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "hasMatchedTetherApnSetting NPE", ex);
        }
        return 2;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$hasCarrierPrivileges() {
        return this.hasCarrierPrivileges(this.getSubId());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$hasCarrierPrivileges(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPrivilegeStatus(this.mSubId) == 1;
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "hasCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "hasCarrierPrivileges NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setOperatorBrandOverride(String brand) {
        return this.setOperatorBrandOverride(this.getSubId(), brand);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setOperatorBrandOverride(int subId, String brand) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setOperatorBrandOverride(subId, brand);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setOperatorBrandOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setOperatorBrandOverride NPE", ex);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setRoamingOverride(List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        return this.setRoamingOverride(this.getSubId(), gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setRoamingOverride(int subId, List<String> gsmRoamingList, List<String> gsmNonRoamingList, List<String> cdmaRoamingList, List<String> cdmaNonRoamingList) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRoamingOverride(subId, gsmRoamingList, gsmNonRoamingList, cdmaRoamingList, cdmaNonRoamingList);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "setRoamingOverride RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "setRoamingOverride NPE", ex);
        }
        return false;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMdn() {
        return this.getCdmaMdn(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMdn(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMdn(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMin() {
        return this.getCdmaMin(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaMin(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return null;
            }
            return telephony.getCdmaMin(subId);
        }
        catch (RemoteException ex) {
            return null;
        }
        catch (NullPointerException ex) {
            return null;
        }
    }

    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_telephony_TelephonyManager$checkCarrierPrivilegesForPackage(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackage(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "checkCarrierPrivilegesForPackage RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "checkCarrierPrivilegesForPackage NPE", ex);
        }
        return 0;
    }

    @SuppressLint(value={"Doclava125"})
    private final int $$robo$$android_telephony_TelephonyManager$checkCarrierPrivilegesForPackageAnyPhone(String pkgName) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.checkCarrierPrivilegesForPackageAnyPhone(pkgName);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "checkCarrierPrivilegesForPackageAnyPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "checkCarrierPrivilegesForPackageAnyPhone NPE", ex);
        }
        return 0;
    }

    private final List<String> $$robo$$android_telephony_TelephonyManager$getCarrierPackageNamesForIntent(Intent intent) {
        return this.getCarrierPackageNamesForIntentAndPhone(intent, this.getPhoneId());
    }

    private final List<String> $$robo$$android_telephony_TelephonyManager$getCarrierPackageNamesForIntentAndPhone(Intent intent, int phoneId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getCarrierPackageNamesForIntentAndPhone(intent, phoneId);
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "getCarrierPackageNamesForIntentAndPhone RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "getCarrierPackageNamesForIntentAndPhone NPE", ex);
        }
        return null;
    }

    private final List<String> $$robo$$android_telephony_TelephonyManager$getPackagesWithCarrierPrivileges() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getPackagesWithCarrierPrivileges();
            }
        }
        catch (RemoteException ex) {
            Rlog.e("TelephonyManager", "getPackagesWithCarrierPrivileges RemoteException", ex);
        }
        catch (NullPointerException ex) {
            Rlog.e("TelephonyManager", "getPackagesWithCarrierPrivileges NPE", ex);
        }
        return Collections.EMPTY_LIST;
    }

    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_telephony_TelephonyManager$dial(String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.dial(number);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#dial", e);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$call(String callingPackage, String number) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.call(callingPackage, number);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#call", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$endCall() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.endCall();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#endCall", e);
        }
        return false;
    }

    private final void $$robo$$android_telephony_TelephonyManager$answerRingingCall() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.answerRingingCall();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#answerRingingCall", e);
        }
    }

    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_telephony_TelephonyManager$silenceRinger() {
        try {
            this.getTelecomService().silenceRinger(this.getOpPackageName());
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelecomService#silenceRinger", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isOffhook() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isOffhook(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isOffhook", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isRinging() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRinging(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isRinging", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isIdle() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isIdle(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isIdle", e);
        }
        return true;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isRadioOn() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isRadioOn(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isRadioOn", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$supplyPin(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPin(pin);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#supplyPin", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$supplyPuk(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPuk(puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#supplyPuk", e);
        }
        return false;
    }

    private final int[] $$robo$$android_telephony_TelephonyManager$supplyPinReportResult(String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPinReportResult(pin);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#supplyPinReportResult", e);
        }
        return new int[0];
    }

    private final int[] $$robo$$android_telephony_TelephonyManager$supplyPukReportResult(String puk, String pin) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.supplyPukReportResult(puk, pin);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#]", e);
        }
        return new int[0];
    }

    private final void $$robo$$android_telephony_TelephonyManager$sendUssdRequest(String ussdRequest, UssdResponseCallback callback, Handler handler) {
        Preconditions.checkNotNull(callback, "UssdResponseCallback cannot be null.");
        TelephonyManager telephonyManager = this;
        ShadowedObject wrappedCallback = new ShadowedObject(this, handler, callback, telephonyManager){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ UssdResponseCallback val$callback;
            /* synthetic */ TelephonyManager val$telephonyManager;
            /* synthetic */ TelephonyManager this$0;

            private void $$robo$$android_telephony_TelephonyManager_1$__constructor__(TelephonyManager this$0, Handler handler, UssdResponseCallback ussdResponseCallback, TelephonyManager telephonyManager) {
            }

            private final void $$robo$$android_telephony_TelephonyManager_1$onReceiveResult(int resultCode, Bundle ussdResponse) {
                Rlog.d("TelephonyManager", "USSD:" + resultCode);
                Preconditions.checkNotNull(ussdResponse, "ussdResponse cannot be null.");
                UssdResponse response = (UssdResponse)ussdResponse.getParcelable("USSD_RESPONSE");
                if (resultCode == 100) {
                    this.val$callback.onReceiveUssdResponse(this.val$telephonyManager, response.getUssdRequest(), response.getReturnMessage());
                } else {
                    this.val$callback.onReceiveUssdResponseFailed(this.val$telephonyManager, response.getUssdRequest(), resultCode);
                }
            }

            private void __constructor__(TelephonyManager telephonyManager, Handler handler, UssdResponseCallback ussdResponseCallback, TelephonyManager telephonyManager2) {
                this.$$robo$$android_telephony_TelephonyManager_1$__constructor__(telephonyManager, handler, ussdResponseCallback, telephonyManager2);
            }
            {
                this.this$0 = telephonyManager;
                this.val$callback = ussdResponseCallback;
                this.val$telephonyManager = telephonyManager2;
                super(handler);
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager_1$__constructor__(android.telephony.TelephonyManager android.os.Handler android.telephony.TelephonyManager$UssdResponseCallback android.telephony.TelephonyManager ), 0, this, telephonyManager, handler, ussdResponseCallback, telephonyManager2);
            }

            @Override
            protected void onReceiveResult(int n, Bundle bundle) {
                InvokeDynamicSupport.bootstrap("onReceiveResult", $$robo$$android_telephony_TelephonyManager_1$onReceiveResult(int android.os.Bundle ), 0, this, n, bundle);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.handleUssdRequest(this.getSubId(), ussdRequest, (ResultReceiver)wrappedCallback);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#sendUSSDCode", e);
            UssdResponse response = new UssdResponse(ussdRequest, "");
            Bundle returnData = new Bundle();
            returnData.putParcelable("USSD_RESPONSE", response);
            wrappedCallback.send(-2, returnData);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isConcurrentVoiceAndDataSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            return telephony == null ? false : telephony.isConcurrentVoiceAndDataAllowed(this.getSubId());
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isConcurrentVoiceAndDataAllowed", e);
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$handlePinMmi(String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmi(dialString);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$handlePinMmiForSubscriber(int subId, String dialString) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.handlePinMmiForSubscriber(subId, dialString);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#handlePinMmi", e);
        }
        return false;
    }

    private final void $$robo$$android_telephony_TelephonyManager$toggleRadioOnOff() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.toggleRadioOnOff();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#toggleRadioOnOff", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setRadio(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadio(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setRadio", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$setRadioPower(boolean turnOn) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.setRadioPower(turnOn);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setRadioPower", e);
        }
        return false;
    }

    @SuppressLint(value={"Doclava125"})
    private final void $$robo$$android_telephony_TelephonyManager$updateServiceLocation() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.updateServiceLocation();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#updateServiceLocation", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$enableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.enableDataConnectivity();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#enableDataConnectivity", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$disableDataConnectivity() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.disableDataConnectivity();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#disableDataConnectivity", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isDataConnectivityPossible() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isDataConnectivityPossible();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isDataConnectivityPossible", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$needsOtaServiceProvisioning() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.needsOtaServiceProvisioning();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#needsOtaServiceProvisioning", e);
        }
        return false;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setDataEnabled(boolean enable) {
        this.setDataEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()), enable);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setDataEnabled(int subId, boolean enable) {
        try {
            Log.d("TelephonyManager", "setDataEnabled: enabled=" + enable);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setDataEnabled(subId, enable);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setDataEnabled", e);
        }
    }

    @Deprecated
    private final boolean $$robo$$android_telephony_TelephonyManager$getDataEnabled() {
        return this.isDataEnabled();
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isDataEnabled() {
        return this.getDataEnabled(this.getSubId(SubscriptionManager.getDefaultDataSubscriptionId()));
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getDataEnabled(int subId) {
        boolean retVal = false;
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                retVal = telephony.getDataEnabled(subId);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getDataEnabled", e);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return retVal;
    }

    @Deprecated
    private final int $$robo$$android_telephony_TelephonyManager$invokeOemRilRequestRaw(byte[] oemReq, byte[] oemResp) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.invokeOemRilRequestRaw(oemReq, oemResp);
            }
        }
        catch (RemoteException remoteException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return -1;
    }

    private final void $$robo$$android_telephony_TelephonyManager$enableVideoCalling(boolean enable) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.enableVideoCalling(enable);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#enableVideoCalling", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isVideoCallingEnabled() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isVideoCallingEnabled(this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isVideoCallingEnabled", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$canChangeDtmfToneLength() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.canChangeDtmfToneLength();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#canChangeDtmfToneLength", e);
        }
        catch (SecurityException e) {
            Log.e("TelephonyManager", "Permission error calling ITelephony#canChangeDtmfToneLength", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isWorldPhone() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isWorldPhone();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isWorldPhone", e);
        }
        catch (SecurityException e) {
            Log.e("TelephonyManager", "Permission error calling ITelephony#isWorldPhone", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isTtyModeSupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isTtyModeSupported();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isTtyModeSupported", e);
        }
        catch (SecurityException e) {
            Log.e("TelephonyManager", "Permission error calling ITelephony#isTtyModeSupported", e);
        }
        return false;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isHearingAidCompatibilitySupported() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.isHearingAidCompatibilitySupported();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        catch (SecurityException e) {
            Log.e("TelephonyManager", "Permission error calling ITelephony#isHearingAidCompatibilitySupported", e);
        }
        return false;
    }

    private static final int $$robo$$android_telephony_TelephonyManager$getIntWithSubId(ContentResolver cr, String name, int subId) throws Settings.SettingNotFoundException {
        try {
            return Settings.Global.getInt(cr, name + subId);
        }
        catch (Settings.SettingNotFoundException e) {
            try {
                int val = Settings.Global.getInt(cr, name);
                Settings.Global.putInt(cr, name + subId, val);
                int default_val = val;
                if (name.equals("mobile_data")) {
                    default_val = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.mobiledata", "true")) ? 1 : 0;
                } else if (name.equals("data_roaming")) {
                    int n = default_val = "true".equalsIgnoreCase(SystemProperties.get("ro.com.android.dataroaming", "false")) ? 1 : 0;
                }
                if (default_val != val) {
                    Settings.Global.putInt(cr, name, default_val);
                }
                return val;
            }
            catch (Settings.SettingNotFoundException exc) {
                throw new Settings.SettingNotFoundException(name);
            }
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isImsRegistered() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.isImsRegistered();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isVolteAvailable() {
        try {
            return this.getITelephony().isVolteAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isVideoTelephonyAvailable() {
        try {
            return this.getITelephony().isVideoTelephonyAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isWifiCallingAvailable() {
        try {
            return this.getITelephony().isWifiCallingAvailable();
        }
        catch (RemoteException ex) {
            return false;
        }
        catch (NullPointerException ex) {
            return false;
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimOperatorNumeric(String numeric) {
        int phoneId = this.getPhoneId();
        this.setSimOperatorNumericForPhone(phoneId, numeric);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimOperatorNumericForPhone(int phoneId, String numeric) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.numeric", numeric);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimOperatorName(String name) {
        int phoneId = this.getPhoneId();
        this.setSimOperatorNameForPhone(phoneId, name);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimOperatorNameForPhone(int phoneId, String name) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.alpha", name);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimCountryIso(String iso) {
        int phoneId = this.getPhoneId();
        this.setSimCountryIsoForPhone(phoneId, iso);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimCountryIsoForPhone(int phoneId, String iso) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.operator.iso-country", iso);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimState(String state) {
        int phoneId = this.getPhoneId();
        this.setSimStateForPhone(phoneId, state);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimStateForPhone(int phoneId, String state) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.sim.state", state);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimPowerState(boolean powerUp) {
        this.setSimPowerStateForSlot(this.getSlotIndex(), powerUp);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setSimPowerStateForSlot(int slotIndex, boolean powerUp) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.setSimPowerStateForSlot(slotIndex, powerUp);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setSimPowerStateForSlot", e);
        }
        catch (SecurityException e) {
            Log.e("TelephonyManager", "Permission error calling ITelephony#setSimPowerStateForSlot", e);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setBasebandVersion(String version) {
        int phoneId = this.getPhoneId();
        this.setBasebandVersionForPhone(phoneId, version);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setBasebandVersionForPhone(int phoneId, String version) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            String prop = "gsm.version.baseband" + (phoneId == 0 ? "" : Integer.toString(phoneId));
            SystemProperties.set(prop, version);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setPhoneType(int type) {
        int phoneId = this.getPhoneId();
        this.setPhoneType(phoneId, type);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setPhoneType(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.current.phone-type", String.valueOf(type));
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getOtaSpNumberSchema(String defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getOtaSpNumberSchemaForPhone(phoneId, defaultValue);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getOtaSpNumberSchemaForPhone(int phoneId, String defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return TelephonyManager.getTelephonyProperty(phoneId, "ro.cdma.otaspnumschema", defaultValue);
        }
        return defaultValue;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getSmsReceiveCapable(boolean defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getSmsReceiveCapableForPhone(phoneId, defaultValue);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getSmsReceiveCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "telephony.sms.receive", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getSmsSendCapable(boolean defaultValue) {
        int phoneId = this.getPhoneId();
        return this.getSmsSendCapableForPhone(phoneId, defaultValue);
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getSmsSendCapableForPhone(int phoneId, boolean defaultValue) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            return Boolean.parseBoolean(TelephonyManager.getTelephonyProperty(phoneId, "telephony.sms.send", String.valueOf(defaultValue)));
        }
        return defaultValue;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkOperatorName(String name) {
        int phoneId = this.getPhoneId();
        this.setNetworkOperatorNameForPhone(phoneId, name);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkOperatorNameForPhone(int phoneId, String name) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.alpha", name);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkOperatorNumeric(String numeric) {
        int phoneId = this.getPhoneId();
        this.setNetworkOperatorNumericForPhone(phoneId, numeric);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkOperatorNumericForPhone(int phoneId, String numeric) {
        TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.numeric", numeric);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkRoaming(boolean isRoaming) {
        int phoneId = this.getPhoneId();
        this.setNetworkRoamingForPhone(phoneId, isRoaming);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkRoamingForPhone(int phoneId, boolean isRoaming) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.isroaming", isRoaming ? "true" : "false");
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkCountryIso(String iso) {
        int phoneId = this.getPhoneId();
        this.setNetworkCountryIsoForPhone(phoneId, iso);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setNetworkCountryIsoForPhone(int phoneId, String iso) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.operator.iso-country", iso);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$setDataNetworkType(int type) {
        int phoneId = this.getPhoneId(SubscriptionManager.getDefaultDataSubscriptionId());
        this.setDataNetworkTypeForPhone(phoneId, type);
    }

    private final void $$robo$$android_telephony_TelephonyManager$setDataNetworkTypeForPhone(int phoneId, int type) {
        if (SubscriptionManager.isValidPhoneId(phoneId)) {
            TelephonyManager.setTelephonyProperty(phoneId, "gsm.network.type", ServiceState.rilRadioTechnologyToString(type));
        }
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSubIdForPhoneAccount(PhoneAccount phoneAccount) {
        int retval = -1;
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                retval = service.getSubIdForPhoneAccount(phoneAccount);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retval;
    }

    private final int $$robo$$android_telephony_TelephonyManager$getSubIdForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        int retval = -1;
        try {
            ITelecomService service = this.getTelecomService();
            if (service != null) {
                retval = this.getSubIdForPhoneAccount(service.getPhoneAccount(phoneAccountHandle));
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return retval;
    }

    private final void $$robo$$android_telephony_TelephonyManager$factoryReset(int subId) {
        try {
            Log.d("TelephonyManager", "factoryReset: subId=" + subId);
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                telephony.factoryReset(subId);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getLocaleFromDefaultSim() {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony != null) {
                return telephony.getLocaleFromDefaultSim();
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return null;
    }

    private final void $$robo$$android_telephony_TelephonyManager$requestModemActivityInfo(ResultReceiver result) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.requestModemActivityInfo(result);
                return;
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getModemActivityInfo", e);
        }
        result.send(0, null);
    }

    private final ServiceState $$robo$$android_telephony_TelephonyManager$getServiceState() {
        return this.getServiceStateForSubscriber(this.getSubId());
    }

    private final ServiceState $$robo$$android_telephony_TelephonyManager$getServiceStateForSubscriber(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getServiceStateForSubscriber(subId, this.getOpPackageName());
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getServiceStateForSubscriber", e);
        }
        return null;
    }

    private final Uri $$robo$$android_telephony_TelephonyManager$getVoicemailRingtoneUri(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getVoicemailRingtoneUri(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getVoicemailRingtoneUri", e);
        }
        return null;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setVoicemailRingtoneUri(PhoneAccountHandle phoneAccountHandle, Uri uri) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setVoicemailRingtoneUri(this.getOpPackageName(), phoneAccountHandle, uri);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setVoicemailRingtoneUri", e);
        }
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$isVoicemailVibrationEnabled(PhoneAccountHandle accountHandle) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.isVoicemailVibrationEnabled(accountHandle);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
        return false;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setVoicemailVibrationEnabled(PhoneAccountHandle phoneAccountHandle, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setVoicemailVibrationEnabled(this.getOpPackageName(), phoneAccountHandle, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#isVoicemailVibrationEnabled", e);
        }
    }

    private final String $$robo$$android_telephony_TelephonyManager$getAidForAppType(int appType) {
        return this.getAidForAppType(this.getSubId(), appType);
    }

    private final String $$robo$$android_telephony_TelephonyManager$getAidForAppType(int subId, int appType) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getAidForAppType(subId, appType);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getAidForAppType", e);
        }
        return null;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getEsn() {
        return this.getEsn(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getEsn(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getEsn(subId);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getEsn", e);
        }
        return null;
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaPrlVersion() {
        return this.getCdmaPrlVersion(this.getSubId());
    }

    private final String $$robo$$android_telephony_TelephonyManager$getCdmaPrlVersion(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getCdmaPrlVersion(subId);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getCdmaPrlVersion", e);
        }
        return null;
    }

    private final List<TelephonyHistogram> $$robo$$android_telephony_TelephonyManager$getTelephonyHistograms() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getTelephonyHistograms();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getTelephonyHistograms", e);
        }
        return null;
    }

    private final int $$robo$$android_telephony_TelephonyManager$setAllowedCarriers(int slotIndex, List<CarrierIdentifier> carriers) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.setAllowedCarriers(slotIndex, carriers);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setAllowedCarriers", e);
        }
        catch (NullPointerException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setAllowedCarriers", e);
        }
        return -1;
    }

    private final List<CarrierIdentifier> $$robo$$android_telephony_TelephonyManager$getAllowedCarriers(int slotIndex) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getAllowedCarriers(slotIndex);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getAllowedCarriers", e);
        }
        catch (NullPointerException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setAllowedCarriers", e);
        }
        return new ArrayList<CarrierIdentifier>(0);
    }

    private final void $$robo$$android_telephony_TelephonyManager$carrierActionSetMeteredApnsEnabled(int subId, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionSetMeteredApnsEnabled(subId, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#carrierActionSetMeteredApnsEnabled", e);
        }
    }

    private final void $$robo$$android_telephony_TelephonyManager$carrierActionSetRadioEnabled(int subId, boolean enabled) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.carrierActionSetRadioEnabled(subId, enabled);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#carrierActionSetRadioEnabled", e);
        }
    }

    private final long $$robo$$android_telephony_TelephonyManager$getVtDataUsage() {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getVtDataUsage();
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling getVtDataUsage", e);
        }
        return 0L;
    }

    private final void $$robo$$android_telephony_TelephonyManager$setPolicyDataEnabled(boolean enabled, int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                service.setPolicyDataEnabled(enabled, subId);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#setPolicyDataEnabled", e);
        }
    }

    private final List<ClientRequestStats> $$robo$$android_telephony_TelephonyManager$getClientRequestStats(int subId) {
        try {
            ITelephony service = this.getITelephony();
            if (service != null) {
                return service.getClientRequestStats(this.getOpPackageName(), subId);
            }
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getClientRequestStats", e);
        }
        return null;
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getEmergencyCallbackMode() {
        return this.getEmergencyCallbackMode(this.getSubId());
    }

    private final boolean $$robo$$android_telephony_TelephonyManager$getEmergencyCallbackMode(int subId) {
        try {
            ITelephony telephony = this.getITelephony();
            if (telephony == null) {
                return false;
            }
            return telephony.getEmergencyCallbackMode(subId);
        }
        catch (RemoteException e) {
            Log.e("TelephonyManager", "Error calling ITelephony#getEmergencyCallbackMode", e);
            return false;
        }
    }

    static void __staticInitializer__() {
        multiSimConfig = SystemProperties.get("persist.radio.multisim.config");
        sInstance = new TelephonyManager();
        EXTRA_STATE_IDLE = PhoneConstants.State.IDLE.toString();
        EXTRA_STATE_RINGING = PhoneConstants.State.RINGING.toString();
        EXTRA_STATE_OFFHOOK = PhoneConstants.State.OFFHOOK.toString();
        sKernelCmdLine = TelephonyManager.getProcCmdLine();
        sProductTypePattern = Pattern.compile("\\sproduct_type\\s*=\\s*(\\w+)");
        sLteOnCdmaProductType = SystemProperties.get("telephony.lteOnCdmaProductType", "");
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_telephony_TelephonyManager$__constructor__(context);
    }

    public TelephonyManager(Context context) {
        this(context, Integer.MAX_VALUE);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, int n) {
        this.$$robo$$android_telephony_TelephonyManager$__constructor__(context, n);
    }

    public TelephonyManager(Context context, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager$__constructor__(android.content.Context int ), 0, this, context, n);
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_TelephonyManager$__constructor__();
    }

    private TelephonyManager() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager$__constructor__(), 0, this);
    }

    public static TelephonyManager getDefault() {
        return InvokeDynamicSupport.bootstrapStatic("getDefault", $$robo$$android_telephony_TelephonyManager$getDefault(), 0);
    }

    private String getOpPackageName() {
        return InvokeDynamicSupport.bootstrap("getOpPackageName", $$robo$$android_telephony_TelephonyManager$getOpPackageName(), 0, this);
    }

    public MultiSimVariants getMultiSimConfiguration() {
        return InvokeDynamicSupport.bootstrap("getMultiSimConfiguration", $$robo$$android_telephony_TelephonyManager$getMultiSimConfiguration(), 0, this);
    }

    public int getPhoneCount() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneCount", $$robo$$android_telephony_TelephonyManager$getPhoneCount(), 0, this);
    }

    public static TelephonyManager from(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("from", $$robo$$android_telephony_TelephonyManager$from(android.content.Context ), 0, (Context)context);
    }

    public TelephonyManager createForSubscriptionId(int n) {
        return InvokeDynamicSupport.bootstrap("createForSubscriptionId", $$robo$$android_telephony_TelephonyManager$createForSubscriptionId(int ), 0, this, n);
    }

    public TelephonyManager createForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("createForPhoneAccountHandle", $$robo$$android_telephony_TelephonyManager$createForPhoneAccountHandle(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public boolean isMultiSimEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMultiSimEnabled", $$robo$$android_telephony_TelephonyManager$isMultiSimEnabled(), 0, this);
    }

    public String getDeviceSoftwareVersion() {
        return InvokeDynamicSupport.bootstrap("getDeviceSoftwareVersion", $$robo$$android_telephony_TelephonyManager$getDeviceSoftwareVersion(), 0, this);
    }

    public String getDeviceSoftwareVersion(int n) {
        return InvokeDynamicSupport.bootstrap("getDeviceSoftwareVersion", $$robo$$android_telephony_TelephonyManager$getDeviceSoftwareVersion(int ), 0, this, n);
    }

    @Deprecated
    public String getDeviceId() {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_telephony_TelephonyManager$getDeviceId(), 0, this);
    }

    @Deprecated
    public String getDeviceId(int n) {
        return InvokeDynamicSupport.bootstrap("getDeviceId", $$robo$$android_telephony_TelephonyManager$getDeviceId(int ), 0, this, n);
    }

    public String getImei() {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$android_telephony_TelephonyManager$getImei(), 0, this);
    }

    public String getImei(int n) {
        return InvokeDynamicSupport.bootstrap("getImei", $$robo$$android_telephony_TelephonyManager$getImei(int ), 0, this, n);
    }

    public String getMeid() {
        return InvokeDynamicSupport.bootstrap("getMeid", $$robo$$android_telephony_TelephonyManager$getMeid(), 0, this);
    }

    public String getMeid(int n) {
        return InvokeDynamicSupport.bootstrap("getMeid", $$robo$$android_telephony_TelephonyManager$getMeid(int ), 0, this, n);
    }

    public String getNai() {
        return InvokeDynamicSupport.bootstrap("getNai", $$robo$$android_telephony_TelephonyManager$getNai(), 0, this);
    }

    public String getNai(int n) {
        return InvokeDynamicSupport.bootstrap("getNai", $$robo$$android_telephony_TelephonyManager$getNai(int ), 0, this, n);
    }

    @Deprecated
    public CellLocation getCellLocation() {
        return InvokeDynamicSupport.bootstrap("getCellLocation", $$robo$$android_telephony_TelephonyManager$getCellLocation(), 0, this);
    }

    public void enableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$android_telephony_TelephonyManager$enableLocationUpdates(), 0, this);
    }

    public void enableLocationUpdates(int n) {
        InvokeDynamicSupport.bootstrap("enableLocationUpdates", $$robo$$android_telephony_TelephonyManager$enableLocationUpdates(int ), 0, this, n);
    }

    public void disableLocationUpdates() {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$android_telephony_TelephonyManager$disableLocationUpdates(), 0, this);
    }

    public void disableLocationUpdates(int n) {
        InvokeDynamicSupport.bootstrap("disableLocationUpdates", $$robo$$android_telephony_TelephonyManager$disableLocationUpdates(int ), 0, this, n);
    }

    @Deprecated
    public List<NeighboringCellInfo> getNeighboringCellInfo() {
        return InvokeDynamicSupport.bootstrap("getNeighboringCellInfo", $$robo$$android_telephony_TelephonyManager$getNeighboringCellInfo(), 0, this);
    }

    public int getCurrentPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPhoneType", $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType(), 0, this);
    }

    public int getCurrentPhoneType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPhoneType", $$robo$$android_telephony_TelephonyManager$getCurrentPhoneType(int ), 0, this, n);
    }

    public int getCurrentPhoneTypeForSlot(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCurrentPhoneTypeForSlot", $$robo$$android_telephony_TelephonyManager$getCurrentPhoneTypeForSlot(int ), 0, this, n);
    }

    public int getPhoneType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneType", $$robo$$android_telephony_TelephonyManager$getPhoneType(), 0, this);
    }

    private int getPhoneTypeFromProperty() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromProperty", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty(), 0, this);
    }

    private int getPhoneTypeFromProperty(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromProperty", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromProperty(int ), 0, this, n);
    }

    private int getPhoneTypeFromNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromNetworkType", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType(), 0, this);
    }

    private int getPhoneTypeFromNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneTypeFromNetworkType", $$robo$$android_telephony_TelephonyManager$getPhoneTypeFromNetworkType(int ), 0, this, n);
    }

    public static int getPhoneType(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getPhoneType", $$robo$$android_telephony_TelephonyManager$getPhoneType(int ), 0, (int)n);
    }

    private static String getProcCmdLine() {
        return InvokeDynamicSupport.bootstrapStatic("getProcCmdLine", $$robo$$android_telephony_TelephonyManager$getProcCmdLine(), 0);
    }

    public static int getLteOnCdmaModeStatic() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getLteOnCdmaModeStatic", $$robo$$android_telephony_TelephonyManager$getLteOnCdmaModeStatic(), 0);
    }

    public String getNetworkOperatorName() {
        return InvokeDynamicSupport.bootstrap("getNetworkOperatorName", $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName(), 0, this);
    }

    public String getNetworkOperatorName(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkOperatorName", $$robo$$android_telephony_TelephonyManager$getNetworkOperatorName(int ), 0, this, n);
    }

    public String getNetworkOperator() {
        return InvokeDynamicSupport.bootstrap("getNetworkOperator", $$robo$$android_telephony_TelephonyManager$getNetworkOperator(), 0, this);
    }

    public String getNetworkOperator(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkOperator", $$robo$$android_telephony_TelephonyManager$getNetworkOperator(int ), 0, this, n);
    }

    public String getNetworkOperatorForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkOperatorForPhone", $$robo$$android_telephony_TelephonyManager$getNetworkOperatorForPhone(int ), 0, this, n);
    }

    public String getNetworkSpecifier() {
        return InvokeDynamicSupport.bootstrap("getNetworkSpecifier", $$robo$$android_telephony_TelephonyManager$getNetworkSpecifier(), 0, this);
    }

    public PersistableBundle getCarrierConfig() {
        return InvokeDynamicSupport.bootstrap("getCarrierConfig", $$robo$$android_telephony_TelephonyManager$getCarrierConfig(), 0, this);
    }

    public boolean isNetworkRoaming() {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkRoaming", $$robo$$android_telephony_TelephonyManager$isNetworkRoaming(), 0, this);
    }

    public boolean isNetworkRoaming(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("isNetworkRoaming", $$robo$$android_telephony_TelephonyManager$isNetworkRoaming(int ), 0, this, n);
    }

    public String getNetworkCountryIso() {
        return InvokeDynamicSupport.bootstrap("getNetworkCountryIso", $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso(), 0, this);
    }

    public String getNetworkCountryIso(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkCountryIso", $$robo$$android_telephony_TelephonyManager$getNetworkCountryIso(int ), 0, this, n);
    }

    public String getNetworkCountryIsoForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getNetworkCountryIsoForPhone", $$robo$$android_telephony_TelephonyManager$getNetworkCountryIsoForPhone(int ), 0, this, n);
    }

    public int getNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkType", $$robo$$android_telephony_TelephonyManager$getNetworkType(), 0, this);
    }

    public int getNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkType", $$robo$$android_telephony_TelephonyManager$getNetworkType(int ), 0, this, n);
    }

    public int getDataNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getDataNetworkType", $$robo$$android_telephony_TelephonyManager$getDataNetworkType(), 0, this);
    }

    public int getDataNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDataNetworkType", $$robo$$android_telephony_TelephonyManager$getDataNetworkType(int ), 0, this, n);
    }

    public int getVoiceNetworkType() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceNetworkType", $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType(), 0, this);
    }

    public int getVoiceNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceNetworkType", $$robo$$android_telephony_TelephonyManager$getVoiceNetworkType(int ), 0, this, n);
    }

    public static int getNetworkClass(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getNetworkClass", $$robo$$android_telephony_TelephonyManager$getNetworkClass(int ), 0, (int)n);
    }

    public String getNetworkTypeName() {
        return InvokeDynamicSupport.bootstrap("getNetworkTypeName", $$robo$$android_telephony_TelephonyManager$getNetworkTypeName(), 0, this);
    }

    public static String getNetworkTypeName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkTypeName", $$robo$$android_telephony_TelephonyManager$getNetworkTypeName(int ), 0, (int)n);
    }

    public boolean hasIccCard() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIccCard", $$robo$$android_telephony_TelephonyManager$hasIccCard(), 0, this);
    }

    public boolean hasIccCard(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasIccCard", $$robo$$android_telephony_TelephonyManager$hasIccCard(int ), 0, this, n);
    }

    public int getSimState() {
        return (int)InvokeDynamicSupport.bootstrap("getSimState", $$robo$$android_telephony_TelephonyManager$getSimState(), 0, this);
    }

    public int getSimState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSimState", $$robo$$android_telephony_TelephonyManager$getSimState(int ), 0, this, n);
    }

    public String getSimOperator() {
        return InvokeDynamicSupport.bootstrap("getSimOperator", $$robo$$android_telephony_TelephonyManager$getSimOperator(), 0, this);
    }

    public String getSimOperator(int n) {
        return InvokeDynamicSupport.bootstrap("getSimOperator", $$robo$$android_telephony_TelephonyManager$getSimOperator(int ), 0, this, n);
    }

    public String getSimOperatorNumeric() {
        return InvokeDynamicSupport.bootstrap("getSimOperatorNumeric", $$robo$$android_telephony_TelephonyManager$getSimOperatorNumeric(), 0, this);
    }

    public String getSimOperatorNumeric(int n) {
        return InvokeDynamicSupport.bootstrap("getSimOperatorNumeric", $$robo$$android_telephony_TelephonyManager$getSimOperatorNumeric(int ), 0, this, n);
    }

    public String getSimOperatorNumericForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getSimOperatorNumericForPhone", $$robo$$android_telephony_TelephonyManager$getSimOperatorNumericForPhone(int ), 0, this, n);
    }

    public String getSimOperatorName() {
        return InvokeDynamicSupport.bootstrap("getSimOperatorName", $$robo$$android_telephony_TelephonyManager$getSimOperatorName(), 0, this);
    }

    public String getSimOperatorName(int n) {
        return InvokeDynamicSupport.bootstrap("getSimOperatorName", $$robo$$android_telephony_TelephonyManager$getSimOperatorName(int ), 0, this, n);
    }

    public String getSimOperatorNameForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getSimOperatorNameForPhone", $$robo$$android_telephony_TelephonyManager$getSimOperatorNameForPhone(int ), 0, this, n);
    }

    public String getSimCountryIso() {
        return InvokeDynamicSupport.bootstrap("getSimCountryIso", $$robo$$android_telephony_TelephonyManager$getSimCountryIso(), 0, this);
    }

    public String getSimCountryIso(int n) {
        return InvokeDynamicSupport.bootstrap("getSimCountryIso", $$robo$$android_telephony_TelephonyManager$getSimCountryIso(int ), 0, this, n);
    }

    public String getSimCountryIsoForPhone(int n) {
        return InvokeDynamicSupport.bootstrap("getSimCountryIsoForPhone", $$robo$$android_telephony_TelephonyManager$getSimCountryIsoForPhone(int ), 0, this, n);
    }

    public String getSimSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getSimSerialNumber", $$robo$$android_telephony_TelephonyManager$getSimSerialNumber(), 0, this);
    }

    public String getSimSerialNumber(int n) {
        return InvokeDynamicSupport.bootstrap("getSimSerialNumber", $$robo$$android_telephony_TelephonyManager$getSimSerialNumber(int ), 0, this, n);
    }

    public int getLteOnCdmaMode() {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode(), 0, this);
    }

    public int getLteOnCdmaMode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getLteOnCdmaMode", $$robo$$android_telephony_TelephonyManager$getLteOnCdmaMode(int ), 0, this, n);
    }

    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_telephony_TelephonyManager$getSubscriberId(), 0, this);
    }

    public String getSubscriberId(int n) {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_telephony_TelephonyManager$getSubscriberId(int ), 0, this, n);
    }

    public String getGroupIdLevel1() {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1(), 0, this);
    }

    public String getGroupIdLevel1(int n) {
        return InvokeDynamicSupport.bootstrap("getGroupIdLevel1", $$robo$$android_telephony_TelephonyManager$getGroupIdLevel1(int ), 0, this, n);
    }

    public String getLine1Number() {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$android_telephony_TelephonyManager$getLine1Number(), 0, this);
    }

    public String getLine1Number(int n) {
        return InvokeDynamicSupport.bootstrap("getLine1Number", $$robo$$android_telephony_TelephonyManager$getLine1Number(int ), 0, this, n);
    }

    public boolean setLine1NumberForDisplay(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("setLine1NumberForDisplay", $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplay(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean setLine1NumberForDisplay(int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("setLine1NumberForDisplay", $$robo$$android_telephony_TelephonyManager$setLine1NumberForDisplay(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    public String getLine1AlphaTag() {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$android_telephony_TelephonyManager$getLine1AlphaTag(), 0, this);
    }

    public String getLine1AlphaTag(int n) {
        return InvokeDynamicSupport.bootstrap("getLine1AlphaTag", $$robo$$android_telephony_TelephonyManager$getLine1AlphaTag(int ), 0, this, n);
    }

    public String[] getMergedSubscriberIds() {
        return InvokeDynamicSupport.bootstrap("getMergedSubscriberIds", $$robo$$android_telephony_TelephonyManager$getMergedSubscriberIds(), 0, this);
    }

    public String getMsisdn() {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$android_telephony_TelephonyManager$getMsisdn(), 0, this);
    }

    public String getMsisdn(int n) {
        return InvokeDynamicSupport.bootstrap("getMsisdn", $$robo$$android_telephony_TelephonyManager$getMsisdn(int ), 0, this, n);
    }

    public String getVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber(), 0, this);
    }

    public String getVoiceMailNumber(int n) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getVoiceMailNumber(int ), 0, this, n);
    }

    public String getCompleteVoiceMailNumber() {
        return InvokeDynamicSupport.bootstrap("getCompleteVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber(), 0, this);
    }

    public String getCompleteVoiceMailNumber(int n) {
        return InvokeDynamicSupport.bootstrap("getCompleteVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$getCompleteVoiceMailNumber(int ), 0, this, n);
    }

    public boolean setVoiceMailNumber(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$setVoiceMailNumber(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean setVoiceMailNumber(int n, String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("setVoiceMailNumber", $$robo$$android_telephony_TelephonyManager$setVoiceMailNumber(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    public void setVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle, boolean bl) {
        InvokeDynamicSupport.bootstrap("setVisualVoicemailEnabled", $$robo$$android_telephony_TelephonyManager$setVisualVoicemailEnabled(android.telecom.PhoneAccountHandle boolean ), 0, this, phoneAccountHandle, bl);
    }

    public boolean isVisualVoicemailEnabled(PhoneAccountHandle phoneAccountHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVisualVoicemailEnabled", $$robo$$android_telephony_TelephonyManager$isVisualVoicemailEnabled(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public Bundle getVisualVoicemailSettings() {
        return InvokeDynamicSupport.bootstrap("getVisualVoicemailSettings", $$robo$$android_telephony_TelephonyManager$getVisualVoicemailSettings(), 0, this);
    }

    public String getVisualVoicemailPackageName() {
        return InvokeDynamicSupport.bootstrap("getVisualVoicemailPackageName", $$robo$$android_telephony_TelephonyManager$getVisualVoicemailPackageName(), 0, this);
    }

    public void setVisualVoicemailSmsFilterSettings(VisualVoicemailSmsFilterSettings visualVoicemailSmsFilterSettings) {
        InvokeDynamicSupport.bootstrap("setVisualVoicemailSmsFilterSettings", $$robo$$android_telephony_TelephonyManager$setVisualVoicemailSmsFilterSettings(android.telephony.VisualVoicemailSmsFilterSettings ), 0, this, visualVoicemailSmsFilterSettings);
    }

    public void sendVisualVoicemailSms(String string2, int n, String string3, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("sendVisualVoicemailSms", $$robo$$android_telephony_TelephonyManager$sendVisualVoicemailSms(java.lang.String int java.lang.String android.app.PendingIntent ), 0, this, string2, n, string3, pendingIntent);
    }

    public void enableVisualVoicemailSmsFilter(int n, VisualVoicemailSmsFilterSettings visualVoicemailSmsFilterSettings) {
        InvokeDynamicSupport.bootstrap("enableVisualVoicemailSmsFilter", $$robo$$android_telephony_TelephonyManager$enableVisualVoicemailSmsFilter(int android.telephony.VisualVoicemailSmsFilterSettings ), 0, this, n, visualVoicemailSmsFilterSettings);
    }

    public void disableVisualVoicemailSmsFilter(int n) {
        InvokeDynamicSupport.bootstrap("disableVisualVoicemailSmsFilter", $$robo$$android_telephony_TelephonyManager$disableVisualVoicemailSmsFilter(int ), 0, this, n);
    }

    public VisualVoicemailSmsFilterSettings getVisualVoicemailSmsFilterSettings(int n) {
        return InvokeDynamicSupport.bootstrap("getVisualVoicemailSmsFilterSettings", $$robo$$android_telephony_TelephonyManager$getVisualVoicemailSmsFilterSettings(int ), 0, this, n);
    }

    public VisualVoicemailSmsFilterSettings getActiveVisualVoicemailSmsFilterSettings(int n) {
        return InvokeDynamicSupport.bootstrap("getActiveVisualVoicemailSmsFilterSettings", $$robo$$android_telephony_TelephonyManager$getActiveVisualVoicemailSmsFilterSettings(int ), 0, this, n);
    }

    public void sendVisualVoicemailSmsForSubscriber(int n, String string2, int n2, String string3, PendingIntent pendingIntent) {
        InvokeDynamicSupport.bootstrap("sendVisualVoicemailSmsForSubscriber", $$robo$$android_telephony_TelephonyManager$sendVisualVoicemailSmsForSubscriber(int java.lang.String int java.lang.String android.app.PendingIntent ), 0, this, n, string2, n2, string3, pendingIntent);
    }

    public void setVoiceActivationState(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setVoiceActivationState", $$robo$$android_telephony_TelephonyManager$setVoiceActivationState(int int ), 0, this, n, n2);
    }

    public void setDataActivationState(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDataActivationState", $$robo$$android_telephony_TelephonyManager$setDataActivationState(int int ), 0, this, n, n2);
    }

    public int getVoiceActivationState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceActivationState", $$robo$$android_telephony_TelephonyManager$getVoiceActivationState(int ), 0, this, n);
    }

    public int getDataActivationState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getDataActivationState", $$robo$$android_telephony_TelephonyManager$getDataActivationState(int ), 0, this, n);
    }

    public int getVoiceMessageCount() {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount(), 0, this);
    }

    public int getVoiceMessageCount(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getVoiceMessageCount", $$robo$$android_telephony_TelephonyManager$getVoiceMessageCount(int ), 0, this, n);
    }

    public String getVoiceMailAlphaTag() {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag(), 0, this);
    }

    public String getVoiceMailAlphaTag(int n) {
        return InvokeDynamicSupport.bootstrap("getVoiceMailAlphaTag", $$robo$$android_telephony_TelephonyManager$getVoiceMailAlphaTag(int ), 0, this, n);
    }

    public void sendDialerSpecialCode(String string2) {
        InvokeDynamicSupport.bootstrap("sendDialerSpecialCode", $$robo$$android_telephony_TelephonyManager$sendDialerSpecialCode(java.lang.String ), 0, this, string2);
    }

    public String getIsimImpi() {
        return InvokeDynamicSupport.bootstrap("getIsimImpi", $$robo$$android_telephony_TelephonyManager$getIsimImpi(), 0, this);
    }

    public String getIsimDomain() {
        return InvokeDynamicSupport.bootstrap("getIsimDomain", $$robo$$android_telephony_TelephonyManager$getIsimDomain(), 0, this);
    }

    public String[] getIsimImpu() {
        return InvokeDynamicSupport.bootstrap("getIsimImpu", $$robo$$android_telephony_TelephonyManager$getIsimImpu(), 0, this);
    }

    private IPhoneSubInfo getSubscriberInfo() {
        return InvokeDynamicSupport.bootstrap("getSubscriberInfo", $$robo$$android_telephony_TelephonyManager$getSubscriberInfo(), 0, this);
    }

    public int getCallState() {
        return (int)InvokeDynamicSupport.bootstrap("getCallState", $$robo$$android_telephony_TelephonyManager$getCallState(), 0, this);
    }

    public int getCallState(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCallState", $$robo$$android_telephony_TelephonyManager$getCallState(int ), 0, this, n);
    }

    public int getCallStateForSlot(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCallStateForSlot", $$robo$$android_telephony_TelephonyManager$getCallStateForSlot(int ), 0, this, n);
    }

    public int getDataActivity() {
        return (int)InvokeDynamicSupport.bootstrap("getDataActivity", $$robo$$android_telephony_TelephonyManager$getDataActivity(), 0, this);
    }

    public int getDataState() {
        return (int)InvokeDynamicSupport.bootstrap("getDataState", $$robo$$android_telephony_TelephonyManager$getDataState(), 0, this);
    }

    private ITelephony getITelephony() {
        return InvokeDynamicSupport.bootstrap("getITelephony", $$robo$$android_telephony_TelephonyManager$getITelephony(), 0, this);
    }

    private ITelecomService getTelecomService() {
        return InvokeDynamicSupport.bootstrap("getTelecomService", $$robo$$android_telephony_TelephonyManager$getTelecomService(), 0, this);
    }

    public void listen(PhoneStateListener phoneStateListener, int n) {
        InvokeDynamicSupport.bootstrap("listen", $$robo$$android_telephony_TelephonyManager$listen(android.telephony.PhoneStateListener int ), 0, this, phoneStateListener, n);
    }

    public int getCdmaEriIconIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex(), 0, this);
    }

    public int getCdmaEriIconIndex(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconIndex", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconIndex(int ), 0, this, n);
    }

    public int getCdmaEriIconMode() {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode(), 0, this);
    }

    public int getCdmaEriIconMode(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getCdmaEriIconMode", $$robo$$android_telephony_TelephonyManager$getCdmaEriIconMode(int ), 0, this, n);
    }

    public String getCdmaEriText() {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$android_telephony_TelephonyManager$getCdmaEriText(), 0, this);
    }

    public String getCdmaEriText(int n) {
        return InvokeDynamicSupport.bootstrap("getCdmaEriText", $$robo$$android_telephony_TelephonyManager$getCdmaEriText(int ), 0, this, n);
    }

    public boolean isVoiceCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoiceCapable", $$robo$$android_telephony_TelephonyManager$isVoiceCapable(), 0, this);
    }

    public boolean isSmsCapable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSmsCapable", $$robo$$android_telephony_TelephonyManager$isSmsCapable(), 0, this);
    }

    public List<CellInfo> getAllCellInfo() {
        return InvokeDynamicSupport.bootstrap("getAllCellInfo", $$robo$$android_telephony_TelephonyManager$getAllCellInfo(), 0, this);
    }

    public void setCellInfoListRate(int n) {
        InvokeDynamicSupport.bootstrap("setCellInfoListRate", $$robo$$android_telephony_TelephonyManager$setCellInfoListRate(int ), 0, this, n);
    }

    public String getMmsUserAgent() {
        return InvokeDynamicSupport.bootstrap("getMmsUserAgent", $$robo$$android_telephony_TelephonyManager$getMmsUserAgent(), 0, this);
    }

    public String getMmsUAProfUrl() {
        return InvokeDynamicSupport.bootstrap("getMmsUAProfUrl", $$robo$$android_telephony_TelephonyManager$getMmsUAProfUrl(), 0, this);
    }

    @Deprecated
    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String string2) {
        return InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(java.lang.String ), 0, this, string2);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(java.lang.String int ), 0, this, string2, n);
    }

    public IccOpenLogicalChannelResponse iccOpenLogicalChannel(int n, String string2, int n2) {
        return InvokeDynamicSupport.bootstrap("iccOpenLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccOpenLogicalChannel(int java.lang.String int ), 0, this, n, string2, n2);
    }

    public boolean iccCloseLogicalChannel(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccCloseLogicalChannel(int ), 0, this, n);
    }

    public boolean iccCloseLogicalChannel(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("iccCloseLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccCloseLogicalChannel(int int ), 0, this, n, n2);
    }

    public String iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        return InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccTransmitApduLogicalChannel(int int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, n6, string2);
    }

    public String iccTransmitApduLogicalChannel(int n, int n2, int n3, int n4, int n5, int n6, int n7, String string2) {
        return InvokeDynamicSupport.bootstrap("iccTransmitApduLogicalChannel", $$robo$$android_telephony_TelephonyManager$iccTransmitApduLogicalChannel(int int int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, n6, n7, string2);
    }

    public String iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, String string2) {
        return InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$android_telephony_TelephonyManager$iccTransmitApduBasicChannel(int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, string2);
    }

    public String iccTransmitApduBasicChannel(int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        return InvokeDynamicSupport.bootstrap("iccTransmitApduBasicChannel", $$robo$$android_telephony_TelephonyManager$iccTransmitApduBasicChannel(int int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, n6, string2);
    }

    public byte[] iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, String string2) {
        return InvokeDynamicSupport.bootstrap("iccExchangeSimIO", $$robo$$android_telephony_TelephonyManager$iccExchangeSimIO(int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, string2);
    }

    public byte[] iccExchangeSimIO(int n, int n2, int n3, int n4, int n5, int n6, String string2) {
        return InvokeDynamicSupport.bootstrap("iccExchangeSimIO", $$robo$$android_telephony_TelephonyManager$iccExchangeSimIO(int int int int int int java.lang.String ), 0, this, n, n2, n3, n4, n5, n6, string2);
    }

    public String sendEnvelopeWithStatus(String string2) {
        return InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$android_telephony_TelephonyManager$sendEnvelopeWithStatus(java.lang.String ), 0, this, string2);
    }

    public String sendEnvelopeWithStatus(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("sendEnvelopeWithStatus", $$robo$$android_telephony_TelephonyManager$sendEnvelopeWithStatus(int java.lang.String ), 0, this, n, string2);
    }

    public String nvReadItem(int n) {
        return InvokeDynamicSupport.bootstrap("nvReadItem", $$robo$$android_telephony_TelephonyManager$nvReadItem(int ), 0, this, n);
    }

    public boolean nvWriteItem(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("nvWriteItem", $$robo$$android_telephony_TelephonyManager$nvWriteItem(int java.lang.String ), 0, this, n, string2);
    }

    public boolean nvWriteCdmaPrl(byte[] byArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("nvWriteCdmaPrl", $$robo$$android_telephony_TelephonyManager$nvWriteCdmaPrl(byte[] ), 0, this, byArray);
    }

    public boolean nvResetConfig(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("nvResetConfig", $$robo$$android_telephony_TelephonyManager$nvResetConfig(int ), 0, this, n);
    }

    private int getSubId() {
        return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$android_telephony_TelephonyManager$getSubId(), 0, this);
    }

    private int getSubId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getSubId", $$robo$$android_telephony_TelephonyManager$getSubId(int ), 0, this, n);
    }

    private int getPhoneId() {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$android_telephony_TelephonyManager$getPhoneId(), 0, this);
    }

    private int getPhoneId(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPhoneId", $$robo$$android_telephony_TelephonyManager$getPhoneId(int ), 0, this, n);
    }

    public int getSlotIndex() {
        return (int)InvokeDynamicSupport.bootstrap("getSlotIndex", $$robo$$android_telephony_TelephonyManager$getSlotIndex(), 0, this);
    }

    public static void setTelephonyProperty(int n, String string2, String string3) {
        InvokeDynamicSupport.bootstrapStatic("setTelephonyProperty", $$robo$$android_telephony_TelephonyManager$setTelephonyProperty(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    public static int getIntAtIndex(ContentResolver contentResolver, String string2, int n) throws Settings.SettingNotFoundException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntAtIndex", $$robo$$android_telephony_TelephonyManager$getIntAtIndex(android.content.ContentResolver java.lang.String int ), 0, (ContentResolver)contentResolver, (String)string2, (int)n);
    }

    public static boolean putIntAtIndex(ContentResolver contentResolver, String string2, int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("putIntAtIndex", $$robo$$android_telephony_TelephonyManager$putIntAtIndex(android.content.ContentResolver java.lang.String int int ), 0, (ContentResolver)contentResolver, (String)string2, (int)n, (int)n2);
    }

    public static String getTelephonyProperty(int n, String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("getTelephonyProperty", $$robo$$android_telephony_TelephonyManager$getTelephonyProperty(int java.lang.String java.lang.String ), 0, (int)n, (String)string2, (String)string3);
    }

    public int getSimCount() {
        return (int)InvokeDynamicSupport.bootstrap("getSimCount", $$robo$$android_telephony_TelephonyManager$getSimCount(), 0, this);
    }

    public String getIsimIst() {
        return InvokeDynamicSupport.bootstrap("getIsimIst", $$robo$$android_telephony_TelephonyManager$getIsimIst(), 0, this);
    }

    public String[] getIsimPcscf() {
        return InvokeDynamicSupport.bootstrap("getIsimPcscf", $$robo$$android_telephony_TelephonyManager$getIsimPcscf(), 0, this);
    }

    public String getIsimChallengeResponse(String string2) {
        return InvokeDynamicSupport.bootstrap("getIsimChallengeResponse", $$robo$$android_telephony_TelephonyManager$getIsimChallengeResponse(java.lang.String ), 0, this, string2);
    }

    public String getIccAuthentication(int n, int n2, String string2) {
        return InvokeDynamicSupport.bootstrap("getIccAuthentication", $$robo$$android_telephony_TelephonyManager$getIccAuthentication(int int java.lang.String ), 0, this, n, n2, string2);
    }

    public String getIccAuthentication(int n, int n2, int n3, String string2) {
        return InvokeDynamicSupport.bootstrap("getIccAuthentication", $$robo$$android_telephony_TelephonyManager$getIccAuthentication(int int int java.lang.String ), 0, this, n, n2, n3, string2);
    }

    public String[] getForbiddenPlmns() {
        return InvokeDynamicSupport.bootstrap("getForbiddenPlmns", $$robo$$android_telephony_TelephonyManager$getForbiddenPlmns(), 0, this);
    }

    public String[] getForbiddenPlmns(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getForbiddenPlmns", $$robo$$android_telephony_TelephonyManager$getForbiddenPlmns(int int ), 0, this, n, n2);
    }

    public String[] getPcscfAddress(String string2) {
        return InvokeDynamicSupport.bootstrap("getPcscfAddress", $$robo$$android_telephony_TelephonyManager$getPcscfAddress(java.lang.String ), 0, this, string2);
    }

    public IImsServiceController getImsServiceControllerAndListen(int n, int n2, IImsServiceFeatureListener iImsServiceFeatureListener) {
        return InvokeDynamicSupport.bootstrap("getImsServiceControllerAndListen", $$robo$$android_telephony_TelephonyManager$getImsServiceControllerAndListen(int int com.android.ims.internal.IImsServiceFeatureListener ), 0, this, n, n2, iImsServiceFeatureListener);
    }

    public void setImsRegistrationState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setImsRegistrationState", $$robo$$android_telephony_TelephonyManager$setImsRegistrationState(boolean ), 0, this, bl);
    }

    public int getPreferredNetworkType(int n) {
        return (int)InvokeDynamicSupport.bootstrap("getPreferredNetworkType", $$robo$$android_telephony_TelephonyManager$getPreferredNetworkType(int ), 0, this, n);
    }

    public void setNetworkSelectionModeAutomatic(int n) {
        InvokeDynamicSupport.bootstrap("setNetworkSelectionModeAutomatic", $$robo$$android_telephony_TelephonyManager$setNetworkSelectionModeAutomatic(int ), 0, this, n);
    }

    public CellNetworkScanResult getCellNetworkScanResults(int n) {
        return InvokeDynamicSupport.bootstrap("getCellNetworkScanResults", $$robo$$android_telephony_TelephonyManager$getCellNetworkScanResults(int ), 0, this, n);
    }

    public boolean setNetworkSelectionModeManual(int n, OperatorInfo operatorInfo, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setNetworkSelectionModeManual", $$robo$$android_telephony_TelephonyManager$setNetworkSelectionModeManual(int com.android.internal.telephony.OperatorInfo boolean ), 0, this, n, operatorInfo, bl);
    }

    public boolean setPreferredNetworkType(int n, int n2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredNetworkType", $$robo$$android_telephony_TelephonyManager$setPreferredNetworkType(int int ), 0, this, n, n2);
    }

    public boolean setPreferredNetworkTypeToGlobal() {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredNetworkTypeToGlobal", $$robo$$android_telephony_TelephonyManager$setPreferredNetworkTypeToGlobal(), 0, this);
    }

    public boolean setPreferredNetworkTypeToGlobal(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("setPreferredNetworkTypeToGlobal", $$robo$$android_telephony_TelephonyManager$setPreferredNetworkTypeToGlobal(int ), 0, this, n);
    }

    public int getTetherApnRequired() {
        return (int)InvokeDynamicSupport.bootstrap("getTetherApnRequired", $$robo$$android_telephony_TelephonyManager$getTetherApnRequired(), 0, this);
    }

    public boolean hasCarrierPrivileges() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPrivileges", $$robo$$android_telephony_TelephonyManager$hasCarrierPrivileges(), 0, this);
    }

    public boolean hasCarrierPrivileges(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCarrierPrivileges", $$robo$$android_telephony_TelephonyManager$hasCarrierPrivileges(int ), 0, this, n);
    }

    public boolean setOperatorBrandOverride(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$android_telephony_TelephonyManager$setOperatorBrandOverride(java.lang.String ), 0, this, string2);
    }

    public boolean setOperatorBrandOverride(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setOperatorBrandOverride", $$robo$$android_telephony_TelephonyManager$setOperatorBrandOverride(int java.lang.String ), 0, this, n, string2);
    }

    public boolean setRoamingOverride(List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRoamingOverride", $$robo$$android_telephony_TelephonyManager$setRoamingOverride(java.util.List<java.lang.String> java.util.List<java.lang.String> java.util.List<java.lang.String> java.util.List<java.lang.String> ), 0, this, list, list2, list3, list4);
    }

    public boolean setRoamingOverride(int n, List<String> list, List<String> list2, List<String> list3, List<String> list4) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRoamingOverride", $$robo$$android_telephony_TelephonyManager$setRoamingOverride(int java.util.List<java.lang.String> java.util.List<java.lang.String> java.util.List<java.lang.String> java.util.List<java.lang.String> ), 0, this, n, list, list2, list3, list4);
    }

    public String getCdmaMdn() {
        return InvokeDynamicSupport.bootstrap("getCdmaMdn", $$robo$$android_telephony_TelephonyManager$getCdmaMdn(), 0, this);
    }

    public String getCdmaMdn(int n) {
        return InvokeDynamicSupport.bootstrap("getCdmaMdn", $$robo$$android_telephony_TelephonyManager$getCdmaMdn(int ), 0, this, n);
    }

    public String getCdmaMin() {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$android_telephony_TelephonyManager$getCdmaMin(), 0, this);
    }

    public String getCdmaMin(int n) {
        return InvokeDynamicSupport.bootstrap("getCdmaMin", $$robo$$android_telephony_TelephonyManager$getCdmaMin(int ), 0, this, n);
    }

    public int checkCarrierPrivilegesForPackage(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkCarrierPrivilegesForPackage", $$robo$$android_telephony_TelephonyManager$checkCarrierPrivilegesForPackage(java.lang.String ), 0, this, string2);
    }

    public int checkCarrierPrivilegesForPackageAnyPhone(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("checkCarrierPrivilegesForPackageAnyPhone", $$robo$$android_telephony_TelephonyManager$checkCarrierPrivilegesForPackageAnyPhone(java.lang.String ), 0, this, string2);
    }

    public List<String> getCarrierPackageNamesForIntent(Intent intent) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntent", $$robo$$android_telephony_TelephonyManager$getCarrierPackageNamesForIntent(android.content.Intent ), 0, this, intent);
    }

    public List<String> getCarrierPackageNamesForIntentAndPhone(Intent intent, int n) {
        return InvokeDynamicSupport.bootstrap("getCarrierPackageNamesForIntentAndPhone", $$robo$$android_telephony_TelephonyManager$getCarrierPackageNamesForIntentAndPhone(android.content.Intent int ), 0, this, intent, n);
    }

    public List<String> getPackagesWithCarrierPrivileges() {
        return InvokeDynamicSupport.bootstrap("getPackagesWithCarrierPrivileges", $$robo$$android_telephony_TelephonyManager$getPackagesWithCarrierPrivileges(), 0, this);
    }

    public void dial(String string2) {
        InvokeDynamicSupport.bootstrap("dial", $$robo$$android_telephony_TelephonyManager$dial(java.lang.String ), 0, this, string2);
    }

    public void call(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("call", $$robo$$android_telephony_TelephonyManager$call(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public boolean endCall() {
        return (boolean)InvokeDynamicSupport.bootstrap("endCall", $$robo$$android_telephony_TelephonyManager$endCall(), 0, this);
    }

    public void answerRingingCall() {
        InvokeDynamicSupport.bootstrap("answerRingingCall", $$robo$$android_telephony_TelephonyManager$answerRingingCall(), 0, this);
    }

    public void silenceRinger() {
        InvokeDynamicSupport.bootstrap("silenceRinger", $$robo$$android_telephony_TelephonyManager$silenceRinger(), 0, this);
    }

    public boolean isOffhook() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOffhook", $$robo$$android_telephony_TelephonyManager$isOffhook(), 0, this);
    }

    public boolean isRinging() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRinging", $$robo$$android_telephony_TelephonyManager$isRinging(), 0, this);
    }

    public boolean isIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdle", $$robo$$android_telephony_TelephonyManager$isIdle(), 0, this);
    }

    public boolean isRadioOn() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRadioOn", $$robo$$android_telephony_TelephonyManager$isRadioOn(), 0, this);
    }

    public boolean supplyPin(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("supplyPin", $$robo$$android_telephony_TelephonyManager$supplyPin(java.lang.String ), 0, this, string2);
    }

    public boolean supplyPuk(String string2, String string3) {
        return (boolean)InvokeDynamicSupport.bootstrap("supplyPuk", $$robo$$android_telephony_TelephonyManager$supplyPuk(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int[] supplyPinReportResult(String string2) {
        return InvokeDynamicSupport.bootstrap("supplyPinReportResult", $$robo$$android_telephony_TelephonyManager$supplyPinReportResult(java.lang.String ), 0, this, string2);
    }

    public int[] supplyPukReportResult(String string2, String string3) {
        return InvokeDynamicSupport.bootstrap("supplyPukReportResult", $$robo$$android_telephony_TelephonyManager$supplyPukReportResult(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void sendUssdRequest(String string2, UssdResponseCallback ussdResponseCallback, Handler handler) {
        InvokeDynamicSupport.bootstrap("sendUssdRequest", $$robo$$android_telephony_TelephonyManager$sendUssdRequest(java.lang.String android.telephony.TelephonyManager$UssdResponseCallback android.os.Handler ), 0, this, string2, ussdResponseCallback, handler);
    }

    public boolean isConcurrentVoiceAndDataSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConcurrentVoiceAndDataSupported", $$robo$$android_telephony_TelephonyManager$isConcurrentVoiceAndDataSupported(), 0, this);
    }

    public boolean handlePinMmi(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmi", $$robo$$android_telephony_TelephonyManager$handlePinMmi(java.lang.String ), 0, this, string2);
    }

    public boolean handlePinMmiForSubscriber(int n, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("handlePinMmiForSubscriber", $$robo$$android_telephony_TelephonyManager$handlePinMmiForSubscriber(int java.lang.String ), 0, this, n, string2);
    }

    public void toggleRadioOnOff() {
        InvokeDynamicSupport.bootstrap("toggleRadioOnOff", $$robo$$android_telephony_TelephonyManager$toggleRadioOnOff(), 0, this);
    }

    public boolean setRadio(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRadio", $$robo$$android_telephony_TelephonyManager$setRadio(boolean ), 0, this, bl);
    }

    public boolean setRadioPower(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("setRadioPower", $$robo$$android_telephony_TelephonyManager$setRadioPower(boolean ), 0, this, bl);
    }

    public void updateServiceLocation() {
        InvokeDynamicSupport.bootstrap("updateServiceLocation", $$robo$$android_telephony_TelephonyManager$updateServiceLocation(), 0, this);
    }

    public boolean enableDataConnectivity() {
        return (boolean)InvokeDynamicSupport.bootstrap("enableDataConnectivity", $$robo$$android_telephony_TelephonyManager$enableDataConnectivity(), 0, this);
    }

    public boolean disableDataConnectivity() {
        return (boolean)InvokeDynamicSupport.bootstrap("disableDataConnectivity", $$robo$$android_telephony_TelephonyManager$disableDataConnectivity(), 0, this);
    }

    public boolean isDataConnectivityPossible() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataConnectivityPossible", $$robo$$android_telephony_TelephonyManager$isDataConnectivityPossible(), 0, this);
    }

    public boolean needsOtaServiceProvisioning() {
        return (boolean)InvokeDynamicSupport.bootstrap("needsOtaServiceProvisioning", $$robo$$android_telephony_TelephonyManager$needsOtaServiceProvisioning(), 0, this);
    }

    public void setDataEnabled(boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$android_telephony_TelephonyManager$setDataEnabled(boolean ), 0, this, bl);
    }

    public void setDataEnabled(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setDataEnabled", $$robo$$android_telephony_TelephonyManager$setDataEnabled(int boolean ), 0, this, n, bl);
    }

    @Deprecated
    public boolean getDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$android_telephony_TelephonyManager$getDataEnabled(), 0, this);
    }

    public boolean isDataEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDataEnabled", $$robo$$android_telephony_TelephonyManager$isDataEnabled(), 0, this);
    }

    public boolean getDataEnabled(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getDataEnabled", $$robo$$android_telephony_TelephonyManager$getDataEnabled(int ), 0, this, n);
    }

    @Deprecated
    public int invokeOemRilRequestRaw(byte[] byArray, byte[] byArray2) {
        return (int)InvokeDynamicSupport.bootstrap("invokeOemRilRequestRaw", $$robo$$android_telephony_TelephonyManager$invokeOemRilRequestRaw(byte[] byte[] ), 0, this, byArray, byArray2);
    }

    public void enableVideoCalling(boolean bl) {
        InvokeDynamicSupport.bootstrap("enableVideoCalling", $$robo$$android_telephony_TelephonyManager$enableVideoCalling(boolean ), 0, this, bl);
    }

    public boolean isVideoCallingEnabled() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoCallingEnabled", $$robo$$android_telephony_TelephonyManager$isVideoCallingEnabled(), 0, this);
    }

    public boolean canChangeDtmfToneLength() {
        return (boolean)InvokeDynamicSupport.bootstrap("canChangeDtmfToneLength", $$robo$$android_telephony_TelephonyManager$canChangeDtmfToneLength(), 0, this);
    }

    public boolean isWorldPhone() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWorldPhone", $$robo$$android_telephony_TelephonyManager$isWorldPhone(), 0, this);
    }

    public boolean isTtyModeSupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isTtyModeSupported", $$robo$$android_telephony_TelephonyManager$isTtyModeSupported(), 0, this);
    }

    public boolean isHearingAidCompatibilitySupported() {
        return (boolean)InvokeDynamicSupport.bootstrap("isHearingAidCompatibilitySupported", $$robo$$android_telephony_TelephonyManager$isHearingAidCompatibilitySupported(), 0, this);
    }

    public static int getIntWithSubId(ContentResolver contentResolver, String string2, int n) throws Settings.SettingNotFoundException {
        return (int)InvokeDynamicSupport.bootstrapStatic("getIntWithSubId", $$robo$$android_telephony_TelephonyManager$getIntWithSubId(android.content.ContentResolver java.lang.String int ), 0, (ContentResolver)contentResolver, (String)string2, (int)n);
    }

    public boolean isImsRegistered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isImsRegistered", $$robo$$android_telephony_TelephonyManager$isImsRegistered(), 0, this);
    }

    public boolean isVolteAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVolteAvailable", $$robo$$android_telephony_TelephonyManager$isVolteAvailable(), 0, this);
    }

    public boolean isVideoTelephonyAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isVideoTelephonyAvailable", $$robo$$android_telephony_TelephonyManager$isVideoTelephonyAvailable(), 0, this);
    }

    public boolean isWifiCallingAvailable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWifiCallingAvailable", $$robo$$android_telephony_TelephonyManager$isWifiCallingAvailable(), 0, this);
    }

    public void setSimOperatorNumeric(String string2) {
        InvokeDynamicSupport.bootstrap("setSimOperatorNumeric", $$robo$$android_telephony_TelephonyManager$setSimOperatorNumeric(java.lang.String ), 0, this, string2);
    }

    public void setSimOperatorNumericForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setSimOperatorNumericForPhone", $$robo$$android_telephony_TelephonyManager$setSimOperatorNumericForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setSimOperatorName(String string2) {
        InvokeDynamicSupport.bootstrap("setSimOperatorName", $$robo$$android_telephony_TelephonyManager$setSimOperatorName(java.lang.String ), 0, this, string2);
    }

    public void setSimOperatorNameForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setSimOperatorNameForPhone", $$robo$$android_telephony_TelephonyManager$setSimOperatorNameForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setSimCountryIso(String string2) {
        InvokeDynamicSupport.bootstrap("setSimCountryIso", $$robo$$android_telephony_TelephonyManager$setSimCountryIso(java.lang.String ), 0, this, string2);
    }

    public void setSimCountryIsoForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setSimCountryIsoForPhone", $$robo$$android_telephony_TelephonyManager$setSimCountryIsoForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setSimState(String string2) {
        InvokeDynamicSupport.bootstrap("setSimState", $$robo$$android_telephony_TelephonyManager$setSimState(java.lang.String ), 0, this, string2);
    }

    public void setSimStateForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setSimStateForPhone", $$robo$$android_telephony_TelephonyManager$setSimStateForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setSimPowerState(boolean bl) {
        InvokeDynamicSupport.bootstrap("setSimPowerState", $$robo$$android_telephony_TelephonyManager$setSimPowerState(boolean ), 0, this, bl);
    }

    public void setSimPowerStateForSlot(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setSimPowerStateForSlot", $$robo$$android_telephony_TelephonyManager$setSimPowerStateForSlot(int boolean ), 0, this, n, bl);
    }

    public void setBasebandVersion(String string2) {
        InvokeDynamicSupport.bootstrap("setBasebandVersion", $$robo$$android_telephony_TelephonyManager$setBasebandVersion(java.lang.String ), 0, this, string2);
    }

    public void setBasebandVersionForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setBasebandVersionForPhone", $$robo$$android_telephony_TelephonyManager$setBasebandVersionForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setPhoneType(int n) {
        InvokeDynamicSupport.bootstrap("setPhoneType", $$robo$$android_telephony_TelephonyManager$setPhoneType(int ), 0, this, n);
    }

    public void setPhoneType(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setPhoneType", $$robo$$android_telephony_TelephonyManager$setPhoneType(int int ), 0, this, n, n2);
    }

    public String getOtaSpNumberSchema(String string2) {
        return InvokeDynamicSupport.bootstrap("getOtaSpNumberSchema", $$robo$$android_telephony_TelephonyManager$getOtaSpNumberSchema(java.lang.String ), 0, this, string2);
    }

    public String getOtaSpNumberSchemaForPhone(int n, String string2) {
        return InvokeDynamicSupport.bootstrap("getOtaSpNumberSchemaForPhone", $$robo$$android_telephony_TelephonyManager$getOtaSpNumberSchemaForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public boolean getSmsReceiveCapable(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSmsReceiveCapable", $$robo$$android_telephony_TelephonyManager$getSmsReceiveCapable(boolean ), 0, this, bl);
    }

    public boolean getSmsReceiveCapableForPhone(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSmsReceiveCapableForPhone", $$robo$$android_telephony_TelephonyManager$getSmsReceiveCapableForPhone(int boolean ), 0, this, n, bl);
    }

    public boolean getSmsSendCapable(boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSmsSendCapable", $$robo$$android_telephony_TelephonyManager$getSmsSendCapable(boolean ), 0, this, bl);
    }

    public boolean getSmsSendCapableForPhone(int n, boolean bl) {
        return (boolean)InvokeDynamicSupport.bootstrap("getSmsSendCapableForPhone", $$robo$$android_telephony_TelephonyManager$getSmsSendCapableForPhone(int boolean ), 0, this, n, bl);
    }

    public void setNetworkOperatorName(String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkOperatorName", $$robo$$android_telephony_TelephonyManager$setNetworkOperatorName(java.lang.String ), 0, this, string2);
    }

    public void setNetworkOperatorNameForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkOperatorNameForPhone", $$robo$$android_telephony_TelephonyManager$setNetworkOperatorNameForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setNetworkOperatorNumeric(String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkOperatorNumeric", $$robo$$android_telephony_TelephonyManager$setNetworkOperatorNumeric(java.lang.String ), 0, this, string2);
    }

    public void setNetworkOperatorNumericForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkOperatorNumericForPhone", $$robo$$android_telephony_TelephonyManager$setNetworkOperatorNumericForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setNetworkRoaming(boolean bl) {
        InvokeDynamicSupport.bootstrap("setNetworkRoaming", $$robo$$android_telephony_TelephonyManager$setNetworkRoaming(boolean ), 0, this, bl);
    }

    public void setNetworkRoamingForPhone(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("setNetworkRoamingForPhone", $$robo$$android_telephony_TelephonyManager$setNetworkRoamingForPhone(int boolean ), 0, this, n, bl);
    }

    public void setNetworkCountryIso(String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkCountryIso", $$robo$$android_telephony_TelephonyManager$setNetworkCountryIso(java.lang.String ), 0, this, string2);
    }

    public void setNetworkCountryIsoForPhone(int n, String string2) {
        InvokeDynamicSupport.bootstrap("setNetworkCountryIsoForPhone", $$robo$$android_telephony_TelephonyManager$setNetworkCountryIsoForPhone(int java.lang.String ), 0, this, n, string2);
    }

    public void setDataNetworkType(int n) {
        InvokeDynamicSupport.bootstrap("setDataNetworkType", $$robo$$android_telephony_TelephonyManager$setDataNetworkType(int ), 0, this, n);
    }

    public void setDataNetworkTypeForPhone(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setDataNetworkTypeForPhone", $$robo$$android_telephony_TelephonyManager$setDataNetworkTypeForPhone(int int ), 0, this, n, n2);
    }

    public int getSubIdForPhoneAccount(PhoneAccount phoneAccount) {
        return (int)InvokeDynamicSupport.bootstrap("getSubIdForPhoneAccount", $$robo$$android_telephony_TelephonyManager$getSubIdForPhoneAccount(android.telecom.PhoneAccount ), 0, this, phoneAccount);
    }

    private int getSubIdForPhoneAccountHandle(PhoneAccountHandle phoneAccountHandle) {
        return (int)InvokeDynamicSupport.bootstrap("getSubIdForPhoneAccountHandle", $$robo$$android_telephony_TelephonyManager$getSubIdForPhoneAccountHandle(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void factoryReset(int n) {
        InvokeDynamicSupport.bootstrap("factoryReset", $$robo$$android_telephony_TelephonyManager$factoryReset(int ), 0, this, n);
    }

    public String getLocaleFromDefaultSim() {
        return InvokeDynamicSupport.bootstrap("getLocaleFromDefaultSim", $$robo$$android_telephony_TelephonyManager$getLocaleFromDefaultSim(), 0, this);
    }

    public void requestModemActivityInfo(ResultReceiver resultReceiver) {
        InvokeDynamicSupport.bootstrap("requestModemActivityInfo", $$robo$$android_telephony_TelephonyManager$requestModemActivityInfo(android.os.ResultReceiver ), 0, this, resultReceiver);
    }

    public ServiceState getServiceState() {
        return InvokeDynamicSupport.bootstrap("getServiceState", $$robo$$android_telephony_TelephonyManager$getServiceState(), 0, this);
    }

    public ServiceState getServiceStateForSubscriber(int n) {
        return InvokeDynamicSupport.bootstrap("getServiceStateForSubscriber", $$robo$$android_telephony_TelephonyManager$getServiceStateForSubscriber(int ), 0, this, n);
    }

    public Uri getVoicemailRingtoneUri(PhoneAccountHandle phoneAccountHandle) {
        return InvokeDynamicSupport.bootstrap("getVoicemailRingtoneUri", $$robo$$android_telephony_TelephonyManager$getVoicemailRingtoneUri(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void setVoicemailRingtoneUri(PhoneAccountHandle phoneAccountHandle, Uri uri) {
        InvokeDynamicSupport.bootstrap("setVoicemailRingtoneUri", $$robo$$android_telephony_TelephonyManager$setVoicemailRingtoneUri(android.telecom.PhoneAccountHandle android.net.Uri ), 0, this, phoneAccountHandle, uri);
    }

    public boolean isVoicemailVibrationEnabled(PhoneAccountHandle phoneAccountHandle) {
        return (boolean)InvokeDynamicSupport.bootstrap("isVoicemailVibrationEnabled", $$robo$$android_telephony_TelephonyManager$isVoicemailVibrationEnabled(android.telecom.PhoneAccountHandle ), 0, this, phoneAccountHandle);
    }

    public void setVoicemailVibrationEnabled(PhoneAccountHandle phoneAccountHandle, boolean bl) {
        InvokeDynamicSupport.bootstrap("setVoicemailVibrationEnabled", $$robo$$android_telephony_TelephonyManager$setVoicemailVibrationEnabled(android.telecom.PhoneAccountHandle boolean ), 0, this, phoneAccountHandle, bl);
    }

    public String getAidForAppType(int n) {
        return InvokeDynamicSupport.bootstrap("getAidForAppType", $$robo$$android_telephony_TelephonyManager$getAidForAppType(int ), 0, this, n);
    }

    public String getAidForAppType(int n, int n2) {
        return InvokeDynamicSupport.bootstrap("getAidForAppType", $$robo$$android_telephony_TelephonyManager$getAidForAppType(int int ), 0, this, n, n2);
    }

    public String getEsn() {
        return InvokeDynamicSupport.bootstrap("getEsn", $$robo$$android_telephony_TelephonyManager$getEsn(), 0, this);
    }

    public String getEsn(int n) {
        return InvokeDynamicSupport.bootstrap("getEsn", $$robo$$android_telephony_TelephonyManager$getEsn(int ), 0, this, n);
    }

    public String getCdmaPrlVersion() {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$android_telephony_TelephonyManager$getCdmaPrlVersion(), 0, this);
    }

    public String getCdmaPrlVersion(int n) {
        return InvokeDynamicSupport.bootstrap("getCdmaPrlVersion", $$robo$$android_telephony_TelephonyManager$getCdmaPrlVersion(int ), 0, this, n);
    }

    public List<TelephonyHistogram> getTelephonyHistograms() {
        return InvokeDynamicSupport.bootstrap("getTelephonyHistograms", $$robo$$android_telephony_TelephonyManager$getTelephonyHistograms(), 0, this);
    }

    public int setAllowedCarriers(int n, List<CarrierIdentifier> list) {
        return (int)InvokeDynamicSupport.bootstrap("setAllowedCarriers", $$robo$$android_telephony_TelephonyManager$setAllowedCarriers(int java.util.List<android.service.carrier.CarrierIdentifier> ), 0, this, n, list);
    }

    public List<CarrierIdentifier> getAllowedCarriers(int n) {
        return InvokeDynamicSupport.bootstrap("getAllowedCarriers", $$robo$$android_telephony_TelephonyManager$getAllowedCarriers(int ), 0, this, n);
    }

    public void carrierActionSetMeteredApnsEnabled(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionSetMeteredApnsEnabled", $$robo$$android_telephony_TelephonyManager$carrierActionSetMeteredApnsEnabled(int boolean ), 0, this, n, bl);
    }

    public void carrierActionSetRadioEnabled(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("carrierActionSetRadioEnabled", $$robo$$android_telephony_TelephonyManager$carrierActionSetRadioEnabled(int boolean ), 0, this, n, bl);
    }

    public long getVtDataUsage() {
        return (long)InvokeDynamicSupport.bootstrap("getVtDataUsage", $$robo$$android_telephony_TelephonyManager$getVtDataUsage(), 0, this);
    }

    public void setPolicyDataEnabled(boolean bl, int n) {
        InvokeDynamicSupport.bootstrap("setPolicyDataEnabled", $$robo$$android_telephony_TelephonyManager$setPolicyDataEnabled(boolean int ), 0, this, bl, n);
    }

    public List<ClientRequestStats> getClientRequestStats(int n) {
        return InvokeDynamicSupport.bootstrap("getClientRequestStats", $$robo$$android_telephony_TelephonyManager$getClientRequestStats(int ), 0, this, n);
    }

    public boolean getEmergencyCallbackMode() {
        return (boolean)InvokeDynamicSupport.bootstrap("getEmergencyCallbackMode", $$robo$$android_telephony_TelephonyManager$getEmergencyCallbackMode(), 0, this);
    }

    public boolean getEmergencyCallbackMode(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("getEmergencyCallbackMode", $$robo$$android_telephony_TelephonyManager$getEmergencyCallbackMode(int ), 0, this, n);
    }

    static {
        RobolectricInternals.classInitializing(TelephonyManager.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TelephonyManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class UssdResponseCallback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telephony_TelephonyManager_UssdResponseCallback$__constructor__() {
        }

        private final void $$robo$$android_telephony_TelephonyManager_UssdResponseCallback$onReceiveUssdResponse(TelephonyManager telephonyManager, String request, CharSequence response) {
        }

        private final void $$robo$$android_telephony_TelephonyManager_UssdResponseCallback$onReceiveUssdResponseFailed(TelephonyManager telephonyManager, String request, int failureCode) {
        }

        private void __constructor__() {
            this.$$robo$$android_telephony_TelephonyManager_UssdResponseCallback$__constructor__();
        }

        public UssdResponseCallback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager_UssdResponseCallback$__constructor__(), 0, this);
        }

        public void onReceiveUssdResponse(TelephonyManager telephonyManager, String string2, CharSequence charSequence) {
            InvokeDynamicSupport.bootstrap("onReceiveUssdResponse", $$robo$$android_telephony_TelephonyManager_UssdResponseCallback$onReceiveUssdResponse(android.telephony.TelephonyManager java.lang.String java.lang.CharSequence ), 0, this, telephonyManager, string2, charSequence);
        }

        public void onReceiveUssdResponseFailed(TelephonyManager telephonyManager, String string2, int n) {
            InvokeDynamicSupport.bootstrap("onReceiveUssdResponseFailed", $$robo$$android_telephony_TelephonyManager_UssdResponseCallback$onReceiveUssdResponseFailed(android.telephony.TelephonyManager java.lang.String int ), 0, this, telephonyManager, string2, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UssdResponseCallback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L, 2L})
    public static @interface Feature {
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class MultiSimVariants
    extends Enum<MultiSimVariants> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ MultiSimVariants DSDS;
        public static /* enum */ MultiSimVariants DSDA;
        public static /* enum */ MultiSimVariants TSTS;
        public static /* enum */ MultiSimVariants UNKNOWN;
        private static /* synthetic */ MultiSimVariants[] $VALUES;

        private static final MultiSimVariants[] $$robo$$android_telephony_TelephonyManager_MultiSimVariants$values() {
            return (MultiSimVariants[])$VALUES.clone();
        }

        private static final MultiSimVariants $$robo$$android_telephony_TelephonyManager_MultiSimVariants$valueOf(String name) {
            return Enum.valueOf(MultiSimVariants.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_telephony_TelephonyManager_MultiSimVariants$__constructor__(String string2, int n) {
        }

        static void __staticInitializer__() {
            DSDS = new MultiSimVariants();
            DSDA = new MultiSimVariants();
            TSTS = new MultiSimVariants();
            UNKNOWN = new MultiSimVariants();
            $VALUES = new MultiSimVariants[]{DSDS, DSDA, TSTS, UNKNOWN};
        }

        public static MultiSimVariants[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_telephony_TelephonyManager_MultiSimVariants$values(), 0);
        }

        public static MultiSimVariants valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_telephony_TelephonyManager_MultiSimVariants$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n) {
            this.$$robo$$android_telephony_TelephonyManager_MultiSimVariants$__constructor__(string2, n);
        }

        private MultiSimVariants() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_TelephonyManager_MultiSimVariants$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        static {
            RobolectricInternals.classInitializing(MultiSimVariants.class);
        }

        public /* synthetic */ MultiSimVariants() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MultiSimVariants)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface WifiCallingChoices
    extends InstrumentedInterface {
        public static final int ALWAYS_USE = 0;
        public static final int ASK_EVERY_TIME = 1;
        public static final int NEVER_USE = 2;
    }
}

