/*
 * Decompiled with CFR 0.152.
 */
package android.telephony;

import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.CellInfoCdma;
import android.telephony.CellInfoGsm;
import android.telephony.CellInfoLte;
import android.telephony.CellInfoWcdma;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class CellInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    protected static int TYPE_GSM = 1;
    protected static int TYPE_CDMA = 2;
    protected static int TYPE_LTE = 3;
    protected static int TYPE_WCDMA = 4;
    public static int TIMESTAMP_TYPE_UNKNOWN = 0;
    public static int TIMESTAMP_TYPE_ANTENNA = 1;
    public static int TIMESTAMP_TYPE_MODEM = 2;
    public static int TIMESTAMP_TYPE_OEM_RIL = 3;
    public static int TIMESTAMP_TYPE_JAVA_RIL = 4;
    private boolean mRegistered;
    private long mTimeStamp;
    private int mTimeStampType;
    public static Parcelable.Creator<CellInfo> CREATOR;

    private void $$robo$$android_telephony_CellInfo$__constructor__() {
        this.mRegistered = false;
        this.mTimeStampType = 0;
        this.mTimeStamp = Long.MAX_VALUE;
    }

    private void $$robo$$android_telephony_CellInfo$__constructor__(CellInfo ci) {
        this.mRegistered = ci.mRegistered;
        this.mTimeStampType = ci.mTimeStampType;
        this.mTimeStamp = ci.mTimeStamp;
    }

    private final boolean $$robo$$android_telephony_CellInfo$isRegistered() {
        return this.mRegistered;
    }

    private final void $$robo$$android_telephony_CellInfo$setRegistered(boolean registered) {
        this.mRegistered = registered;
    }

    private final long $$robo$$android_telephony_CellInfo$getTimeStamp() {
        return this.mTimeStamp;
    }

    private final void $$robo$$android_telephony_CellInfo$setTimeStamp(long timeStamp) {
        this.mTimeStamp = timeStamp;
    }

    private final int $$robo$$android_telephony_CellInfo$getTimeStampType() {
        return this.mTimeStampType;
    }

    private final void $$robo$$android_telephony_CellInfo$setTimeStampType(int timeStampType) {
        this.mTimeStampType = timeStampType < 0 || timeStampType > 4 ? 0 : timeStampType;
    }

    private final int $$robo$$android_telephony_CellInfo$hashCode() {
        int primeNum = 31;
        return (this.mRegistered ? 0 : 1) * primeNum + (int)(this.mTimeStamp / 1000L) * primeNum + this.mTimeStampType * primeNum;
    }

    private final boolean $$robo$$android_telephony_CellInfo$equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this == other) {
            return true;
        }
        try {
            CellInfo o = (CellInfo)other;
            return this.mRegistered == o.mRegistered && this.mTimeStamp == o.mTimeStamp && this.mTimeStampType == o.mTimeStampType;
        }
        catch (ClassCastException e) {
            return false;
        }
    }

    private static final String $$robo$$android_telephony_CellInfo$timeStampTypeToString(int type) {
        switch (type) {
            case 1: {
                return "antenna";
            }
            case 2: {
                return "modem";
            }
            case 3: {
                return "oem_ril";
            }
            case 4: {
                return "java_ril";
            }
        }
        return "unknown";
    }

    private final String $$robo$$android_telephony_CellInfo$toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("mRegistered=").append(this.mRegistered ? "YES" : "NO");
        String timeStampType = CellInfo.timeStampTypeToString(this.mTimeStampType);
        sb.append(" mTimeStampType=").append(timeStampType);
        sb.append(" mTimeStamp=").append(this.mTimeStamp).append("ns");
        return sb.toString();
    }

    private final int $$robo$$android_telephony_CellInfo$describeContents() {
        return 0;
    }

    @Override
    public abstract void writeToParcel(Parcel var1, int var2);

    private final void $$robo$$android_telephony_CellInfo$writeToParcel(Parcel dest, int flags, int type) {
        dest.writeInt(type);
        dest.writeInt(this.mRegistered ? 1 : 0);
        dest.writeInt(this.mTimeStampType);
        dest.writeLong(this.mTimeStamp);
    }

    private void $$robo$$android_telephony_CellInfo$__constructor__(Parcel in) {
        this.mRegistered = in.readInt() == 1;
        this.mTimeStampType = in.readInt();
        this.mTimeStamp = in.readLong();
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<CellInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_telephony_CellInfo_1$__constructor__() {
            }

            private final CellInfo $$robo$$android_telephony_CellInfo_1$createFromParcel(Parcel in) {
                int type = in.readInt();
                switch (type) {
                    case 1: {
                        return CellInfoGsm.createFromParcelBody(in);
                    }
                    case 2: {
                        return CellInfoCdma.createFromParcelBody(in);
                    }
                    case 3: {
                        return CellInfoLte.createFromParcelBody(in);
                    }
                    case 4: {
                        return CellInfoWcdma.createFromParcelBody(in);
                    }
                }
                throw new RuntimeException("Bad CellInfo Parcel");
            }

            private final CellInfo[] $$robo$$android_telephony_CellInfo_1$newArray(int size) {
                return new CellInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_telephony_CellInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_CellInfo_1$__constructor__(), 0, this);
            }

            @Override
            public CellInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_telephony_CellInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public CellInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_telephony_CellInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_telephony_CellInfo$__constructor__();
    }

    protected CellInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_CellInfo$__constructor__(), 0, this);
    }

    private void __constructor__(CellInfo cellInfo) {
        this.$$robo$$android_telephony_CellInfo$__constructor__(cellInfo);
    }

    protected CellInfo(CellInfo cellInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_CellInfo$__constructor__(android.telephony.CellInfo ), 0, this, cellInfo);
    }

    public boolean isRegistered() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRegistered", $$robo$$android_telephony_CellInfo$isRegistered(), 0, this);
    }

    public void setRegistered(boolean bl) {
        InvokeDynamicSupport.bootstrap("setRegistered", $$robo$$android_telephony_CellInfo$setRegistered(boolean ), 0, this, bl);
    }

    public long getTimeStamp() {
        return (long)InvokeDynamicSupport.bootstrap("getTimeStamp", $$robo$$android_telephony_CellInfo$getTimeStamp(), 0, this);
    }

    public void setTimeStamp(long l) {
        InvokeDynamicSupport.bootstrap("setTimeStamp", $$robo$$android_telephony_CellInfo$setTimeStamp(long ), 0, this, l);
    }

    public int getTimeStampType() {
        return (int)InvokeDynamicSupport.bootstrap("getTimeStampType", $$robo$$android_telephony_CellInfo$getTimeStampType(), 0, this);
    }

    public void setTimeStampType(int n) {
        InvokeDynamicSupport.bootstrap("setTimeStampType", $$robo$$android_telephony_CellInfo$setTimeStampType(int ), 0, this, n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telephony_CellInfo$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telephony_CellInfo$equals(java.lang.Object ), 0, this, object);
    }

    private static String timeStampTypeToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("timeStampTypeToString", $$robo$$android_telephony_CellInfo$timeStampTypeToString(int ), 0, (int)n);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telephony_CellInfo$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_telephony_CellInfo$describeContents(), 0, this);
    }

    protected void writeToParcel(Parcel parcel, int n, int n2) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_telephony_CellInfo$writeToParcel(android.os.Parcel int int ), 0, this, parcel, n, n2);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_telephony_CellInfo$__constructor__(parcel);
    }

    protected CellInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telephony_CellInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    static {
        RobolectricInternals.classInitializing(CellInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CellInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

