/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.os.Bundle;
import android.os.Handler;
import android.os.RemoteException;
import android.telecom.AudioState;
import android.telecom.CallAudioState;
import android.telecom.CallbackRecord;
import android.telecom.Connection;
import android.telecom.DisconnectCause;
import android.telecom.Log;
import android.telecom.RemoteConnection;
import com.android.internal.telecom.IConnectionService;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class RemoteConference
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private String mId;
    private IConnectionService mConnectionService;
    private Set<CallbackRecord<Callback>> mCallbackRecords;
    private List<RemoteConnection> mChildConnections;
    private List<RemoteConnection> mUnmodifiableChildConnections;
    private List<RemoteConnection> mConferenceableConnections;
    private List<RemoteConnection> mUnmodifiableConferenceableConnections;
    private int mState;
    private DisconnectCause mDisconnectCause;
    private int mConnectionCapabilities;
    private int mConnectionProperties;
    private Bundle mExtras;

    private void $$robo$$android_telecom_RemoteConference$__constructor__(String id2, IConnectionService connectionService) {
        this.mCallbackRecords = new CopyOnWriteArraySet<CallbackRecord<Callback>>();
        this.mChildConnections = new CopyOnWriteArrayList<RemoteConnection>();
        this.mUnmodifiableChildConnections = Collections.unmodifiableList(this.mChildConnections);
        this.mConferenceableConnections = new ArrayList<RemoteConnection>();
        this.mUnmodifiableConferenceableConnections = Collections.unmodifiableList(this.mConferenceableConnections);
        this.mState = 1;
        this.mId = id2;
        this.mConnectionService = connectionService;
    }

    private final String $$robo$$android_telecom_RemoteConference$getId() {
        return this.mId;
    }

    private final void $$robo$$android_telecom_RemoteConference$setDestroyed() {
        for (RemoteConnection remoteConnection : this.mChildConnections) {
            remoteConnection.setConference(null);
        }
        for (CallbackRecord callbackRecord : this.mCallbackRecords) {
            RemoteConference conference = this;
            Callback callback = (Callback)callbackRecord.getCallback();
            callbackRecord.getHandler().post(new Runnable(this, callback, conference){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConference val$conference;
                /* synthetic */ RemoteConference this$0;

                private void $$robo$$android_telecom_RemoteConference_1$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference) {
                }

                private final void $$robo$$android_telecom_RemoteConference_1$run() {
                    this.val$callback.onDestroyed(this.val$conference);
                }

                private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2) {
                    this.$$robo$$android_telecom_RemoteConference_1$__constructor__(remoteConference, callback, remoteConference2);
                }
                {
                    this.this$0 = remoteConference;
                    this.val$callback = callback;
                    this.val$conference = remoteConference2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_1$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference ), 0, this, remoteConference, callback, remoteConference2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setState(int newState) {
        if (newState != 4 && newState != 5 && newState != 6) {
            Log.w(this, "Unsupported state transition for Conference call.", Connection.stateToString(newState));
            return;
        }
        if (this.mState != newState) {
            int oldState = this.mState;
            this.mState = newState;
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                RemoteConference conference = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, conference, oldState, newState){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ int val$oldState;
                    /* synthetic */ int val$newState;
                    /* synthetic */ RemoteConference this$0;

                    private void $$robo$$android_telecom_RemoteConference_2$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference, int n, int n2) {
                    }

                    private final void $$robo$$android_telecom_RemoteConference_2$run() {
                        this.val$callback.onStateChanged(this.val$conference, this.val$oldState, this.val$newState);
                    }

                    private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2, int n, int n2) {
                        this.$$robo$$android_telecom_RemoteConference_2$__constructor__(remoteConference, callback, remoteConference2, n, n2);
                    }
                    {
                        this.this$0 = remoteConference;
                        this.val$callback = callback;
                        this.val$conference = remoteConference2;
                        this.val$oldState = n;
                        this.val$newState = n2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_2$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference int int ), 0, this, remoteConference, callback, remoteConference2, n, n2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_2$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$addConnection(RemoteConnection connection) {
        if (!this.mChildConnections.contains(connection)) {
            this.mChildConnections.add(connection);
            connection.setConference(this);
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                RemoteConference conference = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, conference, connection){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ RemoteConference this$0;

                    private void $$robo$$android_telecom_RemoteConference_3$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference, RemoteConnection remoteConnection) {
                    }

                    private final void $$robo$$android_telecom_RemoteConference_3$run() {
                        this.val$callback.onConnectionAdded(this.val$conference, this.val$connection);
                    }

                    private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2, RemoteConnection remoteConnection) {
                        this.$$robo$$android_telecom_RemoteConference_3$__constructor__(remoteConference, callback, remoteConference2, remoteConnection);
                    }
                    {
                        this.this$0 = remoteConference;
                        this.val$callback = callback;
                        this.val$conference = remoteConference2;
                        this.val$connection = remoteConnection;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_3$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference android.telecom.RemoteConnection ), 0, this, remoteConference, callback, remoteConference2, remoteConnection);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_3$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$removeConnection(RemoteConnection connection) {
        if (this.mChildConnections.contains(connection)) {
            this.mChildConnections.remove(connection);
            connection.setConference(null);
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                RemoteConference conference = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, conference, connection){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ RemoteConnection val$connection;
                    /* synthetic */ RemoteConference this$0;

                    private void $$robo$$android_telecom_RemoteConference_4$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference, RemoteConnection remoteConnection) {
                    }

                    private final void $$robo$$android_telecom_RemoteConference_4$run() {
                        this.val$callback.onConnectionRemoved(this.val$conference, this.val$connection);
                    }

                    private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2, RemoteConnection remoteConnection) {
                        this.$$robo$$android_telecom_RemoteConference_4$__constructor__(remoteConference, callback, remoteConference2, remoteConnection);
                    }
                    {
                        this.this$0 = remoteConference;
                        this.val$callback = callback;
                        this.val$conference = remoteConference2;
                        this.val$connection = remoteConnection;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_4$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference android.telecom.RemoteConnection ), 0, this, remoteConference, callback, remoteConference2, remoteConnection);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_4$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setConnectionCapabilities(int connectionCapabilities) {
        if (this.mConnectionCapabilities != connectionCapabilities) {
            this.mConnectionCapabilities = connectionCapabilities;
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                RemoteConference conference = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, conference){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ RemoteConference this$0;

                    private void $$robo$$android_telecom_RemoteConference_5$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference) {
                    }

                    private final void $$robo$$android_telecom_RemoteConference_5$run() {
                        this.val$callback.onConnectionCapabilitiesChanged(this.val$conference, this.this$0.mConnectionCapabilities);
                    }

                    private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2) {
                        this.$$robo$$android_telecom_RemoteConference_5$__constructor__(remoteConference, callback, remoteConference2);
                    }
                    {
                        this.this$0 = remoteConference;
                        this.val$callback = callback;
                        this.val$conference = remoteConference2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_5$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference ), 0, this, remoteConference, callback, remoteConference2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_5$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setConnectionProperties(int connectionProperties) {
        if (this.mConnectionProperties != connectionProperties) {
            this.mConnectionProperties = connectionProperties;
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                RemoteConference conference = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, conference){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ RemoteConference this$0;

                    private void $$robo$$android_telecom_RemoteConference_6$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference) {
                    }

                    private final void $$robo$$android_telecom_RemoteConference_6$run() {
                        this.val$callback.onConnectionPropertiesChanged(this.val$conference, this.this$0.mConnectionProperties);
                    }

                    private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2) {
                        this.$$robo$$android_telecom_RemoteConference_6$__constructor__(remoteConference, callback, remoteConference2);
                    }
                    {
                        this.this$0 = remoteConference;
                        this.val$callback = callback;
                        this.val$conference = remoteConference2;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_6$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference ), 0, this, remoteConference, callback, remoteConference2);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_6$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setConferenceableConnections(List<RemoteConnection> conferenceableConnections) {
        this.mConferenceableConnections.clear();
        this.mConferenceableConnections.addAll(conferenceableConnections);
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            RemoteConference conference = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, conference){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConference val$conference;
                /* synthetic */ RemoteConference this$0;

                private void $$robo$$android_telecom_RemoteConference_7$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference) {
                }

                private final void $$robo$$android_telecom_RemoteConference_7$run() {
                    this.val$callback.onConferenceableConnectionsChanged(this.val$conference, this.this$0.mUnmodifiableConferenceableConnections);
                }

                private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2) {
                    this.$$robo$$android_telecom_RemoteConference_7$__constructor__(remoteConference, callback, remoteConference2);
                }
                {
                    this.this$0 = remoteConference;
                    this.val$callback = callback;
                    this.val$conference = remoteConference2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_7$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference ), 0, this, remoteConference, callback, remoteConference2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_7$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$setDisconnected(DisconnectCause disconnectCause) {
        if (this.mState != 6) {
            this.mDisconnectCause = disconnectCause;
            this.setState(6);
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                RemoteConference conference = this;
                Callback callback = record.getCallback();
                record.getHandler().post(new Runnable(this, callback, conference, disconnectCause){
                    public transient /* synthetic */ Object __robo_data__;
                    /* synthetic */ Callback val$callback;
                    /* synthetic */ RemoteConference val$conference;
                    /* synthetic */ DisconnectCause val$disconnectCause;
                    /* synthetic */ RemoteConference this$0;

                    private void $$robo$$android_telecom_RemoteConference_8$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference, DisconnectCause disconnectCause) {
                    }

                    private final void $$robo$$android_telecom_RemoteConference_8$run() {
                        this.val$callback.onDisconnected(this.val$conference, this.val$disconnectCause);
                    }

                    private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2, DisconnectCause disconnectCause) {
                        this.$$robo$$android_telecom_RemoteConference_8$__constructor__(remoteConference, callback, remoteConference2, disconnectCause);
                    }
                    {
                        this.this$0 = remoteConference;
                        this.val$callback = callback;
                        this.val$conference = remoteConference2;
                        this.val$disconnectCause = disconnectCause;
                        this.$$robo$init();
                        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_8$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference android.telecom.DisconnectCause ), 0, this, remoteConference, callback, remoteConference2, disconnectCause);
                    }

                    @Override
                    public void run() {
                        InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_8$run(), 0, this);
                    }
                    {
                        this.$$robo$init();
                    }

                    protected /* synthetic */ void $$robo$init() {
                        if (this.__robo_data__ == null) {
                            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                        }
                    }

                    public /* synthetic */ Object $$robo$getData() {
                        return this.__robo_data__;
                    }
                });
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$putExtras(Bundle extras) {
        if (extras == null) {
            return;
        }
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putAll(extras);
        this.notifyExtrasChanged();
    }

    private final void $$robo$$android_telecom_RemoteConference$removeExtras(List<String> keys) {
        if (this.mExtras == null || keys == null || keys.isEmpty()) {
            return;
        }
        for (String key : keys) {
            this.mExtras.remove(key);
        }
        this.notifyExtrasChanged();
    }

    private final void $$robo$$android_telecom_RemoteConference$notifyExtrasChanged() {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            RemoteConference conference = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, conference){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ RemoteConference val$conference;
                /* synthetic */ RemoteConference this$0;

                private void $$robo$$android_telecom_RemoteConference_9$__constructor__(RemoteConference this$0, Callback callback, RemoteConference remoteConference) {
                }

                private final void $$robo$$android_telecom_RemoteConference_9$run() {
                    this.val$callback.onExtrasChanged(this.val$conference, this.this$0.mExtras);
                }

                private void __constructor__(RemoteConference remoteConference, Callback callback, RemoteConference remoteConference2) {
                    this.$$robo$$android_telecom_RemoteConference_9$__constructor__(remoteConference, callback, remoteConference2);
                }
                {
                    this.this$0 = remoteConference;
                    this.val$callback = callback;
                    this.val$conference = remoteConference2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_9$__constructor__(android.telecom.RemoteConference android.telecom.RemoteConference$Callback android.telecom.RemoteConference ), 0, this, remoteConference, callback, remoteConference2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_RemoteConference_9$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final List<RemoteConnection> $$robo$$android_telecom_RemoteConference$getConnections() {
        return this.mUnmodifiableChildConnections;
    }

    private final int $$robo$$android_telecom_RemoteConference$getState() {
        return this.mState;
    }

    private final int $$robo$$android_telecom_RemoteConference$getConnectionCapabilities() {
        return this.mConnectionCapabilities;
    }

    private final int $$robo$$android_telecom_RemoteConference$getConnectionProperties() {
        return this.mConnectionProperties;
    }

    private final Bundle $$robo$$android_telecom_RemoteConference$getExtras() {
        return this.mExtras;
    }

    private final void $$robo$$android_telecom_RemoteConference$disconnect() {
        try {
            this.mConnectionService.disconnect(this.mId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$separate(RemoteConnection connection) {
        if (this.mChildConnections.contains(connection)) {
            try {
                this.mConnectionService.splitFromConference(connection.getId(), null);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$merge() {
        try {
            this.mConnectionService.mergeConference(this.mId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$swap() {
        try {
            this.mConnectionService.swapConference(this.mId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$hold() {
        try {
            this.mConnectionService.hold(this.mId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$unhold() {
        try {
            this.mConnectionService.unhold(this.mId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final DisconnectCause $$robo$$android_telecom_RemoteConference$getDisconnectCause() {
        return this.mDisconnectCause;
    }

    private final void $$robo$$android_telecom_RemoteConference$playDtmfTone(char digit) {
        try {
            this.mConnectionService.playDtmfTone(this.mId, digit, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$stopDtmfTone() {
        try {
            this.mConnectionService.stopDtmfTone(this.mId, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    @Deprecated
    private final void $$robo$$android_telecom_RemoteConference$setAudioState(AudioState state) {
        this.setCallAudioState(new CallAudioState(state));
    }

    private final void $$robo$$android_telecom_RemoteConference$setCallAudioState(CallAudioState state) {
        try {
            this.mConnectionService.onCallAudioStateChanged(this.mId, state, null);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final List<RemoteConnection> $$robo$$android_telecom_RemoteConference$getConferenceableConnections() {
        return this.mUnmodifiableConferenceableConnections;
    }

    private final void $$robo$$android_telecom_RemoteConference$registerCallback(Callback callback) {
        this.registerCallback(callback, new Handler());
    }

    private final void $$robo$$android_telecom_RemoteConference$registerCallback(Callback callback, Handler handler) {
        this.unregisterCallback(callback);
        if (callback != null && handler != null) {
            this.mCallbackRecords.add(new CallbackRecord<Callback>(callback, handler));
        }
    }

    private final void $$robo$$android_telecom_RemoteConference$unregisterCallback(Callback callback) {
        if (callback != null) {
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                if (record.getCallback() != callback) continue;
                this.mCallbackRecords.remove(record);
                break;
            }
        }
    }

    private void __constructor__(String string2, IConnectionService iConnectionService) {
        this.$$robo$$android_telecom_RemoteConference$__constructor__(string2, iConnectionService);
    }

    RemoteConference(String string2, IConnectionService iConnectionService) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference$__constructor__(java.lang.String com.android.internal.telecom.IConnectionService ), 0, this, string2, iConnectionService);
    }

    String getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_telecom_RemoteConference$getId(), 0, this);
    }

    void setDestroyed() {
        InvokeDynamicSupport.bootstrap("setDestroyed", $$robo$$android_telecom_RemoteConference$setDestroyed(), 0, this);
    }

    void setState(int n) {
        InvokeDynamicSupport.bootstrap("setState", $$robo$$android_telecom_RemoteConference$setState(int ), 0, this, n);
    }

    void addConnection(RemoteConnection remoteConnection) {
        InvokeDynamicSupport.bootstrap("addConnection", $$robo$$android_telecom_RemoteConference$addConnection(android.telecom.RemoteConnection ), 0, this, remoteConnection);
    }

    void removeConnection(RemoteConnection remoteConnection) {
        InvokeDynamicSupport.bootstrap("removeConnection", $$robo$$android_telecom_RemoteConference$removeConnection(android.telecom.RemoteConnection ), 0, this, remoteConnection);
    }

    void setConnectionCapabilities(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionCapabilities", $$robo$$android_telecom_RemoteConference$setConnectionCapabilities(int ), 0, this, n);
    }

    void setConnectionProperties(int n) {
        InvokeDynamicSupport.bootstrap("setConnectionProperties", $$robo$$android_telecom_RemoteConference$setConnectionProperties(int ), 0, this, n);
    }

    void setConferenceableConnections(List<RemoteConnection> list) {
        InvokeDynamicSupport.bootstrap("setConferenceableConnections", $$robo$$android_telecom_RemoteConference$setConferenceableConnections(java.util.List<android.telecom.RemoteConnection> ), 0, this, list);
    }

    void setDisconnected(DisconnectCause disconnectCause) {
        InvokeDynamicSupport.bootstrap("setDisconnected", $$robo$$android_telecom_RemoteConference$setDisconnected(android.telecom.DisconnectCause ), 0, this, disconnectCause);
    }

    void putExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_telecom_RemoteConference$putExtras(android.os.Bundle ), 0, this, bundle);
    }

    void removeExtras(List<String> list) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_RemoteConference$removeExtras(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void notifyExtrasChanged() {
        InvokeDynamicSupport.bootstrap("notifyExtrasChanged", $$robo$$android_telecom_RemoteConference$notifyExtrasChanged(), 0, this);
    }

    public List<RemoteConnection> getConnections() {
        return InvokeDynamicSupport.bootstrap("getConnections", $$robo$$android_telecom_RemoteConference$getConnections(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_RemoteConference$getState(), 0, this);
    }

    public int getConnectionCapabilities() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionCapabilities", $$robo$$android_telecom_RemoteConference$getConnectionCapabilities(), 0, this);
    }

    public int getConnectionProperties() {
        return (int)InvokeDynamicSupport.bootstrap("getConnectionProperties", $$robo$$android_telecom_RemoteConference$getConnectionProperties(), 0, this);
    }

    public Bundle getExtras() {
        return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_RemoteConference$getExtras(), 0, this);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_RemoteConference$disconnect(), 0, this);
    }

    public void separate(RemoteConnection remoteConnection) {
        InvokeDynamicSupport.bootstrap("separate", $$robo$$android_telecom_RemoteConference$separate(android.telecom.RemoteConnection ), 0, this, remoteConnection);
    }

    public void merge() {
        InvokeDynamicSupport.bootstrap("merge", $$robo$$android_telecom_RemoteConference$merge(), 0, this);
    }

    public void swap() {
        InvokeDynamicSupport.bootstrap("swap", $$robo$$android_telecom_RemoteConference$swap(), 0, this);
    }

    public void hold() {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_RemoteConference$hold(), 0, this);
    }

    public void unhold() {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_RemoteConference$unhold(), 0, this);
    }

    public DisconnectCause getDisconnectCause() {
        return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_RemoteConference$getDisconnectCause(), 0, this);
    }

    public void playDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_RemoteConference$playDtmfTone(char ), 0, this, c);
    }

    public void stopDtmfTone() {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_RemoteConference$stopDtmfTone(), 0, this);
    }

    @Deprecated
    public void setAudioState(AudioState audioState) {
        InvokeDynamicSupport.bootstrap("setAudioState", $$robo$$android_telecom_RemoteConference$setAudioState(android.telecom.AudioState ), 0, this, audioState);
    }

    public void setCallAudioState(CallAudioState callAudioState) {
        InvokeDynamicSupport.bootstrap("setCallAudioState", $$robo$$android_telecom_RemoteConference$setCallAudioState(android.telecom.CallAudioState ), 0, this, callAudioState);
    }

    public List<RemoteConnection> getConferenceableConnections() {
        return InvokeDynamicSupport.bootstrap("getConferenceableConnections", $$robo$$android_telecom_RemoteConference$getConferenceableConnections(), 0, this);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConference$registerCallback(android.telecom.RemoteConference$Callback ), 0, this, callback);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_RemoteConference$registerCallback(android.telecom.RemoteConference$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_RemoteConference$unregisterCallback(android.telecom.RemoteConference$Callback ), 0, this, callback);
    }

    public /* synthetic */ RemoteConference() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RemoteConference)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_RemoteConference_Callback$__constructor__() {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onStateChanged(RemoteConference conference, int oldState, int newState) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onDisconnected(RemoteConference conference, DisconnectCause disconnectCause) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConnectionAdded(RemoteConference conference, RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConnectionRemoved(RemoteConference conference, RemoteConnection connection) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConnectionCapabilitiesChanged(RemoteConference conference, int connectionCapabilities) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConnectionPropertiesChanged(RemoteConference conference, int connectionProperties) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onConferenceableConnectionsChanged(RemoteConference conference, List<RemoteConnection> conferenceableConnections) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onDestroyed(RemoteConference conference) {
        }

        private final void $$robo$$android_telecom_RemoteConference_Callback$onExtrasChanged(RemoteConference conference, Bundle extras) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_RemoteConference_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_RemoteConference_Callback$__constructor__(), 0, this);
        }

        public void onStateChanged(RemoteConference remoteConference, int n, int n2) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_RemoteConference_Callback$onStateChanged(android.telecom.RemoteConference int int ), 0, this, remoteConference, n, n2);
        }

        public void onDisconnected(RemoteConference remoteConference, DisconnectCause disconnectCause) {
            InvokeDynamicSupport.bootstrap("onDisconnected", $$robo$$android_telecom_RemoteConference_Callback$onDisconnected(android.telecom.RemoteConference android.telecom.DisconnectCause ), 0, this, remoteConference, disconnectCause);
        }

        public void onConnectionAdded(RemoteConference remoteConference, RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onConnectionAdded", $$robo$$android_telecom_RemoteConference_Callback$onConnectionAdded(android.telecom.RemoteConference android.telecom.RemoteConnection ), 0, this, remoteConference, remoteConnection);
        }

        public void onConnectionRemoved(RemoteConference remoteConference, RemoteConnection remoteConnection) {
            InvokeDynamicSupport.bootstrap("onConnectionRemoved", $$robo$$android_telecom_RemoteConference_Callback$onConnectionRemoved(android.telecom.RemoteConference android.telecom.RemoteConnection ), 0, this, remoteConference, remoteConnection);
        }

        public void onConnectionCapabilitiesChanged(RemoteConference remoteConference, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionCapabilitiesChanged", $$robo$$android_telecom_RemoteConference_Callback$onConnectionCapabilitiesChanged(android.telecom.RemoteConference int ), 0, this, remoteConference, n);
        }

        public void onConnectionPropertiesChanged(RemoteConference remoteConference, int n) {
            InvokeDynamicSupport.bootstrap("onConnectionPropertiesChanged", $$robo$$android_telecom_RemoteConference_Callback$onConnectionPropertiesChanged(android.telecom.RemoteConference int ), 0, this, remoteConference, n);
        }

        public void onConferenceableConnectionsChanged(RemoteConference remoteConference, List<RemoteConnection> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableConnectionsChanged", $$robo$$android_telecom_RemoteConference_Callback$onConferenceableConnectionsChanged(android.telecom.RemoteConference java.util.List<android.telecom.RemoteConnection> ), 0, this, remoteConference, list);
        }

        public void onDestroyed(RemoteConference remoteConference) {
            InvokeDynamicSupport.bootstrap("onDestroyed", $$robo$$android_telecom_RemoteConference_Callback$onDestroyed(android.telecom.RemoteConference ), 0, this, remoteConference);
        }

        public void onExtrasChanged(RemoteConference remoteConference, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onExtrasChanged", $$robo$$android_telecom_RemoteConference_Callback$onExtrasChanged(android.telecom.RemoteConference android.os.Bundle ), 0, this, remoteConference, bundle);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

