/*
 * Decompiled with CFR 0.152.
 */
package android.telecom.Logging;

import android.telecom.Log;
import android.telecom.Logging.SessionManager;
import android.telecom.Logging.TimedEvent;
import android.text.TextUtils;
import com.android.internal.util.IndentingPrintWriter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class EventManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String TAG = "Logging.Events";
    public static int DEFAULT_EVENTS_TO_CACHE = 10;
    private Map<Loggable, EventRecord> mCallEventRecordMap;
    private LinkedBlockingQueue<EventRecord> mEventRecords;
    private List<EventListener> mEventListeners;
    private SessionManager.ISessionIdQueryHandler mSessionIdHandler;
    private Map<String, List<TimedEventPair>> requestResponsePairs;
    private static Object mSync;

    private final void $$robo$$android_telecom_Logging_EventManager$addRequestResponsePair(TimedEventPair p) {
        if (this.requestResponsePairs.containsKey(p.mRequest)) {
            this.requestResponsePairs.get(p.mRequest).add(p);
        } else {
            ArrayList<TimedEventPair> responses = new ArrayList<TimedEventPair>();
            responses.add(p);
            this.requestResponsePairs.put(p.mRequest, responses);
        }
    }

    private void $$robo$$android_telecom_Logging_EventManager$__constructor__(SessionManager.ISessionIdQueryHandler l) {
        this.mCallEventRecordMap = new HashMap<Loggable, EventRecord>();
        this.mEventRecords = new LinkedBlockingQueue(10);
        this.mEventListeners = new ArrayList<EventListener>();
        this.requestResponsePairs = new HashMap<String, List<TimedEventPair>>();
        this.mSessionIdHandler = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Logging_EventManager$event(Loggable recordEntry, String event, Object data) {
        String currentSessionID = this.mSessionIdHandler.getSessionId();
        if (recordEntry == null) {
            Log.i("Logging.Events", "Non-call EVENT: %s, %s", event, data);
            return;
        }
        LinkedBlockingQueue<EventRecord> linkedBlockingQueue = this.mEventRecords;
        synchronized (linkedBlockingQueue) {
            if (!this.mCallEventRecordMap.containsKey(recordEntry)) {
                EventRecord newRecord = new EventRecord(this, recordEntry);
                this.addEventRecord(newRecord);
            }
            EventRecord record = this.mCallEventRecordMap.get(recordEntry);
            record.addEvent(event, currentSessionID, data);
        }
    }

    private final void $$robo$$android_telecom_Logging_EventManager$event(Loggable recordEntry, String event, String format, Object ... args) {
        String msg;
        try {
            msg = args == null || args.length == 0 ? format : String.format(Locale.US, format, args);
        }
        catch (IllegalFormatException ife) {
            Log.e(this, (Throwable)ife, "IllegalFormatException: formatString='%s' numArgs=%d", format, args.length);
            msg = format + " (An error occurred while formatting the message.)";
        }
        this.event(recordEntry, event, msg);
    }

    private final void $$robo$$android_telecom_Logging_EventManager$dumpEvents(IndentingPrintWriter pw) {
        pw.println("Historical Events:");
        pw.increaseIndent();
        for (EventRecord eventRecord : this.mEventRecords) {
            eventRecord.dump(pw);
        }
        pw.decreaseIndent();
    }

    private final void $$robo$$android_telecom_Logging_EventManager$changeEventCacheSize(int newSize) {
        LinkedBlockingQueue<EventRecord> oldEventLog = this.mEventRecords;
        this.mEventRecords = new LinkedBlockingQueue(newSize);
        this.mCallEventRecordMap.clear();
        oldEventLog.forEach(newRecord -> {
            EventRecord record;
            Loggable recordEntry = newRecord.getRecordEntry();
            if (this.mEventRecords.remainingCapacity() == 0 && (record = this.mEventRecords.poll()) != null) {
                this.mCallEventRecordMap.remove(record.getRecordEntry());
            }
            this.mEventRecords.add((EventRecord)newRecord);
            this.mCallEventRecordMap.put(recordEntry, (EventRecord)newRecord);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Logging_EventManager$registerEventListener(EventListener e) {
        if (e != null) {
            Object object = mSync;
            synchronized (object) {
                this.mEventListeners.add(e);
            }
        }
    }

    private final LinkedBlockingQueue<EventRecord> $$robo$$android_telecom_Logging_EventManager$getEventRecords() {
        return this.mEventRecords;
    }

    private final Map<Loggable, EventRecord> $$robo$$android_telecom_Logging_EventManager$getCallEventRecordMap() {
        return this.mCallEventRecordMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_telecom_Logging_EventManager$addEventRecord(EventRecord newRecord) {
        EventRecord record;
        Loggable recordEntry = newRecord.getRecordEntry();
        if (this.mEventRecords.remainingCapacity() == 0 && (record = this.mEventRecords.poll()) != null) {
            this.mCallEventRecordMap.remove(record.getRecordEntry());
        }
        this.mEventRecords.add(newRecord);
        this.mCallEventRecordMap.put(recordEntry, newRecord);
        Object object = mSync;
        synchronized (object) {
            for (EventListener l : this.mEventListeners) {
                l.eventRecordAdded(newRecord);
            }
        }
    }

    static void __staticInitializer__() {
        mSync = new Object();
    }

    public void addRequestResponsePair(TimedEventPair timedEventPair) {
        InvokeDynamicSupport.bootstrap("addRequestResponsePair", $$robo$$android_telecom_Logging_EventManager$addRequestResponsePair(android.telecom.Logging.EventManager$TimedEventPair ), 0, this, timedEventPair);
    }

    private void __constructor__(SessionManager.ISessionIdQueryHandler iSessionIdQueryHandler) {
        this.$$robo$$android_telecom_Logging_EventManager$__constructor__(iSessionIdQueryHandler);
    }

    public EventManager(SessionManager.ISessionIdQueryHandler iSessionIdQueryHandler) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager$__constructor__(android.telecom.Logging.SessionManager$ISessionIdQueryHandler ), 0, this, iSessionIdQueryHandler);
    }

    public void event(Loggable loggable, String string2, Object object) {
        InvokeDynamicSupport.bootstrap("event", $$robo$$android_telecom_Logging_EventManager$event(android.telecom.Logging.EventManager$Loggable java.lang.String java.lang.Object ), 0, this, loggable, string2, object);
    }

    public void event(Loggable loggable, String string2, String string3, Object ... objectArray) {
        InvokeDynamicSupport.bootstrap("event", $$robo$$android_telecom_Logging_EventManager$event(android.telecom.Logging.EventManager$Loggable java.lang.String java.lang.String java.lang.Object[] ), 0, this, loggable, string2, string3, objectArray);
    }

    public void dumpEvents(IndentingPrintWriter indentingPrintWriter) {
        InvokeDynamicSupport.bootstrap("dumpEvents", $$robo$$android_telecom_Logging_EventManager$dumpEvents(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
    }

    public void changeEventCacheSize(int n) {
        InvokeDynamicSupport.bootstrap("changeEventCacheSize", $$robo$$android_telecom_Logging_EventManager$changeEventCacheSize(int ), 0, this, n);
    }

    public void registerEventListener(EventListener eventListener) {
        InvokeDynamicSupport.bootstrap("registerEventListener", $$robo$$android_telecom_Logging_EventManager$registerEventListener(android.telecom.Logging.EventManager$EventListener ), 0, this, eventListener);
    }

    public LinkedBlockingQueue<EventRecord> getEventRecords() {
        return InvokeDynamicSupport.bootstrap("getEventRecords", $$robo$$android_telecom_Logging_EventManager$getEventRecords(), 0, this);
    }

    public Map<Loggable, EventRecord> getCallEventRecordMap() {
        return InvokeDynamicSupport.bootstrap("getCallEventRecordMap", $$robo$$android_telecom_Logging_EventManager$getCallEventRecordMap(), 0, this);
    }

    private void addEventRecord(EventRecord eventRecord) {
        InvokeDynamicSupport.bootstrap("addEventRecord", $$robo$$android_telecom_Logging_EventManager$addEventRecord(android.telecom.Logging.EventManager$EventRecord ), 0, this, eventRecord);
    }

    static {
        RobolectricInternals.classInitializing(EventManager.class);
    }

    public /* synthetic */ EventManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class EventRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private DateFormat sDateFormat;
        private List<Event> mEvents;
        private Loggable mRecordEntry;
        /* synthetic */ EventManager this$0;

        private void $$robo$$android_telecom_Logging_EventManager_EventRecord$__constructor__(EventManager this$0, Loggable recordEntry) {
            this.sDateFormat = new SimpleDateFormat("HH:mm:ss.SSS");
            this.mEvents = new LinkedList<Event>();
            this.mRecordEntry = recordEntry;
        }

        private final Loggable $$robo$$android_telecom_Logging_EventManager_EventRecord$getRecordEntry() {
            return this.mRecordEntry;
        }

        private final void $$robo$$android_telecom_Logging_EventManager_EventRecord$addEvent(String event, String sessionId, Object data) {
            this.mEvents.add(new Event(event, sessionId, (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System"), data));
            Log.i("Event", "RecordEntry %s: %s, %s", this.mRecordEntry.getId(), event, data);
        }

        private final List<Event> $$robo$$android_telecom_Logging_EventManager_EventRecord$getEvents() {
            return this.mEvents;
        }

        private final List<EventTiming> $$robo$$android_telecom_Logging_EventManager_EventRecord$extractEventTimings() {
            if (this.mEvents == null) {
                return Collections.emptyList();
            }
            LinkedList<EventTiming> result = new LinkedList<EventTiming>();
            HashMap<String, PendingResponse> pendingResponses = new HashMap<String, PendingResponse>();
            for (Event event : this.mEvents) {
                long elapsedTime;
                PendingResponse pendingResponse;
                if (this.this$0.requestResponsePairs.containsKey(event.eventId)) {
                    for (TimedEventPair p : (List)this.this$0.requestResponsePairs.get(event.eventId)) {
                        pendingResponses.put(p.mResponse, new PendingResponse(this, event.eventId, event.time, p.mTimeoutMillis, p.mName));
                    }
                }
                if ((pendingResponse = (PendingResponse)pendingResponses.remove(event.eventId)) == null || (elapsedTime = event.time - pendingResponse.requestEventTimeMillis) >= pendingResponse.timeoutMillis) continue;
                result.add(new EventTiming(this, pendingResponse.name, elapsedTime));
            }
            return result;
        }

        private final void $$robo$$android_telecom_Logging_EventManager_EventRecord$dump(IndentingPrintWriter pw) {
            pw.print(this.mRecordEntry.getDescription());
            pw.increaseIndent();
            for (Event event : this.mEvents) {
                pw.print(this.sDateFormat.format(new Date(event.time)));
                pw.print(" - ");
                pw.print(event.eventId);
                if (event.data != null) {
                    EventRecord record;
                    pw.print(" (");
                    Object data = event.data;
                    if (data instanceof Loggable && (record = (EventRecord)this.this$0.mCallEventRecordMap.get(data)) != null) {
                        data = "RecordEntry " + record.mRecordEntry.getId();
                    }
                    pw.print(data);
                    pw.print(")");
                }
                if (!TextUtils.isEmpty(event.sessionId)) {
                    pw.print(":");
                    pw.print(event.sessionId);
                }
                pw.println();
            }
            pw.println("Timings (average for this call, milliseconds):");
            pw.increaseIndent();
            Map avgEventTimings = EventTiming.averageTimings(this.extractEventTimings());
            ArrayList eventNames = new ArrayList(avgEventTimings.keySet());
            Collections.sort(eventNames);
            for (String eventName : eventNames) {
                pw.printf("%s: %.2f\n", eventName, avgEventTimings.get(eventName));
            }
            pw.decreaseIndent();
            pw.decreaseIndent();
        }

        private void __constructor__(EventManager eventManager, Loggable loggable) {
            this.$$robo$$android_telecom_Logging_EventManager_EventRecord$__constructor__(eventManager, loggable);
        }

        public EventRecord(EventManager eventManager, Loggable loggable) {
            this.this$0 = eventManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager_EventRecord$__constructor__(android.telecom.Logging.EventManager android.telecom.Logging.EventManager$Loggable ), 0, this, eventManager, loggable);
        }

        public Loggable getRecordEntry() {
            return InvokeDynamicSupport.bootstrap("getRecordEntry", $$robo$$android_telecom_Logging_EventManager_EventRecord$getRecordEntry(), 0, this);
        }

        public void addEvent(String string2, String string3, Object object) {
            InvokeDynamicSupport.bootstrap("addEvent", $$robo$$android_telecom_Logging_EventManager_EventRecord$addEvent(java.lang.String java.lang.String java.lang.Object ), 0, this, string2, string3, object);
        }

        public List<Event> getEvents() {
            return InvokeDynamicSupport.bootstrap("getEvents", $$robo$$android_telecom_Logging_EventManager_EventRecord$getEvents(), 0, this);
        }

        public List<EventTiming> extractEventTimings() {
            return InvokeDynamicSupport.bootstrap("extractEventTimings", $$robo$$android_telecom_Logging_EventManager_EventRecord$extractEventTimings(), 0, this);
        }

        public void dump(IndentingPrintWriter indentingPrintWriter) {
            InvokeDynamicSupport.bootstrap("dump", $$robo$$android_telecom_Logging_EventManager_EventRecord$dump(com.android.internal.util.IndentingPrintWriter ), 0, this, indentingPrintWriter);
        }

        public /* synthetic */ EventRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class PendingResponse
        implements ShadowedObject {
            public transient /* synthetic */ Object __robo_data__;
            String requestEventId;
            long requestEventTimeMillis;
            long timeoutMillis;
            String name;
            /* synthetic */ EventRecord this$1;

            private void $$robo$$android_telecom_Logging_EventManager_EventRecord_PendingResponse$__constructor__(EventRecord eventRecord, String requestEventId, long requestEventTimeMillis, long timeoutMillis, String name) {
                this.requestEventId = requestEventId;
                this.requestEventTimeMillis = requestEventTimeMillis;
                this.timeoutMillis = timeoutMillis;
                this.name = name;
            }

            private void __constructor__(EventRecord eventRecord, String string2, long l, long l2, String string3) {
                this.$$robo$$android_telecom_Logging_EventManager_EventRecord_PendingResponse$__constructor__(eventRecord, string2, l, l2, string3);
            }

            public PendingResponse(EventRecord eventRecord, String string2, long l, long l2, String string3) {
                this.this$1 = eventRecord;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager_EventRecord_PendingResponse$__constructor__(android.telecom.Logging.EventManager$EventRecord java.lang.String long long java.lang.String ), 0, this, eventRecord, string2, l, l2, string3);
            }

            public /* synthetic */ PendingResponse() {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PendingResponse)this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }

        public class EventTiming
        extends TimedEvent<String> {
            public transient /* synthetic */ Object __robo_data__;
            public String name;
            public long time;
            /* synthetic */ EventRecord this$1;

            private void $$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$__constructor__(EventRecord this$1, String name, long time) {
                this.name = name;
                this.time = time;
            }

            private final String $$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$getKey() {
                return this.name;
            }

            private final long $$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$getTime() {
                return this.time;
            }

            private void __constructor__(EventRecord eventRecord, String string2, long l) {
                this.$$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$__constructor__(eventRecord, string2, l);
            }

            public EventTiming(EventRecord eventRecord, String string2, long l) {
                this.this$1 = eventRecord;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$__constructor__(android.telecom.Logging.EventManager$EventRecord java.lang.String long ), 0, this, eventRecord, string2, l);
            }

            @Override
            public String getKey() {
                return InvokeDynamicSupport.bootstrap("getKey", $$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$getKey(), 0, this);
            }

            @Override
            public long getTime() {
                return (long)InvokeDynamicSupport.bootstrap("getTime", $$robo$$android_telecom_Logging_EventManager_EventRecord_EventTiming$getTime(), 0, this);
            }

            public /* synthetic */ EventTiming() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EventTiming)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public static class Event
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String eventId;
        public String sessionId;
        public long time;
        public Object data;

        private void $$robo$$android_telecom_Logging_EventManager_Event$__constructor__(String eventId, String sessionId, long time, Object data) {
            this.eventId = eventId;
            this.sessionId = sessionId;
            this.time = time;
            this.data = data;
        }

        private void __constructor__(String string2, String string3, long l, Object object) {
            this.$$robo$$android_telecom_Logging_EventManager_Event$__constructor__(string2, string3, l, object);
        }

        public Event(String string2, String string3, long l, Object object) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager_Event$__constructor__(java.lang.String java.lang.String long java.lang.Object ), 0, this, string2, string3, l, object);
        }

        public /* synthetic */ Event() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Event)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class TimedEventPair
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static long DEFAULT_TIMEOUT = 3000L;
        String mRequest;
        String mResponse;
        String mName;
        long mTimeoutMillis;

        private void $$robo$$android_telecom_Logging_EventManager_TimedEventPair$__constructor__(String request, String response, String name) {
            this.mTimeoutMillis = 3000L;
            this.mRequest = request;
            this.mResponse = response;
            this.mName = name;
        }

        private void $$robo$$android_telecom_Logging_EventManager_TimedEventPair$__constructor__(String request, String response, String name, long timeoutMillis) {
            this.mTimeoutMillis = 3000L;
            this.mRequest = request;
            this.mResponse = response;
            this.mName = name;
            this.mTimeoutMillis = timeoutMillis;
        }

        private void __constructor__(String string2, String string3, String string4) {
            this.$$robo$$android_telecom_Logging_EventManager_TimedEventPair$__constructor__(string2, string3, string4);
        }

        public TimedEventPair(String string2, String string3, String string4) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager_TimedEventPair$__constructor__(java.lang.String java.lang.String java.lang.String ), 0, this, string2, string3, string4);
        }

        private void __constructor__(String string2, String string3, String string4, long l) {
            this.$$robo$$android_telecom_Logging_EventManager_TimedEventPair$__constructor__(string2, string3, string4, l);
        }

        public TimedEventPair(String string2, String string3, String string4, long l) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Logging_EventManager_TimedEventPair$__constructor__(java.lang.String java.lang.String java.lang.String long ), 0, this, string2, string3, string4, l);
        }

        public /* synthetic */ TimedEventPair() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TimedEventPair)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface EventListener
    extends InstrumentedInterface {
        public void eventRecordAdded(EventRecord var1);
    }

    public static interface Loggable
    extends InstrumentedInterface {
        public String getId();

        public String getDescription();
    }
}

