/*
 * Decompiled with CFR 0.152.
 */
package android.telecom;

import android.annotation.IntDef;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.ParcelFileDescriptor;
import android.telecom.CallbackRecord;
import android.telecom.DisconnectCause;
import android.telecom.GatewayInfo;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.Log;
import android.telecom.ParcelableCall;
import android.telecom.ParcelableRttCall;
import android.telecom.Phone;
import android.telecom.PhoneAccountHandle;
import android.telecom.StatusHints;
import android.telecom.VideoCallImpl;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Call
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int STATE_NEW = 0;
    public static int STATE_DIALING = 1;
    public static int STATE_RINGING = 2;
    public static int STATE_HOLDING = 3;
    public static int STATE_ACTIVE = 4;
    public static int STATE_DISCONNECTED = 7;
    public static int STATE_SELECT_PHONE_ACCOUNT = 8;
    @Deprecated
    public static int STATE_PRE_DIAL_WAIT = 8;
    public static int STATE_CONNECTING = 9;
    public static int STATE_DISCONNECTING = 10;
    public static int STATE_PULLING_CALL = 11;
    public static String AVAILABLE_PHONE_ACCOUNTS = "selectPhoneAccountAccounts";
    public static String EXTRA_LAST_EMERGENCY_CALLBACK_TIME_MILLIS = "android.telecom.extra.LAST_EMERGENCY_CALLBACK_TIME_MILLIS";
    private Phone mPhone;
    private String mTelecomCallId;
    private InCallAdapter mInCallAdapter;
    private List<String> mChildrenIds;
    private List<Call> mChildren;
    private List<Call> mUnmodifiableChildren;
    private List<CallbackRecord<Callback>> mCallbackRecords;
    private List<Call> mConferenceableCalls;
    private List<Call> mUnmodifiableConferenceableCalls;
    private boolean mChildrenCached;
    private String mParentId;
    private int mState;
    private List<String> mCannedTextResponses;
    private String mCallingPackage;
    private int mTargetSdkVersion;
    private String mRemainingPostDialSequence;
    private VideoCallImpl mVideoCallImpl;
    private RttCall mRttCall;
    private Details mDetails;
    private Bundle mExtras;

    private final String $$robo$$android_telecom_Call$getRemainingPostDialSequence() {
        return this.mRemainingPostDialSequence;
    }

    private final void $$robo$$android_telecom_Call$answer(int videoState) {
        this.mInCallAdapter.answerCall(this.mTelecomCallId, videoState);
    }

    private final void $$robo$$android_telecom_Call$reject(boolean rejectWithMessage, String textMessage) {
        this.mInCallAdapter.rejectCall(this.mTelecomCallId, rejectWithMessage, textMessage);
    }

    private final void $$robo$$android_telecom_Call$disconnect() {
        this.mInCallAdapter.disconnectCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$hold() {
        this.mInCallAdapter.holdCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$unhold() {
        this.mInCallAdapter.unholdCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$playDtmfTone(char digit) {
        this.mInCallAdapter.playDtmfTone(this.mTelecomCallId, digit);
    }

    private final void $$robo$$android_telecom_Call$stopDtmfTone() {
        this.mInCallAdapter.stopDtmfTone(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$postDialContinue(boolean proceed) {
        this.mInCallAdapter.postDialContinue(this.mTelecomCallId, proceed);
    }

    private final void $$robo$$android_telecom_Call$phoneAccountSelected(PhoneAccountHandle accountHandle, boolean setDefault) {
        this.mInCallAdapter.phoneAccountSelected(this.mTelecomCallId, accountHandle, setDefault);
    }

    private final void $$robo$$android_telecom_Call$conference(Call callToConferenceWith) {
        if (callToConferenceWith != null) {
            this.mInCallAdapter.conference(this.mTelecomCallId, callToConferenceWith.mTelecomCallId);
        }
    }

    private final void $$robo$$android_telecom_Call$splitFromConference() {
        this.mInCallAdapter.splitFromConference(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$mergeConference() {
        this.mInCallAdapter.mergeConference(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$swapConference() {
        this.mInCallAdapter.swapConference(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$pullExternalCall() {
        if (!this.mDetails.hasProperty(64)) {
            return;
        }
        this.mInCallAdapter.pullExternalCall(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$sendCallEvent(String event, Bundle extras) {
        this.mInCallAdapter.sendCallEvent(this.mTelecomCallId, event, extras);
    }

    private final void $$robo$$android_telecom_Call$sendRttRequest() {
        this.mInCallAdapter.sendRttRequest(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$respondToRttRequest(int id2, boolean accept) {
        this.mInCallAdapter.respondToRttRequest(this.mTelecomCallId, id2, accept);
    }

    private final void $$robo$$android_telecom_Call$stopRtt() {
        this.mInCallAdapter.stopRtt(this.mTelecomCallId);
    }

    private final void $$robo$$android_telecom_Call$putExtras(Bundle extras) {
        if (extras == null) {
            return;
        }
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putAll(extras);
        this.mInCallAdapter.putExtras(this.mTelecomCallId, extras);
    }

    private final void $$robo$$android_telecom_Call$putExtra(String key, boolean value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putBoolean(key, value);
        this.mInCallAdapter.putExtra(this.mTelecomCallId, key, value);
    }

    private final void $$robo$$android_telecom_Call$putExtra(String key, int value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putInt(key, value);
        this.mInCallAdapter.putExtra(this.mTelecomCallId, key, value);
    }

    private final void $$robo$$android_telecom_Call$putExtra(String key, String value) {
        if (this.mExtras == null) {
            this.mExtras = new Bundle();
        }
        this.mExtras.putString(key, value);
        this.mInCallAdapter.putExtra(this.mTelecomCallId, key, value);
    }

    private final void $$robo$$android_telecom_Call$removeExtras(List<String> keys) {
        if (this.mExtras != null) {
            for (String key : keys) {
                this.mExtras.remove(key);
            }
            if (this.mExtras.size() == 0) {
                this.mExtras = null;
            }
        }
        this.mInCallAdapter.removeExtras(this.mTelecomCallId, keys);
    }

    private final void $$robo$$android_telecom_Call$removeExtras(String ... keys) {
        this.removeExtras(Arrays.asList(keys));
    }

    private final Call $$robo$$android_telecom_Call$getParent() {
        if (this.mParentId != null) {
            return this.mPhone.internalGetCallByTelecomId(this.mParentId);
        }
        return null;
    }

    private final List<Call> $$robo$$android_telecom_Call$getChildren() {
        if (!this.mChildrenCached) {
            this.mChildrenCached = true;
            this.mChildren.clear();
            for (String id2 : this.mChildrenIds) {
                Call call = this.mPhone.internalGetCallByTelecomId(id2);
                if (call == null) {
                    this.mChildrenCached = false;
                    continue;
                }
                this.mChildren.add(call);
            }
        }
        return this.mUnmodifiableChildren;
    }

    private final List<Call> $$robo$$android_telecom_Call$getConferenceableCalls() {
        return this.mUnmodifiableConferenceableCalls;
    }

    private final int $$robo$$android_telecom_Call$getState() {
        return this.mState;
    }

    private final List<String> $$robo$$android_telecom_Call$getCannedTextResponses() {
        return this.mCannedTextResponses;
    }

    private final InCallService.VideoCall $$robo$$android_telecom_Call$getVideoCall() {
        return this.mVideoCallImpl;
    }

    private final Details $$robo$$android_telecom_Call$getDetails() {
        return this.mDetails;
    }

    private final RttCall $$robo$$android_telecom_Call$getRttCall() {
        return this.mRttCall;
    }

    private final boolean $$robo$$android_telecom_Call$isRttActive() {
        return this.mRttCall != null;
    }

    private final void $$robo$$android_telecom_Call$registerCallback(Callback callback) {
        this.registerCallback(callback, new Handler());
    }

    private final void $$robo$$android_telecom_Call$registerCallback(Callback callback, Handler handler) {
        this.unregisterCallback(callback);
        if (callback != null && handler != null && this.mState != 7) {
            this.mCallbackRecords.add(new CallbackRecord<Callback>(callback, handler));
        }
    }

    private final void $$robo$$android_telecom_Call$unregisterCallback(Callback callback) {
        if (callback != null && this.mState != 7) {
            for (CallbackRecord<Callback> record : this.mCallbackRecords) {
                if (record.getCallback() != callback) continue;
                this.mCallbackRecords.remove(record);
                break;
            }
        }
    }

    private final String $$robo$$android_telecom_Call$toString() {
        return "Call [id: " + this.mTelecomCallId + ", state: " + Call.stateToString(this.mState) + ", details: " + this.mDetails + "]";
    }

    private static final String $$robo$$android_telecom_Call$stateToString(int state) {
        switch (state) {
            case 0: {
                return "NEW";
            }
            case 2: {
                return "RINGING";
            }
            case 1: {
                return "DIALING";
            }
            case 4: {
                return "ACTIVE";
            }
            case 3: {
                return "HOLDING";
            }
            case 7: {
                return "DISCONNECTED";
            }
            case 9: {
                return "CONNECTING";
            }
            case 10: {
                return "DISCONNECTING";
            }
            case 8: {
                return "SELECT_PHONE_ACCOUNT";
            }
        }
        Log.w(Call.class, "Unknown state %d", state);
        return "UNKNOWN";
    }

    @Deprecated
    private final void $$robo$$android_telecom_Call$addListener(Listener listener) {
        this.registerCallback(listener);
    }

    @Deprecated
    private final void $$robo$$android_telecom_Call$removeListener(Listener listener) {
        this.unregisterCallback(listener);
    }

    private void $$robo$$android_telecom_Call$__constructor__(Phone phone, String telecomCallId, InCallAdapter inCallAdapter, String callingPackage, int targetSdkVersion) {
        this.mChildrenIds = new ArrayList<String>();
        this.mChildren = new ArrayList<Call>();
        this.mUnmodifiableChildren = Collections.unmodifiableList(this.mChildren);
        this.mCallbackRecords = new CopyOnWriteArrayList<CallbackRecord<Callback>>();
        this.mConferenceableCalls = new ArrayList<Call>();
        this.mUnmodifiableConferenceableCalls = Collections.unmodifiableList(this.mConferenceableCalls);
        this.mParentId = null;
        this.mCannedTextResponses = null;
        this.mPhone = phone;
        this.mTelecomCallId = telecomCallId;
        this.mInCallAdapter = inCallAdapter;
        this.mState = 0;
        this.mCallingPackage = callingPackage;
        this.mTargetSdkVersion = targetSdkVersion;
    }

    private void $$robo$$android_telecom_Call$__constructor__(Phone phone, String telecomCallId, InCallAdapter inCallAdapter, int state, String callingPackage, int targetSdkVersion) {
        this.mChildrenIds = new ArrayList<String>();
        this.mChildren = new ArrayList<Call>();
        this.mUnmodifiableChildren = Collections.unmodifiableList(this.mChildren);
        this.mCallbackRecords = new CopyOnWriteArrayList<CallbackRecord<Callback>>();
        this.mConferenceableCalls = new ArrayList<Call>();
        this.mUnmodifiableConferenceableCalls = Collections.unmodifiableList(this.mConferenceableCalls);
        this.mParentId = null;
        this.mCannedTextResponses = null;
        this.mPhone = phone;
        this.mTelecomCallId = telecomCallId;
        this.mInCallAdapter = inCallAdapter;
        this.mState = state;
        this.mCallingPackage = callingPackage;
        this.mTargetSdkVersion = targetSdkVersion;
    }

    private final String $$robo$$android_telecom_Call$internalGetCallId() {
        return this.mTelecomCallId;
    }

    private final void $$robo$$android_telecom_Call$internalUpdate(ParcelableCall parcelableCall, Map<String, Call> callIdMap) {
        List<String> childCallIds;
        boolean childrenChanged;
        String parentId;
        boolean parentChanged;
        int state;
        boolean stateChanged;
        boolean videoCallChanged;
        boolean detailsChanged;
        Details details = Details.createFromParcelableCall(parcelableCall);
        boolean bl = detailsChanged = !Objects.equals(this.mDetails, details);
        if (detailsChanged) {
            this.mDetails = details;
        }
        boolean cannedTextResponsesChanged = false;
        if (this.mCannedTextResponses == null && parcelableCall.getCannedSmsResponses() != null && !parcelableCall.getCannedSmsResponses().isEmpty()) {
            this.mCannedTextResponses = Collections.unmodifiableList(parcelableCall.getCannedSmsResponses());
            cannedTextResponsesChanged = true;
        }
        VideoCallImpl newVideoCallImpl = parcelableCall.getVideoCallImpl(this.mCallingPackage, this.mTargetSdkVersion);
        boolean bl2 = videoCallChanged = parcelableCall.isVideoCallProviderChanged() && !Objects.equals(this.mVideoCallImpl, newVideoCallImpl);
        if (videoCallChanged) {
            this.mVideoCallImpl = newVideoCallImpl;
        }
        if (this.mVideoCallImpl != null) {
            this.mVideoCallImpl.setVideoState(this.getDetails().getVideoState());
        }
        boolean bl3 = stateChanged = this.mState != (state = parcelableCall.getState());
        if (stateChanged) {
            this.mState = state;
        }
        boolean bl4 = parentChanged = !Objects.equals(this.mParentId, parentId = parcelableCall.getParentCallId());
        if (parentChanged) {
            this.mParentId = parentId;
        }
        boolean bl5 = childrenChanged = !Objects.equals(childCallIds = parcelableCall.getChildCallIds(), this.mChildrenIds);
        if (childrenChanged) {
            this.mChildrenIds.clear();
            this.mChildrenIds.addAll(parcelableCall.getChildCallIds());
            this.mChildrenCached = false;
        }
        List<String> conferenceableCallIds = parcelableCall.getConferenceableCallIds();
        ArrayList<Call> conferenceableCalls = new ArrayList<Call>(conferenceableCallIds.size());
        for (String otherId : conferenceableCallIds) {
            if (!callIdMap.containsKey(otherId)) continue;
            conferenceableCalls.add(callIdMap.get(otherId));
        }
        if (!Objects.equals(this.mConferenceableCalls, conferenceableCalls)) {
            this.mConferenceableCalls.clear();
            this.mConferenceableCalls.addAll(conferenceableCalls);
            this.fireConferenceableCallsChanged();
        }
        boolean isRttChanged = false;
        boolean rttModeChanged = false;
        if (parcelableCall.getParcelableRttCall() != null && parcelableCall.getIsRttCallChanged()) {
            ParcelableRttCall parcelableRttCall = parcelableCall.getParcelableRttCall();
            InputStreamReader receiveStream = new InputStreamReader((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(parcelableRttCall.getReceiveStream()), StandardCharsets.UTF_8);
            OutputStreamWriter transmitStream = new OutputStreamWriter((OutputStream)new ParcelFileDescriptor.AutoCloseOutputStream(parcelableRttCall.getTransmitStream()), StandardCharsets.UTF_8);
            RttCall newRttCall = new RttCall(this.mTelecomCallId, receiveStream, transmitStream, parcelableRttCall.getRttMode(), this.mInCallAdapter);
            if (this.mRttCall == null) {
                isRttChanged = true;
            } else if (this.mRttCall.getRttAudioMode() != newRttCall.getRttAudioMode()) {
                rttModeChanged = true;
            }
            this.mRttCall = newRttCall;
        } else if (this.mRttCall != null && parcelableCall.getParcelableRttCall() == null && parcelableCall.getIsRttCallChanged()) {
            isRttChanged = true;
            this.mRttCall = null;
        }
        if (stateChanged) {
            this.fireStateChanged(this.mState);
        }
        if (detailsChanged) {
            this.fireDetailsChanged(this.mDetails);
        }
        if (cannedTextResponsesChanged) {
            this.fireCannedTextResponsesLoaded(this.mCannedTextResponses);
        }
        if (videoCallChanged) {
            this.fireVideoCallChanged(this.mVideoCallImpl);
        }
        if (parentChanged) {
            this.fireParentChanged(this.getParent());
        }
        if (childrenChanged) {
            this.fireChildrenChanged(this.getChildren());
        }
        if (isRttChanged) {
            this.fireOnIsRttChanged(this.mRttCall != null, this.mRttCall);
        }
        if (rttModeChanged) {
            this.fireOnRttModeChanged(this.mRttCall.getRttAudioMode());
        }
        if (this.mState == 7) {
            this.fireCallDestroyed();
        }
    }

    private final void $$robo$$android_telecom_Call$internalSetPostDialWait(String remaining) {
        this.mRemainingPostDialSequence = remaining;
        this.firePostDialWait(this.mRemainingPostDialSequence);
    }

    private final void $$robo$$android_telecom_Call$internalSetDisconnected() {
        if (this.mState != 7) {
            this.mState = 7;
            this.fireStateChanged(this.mState);
            this.fireCallDestroyed();
        }
    }

    private final void $$robo$$android_telecom_Call$internalOnConnectionEvent(String event, Bundle extras) {
        this.fireOnConnectionEvent(event, extras);
    }

    private final void $$robo$$android_telecom_Call$internalOnRttUpgradeRequest(int requestId) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttRequest(call, requestId));
        }
    }

    private final void $$robo$$android_telecom_Call$internalOnRttInitiationFailure(int reason) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttInitiationFailure(call, reason));
        }
    }

    private final void $$robo$$android_telecom_Call$fireStateChanged(int newState) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, newState){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ int val$newState;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_1$__constructor__(Call this$0, Callback callback, Call call, int n) {
                }

                private final void $$robo$$android_telecom_Call_1$run() {
                    this.val$callback.onStateChanged(this.val$call, this.val$newState);
                }

                private void __constructor__(Call call, Callback callback, Call call2, int n) {
                    this.$$robo$$android_telecom_Call_1$__constructor__(call, callback, call2, n);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$newState = n;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_1$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call int ), 0, this, call, callback, call2, n);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireParentChanged(Call newParent) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, newParent){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ Call val$newParent;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_2$__constructor__(Call this$0, Callback callback, Call call, Call call2) {
                }

                private final void $$robo$$android_telecom_Call_2$run() {
                    this.val$callback.onParentChanged(this.val$call, this.val$newParent);
                }

                private void __constructor__(Call call, Callback callback, Call call2, Call call3) {
                    this.$$robo$$android_telecom_Call_2$__constructor__(call, callback, call2, call3);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$newParent = call3;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_2$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call android.telecom.Call ), 0, this, call, callback, call2, call3);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_2$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireChildrenChanged(List<Call> children) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, children){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ List val$children;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_3$__constructor__(Call this$0, Callback callback, Call call, List list) {
                }

                private final void $$robo$$android_telecom_Call_3$run() {
                    this.val$callback.onChildrenChanged(this.val$call, this.val$children);
                }

                private void __constructor__(Call call, Callback callback, Call call2, List list) {
                    this.$$robo$$android_telecom_Call_3$__constructor__(call, callback, call2, list);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$children = list;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_3$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call java.util.List ), 0, this, call, callback, call2, list);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_3$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireDetailsChanged(Details details) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, details){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ Details val$details;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_4$__constructor__(Call this$0, Callback callback, Call call, Details details) {
                }

                private final void $$robo$$android_telecom_Call_4$run() {
                    this.val$callback.onDetailsChanged(this.val$call, this.val$details);
                }

                private void __constructor__(Call call, Callback callback, Call call2, Details details) {
                    this.$$robo$$android_telecom_Call_4$__constructor__(call, callback, call2, details);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$details = details;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_4$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call android.telecom.Call$Details ), 0, this, call, callback, call2, details);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_4$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireCannedTextResponsesLoaded(List<String> cannedTextResponses) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, cannedTextResponses){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ List val$cannedTextResponses;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_5$__constructor__(Call this$0, Callback callback, Call call, List list) {
                }

                private final void $$robo$$android_telecom_Call_5$run() {
                    this.val$callback.onCannedTextResponsesLoaded(this.val$call, this.val$cannedTextResponses);
                }

                private void __constructor__(Call call, Callback callback, Call call2, List list) {
                    this.$$robo$$android_telecom_Call_5$__constructor__(call, callback, call2, list);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$cannedTextResponses = list;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_5$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call java.util.List ), 0, this, call, callback, call2, list);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_5$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireVideoCallChanged(InCallService.VideoCall videoCall) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, videoCall){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ InCallService.VideoCall val$videoCall;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_6$__constructor__(Call this$0, Callback callback, Call call, InCallService.VideoCall videoCall) {
                }

                private final void $$robo$$android_telecom_Call_6$run() {
                    this.val$callback.onVideoCallChanged(this.val$call, this.val$videoCall);
                }

                private void __constructor__(Call call, Callback callback, Call call2, InCallService.VideoCall videoCall) {
                    this.$$robo$$android_telecom_Call_6$__constructor__(call, callback, call2, videoCall);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$videoCall = videoCall;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_6$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call android.telecom.InCallService$VideoCall ), 0, this, call, callback, call2, videoCall);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_6$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$firePostDialWait(String remainingPostDialSequence) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, remainingPostDialSequence){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ String val$remainingPostDialSequence;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_7$__constructor__(Call this$0, Callback callback, Call call, String string2) {
                }

                private final void $$robo$$android_telecom_Call_7$run() {
                    this.val$callback.onPostDialWait(this.val$call, this.val$remainingPostDialSequence);
                }

                private void __constructor__(Call call, Callback callback, Call call2, String string2) {
                    this.$$robo$$android_telecom_Call_7$__constructor__(call, callback, call2, string2);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$remainingPostDialSequence = string2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_7$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call java.lang.String ), 0, this, call, callback, call2, string2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_7$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireCallDestroyed() {
        Call call = this;
        if (this.mCallbackRecords.isEmpty()) {
            this.mPhone.internalRemoveCall(call);
        }
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, record){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ CallbackRecord val$record;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_8$__constructor__(Call this$0, Callback callback, Call call, CallbackRecord callbackRecord) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private final void $$robo$$android_telecom_Call_8$run() {
                    boolean isFinalRemoval = false;
                    RuntimeException toThrow = null;
                    try {
                        this.val$callback.onCallDestroyed(this.val$call);
                    }
                    catch (RuntimeException e) {
                        toThrow = e;
                    }
                    Call call = this.this$0;
                    synchronized (call) {
                        this.this$0.mCallbackRecords.remove(this.val$record);
                        if (this.this$0.mCallbackRecords.isEmpty()) {
                            isFinalRemoval = true;
                        }
                    }
                    if (isFinalRemoval) {
                        this.this$0.mPhone.internalRemoveCall(this.val$call);
                    }
                    if (toThrow != null) {
                        throw toThrow;
                    }
                }

                private void __constructor__(Call call, Callback callback, Call call2, CallbackRecord callbackRecord) {
                    this.$$robo$$android_telecom_Call_8$__constructor__(call, callback, call2, callbackRecord);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$record = callbackRecord;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_8$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call android.telecom.CallbackRecord ), 0, this, call, callback, call2, callbackRecord);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_8$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireConferenceableCallsChanged() {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_9$__constructor__(Call this$0, Callback callback, Call call) {
                }

                private final void $$robo$$android_telecom_Call_9$run() {
                    this.val$callback.onConferenceableCallsChanged(this.val$call, this.this$0.mUnmodifiableConferenceableCalls);
                }

                private void __constructor__(Call call, Callback callback, Call call2) {
                    this.$$robo$$android_telecom_Call_9$__constructor__(call, callback, call2);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_9$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call ), 0, this, call, callback, call2);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_9$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireOnConnectionEvent(String event, Bundle extras) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(new Runnable(this, callback, call, event, extras){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Callback val$callback;
                /* synthetic */ Call val$call;
                /* synthetic */ String val$event;
                /* synthetic */ Bundle val$extras;
                /* synthetic */ Call this$0;

                private void $$robo$$android_telecom_Call_10$__constructor__(Call this$0, Callback callback, Call call, String string2, Bundle bundle) {
                }

                private final void $$robo$$android_telecom_Call_10$run() {
                    this.val$callback.onConnectionEvent(this.val$call, this.val$event, this.val$extras);
                }

                private void __constructor__(Call call, Callback callback, Call call2, String string2, Bundle bundle) {
                    this.$$robo$$android_telecom_Call_10$__constructor__(call, callback, call2, string2, bundle);
                }
                {
                    this.this$0 = call;
                    this.val$callback = callback;
                    this.val$call = call2;
                    this.val$event = string2;
                    this.val$extras = bundle;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_10$__constructor__(android.telecom.Call android.telecom.Call$Callback android.telecom.Call java.lang.String android.os.Bundle ), 0, this, call, callback, call2, string2, bundle);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_telecom_Call_10$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }
    }

    private final void $$robo$$android_telecom_Call$fireOnIsRttChanged(boolean enabled, RttCall rttCall) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttStatusChanged(call, enabled, rttCall));
        }
    }

    private final void $$robo$$android_telecom_Call$fireOnRttModeChanged(int mode) {
        for (CallbackRecord<Callback> record : this.mCallbackRecords) {
            Call call = this;
            Callback callback = record.getCallback();
            record.getHandler().post(() -> callback.onRttModeChanged(call, mode));
        }
    }

    private static final boolean $$robo$$android_telecom_Call$areBundlesEqual(Bundle bundle, Bundle newBundle) {
        if (bundle == null || newBundle == null) {
            return bundle == newBundle;
        }
        if (bundle.size() != newBundle.size()) {
            return false;
        }
        for (String key : bundle.keySet()) {
            Object newValue;
            Object value;
            if (key == null || Objects.equals(value = bundle.get(key), newValue = newBundle.get(key))) continue;
            return false;
        }
        return true;
    }

    public String getRemainingPostDialSequence() {
        return InvokeDynamicSupport.bootstrap("getRemainingPostDialSequence", $$robo$$android_telecom_Call$getRemainingPostDialSequence(), 0, this);
    }

    public void answer(int n) {
        InvokeDynamicSupport.bootstrap("answer", $$robo$$android_telecom_Call$answer(int ), 0, this, n);
    }

    public void reject(boolean bl, String string2) {
        InvokeDynamicSupport.bootstrap("reject", $$robo$$android_telecom_Call$reject(boolean java.lang.String ), 0, this, bl, string2);
    }

    public void disconnect() {
        InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_telecom_Call$disconnect(), 0, this);
    }

    public void hold() {
        InvokeDynamicSupport.bootstrap("hold", $$robo$$android_telecom_Call$hold(), 0, this);
    }

    public void unhold() {
        InvokeDynamicSupport.bootstrap("unhold", $$robo$$android_telecom_Call$unhold(), 0, this);
    }

    public void playDtmfTone(char c) {
        InvokeDynamicSupport.bootstrap("playDtmfTone", $$robo$$android_telecom_Call$playDtmfTone(char ), 0, this, c);
    }

    public void stopDtmfTone() {
        InvokeDynamicSupport.bootstrap("stopDtmfTone", $$robo$$android_telecom_Call$stopDtmfTone(), 0, this);
    }

    public void postDialContinue(boolean bl) {
        InvokeDynamicSupport.bootstrap("postDialContinue", $$robo$$android_telecom_Call$postDialContinue(boolean ), 0, this, bl);
    }

    public void phoneAccountSelected(PhoneAccountHandle phoneAccountHandle, boolean bl) {
        InvokeDynamicSupport.bootstrap("phoneAccountSelected", $$robo$$android_telecom_Call$phoneAccountSelected(android.telecom.PhoneAccountHandle boolean ), 0, this, phoneAccountHandle, bl);
    }

    public void conference(Call call) {
        InvokeDynamicSupport.bootstrap("conference", $$robo$$android_telecom_Call$conference(android.telecom.Call ), 0, this, call);
    }

    public void splitFromConference() {
        InvokeDynamicSupport.bootstrap("splitFromConference", $$robo$$android_telecom_Call$splitFromConference(), 0, this);
    }

    public void mergeConference() {
        InvokeDynamicSupport.bootstrap("mergeConference", $$robo$$android_telecom_Call$mergeConference(), 0, this);
    }

    public void swapConference() {
        InvokeDynamicSupport.bootstrap("swapConference", $$robo$$android_telecom_Call$swapConference(), 0, this);
    }

    public void pullExternalCall() {
        InvokeDynamicSupport.bootstrap("pullExternalCall", $$robo$$android_telecom_Call$pullExternalCall(), 0, this);
    }

    public void sendCallEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("sendCallEvent", $$robo$$android_telecom_Call$sendCallEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    public void sendRttRequest() {
        InvokeDynamicSupport.bootstrap("sendRttRequest", $$robo$$android_telecom_Call$sendRttRequest(), 0, this);
    }

    public void respondToRttRequest(int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("respondToRttRequest", $$robo$$android_telecom_Call$respondToRttRequest(int boolean ), 0, this, n, bl);
    }

    public void stopRtt() {
        InvokeDynamicSupport.bootstrap("stopRtt", $$robo$$android_telecom_Call$stopRtt(), 0, this);
    }

    public void putExtras(Bundle bundle) {
        InvokeDynamicSupport.bootstrap("putExtras", $$robo$$android_telecom_Call$putExtras(android.os.Bundle ), 0, this, bundle);
    }

    public void putExtra(String string2, boolean bl) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Call$putExtra(java.lang.String boolean ), 0, this, string2, bl);
    }

    public void putExtra(String string2, int n) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Call$putExtra(java.lang.String int ), 0, this, string2, n);
    }

    public void putExtra(String string2, String string3) {
        InvokeDynamicSupport.bootstrap("putExtra", $$robo$$android_telecom_Call$putExtra(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public void removeExtras(List<String> list) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_Call$removeExtras(java.util.List<java.lang.String> ), 0, this, list);
    }

    public void removeExtras(String ... stringArray) {
        InvokeDynamicSupport.bootstrap("removeExtras", $$robo$$android_telecom_Call$removeExtras(java.lang.String[] ), 0, this, stringArray);
    }

    public Call getParent() {
        return InvokeDynamicSupport.bootstrap("getParent", $$robo$$android_telecom_Call$getParent(), 0, this);
    }

    public List<Call> getChildren() {
        return InvokeDynamicSupport.bootstrap("getChildren", $$robo$$android_telecom_Call$getChildren(), 0, this);
    }

    public List<Call> getConferenceableCalls() {
        return InvokeDynamicSupport.bootstrap("getConferenceableCalls", $$robo$$android_telecom_Call$getConferenceableCalls(), 0, this);
    }

    public int getState() {
        return (int)InvokeDynamicSupport.bootstrap("getState", $$robo$$android_telecom_Call$getState(), 0, this);
    }

    public List<String> getCannedTextResponses() {
        return InvokeDynamicSupport.bootstrap("getCannedTextResponses", $$robo$$android_telecom_Call$getCannedTextResponses(), 0, this);
    }

    public InCallService.VideoCall getVideoCall() {
        return InvokeDynamicSupport.bootstrap("getVideoCall", $$robo$$android_telecom_Call$getVideoCall(), 0, this);
    }

    public Details getDetails() {
        return InvokeDynamicSupport.bootstrap("getDetails", $$robo$$android_telecom_Call$getDetails(), 0, this);
    }

    public RttCall getRttCall() {
        return InvokeDynamicSupport.bootstrap("getRttCall", $$robo$$android_telecom_Call$getRttCall(), 0, this);
    }

    public boolean isRttActive() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRttActive", $$robo$$android_telecom_Call$isRttActive(), 0, this);
    }

    public void registerCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_Call$registerCallback(android.telecom.Call$Callback ), 0, this, callback);
    }

    public void registerCallback(Callback callback, Handler handler) {
        InvokeDynamicSupport.bootstrap("registerCallback", $$robo$$android_telecom_Call$registerCallback(android.telecom.Call$Callback android.os.Handler ), 0, this, callback, handler);
    }

    public void unregisterCallback(Callback callback) {
        InvokeDynamicSupport.bootstrap("unregisterCallback", $$robo$$android_telecom_Call$unregisterCallback(android.telecom.Call$Callback ), 0, this, callback);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_Call$toString(), 0, this);
    }

    private static String stateToString(int n) {
        return InvokeDynamicSupport.bootstrapStatic("stateToString", $$robo$$android_telecom_Call$stateToString(int ), 0, (int)n);
    }

    @Deprecated
    public void addListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("addListener", $$robo$$android_telecom_Call$addListener(android.telecom.Call$Listener ), 0, this, listener);
    }

    @Deprecated
    public void removeListener(Listener listener) {
        InvokeDynamicSupport.bootstrap("removeListener", $$robo$$android_telecom_Call$removeListener(android.telecom.Call$Listener ), 0, this, listener);
    }

    private void __constructor__(Phone phone, String string2, InCallAdapter inCallAdapter, String string3, int n) {
        this.$$robo$$android_telecom_Call$__constructor__(phone, string2, inCallAdapter, string3, n);
    }

    Call(Phone phone, String string2, InCallAdapter inCallAdapter, String string3, int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call$__constructor__(android.telecom.Phone java.lang.String android.telecom.InCallAdapter java.lang.String int ), 0, this, phone, string2, inCallAdapter, string3, n);
    }

    private void __constructor__(Phone phone, String string2, InCallAdapter inCallAdapter, int n, String string3, int n2) {
        this.$$robo$$android_telecom_Call$__constructor__(phone, string2, inCallAdapter, n, string3, n2);
    }

    Call(Phone phone, String string2, InCallAdapter inCallAdapter, int n, String string3, int n2) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call$__constructor__(android.telecom.Phone java.lang.String android.telecom.InCallAdapter int java.lang.String int ), 0, this, phone, string2, inCallAdapter, n, string3, n2);
    }

    String internalGetCallId() {
        return InvokeDynamicSupport.bootstrap("internalGetCallId", $$robo$$android_telecom_Call$internalGetCallId(), 0, this);
    }

    void internalUpdate(ParcelableCall parcelableCall, Map<String, Call> map) {
        InvokeDynamicSupport.bootstrap("internalUpdate", $$robo$$android_telecom_Call$internalUpdate(android.telecom.ParcelableCall java.util.Map<java.lang.String, android.telecom.Call> ), 0, this, parcelableCall, map);
    }

    void internalSetPostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("internalSetPostDialWait", $$robo$$android_telecom_Call$internalSetPostDialWait(java.lang.String ), 0, this, string2);
    }

    void internalSetDisconnected() {
        InvokeDynamicSupport.bootstrap("internalSetDisconnected", $$robo$$android_telecom_Call$internalSetDisconnected(), 0, this);
    }

    void internalOnConnectionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("internalOnConnectionEvent", $$robo$$android_telecom_Call$internalOnConnectionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    void internalOnRttUpgradeRequest(int n) {
        InvokeDynamicSupport.bootstrap("internalOnRttUpgradeRequest", $$robo$$android_telecom_Call$internalOnRttUpgradeRequest(int ), 0, this, n);
    }

    void internalOnRttInitiationFailure(int n) {
        InvokeDynamicSupport.bootstrap("internalOnRttInitiationFailure", $$robo$$android_telecom_Call$internalOnRttInitiationFailure(int ), 0, this, n);
    }

    private void fireStateChanged(int n) {
        InvokeDynamicSupport.bootstrap("fireStateChanged", $$robo$$android_telecom_Call$fireStateChanged(int ), 0, this, n);
    }

    private void fireParentChanged(Call call) {
        InvokeDynamicSupport.bootstrap("fireParentChanged", $$robo$$android_telecom_Call$fireParentChanged(android.telecom.Call ), 0, this, call);
    }

    private void fireChildrenChanged(List<Call> list) {
        InvokeDynamicSupport.bootstrap("fireChildrenChanged", $$robo$$android_telecom_Call$fireChildrenChanged(java.util.List<android.telecom.Call> ), 0, this, list);
    }

    private void fireDetailsChanged(Details details) {
        InvokeDynamicSupport.bootstrap("fireDetailsChanged", $$robo$$android_telecom_Call$fireDetailsChanged(android.telecom.Call$Details ), 0, this, details);
    }

    private void fireCannedTextResponsesLoaded(List<String> list) {
        InvokeDynamicSupport.bootstrap("fireCannedTextResponsesLoaded", $$robo$$android_telecom_Call$fireCannedTextResponsesLoaded(java.util.List<java.lang.String> ), 0, this, list);
    }

    private void fireVideoCallChanged(InCallService.VideoCall videoCall) {
        InvokeDynamicSupport.bootstrap("fireVideoCallChanged", $$robo$$android_telecom_Call$fireVideoCallChanged(android.telecom.InCallService$VideoCall ), 0, this, videoCall);
    }

    private void firePostDialWait(String string2) {
        InvokeDynamicSupport.bootstrap("firePostDialWait", $$robo$$android_telecom_Call$firePostDialWait(java.lang.String ), 0, this, string2);
    }

    private void fireCallDestroyed() {
        InvokeDynamicSupport.bootstrap("fireCallDestroyed", $$robo$$android_telecom_Call$fireCallDestroyed(), 0, this);
    }

    private void fireConferenceableCallsChanged() {
        InvokeDynamicSupport.bootstrap("fireConferenceableCallsChanged", $$robo$$android_telecom_Call$fireConferenceableCallsChanged(), 0, this);
    }

    private void fireOnConnectionEvent(String string2, Bundle bundle) {
        InvokeDynamicSupport.bootstrap("fireOnConnectionEvent", $$robo$$android_telecom_Call$fireOnConnectionEvent(java.lang.String android.os.Bundle ), 0, this, string2, bundle);
    }

    private void fireOnIsRttChanged(boolean bl, RttCall rttCall) {
        InvokeDynamicSupport.bootstrap("fireOnIsRttChanged", $$robo$$android_telecom_Call$fireOnIsRttChanged(boolean android.telecom.Call$RttCall ), 0, this, bl, rttCall);
    }

    private void fireOnRttModeChanged(int n) {
        InvokeDynamicSupport.bootstrap("fireOnRttModeChanged", $$robo$$android_telecom_Call$fireOnRttModeChanged(int ), 0, this, n);
    }

    private static boolean areBundlesEqual(Bundle bundle, Bundle bundle2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("areBundlesEqual", $$robo$$android_telecom_Call$areBundlesEqual(android.os.Bundle android.os.Bundle ), 0, (Bundle)bundle, (Bundle)bundle2);
    }

    public /* synthetic */ Call() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Call)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @Deprecated
    public static abstract class Listener
    extends Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Call_Listener$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Call_Listener$__constructor__();
        }

        public Listener() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_Listener$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Listener)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class RttCall
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int RTT_MODE_INVALID = 0;
        public static int RTT_MODE_FULL = 1;
        public static int RTT_MODE_HCO = 2;
        public static int RTT_MODE_VCO = 3;
        private static int READ_BUFFER_SIZE = 1000;
        private InputStreamReader mReceiveStream;
        private OutputStreamWriter mTransmitStream;
        private int mRttMode;
        private InCallAdapter mInCallAdapter;
        private String mTelecomCallId;
        private char[] mReadBuffer;

        private void $$robo$$android_telecom_Call_RttCall$__constructor__(String telecomCallId, InputStreamReader receiveStream, OutputStreamWriter transmitStream, int mode, InCallAdapter inCallAdapter) {
            this.mReadBuffer = new char[1000];
            this.mTelecomCallId = telecomCallId;
            this.mReceiveStream = receiveStream;
            this.mTransmitStream = transmitStream;
            this.mRttMode = mode;
            this.mInCallAdapter = inCallAdapter;
        }

        private final int $$robo$$android_telecom_Call_RttCall$getRttAudioMode() {
            return this.mRttMode;
        }

        private final void $$robo$$android_telecom_Call_RttCall$setRttMode(int mode) {
            this.mInCallAdapter.setRttMode(this.mTelecomCallId, mode);
        }

        private final void $$robo$$android_telecom_Call_RttCall$write(String input) throws IOException {
            this.mTransmitStream.write(input);
            this.mTransmitStream.flush();
        }

        private final String $$robo$$android_telecom_Call_RttCall$read() {
            try {
                int numRead = this.mReceiveStream.read(this.mReadBuffer, 0, 1000);
                if (numRead < 0) {
                    return null;
                }
                return new String(this.mReadBuffer, 0, numRead);
            }
            catch (IOException e) {
                Log.w(this, "Exception encountered when reading from InputStreamReader: %s", e);
                return null;
            }
        }

        private void __constructor__(String string2, InputStreamReader inputStreamReader, OutputStreamWriter outputStreamWriter, int n, InCallAdapter inCallAdapter) {
            this.$$robo$$android_telecom_Call_RttCall$__constructor__(string2, inputStreamReader, outputStreamWriter, n, inCallAdapter);
        }

        public RttCall(String string2, InputStreamReader inputStreamReader, OutputStreamWriter outputStreamWriter, int n, InCallAdapter inCallAdapter) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_RttCall$__constructor__(java.lang.String java.io.InputStreamReader java.io.OutputStreamWriter int android.telecom.InCallAdapter ), 0, this, string2, inputStreamReader, outputStreamWriter, n, inCallAdapter);
        }

        public int getRttAudioMode() {
            return (int)InvokeDynamicSupport.bootstrap("getRttAudioMode", $$robo$$android_telecom_Call_RttCall$getRttAudioMode(), 0, this);
        }

        public void setRttMode(int n) {
            InvokeDynamicSupport.bootstrap("setRttMode", $$robo$$android_telecom_Call_RttCall$setRttMode(int ), 0, this, n);
        }

        public void write(String string2) throws IOException {
            InvokeDynamicSupport.bootstrap("write", $$robo$$android_telecom_Call_RttCall$write(java.lang.String ), 0, this, string2);
        }

        public String read() {
            return InvokeDynamicSupport.bootstrap("read", $$robo$$android_telecom_Call_RttCall$read(), 0, this);
        }

        public /* synthetic */ RttCall() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RttCall)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(value={0L, 1L, 2L, 3L})
        public static @interface RttAudioMode {
        }
    }

    public static abstract class Callback
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_telecom_Call_Callback$__constructor__() {
        }

        private final void $$robo$$android_telecom_Call_Callback$onStateChanged(Call call, int state) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onParentChanged(Call call, Call parent) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onChildrenChanged(Call call, List<Call> children) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onDetailsChanged(Call call, Details details) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onCannedTextResponsesLoaded(Call call, List<String> cannedTextResponses) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onPostDialWait(Call call, String remainingPostDialSequence) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onVideoCallChanged(Call call, InCallService.VideoCall videoCall) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onCallDestroyed(Call call) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onConferenceableCallsChanged(Call call, List<Call> conferenceableCalls) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onConnectionEvent(Call call, String event, Bundle extras) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onRttModeChanged(Call call, int mode) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onRttStatusChanged(Call call, boolean enabled, RttCall rttCall) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onRttRequest(Call call, int id2) {
        }

        private final void $$robo$$android_telecom_Call_Callback$onRttInitiationFailure(Call call, int reason) {
        }

        private void __constructor__() {
            this.$$robo$$android_telecom_Call_Callback$__constructor__();
        }

        public Callback() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_Callback$__constructor__(), 0, this);
        }

        public void onStateChanged(Call call, int n) {
            InvokeDynamicSupport.bootstrap("onStateChanged", $$robo$$android_telecom_Call_Callback$onStateChanged(android.telecom.Call int ), 0, this, call, n);
        }

        public void onParentChanged(Call call, Call call2) {
            InvokeDynamicSupport.bootstrap("onParentChanged", $$robo$$android_telecom_Call_Callback$onParentChanged(android.telecom.Call android.telecom.Call ), 0, this, call, call2);
        }

        public void onChildrenChanged(Call call, List<Call> list) {
            InvokeDynamicSupport.bootstrap("onChildrenChanged", $$robo$$android_telecom_Call_Callback$onChildrenChanged(android.telecom.Call java.util.List<android.telecom.Call> ), 0, this, call, list);
        }

        public void onDetailsChanged(Call call, Details details) {
            InvokeDynamicSupport.bootstrap("onDetailsChanged", $$robo$$android_telecom_Call_Callback$onDetailsChanged(android.telecom.Call android.telecom.Call$Details ), 0, this, call, details);
        }

        public void onCannedTextResponsesLoaded(Call call, List<String> list) {
            InvokeDynamicSupport.bootstrap("onCannedTextResponsesLoaded", $$robo$$android_telecom_Call_Callback$onCannedTextResponsesLoaded(android.telecom.Call java.util.List<java.lang.String> ), 0, this, call, list);
        }

        public void onPostDialWait(Call call, String string2) {
            InvokeDynamicSupport.bootstrap("onPostDialWait", $$robo$$android_telecom_Call_Callback$onPostDialWait(android.telecom.Call java.lang.String ), 0, this, call, string2);
        }

        public void onVideoCallChanged(Call call, InCallService.VideoCall videoCall) {
            InvokeDynamicSupport.bootstrap("onVideoCallChanged", $$robo$$android_telecom_Call_Callback$onVideoCallChanged(android.telecom.Call android.telecom.InCallService$VideoCall ), 0, this, call, videoCall);
        }

        public void onCallDestroyed(Call call) {
            InvokeDynamicSupport.bootstrap("onCallDestroyed", $$robo$$android_telecom_Call_Callback$onCallDestroyed(android.telecom.Call ), 0, this, call);
        }

        public void onConferenceableCallsChanged(Call call, List<Call> list) {
            InvokeDynamicSupport.bootstrap("onConferenceableCallsChanged", $$robo$$android_telecom_Call_Callback$onConferenceableCallsChanged(android.telecom.Call java.util.List<android.telecom.Call> ), 0, this, call, list);
        }

        public void onConnectionEvent(Call call, String string2, Bundle bundle) {
            InvokeDynamicSupport.bootstrap("onConnectionEvent", $$robo$$android_telecom_Call_Callback$onConnectionEvent(android.telecom.Call java.lang.String android.os.Bundle ), 0, this, call, string2, bundle);
        }

        public void onRttModeChanged(Call call, int n) {
            InvokeDynamicSupport.bootstrap("onRttModeChanged", $$robo$$android_telecom_Call_Callback$onRttModeChanged(android.telecom.Call int ), 0, this, call, n);
        }

        public void onRttStatusChanged(Call call, boolean bl, RttCall rttCall) {
            InvokeDynamicSupport.bootstrap("onRttStatusChanged", $$robo$$android_telecom_Call_Callback$onRttStatusChanged(android.telecom.Call boolean android.telecom.Call$RttCall ), 0, this, call, bl, rttCall);
        }

        public void onRttRequest(Call call, int n) {
            InvokeDynamicSupport.bootstrap("onRttRequest", $$robo$$android_telecom_Call_Callback$onRttRequest(android.telecom.Call int ), 0, this, call, n);
        }

        public void onRttInitiationFailure(Call call, int n) {
            InvokeDynamicSupport.bootstrap("onRttInitiationFailure", $$robo$$android_telecom_Call_Callback$onRttInitiationFailure(android.telecom.Call int ), 0, this, call, n);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class Details
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int CAPABILITY_HOLD = 1;
        public static int CAPABILITY_SUPPORT_HOLD = 2;
        public static int CAPABILITY_MERGE_CONFERENCE = 4;
        public static int CAPABILITY_SWAP_CONFERENCE = 8;
        public static int CAPABILITY_UNUSED_1 = 16;
        public static int CAPABILITY_RESPOND_VIA_TEXT = 32;
        public static int CAPABILITY_MUTE = 64;
        public static int CAPABILITY_MANAGE_CONFERENCE = 128;
        public static int CAPABILITY_SUPPORTS_VT_LOCAL_RX = 256;
        public static int CAPABILITY_SUPPORTS_VT_LOCAL_TX = 512;
        public static int CAPABILITY_SUPPORTS_VT_LOCAL_BIDIRECTIONAL = 768;
        public static int CAPABILITY_SUPPORTS_VT_REMOTE_RX = 1024;
        public static int CAPABILITY_SUPPORTS_VT_REMOTE_TX = 2048;
        public static int CAPABILITY_SUPPORTS_VT_REMOTE_BIDIRECTIONAL = 3072;
        public static int CAPABILITY_SEPARATE_FROM_CONFERENCE = 4096;
        public static int CAPABILITY_DISCONNECT_FROM_CONFERENCE = 8192;
        public static int CAPABILITY_SPEED_UP_MT_AUDIO = 262144;
        public static int CAPABILITY_CAN_UPGRADE_TO_VIDEO = 524288;
        public static int CAPABILITY_CAN_PAUSE_VIDEO = 0x100000;
        public static int CAPABILITY_CAN_SEND_RESPONSE_VIA_CONNECTION = 0x200000;
        public static int CAPABILITY_CANNOT_DOWNGRADE_VIDEO_TO_AUDIO = 0x400000;
        public static int CAPABILITY_CAN_PULL_CALL = 0x800000;
        public static int PROPERTY_CONFERENCE = 1;
        public static int PROPERTY_GENERIC_CONFERENCE = 2;
        public static int PROPERTY_EMERGENCY_CALLBACK_MODE = 4;
        public static int PROPERTY_WIFI = 8;
        public static int PROPERTY_HIGH_DEF_AUDIO = 16;
        public static int PROPERTY_ENTERPRISE_CALL = 32;
        public static int PROPERTY_IS_EXTERNAL_CALL = 64;
        public static int PROPERTY_HAS_CDMA_VOICE_PRIVACY = 128;
        public static int PROPERTY_SELF_MANAGED = 256;
        private String mTelecomCallId;
        private Uri mHandle;
        private int mHandlePresentation;
        private String mCallerDisplayName;
        private int mCallerDisplayNamePresentation;
        private PhoneAccountHandle mAccountHandle;
        private int mCallCapabilities;
        private int mCallProperties;
        private int mSupportedAudioRoutes = 15;
        private DisconnectCause mDisconnectCause;
        private long mConnectTimeMillis;
        private GatewayInfo mGatewayInfo;
        private int mVideoState;
        private StatusHints mStatusHints;
        private Bundle mExtras;
        private Bundle mIntentExtras;
        private long mCreationTimeMillis;

        private static final boolean $$robo$$android_telecom_Call_Details$can(int capabilities, int capability) {
            return (capabilities & capability) == capability;
        }

        private final boolean $$robo$$android_telecom_Call_Details$can(int capability) {
            return Details.can(this.mCallCapabilities, capability);
        }

        private static final String $$robo$$android_telecom_Call_Details$capabilitiesToString(int capabilities) {
            StringBuilder builder = new StringBuilder();
            builder.append("[Capabilities:");
            if (Details.can(capabilities, 1)) {
                builder.append(" CAPABILITY_HOLD");
            }
            if (Details.can(capabilities, 2)) {
                builder.append(" CAPABILITY_SUPPORT_HOLD");
            }
            if (Details.can(capabilities, 4)) {
                builder.append(" CAPABILITY_MERGE_CONFERENCE");
            }
            if (Details.can(capabilities, 8)) {
                builder.append(" CAPABILITY_SWAP_CONFERENCE");
            }
            if (Details.can(capabilities, 32)) {
                builder.append(" CAPABILITY_RESPOND_VIA_TEXT");
            }
            if (Details.can(capabilities, 64)) {
                builder.append(" CAPABILITY_MUTE");
            }
            if (Details.can(capabilities, 128)) {
                builder.append(" CAPABILITY_MANAGE_CONFERENCE");
            }
            if (Details.can(capabilities, 256)) {
                builder.append(" CAPABILITY_SUPPORTS_VT_LOCAL_RX");
            }
            if (Details.can(capabilities, 512)) {
                builder.append(" CAPABILITY_SUPPORTS_VT_LOCAL_TX");
            }
            if (Details.can(capabilities, 768)) {
                builder.append(" CAPABILITY_SUPPORTS_VT_LOCAL_BIDIRECTIONAL");
            }
            if (Details.can(capabilities, 1024)) {
                builder.append(" CAPABILITY_SUPPORTS_VT_REMOTE_RX");
            }
            if (Details.can(capabilities, 2048)) {
                builder.append(" CAPABILITY_SUPPORTS_VT_REMOTE_TX");
            }
            if (Details.can(capabilities, 0x400000)) {
                builder.append(" CAPABILITY_CANNOT_DOWNGRADE_VIDEO_TO_AUDIO");
            }
            if (Details.can(capabilities, 3072)) {
                builder.append(" CAPABILITY_SUPPORTS_VT_REMOTE_BIDIRECTIONAL");
            }
            if (Details.can(capabilities, 262144)) {
                builder.append(" CAPABILITY_SPEED_UP_MT_AUDIO");
            }
            if (Details.can(capabilities, 524288)) {
                builder.append(" CAPABILITY_CAN_UPGRADE_TO_VIDEO");
            }
            if (Details.can(capabilities, 0x100000)) {
                builder.append(" CAPABILITY_CAN_PAUSE_VIDEO");
            }
            if (Details.can(capabilities, 0x800000)) {
                builder.append(" CAPABILITY_CAN_PULL_CALL");
            }
            builder.append("]");
            return builder.toString();
        }

        private static final boolean $$robo$$android_telecom_Call_Details$hasProperty(int properties, int property) {
            return (properties & property) == property;
        }

        private final boolean $$robo$$android_telecom_Call_Details$hasProperty(int property) {
            return Details.hasProperty(this.mCallProperties, property);
        }

        private static final String $$robo$$android_telecom_Call_Details$propertiesToString(int properties) {
            StringBuilder builder = new StringBuilder();
            builder.append("[Properties:");
            if (Details.hasProperty(properties, 1)) {
                builder.append(" PROPERTY_CONFERENCE");
            }
            if (Details.hasProperty(properties, 2)) {
                builder.append(" PROPERTY_GENERIC_CONFERENCE");
            }
            if (Details.hasProperty(properties, 8)) {
                builder.append(" PROPERTY_WIFI");
            }
            if (Details.hasProperty(properties, 16)) {
                builder.append(" PROPERTY_HIGH_DEF_AUDIO");
            }
            if (Details.hasProperty(properties, 4)) {
                builder.append(" PROPERTY_EMERGENCY_CALLBACK_MODE");
            }
            if (Details.hasProperty(properties, 64)) {
                builder.append(" PROPERTY_IS_EXTERNAL_CALL");
            }
            if (Details.hasProperty(properties, 128)) {
                builder.append(" PROPERTY_HAS_CDMA_VOICE_PRIVACY");
            }
            builder.append("]");
            return builder.toString();
        }

        private final String $$robo$$android_telecom_Call_Details$getTelecomCallId() {
            return this.mTelecomCallId;
        }

        private final Uri $$robo$$android_telecom_Call_Details$getHandle() {
            return this.mHandle;
        }

        private final int $$robo$$android_telecom_Call_Details$getHandlePresentation() {
            return this.mHandlePresentation;
        }

        private final String $$robo$$android_telecom_Call_Details$getCallerDisplayName() {
            return this.mCallerDisplayName;
        }

        private final int $$robo$$android_telecom_Call_Details$getCallerDisplayNamePresentation() {
            return this.mCallerDisplayNamePresentation;
        }

        private final PhoneAccountHandle $$robo$$android_telecom_Call_Details$getAccountHandle() {
            return this.mAccountHandle;
        }

        private final int $$robo$$android_telecom_Call_Details$getCallCapabilities() {
            return this.mCallCapabilities;
        }

        private final int $$robo$$android_telecom_Call_Details$getCallProperties() {
            return this.mCallProperties;
        }

        private final int $$robo$$android_telecom_Call_Details$getSupportedAudioRoutes() {
            return 15;
        }

        private final DisconnectCause $$robo$$android_telecom_Call_Details$getDisconnectCause() {
            return this.mDisconnectCause;
        }

        private final long $$robo$$android_telecom_Call_Details$getConnectTimeMillis() {
            return this.mConnectTimeMillis;
        }

        private final GatewayInfo $$robo$$android_telecom_Call_Details$getGatewayInfo() {
            return this.mGatewayInfo;
        }

        private final int $$robo$$android_telecom_Call_Details$getVideoState() {
            return this.mVideoState;
        }

        private final StatusHints $$robo$$android_telecom_Call_Details$getStatusHints() {
            return this.mStatusHints;
        }

        private final Bundle $$robo$$android_telecom_Call_Details$getExtras() {
            return this.mExtras;
        }

        private final Bundle $$robo$$android_telecom_Call_Details$getIntentExtras() {
            return this.mIntentExtras;
        }

        private final long $$robo$$android_telecom_Call_Details$getCreationTimeMillis() {
            return this.mCreationTimeMillis;
        }

        private final boolean $$robo$$android_telecom_Call_Details$equals(Object o) {
            if (o instanceof Details) {
                Details d = (Details)o;
                return Objects.equals(this.mHandle, d.mHandle) && Objects.equals(this.mHandlePresentation, d.mHandlePresentation) && Objects.equals(this.mCallerDisplayName, d.mCallerDisplayName) && Objects.equals(this.mCallerDisplayNamePresentation, d.mCallerDisplayNamePresentation) && Objects.equals(this.mAccountHandle, d.mAccountHandle) && Objects.equals(this.mCallCapabilities, d.mCallCapabilities) && Objects.equals(this.mCallProperties, d.mCallProperties) && Objects.equals(this.mDisconnectCause, d.mDisconnectCause) && Objects.equals(this.mConnectTimeMillis, d.mConnectTimeMillis) && Objects.equals(this.mGatewayInfo, d.mGatewayInfo) && Objects.equals(this.mVideoState, d.mVideoState) && Objects.equals(this.mStatusHints, d.mStatusHints) && Call.areBundlesEqual(this.mExtras, d.mExtras) && Call.areBundlesEqual(this.mIntentExtras, d.mIntentExtras) && Objects.equals(this.mCreationTimeMillis, d.mCreationTimeMillis);
            }
            return false;
        }

        private final int $$robo$$android_telecom_Call_Details$hashCode() {
            return Objects.hash(this.mHandle, this.mHandlePresentation, this.mCallerDisplayName, this.mCallerDisplayNamePresentation, this.mAccountHandle, this.mCallCapabilities, this.mCallProperties, this.mDisconnectCause, this.mConnectTimeMillis, this.mGatewayInfo, this.mVideoState, this.mStatusHints, this.mExtras, this.mIntentExtras, this.mCreationTimeMillis);
        }

        private void $$robo$$android_telecom_Call_Details$__constructor__(String telecomCallId, Uri handle, int handlePresentation, String callerDisplayName, int callerDisplayNamePresentation, PhoneAccountHandle accountHandle, int capabilities, int properties, DisconnectCause disconnectCause, long connectTimeMillis, GatewayInfo gatewayInfo, int videoState, StatusHints statusHints, Bundle extras, Bundle intentExtras, long creationTimeMillis) {
            this.mSupportedAudioRoutes = 15;
            this.mTelecomCallId = telecomCallId;
            this.mHandle = handle;
            this.mHandlePresentation = handlePresentation;
            this.mCallerDisplayName = callerDisplayName;
            this.mCallerDisplayNamePresentation = callerDisplayNamePresentation;
            this.mAccountHandle = accountHandle;
            this.mCallCapabilities = capabilities;
            this.mCallProperties = properties;
            this.mDisconnectCause = disconnectCause;
            this.mConnectTimeMillis = connectTimeMillis;
            this.mGatewayInfo = gatewayInfo;
            this.mVideoState = videoState;
            this.mStatusHints = statusHints;
            this.mExtras = extras;
            this.mIntentExtras = intentExtras;
            this.mCreationTimeMillis = creationTimeMillis;
        }

        private static final Details $$robo$$android_telecom_Call_Details$createFromParcelableCall(ParcelableCall parcelableCall) {
            return new Details(parcelableCall.getId(), parcelableCall.getHandle(), parcelableCall.getHandlePresentation(), parcelableCall.getCallerDisplayName(), parcelableCall.getCallerDisplayNamePresentation(), parcelableCall.getAccountHandle(), parcelableCall.getCapabilities(), parcelableCall.getProperties(), parcelableCall.getDisconnectCause(), parcelableCall.getConnectTimeMillis(), parcelableCall.getGatewayInfo(), parcelableCall.getVideoState(), parcelableCall.getStatusHints(), parcelableCall.getExtras(), parcelableCall.getIntentExtras(), parcelableCall.getCreationTimeMillis());
        }

        private final String $$robo$$android_telecom_Call_Details$toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[pa: ");
            sb.append(this.mAccountHandle);
            sb.append(", hdl: ");
            sb.append(Log.pii(this.mHandle));
            sb.append(", caps: ");
            sb.append(Details.capabilitiesToString(this.mCallCapabilities));
            sb.append(", props: ");
            sb.append(Details.propertiesToString(this.mCallProperties));
            sb.append("]");
            return sb.toString();
        }

        public static boolean can(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("can", $$robo$$android_telecom_Call_Details$can(int int ), 0, (int)n, (int)n2);
        }

        public boolean can(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("can", $$robo$$android_telecom_Call_Details$can(int ), 0, this, n);
        }

        public static String capabilitiesToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("capabilitiesToString", $$robo$$android_telecom_Call_Details$capabilitiesToString(int ), 0, (int)n);
        }

        public static boolean hasProperty(int n, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrapStatic("hasProperty", $$robo$$android_telecom_Call_Details$hasProperty(int int ), 0, (int)n, (int)n2);
        }

        public boolean hasProperty(int n) {
            return (boolean)InvokeDynamicSupport.bootstrap("hasProperty", $$robo$$android_telecom_Call_Details$hasProperty(int ), 0, this, n);
        }

        public static String propertiesToString(int n) {
            return InvokeDynamicSupport.bootstrapStatic("propertiesToString", $$robo$$android_telecom_Call_Details$propertiesToString(int ), 0, (int)n);
        }

        public String getTelecomCallId() {
            return InvokeDynamicSupport.bootstrap("getTelecomCallId", $$robo$$android_telecom_Call_Details$getTelecomCallId(), 0, this);
        }

        public Uri getHandle() {
            return InvokeDynamicSupport.bootstrap("getHandle", $$robo$$android_telecom_Call_Details$getHandle(), 0, this);
        }

        public int getHandlePresentation() {
            return (int)InvokeDynamicSupport.bootstrap("getHandlePresentation", $$robo$$android_telecom_Call_Details$getHandlePresentation(), 0, this);
        }

        public String getCallerDisplayName() {
            return InvokeDynamicSupport.bootstrap("getCallerDisplayName", $$robo$$android_telecom_Call_Details$getCallerDisplayName(), 0, this);
        }

        public int getCallerDisplayNamePresentation() {
            return (int)InvokeDynamicSupport.bootstrap("getCallerDisplayNamePresentation", $$robo$$android_telecom_Call_Details$getCallerDisplayNamePresentation(), 0, this);
        }

        public PhoneAccountHandle getAccountHandle() {
            return InvokeDynamicSupport.bootstrap("getAccountHandle", $$robo$$android_telecom_Call_Details$getAccountHandle(), 0, this);
        }

        public int getCallCapabilities() {
            return (int)InvokeDynamicSupport.bootstrap("getCallCapabilities", $$robo$$android_telecom_Call_Details$getCallCapabilities(), 0, this);
        }

        public int getCallProperties() {
            return (int)InvokeDynamicSupport.bootstrap("getCallProperties", $$robo$$android_telecom_Call_Details$getCallProperties(), 0, this);
        }

        public int getSupportedAudioRoutes() {
            return (int)InvokeDynamicSupport.bootstrap("getSupportedAudioRoutes", $$robo$$android_telecom_Call_Details$getSupportedAudioRoutes(), 0, this);
        }

        public DisconnectCause getDisconnectCause() {
            return InvokeDynamicSupport.bootstrap("getDisconnectCause", $$robo$$android_telecom_Call_Details$getDisconnectCause(), 0, this);
        }

        public long getConnectTimeMillis() {
            return (long)InvokeDynamicSupport.bootstrap("getConnectTimeMillis", $$robo$$android_telecom_Call_Details$getConnectTimeMillis(), 0, this);
        }

        public GatewayInfo getGatewayInfo() {
            return InvokeDynamicSupport.bootstrap("getGatewayInfo", $$robo$$android_telecom_Call_Details$getGatewayInfo(), 0, this);
        }

        public int getVideoState() {
            return (int)InvokeDynamicSupport.bootstrap("getVideoState", $$robo$$android_telecom_Call_Details$getVideoState(), 0, this);
        }

        public StatusHints getStatusHints() {
            return InvokeDynamicSupport.bootstrap("getStatusHints", $$robo$$android_telecom_Call_Details$getStatusHints(), 0, this);
        }

        public Bundle getExtras() {
            return InvokeDynamicSupport.bootstrap("getExtras", $$robo$$android_telecom_Call_Details$getExtras(), 0, this);
        }

        public Bundle getIntentExtras() {
            return InvokeDynamicSupport.bootstrap("getIntentExtras", $$robo$$android_telecom_Call_Details$getIntentExtras(), 0, this);
        }

        public long getCreationTimeMillis() {
            return (long)InvokeDynamicSupport.bootstrap("getCreationTimeMillis", $$robo$$android_telecom_Call_Details$getCreationTimeMillis(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_telecom_Call_Details$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_telecom_Call_Details$hashCode(), 0, this);
        }

        private void __constructor__(String string2, Uri uri, int n, String string3, int n2, PhoneAccountHandle phoneAccountHandle, int n3, int n4, DisconnectCause disconnectCause, long l, GatewayInfo gatewayInfo, int n5, StatusHints statusHints, Bundle bundle, Bundle bundle2, long l2) {
            this.$$robo$$android_telecom_Call_Details$__constructor__(string2, uri, n, string3, n2, phoneAccountHandle, n3, n4, disconnectCause, l, gatewayInfo, n5, statusHints, bundle, bundle2, l2);
        }

        public Details(String string2, Uri uri, int n, String string3, int n2, PhoneAccountHandle phoneAccountHandle, int n3, int n4, DisconnectCause disconnectCause, long l, GatewayInfo gatewayInfo, int n5, StatusHints statusHints, Bundle bundle, Bundle bundle2, long l2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_telecom_Call_Details$__constructor__(java.lang.String android.net.Uri int java.lang.String int android.telecom.PhoneAccountHandle int int android.telecom.DisconnectCause long android.telecom.GatewayInfo int android.telecom.StatusHints android.os.Bundle android.os.Bundle long ), 0, this, string2, uri, n, string3, n2, phoneAccountHandle, n3, n4, disconnectCause, l, gatewayInfo, n5, statusHints, bundle, bundle2, l2);
        }

        public static Details createFromParcelableCall(ParcelableCall parcelableCall) {
            return InvokeDynamicSupport.bootstrapStatic("createFromParcelableCall", $$robo$$android_telecom_Call_Details$createFromParcelableCall(android.telecom.ParcelableCall ), 0, (ParcelableCall)parcelableCall);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_telecom_Call_Details$toString(), 0, this);
        }

        public /* synthetic */ Details() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Details)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

