/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.annotation.IntDef;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.media.AudioAttributes;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.IBinder;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.speech.tts.ITextToSpeechCallback;
import android.speech.tts.ITextToSpeechService;
import android.speech.tts.TtsEngines;
import android.speech.tts.UtteranceProgressListener;
import android.speech.tts.Voice;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TextToSpeech
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TextToSpeech";
    public static int SUCCESS = 0;
    public static int ERROR = -1;
    public static int STOPPED = -2;
    public static int ERROR_SYNTHESIS = -3;
    public static int ERROR_SERVICE = -4;
    public static int ERROR_OUTPUT = -5;
    public static int ERROR_NETWORK = -6;
    public static int ERROR_NETWORK_TIMEOUT = -7;
    public static int ERROR_INVALID_REQUEST = -8;
    public static int ERROR_NOT_INSTALLED_YET = -9;
    public static int QUEUE_FLUSH = 0;
    public static int QUEUE_ADD = 1;
    static int QUEUE_DESTROY = 2;
    public static int LANG_COUNTRY_VAR_AVAILABLE = 2;
    public static int LANG_COUNTRY_AVAILABLE = 1;
    public static int LANG_AVAILABLE = 0;
    public static int LANG_MISSING_DATA = -1;
    public static int LANG_NOT_SUPPORTED = -2;
    public static String ACTION_TTS_QUEUE_PROCESSING_COMPLETED = "android.speech.tts.TTS_QUEUE_PROCESSING_COMPLETED";
    private Context mContext;
    private Connection mConnectingServiceConnection;
    private Connection mServiceConnection;
    private OnInitListener mInitListener;
    private volatile UtteranceProgressListener mUtteranceProgressListener;
    private Object mStartLock;
    private String mRequestedEngine;
    private boolean mUseFallback;
    private Map<String, Uri> mEarcons;
    private Map<CharSequence, Uri> mUtterances;
    private Bundle mParams;
    private TtsEngines mEnginesHelper;
    private volatile String mCurrentEngine;

    private void $$robo$$android_speech_tts_TextToSpeech$__constructor__(Context context, OnInitListener listener) {
    }

    private void $$robo$$android_speech_tts_TextToSpeech$__constructor__(Context context, OnInitListener listener, String engine) {
    }

    private void $$robo$$android_speech_tts_TextToSpeech$__constructor__(Context context, OnInitListener listener, String engine, String packageName, boolean useFallback) {
        this.mStartLock = new Object();
        this.mParams = new Bundle();
        this.mCurrentEngine = null;
        this.mContext = context;
        this.mInitListener = listener;
        this.mRequestedEngine = engine;
        this.mUseFallback = useFallback;
        this.mEarcons = new HashMap<String, Uri>();
        this.mUtterances = new HashMap<CharSequence, Uri>();
        this.mUtteranceProgressListener = null;
        this.mEnginesHelper = new TtsEngines(this.mContext);
        this.initTts();
    }

    private final <R> R $$robo$$android_speech_tts_TextToSpeech$runActionNoReconnect(Action<R> action, R errorResult, String method, boolean onlyEstablishedConnection) {
        return this.runAction(action, errorResult, method, false, onlyEstablishedConnection);
    }

    private final <R> R $$robo$$android_speech_tts_TextToSpeech$runAction(Action<R> action, R errorResult, String method) {
        return this.runAction(action, errorResult, method, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final <R> R $$robo$$android_speech_tts_TextToSpeech$runAction(Action<R> action, R errorResult, String method, boolean reconnect, boolean onlyEstablishedConnection) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mServiceConnection == null) {
                Log.w("TextToSpeech", method + " failed: not bound to TTS engine");
                return errorResult;
            }
            return this.mServiceConnection.runAction(action, errorResult, method, reconnect, onlyEstablishedConnection);
        }
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$initTts() {
        String defaultEngine;
        if (this.mRequestedEngine != null) {
            if (this.mEnginesHelper.isEngineInstalled(this.mRequestedEngine)) {
                if (this.connectToEngine(this.mRequestedEngine)) {
                    this.mCurrentEngine = this.mRequestedEngine;
                    return 0;
                }
                if (!this.mUseFallback) {
                    this.mCurrentEngine = null;
                    this.dispatchOnInit(-1);
                    return -1;
                }
            } else if (!this.mUseFallback) {
                Log.i("TextToSpeech", "Requested engine not installed: " + this.mRequestedEngine);
                this.mCurrentEngine = null;
                this.dispatchOnInit(-1);
                return -1;
            }
        }
        if ((defaultEngine = this.getDefaultEngine()) != null && !defaultEngine.equals(this.mRequestedEngine) && this.connectToEngine(defaultEngine)) {
            this.mCurrentEngine = defaultEngine;
            return 0;
        }
        String highestRanked = this.mEnginesHelper.getHighestRankedEngineName();
        if (highestRanked != null && !highestRanked.equals(this.mRequestedEngine) && !highestRanked.equals(defaultEngine) && this.connectToEngine(highestRanked)) {
            this.mCurrentEngine = highestRanked;
            return 0;
        }
        this.mCurrentEngine = null;
        this.dispatchOnInit(-1);
        return -1;
    }

    private final boolean $$robo$$android_speech_tts_TextToSpeech$connectToEngine(String engine) {
        Connection connection = new Connection(this);
        Intent intent = new Intent("android.intent.action.TTS_SERVICE");
        intent.setPackage(engine);
        boolean bound = this.mContext.bindService(intent, connection, 1);
        if (!bound) {
            Log.e("TextToSpeech", "Failed to bind to " + engine);
            return false;
        }
        Log.i("TextToSpeech", "Sucessfully bound to " + engine);
        this.mConnectingServiceConnection = connection;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_TextToSpeech$dispatchOnInit(int result) {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mInitListener != null) {
                this.mInitListener.onInit(result);
                this.mInitListener = null;
            }
        }
    }

    private final IBinder $$robo$$android_speech_tts_TextToSpeech$getCallerIdentity() {
        return this.mServiceConnection.getCallerIdentity();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_TextToSpeech$shutdown() {
        Object object = this.mStartLock;
        synchronized (object) {
            if (this.mConnectingServiceConnection != null) {
                this.mContext.unbindService(this.mConnectingServiceConnection);
                this.mConnectingServiceConnection = null;
                return;
            }
        }
        this.runActionNoReconnect(new Action<Void>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_1$__constructor__(TextToSpeech this$0) {
            }

            private final Void $$robo$$android_speech_tts_TextToSpeech_1$run(ITextToSpeechService service) throws RemoteException {
                service.setCallback(this.this$0.getCallerIdentity(), null);
                service.stop(this.this$0.getCallerIdentity());
                this.this$0.mServiceConnection.disconnect();
                this.this$0.mServiceConnection = null;
                this.this$0.mCurrentEngine = null;
                return null;
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_1$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_1$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Void run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_1$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "shutdown", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$addSpeech(String text, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$addSpeech(CharSequence text, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$addSpeech(String text, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, Uri.parse(filename));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$addSpeech(CharSequence text, File file) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mUtterances.put(text, Uri.fromFile(file));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$addEarcon(String earcon, String packagename, int resourceId) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, this.makeResourceUri(packagename, resourceId));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$addEarcon(String earcon, String filename) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, Uri.parse(filename));
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$addEarcon(String earcon, File file) {
        Object object = this.mStartLock;
        synchronized (object) {
            this.mEarcons.put(earcon, Uri.fromFile(file));
            return 0;
        }
    }

    private final Uri $$robo$$android_speech_tts_TextToSpeech$makeResourceUri(String packageName, int resourceId) {
        return new Uri.Builder().scheme("android.resource").encodedAuthority(packageName).appendEncodedPath(String.valueOf(resourceId)).build();
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$speak(CharSequence text, int queueMode, Bundle params, String utteranceId) {
        return this.runAction(new Action<Integer>(this, text, queueMode, params, utteranceId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ CharSequence val$text;
            /* synthetic */ int val$queueMode;
            /* synthetic */ Bundle val$params;
            /* synthetic */ String val$utteranceId;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_2$__constructor__(TextToSpeech this$0, CharSequence charSequence, int n, Bundle bundle, String string2) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_2$run(ITextToSpeechService service) throws RemoteException {
                Uri utteranceUri = (Uri)this.this$0.mUtterances.get(this.val$text);
                if (utteranceUri != null) {
                    return service.playAudio(this.this$0.getCallerIdentity(), utteranceUri, this.val$queueMode, this.this$0.getParams(this.val$params), this.val$utteranceId);
                }
                return service.speak(this.this$0.getCallerIdentity(), this.val$text, this.val$queueMode, this.this$0.getParams(this.val$params), this.val$utteranceId);
            }

            private void __constructor__(TextToSpeech textToSpeech, CharSequence charSequence, int n, Bundle bundle, String string2) {
                this.$$robo$$android_speech_tts_TextToSpeech_2$__constructor__(textToSpeech, charSequence, n, bundle, string2);
            }
            {
                this.this$0 = textToSpeech;
                this.val$text = charSequence;
                this.val$queueMode = n;
                this.val$params = bundle;
                this.val$utteranceId = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_2$__constructor__(android.speech.tts.TextToSpeech java.lang.CharSequence int android.os.Bundle java.lang.String ), 0, this, textToSpeech, charSequence, n, bundle, string2);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_2$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -1, "speak");
    }

    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$speak(String text, int queueMode, HashMap<String, String> params) {
        return this.speak(text, queueMode, this.convertParamsHashMaptoBundle(params), params == null ? null : params.get("utteranceId"));
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$playEarcon(String earcon, int queueMode, Bundle params, String utteranceId) {
        return this.runAction(new Action<Integer>(this, earcon, queueMode, params, utteranceId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ String val$earcon;
            /* synthetic */ int val$queueMode;
            /* synthetic */ Bundle val$params;
            /* synthetic */ String val$utteranceId;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_3$__constructor__(TextToSpeech this$0, String string2, int n, Bundle bundle, String string3) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_3$run(ITextToSpeechService service) throws RemoteException {
                Uri earconUri = (Uri)this.this$0.mEarcons.get(this.val$earcon);
                if (earconUri == null) {
                    return -1;
                }
                return service.playAudio(this.this$0.getCallerIdentity(), earconUri, this.val$queueMode, this.this$0.getParams(this.val$params), this.val$utteranceId);
            }

            private void __constructor__(TextToSpeech textToSpeech, String string2, int n, Bundle bundle, String string3) {
                this.$$robo$$android_speech_tts_TextToSpeech_3$__constructor__(textToSpeech, string2, n, bundle, string3);
            }
            {
                this.this$0 = textToSpeech;
                this.val$earcon = string2;
                this.val$queueMode = n;
                this.val$params = bundle;
                this.val$utteranceId = string3;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_3$__constructor__(android.speech.tts.TextToSpeech java.lang.String int android.os.Bundle java.lang.String ), 0, this, textToSpeech, string2, n, bundle, string3);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_3$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -1, "playEarcon");
    }

    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$playEarcon(String earcon, int queueMode, HashMap<String, String> params) {
        return this.playEarcon(earcon, queueMode, this.convertParamsHashMaptoBundle(params), params == null ? null : params.get("utteranceId"));
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$playSilentUtterance(long durationInMs, int queueMode, String utteranceId) {
        return this.runAction(new Action<Integer>(this, durationInMs, queueMode, utteranceId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ long val$durationInMs;
            /* synthetic */ int val$queueMode;
            /* synthetic */ String val$utteranceId;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_4$__constructor__(TextToSpeech this$0, long l, int n, String string2) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_4$run(ITextToSpeechService service) throws RemoteException {
                return service.playSilence(this.this$0.getCallerIdentity(), this.val$durationInMs, this.val$queueMode, this.val$utteranceId);
            }

            private void __constructor__(TextToSpeech textToSpeech, long l, int n, String string2) {
                this.$$robo$$android_speech_tts_TextToSpeech_4$__constructor__(textToSpeech, l, n, string2);
            }
            {
                this.this$0 = textToSpeech;
                this.val$durationInMs = l;
                this.val$queueMode = n;
                this.val$utteranceId = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_4$__constructor__(android.speech.tts.TextToSpeech long int java.lang.String ), 0, this, textToSpeech, l, n, string2);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_4$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -1, "playSilentUtterance");
    }

    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$playSilence(long durationInMs, int queueMode, HashMap<String, String> params) {
        return this.playSilentUtterance(durationInMs, queueMode, params == null ? null : params.get("utteranceId"));
    }

    @Deprecated
    private final Set<String> $$robo$$android_speech_tts_TextToSpeech$getFeatures(Locale locale) {
        return this.runAction(new Action<Set<String>>(this, locale){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Locale val$locale;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_5$__constructor__(TextToSpeech this$0, Locale locale) {
            }

            private final Set<String> $$robo$$android_speech_tts_TextToSpeech_5$run(ITextToSpeechService service) throws RemoteException {
                String[] features = null;
                try {
                    features = service.getFeaturesForLanguage(this.val$locale.getISO3Language(), this.val$locale.getISO3Country(), this.val$locale.getVariant());
                }
                catch (MissingResourceException e) {
                    Log.w("TextToSpeech", "Couldn't retrieve 3 letter ISO 639-2/T language and/or ISO 3166 country code for locale: " + this.val$locale, e);
                    return null;
                }
                if (features != null) {
                    HashSet<String> featureSet = new HashSet<String>();
                    Collections.addAll(featureSet, features);
                    return featureSet;
                }
                return null;
            }

            private void __constructor__(TextToSpeech textToSpeech, Locale locale) {
                this.$$robo$$android_speech_tts_TextToSpeech_5$__constructor__(textToSpeech, locale);
            }
            {
                this.this$0 = textToSpeech;
                this.val$locale = locale;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_5$__constructor__(android.speech.tts.TextToSpeech java.util.Locale ), 0, this, textToSpeech, locale);
            }

            @Override
            public Set<String> run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_5$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getFeatures");
    }

    private final boolean $$robo$$android_speech_tts_TextToSpeech$isSpeaking() {
        return this.runAction(new Action<Boolean>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_6$__constructor__(TextToSpeech this$0) {
            }

            private final Boolean $$robo$$android_speech_tts_TextToSpeech_6$run(ITextToSpeechService service) throws RemoteException {
                return service.isSpeaking();
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_6$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_6$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Boolean run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_6$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, false, "isSpeaking");
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$stop() {
        return this.runAction(new Action<Integer>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_7$__constructor__(TextToSpeech this$0) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_7$run(ITextToSpeechService service) throws RemoteException {
                return service.stop(this.this$0.getCallerIdentity());
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_7$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_7$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_7$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -1, "stop");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$setSpeechRate(float speechRate) {
        int intRate;
        if (speechRate > 0.0f && (intRate = (int)(speechRate * 100.0f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("rate", intRate);
            }
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$setPitch(float pitch) {
        int intPitch;
        if (pitch > 0.0f && (intPitch = (int)(pitch * 100.0f)) > 0) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putInt("pitch", intPitch);
            }
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_TextToSpeech$setAudioAttributes(AudioAttributes audioAttributes) {
        if (audioAttributes != null) {
            Object object = this.mStartLock;
            synchronized (object) {
                this.mParams.putParcelable("audioAttributes", audioAttributes);
            }
            return 0;
        }
        return -1;
    }

    private final String $$robo$$android_speech_tts_TextToSpeech$getCurrentEngine() {
        return this.mCurrentEngine;
    }

    @Deprecated
    private final Locale $$robo$$android_speech_tts_TextToSpeech$getDefaultLanguage() {
        return this.runAction(new Action<Locale>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_8$__constructor__(TextToSpeech this$0) {
            }

            private final Locale $$robo$$android_speech_tts_TextToSpeech_8$run(ITextToSpeechService service) throws RemoteException {
                String[] defaultLanguage = service.getClientDefaultLanguage();
                return new Locale(defaultLanguage[0], defaultLanguage[1], defaultLanguage[2]);
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_8$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_8$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Locale run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_8$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getDefaultLanguage");
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$setLanguage(Locale loc) {
        return this.runAction(new Action<Integer>(this, loc){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Locale val$loc;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_9$__constructor__(TextToSpeech this$0, Locale locale) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_9$run(ITextToSpeechService service) throws RemoteException {
                if (this.val$loc == null) {
                    return -2;
                }
                String language = null;
                String country = null;
                try {
                    language = this.val$loc.getISO3Language();
                }
                catch (MissingResourceException e) {
                    Log.w("TextToSpeech", "Couldn't retrieve ISO 639-2/T language code for locale: " + this.val$loc, e);
                    return -2;
                }
                try {
                    country = this.val$loc.getISO3Country();
                }
                catch (MissingResourceException e) {
                    Log.w("TextToSpeech", "Couldn't retrieve ISO 3166 country code for locale: " + this.val$loc, e);
                    return -2;
                }
                String variant = this.val$loc.getVariant();
                int result = service.isLanguageAvailable(language, country, variant);
                if (result >= 0) {
                    String voiceName = service.getDefaultVoiceNameFor(language, country, variant);
                    if (TextUtils.isEmpty(voiceName)) {
                        Log.w("TextToSpeech", "Couldn't find the default voice for " + language + "-" + country + "-" + variant);
                        return -2;
                    }
                    if (service.loadVoice(this.this$0.getCallerIdentity(), voiceName) == -1) {
                        Log.w("TextToSpeech", "The service claimed " + language + "-" + country + "-" + variant + " was available with voice name " + voiceName + " but loadVoice returned ERROR");
                        return -2;
                    }
                    Voice voice = this.this$0.getVoice(service, voiceName);
                    if (voice == null) {
                        Log.w("TextToSpeech", "getDefaultVoiceNameFor returned " + voiceName + " for locale " + language + "-" + country + "-" + variant + " but getVoice returns null");
                        return -2;
                    }
                    String voiceLanguage = "";
                    try {
                        voiceLanguage = voice.getLocale().getISO3Language();
                    }
                    catch (MissingResourceException e) {
                        Log.w("TextToSpeech", "Couldn't retrieve ISO 639-2/T language code for locale: " + voice.getLocale(), e);
                    }
                    String voiceCountry = "";
                    try {
                        voiceCountry = voice.getLocale().getISO3Country();
                    }
                    catch (MissingResourceException e) {
                        Log.w("TextToSpeech", "Couldn't retrieve ISO 3166 country code for locale: " + voice.getLocale(), e);
                    }
                    this.this$0.mParams.putString("voiceName", voiceName);
                    this.this$0.mParams.putString("language", voiceLanguage);
                    this.this$0.mParams.putString("country", voiceCountry);
                    this.this$0.mParams.putString("variant", voice.getLocale().getVariant());
                }
                return result;
            }

            private void __constructor__(TextToSpeech textToSpeech, Locale locale) {
                this.$$robo$$android_speech_tts_TextToSpeech_9$__constructor__(textToSpeech, locale);
            }
            {
                this.this$0 = textToSpeech;
                this.val$loc = locale;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_9$__constructor__(android.speech.tts.TextToSpeech java.util.Locale ), 0, this, textToSpeech, locale);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_9$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -2, "setLanguage");
    }

    @Deprecated
    private final Locale $$robo$$android_speech_tts_TextToSpeech$getLanguage() {
        return this.runAction(new Action<Locale>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_10$__constructor__(TextToSpeech this$0) {
            }

            private final Locale $$robo$$android_speech_tts_TextToSpeech_10$run(ITextToSpeechService service) {
                String lang = this.this$0.mParams.getString("language", "");
                String country = this.this$0.mParams.getString("country", "");
                String variant = this.this$0.mParams.getString("variant", "");
                return new Locale(lang, country, variant);
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_10$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_10$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Locale run(ITextToSpeechService iTextToSpeechService) {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_10$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getLanguage");
    }

    private final Set<Locale> $$robo$$android_speech_tts_TextToSpeech$getAvailableLanguages() {
        return this.runAction(new Action<Set<Locale>>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_11$__constructor__(TextToSpeech this$0) {
            }

            private final Set<Locale> $$robo$$android_speech_tts_TextToSpeech_11$run(ITextToSpeechService service) throws RemoteException {
                List<Voice> voices = service.getVoices();
                if (voices == null) {
                    return new HashSet<Locale>();
                }
                HashSet<Locale> locales = new HashSet<Locale>();
                for (Voice voice : voices) {
                    locales.add(voice.getLocale());
                }
                return locales;
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_11$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_11$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Set<Locale> run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_11$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getAvailableLanguages");
    }

    private final Set<Voice> $$robo$$android_speech_tts_TextToSpeech$getVoices() {
        return this.runAction(new Action<Set<Voice>>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_12$__constructor__(TextToSpeech this$0) {
            }

            private final Set<Voice> $$robo$$android_speech_tts_TextToSpeech_12$run(ITextToSpeechService service) throws RemoteException {
                List<Voice> voices = service.getVoices();
                return voices != null ? new HashSet<Voice>(voices) : new HashSet();
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_12$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_12$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Set<Voice> run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_12$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getVoices");
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$setVoice(Voice voice) {
        return this.runAction(new Action<Integer>(this, voice){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Voice val$voice;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_13$__constructor__(TextToSpeech this$0, Voice voice) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_13$run(ITextToSpeechService service) throws RemoteException {
                int result = service.loadVoice(this.this$0.getCallerIdentity(), this.val$voice.getName());
                if (result == 0) {
                    this.this$0.mParams.putString("voiceName", this.val$voice.getName());
                    String language = "";
                    try {
                        language = this.val$voice.getLocale().getISO3Language();
                    }
                    catch (MissingResourceException e) {
                        Log.w("TextToSpeech", "Couldn't retrieve ISO 639-2/T language code for locale: " + this.val$voice.getLocale(), e);
                    }
                    String country = "";
                    try {
                        country = this.val$voice.getLocale().getISO3Country();
                    }
                    catch (MissingResourceException e) {
                        Log.w("TextToSpeech", "Couldn't retrieve ISO 3166 country code for locale: " + this.val$voice.getLocale(), e);
                    }
                    this.this$0.mParams.putString("language", language);
                    this.this$0.mParams.putString("country", country);
                    this.this$0.mParams.putString("variant", this.val$voice.getLocale().getVariant());
                }
                return result;
            }

            private void __constructor__(TextToSpeech textToSpeech, Voice voice) {
                this.$$robo$$android_speech_tts_TextToSpeech_13$__constructor__(textToSpeech, voice);
            }
            {
                this.this$0 = textToSpeech;
                this.val$voice = voice;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_13$__constructor__(android.speech.tts.TextToSpeech android.speech.tts.Voice ), 0, this, textToSpeech, voice);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_13$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -2, "setVoice");
    }

    private final Voice $$robo$$android_speech_tts_TextToSpeech$getVoice() {
        return this.runAction(new Action<Voice>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_14$__constructor__(TextToSpeech this$0) {
            }

            private final Voice $$robo$$android_speech_tts_TextToSpeech_14$run(ITextToSpeechService service) throws RemoteException {
                String voiceName = this.this$0.mParams.getString("voiceName", "");
                if (TextUtils.isEmpty(voiceName)) {
                    return null;
                }
                return this.this$0.getVoice(service, voiceName);
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_14$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_14$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Voice run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_14$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getVoice");
    }

    private final Voice $$robo$$android_speech_tts_TextToSpeech$getVoice(ITextToSpeechService service, String voiceName) throws RemoteException {
        List<Voice> voices = service.getVoices();
        if (voices == null) {
            Log.w("TextToSpeech", "getVoices returned null");
            return null;
        }
        for (Voice voice : voices) {
            if (!voice.getName().equals(voiceName)) continue;
            return voice;
        }
        Log.w("TextToSpeech", "Could not find voice " + voiceName + " in voice list");
        return null;
    }

    private final Voice $$robo$$android_speech_tts_TextToSpeech$getDefaultVoice() {
        return this.runAction(new Action<Voice>(this){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_15$__constructor__(TextToSpeech this$0) {
            }

            private final Voice $$robo$$android_speech_tts_TextToSpeech_15$run(ITextToSpeechService service) throws RemoteException {
                String variant;
                String[] defaultLanguage = service.getClientDefaultLanguage();
                if (defaultLanguage == null || defaultLanguage.length == 0) {
                    Log.e("TextToSpeech", "service.getClientDefaultLanguage() returned empty array");
                    return null;
                }
                String language = defaultLanguage[0];
                String country = defaultLanguage.length > 1 ? defaultLanguage[1] : "";
                int result = service.isLanguageAvailable(language, country, variant = defaultLanguage.length > 2 ? defaultLanguage[2] : "");
                if (result < 0) {
                    return null;
                }
                String voiceName = service.getDefaultVoiceNameFor(language, country, variant);
                if (TextUtils.isEmpty(voiceName)) {
                    return null;
                }
                List<Voice> voices = service.getVoices();
                if (voices == null) {
                    return null;
                }
                for (Voice voice : voices) {
                    if (!voice.getName().equals(voiceName)) continue;
                    return voice;
                }
                return null;
            }

            private void __constructor__(TextToSpeech textToSpeech) {
                this.$$robo$$android_speech_tts_TextToSpeech_15$__constructor__(textToSpeech);
            }
            {
                this.this$0 = textToSpeech;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_15$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
            }

            @Override
            public Voice run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_15$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, "getDefaultVoice");
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$isLanguageAvailable(Locale loc) {
        return this.runAction(new Action<Integer>(this, loc){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ Locale val$loc;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_16$__constructor__(TextToSpeech this$0, Locale locale) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_16$run(ITextToSpeechService service) throws RemoteException {
                String language = null;
                String country = null;
                try {
                    language = this.val$loc.getISO3Language();
                }
                catch (MissingResourceException e) {
                    Log.w("TextToSpeech", "Couldn't retrieve ISO 639-2/T language code for locale: " + this.val$loc, e);
                    return -2;
                }
                try {
                    country = this.val$loc.getISO3Country();
                }
                catch (MissingResourceException e) {
                    Log.w("TextToSpeech", "Couldn't retrieve ISO 3166 country code for locale: " + this.val$loc, e);
                    return -2;
                }
                return service.isLanguageAvailable(language, country, this.val$loc.getVariant());
            }

            private void __constructor__(TextToSpeech textToSpeech, Locale locale) {
                this.$$robo$$android_speech_tts_TextToSpeech_16$__constructor__(textToSpeech, locale);
            }
            {
                this.this$0 = textToSpeech;
                this.val$loc = locale;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_16$__constructor__(android.speech.tts.TextToSpeech java.util.Locale ), 0, this, textToSpeech, locale);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_16$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -2, "isLanguageAvailable");
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$synthesizeToFile(CharSequence text, Bundle params, File file, String utteranceId) {
        return this.runAction(new Action<Integer>(this, file, text, params, utteranceId){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ File val$file;
            /* synthetic */ CharSequence val$text;
            /* synthetic */ Bundle val$params;
            /* synthetic */ String val$utteranceId;
            /* synthetic */ TextToSpeech this$0;

            private void $$robo$$android_speech_tts_TextToSpeech_17$__constructor__(TextToSpeech this$0, File file, CharSequence charSequence, Bundle bundle, String string2) {
            }

            private final Integer $$robo$$android_speech_tts_TextToSpeech_17$run(ITextToSpeechService service) throws RemoteException {
                try {
                    if (this.val$file.exists() && !this.val$file.canWrite()) {
                        Log.e("TextToSpeech", "Can't write to " + this.val$file);
                        return -1;
                    }
                    ParcelFileDescriptor fileDescriptor = ParcelFileDescriptor.open(this.val$file, 0x2C000000);
                    int returnValue = service.synthesizeToFileDescriptor(this.this$0.getCallerIdentity(), this.val$text, fileDescriptor, this.this$0.getParams(this.val$params), this.val$utteranceId);
                    fileDescriptor.close();
                    return returnValue;
                }
                catch (FileNotFoundException e) {
                    Log.e("TextToSpeech", "Opening file " + this.val$file + " failed", e);
                    return -1;
                }
                catch (IOException e) {
                    Log.e("TextToSpeech", "Closing file " + this.val$file + " failed", e);
                    return -1;
                }
            }

            private void __constructor__(TextToSpeech textToSpeech, File file, CharSequence charSequence, Bundle bundle, String string2) {
                this.$$robo$$android_speech_tts_TextToSpeech_17$__constructor__(textToSpeech, file, charSequence, bundle, string2);
            }
            {
                this.this$0 = textToSpeech;
                this.val$file = file;
                this.val$text = charSequence;
                this.val$params = bundle;
                this.val$utteranceId = string2;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_17$__constructor__(android.speech.tts.TextToSpeech java.io.File java.lang.CharSequence android.os.Bundle java.lang.String ), 0, this, textToSpeech, file, charSequence, bundle, string2);
            }

            @Override
            public Integer run(ITextToSpeechService iTextToSpeechService) throws RemoteException {
                return InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_TextToSpeech_17$run(android.speech.tts.ITextToSpeechService ), 0, this, iTextToSpeechService);
            }
            {
                this.$$robo$init();
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, -1, "synthesizeToFile");
    }

    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$synthesizeToFile(String text, HashMap<String, String> params, String filename) {
        return this.synthesizeToFile(text, this.convertParamsHashMaptoBundle(params), new File(filename), params.get("utteranceId"));
    }

    private final Bundle $$robo$$android_speech_tts_TextToSpeech$convertParamsHashMaptoBundle(HashMap<String, String> params) {
        if (params != null && !params.isEmpty()) {
            Bundle bundle = new Bundle();
            this.copyIntParam(bundle, params, "streamType");
            this.copyIntParam(bundle, params, "sessionId");
            this.copyStringParam(bundle, params, "utteranceId");
            this.copyFloatParam(bundle, params, "volume");
            this.copyFloatParam(bundle, params, "pan");
            this.copyStringParam(bundle, params, "networkTts");
            this.copyStringParam(bundle, params, "embeddedTts");
            this.copyIntParam(bundle, params, "networkTimeoutMs");
            this.copyIntParam(bundle, params, "networkRetriesCount");
            if (!TextUtils.isEmpty(this.mCurrentEngine)) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    String key = entry.getKey();
                    if (key == null || !key.startsWith(this.mCurrentEngine)) continue;
                    bundle.putString(key, entry.getValue());
                }
            }
            return bundle;
        }
        return null;
    }

    private final Bundle $$robo$$android_speech_tts_TextToSpeech$getParams(Bundle params) {
        if (params != null && !params.isEmpty()) {
            Bundle bundle = new Bundle(this.mParams);
            bundle.putAll(params);
            TextToSpeech.verifyIntegerBundleParam(bundle, "streamType");
            TextToSpeech.verifyIntegerBundleParam(bundle, "sessionId");
            TextToSpeech.verifyStringBundleParam(bundle, "utteranceId");
            TextToSpeech.verifyFloatBundleParam(bundle, "volume");
            TextToSpeech.verifyFloatBundleParam(bundle, "pan");
            TextToSpeech.verifyBooleanBundleParam(bundle, "networkTts");
            TextToSpeech.verifyBooleanBundleParam(bundle, "embeddedTts");
            TextToSpeech.verifyIntegerBundleParam(bundle, "networkTimeoutMs");
            TextToSpeech.verifyIntegerBundleParam(bundle, "networkRetriesCount");
            return bundle;
        }
        return this.mParams;
    }

    private static final boolean $$robo$$android_speech_tts_TextToSpeech$verifyIntegerBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof Integer) && !(bundle.get(key) instanceof Long)) {
            bundle.remove(key);
            Log.w("TextToSpeech", "Synthesis request paramter " + key + " containst value  with invalid type. Should be an Integer or a Long");
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_speech_tts_TextToSpeech$verifyStringBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof String)) {
            bundle.remove(key);
            Log.w("TextToSpeech", "Synthesis request paramter " + key + " containst value  with invalid type. Should be a String");
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_speech_tts_TextToSpeech$verifyBooleanBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof Boolean) && !(bundle.get(key) instanceof String)) {
            bundle.remove(key);
            Log.w("TextToSpeech", "Synthesis request paramter " + key + " containst value  with invalid type. Should be a Boolean or String");
            return false;
        }
        return true;
    }

    private static final boolean $$robo$$android_speech_tts_TextToSpeech$verifyFloatBundleParam(Bundle bundle, String key) {
        if (bundle.containsKey(key) && !(bundle.get(key) instanceof Float) && !(bundle.get(key) instanceof Double)) {
            bundle.remove(key);
            Log.w("TextToSpeech", "Synthesis request paramter " + key + " containst value  with invalid type. Should be a Float or a Double");
            return false;
        }
        return true;
    }

    private final void $$robo$$android_speech_tts_TextToSpeech$copyStringParam(Bundle bundle, HashMap<String, String> params, String key) {
        String value = params.get(key);
        if (value != null) {
            bundle.putString(key, value);
        }
    }

    private final void $$robo$$android_speech_tts_TextToSpeech$copyIntParam(Bundle bundle, HashMap<String, String> params, String key) {
        String valueString = params.get(key);
        if (!TextUtils.isEmpty(valueString)) {
            try {
                int value = Integer.parseInt(valueString);
                bundle.putInt(key, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private final void $$robo$$android_speech_tts_TextToSpeech$copyFloatParam(Bundle bundle, HashMap<String, String> params, String key) {
        String valueString = params.get(key);
        if (!TextUtils.isEmpty(valueString)) {
            try {
                float value = Float.parseFloat(valueString);
                bundle.putFloat(key, value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$setOnUtteranceCompletedListener(OnUtteranceCompletedListener listener) {
        this.mUtteranceProgressListener = UtteranceProgressListener.from(listener);
        return 0;
    }

    private final int $$robo$$android_speech_tts_TextToSpeech$setOnUtteranceProgressListener(UtteranceProgressListener listener) {
        this.mUtteranceProgressListener = listener;
        return 0;
    }

    @Deprecated
    private final int $$robo$$android_speech_tts_TextToSpeech$setEngineByPackageName(String enginePackageName) {
        this.mRequestedEngine = enginePackageName;
        return this.initTts();
    }

    private final String $$robo$$android_speech_tts_TextToSpeech$getDefaultEngine() {
        return this.mEnginesHelper.getDefaultEngine();
    }

    @Deprecated
    private final boolean $$robo$$android_speech_tts_TextToSpeech$areDefaultsEnforced() {
        return false;
    }

    private final List<EngineInfo> $$robo$$android_speech_tts_TextToSpeech$getEngines() {
        return this.mEnginesHelper.getEngines();
    }

    private static final int $$robo$$android_speech_tts_TextToSpeech$getMaxSpeechInputLength() {
        return 4000;
    }

    private void __constructor__(Context context, OnInitListener onInitListener) {
        this.$$robo$$android_speech_tts_TextToSpeech$__constructor__(context, onInitListener);
    }

    public TextToSpeech(Context context, OnInitListener onInitListener) {
        this(context, onInitListener, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech$__constructor__(android.content.Context android.speech.tts.TextToSpeech$OnInitListener ), 0, this, context, onInitListener);
    }

    private void __constructor__(Context context, OnInitListener onInitListener, String string2) {
        this.$$robo$$android_speech_tts_TextToSpeech$__constructor__(context, onInitListener, string2);
    }

    public TextToSpeech(Context context, OnInitListener onInitListener, String string2) {
        this(context, onInitListener, string2, null, true);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech$__constructor__(android.content.Context android.speech.tts.TextToSpeech$OnInitListener java.lang.String ), 0, this, context, onInitListener, string2);
    }

    private void __constructor__(Context context, OnInitListener onInitListener, String string2, String string3, boolean bl) {
        this.$$robo$$android_speech_tts_TextToSpeech$__constructor__(context, onInitListener, string2, string3, bl);
    }

    public TextToSpeech(Context context, OnInitListener onInitListener, String string2, String string3, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech$__constructor__(android.content.Context android.speech.tts.TextToSpeech$OnInitListener java.lang.String java.lang.String boolean ), 0, this, context, onInitListener, string2, string3, bl);
    }

    private <R> R runActionNoReconnect(Action<R> action, R r, String string2, boolean bl) {
        return (R)InvokeDynamicSupport.bootstrap("runActionNoReconnect", $$robo$$android_speech_tts_TextToSpeech$runActionNoReconnect(android.speech.tts.TextToSpeech$Action<R> R java.lang.String boolean ), 0, this, action, r, string2, bl);
    }

    private <R> R runAction(Action<R> action, R r, String string2) {
        return (R)InvokeDynamicSupport.bootstrap("runAction", $$robo$$android_speech_tts_TextToSpeech$runAction(android.speech.tts.TextToSpeech$Action<R> R java.lang.String ), 0, this, action, r, string2);
    }

    private <R> R runAction(Action<R> action, R r, String string2, boolean bl, boolean bl2) {
        return (R)InvokeDynamicSupport.bootstrap("runAction", $$robo$$android_speech_tts_TextToSpeech$runAction(android.speech.tts.TextToSpeech$Action<R> R java.lang.String boolean boolean ), 0, this, action, r, string2, bl, bl2);
    }

    private int initTts() {
        return (int)InvokeDynamicSupport.bootstrap("initTts", $$robo$$android_speech_tts_TextToSpeech$initTts(), 0, this);
    }

    private boolean connectToEngine(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("connectToEngine", $$robo$$android_speech_tts_TextToSpeech$connectToEngine(java.lang.String ), 0, this, string2);
    }

    private void dispatchOnInit(int n) {
        InvokeDynamicSupport.bootstrap("dispatchOnInit", $$robo$$android_speech_tts_TextToSpeech$dispatchOnInit(int ), 0, this, n);
    }

    private IBinder getCallerIdentity() {
        return InvokeDynamicSupport.bootstrap("getCallerIdentity", $$robo$$android_speech_tts_TextToSpeech$getCallerIdentity(), 0, this);
    }

    public void shutdown() {
        InvokeDynamicSupport.bootstrap("shutdown", $$robo$$android_speech_tts_TextToSpeech$shutdown(), 0, this);
    }

    public int addSpeech(String string2, String string3, int n) {
        return (int)InvokeDynamicSupport.bootstrap("addSpeech", $$robo$$android_speech_tts_TextToSpeech$addSpeech(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    public int addSpeech(CharSequence charSequence, String string2, int n) {
        return (int)InvokeDynamicSupport.bootstrap("addSpeech", $$robo$$android_speech_tts_TextToSpeech$addSpeech(java.lang.CharSequence java.lang.String int ), 0, this, charSequence, string2, n);
    }

    public int addSpeech(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("addSpeech", $$robo$$android_speech_tts_TextToSpeech$addSpeech(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int addSpeech(CharSequence charSequence, File file) {
        return (int)InvokeDynamicSupport.bootstrap("addSpeech", $$robo$$android_speech_tts_TextToSpeech$addSpeech(java.lang.CharSequence java.io.File ), 0, this, charSequence, file);
    }

    public int addEarcon(String string2, String string3, int n) {
        return (int)InvokeDynamicSupport.bootstrap("addEarcon", $$robo$$android_speech_tts_TextToSpeech$addEarcon(java.lang.String java.lang.String int ), 0, this, string2, string3, n);
    }

    @Deprecated
    public int addEarcon(String string2, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("addEarcon", $$robo$$android_speech_tts_TextToSpeech$addEarcon(java.lang.String java.lang.String ), 0, this, string2, string3);
    }

    public int addEarcon(String string2, File file) {
        return (int)InvokeDynamicSupport.bootstrap("addEarcon", $$robo$$android_speech_tts_TextToSpeech$addEarcon(java.lang.String java.io.File ), 0, this, string2, file);
    }

    private Uri makeResourceUri(String string2, int n) {
        return InvokeDynamicSupport.bootstrap("makeResourceUri", $$robo$$android_speech_tts_TextToSpeech$makeResourceUri(java.lang.String int ), 0, this, string2, n);
    }

    public int speak(CharSequence charSequence, int n, Bundle bundle, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("speak", $$robo$$android_speech_tts_TextToSpeech$speak(java.lang.CharSequence int android.os.Bundle java.lang.String ), 0, this, charSequence, n, bundle, string2);
    }

    @Deprecated
    public int speak(String string2, int n, HashMap<String, String> hashMap) {
        return (int)InvokeDynamicSupport.bootstrap("speak", $$robo$$android_speech_tts_TextToSpeech$speak(java.lang.String int java.util.HashMap<java.lang.String, java.lang.String> ), 0, this, string2, n, hashMap);
    }

    public int playEarcon(String string2, int n, Bundle bundle, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("playEarcon", $$robo$$android_speech_tts_TextToSpeech$playEarcon(java.lang.String int android.os.Bundle java.lang.String ), 0, this, string2, n, bundle, string3);
    }

    @Deprecated
    public int playEarcon(String string2, int n, HashMap<String, String> hashMap) {
        return (int)InvokeDynamicSupport.bootstrap("playEarcon", $$robo$$android_speech_tts_TextToSpeech$playEarcon(java.lang.String int java.util.HashMap<java.lang.String, java.lang.String> ), 0, this, string2, n, hashMap);
    }

    public int playSilentUtterance(long l, int n, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("playSilentUtterance", $$robo$$android_speech_tts_TextToSpeech$playSilentUtterance(long int java.lang.String ), 0, this, l, n, string2);
    }

    @Deprecated
    public int playSilence(long l, int n, HashMap<String, String> hashMap) {
        return (int)InvokeDynamicSupport.bootstrap("playSilence", $$robo$$android_speech_tts_TextToSpeech$playSilence(long int java.util.HashMap<java.lang.String, java.lang.String> ), 0, this, l, n, hashMap);
    }

    @Deprecated
    public Set<String> getFeatures(Locale locale) {
        return InvokeDynamicSupport.bootstrap("getFeatures", $$robo$$android_speech_tts_TextToSpeech$getFeatures(java.util.Locale ), 0, this, locale);
    }

    public boolean isSpeaking() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSpeaking", $$robo$$android_speech_tts_TextToSpeech$isSpeaking(), 0, this);
    }

    public int stop() {
        return (int)InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_TextToSpeech$stop(), 0, this);
    }

    public int setSpeechRate(float f) {
        return (int)InvokeDynamicSupport.bootstrap("setSpeechRate", $$robo$$android_speech_tts_TextToSpeech$setSpeechRate(float ), 0, this, f);
    }

    public int setPitch(float f) {
        return (int)InvokeDynamicSupport.bootstrap("setPitch", $$robo$$android_speech_tts_TextToSpeech$setPitch(float ), 0, this, f);
    }

    public int setAudioAttributes(AudioAttributes audioAttributes) {
        return (int)InvokeDynamicSupport.bootstrap("setAudioAttributes", $$robo$$android_speech_tts_TextToSpeech$setAudioAttributes(android.media.AudioAttributes ), 0, this, audioAttributes);
    }

    public String getCurrentEngine() {
        return InvokeDynamicSupport.bootstrap("getCurrentEngine", $$robo$$android_speech_tts_TextToSpeech$getCurrentEngine(), 0, this);
    }

    @Deprecated
    public Locale getDefaultLanguage() {
        return InvokeDynamicSupport.bootstrap("getDefaultLanguage", $$robo$$android_speech_tts_TextToSpeech$getDefaultLanguage(), 0, this);
    }

    public int setLanguage(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrap("setLanguage", $$robo$$android_speech_tts_TextToSpeech$setLanguage(java.util.Locale ), 0, this, locale);
    }

    @Deprecated
    public Locale getLanguage() {
        return InvokeDynamicSupport.bootstrap("getLanguage", $$robo$$android_speech_tts_TextToSpeech$getLanguage(), 0, this);
    }

    public Set<Locale> getAvailableLanguages() {
        return InvokeDynamicSupport.bootstrap("getAvailableLanguages", $$robo$$android_speech_tts_TextToSpeech$getAvailableLanguages(), 0, this);
    }

    public Set<Voice> getVoices() {
        return InvokeDynamicSupport.bootstrap("getVoices", $$robo$$android_speech_tts_TextToSpeech$getVoices(), 0, this);
    }

    public int setVoice(Voice voice) {
        return (int)InvokeDynamicSupport.bootstrap("setVoice", $$robo$$android_speech_tts_TextToSpeech$setVoice(android.speech.tts.Voice ), 0, this, voice);
    }

    public Voice getVoice() {
        return InvokeDynamicSupport.bootstrap("getVoice", $$robo$$android_speech_tts_TextToSpeech$getVoice(), 0, this);
    }

    private Voice getVoice(ITextToSpeechService iTextToSpeechService, String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrap("getVoice", $$robo$$android_speech_tts_TextToSpeech$getVoice(android.speech.tts.ITextToSpeechService java.lang.String ), 0, this, iTextToSpeechService, string2);
    }

    public Voice getDefaultVoice() {
        return InvokeDynamicSupport.bootstrap("getDefaultVoice", $$robo$$android_speech_tts_TextToSpeech$getDefaultVoice(), 0, this);
    }

    public int isLanguageAvailable(Locale locale) {
        return (int)InvokeDynamicSupport.bootstrap("isLanguageAvailable", $$robo$$android_speech_tts_TextToSpeech$isLanguageAvailable(java.util.Locale ), 0, this, locale);
    }

    public int synthesizeToFile(CharSequence charSequence, Bundle bundle, File file, String string2) {
        return (int)InvokeDynamicSupport.bootstrap("synthesizeToFile", $$robo$$android_speech_tts_TextToSpeech$synthesizeToFile(java.lang.CharSequence android.os.Bundle java.io.File java.lang.String ), 0, this, charSequence, bundle, file, string2);
    }

    @Deprecated
    public int synthesizeToFile(String string2, HashMap<String, String> hashMap, String string3) {
        return (int)InvokeDynamicSupport.bootstrap("synthesizeToFile", $$robo$$android_speech_tts_TextToSpeech$synthesizeToFile(java.lang.String java.util.HashMap<java.lang.String, java.lang.String> java.lang.String ), 0, this, string2, hashMap, string3);
    }

    private Bundle convertParamsHashMaptoBundle(HashMap<String, String> hashMap) {
        return InvokeDynamicSupport.bootstrap("convertParamsHashMaptoBundle", $$robo$$android_speech_tts_TextToSpeech$convertParamsHashMaptoBundle(java.util.HashMap<java.lang.String, java.lang.String> ), 0, this, hashMap);
    }

    private Bundle getParams(Bundle bundle) {
        return InvokeDynamicSupport.bootstrap("getParams", $$robo$$android_speech_tts_TextToSpeech$getParams(android.os.Bundle ), 0, this, bundle);
    }

    private static boolean verifyIntegerBundleParam(Bundle bundle, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyIntegerBundleParam", $$robo$$android_speech_tts_TextToSpeech$verifyIntegerBundleParam(android.os.Bundle java.lang.String ), 0, (Bundle)bundle, (String)string2);
    }

    private static boolean verifyStringBundleParam(Bundle bundle, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyStringBundleParam", $$robo$$android_speech_tts_TextToSpeech$verifyStringBundleParam(android.os.Bundle java.lang.String ), 0, (Bundle)bundle, (String)string2);
    }

    private static boolean verifyBooleanBundleParam(Bundle bundle, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyBooleanBundleParam", $$robo$$android_speech_tts_TextToSpeech$verifyBooleanBundleParam(android.os.Bundle java.lang.String ), 0, (Bundle)bundle, (String)string2);
    }

    private static boolean verifyFloatBundleParam(Bundle bundle, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyFloatBundleParam", $$robo$$android_speech_tts_TextToSpeech$verifyFloatBundleParam(android.os.Bundle java.lang.String ), 0, (Bundle)bundle, (String)string2);
    }

    private void copyStringParam(Bundle bundle, HashMap<String, String> hashMap, String string2) {
        InvokeDynamicSupport.bootstrap("copyStringParam", $$robo$$android_speech_tts_TextToSpeech$copyStringParam(android.os.Bundle java.util.HashMap<java.lang.String, java.lang.String> java.lang.String ), 0, this, bundle, hashMap, string2);
    }

    private void copyIntParam(Bundle bundle, HashMap<String, String> hashMap, String string2) {
        InvokeDynamicSupport.bootstrap("copyIntParam", $$robo$$android_speech_tts_TextToSpeech$copyIntParam(android.os.Bundle java.util.HashMap<java.lang.String, java.lang.String> java.lang.String ), 0, this, bundle, hashMap, string2);
    }

    private void copyFloatParam(Bundle bundle, HashMap<String, String> hashMap, String string2) {
        InvokeDynamicSupport.bootstrap("copyFloatParam", $$robo$$android_speech_tts_TextToSpeech$copyFloatParam(android.os.Bundle java.util.HashMap<java.lang.String, java.lang.String> java.lang.String ), 0, this, bundle, hashMap, string2);
    }

    @Deprecated
    public int setOnUtteranceCompletedListener(OnUtteranceCompletedListener onUtteranceCompletedListener) {
        return (int)InvokeDynamicSupport.bootstrap("setOnUtteranceCompletedListener", $$robo$$android_speech_tts_TextToSpeech$setOnUtteranceCompletedListener(android.speech.tts.TextToSpeech$OnUtteranceCompletedListener ), 0, this, onUtteranceCompletedListener);
    }

    public int setOnUtteranceProgressListener(UtteranceProgressListener utteranceProgressListener) {
        return (int)InvokeDynamicSupport.bootstrap("setOnUtteranceProgressListener", $$robo$$android_speech_tts_TextToSpeech$setOnUtteranceProgressListener(android.speech.tts.UtteranceProgressListener ), 0, this, utteranceProgressListener);
    }

    @Deprecated
    public int setEngineByPackageName(String string2) {
        return (int)InvokeDynamicSupport.bootstrap("setEngineByPackageName", $$robo$$android_speech_tts_TextToSpeech$setEngineByPackageName(java.lang.String ), 0, this, string2);
    }

    public String getDefaultEngine() {
        return InvokeDynamicSupport.bootstrap("getDefaultEngine", $$robo$$android_speech_tts_TextToSpeech$getDefaultEngine(), 0, this);
    }

    @Deprecated
    public boolean areDefaultsEnforced() {
        return (boolean)InvokeDynamicSupport.bootstrap("areDefaultsEnforced", $$robo$$android_speech_tts_TextToSpeech$areDefaultsEnforced(), 0, this);
    }

    public List<EngineInfo> getEngines() {
        return InvokeDynamicSupport.bootstrap("getEngines", $$robo$$android_speech_tts_TextToSpeech$getEngines(), 0, this);
    }

    public static int getMaxSpeechInputLength() {
        return (int)InvokeDynamicSupport.bootstrapStatic("getMaxSpeechInputLength", $$robo$$android_speech_tts_TextToSpeech$getMaxSpeechInputLength(), 0);
    }

    public /* synthetic */ TextToSpeech() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextToSpeech)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class EngineInfo
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public String name;
        public String label;
        public int icon;
        public boolean system;
        public int priority;

        private void $$robo$$android_speech_tts_TextToSpeech_EngineInfo$__constructor__() {
        }

        private final String $$robo$$android_speech_tts_TextToSpeech_EngineInfo$toString() {
            return "EngineInfo{name=" + this.name + "}";
        }

        private void __constructor__() {
            this.$$robo$$android_speech_tts_TextToSpeech_EngineInfo$__constructor__();
        }

        public EngineInfo() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_EngineInfo$__constructor__(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_speech_tts_TextToSpeech_EngineInfo$toString(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EngineInfo)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static interface Action<R> {
        public R run(ITextToSpeechService var1) throws RemoteException;
    }

    private class Connection
    implements ServiceConnection,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private ITextToSpeechService mService;
        private SetupConnectionAsyncTask mOnSetupConnectionAsyncTask;
        private boolean mEstablished;
        private ITextToSpeechCallback.Stub mCallback;
        /* synthetic */ TextToSpeech this$0;

        private void $$robo$$android_speech_tts_TextToSpeech_Connection$__constructor__(TextToSpeech textToSpeech) {
            this.mCallback = new ShadowedObject(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ Connection this$1;

                private void $$robo$$android_speech_tts_TextToSpeech_Connection_1$__constructor__(Connection this$1) {
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onStop(String utteranceId, boolean isStarted) throws RemoteException {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onStop(utteranceId, isStarted);
                    }
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onSuccess(String utteranceId) {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onDone(utteranceId);
                    }
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onError(String utteranceId, int errorCode) {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onError(utteranceId);
                    }
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onStart(String utteranceId) {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onStart(utteranceId);
                    }
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onBeginSynthesis(String utteranceId, int sampleRateInHz, int audioFormat, int channelCount) {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onBeginSynthesis(utteranceId, sampleRateInHz, audioFormat, channelCount);
                    }
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onAudioAvailable(String utteranceId, byte[] audio) {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onAudioAvailable(utteranceId, audio);
                    }
                }

                private final void $$robo$$android_speech_tts_TextToSpeech_Connection_1$onRangeStart(String utteranceId, int start, int end, int frame) {
                    UtteranceProgressListener listener = this.this$1.this$0.mUtteranceProgressListener;
                    if (listener != null) {
                        listener.onRangeStart(utteranceId, start, end, frame);
                    }
                }

                private void __constructor__(Connection connection) {
                    this.$$robo$$android_speech_tts_TextToSpeech_Connection_1$__constructor__(connection);
                }
                {
                    this.this$1 = connection;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_Connection_1$__constructor__(android.speech.tts.TextToSpeech$Connection ), 0, this, connection);
                }

                @Override
                public void onStop(String string2, boolean bl) throws RemoteException {
                    InvokeDynamicSupport.bootstrap("onStop", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onStop(java.lang.String boolean ), 0, this, string2, bl);
                }

                @Override
                public void onSuccess(String string2) {
                    InvokeDynamicSupport.bootstrap("onSuccess", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onSuccess(java.lang.String ), 0, this, string2);
                }

                @Override
                public void onError(String string2, int n) {
                    InvokeDynamicSupport.bootstrap("onError", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onError(java.lang.String int ), 0, this, string2, n);
                }

                @Override
                public void onStart(String string2) {
                    InvokeDynamicSupport.bootstrap("onStart", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onStart(java.lang.String ), 0, this, string2);
                }

                @Override
                public void onBeginSynthesis(String string2, int n, int n2, int n3) {
                    InvokeDynamicSupport.bootstrap("onBeginSynthesis", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onBeginSynthesis(java.lang.String int int int ), 0, this, string2, n, n2, n3);
                }

                @Override
                public void onAudioAvailable(String string2, byte[] byArray) {
                    InvokeDynamicSupport.bootstrap("onAudioAvailable", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onAudioAvailable(java.lang.String byte[] ), 0, this, string2, byArray);
                }

                @Override
                public void onRangeStart(String string2, int n, int n2, int n3) {
                    InvokeDynamicSupport.bootstrap("onRangeStart", $$robo$$android_speech_tts_TextToSpeech_Connection_1$onRangeStart(java.lang.String int int int ), 0, this, string2, n, n2, n3);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_speech_tts_TextToSpeech_Connection$onServiceConnected(ComponentName name, IBinder service) {
            Object object = this.this$0.mStartLock;
            synchronized (object) {
                this.this$0.mConnectingServiceConnection = null;
                Log.i("TextToSpeech", "Connected to " + name);
                if (this.mOnSetupConnectionAsyncTask != null) {
                    this.mOnSetupConnectionAsyncTask.cancel(false);
                }
                this.mService = ITextToSpeechService.Stub.asInterface(service);
                this.this$0.mServiceConnection = this;
                this.mEstablished = false;
                this.mOnSetupConnectionAsyncTask = new SetupConnectionAsyncTask(this, name);
                this.mOnSetupConnectionAsyncTask.execute(new Void[0]);
            }
        }

        private final IBinder $$robo$$android_speech_tts_TextToSpeech_Connection$getCallerIdentity() {
            return this.mCallback;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean $$robo$$android_speech_tts_TextToSpeech_Connection$clearServiceConnection() {
            Object object = this.this$0.mStartLock;
            synchronized (object) {
                boolean result = false;
                if (this.mOnSetupConnectionAsyncTask != null) {
                    result = this.mOnSetupConnectionAsyncTask.cancel(false);
                    this.mOnSetupConnectionAsyncTask = null;
                }
                this.mService = null;
                if (this.this$0.mServiceConnection == this) {
                    this.this$0.mServiceConnection = null;
                }
                return result;
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeech_Connection$onServiceDisconnected(ComponentName name) {
            Log.i("TextToSpeech", "Asked to disconnect from " + name);
            if (this.clearServiceConnection()) {
                this.this$0.dispatchOnInit(-1);
            }
        }

        private final void $$robo$$android_speech_tts_TextToSpeech_Connection$disconnect() {
            this.this$0.mContext.unbindService(this);
            this.clearServiceConnection();
        }

        private final boolean $$robo$$android_speech_tts_TextToSpeech_Connection$isEstablished() {
            return this.mService != null && this.mEstablished;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <R> R $$robo$$android_speech_tts_TextToSpeech_Connection$runAction(Action<R> action, R errorResult, String method, boolean reconnect, boolean onlyEstablishedConnection) {
            Object object = this.this$0.mStartLock;
            synchronized (object) {
                try {
                    if (this.mService == null) {
                        Log.w("TextToSpeech", method + " failed: not connected to TTS engine");
                        return errorResult;
                    }
                    if (onlyEstablishedConnection && !this.isEstablished()) {
                        Log.w("TextToSpeech", method + " failed: TTS engine connection not fully set up");
                        return errorResult;
                    }
                    return action.run(this.mService);
                }
                catch (RemoteException ex) {
                    Log.e("TextToSpeech", method + " failed", ex);
                    if (reconnect) {
                        this.disconnect();
                        this.this$0.initTts();
                    }
                    return errorResult;
                }
            }
        }

        private /* synthetic */ void $$robo$$android_speech_tts_TextToSpeech_Connection$__constructor__(TextToSpeech x0, 1 x1) {
        }

        private void __constructor__(TextToSpeech textToSpeech) {
            this.$$robo$$android_speech_tts_TextToSpeech_Connection$__constructor__(textToSpeech);
        }

        private Connection(TextToSpeech textToSpeech) {
            this.this$0 = textToSpeech;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_Connection$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
        }

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InvokeDynamicSupport.bootstrap("onServiceConnected", $$robo$$android_speech_tts_TextToSpeech_Connection$onServiceConnected(android.content.ComponentName android.os.IBinder ), 0, this, componentName, iBinder);
        }

        public IBinder getCallerIdentity() {
            return InvokeDynamicSupport.bootstrap("getCallerIdentity", $$robo$$android_speech_tts_TextToSpeech_Connection$getCallerIdentity(), 0, this);
        }

        private boolean clearServiceConnection() {
            return (boolean)InvokeDynamicSupport.bootstrap("clearServiceConnection", $$robo$$android_speech_tts_TextToSpeech_Connection$clearServiceConnection(), 0, this);
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            InvokeDynamicSupport.bootstrap("onServiceDisconnected", $$robo$$android_speech_tts_TextToSpeech_Connection$onServiceDisconnected(android.content.ComponentName ), 0, this, componentName);
        }

        public void disconnect() {
            InvokeDynamicSupport.bootstrap("disconnect", $$robo$$android_speech_tts_TextToSpeech_Connection$disconnect(), 0, this);
        }

        public boolean isEstablished() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEstablished", $$robo$$android_speech_tts_TextToSpeech_Connection$isEstablished(), 0, this);
        }

        public <R> R runAction(Action<R> action, R r, String string2, boolean bl, boolean bl2) {
            return (R)InvokeDynamicSupport.bootstrap("runAction", $$robo$$android_speech_tts_TextToSpeech_Connection$runAction(android.speech.tts.TextToSpeech$Action<R> R java.lang.String boolean boolean ), 0, this, action, r, string2, bl, bl2);
        }

        private /* synthetic */ void __constructor__(TextToSpeech textToSpeech, 1 var2_2) {
            this.$$robo$$android_speech_tts_TextToSpeech_Connection$__constructor__(textToSpeech, var2_2);
        }

        public /* synthetic */ Connection() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Connection)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }

        private class SetupConnectionAsyncTask
        extends AsyncTask<Void, Void, Integer> {
            public transient /* synthetic */ Object __robo_data__;
            private ComponentName mName;
            /* synthetic */ Connection this$1;

            private void $$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$__constructor__(Connection connection, ComponentName name) {
                this.mName = name;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final Integer $$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$doInBackground(Void ... params) {
                Object object = this.this$1.this$0.mStartLock;
                synchronized (object) {
                    if (this.isCancelled()) {
                        return null;
                    }
                    try {
                        this.this$1.mService.setCallback(this.this$1.getCallerIdentity(), this.this$1.mCallback);
                        if (this.this$1.this$0.mParams.getString("language") == null) {
                            String[] defaultLanguage = this.this$1.mService.getClientDefaultLanguage();
                            this.this$1.this$0.mParams.putString("language", defaultLanguage[0]);
                            this.this$1.this$0.mParams.putString("country", defaultLanguage[1]);
                            this.this$1.this$0.mParams.putString("variant", defaultLanguage[2]);
                            String defaultVoiceName = this.this$1.mService.getDefaultVoiceNameFor(defaultLanguage[0], defaultLanguage[1], defaultLanguage[2]);
                            this.this$1.this$0.mParams.putString("voiceName", defaultVoiceName);
                        }
                        Log.i("TextToSpeech", "Set up connection to " + this.mName);
                        return 0;
                    }
                    catch (RemoteException re) {
                        Log.e("TextToSpeech", "Error connecting to service, setCallback() failed");
                        return -1;
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private final void $$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$onPostExecute(Integer result) {
                Object object = this.this$1.this$0.mStartLock;
                synchronized (object) {
                    if (this.this$1.mOnSetupConnectionAsyncTask == this) {
                        this.this$1.mOnSetupConnectionAsyncTask = null;
                    }
                    this.this$1.mEstablished = true;
                    this.this$1.this$0.dispatchOnInit(result);
                }
            }

            private void __constructor__(Connection connection, ComponentName componentName) {
                this.$$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$__constructor__(connection, componentName);
            }

            public SetupConnectionAsyncTask(Connection connection, ComponentName componentName) {
                this.this$1 = connection;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$__constructor__(android.speech.tts.TextToSpeech$Connection android.content.ComponentName ), 0, this, connection, componentName);
            }

            protected Integer doInBackground(Void ... voidArray) {
                return InvokeDynamicSupport.bootstrap("doInBackground", $$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$doInBackground(java.lang.Void[] ), 0, this, voidArray);
            }

            @Override
            protected void onPostExecute(Integer n) {
                InvokeDynamicSupport.bootstrap("onPostExecute", $$robo$$android_speech_tts_TextToSpeech_Connection_SetupConnectionAsyncTask$onPostExecute(java.lang.Integer ), 0, this, n);
            }

            public /* synthetic */ SetupConnectionAsyncTask() {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SetupConnectionAsyncTask)this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }
    }

    public class Engine
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static int DEFAULT_RATE = 100;
        public static int DEFAULT_PITCH = 100;
        public static float DEFAULT_VOLUME = 1.0f;
        public static float DEFAULT_PAN = 0.0f;
        public static int USE_DEFAULTS = 0;
        @Deprecated
        public static String DEFAULT_ENGINE = "com.svox.pico";
        public static int DEFAULT_STREAM = 3;
        public static int CHECK_VOICE_DATA_PASS = 1;
        public static int CHECK_VOICE_DATA_FAIL = 0;
        @Deprecated
        public static int CHECK_VOICE_DATA_BAD_DATA = -1;
        @Deprecated
        public static int CHECK_VOICE_DATA_MISSING_DATA = -2;
        @Deprecated
        public static int CHECK_VOICE_DATA_MISSING_VOLUME = -3;
        public static String INTENT_ACTION_TTS_SERVICE = "android.intent.action.TTS_SERVICE";
        public static String SERVICE_META_DATA = "android.speech.tts";
        public static String ACTION_INSTALL_TTS_DATA = "android.speech.tts.engine.INSTALL_TTS_DATA";
        public static String ACTION_TTS_DATA_INSTALLED = "android.speech.tts.engine.TTS_DATA_INSTALLED";
        public static String ACTION_CHECK_TTS_DATA = "android.speech.tts.engine.CHECK_TTS_DATA";
        public static String ACTION_GET_SAMPLE_TEXT = "android.speech.tts.engine.GET_SAMPLE_TEXT";
        public static String EXTRA_SAMPLE_TEXT = "sampleText";
        public static String EXTRA_AVAILABLE_VOICES = "availableVoices";
        public static String EXTRA_UNAVAILABLE_VOICES = "unavailableVoices";
        @Deprecated
        public static String EXTRA_VOICE_DATA_ROOT_DIRECTORY = "dataRoot";
        @Deprecated
        public static String EXTRA_VOICE_DATA_FILES = "dataFiles";
        @Deprecated
        public static String EXTRA_VOICE_DATA_FILES_INFO = "dataFilesInfo";
        @Deprecated
        public static String EXTRA_CHECK_VOICE_DATA_FOR = "checkVoiceDataFor";
        @Deprecated
        public static String EXTRA_TTS_DATA_INSTALLED = "dataInstalled";
        public static String KEY_PARAM_RATE = "rate";
        public static String KEY_PARAM_VOICE_NAME = "voiceName";
        public static String KEY_PARAM_LANGUAGE = "language";
        public static String KEY_PARAM_COUNTRY = "country";
        public static String KEY_PARAM_VARIANT = "variant";
        public static String KEY_PARAM_ENGINE = "engine";
        public static String KEY_PARAM_PITCH = "pitch";
        public static String KEY_PARAM_STREAM = "streamType";
        public static String KEY_PARAM_AUDIO_ATTRIBUTES = "audioAttributes";
        public static String KEY_PARAM_UTTERANCE_ID = "utteranceId";
        public static String KEY_PARAM_VOLUME = "volume";
        public static String KEY_PARAM_PAN = "pan";
        @Deprecated
        public static String KEY_FEATURE_NETWORK_SYNTHESIS = "networkTts";
        @Deprecated
        public static String KEY_FEATURE_EMBEDDED_SYNTHESIS = "embeddedTts";
        public static String KEY_PARAM_SESSION_ID = "sessionId";
        public static String KEY_FEATURE_NOT_INSTALLED = "notInstalled";
        public static String KEY_FEATURE_NETWORK_TIMEOUT_MS = "networkTimeoutMs";
        public static String KEY_FEATURE_NETWORK_RETRIES_COUNT = "networkRetriesCount";
        /* synthetic */ TextToSpeech this$0;

        private void $$robo$$android_speech_tts_TextToSpeech_Engine$__constructor__(TextToSpeech this$0) {
        }

        private void __constructor__(TextToSpeech textToSpeech) {
            this.$$robo$$android_speech_tts_TextToSpeech_Engine$__constructor__(textToSpeech);
        }

        public Engine(TextToSpeech textToSpeech) {
            this.this$0 = textToSpeech;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_TextToSpeech_Engine$__constructor__(android.speech.tts.TextToSpeech ), 0, this, textToSpeech);
        }

        public /* synthetic */ Engine() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Engine)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Deprecated
    public static interface OnUtteranceCompletedListener
    extends InstrumentedInterface {
        public void onUtteranceCompleted(String var1);
    }

    public static interface OnInitListener
    extends InstrumentedInterface {
        public void onInit(int var1);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={-3L, -4L, -5L, -6L, -7L, -8L, -9L})
    public static @interface Error {
    }
}

