/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.speech.tts.AbstractEventLogger;
import android.speech.tts.AbstractSynthesisCallback;
import android.speech.tts.AudioPlaybackHandler;
import android.speech.tts.BlockingAudioTrack;
import android.speech.tts.SynthesisPlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class PlaybackSynthesisCallback
extends AbstractSynthesisCallback
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "PlaybackSynthesisRequest";
    private static boolean DBG = false;
    private static int MIN_AUDIO_BUFFER_SIZE = 8192;
    private TextToSpeechService.AudioOutputParams mAudioParams;
    private Object mStateLock;
    private AudioPlaybackHandler mAudioTrackHandler;
    private SynthesisPlaybackQueueItem mItem;
    private volatile boolean mDone;
    protected int mStatusCode;
    private TextToSpeechService.UtteranceProgressDispatcher mDispatcher;
    private Object mCallerIdentity;
    private AbstractEventLogger mLogger;

    private void $$robo$$android_speech_tts_PlaybackSynthesisCallback$__constructor__(TextToSpeechService.AudioOutputParams audioParams, AudioPlaybackHandler audioTrackHandler, TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, AbstractEventLogger logger, boolean clientIsUsingV2) {
        this.mStateLock = new Object();
        this.mItem = null;
        this.mDone = false;
        this.mAudioParams = audioParams;
        this.mAudioTrackHandler = audioTrackHandler;
        this.mDispatcher = dispatcher;
        this.mCallerIdentity = callerIdentity;
        this.mLogger = logger;
        this.mStatusCode = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_PlaybackSynthesisCallback$stop() {
        SynthesisPlaybackQueueItem item;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            if (this.mStatusCode == -2) {
                Log.w("PlaybackSynthesisRequest", "stop() called twice");
                return;
            }
            item = this.mItem;
            this.mStatusCode = -2;
        }
        if (item != null) {
            item.stop(-2);
        } else {
            this.mLogger.onCompleted(-2);
            this.mDispatcher.dispatchOnStop();
        }
    }

    private final int $$robo$$android_speech_tts_PlaybackSynthesisCallback$getMaxBufferSize() {
        return 8192;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_speech_tts_PlaybackSynthesisCallback$hasStarted() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mItem != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_speech_tts_PlaybackSynthesisCallback$hasFinished() {
        Object object = this.mStateLock;
        synchronized (object) {
            return this.mDone;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_PlaybackSynthesisCallback$start(int sampleRateInHz, int audioFormat, int channelCount) {
        if (audioFormat != 3 && audioFormat != 2 && audioFormat != 4) {
            Log.w("PlaybackSynthesisRequest", "Audio format encoding " + audioFormat + " not supported. Please use one of AudioFormat.ENCODING_PCM_8BIT, AudioFormat.ENCODING_PCM_16BIT or AudioFormat.ENCODING_PCM_FLOAT");
        }
        this.mDispatcher.dispatchOnBeginSynthesis(sampleRateInHz, audioFormat, channelCount);
        int channelConfig = BlockingAudioTrack.getChannelConfig(channelCount);
        Object object = this.mStateLock;
        synchronized (object) {
            if (channelConfig == 0) {
                Log.e("PlaybackSynthesisRequest", "Unsupported number of channels :" + channelCount);
                this.mStatusCode = -5;
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mItem != null) {
                Log.e("PlaybackSynthesisRequest", "Start called twice");
                return -1;
            }
            SynthesisPlaybackQueueItem item = new SynthesisPlaybackQueueItem(this.mAudioParams, sampleRateInHz, audioFormat, channelCount, this.mDispatcher, this.mCallerIdentity, this.mLogger);
            this.mAudioTrackHandler.enqueue(item);
            this.mItem = item;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_PlaybackSynthesisCallback$audioAvailable(byte[] buffer, int offset, int length) {
        if (length > this.getMaxBufferSize() || length <= 0) {
            throw new IllegalArgumentException("buffer is too large or of zero length (" + length + " bytes)");
        }
        SynthesisPlaybackQueueItem item = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mItem == null) {
                this.mStatusCode = -5;
                return -1;
            }
            if (this.mStatusCode != 0) {
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            item = this.mItem;
        }
        byte[] bufferCopy = new byte[length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])buffer, (int)offset, (byte[])bufferCopy, (int)0, (int)length);
        this.mDispatcher.dispatchOnAudioAvailable(bufferCopy);
        try {
            item.put(bufferCopy);
        }
        catch (InterruptedException ie) {
            Object object2 = this.mStateLock;
            synchronized (object2) {
                this.mStatusCode = -5;
                return -1;
            }
        }
        this.mLogger.onEngineDataReceived();
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_speech_tts_PlaybackSynthesisCallback$done() {
        int statusCode = 0;
        SynthesisPlaybackQueueItem item = null;
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                Log.w("PlaybackSynthesisRequest", "Duplicate call to done()");
                return -1;
            }
            if (this.mStatusCode == -2) {
                return this.errorCodeOnStop();
            }
            this.mDone = true;
            if (this.mItem == null) {
                Log.w("PlaybackSynthesisRequest", "done() was called before start() call");
                if (this.mStatusCode == 0) {
                    this.mDispatcher.dispatchOnSuccess();
                } else {
                    this.mDispatcher.dispatchOnError(this.mStatusCode);
                }
                this.mLogger.onEngineComplete();
                return -1;
            }
            item = this.mItem;
            statusCode = this.mStatusCode;
        }
        if (statusCode == 0) {
            item.done();
        } else {
            item.stop(statusCode);
        }
        this.mLogger.onEngineComplete();
        return 0;
    }

    private final void $$robo$$android_speech_tts_PlaybackSynthesisCallback$error() {
        this.error(-3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_speech_tts_PlaybackSynthesisCallback$error(int errorCode) {
        Object object = this.mStateLock;
        synchronized (object) {
            if (this.mDone) {
                return;
            }
            this.mStatusCode = errorCode;
        }
    }

    private final void $$robo$$android_speech_tts_PlaybackSynthesisCallback$rangeStart(int markerInFrames, int start, int end) {
        if (this.mItem == null) {
            Log.e("PlaybackSynthesisRequest", "mItem is null");
            return;
        }
        this.mItem.rangeStart(markerInFrames, start, end);
    }

    private void __constructor__(TextToSpeechService.AudioOutputParams audioOutputParams, AudioPlaybackHandler audioPlaybackHandler, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, AbstractEventLogger abstractEventLogger, boolean bl) {
        this.$$robo$$android_speech_tts_PlaybackSynthesisCallback$__constructor__(audioOutputParams, audioPlaybackHandler, utteranceProgressDispatcher, object, abstractEventLogger, bl);
    }

    PlaybackSynthesisCallback(TextToSpeechService.AudioOutputParams audioOutputParams, AudioPlaybackHandler audioPlaybackHandler, TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, AbstractEventLogger abstractEventLogger, boolean bl) {
        super(bl);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_PlaybackSynthesisCallback$__constructor__(android.speech.tts.TextToSpeechService$AudioOutputParams android.speech.tts.AudioPlaybackHandler android.speech.tts.TextToSpeechService$UtteranceProgressDispatcher java.lang.Object android.speech.tts.AbstractEventLogger boolean ), 0, this, audioOutputParams, audioPlaybackHandler, utteranceProgressDispatcher, object, abstractEventLogger, bl);
    }

    @Override
    void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_PlaybackSynthesisCallback$stop(), 0, this);
    }

    @Override
    public int getMaxBufferSize() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxBufferSize", $$robo$$android_speech_tts_PlaybackSynthesisCallback$getMaxBufferSize(), 0, this);
    }

    @Override
    public boolean hasStarted() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasStarted", $$robo$$android_speech_tts_PlaybackSynthesisCallback$hasStarted(), 0, this);
    }

    @Override
    public boolean hasFinished() {
        return (boolean)InvokeDynamicSupport.bootstrap("hasFinished", $$robo$$android_speech_tts_PlaybackSynthesisCallback$hasFinished(), 0, this);
    }

    @Override
    public int start(int n, int n2, int n3) {
        return (int)InvokeDynamicSupport.bootstrap("start", $$robo$$android_speech_tts_PlaybackSynthesisCallback$start(int int int ), 0, this, n, n2, n3);
    }

    @Override
    public int audioAvailable(byte[] byArray, int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("audioAvailable", $$robo$$android_speech_tts_PlaybackSynthesisCallback$audioAvailable(byte[] int int ), 0, this, byArray, n, n2);
    }

    @Override
    public int done() {
        return (int)InvokeDynamicSupport.bootstrap("done", $$robo$$android_speech_tts_PlaybackSynthesisCallback$done(), 0, this);
    }

    @Override
    public void error() {
        InvokeDynamicSupport.bootstrap("error", $$robo$$android_speech_tts_PlaybackSynthesisCallback$error(), 0, this);
    }

    @Override
    public void error(int n) {
        InvokeDynamicSupport.bootstrap("error", $$robo$$android_speech_tts_PlaybackSynthesisCallback$error(int ), 0, this, n);
    }

    @Override
    public void rangeStart(int n, int n2, int n3) {
        InvokeDynamicSupport.bootstrap("rangeStart", $$robo$$android_speech_tts_PlaybackSynthesisCallback$rangeStart(int int int ), 0, this, n, n2, n3);
    }

    public /* synthetic */ PlaybackSynthesisCallback() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PlaybackSynthesisCallback)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

