/*
 * Decompiled with CFR 0.152.
 */
package android.speech.tts;

import android.content.Context;
import android.media.MediaPlayer;
import android.net.Uri;
import android.os.ConditionVariable;
import android.speech.tts.PlaybackQueueItem;
import android.speech.tts.TextToSpeechService;
import android.util.Log;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AudioPlaybackQueueItem
extends PlaybackQueueItem
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "TTS.AudioQueueItem";
    private Context mContext;
    private Uri mUri;
    private TextToSpeechService.AudioOutputParams mAudioParams;
    private ConditionVariable mDone;
    private MediaPlayer mPlayer;
    private volatile boolean mFinished;

    private void $$robo$$android_speech_tts_AudioPlaybackQueueItem$__constructor__(TextToSpeechService.UtteranceProgressDispatcher dispatcher, Object callerIdentity, Context context, Uri uri, TextToSpeechService.AudioOutputParams audioParams) {
        this.mContext = context;
        this.mUri = uri;
        this.mAudioParams = audioParams;
        this.mDone = new ConditionVariable();
        this.mPlayer = null;
        this.mFinished = false;
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackQueueItem$run() {
        TextToSpeechService.UtteranceProgressDispatcher dispatcher = this.getDispatcher();
        dispatcher.dispatchOnStart();
        int sessionId = this.mAudioParams.mSessionId;
        this.mPlayer = MediaPlayer.create(this.mContext, this.mUri, null, this.mAudioParams.mAudioAttributes, sessionId > 0 ? sessionId : 0);
        if (this.mPlayer == null) {
            dispatcher.dispatchOnError(-5);
            return;
        }
        try {
            this.mPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioPlaybackQueueItem this$0;

                private void $$robo$$android_speech_tts_AudioPlaybackQueueItem_1$__constructor__(AudioPlaybackQueueItem this$0) {
                }

                private final boolean $$robo$$android_speech_tts_AudioPlaybackQueueItem_1$onError(MediaPlayer mp, int what, int extra) {
                    Log.w("TTS.AudioQueueItem", "Audio playback error: " + what + ", " + extra);
                    this.this$0.mDone.open();
                    return true;
                }

                private void __constructor__(AudioPlaybackQueueItem audioPlaybackQueueItem) {
                    this.$$robo$$android_speech_tts_AudioPlaybackQueueItem_1$__constructor__(audioPlaybackQueueItem);
                }
                {
                    this.this$0 = audioPlaybackQueueItem;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_AudioPlaybackQueueItem_1$__constructor__(android.speech.tts.AudioPlaybackQueueItem ), 0, this, audioPlaybackQueueItem);
                }

                @Override
                public boolean onError(MediaPlayer mediaPlayer, int n, int n2) {
                    return (boolean)InvokeDynamicSupport.bootstrap("onError", $$robo$$android_speech_tts_AudioPlaybackQueueItem_1$onError(android.media.MediaPlayer int int ), 0, this, mediaPlayer, n, n2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            this.mPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(this){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ AudioPlaybackQueueItem this$0;

                private void $$robo$$android_speech_tts_AudioPlaybackQueueItem_2$__constructor__(AudioPlaybackQueueItem this$0) {
                }

                private final void $$robo$$android_speech_tts_AudioPlaybackQueueItem_2$onCompletion(MediaPlayer mp) {
                    this.this$0.mFinished = true;
                    this.this$0.mDone.open();
                }

                private void __constructor__(AudioPlaybackQueueItem audioPlaybackQueueItem) {
                    this.$$robo$$android_speech_tts_AudioPlaybackQueueItem_2$__constructor__(audioPlaybackQueueItem);
                }
                {
                    this.this$0 = audioPlaybackQueueItem;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_AudioPlaybackQueueItem_2$__constructor__(android.speech.tts.AudioPlaybackQueueItem ), 0, this, audioPlaybackQueueItem);
                }

                @Override
                public void onCompletion(MediaPlayer mediaPlayer) {
                    InvokeDynamicSupport.bootstrap("onCompletion", $$robo$$android_speech_tts_AudioPlaybackQueueItem_2$onCompletion(android.media.MediaPlayer ), 0, this, mediaPlayer);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            AudioPlaybackQueueItem.setupVolume(this.mPlayer, this.mAudioParams.mVolume, this.mAudioParams.mPan);
            this.mPlayer.start();
            this.mDone.block();
            this.finish();
        }
        catch (IllegalArgumentException ex) {
            Log.w("TTS.AudioQueueItem", "MediaPlayer failed", ex);
            this.mDone.open();
        }
        if (this.mFinished) {
            dispatcher.dispatchOnSuccess();
        } else {
            dispatcher.dispatchOnStop();
        }
    }

    private static final void $$robo$$android_speech_tts_AudioPlaybackQueueItem$setupVolume(MediaPlayer player, float volume, float pan) {
        float vol = AudioPlaybackQueueItem.clip(volume, 0.0f, 1.0f);
        float panning = AudioPlaybackQueueItem.clip(pan, -1.0f, 1.0f);
        float volLeft = vol;
        float volRight = vol;
        if (panning > 0.0f) {
            volLeft *= 1.0f - panning;
        } else if (panning < 0.0f) {
            volRight *= 1.0f + panning;
        }
        player.setVolume(volLeft, volRight);
    }

    private static final float $$robo$$android_speech_tts_AudioPlaybackQueueItem$clip(float value, float min, float max) {
        return value < min ? min : (value < max ? value : max);
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackQueueItem$finish() {
        try {
            this.mPlayer.stop();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.mPlayer.release();
    }

    private final void $$robo$$android_speech_tts_AudioPlaybackQueueItem$stop(int errorCode) {
        this.mDone.open();
    }

    private void __constructor__(TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, Context context, Uri uri, TextToSpeechService.AudioOutputParams audioOutputParams) {
        this.$$robo$$android_speech_tts_AudioPlaybackQueueItem$__constructor__(utteranceProgressDispatcher, object, context, uri, audioOutputParams);
    }

    AudioPlaybackQueueItem(TextToSpeechService.UtteranceProgressDispatcher utteranceProgressDispatcher, Object object, Context context, Uri uri, TextToSpeechService.AudioOutputParams audioOutputParams) {
        super(utteranceProgressDispatcher, object);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_speech_tts_AudioPlaybackQueueItem$__constructor__(android.speech.tts.TextToSpeechService$UtteranceProgressDispatcher java.lang.Object android.content.Context android.net.Uri android.speech.tts.TextToSpeechService$AudioOutputParams ), 0, this, utteranceProgressDispatcher, object, context, uri, audioOutputParams);
    }

    @Override
    public void run() {
        InvokeDynamicSupport.bootstrap("run", $$robo$$android_speech_tts_AudioPlaybackQueueItem$run(), 0, this);
    }

    private static void setupVolume(MediaPlayer mediaPlayer, float f, float f2) {
        InvokeDynamicSupport.bootstrapStatic("setupVolume", $$robo$$android_speech_tts_AudioPlaybackQueueItem$setupVolume(android.media.MediaPlayer float float ), 0, (MediaPlayer)mediaPlayer, (float)f, (float)f2);
    }

    private static float clip(float f, float f2, float f3) {
        return (float)InvokeDynamicSupport.bootstrapStatic("clip", $$robo$$android_speech_tts_AudioPlaybackQueueItem$clip(float float float ), 0, (float)f, (float)f2, (float)f3);
    }

    private void finish() {
        InvokeDynamicSupport.bootstrap("finish", $$robo$$android_speech_tts_AudioPlaybackQueueItem$finish(), 0, this);
    }

    @Override
    void stop(int n) {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_speech_tts_AudioPlaybackQueueItem$stop(int ), 0, this, n);
    }

    public /* synthetic */ AudioPlaybackQueueItem() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AudioPlaybackQueueItem)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

