/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.keystore.ArrayUtils;
import android.security.keystore.Utils;
import android.text.TextUtils;
import com.google.errorprone.annotations.DoNotMock;
import java.math.BigInteger;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Date;
import javax.security.auth.x500.X500Principal;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class KeyGenParameterSpec
implements AlgorithmParameterSpec,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static X500Principal DEFAULT_CERT_SUBJECT;
    private static BigInteger DEFAULT_CERT_SERIAL_NUMBER;
    private static Date DEFAULT_CERT_NOT_BEFORE;
    private static Date DEFAULT_CERT_NOT_AFTER;
    private String mKeystoreAlias;
    private int mUid;
    private int mKeySize;
    private AlgorithmParameterSpec mSpec;
    private X500Principal mCertificateSubject;
    private BigInteger mCertificateSerialNumber;
    private Date mCertificateNotBefore;
    private Date mCertificateNotAfter;
    private Date mKeyValidityStart;
    private Date mKeyValidityForOriginationEnd;
    private Date mKeyValidityForConsumptionEnd;
    private int mPurposes;
    private String[] mDigests;
    private String[] mEncryptionPaddings;
    private String[] mSignaturePaddings;
    private String[] mBlockModes;
    private boolean mRandomizedEncryptionRequired;
    private boolean mUserAuthenticationRequired;
    private int mUserAuthenticationValidityDurationSeconds;
    private byte[] mAttestationChallenge;
    private boolean mUniqueIdIncluded;
    private boolean mUserAuthenticationValidWhileOnBody;
    private boolean mInvalidatedByBiometricEnrollment;

    private void $$robo$$android_security_keystore_KeyGenParameterSpec$__constructor__(String keyStoreAlias, int uid, int keySize, AlgorithmParameterSpec spec, X500Principal certificateSubject, BigInteger certificateSerialNumber, Date certificateNotBefore, Date certificateNotAfter, Date keyValidityStart, Date keyValidityForOriginationEnd, Date keyValidityForConsumptionEnd, int purposes, String[] digests, String[] encryptionPaddings, String[] signaturePaddings, String[] blockModes, boolean randomizedEncryptionRequired, boolean userAuthenticationRequired, int userAuthenticationValidityDurationSeconds, byte[] attestationChallenge, boolean uniqueIdIncluded, boolean userAuthenticationValidWhileOnBody, boolean invalidatedByBiometricEnrollment) {
        if (TextUtils.isEmpty(keyStoreAlias)) {
            throw new IllegalArgumentException("keyStoreAlias must not be empty");
        }
        if (certificateSubject == null) {
            certificateSubject = DEFAULT_CERT_SUBJECT;
        }
        if (certificateNotBefore == null) {
            certificateNotBefore = DEFAULT_CERT_NOT_BEFORE;
        }
        if (certificateNotAfter == null) {
            certificateNotAfter = DEFAULT_CERT_NOT_AFTER;
        }
        if (certificateSerialNumber == null) {
            certificateSerialNumber = DEFAULT_CERT_SERIAL_NUMBER;
        }
        if (certificateNotAfter.before(certificateNotBefore)) {
            throw new IllegalArgumentException("certificateNotAfter < certificateNotBefore");
        }
        this.mKeystoreAlias = keyStoreAlias;
        this.mUid = uid;
        this.mKeySize = keySize;
        this.mSpec = spec;
        this.mCertificateSubject = certificateSubject;
        this.mCertificateSerialNumber = certificateSerialNumber;
        this.mCertificateNotBefore = Utils.cloneIfNotNull(certificateNotBefore);
        this.mCertificateNotAfter = Utils.cloneIfNotNull(certificateNotAfter);
        this.mKeyValidityStart = Utils.cloneIfNotNull(keyValidityStart);
        this.mKeyValidityForOriginationEnd = Utils.cloneIfNotNull(keyValidityForOriginationEnd);
        this.mKeyValidityForConsumptionEnd = Utils.cloneIfNotNull(keyValidityForConsumptionEnd);
        this.mPurposes = purposes;
        this.mDigests = ArrayUtils.cloneIfNotEmpty(digests);
        this.mEncryptionPaddings = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(encryptionPaddings));
        this.mSignaturePaddings = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(signaturePaddings));
        this.mBlockModes = ArrayUtils.cloneIfNotEmpty(ArrayUtils.nullToEmpty(blockModes));
        this.mRandomizedEncryptionRequired = randomizedEncryptionRequired;
        this.mUserAuthenticationRequired = userAuthenticationRequired;
        this.mUserAuthenticationValidityDurationSeconds = userAuthenticationValidityDurationSeconds;
        this.mAttestationChallenge = Utils.cloneIfNotNull(attestationChallenge);
        this.mUniqueIdIncluded = uniqueIdIncluded;
        this.mUserAuthenticationValidWhileOnBody = userAuthenticationValidWhileOnBody;
        this.mInvalidatedByBiometricEnrollment = invalidatedByBiometricEnrollment;
    }

    private final String $$robo$$android_security_keystore_KeyGenParameterSpec$getKeystoreAlias() {
        return this.mKeystoreAlias;
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getUid() {
        return this.mUid;
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getKeySize() {
        return this.mKeySize;
    }

    private final AlgorithmParameterSpec $$robo$$android_security_keystore_KeyGenParameterSpec$getAlgorithmParameterSpec() {
        return this.mSpec;
    }

    private final X500Principal $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSubject() {
        return this.mCertificateSubject;
    }

    private final BigInteger $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSerialNumber() {
        return this.mCertificateSerialNumber;
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotBefore() {
        return Utils.cloneIfNotNull(this.mCertificateNotBefore);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotAfter() {
        return Utils.cloneIfNotNull(this.mCertificateNotAfter);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityStart() {
        return Utils.cloneIfNotNull(this.mKeyValidityStart);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForConsumptionEnd() {
        return Utils.cloneIfNotNull(this.mKeyValidityForConsumptionEnd);
    }

    private final Date $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForOriginationEnd() {
        return Utils.cloneIfNotNull(this.mKeyValidityForOriginationEnd);
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getPurposes() {
        return this.mPurposes;
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getDigests() {
        if (this.mDigests == null) {
            throw new IllegalStateException("Digests not specified");
        }
        return ArrayUtils.cloneIfNotEmpty(this.mDigests);
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isDigestsSpecified() {
        return this.mDigests != null;
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getEncryptionPaddings() {
        return ArrayUtils.cloneIfNotEmpty(this.mEncryptionPaddings);
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getSignaturePaddings() {
        return ArrayUtils.cloneIfNotEmpty(this.mSignaturePaddings);
    }

    private final String[] $$robo$$android_security_keystore_KeyGenParameterSpec$getBlockModes() {
        return ArrayUtils.cloneIfNotEmpty(this.mBlockModes);
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isRandomizedEncryptionRequired() {
        return this.mRandomizedEncryptionRequired;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationRequired() {
        return this.mUserAuthenticationRequired;
    }

    private final int $$robo$$android_security_keystore_KeyGenParameterSpec$getUserAuthenticationValidityDurationSeconds() {
        return this.mUserAuthenticationValidityDurationSeconds;
    }

    private final byte[] $$robo$$android_security_keystore_KeyGenParameterSpec$getAttestationChallenge() {
        return Utils.cloneIfNotNull(this.mAttestationChallenge);
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUniqueIdIncluded() {
        return this.mUniqueIdIncluded;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationValidWhileOnBody() {
        return this.mUserAuthenticationValidWhileOnBody;
    }

    private final boolean $$robo$$android_security_keystore_KeyGenParameterSpec$isInvalidatedByBiometricEnrollment() {
        return this.mInvalidatedByBiometricEnrollment;
    }

    static void __staticInitializer__() {
        DEFAULT_CERT_SUBJECT = new X500Principal("CN=fake");
        DEFAULT_CERT_SERIAL_NUMBER = new BigInteger("1");
        DEFAULT_CERT_NOT_BEFORE = new Date(0L);
        DEFAULT_CERT_NOT_AFTER = new Date(2461449600000L);
    }

    private void __constructor__(String string2, int n, int n2, AlgorithmParameterSpec algorithmParameterSpec, X500Principal x500Principal, BigInteger bigInteger, Date date, Date date2, Date date3, Date date4, Date date5, int n3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n4, byte[] byArray, boolean bl3, boolean bl4, boolean bl5) {
        this.$$robo$$android_security_keystore_KeyGenParameterSpec$__constructor__(string2, n, n2, algorithmParameterSpec, x500Principal, bigInteger, date, date2, date3, date4, date5, n3, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n4, byArray, bl3, bl4, bl5);
    }

    public KeyGenParameterSpec(String string2, int n, int n2, AlgorithmParameterSpec algorithmParameterSpec, X500Principal x500Principal, BigInteger bigInteger, Date date, Date date2, Date date3, Date date4, Date date5, int n3, String[] stringArray, String[] stringArray2, String[] stringArray3, String[] stringArray4, boolean bl, boolean bl2, int n4, byte[] byArray, boolean bl3, boolean bl4, boolean bl5) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyGenParameterSpec$__constructor__(java.lang.String int int java.security.spec.AlgorithmParameterSpec javax.security.auth.x500.X500Principal java.math.BigInteger java.util.Date java.util.Date java.util.Date java.util.Date java.util.Date int java.lang.String[] java.lang.String[] java.lang.String[] java.lang.String[] boolean boolean int byte[] boolean boolean boolean ), 0, this, string2, n, n2, algorithmParameterSpec, x500Principal, bigInteger, date, date2, date3, date4, date5, n3, stringArray, stringArray2, stringArray3, stringArray4, bl, bl2, n4, byArray, bl3, bl4, bl5);
    }

    public String getKeystoreAlias() {
        return InvokeDynamicSupport.bootstrap("getKeystoreAlias", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeystoreAlias(), 0, this);
    }

    public int getUid() {
        return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_security_keystore_KeyGenParameterSpec$getUid(), 0, this);
    }

    public int getKeySize() {
        return (int)InvokeDynamicSupport.bootstrap("getKeySize", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeySize(), 0, this);
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return InvokeDynamicSupport.bootstrap("getAlgorithmParameterSpec", $$robo$$android_security_keystore_KeyGenParameterSpec$getAlgorithmParameterSpec(), 0, this);
    }

    public X500Principal getCertificateSubject() {
        return InvokeDynamicSupport.bootstrap("getCertificateSubject", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSubject(), 0, this);
    }

    public BigInteger getCertificateSerialNumber() {
        return InvokeDynamicSupport.bootstrap("getCertificateSerialNumber", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateSerialNumber(), 0, this);
    }

    public Date getCertificateNotBefore() {
        return InvokeDynamicSupport.bootstrap("getCertificateNotBefore", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotBefore(), 0, this);
    }

    public Date getCertificateNotAfter() {
        return InvokeDynamicSupport.bootstrap("getCertificateNotAfter", $$robo$$android_security_keystore_KeyGenParameterSpec$getCertificateNotAfter(), 0, this);
    }

    public Date getKeyValidityStart() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityStart", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityStart(), 0, this);
    }

    public Date getKeyValidityForConsumptionEnd() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityForConsumptionEnd", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForConsumptionEnd(), 0, this);
    }

    public Date getKeyValidityForOriginationEnd() {
        return InvokeDynamicSupport.bootstrap("getKeyValidityForOriginationEnd", $$robo$$android_security_keystore_KeyGenParameterSpec$getKeyValidityForOriginationEnd(), 0, this);
    }

    public int getPurposes() {
        return (int)InvokeDynamicSupport.bootstrap("getPurposes", $$robo$$android_security_keystore_KeyGenParameterSpec$getPurposes(), 0, this);
    }

    public String[] getDigests() {
        return InvokeDynamicSupport.bootstrap("getDigests", $$robo$$android_security_keystore_KeyGenParameterSpec$getDigests(), 0, this);
    }

    public boolean isDigestsSpecified() {
        return (boolean)InvokeDynamicSupport.bootstrap("isDigestsSpecified", $$robo$$android_security_keystore_KeyGenParameterSpec$isDigestsSpecified(), 0, this);
    }

    public String[] getEncryptionPaddings() {
        return InvokeDynamicSupport.bootstrap("getEncryptionPaddings", $$robo$$android_security_keystore_KeyGenParameterSpec$getEncryptionPaddings(), 0, this);
    }

    public String[] getSignaturePaddings() {
        return InvokeDynamicSupport.bootstrap("getSignaturePaddings", $$robo$$android_security_keystore_KeyGenParameterSpec$getSignaturePaddings(), 0, this);
    }

    public String[] getBlockModes() {
        return InvokeDynamicSupport.bootstrap("getBlockModes", $$robo$$android_security_keystore_KeyGenParameterSpec$getBlockModes(), 0, this);
    }

    public boolean isRandomizedEncryptionRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isRandomizedEncryptionRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isRandomizedEncryptionRequired(), 0, this);
    }

    public boolean isUserAuthenticationRequired() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAuthenticationRequired", $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationRequired(), 0, this);
    }

    public int getUserAuthenticationValidityDurationSeconds() {
        return (int)InvokeDynamicSupport.bootstrap("getUserAuthenticationValidityDurationSeconds", $$robo$$android_security_keystore_KeyGenParameterSpec$getUserAuthenticationValidityDurationSeconds(), 0, this);
    }

    public byte[] getAttestationChallenge() {
        return InvokeDynamicSupport.bootstrap("getAttestationChallenge", $$robo$$android_security_keystore_KeyGenParameterSpec$getAttestationChallenge(), 0, this);
    }

    public boolean isUniqueIdIncluded() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUniqueIdIncluded", $$robo$$android_security_keystore_KeyGenParameterSpec$isUniqueIdIncluded(), 0, this);
    }

    public boolean isUserAuthenticationValidWhileOnBody() {
        return (boolean)InvokeDynamicSupport.bootstrap("isUserAuthenticationValidWhileOnBody", $$robo$$android_security_keystore_KeyGenParameterSpec$isUserAuthenticationValidWhileOnBody(), 0, this);
    }

    public boolean isInvalidatedByBiometricEnrollment() {
        return (boolean)InvokeDynamicSupport.bootstrap("isInvalidatedByBiometricEnrollment", $$robo$$android_security_keystore_KeyGenParameterSpec$isInvalidatedByBiometricEnrollment(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(KeyGenParameterSpec.class);
    }

    public /* synthetic */ KeyGenParameterSpec() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (KeyGenParameterSpec)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mKeystoreAlias;
        private int mPurposes;
        private int mUid;
        private int mKeySize;
        private AlgorithmParameterSpec mSpec;
        private X500Principal mCertificateSubject;
        private BigInteger mCertificateSerialNumber;
        private Date mCertificateNotBefore;
        private Date mCertificateNotAfter;
        private Date mKeyValidityStart;
        private Date mKeyValidityForOriginationEnd;
        private Date mKeyValidityForConsumptionEnd;
        private String[] mDigests;
        private String[] mEncryptionPaddings;
        private String[] mSignaturePaddings;
        private String[] mBlockModes;
        private boolean mRandomizedEncryptionRequired;
        private boolean mUserAuthenticationRequired;
        private int mUserAuthenticationValidityDurationSeconds;
        private byte[] mAttestationChallenge;
        private boolean mUniqueIdIncluded;
        private boolean mUserAuthenticationValidWhileOnBody;
        private boolean mInvalidatedByBiometricEnrollment;

        private void $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(String keystoreAlias, int purposes) {
            this.mUid = -1;
            this.mKeySize = -1;
            this.mRandomizedEncryptionRequired = true;
            this.mUserAuthenticationValidityDurationSeconds = -1;
            this.mAttestationChallenge = null;
            this.mUniqueIdIncluded = false;
            this.mInvalidatedByBiometricEnrollment = true;
            if (keystoreAlias == null) {
                throw new NullPointerException("keystoreAlias == null");
            }
            if (keystoreAlias.isEmpty()) {
                throw new IllegalArgumentException("keystoreAlias must not be empty");
            }
            this.mKeystoreAlias = keystoreAlias;
            this.mPurposes = purposes;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUid(int uid) {
            this.mUid = uid;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeySize(int keySize) {
            if (keySize < 0) {
                throw new IllegalArgumentException("keySize < 0");
            }
            this.mKeySize = keySize;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAlgorithmParameterSpec(AlgorithmParameterSpec spec) {
            if (spec == null) {
                throw new NullPointerException("spec == null");
            }
            this.mSpec = spec;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSubject(X500Principal subject) {
            if (subject == null) {
                throw new NullPointerException("subject == null");
            }
            this.mCertificateSubject = subject;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSerialNumber(BigInteger serialNumber) {
            if (serialNumber == null) {
                throw new NullPointerException("serialNumber == null");
            }
            this.mCertificateSerialNumber = serialNumber;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotBefore(Date date) {
            if (date == null) {
                throw new NullPointerException("date == null");
            }
            this.mCertificateNotBefore = Utils.cloneIfNotNull(date);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotAfter(Date date) {
            if (date == null) {
                throw new NullPointerException("date == null");
            }
            this.mCertificateNotAfter = Utils.cloneIfNotNull(date);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityStart(Date startDate) {
            this.mKeyValidityStart = Utils.cloneIfNotNull(startDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityEnd(Date endDate) {
            this.setKeyValidityForOriginationEnd(endDate);
            this.setKeyValidityForConsumptionEnd(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForOriginationEnd(Date endDate) {
            this.mKeyValidityForOriginationEnd = Utils.cloneIfNotNull(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForConsumptionEnd(Date endDate) {
            this.mKeyValidityForConsumptionEnd = Utils.cloneIfNotNull(endDate);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setDigests(String ... digests) {
            this.mDigests = ArrayUtils.cloneIfNotEmpty(digests);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setEncryptionPaddings(String ... paddings) {
            this.mEncryptionPaddings = ArrayUtils.cloneIfNotEmpty(paddings);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setSignaturePaddings(String ... paddings) {
            this.mSignaturePaddings = ArrayUtils.cloneIfNotEmpty(paddings);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setBlockModes(String ... blockModes) {
            this.mBlockModes = ArrayUtils.cloneIfNotEmpty(blockModes);
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setRandomizedEncryptionRequired(boolean required) {
            this.mRandomizedEncryptionRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationRequired(boolean required) {
            this.mUserAuthenticationRequired = required;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidityDurationSeconds(int seconds) {
            if (seconds < -1) {
                throw new IllegalArgumentException("seconds must be -1 or larger");
            }
            this.mUserAuthenticationValidityDurationSeconds = seconds;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAttestationChallenge(byte[] attestationChallenge) {
            this.mAttestationChallenge = attestationChallenge;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUniqueIdIncluded(boolean uniqueIdIncluded) {
            this.mUniqueIdIncluded = uniqueIdIncluded;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidWhileOnBody(boolean remainsValid) {
            this.mUserAuthenticationValidWhileOnBody = remainsValid;
            return this;
        }

        private final Builder $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setInvalidatedByBiometricEnrollment(boolean invalidateKey) {
            this.mInvalidatedByBiometricEnrollment = invalidateKey;
            return this;
        }

        private final KeyGenParameterSpec $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$build() {
            return new KeyGenParameterSpec(this.mKeystoreAlias, this.mUid, this.mKeySize, this.mSpec, this.mCertificateSubject, this.mCertificateSerialNumber, this.mCertificateNotBefore, this.mCertificateNotAfter, this.mKeyValidityStart, this.mKeyValidityForOriginationEnd, this.mKeyValidityForConsumptionEnd, this.mPurposes, this.mDigests, this.mEncryptionPaddings, this.mSignaturePaddings, this.mBlockModes, this.mRandomizedEncryptionRequired, this.mUserAuthenticationRequired, this.mUserAuthenticationValidityDurationSeconds, this.mAttestationChallenge, this.mUniqueIdIncluded, this.mUserAuthenticationValidWhileOnBody, this.mInvalidatedByBiometricEnrollment);
        }

        private void __constructor__(String string2, int n) {
            this.$$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(string2, n);
        }

        public Builder(String string2, int n) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$__constructor__(java.lang.String int ), 0, this, string2, n);
        }

        public Builder setUid(int n) {
            return InvokeDynamicSupport.bootstrap("setUid", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUid(int ), 0, this, n);
        }

        public Builder setKeySize(int n) {
            return InvokeDynamicSupport.bootstrap("setKeySize", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeySize(int ), 0, this, n);
        }

        public Builder setAlgorithmParameterSpec(AlgorithmParameterSpec algorithmParameterSpec) {
            return InvokeDynamicSupport.bootstrap("setAlgorithmParameterSpec", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAlgorithmParameterSpec(java.security.spec.AlgorithmParameterSpec ), 0, this, algorithmParameterSpec);
        }

        public Builder setCertificateSubject(X500Principal x500Principal) {
            return InvokeDynamicSupport.bootstrap("setCertificateSubject", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSubject(javax.security.auth.x500.X500Principal ), 0, this, x500Principal);
        }

        public Builder setCertificateSerialNumber(BigInteger bigInteger) {
            return InvokeDynamicSupport.bootstrap("setCertificateSerialNumber", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateSerialNumber(java.math.BigInteger ), 0, this, bigInteger);
        }

        public Builder setCertificateNotBefore(Date date) {
            return InvokeDynamicSupport.bootstrap("setCertificateNotBefore", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotBefore(java.util.Date ), 0, this, date);
        }

        public Builder setCertificateNotAfter(Date date) {
            return InvokeDynamicSupport.bootstrap("setCertificateNotAfter", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setCertificateNotAfter(java.util.Date ), 0, this, date);
        }

        public Builder setKeyValidityStart(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityStart", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityStart(java.util.Date ), 0, this, date);
        }

        public Builder setKeyValidityEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityEnd", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityEnd(java.util.Date ), 0, this, date);
        }

        public Builder setKeyValidityForOriginationEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityForOriginationEnd", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForOriginationEnd(java.util.Date ), 0, this, date);
        }

        public Builder setKeyValidityForConsumptionEnd(Date date) {
            return InvokeDynamicSupport.bootstrap("setKeyValidityForConsumptionEnd", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setKeyValidityForConsumptionEnd(java.util.Date ), 0, this, date);
        }

        public Builder setDigests(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setDigests", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setDigests(java.lang.String[] ), 0, this, stringArray);
        }

        public Builder setEncryptionPaddings(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setEncryptionPaddings", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setEncryptionPaddings(java.lang.String[] ), 0, this, stringArray);
        }

        public Builder setSignaturePaddings(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setSignaturePaddings", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setSignaturePaddings(java.lang.String[] ), 0, this, stringArray);
        }

        public Builder setBlockModes(String ... stringArray) {
            return InvokeDynamicSupport.bootstrap("setBlockModes", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setBlockModes(java.lang.String[] ), 0, this, stringArray);
        }

        public Builder setRandomizedEncryptionRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setRandomizedEncryptionRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setRandomizedEncryptionRequired(boolean ), 0, this, bl);
        }

        public Builder setUserAuthenticationRequired(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationRequired", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationRequired(boolean ), 0, this, bl);
        }

        public Builder setUserAuthenticationValidityDurationSeconds(int n) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationValidityDurationSeconds", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidityDurationSeconds(int ), 0, this, n);
        }

        public Builder setAttestationChallenge(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setAttestationChallenge", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setAttestationChallenge(byte[] ), 0, this, byArray);
        }

        public Builder setUniqueIdIncluded(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUniqueIdIncluded", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUniqueIdIncluded(boolean ), 0, this, bl);
        }

        public Builder setUserAuthenticationValidWhileOnBody(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setUserAuthenticationValidWhileOnBody", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setUserAuthenticationValidWhileOnBody(boolean ), 0, this, bl);
        }

        public Builder setInvalidatedByBiometricEnrollment(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setInvalidatedByBiometricEnrollment", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$setInvalidatedByBiometricEnrollment(boolean ), 0, this, bl);
        }

        public KeyGenParameterSpec build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_security_keystore_KeyGenParameterSpec_Builder$build(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

