/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.content.Context;
import android.os.Build;
import android.security.KeyStore;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.DeviceIdAttestationException;
import android.telephony.TelephonyManager;
import android.util.ArraySet;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AttestationUtils
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int ID_TYPE_SERIAL = 1;
    public static int ID_TYPE_IMEI = 2;
    public static int ID_TYPE_MEID = 3;

    private void $$robo$$android_security_keystore_AttestationUtils$__constructor__() {
    }

    private static final X509Certificate[] $$robo$$android_security_keystore_AttestationUtils$attestDeviceIds(Context context, int[] idTypes, byte[] attestationChallenge) throws DeviceIdAttestationException {
        if (idTypes == null) {
            throw new NullPointerException("Missing id types");
        }
        if (attestationChallenge == null) {
            throw new NullPointerException("Missing attestation challenge");
        }
        KeymasterArguments attestArgs = new KeymasterArguments();
        attestArgs.addBytes(-1879047484, attestationChallenge);
        ArraySet<Integer> idTypesSet = new ArraySet<Integer>(idTypes.length);
        for (int idType : idTypes) {
            idTypesSet.add(idType);
        }
        TelephonyManager telephonyService = null;
        if ((idTypesSet.contains(2) || idTypesSet.contains(3)) && (telephonyService = (TelephonyManager)context.getSystemService("phone")) == null) {
            throw new DeviceIdAttestationException("Unable to access telephony service");
        }
        block8: for (Integer idType : idTypesSet) {
            switch (idType) {
                case 1: {
                    attestArgs.addBytes(-1879047479, Build.getSerial().getBytes(StandardCharsets.UTF_8));
                    continue block8;
                }
                case 2: {
                    String imei = telephonyService.getImei(0);
                    if (imei == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve IMEI");
                    }
                    attestArgs.addBytes(-1879047478, imei.getBytes(StandardCharsets.UTF_8));
                    continue block8;
                }
                case 3: {
                    String meid = telephonyService.getDeviceId();
                    if (meid == null) {
                        throw new DeviceIdAttestationException("Unable to retrieve MEID");
                    }
                    attestArgs.addBytes(-1879047477, meid.getBytes(StandardCharsets.UTF_8));
                    continue block8;
                }
            }
            throw new IllegalArgumentException("Unknown device ID type " + idType);
        }
        attestArgs.addBytes(-1879047482, Build.BRAND.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047481, Build.DEVICE.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047480, Build.PRODUCT.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047476, Build.MANUFACTURER.getBytes(StandardCharsets.UTF_8));
        attestArgs.addBytes(-1879047475, Build.MODEL.getBytes(StandardCharsets.UTF_8));
        KeymasterCertificateChain outChain = new KeymasterCertificateChain();
        int errorCode = KeyStore.getInstance().attestDeviceIds(attestArgs, outChain);
        if (errorCode != 1) {
            throw new DeviceIdAttestationException("Unable to perform attestation", KeyStore.getKeyStoreException(errorCode));
        }
        List<byte[]> rawChain = outChain.getCertificates();
        if (rawChain.size() < 2) {
            throw new DeviceIdAttestationException("Attestation certificate chain contained " + rawChain.size() + " entries. At least two are required.");
        }
        ByteArrayOutputStream concatenatedRawChain = new ByteArrayOutputStream();
        try {
            for (byte[] cert : rawChain) {
                concatenatedRawChain.write(cert);
            }
            return CertificateFactory.getInstance("X.509").generateCertificates(new ByteArrayInputStream(concatenatedRawChain.toByteArray())).toArray(new X509Certificate[0]);
        }
        catch (Exception e) {
            throw new DeviceIdAttestationException("Unable to construct certificate chain", e);
        }
    }

    private void __constructor__() {
        this.$$robo$$android_security_keystore_AttestationUtils$__constructor__();
    }

    private AttestationUtils() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AttestationUtils$__constructor__(), 0, this);
    }

    public static X509Certificate[] attestDeviceIds(Context context, int[] nArray, byte[] byArray) throws DeviceIdAttestationException {
        return InvokeDynamicSupport.bootstrapStatic("attestDeviceIds", $$robo$$android_security_keystore_AttestationUtils$attestDeviceIds(android.content.Context int[] byte[] ), 0, (Context)context, (int[])nArray, (byte[])byArray);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AttestationUtils)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

