/*
 * Decompiled with CFR 0.152.
 */
package android.security.keystore;

import android.security.Credentials;
import android.security.KeyPairGeneratorSpec;
import android.security.KeyStore;
import android.security.keymaster.KeyCharacteristics;
import android.security.keymaster.KeymasterArguments;
import android.security.keymaster.KeymasterCertificateChain;
import android.security.keystore.AndroidKeyStoreBCWorkaroundProvider;
import android.security.keystore.AndroidKeyStoreProvider;
import android.security.keystore.KeyGenParameterSpec;
import android.security.keystore.KeyProperties;
import android.security.keystore.KeyStoreCryptoOperationUtils;
import android.security.keystore.KeymasterUtils;
import com.android.internal.util.ArrayUtils;
import com.android.org.bouncycastle.asn1.ASN1Encodable;
import com.android.org.bouncycastle.asn1.ASN1EncodableVector;
import com.android.org.bouncycastle.asn1.ASN1InputStream;
import com.android.org.bouncycastle.asn1.ASN1Integer;
import com.android.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import com.android.org.bouncycastle.asn1.DERBitString;
import com.android.org.bouncycastle.asn1.DERInteger;
import com.android.org.bouncycastle.asn1.DERNull;
import com.android.org.bouncycastle.asn1.DERSequence;
import com.android.org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import com.android.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.android.org.bouncycastle.asn1.x509.Certificate;
import com.android.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import com.android.org.bouncycastle.asn1.x509.TBSCertificate;
import com.android.org.bouncycastle.asn1.x509.Time;
import com.android.org.bouncycastle.asn1.x509.V3TBSCertificateGenerator;
import com.android.org.bouncycastle.asn1.x509.X509Name;
import com.android.org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import com.android.org.bouncycastle.jce.X509Principal;
import com.android.org.bouncycastle.jce.provider.X509CertificateObject;
import com.android.org.bouncycastle.x509.X509V3CertificateGenerator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.PrivateKey;
import java.security.ProviderException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.RSAKeyGenParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import libcore.util.EmptyArray;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class AndroidKeyStoreKeyPairGeneratorSpi
extends KeyPairGeneratorSpi
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int EC_DEFAULT_KEY_SIZE = 256;
    private static int RSA_DEFAULT_KEY_SIZE = 2048;
    private static int RSA_MIN_KEY_SIZE = 512;
    private static int RSA_MAX_KEY_SIZE = 8192;
    private static Map<String, Integer> SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE;
    private static List<String> SUPPORTED_EC_NIST_CURVE_NAMES;
    private static List<Integer> SUPPORTED_EC_NIST_CURVE_SIZES;
    private int mOriginalKeymasterAlgorithm;
    private KeyStore mKeyStore;
    private KeyGenParameterSpec mSpec;
    private String mEntryAlias;
    private int mEntryUid;
    private boolean mEncryptionAtRestRequired;
    private String mJcaKeyAlgorithm;
    private int mKeymasterAlgorithm;
    private int mKeySizeBits;
    private SecureRandom mRng;
    private int[] mKeymasterPurposes;
    private int[] mKeymasterBlockModes;
    private int[] mKeymasterEncryptionPaddings;
    private int[] mKeymasterSignaturePaddings;
    private int[] mKeymasterDigests;
    private BigInteger mRSAPublicExponent;

    private void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$__constructor__(int keymasterAlgorithm) {
        this.mKeymasterAlgorithm = -1;
        this.mOriginalKeymasterAlgorithm = keymasterAlgorithm;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$initialize(int keysize, SecureRandom random) {
        throw new IllegalArgumentException(KeyGenParameterSpec.class.getName() + " or " + KeyPairGeneratorSpec.class.getName() + " required to initialize this KeyPairGenerator");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        this.resetAll();
        boolean success = false;
        try {
            String jcaKeyAlgorithm;
            KeyGenParameterSpec spec;
            if (params == null) {
                throw new InvalidAlgorithmParameterException("Must supply params of type " + KeyGenParameterSpec.class.getName() + " or " + KeyPairGeneratorSpec.class.getName());
            }
            boolean encryptionAtRestRequired = false;
            int keymasterAlgorithm = this.mOriginalKeymasterAlgorithm;
            if (params instanceof KeyGenParameterSpec) {
                spec = (KeyGenParameterSpec)params;
            } else {
                if (params instanceof KeyPairGeneratorSpec) {
                    KeyPairGeneratorSpec legacySpec = (KeyPairGeneratorSpec)params;
                    try {
                        KeyGenParameterSpec.Builder specBuilder;
                        String specKeyAlgorithm = legacySpec.getKeyType();
                        if (specKeyAlgorithm != null) {
                            try {
                                keymasterAlgorithm = KeyProperties.KeyAlgorithm.toKeymasterAsymmetricKeyAlgorithm(specKeyAlgorithm);
                            }
                            catch (IllegalArgumentException e) {
                                throw new InvalidAlgorithmParameterException("Invalid key type in parameters", e);
                            }
                        }
                        switch (keymasterAlgorithm) {
                            case 3: {
                                specBuilder = new KeyGenParameterSpec.Builder(legacySpec.getKeystoreAlias(), 12);
                                specBuilder.setDigests("NONE", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
                                break;
                            }
                            case 1: {
                                specBuilder = new KeyGenParameterSpec.Builder(legacySpec.getKeystoreAlias(), 15);
                                specBuilder.setDigests("NONE", "MD5", "SHA-1", "SHA-224", "SHA-256", "SHA-384", "SHA-512");
                                specBuilder.setEncryptionPaddings("NoPadding", "PKCS1Padding", "OAEPPadding");
                                specBuilder.setSignaturePaddings("PKCS1", "PSS");
                                specBuilder.setRandomizedEncryptionRequired(false);
                                break;
                            }
                            default: {
                                throw new ProviderException("Unsupported algorithm: " + this.mKeymasterAlgorithm);
                            }
                        }
                        if (legacySpec.getKeySize() != -1) {
                            specBuilder.setKeySize(legacySpec.getKeySize());
                        }
                        if (legacySpec.getAlgorithmParameterSpec() != null) {
                            specBuilder.setAlgorithmParameterSpec(legacySpec.getAlgorithmParameterSpec());
                        }
                        specBuilder.setCertificateSubject(legacySpec.getSubjectDN());
                        specBuilder.setCertificateSerialNumber(legacySpec.getSerialNumber());
                        specBuilder.setCertificateNotBefore(legacySpec.getStartDate());
                        specBuilder.setCertificateNotAfter(legacySpec.getEndDate());
                        encryptionAtRestRequired = legacySpec.isEncryptionRequired();
                        specBuilder.setUserAuthenticationRequired(false);
                        spec = specBuilder.build();
                    }
                    catch (IllegalArgumentException | NullPointerException e) {
                        throw new InvalidAlgorithmParameterException(e);
                    }
                }
                throw new InvalidAlgorithmParameterException("Unsupported params class: " + params.getClass().getName() + ". Supported: " + KeyGenParameterSpec.class.getName() + ", " + KeyPairGeneratorSpec.class.getName());
            }
            this.mEntryAlias = spec.getKeystoreAlias();
            this.mEntryUid = spec.getUid();
            this.mSpec = spec;
            this.mKeymasterAlgorithm = keymasterAlgorithm;
            this.mEncryptionAtRestRequired = encryptionAtRestRequired;
            this.mKeySizeBits = spec.getKeySize();
            this.initAlgorithmSpecificParameters();
            if (this.mKeySizeBits == -1) {
                this.mKeySizeBits = AndroidKeyStoreKeyPairGeneratorSpi.getDefaultKeySize(keymasterAlgorithm);
            }
            AndroidKeyStoreKeyPairGeneratorSpi.checkValidKeySize(keymasterAlgorithm, this.mKeySizeBits);
            if (spec.getKeystoreAlias() == null) {
                throw new InvalidAlgorithmParameterException("KeyStore entry alias not provided");
            }
            try {
                jcaKeyAlgorithm = KeyProperties.KeyAlgorithm.fromKeymasterAsymmetricKeyAlgorithm(keymasterAlgorithm);
                this.mKeymasterPurposes = KeyProperties.Purpose.allToKeymaster(spec.getPurposes());
                this.mKeymasterBlockModes = KeyProperties.BlockMode.allToKeymaster(spec.getBlockModes());
                this.mKeymasterEncryptionPaddings = KeyProperties.EncryptionPadding.allToKeymaster(spec.getEncryptionPaddings());
                if ((spec.getPurposes() & 1) != 0 && spec.isRandomizedEncryptionRequired()) {
                    for (int keymasterPadding : this.mKeymasterEncryptionPaddings) {
                        if (KeymasterUtils.isKeymasterPaddingSchemeIndCpaCompatibleWithAsymmetricCrypto(keymasterPadding)) continue;
                        throw new InvalidAlgorithmParameterException("Randomized encryption (IND-CPA) required but may be violated by padding scheme: " + KeyProperties.EncryptionPadding.fromKeymaster(keymasterPadding) + ". See " + KeyGenParameterSpec.class.getName() + " documentation.");
                    }
                }
                this.mKeymasterSignaturePaddings = KeyProperties.SignaturePadding.allToKeymaster(spec.getSignaturePaddings());
                this.mKeymasterDigests = spec.isDigestsSpecified() ? KeyProperties.Digest.allToKeymaster(spec.getDigests()) : EmptyArray.INT;
                KeymasterUtils.addUserAuthArgs(new KeymasterArguments(), this.mSpec.isUserAuthenticationRequired(), this.mSpec.getUserAuthenticationValidityDurationSeconds(), this.mSpec.isUserAuthenticationValidWhileOnBody(), this.mSpec.isInvalidatedByBiometricEnrollment(), 0L);
            }
            catch (IllegalArgumentException | IllegalStateException e) {
                throw new InvalidAlgorithmParameterException(e);
            }
            this.mJcaKeyAlgorithm = jcaKeyAlgorithm;
            this.mRng = random;
            this.mKeyStore = KeyStore.getInstance();
            success = true;
        }
        finally {
            if (!success) {
                this.resetAll();
            }
        }
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$resetAll() {
        this.mEntryAlias = null;
        this.mEntryUid = -1;
        this.mJcaKeyAlgorithm = null;
        this.mKeymasterAlgorithm = -1;
        this.mKeymasterPurposes = null;
        this.mKeymasterBlockModes = null;
        this.mKeymasterEncryptionPaddings = null;
        this.mKeymasterSignaturePaddings = null;
        this.mKeymasterDigests = null;
        this.mKeySizeBits = 0;
        this.mSpec = null;
        this.mRSAPublicExponent = null;
        this.mEncryptionAtRestRequired = false;
        this.mRng = null;
        this.mKeyStore = null;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$initAlgorithmSpecificParameters() throws InvalidAlgorithmParameterException {
        AlgorithmParameterSpec algSpecificSpec = this.mSpec.getAlgorithmParameterSpec();
        switch (this.mKeymasterAlgorithm) {
            case 1: {
                BigInteger publicExponent = null;
                if (algSpecificSpec instanceof RSAKeyGenParameterSpec) {
                    RSAKeyGenParameterSpec rsaSpec = (RSAKeyGenParameterSpec)algSpecificSpec;
                    if (this.mKeySizeBits == -1) {
                        this.mKeySizeBits = rsaSpec.getKeysize();
                    } else if (this.mKeySizeBits != rsaSpec.getKeysize()) {
                        throw new InvalidAlgorithmParameterException("RSA key size must match  between " + this.mSpec + " and " + algSpecificSpec + ": " + this.mKeySizeBits + " vs " + rsaSpec.getKeysize());
                    }
                    publicExponent = rsaSpec.getPublicExponent();
                } else if (algSpecificSpec != null) {
                    throw new InvalidAlgorithmParameterException("RSA may only use RSAKeyGenParameterSpec");
                }
                if (publicExponent == null) {
                    publicExponent = RSAKeyGenParameterSpec.F4;
                }
                if (publicExponent.compareTo(BigInteger.ZERO) < 1) {
                    throw new InvalidAlgorithmParameterException("RSA public exponent must be positive: " + publicExponent);
                }
                if (publicExponent.compareTo(KeymasterArguments.UINT64_MAX_VALUE) > 0) {
                    throw new InvalidAlgorithmParameterException("Unsupported RSA public exponent: " + publicExponent + ". Maximum supported value: " + KeymasterArguments.UINT64_MAX_VALUE);
                }
                this.mRSAPublicExponent = publicExponent;
                break;
            }
            case 3: {
                if (algSpecificSpec instanceof ECGenParameterSpec) {
                    ECGenParameterSpec ecSpec = (ECGenParameterSpec)algSpecificSpec;
                    String curveName = ecSpec.getName();
                    Integer ecSpecKeySizeBits = SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.get(curveName.toLowerCase(Locale.US));
                    if (ecSpecKeySizeBits == null) {
                        throw new InvalidAlgorithmParameterException("Unsupported EC curve name: " + curveName + ". Supported: " + SUPPORTED_EC_NIST_CURVE_NAMES);
                    }
                    if (this.mKeySizeBits == -1) {
                        this.mKeySizeBits = ecSpecKeySizeBits;
                        break;
                    }
                    if (this.mKeySizeBits == ecSpecKeySizeBits) break;
                    throw new InvalidAlgorithmParameterException("EC key size must match  between " + this.mSpec + " and " + algSpecificSpec + ": " + this.mKeySizeBits + " vs " + ecSpecKeySizeBits);
                }
                if (algSpecificSpec == null) break;
                throw new InvalidAlgorithmParameterException("EC may only use ECGenParameterSpec");
            }
            default: {
                throw new ProviderException("Unsupported algorithm: " + this.mKeymasterAlgorithm);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final KeyPair $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateKeyPair() {
        int flags;
        if (this.mKeyStore == null || this.mSpec == null) {
            throw new IllegalStateException("Not initialized");
        }
        int n = flags = this.mEncryptionAtRestRequired ? 1 : 0;
        if (flags & true && this.mKeyStore.state() != KeyStore.State.UNLOCKED) {
            throw new IllegalStateException("Encryption at rest using secure lock screen credential requested for key pair, but the user has not yet entered the credential");
        }
        byte[] additionalEntropy = KeyStoreCryptoOperationUtils.getRandomBytesToMixIntoKeystoreRng(this.mRng, (this.mKeySizeBits + 7) / 8);
        Credentials.deleteAllTypesForAlias(this.mKeyStore, this.mEntryAlias, this.mEntryUid);
        String privateKeyAlias = "USRPKEY_" + this.mEntryAlias;
        boolean success = false;
        try {
            this.generateKeystoreKeyPair(privateKeyAlias, this.constructKeyGenerationArguments(), additionalEntropy, flags);
            KeyPair keyPair = this.loadKeystoreKeyPair(privateKeyAlias);
            this.storeCertificateChain(flags, this.createCertificateChain(privateKeyAlias, keyPair));
            success = true;
            KeyPair keyPair2 = keyPair;
            return keyPair2;
        }
        finally {
            if (!success) {
                Credentials.deleteAllTypesForAlias(this.mKeyStore, this.mEntryAlias, this.mEntryUid);
            }
        }
    }

    private final Iterable<byte[]> $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$createCertificateChain(String privateKeyAlias, KeyPair keyPair) throws ProviderException {
        byte[] challenge = this.mSpec.getAttestationChallenge();
        if (challenge != null) {
            KeymasterArguments args = new KeymasterArguments();
            args.addBytes(-1879047484, challenge);
            return this.getAttestationChain(privateKeyAlias, keyPair, args);
        }
        return Collections.singleton(this.generateSelfSignedCertificateBytes(keyPair));
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateKeystoreKeyPair(String privateKeyAlias, KeymasterArguments args, byte[] additionalEntropy, int flags) throws ProviderException {
        KeyCharacteristics resultingKeyCharacteristics = new KeyCharacteristics();
        int errorCode = this.mKeyStore.generateKey(privateKeyAlias, args, additionalEntropy, this.mEntryUid, flags, resultingKeyCharacteristics);
        if (errorCode != 1) {
            throw new ProviderException("Failed to generate key pair", KeyStore.getKeyStoreException(errorCode));
        }
    }

    private final KeyPair $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$loadKeystoreKeyPair(String privateKeyAlias) throws ProviderException {
        try {
            KeyPair result = AndroidKeyStoreProvider.loadAndroidKeyStoreKeyPairFromKeystore(this.mKeyStore, privateKeyAlias, this.mEntryUid);
            if (!this.mJcaKeyAlgorithm.equalsIgnoreCase(result.getPrivate().getAlgorithm())) {
                throw new ProviderException("Generated key pair algorithm does not match requested algorithm: " + result.getPrivate().getAlgorithm() + " vs " + this.mJcaKeyAlgorithm);
            }
            return result;
        }
        catch (UnrecoverableKeyException e) {
            throw new ProviderException("Failed to load generated key pair from keystore", e);
        }
    }

    private final KeymasterArguments $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$constructKeyGenerationArguments() {
        KeymasterArguments args = new KeymasterArguments();
        args.addUnsignedInt(0x30000003, this.mKeySizeBits);
        args.addEnum(0x10000002, this.mKeymasterAlgorithm);
        args.addEnums(0x20000001, this.mKeymasterPurposes);
        args.addEnums(0x20000004, this.mKeymasterBlockModes);
        args.addEnums(0x20000006, this.mKeymasterEncryptionPaddings);
        args.addEnums(0x20000006, this.mKeymasterSignaturePaddings);
        args.addEnums(0x20000005, this.mKeymasterDigests);
        KeymasterUtils.addUserAuthArgs(args, this.mSpec.isUserAuthenticationRequired(), this.mSpec.getUserAuthenticationValidityDurationSeconds(), this.mSpec.isUserAuthenticationValidWhileOnBody(), this.mSpec.isInvalidatedByBiometricEnrollment(), 0L);
        args.addDateIfNotNull(1610613136, this.mSpec.getKeyValidityStart());
        args.addDateIfNotNull(1610613137, this.mSpec.getKeyValidityForOriginationEnd());
        args.addDateIfNotNull(1610613138, this.mSpec.getKeyValidityForConsumptionEnd());
        this.addAlgorithmSpecificParameters(args);
        if (this.mSpec.isUniqueIdIncluded()) {
            args.addBoolean(1879048394);
        }
        return args;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$storeCertificateChain(int flags, Iterable<byte[]> iterable) throws ProviderException {
        Iterator<byte[]> iter = iterable.iterator();
        this.storeCertificate("USRCERT_", iter.next(), flags, "Failed to store certificate");
        if (!iter.hasNext()) {
            return;
        }
        ByteArrayOutputStream certificateConcatenationStream = new ByteArrayOutputStream();
        while (iter.hasNext()) {
            byte[] data = iter.next();
            certificateConcatenationStream.write(data, 0, data.length);
        }
        this.storeCertificate("CACERT_", certificateConcatenationStream.toByteArray(), flags, "Failed to store attestation CA certificate");
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$storeCertificate(String prefix, byte[] certificateBytes, int flags, String failureMessage) throws ProviderException {
        int insertErrorCode = this.mKeyStore.insert(prefix + this.mEntryAlias, certificateBytes, this.mEntryUid, flags);
        if (insertErrorCode != 1) {
            throw new ProviderException(failureMessage, KeyStore.getKeyStoreException(insertErrorCode));
        }
    }

    private final byte[] $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificateBytes(KeyPair keyPair) throws ProviderException {
        try {
            return this.generateSelfSignedCertificate(keyPair.getPrivate(), keyPair.getPublic()).getEncoded();
        }
        catch (IOException | CertificateParsingException e) {
            throw new ProviderException("Failed to generate self-signed certificate", e);
        }
        catch (CertificateEncodingException e) {
            throw new ProviderException("Failed to obtain encoded form of self-signed certificate", e);
        }
    }

    private final Iterable<byte[]> $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getAttestationChain(String privateKeyAlias, KeyPair keyPair, KeymasterArguments args) throws ProviderException {
        KeymasterCertificateChain outChain = new KeymasterCertificateChain();
        int errorCode = this.mKeyStore.attestKey(privateKeyAlias, args, outChain);
        if (errorCode != 1) {
            throw new ProviderException("Failed to generate attestation certificate chain", KeyStore.getKeyStoreException(errorCode));
        }
        List<byte[]> chain = outChain.getCertificates();
        if (chain.size() < 2) {
            throw new ProviderException("Attestation certificate chain contained " + chain.size() + " entries. At least two are required.");
        }
        return chain;
    }

    private final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$addAlgorithmSpecificParameters(KeymasterArguments keymasterArgs) {
        switch (this.mKeymasterAlgorithm) {
            case 1: {
                keymasterArgs.addUnsignedLong(1342177480, this.mRSAPublicExponent);
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new ProviderException("Unsupported algorithm: " + this.mKeymasterAlgorithm);
            }
        }
    }

    private final X509Certificate $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificate(PrivateKey privateKey, PublicKey publicKey) throws CertificateParsingException, IOException {
        String signatureAlgorithm = AndroidKeyStoreKeyPairGeneratorSpi.getCertificateSignatureAlgorithm(this.mKeymasterAlgorithm, this.mKeySizeBits, this.mSpec);
        if (signatureAlgorithm == null) {
            return this.generateSelfSignedCertificateWithFakeSignature(publicKey);
        }
        try {
            return this.generateSelfSignedCertificateWithValidSignature(privateKey, publicKey, signatureAlgorithm);
        }
        catch (Exception e) {
            return this.generateSelfSignedCertificateWithFakeSignature(publicKey);
        }
    }

    private final X509Certificate $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificateWithValidSignature(PrivateKey privateKey, PublicKey publicKey, String signatureAlgorithm) throws Exception {
        X509V3CertificateGenerator certGen = new X509V3CertificateGenerator();
        certGen.setPublicKey(publicKey);
        certGen.setSerialNumber(this.mSpec.getCertificateSerialNumber());
        certGen.setSubjectDN(this.mSpec.getCertificateSubject());
        certGen.setIssuerDN(this.mSpec.getCertificateSubject());
        certGen.setNotBefore(this.mSpec.getCertificateNotBefore());
        certGen.setNotAfter(this.mSpec.getCertificateNotAfter());
        certGen.setSignatureAlgorithm(signatureAlgorithm);
        return certGen.generate(privateKey);
    }

    private final X509Certificate $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificateWithFakeSignature(PublicKey publicKey) throws IOException, CertificateParsingException {
        byte[] signature;
        AlgorithmIdentifier sigAlgId;
        V3TBSCertificateGenerator tbsGenerator = new V3TBSCertificateGenerator();
        switch (this.mKeymasterAlgorithm) {
            case 3: {
                ASN1ObjectIdentifier sigAlgOid = X9ObjectIdentifiers.ecdsa_with_SHA256;
                sigAlgId = new AlgorithmIdentifier(sigAlgOid);
                ASN1EncodableVector v = new ASN1EncodableVector();
                v.add((ASN1Encodable)new DERInteger(0L));
                v.add((ASN1Encodable)new DERInteger(0L));
                signature = new DERSequence().getEncoded();
                break;
            }
            case 1: {
                ASN1ObjectIdentifier sigAlgOid = PKCSObjectIdentifiers.sha256WithRSAEncryption;
                sigAlgId = new AlgorithmIdentifier(sigAlgOid, (ASN1Encodable)DERNull.INSTANCE);
                signature = new byte[1];
                break;
            }
            default: {
                throw new ProviderException("Unsupported key algorithm: " + this.mKeymasterAlgorithm);
            }
        }
        try (ASN1InputStream publicKeyInfoIn = new ASN1InputStream(publicKey.getEncoded());){
            tbsGenerator.setSubjectPublicKeyInfo(SubjectPublicKeyInfo.getInstance((Object)publicKeyInfoIn.readObject()));
        }
        tbsGenerator.setSerialNumber(new ASN1Integer(this.mSpec.getCertificateSerialNumber()));
        X509Principal subject = new X509Principal(this.mSpec.getCertificateSubject().getEncoded());
        tbsGenerator.setSubject((X509Name)subject);
        tbsGenerator.setIssuer((X509Name)subject);
        tbsGenerator.setStartDate(new Time(this.mSpec.getCertificateNotBefore()));
        tbsGenerator.setEndDate(new Time(this.mSpec.getCertificateNotAfter()));
        tbsGenerator.setSignature(sigAlgId);
        TBSCertificate tbsCertificate = tbsGenerator.generateTBSCertificate();
        ASN1EncodableVector result = new ASN1EncodableVector();
        result.add((ASN1Encodable)tbsCertificate);
        result.add((ASN1Encodable)sigAlgId);
        result.add((ASN1Encodable)new DERBitString(signature));
        return new X509CertificateObject(Certificate.getInstance((Object)new DERSequence(result)));
    }

    private static final int $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getDefaultKeySize(int keymasterAlgorithm) {
        switch (keymasterAlgorithm) {
            case 3: {
                return 256;
            }
            case 1: {
                return 2048;
            }
        }
        throw new ProviderException("Unsupported algorithm: " + keymasterAlgorithm);
    }

    private static final void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$checkValidKeySize(int keymasterAlgorithm, int keySize) throws InvalidAlgorithmParameterException {
        switch (keymasterAlgorithm) {
            case 3: {
                if (SUPPORTED_EC_NIST_CURVE_SIZES.contains(keySize)) break;
                throw new InvalidAlgorithmParameterException("Unsupported EC key size: " + keySize + " bits. Supported: " + SUPPORTED_EC_NIST_CURVE_SIZES);
            }
            case 1: {
                if (keySize >= 512 && keySize <= 8192) break;
                throw new InvalidAlgorithmParameterException("RSA key size must be >= 512 and <= 8192");
            }
            default: {
                throw new ProviderException("Unsupported algorithm: " + keymasterAlgorithm);
            }
        }
    }

    private static final String $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getCertificateSignatureAlgorithm(int keymasterAlgorithm, int keySizeBits, KeyGenParameterSpec spec) {
        if ((spec.getPurposes() & 4) == 0) {
            return null;
        }
        if (spec.isUserAuthenticationRequired()) {
            return null;
        }
        if (!spec.isDigestsSpecified()) {
            return null;
        }
        switch (keymasterAlgorithm) {
            case 3: {
                Set<Integer> availableKeymasterDigests = AndroidKeyStoreKeyPairGeneratorSpi.getAvailableKeymasterSignatureDigests(spec.getDigests(), AndroidKeyStoreBCWorkaroundProvider.getSupportedEcdsaSignatureDigests());
                int bestKeymasterDigest = -1;
                int bestDigestOutputSizeBits = -1;
                for (int keymasterDigest : availableKeymasterDigests) {
                    int outputSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
                    if (outputSizeBits == keySizeBits) {
                        bestKeymasterDigest = keymasterDigest;
                        bestDigestOutputSizeBits = outputSizeBits;
                        break;
                    }
                    if (bestKeymasterDigest == -1) {
                        bestKeymasterDigest = keymasterDigest;
                        bestDigestOutputSizeBits = outputSizeBits;
                        continue;
                    }
                    if (bestDigestOutputSizeBits < keySizeBits) {
                        if (outputSizeBits <= bestDigestOutputSizeBits) continue;
                        bestKeymasterDigest = keymasterDigest;
                        bestDigestOutputSizeBits = outputSizeBits;
                        continue;
                    }
                    if (outputSizeBits >= bestDigestOutputSizeBits || outputSizeBits < keySizeBits) continue;
                    bestKeymasterDigest = keymasterDigest;
                    bestDigestOutputSizeBits = outputSizeBits;
                }
                if (bestKeymasterDigest == -1) {
                    return null;
                }
                return KeyProperties.Digest.fromKeymasterToSignatureAlgorithmDigest(bestKeymasterDigest) + "WithECDSA";
            }
            case 1: {
                boolean pkcs1SignaturePaddingSupported = ArrayUtils.contains(KeyProperties.SignaturePadding.allToKeymaster(spec.getSignaturePaddings()), 5);
                if (!pkcs1SignaturePaddingSupported) {
                    return null;
                }
                Set<Integer> availableKeymasterDigests = AndroidKeyStoreKeyPairGeneratorSpi.getAvailableKeymasterSignatureDigests(spec.getDigests(), AndroidKeyStoreBCWorkaroundProvider.getSupportedEcdsaSignatureDigests());
                int maxDigestOutputSizeBits = keySizeBits - 240;
                int bestKeymasterDigest = -1;
                int bestDigestOutputSizeBits = -1;
                for (int keymasterDigest : availableKeymasterDigests) {
                    int outputSizeBits = KeymasterUtils.getDigestOutputSizeBits(keymasterDigest);
                    if (outputSizeBits > maxDigestOutputSizeBits) continue;
                    if (bestKeymasterDigest == -1) {
                        bestKeymasterDigest = keymasterDigest;
                        bestDigestOutputSizeBits = outputSizeBits;
                        continue;
                    }
                    if (outputSizeBits <= bestDigestOutputSizeBits) continue;
                    bestKeymasterDigest = keymasterDigest;
                    bestDigestOutputSizeBits = outputSizeBits;
                }
                if (bestKeymasterDigest == -1) {
                    return null;
                }
                return KeyProperties.Digest.fromKeymasterToSignatureAlgorithmDigest(bestKeymasterDigest) + "WithRSA";
            }
        }
        throw new ProviderException("Unsupported algorithm: " + keymasterAlgorithm);
    }

    private static final Set<Integer> $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getAvailableKeymasterSignatureDigests(String[] authorizedKeyDigests, String[] supportedSignatureDigests) {
        HashSet<Integer> authorizedKeymasterKeyDigests = new HashSet<Integer>();
        for (int keymasterDigest : KeyProperties.Digest.allToKeymaster(authorizedKeyDigests)) {
            authorizedKeymasterKeyDigests.add(keymasterDigest);
        }
        HashSet<Integer> supportedKeymasterSignatureDigests = new HashSet<Integer>();
        for (int keymasterDigest : KeyProperties.Digest.allToKeymaster(supportedSignatureDigests)) {
            supportedKeymasterSignatureDigests.add(keymasterDigest);
        }
        HashSet<Integer> result = new HashSet<Integer>(supportedKeymasterSignatureDigests);
        result.retainAll(authorizedKeymasterKeyDigests);
        return result;
    }

    static void __staticInitializer__() {
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE = new HashMap<String, Integer>();
        SUPPORTED_EC_NIST_CURVE_NAMES = new ArrayList<String>();
        SUPPORTED_EC_NIST_CURVE_SIZES = new ArrayList<Integer>();
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("p-224", 224);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("secp224r1", 224);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("p-256", 256);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("secp256r1", 256);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("prime256v1", 256);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("p-384", 384);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("secp384r1", 384);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("p-521", 521);
        SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.put("secp521r1", 521);
        SUPPORTED_EC_NIST_CURVE_NAMES.addAll(SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.keySet());
        Collections.sort(SUPPORTED_EC_NIST_CURVE_NAMES);
        SUPPORTED_EC_NIST_CURVE_SIZES.addAll(new HashSet<Integer>(SUPPORTED_EC_NIST_CURVE_NAME_TO_SIZE.values()));
        Collections.sort(SUPPORTED_EC_NIST_CURVE_SIZES);
    }

    private void __constructor__(int n) {
        this.$$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$__constructor__(n);
    }

    protected AndroidKeyStoreKeyPairGeneratorSpi(int n) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$__constructor__(int ), 0, this, n);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$initialize(int java.security.SecureRandom ), 0, this, n, secureRandom);
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("initialize", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$initialize(java.security.spec.AlgorithmParameterSpec java.security.SecureRandom ), 0, this, algorithmParameterSpec, secureRandom);
    }

    private void resetAll() {
        InvokeDynamicSupport.bootstrap("resetAll", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$resetAll(), 0, this);
    }

    private void initAlgorithmSpecificParameters() throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrap("initAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$initAlgorithmSpecificParameters(), 0, this);
    }

    @Override
    public KeyPair generateKeyPair() {
        return InvokeDynamicSupport.bootstrap("generateKeyPair", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateKeyPair(), 0, this);
    }

    private Iterable<byte[]> createCertificateChain(String string2, KeyPair keyPair) throws ProviderException {
        return InvokeDynamicSupport.bootstrap("createCertificateChain", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$createCertificateChain(java.lang.String java.security.KeyPair ), 0, this, string2, keyPair);
    }

    private void generateKeystoreKeyPair(String string2, KeymasterArguments keymasterArguments, byte[] byArray, int n) throws ProviderException {
        InvokeDynamicSupport.bootstrap("generateKeystoreKeyPair", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateKeystoreKeyPair(java.lang.String android.security.keymaster.KeymasterArguments byte[] int ), 0, this, string2, keymasterArguments, byArray, n);
    }

    private KeyPair loadKeystoreKeyPair(String string2) throws ProviderException {
        return InvokeDynamicSupport.bootstrap("loadKeystoreKeyPair", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$loadKeystoreKeyPair(java.lang.String ), 0, this, string2);
    }

    private KeymasterArguments constructKeyGenerationArguments() {
        return InvokeDynamicSupport.bootstrap("constructKeyGenerationArguments", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$constructKeyGenerationArguments(), 0, this);
    }

    private void storeCertificateChain(int n, Iterable<byte[]> iterable) throws ProviderException {
        InvokeDynamicSupport.bootstrap("storeCertificateChain", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$storeCertificateChain(int java.lang.Iterable<byte[]> ), 0, this, n, iterable);
    }

    private void storeCertificate(String string2, byte[] byArray, int n, String string3) throws ProviderException {
        InvokeDynamicSupport.bootstrap("storeCertificate", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$storeCertificate(java.lang.String byte[] int java.lang.String ), 0, this, string2, byArray, n, string3);
    }

    private byte[] generateSelfSignedCertificateBytes(KeyPair keyPair) throws ProviderException {
        return InvokeDynamicSupport.bootstrap("generateSelfSignedCertificateBytes", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificateBytes(java.security.KeyPair ), 0, this, keyPair);
    }

    private Iterable<byte[]> getAttestationChain(String string2, KeyPair keyPair, KeymasterArguments keymasterArguments) throws ProviderException {
        return InvokeDynamicSupport.bootstrap("getAttestationChain", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getAttestationChain(java.lang.String java.security.KeyPair android.security.keymaster.KeymasterArguments ), 0, this, string2, keyPair, keymasterArguments);
    }

    private void addAlgorithmSpecificParameters(KeymasterArguments keymasterArguments) {
        InvokeDynamicSupport.bootstrap("addAlgorithmSpecificParameters", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$addAlgorithmSpecificParameters(android.security.keymaster.KeymasterArguments ), 0, this, keymasterArguments);
    }

    private X509Certificate generateSelfSignedCertificate(PrivateKey privateKey, PublicKey publicKey) throws CertificateParsingException, IOException {
        return InvokeDynamicSupport.bootstrap("generateSelfSignedCertificate", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificate(java.security.PrivateKey java.security.PublicKey ), 0, this, privateKey, publicKey);
    }

    private X509Certificate generateSelfSignedCertificateWithValidSignature(PrivateKey privateKey, PublicKey publicKey, String string2) throws Exception {
        return InvokeDynamicSupport.bootstrap("generateSelfSignedCertificateWithValidSignature", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificateWithValidSignature(java.security.PrivateKey java.security.PublicKey java.lang.String ), 0, this, privateKey, publicKey, string2);
    }

    private X509Certificate generateSelfSignedCertificateWithFakeSignature(PublicKey publicKey) throws IOException, CertificateParsingException {
        return InvokeDynamicSupport.bootstrap("generateSelfSignedCertificateWithFakeSignature", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$generateSelfSignedCertificateWithFakeSignature(java.security.PublicKey ), 0, this, publicKey);
    }

    private static int getDefaultKeySize(int n) {
        return (int)InvokeDynamicSupport.bootstrapStatic("getDefaultKeySize", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getDefaultKeySize(int ), 0, (int)n);
    }

    private static void checkValidKeySize(int n, int n2) throws InvalidAlgorithmParameterException {
        InvokeDynamicSupport.bootstrapStatic("checkValidKeySize", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$checkValidKeySize(int int ), 0, (int)n, (int)n2);
    }

    private static String getCertificateSignatureAlgorithm(int n, int n2, KeyGenParameterSpec keyGenParameterSpec) {
        return InvokeDynamicSupport.bootstrapStatic("getCertificateSignatureAlgorithm", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getCertificateSignatureAlgorithm(int int android.security.keystore.KeyGenParameterSpec ), 0, (int)n, (int)n2, (KeyGenParameterSpec)keyGenParameterSpec);
    }

    private static Set<Integer> getAvailableKeymasterSignatureDigests(String[] stringArray, String[] stringArray2) {
        return InvokeDynamicSupport.bootstrapStatic("getAvailableKeymasterSignatureDigests", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi$getAvailableKeymasterSignatureDigests(java.lang.String[] java.lang.String[] ), 0, (String[])stringArray, (String[])stringArray2);
    }

    static {
        RobolectricInternals.classInitializing(AndroidKeyStoreKeyPairGeneratorSpi.class);
    }

    public /* synthetic */ AndroidKeyStoreKeyPairGeneratorSpi() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AndroidKeyStoreKeyPairGeneratorSpi)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class EC
    extends AndroidKeyStoreKeyPairGeneratorSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi_EC$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi_EC$__constructor__();
        }

        public EC() {
            super(3);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi_EC$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (EC)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RSA
    extends AndroidKeyStoreKeyPairGeneratorSpi
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;

        private void $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi_RSA$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi_RSA$__constructor__();
        }

        public RSA() {
            super(1);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_security_keystore_AndroidKeyStoreKeyPairGeneratorSpi_RSA$__constructor__(), 0, this);
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RSA)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

