/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.content.res.Resources;
import android.renderscript.Allocation;
import android.renderscript.BaseObj;
import android.renderscript.Element;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RenderScript;
import android.renderscript.Sampler;
import android.renderscript.Type;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class Program
extends BaseObj
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static int MAX_INPUT = 8;
    static int MAX_OUTPUT = 8;
    static int MAX_CONSTANT = 8;
    static int MAX_TEXTURE = 8;
    Element[] mInputs;
    Element[] mOutputs;
    Type[] mConstants;
    TextureType[] mTextures;
    String[] mTextureNames;
    int mTextureCount;
    String mShader;

    private void $$robo$$android_renderscript_Program$__constructor__(long id2, RenderScript rs) {
        this.guard.open("destroy");
    }

    private final int $$robo$$android_renderscript_Program$getConstantCount() {
        return this.mConstants != null ? this.mConstants.length : 0;
    }

    private final Type $$robo$$android_renderscript_Program$getConstant(int slot) {
        if (slot < 0 || slot >= this.mConstants.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mConstants[slot];
    }

    private final int $$robo$$android_renderscript_Program$getTextureCount() {
        return this.mTextureCount;
    }

    private final TextureType $$robo$$android_renderscript_Program$getTextureType(int slot) {
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mTextures[slot];
    }

    private final String $$robo$$android_renderscript_Program$getTextureName(int slot) {
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        return this.mTextureNames[slot];
    }

    private final void $$robo$$android_renderscript_Program$bindConstants(Allocation a, int slot) {
        if (slot < 0 || slot >= this.mConstants.length) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        if (a != null && a.getType().getID(this.mRS) != this.mConstants[slot].getID(this.mRS)) {
            throw new IllegalArgumentException("Allocation type does not match slot type.");
        }
        long id2 = a != null ? a.getID(this.mRS) : 0L;
        this.mRS.nProgramBindConstants(this.getID(this.mRS), slot, id2);
    }

    private final void $$robo$$android_renderscript_Program$bindTexture(Allocation va, int slot) throws IllegalArgumentException {
        this.mRS.validate();
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        if (va != null && va.getType().hasFaces() && this.mTextures[slot] != TextureType.TEXTURE_CUBE) {
            throw new IllegalArgumentException("Cannot bind cubemap to 2d texture slot");
        }
        long id2 = va != null ? va.getID(this.mRS) : 0L;
        this.mRS.nProgramBindTexture(this.getID(this.mRS), slot, id2);
    }

    private final void $$robo$$android_renderscript_Program$bindSampler(Sampler vs, int slot) throws IllegalArgumentException {
        this.mRS.validate();
        if (slot < 0 || slot >= this.mTextureCount) {
            throw new IllegalArgumentException("Slot ID out of range.");
        }
        long id2 = vs != null ? vs.getID(this.mRS) : 0L;
        this.mRS.nProgramBindSampler(this.getID(this.mRS), slot, id2);
    }

    private void __constructor__(long l, RenderScript renderScript) {
        this.$$robo$$android_renderscript_Program$__constructor__(l, renderScript);
    }

    Program(long l, RenderScript renderScript) {
        super(l, renderScript);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Program$__constructor__(long android.renderscript.RenderScript ), 0, this, l, renderScript);
    }

    public int getConstantCount() {
        return (int)InvokeDynamicSupport.bootstrap("getConstantCount", $$robo$$android_renderscript_Program$getConstantCount(), 0, this);
    }

    public Type getConstant(int n) {
        return InvokeDynamicSupport.bootstrap("getConstant", $$robo$$android_renderscript_Program$getConstant(int ), 0, this, n);
    }

    public int getTextureCount() {
        return (int)InvokeDynamicSupport.bootstrap("getTextureCount", $$robo$$android_renderscript_Program$getTextureCount(), 0, this);
    }

    public TextureType getTextureType(int n) {
        return InvokeDynamicSupport.bootstrap("getTextureType", $$robo$$android_renderscript_Program$getTextureType(int ), 0, this, n);
    }

    public String getTextureName(int n) {
        return InvokeDynamicSupport.bootstrap("getTextureName", $$robo$$android_renderscript_Program$getTextureName(int ), 0, this, n);
    }

    public void bindConstants(Allocation allocation, int n) {
        InvokeDynamicSupport.bootstrap("bindConstants", $$robo$$android_renderscript_Program$bindConstants(android.renderscript.Allocation int ), 0, this, allocation, n);
    }

    public void bindTexture(Allocation allocation, int n) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("bindTexture", $$robo$$android_renderscript_Program$bindTexture(android.renderscript.Allocation int ), 0, this, allocation, n);
    }

    public void bindSampler(Sampler sampler, int n) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("bindSampler", $$robo$$android_renderscript_Program$bindSampler(android.renderscript.Sampler int ), 0, this, sampler, n);
    }

    public /* synthetic */ Program() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Program)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static class BaseProgramBuilder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        RenderScript mRS;
        Element[] mInputs;
        Element[] mOutputs;
        Type[] mConstants;
        Type[] mTextures;
        TextureType[] mTextureTypes;
        String[] mTextureNames;
        int mInputCount;
        int mOutputCount;
        int mConstantCount;
        int mTextureCount;
        String mShader;

        private void $$robo$$android_renderscript_Program_BaseProgramBuilder$__constructor__(RenderScript rs) {
            this.mRS = rs;
            this.mInputs = new Element[8];
            this.mOutputs = new Element[8];
            this.mConstants = new Type[8];
            this.mInputCount = 0;
            this.mOutputCount = 0;
            this.mConstantCount = 0;
            this.mTextureCount = 0;
            this.mTextureTypes = new TextureType[8];
            this.mTextureNames = new String[8];
        }

        private final BaseProgramBuilder $$robo$$android_renderscript_Program_BaseProgramBuilder$setShader(String s) {
            this.mShader = s;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final BaseProgramBuilder $$robo$$android_renderscript_Program_BaseProgramBuilder$setShader(Resources resources, int resourceID) {
            int strLength;
            byte[] str;
            InputStream is = resources.openRawResource(resourceID);
            try {
                try {
                    str = new byte[1024];
                    strLength = 0;
                    while (true) {
                        int bytesRead;
                        int bytesLeft;
                        if ((bytesLeft = str.length - strLength) == 0) {
                            byte[] buf2 = new byte[str.length * 2];
                            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])str, (int)0, (byte[])buf2, (int)0, (int)str.length);
                            str = buf2;
                            bytesLeft = str.length - strLength;
                        }
                        if ((bytesRead = is.read(str, strLength, bytesLeft)) <= 0) {
                            break;
                        }
                        strLength += bytesRead;
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                throw new Resources.NotFoundException();
            }
            try {
                this.mShader = new String(str, 0, strLength, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Log.e("RenderScript shader creation", "Could not decode shader string");
            }
            return this;
        }

        private final int $$robo$$android_renderscript_Program_BaseProgramBuilder$getCurrentConstantIndex() {
            return this.mConstantCount - 1;
        }

        private final int $$robo$$android_renderscript_Program_BaseProgramBuilder$getCurrentTextureIndex() {
            return this.mTextureCount - 1;
        }

        private final BaseProgramBuilder $$robo$$android_renderscript_Program_BaseProgramBuilder$addConstant(Type t) throws IllegalStateException {
            if (this.mConstantCount >= 8) {
                throw new RSIllegalArgumentException("Max input count exceeded.");
            }
            if (t.getElement().isComplex()) {
                throw new RSIllegalArgumentException("Complex elements not allowed.");
            }
            this.mConstants[this.mConstantCount] = t;
            ++this.mConstantCount;
            return this;
        }

        private final BaseProgramBuilder $$robo$$android_renderscript_Program_BaseProgramBuilder$addTexture(TextureType texType) throws IllegalArgumentException {
            this.addTexture(texType, "Tex" + this.mTextureCount);
            return this;
        }

        private final BaseProgramBuilder $$robo$$android_renderscript_Program_BaseProgramBuilder$addTexture(TextureType texType, String texName) throws IllegalArgumentException {
            if (this.mTextureCount >= 8) {
                throw new IllegalArgumentException("Max texture count exceeded.");
            }
            this.mTextureTypes[this.mTextureCount] = texType;
            this.mTextureNames[this.mTextureCount] = texName;
            ++this.mTextureCount;
            return this;
        }

        private final void $$robo$$android_renderscript_Program_BaseProgramBuilder$initProgram(Program p) {
            p.mInputs = new Element[this.mInputCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mInputs, (int)0, (Object)p.mInputs, (int)0, (int)this.mInputCount);
            p.mOutputs = new Element[this.mOutputCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mOutputs, (int)0, (Object)p.mOutputs, (int)0, (int)this.mOutputCount);
            p.mConstants = new Type[this.mConstantCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mConstants, (int)0, (Object)p.mConstants, (int)0, (int)this.mConstantCount);
            p.mTextureCount = this.mTextureCount;
            p.mTextures = new TextureType[this.mTextureCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mTextureTypes, (int)0, (Object)p.mTextures, (int)0, (int)this.mTextureCount);
            p.mTextureNames = new String[this.mTextureCount];
            InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (Object)this.mTextureNames, (int)0, (Object)p.mTextureNames, (int)0, (int)this.mTextureCount);
        }

        private void __constructor__(RenderScript renderScript) {
            this.$$robo$$android_renderscript_Program_BaseProgramBuilder$__constructor__(renderScript);
        }

        protected BaseProgramBuilder(RenderScript renderScript) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Program_BaseProgramBuilder$__constructor__(android.renderscript.RenderScript ), 0, this, renderScript);
        }

        public BaseProgramBuilder setShader(String string2) {
            return InvokeDynamicSupport.bootstrap("setShader", $$robo$$android_renderscript_Program_BaseProgramBuilder$setShader(java.lang.String ), 0, this, string2);
        }

        public BaseProgramBuilder setShader(Resources resources, int n) {
            return InvokeDynamicSupport.bootstrap("setShader", $$robo$$android_renderscript_Program_BaseProgramBuilder$setShader(android.content.res.Resources int ), 0, this, resources, n);
        }

        public int getCurrentConstantIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentConstantIndex", $$robo$$android_renderscript_Program_BaseProgramBuilder$getCurrentConstantIndex(), 0, this);
        }

        public int getCurrentTextureIndex() {
            return (int)InvokeDynamicSupport.bootstrap("getCurrentTextureIndex", $$robo$$android_renderscript_Program_BaseProgramBuilder$getCurrentTextureIndex(), 0, this);
        }

        public BaseProgramBuilder addConstant(Type type) throws IllegalStateException {
            return InvokeDynamicSupport.bootstrap("addConstant", $$robo$$android_renderscript_Program_BaseProgramBuilder$addConstant(android.renderscript.Type ), 0, this, type);
        }

        public BaseProgramBuilder addTexture(TextureType textureType) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("addTexture", $$robo$$android_renderscript_Program_BaseProgramBuilder$addTexture(android.renderscript.Program$TextureType ), 0, this, textureType);
        }

        public BaseProgramBuilder addTexture(TextureType textureType, String string2) throws IllegalArgumentException {
            return InvokeDynamicSupport.bootstrap("addTexture", $$robo$$android_renderscript_Program_BaseProgramBuilder$addTexture(android.renderscript.Program$TextureType java.lang.String ), 0, this, textureType, string2);
        }

        protected void initProgram(Program program) {
            InvokeDynamicSupport.bootstrap("initProgram", $$robo$$android_renderscript_Program_BaseProgramBuilder$initProgram(android.renderscript.Program ), 0, this, program);
        }

        public /* synthetic */ BaseProgramBuilder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BaseProgramBuilder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class ProgramParam
    extends Enum<ProgramParam> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ ProgramParam INPUT;
        public static /* enum */ ProgramParam OUTPUT;
        public static /* enum */ ProgramParam CONSTANT;
        public static /* enum */ ProgramParam TEXTURE_TYPE;
        int mID;
        private static /* synthetic */ ProgramParam[] $VALUES;

        private static final ProgramParam[] $$robo$$android_renderscript_Program_ProgramParam$values() {
            return (ProgramParam[])$VALUES.clone();
        }

        private static final ProgramParam $$robo$$android_renderscript_Program_ProgramParam$valueOf(String name) {
            return Enum.valueOf(ProgramParam.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Program_ProgramParam$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
        }

        static void __staticInitializer__() {
            INPUT = new ProgramParam(0);
            OUTPUT = new ProgramParam(1);
            CONSTANT = new ProgramParam(2);
            TEXTURE_TYPE = new ProgramParam(3);
            $VALUES = new ProgramParam[]{INPUT, OUTPUT, CONSTANT, TEXTURE_TYPE};
        }

        public static ProgramParam[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Program_ProgramParam$values(), 0);
        }

        public static ProgramParam valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Program_ProgramParam$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_Program_ProgramParam$__constructor__(string2, n, n2);
        }

        private ProgramParam(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Program_ProgramParam$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(ProgramParam.class);
        }

        public /* synthetic */ ProgramParam() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ProgramParam)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class TextureType
    extends Enum<TextureType> {
        public transient /* synthetic */ Object __robo_data__;
        public static /* enum */ TextureType TEXTURE_2D;
        public static /* enum */ TextureType TEXTURE_CUBE;
        int mID;
        private static /* synthetic */ TextureType[] $VALUES;

        private static final TextureType[] $$robo$$android_renderscript_Program_TextureType$values() {
            return (TextureType[])$VALUES.clone();
        }

        private static final TextureType $$robo$$android_renderscript_Program_TextureType$valueOf(String name) {
            return Enum.valueOf(TextureType.class, name);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void $$robo$$android_renderscript_Program_TextureType$__constructor__(String string2, int n, int id2) {
            this.mID = id2;
        }

        static void __staticInitializer__() {
            TEXTURE_2D = new TextureType(0);
            TEXTURE_CUBE = new TextureType(1);
            $VALUES = new TextureType[]{TEXTURE_2D, TEXTURE_CUBE};
        }

        public static TextureType[] values() {
            return InvokeDynamicSupport.bootstrapStatic("values", $$robo$$android_renderscript_Program_TextureType$values(), 0);
        }

        public static TextureType valueOf(String string2) {
            return InvokeDynamicSupport.bootstrapStatic("valueOf", $$robo$$android_renderscript_Program_TextureType$valueOf(java.lang.String ), 0, (String)string2);
        }

        /*
         * Ignored method signature, as it can't be verified against descriptor
         */
        private void __constructor__(String string2, int n, int n2) {
            this.$$robo$$android_renderscript_Program_TextureType$__constructor__(string2, n, n2);
        }

        private TextureType(int n2) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_Program_TextureType$__constructor__(java.lang.String int int ), 0, this, string2, n, n2);
        }

        static {
            RobolectricInternals.classInitializing(TextureType.class);
        }

        public /* synthetic */ TextureType() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TextureType)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

