/*
 * Decompiled with CFR 0.152.
 */
package android.renderscript;

import android.renderscript.Allocation;
import android.renderscript.RSIllegalArgumentException;
import android.renderscript.RSInvalidStateException;
import android.renderscript.RSRuntimeException;
import android.renderscript.RenderScript;
import android.renderscript.Type;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class AllocationAdapter
extends Allocation
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    Type mWindow;

    private void $$robo$$android_renderscript_AllocationAdapter$__constructor__(long id2, RenderScript rs, Allocation alloc, Type t) {
        this.mAdaptedAllocation = alloc;
        this.mWindow = t;
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$initLOD(int lod) {
        if (lod < 0) {
            throw new RSIllegalArgumentException("Attempting to set negative lod (" + lod + ").");
        }
        int tx = this.mAdaptedAllocation.mType.getX();
        int ty = this.mAdaptedAllocation.mType.getY();
        int tz = this.mAdaptedAllocation.mType.getZ();
        for (int ct = 0; ct < lod; ++ct) {
            if (tx == 1 && ty == 1 && tz == 1) {
                throw new RSIllegalArgumentException("Attempting to set lod (" + lod + ") out of range.");
            }
            if (tx > 1) {
                tx >>= 1;
            }
            if (ty > 1) {
                ty >>= 1;
            }
            if (tz <= 1) continue;
            tz >>= 1;
        }
        this.mCurrentDimX = tx;
        this.mCurrentDimY = ty;
        this.mCurrentDimZ = tz;
        this.mCurrentCount = this.mCurrentDimX;
        if (this.mCurrentDimY > 1) {
            this.mCurrentCount *= this.mCurrentDimY;
        }
        if (this.mCurrentDimZ > 1) {
            this.mCurrentCount *= this.mCurrentDimZ;
        }
        this.mSelectedY = 0;
        this.mSelectedZ = 0;
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$updateOffsets() {
        int a1 = 0;
        int a2 = 0;
        int a3 = 0;
        int a4 = 0;
        if (this.mSelectedArray != null) {
            if (this.mSelectedArray.length > 0) {
                a1 = this.mSelectedArray[0];
            }
            if (this.mSelectedArray.length > 1) {
                a2 = this.mSelectedArray[2];
            }
            if (this.mSelectedArray.length > 2) {
                a3 = this.mSelectedArray[2];
            }
            if (this.mSelectedArray.length > 3) {
                a4 = this.mSelectedArray[3];
            }
        }
        this.mRS.nAllocationAdapterOffset(this.getID(this.mRS), this.mSelectedX, this.mSelectedY, this.mSelectedZ, this.mSelectedLOD, this.mSelectedFace.mID, a1, a2, a3, a4);
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$setLOD(int lod) {
        if (!this.mAdaptedAllocation.getType().hasMipmaps()) {
            throw new RSInvalidStateException("Cannot set LOD when the allocation type does not include mipmaps.");
        }
        if (this.mWindow.hasMipmaps()) {
            throw new RSInvalidStateException("Cannot set LOD when the adapter includes mipmaps.");
        }
        this.initLOD(lod);
        this.mSelectedLOD = lod;
        this.updateOffsets();
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$setFace(Type.CubemapFace cf) {
        if (!this.mAdaptedAllocation.getType().hasFaces()) {
            throw new RSInvalidStateException("Cannot set Face when the allocation type does not include faces.");
        }
        if (this.mWindow.hasFaces()) {
            throw new RSInvalidStateException("Cannot set face when the adapter includes faces.");
        }
        if (cf == null) {
            throw new RSIllegalArgumentException("Cannot set null face.");
        }
        this.mSelectedFace = cf;
        this.updateOffsets();
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$setX(int x) {
        if (this.mAdaptedAllocation.getType().getX() <= x) {
            throw new RSInvalidStateException("Cannot set X greater than dimension of allocation.");
        }
        if (this.mWindow.getX() == this.mAdaptedAllocation.getType().getX()) {
            throw new RSInvalidStateException("Cannot set X when the adapter includes X.");
        }
        if (this.mWindow.getX() + x >= this.mAdaptedAllocation.getType().getX()) {
            throw new RSInvalidStateException("Cannot set (X + window) which would be larger than dimension of allocation.");
        }
        this.mSelectedX = x;
        this.updateOffsets();
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$setY(int y) {
        if (this.mAdaptedAllocation.getType().getY() == 0) {
            throw new RSInvalidStateException("Cannot set Y when the allocation type does not include Y dim.");
        }
        if (this.mAdaptedAllocation.getType().getY() <= y) {
            throw new RSInvalidStateException("Cannot set Y greater than dimension of allocation.");
        }
        if (this.mWindow.getY() == this.mAdaptedAllocation.getType().getY()) {
            throw new RSInvalidStateException("Cannot set Y when the adapter includes Y.");
        }
        if (this.mWindow.getY() + y >= this.mAdaptedAllocation.getType().getY()) {
            throw new RSInvalidStateException("Cannot set (Y + window) which would be larger than dimension of allocation.");
        }
        this.mSelectedY = y;
        this.updateOffsets();
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$setZ(int z) {
        if (this.mAdaptedAllocation.getType().getZ() == 0) {
            throw new RSInvalidStateException("Cannot set Z when the allocation type does not include Z dim.");
        }
        if (this.mAdaptedAllocation.getType().getZ() <= z) {
            throw new RSInvalidStateException("Cannot set Z greater than dimension of allocation.");
        }
        if (this.mWindow.getZ() == this.mAdaptedAllocation.getType().getZ()) {
            throw new RSInvalidStateException("Cannot set Z when the adapter includes Z.");
        }
        if (this.mWindow.getZ() + z >= this.mAdaptedAllocation.getType().getZ()) {
            throw new RSInvalidStateException("Cannot set (Z + window) which would be larger than dimension of allocation.");
        }
        this.mSelectedZ = z;
        this.updateOffsets();
    }

    private final void $$robo$$android_renderscript_AllocationAdapter$setArray(int arrayNum, int arrayVal) {
        if (this.mAdaptedAllocation.getType().getArray(arrayNum) == 0) {
            throw new RSInvalidStateException("Cannot set arrayNum when the allocation type does not include arrayNum dim.");
        }
        if (this.mAdaptedAllocation.getType().getArray(arrayNum) <= arrayVal) {
            throw new RSInvalidStateException("Cannot set arrayNum greater than dimension of allocation.");
        }
        if (this.mWindow.getArray(arrayNum) == this.mAdaptedAllocation.getType().getArray(arrayNum)) {
            throw new RSInvalidStateException("Cannot set arrayNum when the adapter includes arrayNum.");
        }
        if (this.mWindow.getArray(arrayNum) + arrayVal >= this.mAdaptedAllocation.getType().getArray(arrayNum)) {
            throw new RSInvalidStateException("Cannot set (arrayNum + window) which would be larger than dimension of allocation.");
        }
        this.mSelectedArray[arrayNum] = arrayVal;
        this.updateOffsets();
    }

    private static final AllocationAdapter $$robo$$android_renderscript_AllocationAdapter$create1D(RenderScript rs, Allocation a) {
        rs.validate();
        Type t = Type.createX(rs, a.getElement(), a.getType().getX());
        return AllocationAdapter.createTyped(rs, a, t);
    }

    private static final AllocationAdapter $$robo$$android_renderscript_AllocationAdapter$create2D(RenderScript rs, Allocation a) {
        rs.validate();
        Type t = Type.createXY(rs, a.getElement(), a.getType().getX(), a.getType().getY());
        return AllocationAdapter.createTyped(rs, a, t);
    }

    private static final AllocationAdapter $$robo$$android_renderscript_AllocationAdapter$createTyped(RenderScript rs, Allocation a, Type t) {
        long id2;
        rs.validate();
        if (a.mAdaptedAllocation != null) {
            throw new RSInvalidStateException("Adapters cannot be nested.");
        }
        if (!a.getType().getElement().equals(t.getElement())) {
            throw new RSInvalidStateException("Element must match Allocation type.");
        }
        if (t.hasFaces() || t.hasMipmaps()) {
            throw new RSInvalidStateException("Adapters do not support window types with Mipmaps or Faces.");
        }
        Type at = a.getType();
        if (t.getX() > at.getX() || t.getY() > at.getY() || t.getZ() > at.getZ() || t.getArrayCount() > at.getArrayCount()) {
            throw new RSInvalidStateException("Type cannot have dimension larger than the source allocation.");
        }
        if (t.getArrayCount() > 0) {
            for (int i = 0; i < t.getArray(i); ++i) {
                if (t.getArray(i) <= at.getArray(i)) continue;
                throw new RSInvalidStateException("Type cannot have dimension larger than the source allocation.");
            }
        }
        if ((id2 = rs.nAllocationAdapterCreate(a.getID(rs), t.getID(rs))) == 0L) {
            throw new RSRuntimeException("AllocationAdapter creation failed.");
        }
        return new AllocationAdapter(id2, rs, a, t);
    }

    private final synchronized void $$robo$$android_renderscript_AllocationAdapter$resize(int dimX) {
        throw new RSInvalidStateException("Resize not allowed for Adapters.");
    }

    private void __constructor__(long l, RenderScript renderScript, Allocation allocation, Type type) {
        this.$$robo$$android_renderscript_AllocationAdapter$__constructor__(l, renderScript, allocation, type);
    }

    AllocationAdapter(long l, RenderScript renderScript, Allocation allocation, Type type) {
        super(l, renderScript, allocation.mType, allocation.mUsage);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_renderscript_AllocationAdapter$__constructor__(long android.renderscript.RenderScript android.renderscript.Allocation android.renderscript.Type ), 0, this, l, renderScript, allocation, type);
    }

    void initLOD(int n) {
        InvokeDynamicSupport.bootstrap("initLOD", $$robo$$android_renderscript_AllocationAdapter$initLOD(int ), 0, this, n);
    }

    private void updateOffsets() {
        InvokeDynamicSupport.bootstrap("updateOffsets", $$robo$$android_renderscript_AllocationAdapter$updateOffsets(), 0, this);
    }

    public void setLOD(int n) {
        InvokeDynamicSupport.bootstrap("setLOD", $$robo$$android_renderscript_AllocationAdapter$setLOD(int ), 0, this, n);
    }

    public void setFace(Type.CubemapFace cubemapFace) {
        InvokeDynamicSupport.bootstrap("setFace", $$robo$$android_renderscript_AllocationAdapter$setFace(android.renderscript.Type$CubemapFace ), 0, this, cubemapFace);
    }

    public void setX(int n) {
        InvokeDynamicSupport.bootstrap("setX", $$robo$$android_renderscript_AllocationAdapter$setX(int ), 0, this, n);
    }

    public void setY(int n) {
        InvokeDynamicSupport.bootstrap("setY", $$robo$$android_renderscript_AllocationAdapter$setY(int ), 0, this, n);
    }

    public void setZ(int n) {
        InvokeDynamicSupport.bootstrap("setZ", $$robo$$android_renderscript_AllocationAdapter$setZ(int ), 0, this, n);
    }

    public void setArray(int n, int n2) {
        InvokeDynamicSupport.bootstrap("setArray", $$robo$$android_renderscript_AllocationAdapter$setArray(int int ), 0, this, n, n2);
    }

    public static AllocationAdapter create1D(RenderScript renderScript, Allocation allocation) {
        return InvokeDynamicSupport.bootstrapStatic("create1D", $$robo$$android_renderscript_AllocationAdapter$create1D(android.renderscript.RenderScript android.renderscript.Allocation ), 0, (RenderScript)renderScript, (Allocation)allocation);
    }

    public static AllocationAdapter create2D(RenderScript renderScript, Allocation allocation) {
        return InvokeDynamicSupport.bootstrapStatic("create2D", $$robo$$android_renderscript_AllocationAdapter$create2D(android.renderscript.RenderScript android.renderscript.Allocation ), 0, (RenderScript)renderScript, (Allocation)allocation);
    }

    public static AllocationAdapter createTyped(RenderScript renderScript, Allocation allocation, Type type) {
        return InvokeDynamicSupport.bootstrapStatic("createTyped", $$robo$$android_renderscript_AllocationAdapter$createTyped(android.renderscript.RenderScript android.renderscript.Allocation android.renderscript.Type ), 0, (RenderScript)renderScript, (Allocation)allocation, (Type)type);
    }

    @Override
    public synchronized void resize(int n) {
        InvokeDynamicSupport.bootstrap("resize", $$robo$$android_renderscript_AllocationAdapter$resize(int ), 0, this, n);
    }

    public /* synthetic */ AllocationAdapter() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (AllocationAdapter)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

