/*
 * Decompiled with CFR 0.152.
 */
package android.provider;

import android.content.ContentProviderClient;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ResolveInfo;
import android.content.res.AssetFileDescriptor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Point;
import android.media.ExifInterface;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.ParcelableException;
import android.os.RemoteException;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.util.Log;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import libcore.io.IoUtils;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class DocumentsContract
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "DocumentsContract";
    public static String PROVIDER_INTERFACE = "android.content.action.DOCUMENTS_PROVIDER";
    public static String EXTRA_PACKAGE_NAME = "android.content.extra.PACKAGE_NAME";
    public static String EXTRA_SHOW_ADVANCED = "android.content.extra.SHOW_ADVANCED";
    public static String EXTRA_TARGET_URI = "android.content.extra.TARGET_URI";
    public static String EXTRA_INITIAL_URI = "android.provider.extra.INITIAL_URI";
    public static String EXTRA_EXCLUDE_SELF = "android.provider.extra.EXCLUDE_SELF";
    public static String EXTRA_ORIENTATION = "android.provider.extra.ORIENTATION";
    public static String EXTRA_PROMPT = "android.provider.extra.PROMPT";
    public static String ACTION_DOCUMENT_SETTINGS = "android.provider.action.DOCUMENT_SETTINGS";
    public static String ACTION_MANAGE_DOCUMENT = "android.provider.action.MANAGE_DOCUMENT";
    public static String ACTION_DOCUMENT_ROOT_SETTINGS = "android.provider.action.DOCUMENT_ROOT_SETTINGS";
    private static int THUMBNAIL_BUFFER_SIZE = 131072;
    public static String EXTERNAL_STORAGE_PROVIDER_AUTHORITY = "com.android.externalstorage.documents";
    public static String PACKAGE_DOCUMENTS_UI = "com.android.documentsui";
    public static String EXTRA_LOADING = "loading";
    public static String EXTRA_INFO = "info";
    public static String EXTRA_ERROR = "error";
    public static String EXTRA_RESULT = "result";
    public static String METHOD_CREATE_DOCUMENT = "android:createDocument";
    public static String METHOD_RENAME_DOCUMENT = "android:renameDocument";
    public static String METHOD_DELETE_DOCUMENT = "android:deleteDocument";
    public static String METHOD_COPY_DOCUMENT = "android:copyDocument";
    public static String METHOD_MOVE_DOCUMENT = "android:moveDocument";
    public static String METHOD_IS_CHILD_DOCUMENT = "android:isChildDocument";
    public static String METHOD_REMOVE_DOCUMENT = "android:removeDocument";
    public static String METHOD_EJECT_ROOT = "android:ejectRoot";
    public static String METHOD_FIND_DOCUMENT_PATH = "android:findDocumentPath";
    public static String METHOD_CREATE_WEB_LINK_INTENT = "android:createWebLinkIntent";
    public static String EXTRA_PARENT_URI = "parentUri";
    public static String EXTRA_URI = "uri";
    public static String EXTRA_OPTIONS = "options";
    private static String PATH_ROOT = "root";
    private static String PATH_RECENT = "recent";
    private static String PATH_DOCUMENT = "document";
    private static String PATH_CHILDREN = "children";
    private static String PATH_SEARCH = "search";
    private static String PATH_TREE = "tree";
    private static String PARAM_QUERY = "query";
    private static String PARAM_MANAGE = "manage";

    private void $$robo$$android_provider_DocumentsContract$__constructor__() {
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildRootsUri(String authority) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildRootUri(String authority, String rootId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").appendPath(rootId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildHomeUri() {
        return DocumentsContract.buildRootUri("com.android.externalstorage.documents", "home");
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildRecentDocumentsUri(String authority, String rootId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").appendPath(rootId).appendPath("recent").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildTreeDocumentUri(String authority, String documentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("tree").appendPath(documentId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildDocumentUri(String authority, String documentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("document").appendPath(documentId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildDocumentUriUsingTree(Uri treeUri, String documentId) {
        return new Uri.Builder().scheme("content").authority(treeUri.getAuthority()).appendPath("tree").appendPath(DocumentsContract.getTreeDocumentId(treeUri)).appendPath("document").appendPath(documentId).build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildDocumentUriMaybeUsingTree(Uri baseUri, String documentId) {
        if (DocumentsContract.isTreeUri(baseUri)) {
            return DocumentsContract.buildDocumentUriUsingTree(baseUri, documentId);
        }
        return DocumentsContract.buildDocumentUri(baseUri.getAuthority(), documentId);
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildChildDocumentsUri(String authority, String parentDocumentId) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("document").appendPath(parentDocumentId).appendPath("children").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildChildDocumentsUriUsingTree(Uri treeUri, String parentDocumentId) {
        return new Uri.Builder().scheme("content").authority(treeUri.getAuthority()).appendPath("tree").appendPath(DocumentsContract.getTreeDocumentId(treeUri)).appendPath("document").appendPath(parentDocumentId).appendPath("children").build();
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$buildSearchDocumentsUri(String authority, String rootId, String query) {
        return new Uri.Builder().scheme("content").authority(authority).appendPath("root").appendPath(rootId).appendPath("search").appendQueryParameter("query", query).build();
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isDocumentUri(Context context, Uri uri) {
        if (DocumentsContract.isContentUri(uri) && DocumentsContract.isDocumentsProvider(context, uri.getAuthority())) {
            List<String> paths = uri.getPathSegments();
            if (paths.size() == 2) {
                return "document".equals(paths.get(0));
            }
            if (paths.size() == 4) {
                return "tree".equals(paths.get(0)) && "document".equals(paths.get(2));
            }
        }
        return false;
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isRootUri(Context context, Uri uri) {
        if (DocumentsContract.isContentUri(uri) && DocumentsContract.isDocumentsProvider(context, uri.getAuthority())) {
            List<String> paths = uri.getPathSegments();
            return paths.size() == 2 && "root".equals(paths.get(0));
        }
        return false;
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isContentUri(Uri uri) {
        return uri != null && "content".equals(uri.getScheme());
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isTreeUri(Uri uri) {
        List<String> paths = uri.getPathSegments();
        return paths.size() >= 2 && "tree".equals(paths.get(0));
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isDocumentsProvider(Context context, String authority) {
        Intent intent = new Intent("android.content.action.DOCUMENTS_PROVIDER");
        List<ResolveInfo> infos = context.getPackageManager().queryIntentContentProviders(intent, 0);
        for (ResolveInfo info : infos) {
            if (!authority.equals(info.providerInfo.authority)) continue;
            return true;
        }
        return false;
    }

    private static final String $$robo$$android_provider_DocumentsContract$getRootId(Uri rootUri) {
        List<String> paths = rootUri.getPathSegments();
        if (paths.size() >= 2 && "root".equals(paths.get(0))) {
            return paths.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + rootUri);
    }

    private static final String $$robo$$android_provider_DocumentsContract$getDocumentId(Uri documentUri) {
        List<String> paths = documentUri.getPathSegments();
        if (paths.size() >= 2 && "document".equals(paths.get(0))) {
            return paths.get(1);
        }
        if (paths.size() >= 4 && "tree".equals(paths.get(0)) && "document".equals(paths.get(2))) {
            return paths.get(3);
        }
        throw new IllegalArgumentException("Invalid URI: " + documentUri);
    }

    private static final String $$robo$$android_provider_DocumentsContract$getTreeDocumentId(Uri documentUri) {
        List<String> paths = documentUri.getPathSegments();
        if (paths.size() >= 2 && "tree".equals(paths.get(0))) {
            return paths.get(1);
        }
        throw new IllegalArgumentException("Invalid URI: " + documentUri);
    }

    private static final String $$robo$$android_provider_DocumentsContract$getSearchDocumentsQuery(Uri searchDocumentsUri) {
        return searchDocumentsUri.getQueryParameter("query");
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$setManageMode(Uri uri) {
        return uri.buildUpon().appendQueryParameter("manage", "true").build();
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isManageMode(Uri uri) {
        return uri.getBooleanQueryParameter("manage", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(ContentResolver resolver, Uri documentUri, Point size, CancellationSignal signal) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Bitmap bitmap = DocumentsContract.getDocumentThumbnail(client, documentUri, size, signal);
            return bitmap;
        }
        catch (Exception e) {
            if (!(e instanceof OperationCanceledException)) {
                Log.w("DocumentsContract", "Failed to load thumbnail for " + documentUri + ": " + e);
            }
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Bitmap $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(ContentProviderClient client, Uri documentUri, Point size, CancellationSignal signal) throws RemoteException, IOException {
        Bundle openOpts = new Bundle();
        openOpts.putParcelable("android.content.extra.SIZE", size);
        AssetFileDescriptor afd = null;
        Bitmap bitmap = null;
        try {
            int orientation;
            afd = client.openTypedAssetFileDescriptor(documentUri, "image/*", openOpts, signal);
            FileDescriptor fd = afd.getFileDescriptor();
            long offset = afd.getStartOffset();
            BufferedInputStream is = null;
            try {
                Os.lseek(fd, offset, OsConstants.SEEK_SET);
            }
            catch (ErrnoException e) {
                is = new BufferedInputStream(new FileInputStream(fd), 131072);
                is.mark(131072);
            }
            BitmapFactory.Options opts = new BitmapFactory.Options();
            opts.inJustDecodeBounds = true;
            if (is != null) {
                BitmapFactory.decodeStream(is, null, opts);
            } else {
                BitmapFactory.decodeFileDescriptor(fd, null, opts);
            }
            int widthSample = opts.outWidth / size.x;
            int heightSample = opts.outHeight / size.y;
            opts.inJustDecodeBounds = false;
            opts.inSampleSize = Math.min(widthSample, heightSample);
            if (is != null) {
                is.reset();
                bitmap = BitmapFactory.decodeStream(is, null, opts);
            } else {
                try {
                    Os.lseek(fd, offset, OsConstants.SEEK_SET);
                }
                catch (ErrnoException e) {
                    e.rethrowAsIOException();
                }
                bitmap = BitmapFactory.decodeFileDescriptor(fd, null, opts);
            }
            Bundle extras = afd.getExtras();
            int n = orientation = extras != null ? extras.getInt("android.provider.extra.ORIENTATION", 0) : 0;
            if (orientation != 0) {
                int width = bitmap.getWidth();
                int height = bitmap.getHeight();
                Matrix m = new Matrix();
                m.setRotate(orientation, width / 2, height / 2);
                bitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height, m, false);
            }
        }
        catch (Throwable throwable) {
            IoUtils.closeQuietly(afd);
            throw throwable;
        }
        IoUtils.closeQuietly(afd);
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Uri $$robo$$android_provider_DocumentsContract$createDocument(ContentResolver resolver, Uri parentDocumentUri, String mimeType, String displayName) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(parentDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.createDocument(client, parentDocumentUri, mimeType, displayName);
            return uri;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to create document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$createDocument(ContentProviderClient client, Uri parentDocumentUri, String mimeType, String displayName) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", parentDocumentUri);
        in.putString("mime_type", mimeType);
        in.putString("_display_name", displayName);
        Bundle out = client.call("android:createDocument", null, in);
        return (Uri)out.getParcelable("uri");
    }

    private static final boolean $$robo$$android_provider_DocumentsContract$isChildDocument(ContentProviderClient client, Uri parentDocumentUri, Uri childDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", parentDocumentUri);
        in.putParcelable("android.content.extra.TARGET_URI", childDocumentUri);
        Bundle out = client.call("android:isChildDocument", null, in);
        if (out == null) {
            throw new RemoteException("Failed to get a reponse from isChildDocument query.");
        }
        if (!out.containsKey("result")) {
            throw new RemoteException("Response did not include result field..");
        }
        return out.getBoolean("result");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Uri $$robo$$android_provider_DocumentsContract$renameDocument(ContentResolver resolver, Uri documentUri, String displayName) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.renameDocument(client, documentUri, displayName);
            return uri;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to rename document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$renameDocument(ContentProviderClient client, Uri documentUri, String displayName) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", documentUri);
        in.putString("_display_name", displayName);
        Bundle out = client.call("android:renameDocument", null, in);
        Uri outUri = (Uri)out.getParcelable("uri");
        return outUri != null ? outUri : documentUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_provider_DocumentsContract$deleteDocument(ContentResolver resolver, Uri documentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            DocumentsContract.deleteDocument(client, documentUri);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to delete document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            boolean bl = false;
            return bl;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final void $$robo$$android_provider_DocumentsContract$deleteDocument(ContentProviderClient client, Uri documentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", documentUri);
        client.call("android:deleteDocument", null, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Uri $$robo$$android_provider_DocumentsContract$copyDocument(ContentResolver resolver, Uri sourceDocumentUri, Uri targetParentDocumentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(sourceDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.copyDocument(client, sourceDocumentUri, targetParentDocumentUri);
            return uri;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to copy document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$copyDocument(ContentProviderClient client, Uri sourceDocumentUri, Uri targetParentDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", sourceDocumentUri);
        in.putParcelable("android.content.extra.TARGET_URI", targetParentDocumentUri);
        Bundle out = client.call("android:copyDocument", null, in);
        return (Uri)out.getParcelable("uri");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Uri $$robo$$android_provider_DocumentsContract$moveDocument(ContentResolver resolver, Uri sourceDocumentUri, Uri sourceParentDocumentUri, Uri targetParentDocumentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(sourceDocumentUri.getAuthority());
        try {
            Uri uri = DocumentsContract.moveDocument(client, sourceDocumentUri, sourceParentDocumentUri, targetParentDocumentUri);
            return uri;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to move document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Uri uri = null;
            return uri;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Uri $$robo$$android_provider_DocumentsContract$moveDocument(ContentProviderClient client, Uri sourceDocumentUri, Uri sourceParentDocumentUri, Uri targetParentDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", sourceDocumentUri);
        in.putParcelable("parentUri", sourceParentDocumentUri);
        in.putParcelable("android.content.extra.TARGET_URI", targetParentDocumentUri);
        Bundle out = client.call("android:moveDocument", null, in);
        return (Uri)out.getParcelable("uri");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean $$robo$$android_provider_DocumentsContract$removeDocument(ContentResolver resolver, Uri documentUri, Uri parentDocumentUri) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(documentUri.getAuthority());
        try {
            DocumentsContract.removeDocument(client, documentUri, parentDocumentUri);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to remove document", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            boolean bl = false;
            return bl;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final void $$robo$$android_provider_DocumentsContract$removeDocument(ContentProviderClient client, Uri documentUri, Uri parentDocumentUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", documentUri);
        in.putParcelable("parentUri", parentDocumentUri);
        client.call("android:removeDocument", null, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_provider_DocumentsContract$ejectRoot(ContentResolver resolver, Uri rootUri) {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(rootUri.getAuthority());
        try {
            DocumentsContract.ejectRoot(client, rootUri);
        }
        catch (RemoteException e) {
            e.rethrowAsRuntimeException();
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final void $$robo$$android_provider_DocumentsContract$ejectRoot(ContentProviderClient client, Uri rootUri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", rootUri);
        client.call("android:ejectRoot", null, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Path $$robo$$android_provider_DocumentsContract$findDocumentPath(ContentResolver resolver, Uri treeUri) throws FileNotFoundException {
        Preconditions.checkArgument(DocumentsContract.isTreeUri(treeUri), treeUri + " is not a tree uri.");
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(treeUri.getAuthority());
        try {
            Path path = DocumentsContract.findDocumentPath(client, treeUri);
            return path;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to find path", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            Path path = null;
            return path;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final Path $$robo$$android_provider_DocumentsContract$findDocumentPath(ContentProviderClient client, Uri uri) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", uri);
        Bundle out = client.call("android:findDocumentPath", null, in);
        return (Path)out.getParcelable("result");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final IntentSender $$robo$$android_provider_DocumentsContract$createWebLinkIntent(ContentResolver resolver, Uri uri, Bundle options) throws FileNotFoundException {
        ContentProviderClient client = resolver.acquireUnstableContentProviderClient(uri.getAuthority());
        try {
            IntentSender intentSender = DocumentsContract.createWebLinkIntent(client, uri, options);
            return intentSender;
        }
        catch (Exception e) {
            Log.w("DocumentsContract", "Failed to create a web link intent", e);
            DocumentsContract.rethrowIfNecessary(resolver, e);
            IntentSender intentSender = null;
            return intentSender;
        }
        finally {
            ContentProviderClient.releaseQuietly(client);
        }
    }

    private static final IntentSender $$robo$$android_provider_DocumentsContract$createWebLinkIntent(ContentProviderClient client, Uri uri, Bundle options) throws RemoteException {
        Bundle in = new Bundle();
        in.putParcelable("uri", uri);
        if (options != null) {
            in.putBundle("options", options);
        }
        Bundle out = client.call("android:createWebLinkIntent", null, in);
        return (IntentSender)out.getParcelable("result");
    }

    private static final AssetFileDescriptor $$robo$$android_provider_DocumentsContract$openImageThumbnail(File file) throws FileNotFoundException {
        ParcelFileDescriptor pfd = ParcelFileDescriptor.open(file, 0x10000000);
        Bundle extras = null;
        try {
            ExifInterface exif = new ExifInterface(file.getAbsolutePath());
            switch (exif.getAttributeInt("Orientation", -1)) {
                case 6: {
                    extras = new Bundle(1);
                    extras.putInt("android.provider.extra.ORIENTATION", 90);
                    break;
                }
                case 3: {
                    extras = new Bundle(1);
                    extras.putInt("android.provider.extra.ORIENTATION", 180);
                    break;
                }
                case 8: {
                    extras = new Bundle(1);
                    extras.putInt("android.provider.extra.ORIENTATION", 270);
                }
            }
            long[] thumb = exif.getThumbnailRange();
            if (thumb != null) {
                return new AssetFileDescriptor(pfd, thumb[0], thumb[1], extras);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new AssetFileDescriptor(pfd, 0L, -1L, extras);
    }

    private static final void $$robo$$android_provider_DocumentsContract$rethrowIfNecessary(ContentResolver resolver, Exception e) throws FileNotFoundException {
        if (resolver.getTargetSdkVersion() >= 26) {
            if (e instanceof ParcelableException) {
                ((ParcelableException)e).maybeRethrow(FileNotFoundException.class);
            } else if (e instanceof RemoteException) {
                ((RemoteException)e).rethrowAsRuntimeException();
            } else if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
        }
    }

    private void __constructor__() {
        this.$$robo$$android_provider_DocumentsContract$__constructor__();
    }

    private DocumentsContract() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract$__constructor__(), 0, this);
    }

    public static Uri buildRootsUri(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildRootsUri", $$robo$$android_provider_DocumentsContract$buildRootsUri(java.lang.String ), 0, (String)string2);
    }

    public static Uri buildRootUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildRootUri", $$robo$$android_provider_DocumentsContract$buildRootUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildHomeUri() {
        return InvokeDynamicSupport.bootstrapStatic("buildHomeUri", $$robo$$android_provider_DocumentsContract$buildHomeUri(), 0);
    }

    public static Uri buildRecentDocumentsUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildRecentDocumentsUri", $$robo$$android_provider_DocumentsContract$buildRecentDocumentsUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildTreeDocumentUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildTreeDocumentUri", $$robo$$android_provider_DocumentsContract$buildTreeDocumentUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildDocumentUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildDocumentUri", $$robo$$android_provider_DocumentsContract$buildDocumentUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildDocumentUriUsingTree(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildDocumentUriUsingTree", $$robo$$android_provider_DocumentsContract$buildDocumentUriUsingTree(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static Uri buildDocumentUriMaybeUsingTree(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildDocumentUriMaybeUsingTree", $$robo$$android_provider_DocumentsContract$buildDocumentUriMaybeUsingTree(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static Uri buildChildDocumentsUri(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("buildChildDocumentsUri", $$robo$$android_provider_DocumentsContract$buildChildDocumentsUri(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    public static Uri buildChildDocumentsUriUsingTree(Uri uri, String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildChildDocumentsUriUsingTree", $$robo$$android_provider_DocumentsContract$buildChildDocumentsUriUsingTree(android.net.Uri java.lang.String ), 0, (Uri)uri, (String)string2);
    }

    public static Uri buildSearchDocumentsUri(String string2, String string3, String string4) {
        return InvokeDynamicSupport.bootstrapStatic("buildSearchDocumentsUri", $$robo$$android_provider_DocumentsContract$buildSearchDocumentsUri(java.lang.String java.lang.String java.lang.String ), 0, (String)string2, (String)string3, (String)string4);
    }

    public static boolean isDocumentUri(Context context, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDocumentUri", $$robo$$android_provider_DocumentsContract$isDocumentUri(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    public static boolean isRootUri(Context context, Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isRootUri", $$robo$$android_provider_DocumentsContract$isRootUri(android.content.Context android.net.Uri ), 0, (Context)context, (Uri)uri);
    }

    public static boolean isContentUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isContentUri", $$robo$$android_provider_DocumentsContract$isContentUri(android.net.Uri ), 0, (Uri)uri);
    }

    public static boolean isTreeUri(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isTreeUri", $$robo$$android_provider_DocumentsContract$isTreeUri(android.net.Uri ), 0, (Uri)uri);
    }

    private static boolean isDocumentsProvider(Context context, String string2) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isDocumentsProvider", $$robo$$android_provider_DocumentsContract$isDocumentsProvider(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static String getRootId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getRootId", $$robo$$android_provider_DocumentsContract$getRootId(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getDocumentId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentId", $$robo$$android_provider_DocumentsContract$getDocumentId(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getTreeDocumentId(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getTreeDocumentId", $$robo$$android_provider_DocumentsContract$getTreeDocumentId(android.net.Uri ), 0, (Uri)uri);
    }

    public static String getSearchDocumentsQuery(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("getSearchDocumentsQuery", $$robo$$android_provider_DocumentsContract$getSearchDocumentsQuery(android.net.Uri ), 0, (Uri)uri);
    }

    public static Uri setManageMode(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("setManageMode", $$robo$$android_provider_DocumentsContract$setManageMode(android.net.Uri ), 0, (Uri)uri);
    }

    public static boolean isManageMode(Uri uri) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isManageMode", $$robo$$android_provider_DocumentsContract$isManageMode(android.net.Uri ), 0, (Uri)uri);
    }

    public static Bitmap getDocumentThumbnail(ContentResolver contentResolver, Uri uri, Point point, CancellationSignal cancellationSignal) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentThumbnail", $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(android.content.ContentResolver android.net.Uri android.graphics.Point android.os.CancellationSignal ), 0, (ContentResolver)contentResolver, (Uri)uri, (Point)point, (CancellationSignal)cancellationSignal);
    }

    public static Bitmap getDocumentThumbnail(ContentProviderClient contentProviderClient, Uri uri, Point point, CancellationSignal cancellationSignal) throws RemoteException, IOException {
        return InvokeDynamicSupport.bootstrapStatic("getDocumentThumbnail", $$robo$$android_provider_DocumentsContract$getDocumentThumbnail(android.content.ContentProviderClient android.net.Uri android.graphics.Point android.os.CancellationSignal ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Point)point, (CancellationSignal)cancellationSignal);
    }

    public static Uri createDocument(ContentResolver contentResolver, Uri uri, String string2, String string3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("createDocument", $$robo$$android_provider_DocumentsContract$createDocument(android.content.ContentResolver android.net.Uri java.lang.String java.lang.String ), 0, (ContentResolver)contentResolver, (Uri)uri, (String)string2, (String)string3);
    }

    public static Uri createDocument(ContentProviderClient contentProviderClient, Uri uri, String string2, String string3) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("createDocument", $$robo$$android_provider_DocumentsContract$createDocument(android.content.ContentProviderClient android.net.Uri java.lang.String java.lang.String ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (String)string2, (String)string3);
    }

    public static boolean isChildDocument(ContentProviderClient contentProviderClient, Uri uri, Uri uri2) throws RemoteException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isChildDocument", $$robo$$android_provider_DocumentsContract$isChildDocument(android.content.ContentProviderClient android.net.Uri android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Uri)uri2);
    }

    public static Uri renameDocument(ContentResolver contentResolver, Uri uri, String string2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("renameDocument", $$robo$$android_provider_DocumentsContract$renameDocument(android.content.ContentResolver android.net.Uri java.lang.String ), 0, (ContentResolver)contentResolver, (Uri)uri, (String)string2);
    }

    public static Uri renameDocument(ContentProviderClient contentProviderClient, Uri uri, String string2) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("renameDocument", $$robo$$android_provider_DocumentsContract$renameDocument(android.content.ContentProviderClient android.net.Uri java.lang.String ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (String)string2);
    }

    public static boolean deleteDocument(ContentResolver contentResolver, Uri uri) throws FileNotFoundException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("deleteDocument", $$robo$$android_provider_DocumentsContract$deleteDocument(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
    }

    public static void deleteDocument(ContentProviderClient contentProviderClient, Uri uri) throws RemoteException {
        InvokeDynamicSupport.bootstrapStatic("deleteDocument", $$robo$$android_provider_DocumentsContract$deleteDocument(android.content.ContentProviderClient android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri);
    }

    public static Uri copyDocument(ContentResolver contentResolver, Uri uri, Uri uri2) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("copyDocument", $$robo$$android_provider_DocumentsContract$copyDocument(android.content.ContentResolver android.net.Uri android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri, (Uri)uri2);
    }

    public static Uri copyDocument(ContentProviderClient contentProviderClient, Uri uri, Uri uri2) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("copyDocument", $$robo$$android_provider_DocumentsContract$copyDocument(android.content.ContentProviderClient android.net.Uri android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Uri)uri2);
    }

    public static Uri moveDocument(ContentResolver contentResolver, Uri uri, Uri uri2, Uri uri3) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("moveDocument", $$robo$$android_provider_DocumentsContract$moveDocument(android.content.ContentResolver android.net.Uri android.net.Uri android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri, (Uri)uri2, (Uri)uri3);
    }

    public static Uri moveDocument(ContentProviderClient contentProviderClient, Uri uri, Uri uri2, Uri uri3) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("moveDocument", $$robo$$android_provider_DocumentsContract$moveDocument(android.content.ContentProviderClient android.net.Uri android.net.Uri android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Uri)uri2, (Uri)uri3);
    }

    public static boolean removeDocument(ContentResolver contentResolver, Uri uri, Uri uri2) throws FileNotFoundException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("removeDocument", $$robo$$android_provider_DocumentsContract$removeDocument(android.content.ContentResolver android.net.Uri android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri, (Uri)uri2);
    }

    public static void removeDocument(ContentProviderClient contentProviderClient, Uri uri, Uri uri2) throws RemoteException {
        InvokeDynamicSupport.bootstrapStatic("removeDocument", $$robo$$android_provider_DocumentsContract$removeDocument(android.content.ContentProviderClient android.net.Uri android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Uri)uri2);
    }

    public static void ejectRoot(ContentResolver contentResolver, Uri uri) {
        InvokeDynamicSupport.bootstrapStatic("ejectRoot", $$robo$$android_provider_DocumentsContract$ejectRoot(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
    }

    public static void ejectRoot(ContentProviderClient contentProviderClient, Uri uri) throws RemoteException {
        InvokeDynamicSupport.bootstrapStatic("ejectRoot", $$robo$$android_provider_DocumentsContract$ejectRoot(android.content.ContentProviderClient android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri);
    }

    public static Path findDocumentPath(ContentResolver contentResolver, Uri uri) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("findDocumentPath", $$robo$$android_provider_DocumentsContract$findDocumentPath(android.content.ContentResolver android.net.Uri ), 0, (ContentResolver)contentResolver, (Uri)uri);
    }

    public static Path findDocumentPath(ContentProviderClient contentProviderClient, Uri uri) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("findDocumentPath", $$robo$$android_provider_DocumentsContract$findDocumentPath(android.content.ContentProviderClient android.net.Uri ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri);
    }

    public static IntentSender createWebLinkIntent(ContentResolver contentResolver, Uri uri, Bundle bundle) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("createWebLinkIntent", $$robo$$android_provider_DocumentsContract$createWebLinkIntent(android.content.ContentResolver android.net.Uri android.os.Bundle ), 0, (ContentResolver)contentResolver, (Uri)uri, (Bundle)bundle);
    }

    public static IntentSender createWebLinkIntent(ContentProviderClient contentProviderClient, Uri uri, Bundle bundle) throws RemoteException {
        return InvokeDynamicSupport.bootstrapStatic("createWebLinkIntent", $$robo$$android_provider_DocumentsContract$createWebLinkIntent(android.content.ContentProviderClient android.net.Uri android.os.Bundle ), 0, (ContentProviderClient)contentProviderClient, (Uri)uri, (Bundle)bundle);
    }

    public static AssetFileDescriptor openImageThumbnail(File file) throws FileNotFoundException {
        return InvokeDynamicSupport.bootstrapStatic("openImageThumbnail", $$robo$$android_provider_DocumentsContract$openImageThumbnail(java.io.File ), 0, (File)file);
    }

    private static void rethrowIfNecessary(ContentResolver contentResolver, Exception exception) throws FileNotFoundException {
        InvokeDynamicSupport.bootstrapStatic("rethrowIfNecessary", $$robo$$android_provider_DocumentsContract$rethrowIfNecessary(android.content.ContentResolver java.lang.Exception ), 0, (ContentResolver)contentResolver, (Exception)exception);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DocumentsContract)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Path
    implements Parcelable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private String mRootId;
        private List<String> mPath;
        public static Parcelable.Creator<Path> CREATOR;

        private void $$robo$$android_provider_DocumentsContract_Path$__constructor__(String rootId, List<String> path) {
            Preconditions.checkCollectionNotEmpty(path, "path");
            Preconditions.checkCollectionElementsNotNull(path, "path");
            this.mRootId = rootId;
            this.mPath = path;
        }

        private final String $$robo$$android_provider_DocumentsContract_Path$getRootId() {
            return this.mRootId;
        }

        private final List<String> $$robo$$android_provider_DocumentsContract_Path$getPath() {
            return this.mPath;
        }

        private final boolean $$robo$$android_provider_DocumentsContract_Path$equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Path)) {
                return false;
            }
            Path path = (Path)o;
            return Objects.equals(this.mRootId, path.mRootId) && Objects.equals(this.mPath, path.mPath);
        }

        private final int $$robo$$android_provider_DocumentsContract_Path$hashCode() {
            return Objects.hash(this.mRootId, this.mPath);
        }

        private final String $$robo$$android_provider_DocumentsContract_Path$toString() {
            return "DocumentsContract.Path{" + "rootId=" + this.mRootId + ", path=" + this.mPath + "}";
        }

        private final void $$robo$$android_provider_DocumentsContract_Path$writeToParcel(Parcel dest, int flags) {
            dest.writeString(this.mRootId);
            dest.writeStringList(this.mPath);
        }

        private final int $$robo$$android_provider_DocumentsContract_Path$describeContents() {
            return 0;
        }

        static void __staticInitializer__() {
            CREATOR = new Parcelable.Creator<Path>(){
                public transient /* synthetic */ Object __robo_data__;

                private void $$robo$$android_provider_DocumentsContract_Path_1$__constructor__() {
                }

                private final Path $$robo$$android_provider_DocumentsContract_Path_1$createFromParcel(Parcel in) {
                    String rootId = in.readString();
                    ArrayList<String> path = in.createStringArrayList();
                    return new Path(rootId, path);
                }

                private final Path[] $$robo$$android_provider_DocumentsContract_Path_1$newArray(int size) {
                    return new Path[size];
                }

                private void __constructor__() {
                    this.$$robo$$android_provider_DocumentsContract_Path_1$__constructor__();
                }
                {
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract_Path_1$__constructor__(), 0, this);
                }

                @Override
                public Path createFromParcel(Parcel parcel) {
                    return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_provider_DocumentsContract_Path_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
                }

                public Path[] newArray(int n) {
                    return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_provider_DocumentsContract_Path_1$newArray(int ), 0, this, n);
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }

        private void __constructor__(String string2, List<String> list) {
            this.$$robo$$android_provider_DocumentsContract_Path$__constructor__(string2, list);
        }

        public Path(String string2, List<String> list) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract_Path$__constructor__(java.lang.String java.util.List<java.lang.String> ), 0, this, string2, list);
        }

        public String getRootId() {
            return InvokeDynamicSupport.bootstrap("getRootId", $$robo$$android_provider_DocumentsContract_Path$getRootId(), 0, this);
        }

        public List<String> getPath() {
            return InvokeDynamicSupport.bootstrap("getPath", $$robo$$android_provider_DocumentsContract_Path$getPath(), 0, this);
        }

        public boolean equals(Object object) {
            return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_provider_DocumentsContract_Path$equals(java.lang.Object ), 0, this, object);
        }

        public int hashCode() {
            return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_provider_DocumentsContract_Path$hashCode(), 0, this);
        }

        public String toString() {
            return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_provider_DocumentsContract_Path$toString(), 0, this);
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_provider_DocumentsContract_Path$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
        }

        @Override
        public int describeContents() {
            return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_provider_DocumentsContract_Path$describeContents(), 0, this);
        }

        static {
            RobolectricInternals.classInitializing(Path.class);
        }

        public /* synthetic */ Path() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Path)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Root
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String COLUMN_ROOT_ID = "root_id";
        public static String COLUMN_FLAGS = "flags";
        public static String COLUMN_ICON = "icon";
        public static String COLUMN_TITLE = "title";
        public static String COLUMN_SUMMARY = "summary";
        public static String COLUMN_DOCUMENT_ID = "document_id";
        public static String COLUMN_AVAILABLE_BYTES = "available_bytes";
        public static String COLUMN_CAPACITY_BYTES = "capacity_bytes";
        public static String COLUMN_MIME_TYPES = "mime_types";
        public static String MIME_TYPE_ITEM = "vnd.android.document/root";
        public static int FLAG_SUPPORTS_CREATE = 1;
        public static int FLAG_LOCAL_ONLY = 2;
        public static int FLAG_SUPPORTS_RECENTS = 4;
        public static int FLAG_SUPPORTS_SEARCH = 8;
        public static int FLAG_SUPPORTS_IS_CHILD = 16;
        public static int FLAG_SUPPORTS_EJECT = 32;
        public static int FLAG_EMPTY = 65536;
        public static int FLAG_ADVANCED = 131072;
        public static int FLAG_HAS_SETTINGS = 262144;
        public static int FLAG_REMOVABLE_SD = 524288;
        public static int FLAG_REMOVABLE_USB = 0x100000;

        private void $$robo$$android_provider_DocumentsContract_Root$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_DocumentsContract_Root$__constructor__();
        }

        private Root() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract_Root$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Root)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Document
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public static String COLUMN_DOCUMENT_ID = "document_id";
        public static String COLUMN_MIME_TYPE = "mime_type";
        public static String COLUMN_DISPLAY_NAME = "_display_name";
        public static String COLUMN_SUMMARY = "summary";
        public static String COLUMN_LAST_MODIFIED = "last_modified";
        public static String COLUMN_ICON = "icon";
        public static String COLUMN_FLAGS = "flags";
        public static String COLUMN_SIZE = "_size";
        public static String MIME_TYPE_DIR = "vnd.android.document/directory";
        public static int FLAG_SUPPORTS_THUMBNAIL = 1;
        public static int FLAG_SUPPORTS_WRITE = 2;
        public static int FLAG_SUPPORTS_DELETE = 4;
        public static int FLAG_DIR_SUPPORTS_CREATE = 8;
        public static int FLAG_DIR_PREFERS_GRID = 16;
        public static int FLAG_DIR_PREFERS_LAST_MODIFIED = 32;
        public static int FLAG_SUPPORTS_RENAME = 64;
        public static int FLAG_SUPPORTS_COPY = 128;
        public static int FLAG_SUPPORTS_MOVE = 256;
        public static int FLAG_VIRTUAL_DOCUMENT = 512;
        public static int FLAG_SUPPORTS_REMOVE = 1024;
        public static int FLAG_SUPPORTS_SETTINGS = 2048;
        public static int FLAG_WEB_LINKABLE = 4096;
        public static int FLAG_PARTIAL = 65536;

        private void $$robo$$android_provider_DocumentsContract_Document$__constructor__() {
        }

        private void __constructor__() {
            this.$$robo$$android_provider_DocumentsContract_Document$__constructor__();
        }

        private Document() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_provider_DocumentsContract_Document$__constructor__(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Document)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

