/*
 * Decompiled with CFR 0.152.
 */
package android.printservice;

import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.print.PrintDocumentInfo;
import android.print.PrintJobId;
import android.printservice.IPrintServiceClient;
import android.printservice.PrintService;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrintDocument
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String LOG_TAG = "PrintDocument";
    private PrintJobId mPrintJobId;
    private IPrintServiceClient mPrintServiceClient;
    private PrintDocumentInfo mInfo;

    private void $$robo$$android_printservice_PrintDocument$__constructor__(PrintJobId printJobId, IPrintServiceClient printServiceClient, PrintDocumentInfo info) {
        this.mPrintJobId = printJobId;
        this.mPrintServiceClient = printServiceClient;
        this.mInfo = info;
    }

    private final PrintDocumentInfo $$robo$$android_printservice_PrintDocument$getInfo() {
        PrintService.throwIfNotCalledOnMainThread();
        return this.mInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ParcelFileDescriptor $$robo$$android_printservice_PrintDocument$getData() {
        PrintService.throwIfNotCalledOnMainThread();
        ParcelFileDescriptor source = null;
        ParcelFileDescriptor sink = null;
        try {
            ParcelFileDescriptor[] fds = ParcelFileDescriptor.createPipe();
            source = fds[0];
            sink = fds[1];
            this.mPrintServiceClient.writePrintJobData(sink, this.mPrintJobId);
            ParcelFileDescriptor parcelFileDescriptor = source;
            return parcelFileDescriptor;
        }
        catch (IOException ioe) {
            Log.e("PrintDocument", "Error calling getting print job data!", ioe);
        }
        catch (RemoteException re) {
            Log.e("PrintDocument", "Error calling getting print job data!", re);
        }
        finally {
            if (sink != null) {
                try {
                    sink.close();
                }
                catch (IOException ioe) {}
            }
        }
        return null;
    }

    private void __constructor__(PrintJobId printJobId, IPrintServiceClient iPrintServiceClient, PrintDocumentInfo printDocumentInfo) {
        this.$$robo$$android_printservice_PrintDocument$__constructor__(printJobId, iPrintServiceClient, printDocumentInfo);
    }

    PrintDocument(PrintJobId printJobId, IPrintServiceClient iPrintServiceClient, PrintDocumentInfo printDocumentInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_printservice_PrintDocument$__constructor__(android.print.PrintJobId android.printservice.IPrintServiceClient android.print.PrintDocumentInfo ), 0, this, printJobId, iPrintServiceClient, printDocumentInfo);
    }

    public PrintDocumentInfo getInfo() {
        return InvokeDynamicSupport.bootstrap("getInfo", $$robo$$android_printservice_PrintDocument$getInfo(), 0, this);
    }

    public ParcelFileDescriptor getData() {
        return InvokeDynamicSupport.bootstrap("getData", $$robo$$android_printservice_PrintDocument$getData(), 0, this);
    }

    public /* synthetic */ PrintDocument() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrintDocument)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

