/*
 * Decompiled with CFR 0.152.
 */
package android.print;

import android.os.Parcel;
import android.os.Parcelable;
import android.print.PrintAttributes;
import android.print.PrinterId;
import com.android.internal.util.Preconditions;
import com.google.errorprone.annotations.DoNotMock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.IntConsumer;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PrinterCapabilitiesInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int DEFAULT_UNDEFINED = -1;
    private static int PROPERTY_MEDIA_SIZE = 0;
    private static int PROPERTY_RESOLUTION = 1;
    private static int PROPERTY_COLOR_MODE = 2;
    private static int PROPERTY_DUPLEX_MODE = 3;
    private static int PROPERTY_COUNT = 4;
    private static PrintAttributes.Margins DEFAULT_MARGINS;
    private PrintAttributes.Margins mMinMargins;
    private List<PrintAttributes.MediaSize> mMediaSizes;
    private List<PrintAttributes.Resolution> mResolutions;
    private int mColorModes;
    private int mDuplexModes;
    private int[] mDefaults;
    public static Parcelable.Creator<PrinterCapabilitiesInfo> CREATOR;

    private void $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__() {
        this.mMinMargins = DEFAULT_MARGINS;
        this.mDefaults = new int[4];
        Arrays.fill(this.mDefaults, -1);
    }

    private void $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(PrinterCapabilitiesInfo prototype) {
        this.mMinMargins = DEFAULT_MARGINS;
        this.mDefaults = new int[4];
        this.copyFrom(prototype);
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$copyFrom(PrinterCapabilitiesInfo other) {
        if (this == other) {
            return;
        }
        this.mMinMargins = other.mMinMargins;
        if (other.mMediaSizes != null) {
            if (this.mMediaSizes != null) {
                this.mMediaSizes.clear();
                this.mMediaSizes.addAll(other.mMediaSizes);
            } else {
                this.mMediaSizes = new ArrayList<PrintAttributes.MediaSize>(other.mMediaSizes);
            }
        } else {
            this.mMediaSizes = null;
        }
        if (other.mResolutions != null) {
            if (this.mResolutions != null) {
                this.mResolutions.clear();
                this.mResolutions.addAll(other.mResolutions);
            } else {
                this.mResolutions = new ArrayList<PrintAttributes.Resolution>(other.mResolutions);
            }
        } else {
            this.mResolutions = null;
        }
        this.mColorModes = other.mColorModes;
        this.mDuplexModes = other.mDuplexModes;
        for (int this.mDefaults[i] : other.mDefaults) {
        }
    }

    private final List<PrintAttributes.MediaSize> $$robo$$android_print_PrinterCapabilitiesInfo$getMediaSizes() {
        return Collections.unmodifiableList(this.mMediaSizes);
    }

    private final List<PrintAttributes.Resolution> $$robo$$android_print_PrinterCapabilitiesInfo$getResolutions() {
        return Collections.unmodifiableList(this.mResolutions);
    }

    private final PrintAttributes.Margins $$robo$$android_print_PrinterCapabilitiesInfo$getMinMargins() {
        return this.mMinMargins;
    }

    private final int $$robo$$android_print_PrinterCapabilitiesInfo$getColorModes() {
        return this.mColorModes;
    }

    private final int $$robo$$android_print_PrinterCapabilitiesInfo$getDuplexModes() {
        return this.mDuplexModes;
    }

    private final PrintAttributes $$robo$$android_print_PrinterCapabilitiesInfo$getDefaults() {
        int duplexMode;
        int colorMode;
        int resolutionIndex;
        PrintAttributes.Builder builder = new PrintAttributes.Builder();
        builder.setMinMargins(this.mMinMargins);
        int mediaSizeIndex = this.mDefaults[0];
        if (mediaSizeIndex >= 0) {
            builder.setMediaSize(this.mMediaSizes.get(mediaSizeIndex));
        }
        if ((resolutionIndex = this.mDefaults[1]) >= 0) {
            builder.setResolution(this.mResolutions.get(resolutionIndex));
        }
        if ((colorMode = this.mDefaults[2]) > 0) {
            builder.setColorMode(colorMode);
        }
        if ((duplexMode = this.mDefaults[3]) > 0) {
            builder.setDuplexMode(duplexMode);
        }
        return builder.build();
    }

    private static final void $$robo$$android_print_PrinterCapabilitiesInfo$enforceValidMask(int mask, IntConsumer enforceSingle) {
        int currentMode;
        for (int current = mask; current > 0; current &= ~currentMode) {
            currentMode = 1 << Integer.numberOfTrailingZeros(current);
            enforceSingle.accept(currentMode);
        }
    }

    private void $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(Parcel parcel) {
        this.mMinMargins = DEFAULT_MARGINS;
        this.mDefaults = new int[4];
        this.mMinMargins = Preconditions.checkNotNull(this.readMargins(parcel));
        this.readMediaSizes(parcel);
        this.readResolutions(parcel);
        this.mColorModes = parcel.readInt();
        PrinterCapabilitiesInfo.enforceValidMask(this.mColorModes, currentMode -> PrintAttributes.enforceValidColorMode(currentMode));
        this.mDuplexModes = parcel.readInt();
        PrinterCapabilitiesInfo.enforceValidMask(this.mDuplexModes, currentMode -> PrintAttributes.enforceValidDuplexMode(currentMode));
        this.readDefaults(parcel);
        Preconditions.checkArgument(this.mMediaSizes.size() > this.mDefaults[0]);
        Preconditions.checkArgument(this.mResolutions.size() > this.mDefaults[1]);
    }

    private final int $$robo$$android_print_PrinterCapabilitiesInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$writeToParcel(Parcel parcel, int flags) {
        this.writeMargins(this.mMinMargins, parcel);
        this.writeMediaSizes(parcel);
        this.writeResolutions(parcel);
        parcel.writeInt(this.mColorModes);
        parcel.writeInt(this.mDuplexModes);
        this.writeDefaults(parcel);
    }

    private final int $$robo$$android_print_PrinterCapabilitiesInfo$hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.mMinMargins == null ? 0 : this.mMinMargins.hashCode());
        result = 31 * result + (this.mMediaSizes == null ? 0 : this.mMediaSizes.hashCode());
        result = 31 * result + (this.mResolutions == null ? 0 : this.mResolutions.hashCode());
        result = 31 * result + this.mColorModes;
        result = 31 * result + this.mDuplexModes;
        result = 31 * result + Arrays.hashCode(this.mDefaults);
        return result;
    }

    private final boolean $$robo$$android_print_PrinterCapabilitiesInfo$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PrinterCapabilitiesInfo other = (PrinterCapabilitiesInfo)obj;
        if (this.mMinMargins == null ? other.mMinMargins != null : !this.mMinMargins.equals(other.mMinMargins)) {
            return false;
        }
        if (this.mMediaSizes == null ? other.mMediaSizes != null : !this.mMediaSizes.equals(other.mMediaSizes)) {
            return false;
        }
        if (this.mResolutions == null ? other.mResolutions != null : !this.mResolutions.equals(other.mResolutions)) {
            return false;
        }
        if (this.mColorModes != other.mColorModes) {
            return false;
        }
        if (this.mDuplexModes != other.mDuplexModes) {
            return false;
        }
        return Arrays.equals(this.mDefaults, other.mDefaults);
    }

    private final String $$robo$$android_print_PrinterCapabilitiesInfo$toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PrinterInfo{");
        builder.append("minMargins=").append(this.mMinMargins);
        builder.append(", mediaSizes=").append(this.mMediaSizes);
        builder.append(", resolutions=").append(this.mResolutions);
        builder.append(", colorModes=").append(this.colorModesToString());
        builder.append(", duplexModes=").append(this.duplexModesToString());
        builder.append("\"}");
        return builder.toString();
    }

    private final String $$robo$$android_print_PrinterCapabilitiesInfo$colorModesToString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int colorModes = this.mColorModes;
        while (colorModes != 0) {
            int colorMode = 1 << Integer.numberOfTrailingZeros(colorModes);
            colorModes &= ~colorMode;
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(PrintAttributes.colorModeToString(colorMode));
        }
        builder.append(']');
        return builder.toString();
    }

    private final String $$robo$$android_print_PrinterCapabilitiesInfo$duplexModesToString() {
        StringBuilder builder = new StringBuilder();
        builder.append('[');
        int duplexModes = this.mDuplexModes;
        while (duplexModes != 0) {
            int duplexMode = 1 << Integer.numberOfTrailingZeros(duplexModes);
            duplexModes &= ~duplexMode;
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(PrintAttributes.duplexModeToString(duplexMode));
        }
        builder.append(']');
        return builder.toString();
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$writeMediaSizes(Parcel parcel) {
        if (this.mMediaSizes == null) {
            parcel.writeInt(0);
            return;
        }
        int mediaSizeCount = this.mMediaSizes.size();
        parcel.writeInt(mediaSizeCount);
        for (int i = 0; i < mediaSizeCount; ++i) {
            this.mMediaSizes.get(i).writeToParcel(parcel);
        }
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$readMediaSizes(Parcel parcel) {
        int mediaSizeCount = parcel.readInt();
        if (mediaSizeCount > 0 && this.mMediaSizes == null) {
            this.mMediaSizes = new ArrayList<PrintAttributes.MediaSize>();
        }
        for (int i = 0; i < mediaSizeCount; ++i) {
            this.mMediaSizes.add(PrintAttributes.MediaSize.createFromParcel(parcel));
        }
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$writeResolutions(Parcel parcel) {
        if (this.mResolutions == null) {
            parcel.writeInt(0);
            return;
        }
        int resolutionCount = this.mResolutions.size();
        parcel.writeInt(resolutionCount);
        for (int i = 0; i < resolutionCount; ++i) {
            this.mResolutions.get(i).writeToParcel(parcel);
        }
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$readResolutions(Parcel parcel) {
        int resolutionCount = parcel.readInt();
        if (resolutionCount > 0 && this.mResolutions == null) {
            this.mResolutions = new ArrayList<PrintAttributes.Resolution>();
        }
        for (int i = 0; i < resolutionCount; ++i) {
            this.mResolutions.add(PrintAttributes.Resolution.createFromParcel(parcel));
        }
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$writeMargins(PrintAttributes.Margins margins, Parcel parcel) {
        if (margins == null) {
            parcel.writeInt(0);
        } else {
            parcel.writeInt(1);
            margins.writeToParcel(parcel);
        }
    }

    private final PrintAttributes.Margins $$robo$$android_print_PrinterCapabilitiesInfo$readMargins(Parcel parcel) {
        return parcel.readInt() == 1 ? PrintAttributes.Margins.createFromParcel(parcel) : null;
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$readDefaults(Parcel parcel) {
        int defaultCount = parcel.readInt();
        for (int i = 0; i < defaultCount; ++i) {
            this.mDefaults[i] = parcel.readInt();
        }
    }

    private final void $$robo$$android_print_PrinterCapabilitiesInfo$writeDefaults(Parcel parcel) {
        int defaultCount = this.mDefaults.length;
        parcel.writeInt(defaultCount);
        for (int i = 0; i < defaultCount; ++i) {
            parcel.writeInt(this.mDefaults[i]);
        }
    }

    private /* synthetic */ void $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        DEFAULT_MARGINS = new PrintAttributes.Margins(0, 0, 0, 0);
        CREATOR = new Parcelable.Creator<PrinterCapabilitiesInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_print_PrinterCapabilitiesInfo_1$__constructor__() {
            }

            private final PrinterCapabilitiesInfo $$robo$$android_print_PrinterCapabilitiesInfo_1$createFromParcel(Parcel parcel) {
                return new PrinterCapabilitiesInfo(parcel);
            }

            private final PrinterCapabilitiesInfo[] $$robo$$android_print_PrinterCapabilitiesInfo_1$newArray(int size) {
                return new PrinterCapabilitiesInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_print_PrinterCapabilitiesInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterCapabilitiesInfo_1$__constructor__(), 0, this);
            }

            @Override
            public PrinterCapabilitiesInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_print_PrinterCapabilitiesInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public PrinterCapabilitiesInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_print_PrinterCapabilitiesInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__() {
        this.$$robo$$android_print_PrinterCapabilitiesInfo$__constructor__();
    }

    public PrinterCapabilitiesInfo() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(), 0, this);
    }

    private void __constructor__(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
        this.$$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(printerCapabilitiesInfo);
    }

    public PrinterCapabilitiesInfo(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(android.print.PrinterCapabilitiesInfo ), 0, this, printerCapabilitiesInfo);
    }

    public void copyFrom(PrinterCapabilitiesInfo printerCapabilitiesInfo) {
        InvokeDynamicSupport.bootstrap("copyFrom", $$robo$$android_print_PrinterCapabilitiesInfo$copyFrom(android.print.PrinterCapabilitiesInfo ), 0, this, printerCapabilitiesInfo);
    }

    public List<PrintAttributes.MediaSize> getMediaSizes() {
        return InvokeDynamicSupport.bootstrap("getMediaSizes", $$robo$$android_print_PrinterCapabilitiesInfo$getMediaSizes(), 0, this);
    }

    public List<PrintAttributes.Resolution> getResolutions() {
        return InvokeDynamicSupport.bootstrap("getResolutions", $$robo$$android_print_PrinterCapabilitiesInfo$getResolutions(), 0, this);
    }

    public PrintAttributes.Margins getMinMargins() {
        return InvokeDynamicSupport.bootstrap("getMinMargins", $$robo$$android_print_PrinterCapabilitiesInfo$getMinMargins(), 0, this);
    }

    public int getColorModes() {
        return (int)InvokeDynamicSupport.bootstrap("getColorModes", $$robo$$android_print_PrinterCapabilitiesInfo$getColorModes(), 0, this);
    }

    public int getDuplexModes() {
        return (int)InvokeDynamicSupport.bootstrap("getDuplexModes", $$robo$$android_print_PrinterCapabilitiesInfo$getDuplexModes(), 0, this);
    }

    public PrintAttributes getDefaults() {
        return InvokeDynamicSupport.bootstrap("getDefaults", $$robo$$android_print_PrinterCapabilitiesInfo$getDefaults(), 0, this);
    }

    private static void enforceValidMask(int n, IntConsumer intConsumer) {
        InvokeDynamicSupport.bootstrapStatic("enforceValidMask", $$robo$$android_print_PrinterCapabilitiesInfo$enforceValidMask(int java.util.function.IntConsumer ), 0, (int)n, (IntConsumer)intConsumer);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(parcel);
    }

    private PrinterCapabilitiesInfo(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_print_PrinterCapabilitiesInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_print_PrinterCapabilitiesInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_print_PrinterCapabilitiesInfo$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_print_PrinterCapabilitiesInfo$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_print_PrinterCapabilitiesInfo$toString(), 0, this);
    }

    private String colorModesToString() {
        return InvokeDynamicSupport.bootstrap("colorModesToString", $$robo$$android_print_PrinterCapabilitiesInfo$colorModesToString(), 0, this);
    }

    private String duplexModesToString() {
        return InvokeDynamicSupport.bootstrap("duplexModesToString", $$robo$$android_print_PrinterCapabilitiesInfo$duplexModesToString(), 0, this);
    }

    private void writeMediaSizes(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeMediaSizes", $$robo$$android_print_PrinterCapabilitiesInfo$writeMediaSizes(android.os.Parcel ), 0, this, parcel);
    }

    private void readMediaSizes(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readMediaSizes", $$robo$$android_print_PrinterCapabilitiesInfo$readMediaSizes(android.os.Parcel ), 0, this, parcel);
    }

    private void writeResolutions(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeResolutions", $$robo$$android_print_PrinterCapabilitiesInfo$writeResolutions(android.os.Parcel ), 0, this, parcel);
    }

    private void readResolutions(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readResolutions", $$robo$$android_print_PrinterCapabilitiesInfo$readResolutions(android.os.Parcel ), 0, this, parcel);
    }

    private void writeMargins(PrintAttributes.Margins margins, Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeMargins", $$robo$$android_print_PrinterCapabilitiesInfo$writeMargins(android.print.PrintAttributes$Margins android.os.Parcel ), 0, this, margins, parcel);
    }

    private PrintAttributes.Margins readMargins(Parcel parcel) {
        return InvokeDynamicSupport.bootstrap("readMargins", $$robo$$android_print_PrinterCapabilitiesInfo$readMargins(android.os.Parcel ), 0, this, parcel);
    }

    private void readDefaults(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("readDefaults", $$robo$$android_print_PrinterCapabilitiesInfo$readDefaults(android.os.Parcel ), 0, this, parcel);
    }

    private void writeDefaults(Parcel parcel) {
        InvokeDynamicSupport.bootstrap("writeDefaults", $$robo$$android_print_PrinterCapabilitiesInfo$writeDefaults(android.os.Parcel ), 0, this, parcel);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_print_PrinterCapabilitiesInfo$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(PrinterCapabilitiesInfo.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PrinterCapabilitiesInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private PrinterCapabilitiesInfo mPrototype;

        private void $$robo$$android_print_PrinterCapabilitiesInfo_Builder$__constructor__(PrinterId printerId) {
            if (printerId == null) {
                throw new IllegalArgumentException("printerId cannot be null.");
            }
            this.mPrototype = new PrinterCapabilitiesInfo();
        }

        private final Builder $$robo$$android_print_PrinterCapabilitiesInfo_Builder$addMediaSize(PrintAttributes.MediaSize mediaSize, boolean isDefault) {
            if (this.mPrototype.mMediaSizes == null) {
                this.mPrototype.mMediaSizes = new ArrayList();
            }
            int insertionIndex = this.mPrototype.mMediaSizes.size();
            this.mPrototype.mMediaSizes.add(mediaSize);
            if (isDefault) {
                this.throwIfDefaultAlreadySpecified(0);
                ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[0] = insertionIndex;
            }
            return this;
        }

        private final Builder $$robo$$android_print_PrinterCapabilitiesInfo_Builder$addResolution(PrintAttributes.Resolution resolution, boolean isDefault) {
            if (this.mPrototype.mResolutions == null) {
                this.mPrototype.mResolutions = new ArrayList();
            }
            int insertionIndex = this.mPrototype.mResolutions.size();
            this.mPrototype.mResolutions.add(resolution);
            if (isDefault) {
                this.throwIfDefaultAlreadySpecified(1);
                ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[1] = insertionIndex;
            }
            return this;
        }

        private final Builder $$robo$$android_print_PrinterCapabilitiesInfo_Builder$setMinMargins(PrintAttributes.Margins margins) {
            if (margins == null) {
                throw new IllegalArgumentException("margins cannot be null");
            }
            this.mPrototype.mMinMargins = margins;
            return this;
        }

        private final Builder $$robo$$android_print_PrinterCapabilitiesInfo_Builder$setColorModes(int colorModes, int defaultColorMode) {
            PrinterCapabilitiesInfo.enforceValidMask(colorModes, currentMode -> PrintAttributes.enforceValidColorMode(currentMode));
            PrintAttributes.enforceValidColorMode(defaultColorMode);
            this.mPrototype.mColorModes = colorModes;
            ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[2] = defaultColorMode;
            return this;
        }

        private final Builder $$robo$$android_print_PrinterCapabilitiesInfo_Builder$setDuplexModes(int duplexModes, int defaultDuplexMode) {
            PrinterCapabilitiesInfo.enforceValidMask(duplexModes, currentMode -> PrintAttributes.enforceValidDuplexMode(currentMode));
            PrintAttributes.enforceValidDuplexMode(defaultDuplexMode);
            this.mPrototype.mDuplexModes = duplexModes;
            ((PrinterCapabilitiesInfo)this.mPrototype).mDefaults[3] = defaultDuplexMode;
            return this;
        }

        private final PrinterCapabilitiesInfo $$robo$$android_print_PrinterCapabilitiesInfo_Builder$build() {
            if (this.mPrototype.mMediaSizes == null || this.mPrototype.mMediaSizes.isEmpty()) {
                throw new IllegalStateException("No media size specified.");
            }
            if (this.mPrototype.mDefaults[0] == -1) {
                throw new IllegalStateException("No default media size specified.");
            }
            if (this.mPrototype.mResolutions == null || this.mPrototype.mResolutions.isEmpty()) {
                throw new IllegalStateException("No resolution specified.");
            }
            if (this.mPrototype.mDefaults[1] == -1) {
                throw new IllegalStateException("No default resolution specified.");
            }
            if (this.mPrototype.mColorModes == 0) {
                throw new IllegalStateException("No color mode specified.");
            }
            if (this.mPrototype.mDefaults[2] == -1) {
                throw new IllegalStateException("No default color mode specified.");
            }
            if (this.mPrototype.mDuplexModes == 0) {
                this.setDuplexModes(1, 1);
            }
            if (this.mPrototype.mMinMargins == null) {
                throw new IllegalArgumentException("margins cannot be null");
            }
            return this.mPrototype;
        }

        private final void $$robo$$android_print_PrinterCapabilitiesInfo_Builder$throwIfDefaultAlreadySpecified(int propertyIndex) {
            if (this.mPrototype.mDefaults[propertyIndex] != -1) {
                throw new IllegalArgumentException("Default already specified.");
            }
        }

        private void __constructor__(PrinterId printerId) {
            this.$$robo$$android_print_PrinterCapabilitiesInfo_Builder$__constructor__(printerId);
        }

        public Builder(PrinterId printerId) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$__constructor__(android.print.PrinterId ), 0, this, printerId);
        }

        public Builder addMediaSize(PrintAttributes.MediaSize mediaSize, boolean bl) {
            return InvokeDynamicSupport.bootstrap("addMediaSize", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$addMediaSize(android.print.PrintAttributes$MediaSize boolean ), 0, this, mediaSize, bl);
        }

        public Builder addResolution(PrintAttributes.Resolution resolution, boolean bl) {
            return InvokeDynamicSupport.bootstrap("addResolution", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$addResolution(android.print.PrintAttributes$Resolution boolean ), 0, this, resolution, bl);
        }

        public Builder setMinMargins(PrintAttributes.Margins margins) {
            return InvokeDynamicSupport.bootstrap("setMinMargins", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$setMinMargins(android.print.PrintAttributes$Margins ), 0, this, margins);
        }

        public Builder setColorModes(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setColorModes", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$setColorModes(int int ), 0, this, n, n2);
        }

        public Builder setDuplexModes(int n, int n2) {
            return InvokeDynamicSupport.bootstrap("setDuplexModes", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$setDuplexModes(int int ), 0, this, n, n2);
        }

        public PrinterCapabilitiesInfo build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$build(), 0, this);
        }

        private void throwIfDefaultAlreadySpecified(int n) {
            InvokeDynamicSupport.bootstrap("throwIfDefaultAlreadySpecified", $$robo$$android_print_PrinterCapabilitiesInfo_Builder$throwIfDefaultAlreadySpecified(int ), 0, this, n);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

