/*
 * Decompiled with CFR 0.152.
 */
package android.preference;

import android.app.NotificationManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.ContentObserver;
import android.media.AudioAttributes;
import android.media.AudioManager;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.Message;
import android.preference.VolumePreference;
import android.provider.Settings;
import android.util.Log;
import android.widget.SeekBar;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class SeekBarVolumizer
implements SeekBar.OnSeekBarChangeListener,
Handler.Callback,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "SeekBarVolumizer";
    private Context mContext;
    private H mUiHandler;
    private Callback mCallback;
    private Uri mDefaultUri;
    private AudioManager mAudioManager;
    private NotificationManager mNotificationManager;
    private int mStreamType;
    private int mMaxStreamVolume;
    private boolean mAffectedByRingerMode;
    private boolean mNotificationOrRing;
    private Receiver mReceiver;
    private Handler mHandler;
    private Observer mVolumeObserver;
    private int mOriginalStreamVolume;
    private int mLastAudibleStreamVolume;
    @GuardedBy(value="this")
    private Ringtone mRingtone;
    private int mLastProgress;
    private boolean mMuted;
    private SeekBar mSeekBar;
    private int mVolumeBeforeMute;
    private int mRingerMode;
    private int mZenMode;
    private static int MSG_SET_STREAM_VOLUME = 0;
    private static int MSG_START_SAMPLE = 1;
    private static int MSG_STOP_SAMPLE = 2;
    private static int MSG_INIT_SAMPLE = 3;
    private static int CHECK_RINGTONE_PLAYBACK_DELAY_MS = 1000;

    private void $$robo$$android_preference_SeekBarVolumizer$__constructor__(Context context, int streamType, Uri defaultUri, Callback callback) {
        this.mUiHandler = new H(this);
        this.mReceiver = new Receiver(this);
        this.mLastProgress = -1;
        this.mVolumeBeforeMute = -1;
        this.mContext = context;
        this.mAudioManager = context.getSystemService(AudioManager.class);
        this.mNotificationManager = context.getSystemService(NotificationManager.class);
        this.mStreamType = streamType;
        this.mAffectedByRingerMode = this.mAudioManager.isStreamAffectedByRingerMode(this.mStreamType);
        this.mNotificationOrRing = SeekBarVolumizer.isNotificationOrRing(this.mStreamType);
        if (this.mNotificationOrRing) {
            this.mRingerMode = this.mAudioManager.getRingerModeInternal();
        }
        this.mZenMode = this.mNotificationManager.getZenMode();
        this.mMaxStreamVolume = this.mAudioManager.getStreamMaxVolume(this.mStreamType);
        this.mCallback = callback;
        this.mOriginalStreamVolume = this.mAudioManager.getStreamVolume(this.mStreamType);
        this.mLastAudibleStreamVolume = this.mAudioManager.getLastAudibleStreamVolume(this.mStreamType);
        this.mMuted = this.mAudioManager.isStreamMute(this.mStreamType);
        if (this.mCallback != null) {
            this.mCallback.onMuted(this.mMuted, this.isZenMuted());
        }
        if (defaultUri == null) {
            defaultUri = this.mStreamType == 2 ? Settings.System.DEFAULT_RINGTONE_URI : (this.mStreamType == 5 ? Settings.System.DEFAULT_NOTIFICATION_URI : Settings.System.DEFAULT_ALARM_ALERT_URI);
        }
        this.mDefaultUri = defaultUri;
    }

    private static final boolean $$robo$$android_preference_SeekBarVolumizer$isNotificationOrRing(int stream) {
        return stream == 2 || stream == 5;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$setSeekBar(SeekBar seekBar) {
        if (this.mSeekBar != null) {
            this.mSeekBar.setOnSeekBarChangeListener(null);
        }
        this.mSeekBar = seekBar;
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mSeekBar.setMax(this.mMaxStreamVolume);
        this.updateSeekBar();
        this.mSeekBar.setOnSeekBarChangeListener(this);
    }

    private final boolean $$robo$$android_preference_SeekBarVolumizer$isZenMuted() {
        return this.mNotificationOrRing && this.mZenMode == 3 || this.mZenMode == 2;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$updateSeekBar() {
        boolean zenMuted = this.isZenMuted();
        this.mSeekBar.setEnabled(!zenMuted);
        if (zenMuted) {
            this.mSeekBar.setProgress(this.mLastAudibleStreamVolume, true);
        } else if (this.mNotificationOrRing && this.mRingerMode == 1) {
            this.mSeekBar.setProgress(0, true);
        } else if (this.mMuted) {
            this.mSeekBar.setProgress(0, true);
        } else {
            this.mSeekBar.setProgress(this.mLastProgress > -1 ? this.mLastProgress : this.mOriginalStreamVolume, true);
        }
    }

    private final boolean $$robo$$android_preference_SeekBarVolumizer$handleMessage(Message msg) {
        switch (msg.what) {
            case 0: {
                if (this.mMuted && this.mLastProgress > 0) {
                    this.mAudioManager.adjustStreamVolume(this.mStreamType, 100, 0);
                } else if (!this.mMuted && this.mLastProgress == 0) {
                    this.mAudioManager.adjustStreamVolume(this.mStreamType, -100, 0);
                }
                this.mAudioManager.setStreamVolume(this.mStreamType, this.mLastProgress, 1024);
                break;
            }
            case 1: {
                this.onStartSample();
                break;
            }
            case 2: {
                this.onStopSample();
                break;
            }
            case 3: {
                this.onInitSample();
                break;
            }
            default: {
                Log.e("SeekBarVolumizer", "invalid SeekBarVolumizer message: " + msg.what);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_SeekBarVolumizer$onInitSample() {
        SeekBarVolumizer seekBarVolumizer = this;
        synchronized (seekBarVolumizer) {
            this.mRingtone = RingtoneManager.getRingtone(this.mContext, this.mDefaultUri);
            if (this.mRingtone != null) {
                this.mRingtone.setStreamType(this.mStreamType);
            }
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$postStartSample() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), this.isSamplePlaying() ? 1000L : 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_SeekBarVolumizer$onStartSample() {
        if (!this.isSamplePlaying()) {
            if (this.mCallback != null) {
                this.mCallback.onSampleStarting(this);
            }
            SeekBarVolumizer seekBarVolumizer = this;
            synchronized (seekBarVolumizer) {
                if (this.mRingtone != null) {
                    try {
                        this.mRingtone.setAudioAttributes(new AudioAttributes.Builder(this.mRingtone.getAudioAttributes()).setFlags(192).build());
                        this.mRingtone.play();
                    }
                    catch (Throwable e) {
                        Log.w("SeekBarVolumizer", "Error playing ringtone, stream " + this.mStreamType, e);
                    }
                }
            }
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$postStopSample() {
        if (this.mHandler == null) {
            return;
        }
        this.mHandler.removeMessages(1);
        this.mHandler.removeMessages(2);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_preference_SeekBarVolumizer$onStopSample() {
        SeekBarVolumizer seekBarVolumizer = this;
        synchronized (seekBarVolumizer) {
            if (this.mRingtone != null) {
                this.mRingtone.stop();
            }
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$stop() {
        if (this.mHandler == null) {
            return;
        }
        this.postStopSample();
        this.mContext.getContentResolver().unregisterContentObserver(this.mVolumeObserver);
        this.mReceiver.setListening(false);
        this.mSeekBar.setOnSeekBarChangeListener(null);
        this.mHandler.getLooper().quitSafely();
        this.mHandler = null;
        this.mVolumeObserver = null;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$start() {
        if (this.mHandler != null) {
            return;
        }
        HandlerThread thread = new HandlerThread("SeekBarVolumizer.CallbackHandler");
        thread.start();
        this.mHandler = new Handler(thread.getLooper(), this);
        this.mHandler.sendEmptyMessage(3);
        this.mVolumeObserver = new Observer(this, this.mHandler);
        this.mContext.getContentResolver().registerContentObserver(Settings.System.getUriFor(Settings.System.VOLUME_SETTINGS[this.mStreamType]), false, this.mVolumeObserver);
        this.mReceiver.setListening(true);
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$revertVolume() {
        this.mAudioManager.setStreamVolume(this.mStreamType, this.mOriginalStreamVolume, 0);
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onProgressChanged(SeekBar seekBar, int progress, boolean fromTouch) {
        if (fromTouch) {
            this.postSetVolume(progress);
        }
        if (this.mCallback != null) {
            this.mCallback.onProgressChanged(seekBar, progress, fromTouch);
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$postSetVolume(int progress) {
        if (this.mHandler == null) {
            return;
        }
        this.mLastProgress = progress;
        this.mHandler.removeMessages(0);
        this.mHandler.sendMessage(this.mHandler.obtainMessage(0));
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onStartTrackingTouch(SeekBar seekBar) {
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onStopTrackingTouch(SeekBar seekBar) {
        this.postStartSample();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_preference_SeekBarVolumizer$isSamplePlaying() {
        SeekBarVolumizer seekBarVolumizer = this;
        synchronized (seekBarVolumizer) {
            return this.mRingtone != null && this.mRingtone.isPlaying();
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$startSample() {
        this.postStartSample();
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$stopSample() {
        this.postStopSample();
    }

    private final SeekBar $$robo$$android_preference_SeekBarVolumizer$getSeekBar() {
        return this.mSeekBar;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$changeVolumeBy(int amount) {
        this.mSeekBar.incrementProgressBy(amount);
        this.postSetVolume(this.mSeekBar.getProgress());
        this.postStartSample();
        this.mVolumeBeforeMute = -1;
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$muteVolume() {
        if (this.mVolumeBeforeMute != -1) {
            this.mSeekBar.setProgress(this.mVolumeBeforeMute, true);
            this.postSetVolume(this.mVolumeBeforeMute);
            this.postStartSample();
            this.mVolumeBeforeMute = -1;
        } else {
            this.mVolumeBeforeMute = this.mSeekBar.getProgress();
            this.mSeekBar.setProgress(0, true);
            this.postStopSample();
            this.postSetVolume(0);
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onSaveInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (this.mLastProgress >= 0) {
            volumeStore.volume = this.mLastProgress;
            volumeStore.originalVolume = this.mOriginalStreamVolume;
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$onRestoreInstanceState(VolumePreference.VolumeStore volumeStore) {
        if (volumeStore.volume != -1) {
            this.mOriginalStreamVolume = volumeStore.originalVolume;
            this.mLastProgress = volumeStore.volume;
            this.postSetVolume(this.mLastProgress);
        }
    }

    private final void $$robo$$android_preference_SeekBarVolumizer$updateSlider() {
        if (this.mSeekBar != null && this.mAudioManager != null) {
            int volume = this.mAudioManager.getStreamVolume(this.mStreamType);
            int lastAudibleVolume = this.mAudioManager.getLastAudibleStreamVolume(this.mStreamType);
            boolean mute = this.mAudioManager.isStreamMute(this.mStreamType);
            this.mUiHandler.postUpdateSlider(volume, lastAudibleVolume, mute);
        }
    }

    private void __constructor__(Context context, int n, Uri uri, Callback callback) {
        this.$$robo$$android_preference_SeekBarVolumizer$__constructor__(context, n, uri, callback);
    }

    public SeekBarVolumizer(Context context, int n, Uri uri, Callback callback) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer$__constructor__(android.content.Context int android.net.Uri android.preference.SeekBarVolumizer$Callback ), 0, this, context, n, uri, callback);
    }

    private static boolean isNotificationOrRing(int n) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("isNotificationOrRing", $$robo$$android_preference_SeekBarVolumizer$isNotificationOrRing(int ), 0, (int)n);
    }

    public void setSeekBar(SeekBar seekBar) {
        InvokeDynamicSupport.bootstrap("setSeekBar", $$robo$$android_preference_SeekBarVolumizer$setSeekBar(android.widget.SeekBar ), 0, this, seekBar);
    }

    private boolean isZenMuted() {
        return (boolean)InvokeDynamicSupport.bootstrap("isZenMuted", $$robo$$android_preference_SeekBarVolumizer$isZenMuted(), 0, this);
    }

    protected void updateSeekBar() {
        InvokeDynamicSupport.bootstrap("updateSeekBar", $$robo$$android_preference_SeekBarVolumizer$updateSeekBar(), 0, this);
    }

    @Override
    public boolean handleMessage(Message message) {
        return (boolean)InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_preference_SeekBarVolumizer$handleMessage(android.os.Message ), 0, this, message);
    }

    private void onInitSample() {
        InvokeDynamicSupport.bootstrap("onInitSample", $$robo$$android_preference_SeekBarVolumizer$onInitSample(), 0, this);
    }

    private void postStartSample() {
        InvokeDynamicSupport.bootstrap("postStartSample", $$robo$$android_preference_SeekBarVolumizer$postStartSample(), 0, this);
    }

    private void onStartSample() {
        InvokeDynamicSupport.bootstrap("onStartSample", $$robo$$android_preference_SeekBarVolumizer$onStartSample(), 0, this);
    }

    private void postStopSample() {
        InvokeDynamicSupport.bootstrap("postStopSample", $$robo$$android_preference_SeekBarVolumizer$postStopSample(), 0, this);
    }

    private void onStopSample() {
        InvokeDynamicSupport.bootstrap("onStopSample", $$robo$$android_preference_SeekBarVolumizer$onStopSample(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_preference_SeekBarVolumizer$stop(), 0, this);
    }

    public void start() {
        InvokeDynamicSupport.bootstrap("start", $$robo$$android_preference_SeekBarVolumizer$start(), 0, this);
    }

    public void revertVolume() {
        InvokeDynamicSupport.bootstrap("revertVolume", $$robo$$android_preference_SeekBarVolumizer$revertVolume(), 0, this);
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int n, boolean bl) {
        InvokeDynamicSupport.bootstrap("onProgressChanged", $$robo$$android_preference_SeekBarVolumizer$onProgressChanged(android.widget.SeekBar int boolean ), 0, this, seekBar, n, bl);
    }

    private void postSetVolume(int n) {
        InvokeDynamicSupport.bootstrap("postSetVolume", $$robo$$android_preference_SeekBarVolumizer$postSetVolume(int ), 0, this, n);
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {
        InvokeDynamicSupport.bootstrap("onStartTrackingTouch", $$robo$$android_preference_SeekBarVolumizer$onStartTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {
        InvokeDynamicSupport.bootstrap("onStopTrackingTouch", $$robo$$android_preference_SeekBarVolumizer$onStopTrackingTouch(android.widget.SeekBar ), 0, this, seekBar);
    }

    public boolean isSamplePlaying() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSamplePlaying", $$robo$$android_preference_SeekBarVolumizer$isSamplePlaying(), 0, this);
    }

    public void startSample() {
        InvokeDynamicSupport.bootstrap("startSample", $$robo$$android_preference_SeekBarVolumizer$startSample(), 0, this);
    }

    public void stopSample() {
        InvokeDynamicSupport.bootstrap("stopSample", $$robo$$android_preference_SeekBarVolumizer$stopSample(), 0, this);
    }

    public SeekBar getSeekBar() {
        return InvokeDynamicSupport.bootstrap("getSeekBar", $$robo$$android_preference_SeekBarVolumizer$getSeekBar(), 0, this);
    }

    public void changeVolumeBy(int n) {
        InvokeDynamicSupport.bootstrap("changeVolumeBy", $$robo$$android_preference_SeekBarVolumizer$changeVolumeBy(int ), 0, this, n);
    }

    public void muteVolume() {
        InvokeDynamicSupport.bootstrap("muteVolume", $$robo$$android_preference_SeekBarVolumizer$muteVolume(), 0, this);
    }

    public void onSaveInstanceState(VolumePreference.VolumeStore volumeStore) {
        InvokeDynamicSupport.bootstrap("onSaveInstanceState", $$robo$$android_preference_SeekBarVolumizer$onSaveInstanceState(android.preference.VolumePreference$VolumeStore ), 0, this, volumeStore);
    }

    public void onRestoreInstanceState(VolumePreference.VolumeStore volumeStore) {
        InvokeDynamicSupport.bootstrap("onRestoreInstanceState", $$robo$$android_preference_SeekBarVolumizer$onRestoreInstanceState(android.preference.VolumePreference$VolumeStore ), 0, this, volumeStore);
    }

    private void updateSlider() {
        InvokeDynamicSupport.bootstrap("updateSlider", $$robo$$android_preference_SeekBarVolumizer$updateSlider(), 0, this);
    }

    public /* synthetic */ SeekBarVolumizer() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (SeekBarVolumizer)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class Receiver
    extends BroadcastReceiver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private boolean mListening;
        /* synthetic */ SeekBarVolumizer this$0;

        private void $$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(SeekBarVolumizer seekBarVolumizer) {
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Receiver$setListening(boolean listening) {
            if (this.mListening == listening) {
                return;
            }
            this.mListening = listening;
            if (listening) {
                IntentFilter filter = new IntentFilter("android.media.VOLUME_CHANGED_ACTION");
                filter.addAction("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION");
                filter.addAction("android.app.action.INTERRUPTION_FILTER_CHANGED");
                filter.addAction("android.media.STREAM_DEVICES_CHANGED_ACTION");
                this.this$0.mContext.registerReceiver(this, filter);
            } else {
                this.this$0.mContext.unregisterReceiver(this);
            }
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Receiver$onReceive(Context context, Intent intent) {
            String action = intent.getAction();
            if ("android.media.VOLUME_CHANGED_ACTION".equals(action)) {
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                int streamValue = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_VALUE", -1);
                this.updateVolumeSlider(streamType, streamValue);
            } else if ("android.media.INTERNAL_RINGER_MODE_CHANGED_ACTION".equals(action)) {
                if (this.this$0.mNotificationOrRing) {
                    this.this$0.mRingerMode = this.this$0.mAudioManager.getRingerModeInternal();
                }
                if (this.this$0.mAffectedByRingerMode) {
                    this.this$0.updateSlider();
                }
            } else if ("android.media.STREAM_DEVICES_CHANGED_ACTION".equals(action)) {
                int streamType = intent.getIntExtra("android.media.EXTRA_VOLUME_STREAM_TYPE", -1);
                int streamVolume = this.this$0.mAudioManager.getStreamVolume(streamType);
                this.updateVolumeSlider(streamType, streamVolume);
            } else if ("android.app.action.INTERRUPTION_FILTER_CHANGED".equals(action)) {
                this.this$0.mZenMode = this.this$0.mNotificationManager.getZenMode();
                this.this$0.updateSlider();
            }
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Receiver$updateVolumeSlider(int streamType, int streamValue) {
            boolean streamMatch;
            boolean bl = this.this$0.mNotificationOrRing ? SeekBarVolumizer.isNotificationOrRing(streamType) : (streamMatch = streamType == this.this$0.mStreamType);
            if (this.this$0.mSeekBar != null && streamMatch && streamValue != -1) {
                boolean muted = this.this$0.mAudioManager.isStreamMute(this.this$0.mStreamType) || streamValue == 0;
                this.this$0.mUiHandler.postUpdateSlider(streamValue, this.this$0.mLastAudibleStreamVolume, muted);
            }
        }

        private /* synthetic */ void $$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(SeekBarVolumizer x0, 1 x1) {
        }

        private void __constructor__(SeekBarVolumizer seekBarVolumizer) {
            this.$$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(seekBarVolumizer);
        }

        private Receiver(SeekBarVolumizer seekBarVolumizer) {
            this.this$0 = seekBarVolumizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(android.preference.SeekBarVolumizer ), 0, this, seekBarVolumizer);
        }

        public void setListening(boolean bl) {
            InvokeDynamicSupport.bootstrap("setListening", $$robo$$android_preference_SeekBarVolumizer_Receiver$setListening(boolean ), 0, this, bl);
        }

        @Override
        public void onReceive(Context context, Intent intent) {
            InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_preference_SeekBarVolumizer_Receiver$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
        }

        private void updateVolumeSlider(int n, int n2) {
            InvokeDynamicSupport.bootstrap("updateVolumeSlider", $$robo$$android_preference_SeekBarVolumizer_Receiver$updateVolumeSlider(int int ), 0, this, n, n2);
        }

        private /* synthetic */ void __constructor__(SeekBarVolumizer seekBarVolumizer, 1 var2_2) {
            this.$$robo$$android_preference_SeekBarVolumizer_Receiver$__constructor__(seekBarVolumizer, var2_2);
        }

        public /* synthetic */ Receiver() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Receiver)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class Observer
    extends ContentObserver
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ SeekBarVolumizer this$0;

        private void $$robo$$android_preference_SeekBarVolumizer_Observer$__constructor__(SeekBarVolumizer seekBarVolumizer, Handler handler) {
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_Observer$onChange(boolean selfChange) {
            super.onChange(selfChange);
            this.this$0.updateSlider();
        }

        private void __constructor__(SeekBarVolumizer seekBarVolumizer, Handler handler) {
            this.$$robo$$android_preference_SeekBarVolumizer_Observer$__constructor__(seekBarVolumizer, handler);
        }

        public Observer(SeekBarVolumizer seekBarVolumizer, Handler handler) {
            this.this$0 = seekBarVolumizer;
            super(handler);
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer_Observer$__constructor__(android.preference.SeekBarVolumizer android.os.Handler ), 0, this, seekBarVolumizer, handler);
        }

        @Override
        public void onChange(boolean bl) {
            InvokeDynamicSupport.bootstrap("onChange", $$robo$$android_preference_SeekBarVolumizer_Observer$onChange(boolean ), 0, this, bl);
        }

        public /* synthetic */ Observer() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Observer)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class H
    extends Handler
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private static int UPDATE_SLIDER = 1;
        /* synthetic */ SeekBarVolumizer this$0;

        private void $$robo$$android_preference_SeekBarVolumizer_H$__constructor__(SeekBarVolumizer seekBarVolumizer) {
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_H$handleMessage(Message msg) {
            if (msg.what == 1 && this.this$0.mSeekBar != null) {
                this.this$0.mLastProgress = msg.arg1;
                this.this$0.mLastAudibleStreamVolume = msg.arg2;
                boolean muted = (Boolean)msg.obj;
                if (muted != this.this$0.mMuted) {
                    this.this$0.mMuted = muted;
                    if (this.this$0.mCallback != null) {
                        this.this$0.mCallback.onMuted(this.this$0.mMuted, this.this$0.isZenMuted());
                    }
                }
                this.this$0.updateSeekBar();
            }
        }

        private final void $$robo$$android_preference_SeekBarVolumizer_H$postUpdateSlider(int volume, int lastAudibleVolume, boolean mute) {
            this.obtainMessage(1, volume, lastAudibleVolume, new Boolean(mute)).sendToTarget();
        }

        private /* synthetic */ void $$robo$$android_preference_SeekBarVolumizer_H$__constructor__(SeekBarVolumizer x0, 1 x1) {
        }

        private void __constructor__(SeekBarVolumizer seekBarVolumizer) {
            this.$$robo$$android_preference_SeekBarVolumizer_H$__constructor__(seekBarVolumizer);
        }

        private H(SeekBarVolumizer seekBarVolumizer) {
            this.this$0 = seekBarVolumizer;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_preference_SeekBarVolumizer_H$__constructor__(android.preference.SeekBarVolumizer ), 0, this, seekBarVolumizer);
        }

        @Override
        public void handleMessage(Message message) {
            InvokeDynamicSupport.bootstrap("handleMessage", $$robo$$android_preference_SeekBarVolumizer_H$handleMessage(android.os.Message ), 0, this, message);
        }

        public void postUpdateSlider(int n, int n2, boolean bl) {
            InvokeDynamicSupport.bootstrap("postUpdateSlider", $$robo$$android_preference_SeekBarVolumizer_H$postUpdateSlider(int int boolean ), 0, this, n, n2, bl);
        }

        private /* synthetic */ void __constructor__(SeekBarVolumizer seekBarVolumizer, 1 var2_2) {
            this.$$robo$$android_preference_SeekBarVolumizer_H$__constructor__(seekBarVolumizer, var2_2);
        }

        public /* synthetic */ H() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (H)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface Callback
    extends InstrumentedInterface {
        public void onSampleStarting(SeekBarVolumizer var1);

        public void onProgressChanged(SeekBar var1, int var2, boolean var3);

        public void onMuted(boolean var1, boolean var2);
    }
}

