/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.MessageQueue;
import android.util.ArraySet;
import java.util.concurrent.LinkedBlockingQueue;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class TestLooperManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static ArraySet<Looper> sHeldLoopers;
    private MessageQueue mQueue;
    private Looper mLooper;
    private LinkedBlockingQueue<MessageExecution> mExecuteQueue;
    private boolean mReleased;
    private boolean mLooperBlocked;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void $$robo$$android_os_TestLooperManager$__constructor__(Looper looper) {
        this.mExecuteQueue = new LinkedBlockingQueue();
        ArraySet<Looper> arraySet = sHeldLoopers;
        synchronized (arraySet) {
            if (sHeldLoopers.contains(looper)) {
                throw new RuntimeException("TestLooperManager already held for this looper");
            }
            sHeldLoopers.add(looper);
        }
        this.mLooper = looper;
        this.mQueue = this.mLooper.getQueue();
        new Handler(looper).post(new LooperHolder(this));
    }

    private final MessageQueue $$robo$$android_os_TestLooperManager$getMessageQueue() {
        this.checkReleased();
        return this.mQueue;
    }

    @Deprecated
    private final MessageQueue $$robo$$android_os_TestLooperManager$getQueue() {
        return this.getMessageQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Message $$robo$$android_os_TestLooperManager$next() {
        while (!this.mLooperBlocked) {
            TestLooperManager testLooperManager = this;
            synchronized (testLooperManager) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.checkReleased();
        return this.mQueue.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_TestLooperManager$release() {
        ArraySet<Looper> arraySet = sHeldLoopers;
        synchronized (arraySet) {
            sHeldLoopers.remove(this.mLooper);
        }
        this.checkReleased();
        this.mReleased = true;
        this.mExecuteQueue.add(new MessageExecution());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_TestLooperManager$execute(Message message) {
        this.checkReleased();
        if (Looper.myLooper() == this.mLooper) {
            message.target.dispatchMessage(message);
        } else {
            MessageExecution execution = new MessageExecution();
            execution.m = message;
            MessageExecution messageExecution = execution;
            synchronized (messageExecution) {
                this.mExecuteQueue.add(execution);
                try {
                    execution.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (execution.response != null) {
                    throw new RuntimeException(execution.response);
                }
            }
        }
    }

    private final void $$robo$$android_os_TestLooperManager$recycle(Message msg) {
        this.checkReleased();
        msg.recycleUnchecked();
    }

    private final boolean $$robo$$android_os_TestLooperManager$hasMessages(Handler h, Object object, int what) {
        this.checkReleased();
        return this.mQueue.hasMessages(h, what, object);
    }

    private final boolean $$robo$$android_os_TestLooperManager$hasMessages(Handler h, Object object, Runnable r) {
        this.checkReleased();
        return this.mQueue.hasMessages(h, r, object);
    }

    private final void $$robo$$android_os_TestLooperManager$checkReleased() {
        if (this.mReleased) {
            throw new RuntimeException("release() has already be called");
        }
    }

    static void __staticInitializer__() {
        sHeldLoopers = new ArraySet();
    }

    private void __constructor__(Looper looper) {
        this.$$robo$$android_os_TestLooperManager$__constructor__(looper);
    }

    public TestLooperManager(Looper looper) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_TestLooperManager$__constructor__(android.os.Looper ), 0, this, looper);
    }

    public MessageQueue getMessageQueue() {
        return InvokeDynamicSupport.bootstrap("getMessageQueue", $$robo$$android_os_TestLooperManager$getMessageQueue(), 0, this);
    }

    @Deprecated
    public MessageQueue getQueue() {
        return InvokeDynamicSupport.bootstrap("getQueue", $$robo$$android_os_TestLooperManager$getQueue(), 0, this);
    }

    public Message next() {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_os_TestLooperManager$next(), 0, this);
    }

    public void release() {
        InvokeDynamicSupport.bootstrap("release", $$robo$$android_os_TestLooperManager$release(), 0, this);
    }

    public void execute(Message message) {
        InvokeDynamicSupport.bootstrap("execute", $$robo$$android_os_TestLooperManager$execute(android.os.Message ), 0, this, message);
    }

    public void recycle(Message message) {
        InvokeDynamicSupport.bootstrap("recycle", $$robo$$android_os_TestLooperManager$recycle(android.os.Message ), 0, this, message);
    }

    public boolean hasMessages(Handler handler, Object object, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_TestLooperManager$hasMessages(android.os.Handler java.lang.Object int ), 0, this, handler, object, n);
    }

    public boolean hasMessages(Handler handler, Object object, Runnable runnable) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_TestLooperManager$hasMessages(android.os.Handler java.lang.Object java.lang.Runnable ), 0, this, handler, object, runnable);
    }

    private void checkReleased() {
        InvokeDynamicSupport.bootstrap("checkReleased", $$robo$$android_os_TestLooperManager$checkReleased(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(TestLooperManager.class);
    }

    public /* synthetic */ TestLooperManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (TestLooperManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    private static class MessageExecution
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Message m;
        private Throwable response;

        private void $$robo$$android_os_TestLooperManager_MessageExecution$__constructor__() {
        }

        private /* synthetic */ void $$robo$$android_os_TestLooperManager_MessageExecution$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_os_TestLooperManager_MessageExecution$__constructor__();
        }

        private MessageExecution() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_TestLooperManager_MessageExecution$__constructor__(), 0, this);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_os_TestLooperManager_MessageExecution$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageExecution)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class LooperHolder
    implements Runnable,
    ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ TestLooperManager this$0;

        private void $$robo$$android_os_TestLooperManager_LooperHolder$__constructor__(TestLooperManager testLooperManager) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_TestLooperManager_LooperHolder$run() {
            TestLooperManager testLooperManager = this.this$0;
            synchronized (testLooperManager) {
                this.this$0.mLooperBlocked = true;
                this.this$0.notify();
            }
            while (!this.this$0.mReleased) {
                try {
                    MessageExecution take = (MessageExecution)this.this$0.mExecuteQueue.take();
                    if (take.m == null) continue;
                    this.processMessage(take);
                }
                catch (InterruptedException interruptedException) {}
            }
            testLooperManager = this.this$0;
            synchronized (testLooperManager) {
                this.this$0.mLooperBlocked = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_os_TestLooperManager_LooperHolder$processMessage(MessageExecution mex) {
            MessageExecution messageExecution = mex;
            synchronized (messageExecution) {
                try {
                    ((MessageExecution)mex).m.target.dispatchMessage(mex.m);
                    mex.response = null;
                }
                catch (Throwable t) {
                    mex.response = t;
                }
                mex.notifyAll();
            }
        }

        private /* synthetic */ void $$robo$$android_os_TestLooperManager_LooperHolder$__constructor__(TestLooperManager x0, 1 x1) {
        }

        private void __constructor__(TestLooperManager testLooperManager) {
            this.$$robo$$android_os_TestLooperManager_LooperHolder$__constructor__(testLooperManager);
        }

        private LooperHolder(TestLooperManager testLooperManager) {
            this.this$0 = testLooperManager;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_TestLooperManager_LooperHolder$__constructor__(android.os.TestLooperManager ), 0, this, testLooperManager);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_TestLooperManager_LooperHolder$run(), 0, this);
        }

        private void processMessage(MessageExecution messageExecution) {
            InvokeDynamicSupport.bootstrap("processMessage", $$robo$$android_os_TestLooperManager_LooperHolder$processMessage(android.os.TestLooperManager$MessageExecution ), 0, this, messageExecution);
        }

        private /* synthetic */ void __constructor__(TestLooperManager testLooperManager, 1 var2_2) {
            this.$$robo$$android_os_TestLooperManager_LooperHolder$__constructor__(testLooperManager, var2_2);
        }

        public /* synthetic */ LooperHolder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (LooperHolder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

