/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.SuppressLint;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.ConditionVariable;
import android.os.FileUtils;
import android.os.Handler;
import android.os.IRecoverySystem;
import android.os.IRecoverySystemProgressListener;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.UserManager;
import android.os.VintfObject;
import android.text.TextUtils;
import android.util.Log;
import android.view.WindowManager;
import com.android.internal.logging.MetricsLogger;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Locale;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import libcore.io.Streams;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import sun.security.pkcs.PKCS7;
import sun.security.pkcs.SignerInfo;

public class RecoverySystem
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "RecoverySystem";
    private static File DEFAULT_KEYSTORE;
    private static long PUBLISH_PROGRESS_INTERVAL_MS = 500L;
    private static File RECOVERY_DIR;
    private static File LOG_FILE;
    private static File LAST_INSTALL_FILE;
    private static String LAST_PREFIX = "last_";
    public static File BLOCK_MAP_FILE;
    public static File UNCRYPT_PACKAGE_FILE;
    public static File UNCRYPT_STATUS_FILE;
    private static int LOG_FILE_MAX_LENGTH = 65536;
    private static Object sRequestLock;
    private IRecoverySystem mService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final HashSet<X509Certificate> $$robo$$android_os_RecoverySystem$getTrustedCerts(File keystore) throws IOException, GeneralSecurityException {
        HashSet<X509Certificate> trusted = new HashSet<X509Certificate>();
        if (keystore == null) {
            keystore = DEFAULT_KEYSTORE;
        }
        try (ZipFile zip = new ZipFile(keystore);){
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                try (InputStream is = zip.getInputStream(entry);){
                    trusted.add((X509Certificate)cf.generateCertificate(is));
                }
            }
        }
        return trusted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_RecoverySystem$verifyPackage(File packageFile, ProgressListener listener, File deviceCertsZipFile) throws IOException, GeneralSecurityException {
        long fileLen = packageFile.length();
        try (RandomAccessFile raf = new RandomAccessFile(packageFile, "r");){
            CallSite startTimeMillis = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
            if (listener != null) {
                listener.onProgress(0);
            }
            raf.seek(fileLen - 6L);
            byte[] footer = new byte[6];
            raf.readFully(footer);
            if (footer[2] != -1 || footer[3] != -1) {
                throw new SignatureException("no signature in file (no footer)");
            }
            int commentSize = footer[4] & 0xFF | (footer[5] & 0xFF) << 8;
            int signatureStart = footer[0] & 0xFF | (footer[1] & 0xFF) << 8;
            byte[] eocd = new byte[commentSize + 22];
            raf.seek(fileLen - (long)(commentSize + 22));
            raf.readFully(eocd);
            if (eocd[0] != 80 || eocd[1] != 75 || eocd[2] != 5 || eocd[3] != 6) {
                throw new SignatureException("no signature in file (bad footer)");
            }
            for (int i = 4; i < eocd.length - 3; ++i) {
                if (eocd[i] != 80 || eocd[i + 1] != 75 || eocd[i + 2] != 5 || eocd[i + 3] != 6) continue;
                throw new SignatureException("EOCD marker found after start of EOCD");
            }
            PKCS7 block = new PKCS7(new ByteArrayInputStream(eocd, commentSize + 22 - signatureStart, signatureStart));
            X509Certificate[] certificates = block.getCertificates();
            if (certificates == null || certificates.length == 0) {
                throw new SignatureException("signature contains no certificates");
            }
            X509Certificate cert = certificates[0];
            PublicKey signatureKey = cert.getPublicKey();
            SignerInfo[] signerInfos = block.getSignerInfos();
            if (signerInfos == null || signerInfos.length == 0) {
                throw new SignatureException("signature contains no signedData");
            }
            SignerInfo signerInfo = signerInfos[0];
            boolean verified = false;
            HashSet<X509Certificate> trusted = RecoverySystem.getTrustedCerts(deviceCertsZipFile == null ? DEFAULT_KEYSTORE : deviceCertsZipFile);
            for (X509Certificate c : trusted) {
                if (!c.getPublicKey().equals(signatureKey)) continue;
                verified = true;
                break;
            }
            if (!verified) {
                throw new SignatureException("signature doesn't match any trusted key");
            }
            raf.seek(0L);
            ProgressListener listenerForInner = listener;
            SignerInfo verifyResult = block.verify(signerInfo, (InputStream)new ShadowedObject(fileLen, commentSize, (long)startTimeMillis, raf, listenerForInner){
                public transient /* synthetic */ Object __robo_data__;
                long toRead;
                long soFar;
                int lastPercent;
                long lastPublishTime;
                /* synthetic */ long val$fileLen;
                /* synthetic */ int val$commentSize;
                /* synthetic */ long val$startTimeMillis;
                /* synthetic */ RandomAccessFile val$raf;
                /* synthetic */ ProgressListener val$listenerForInner;

                private void $$robo$$android_os_RecoverySystem_1$__constructor__(long l, int n, long l2, RandomAccessFile randomAccessFile, ProgressListener progressListener) {
                    this.toRead = this.val$fileLen - (long)this.val$commentSize - 2L;
                    this.soFar = 0L;
                    this.lastPercent = 0;
                    this.lastPublishTime = this.val$startTimeMillis;
                }

                private final int $$robo$$android_os_RecoverySystem_1$read() throws IOException {
                    throw new UnsupportedOperationException();
                }

                private final int $$robo$$android_os_RecoverySystem_1$read(byte[] b, int off, int len) throws IOException {
                    if (this.soFar >= this.toRead) {
                        return -1;
                    }
                    if (Thread.currentThread().isInterrupted()) {
                        return -1;
                    }
                    int size = len;
                    if (this.soFar + (long)size > this.toRead) {
                        size = (int)(this.toRead - this.soFar);
                    }
                    int read = this.val$raf.read(b, off, size);
                    this.soFar += (long)read;
                    if (this.val$listenerForInner != null) {
                        CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
                        int p = (int)(this.soFar * 100L / this.toRead);
                        if (p > this.lastPercent && now - this.lastPublishTime > 500L) {
                            this.lastPercent = p;
                            this.lastPublishTime = (long)now;
                            this.val$listenerForInner.onProgress(this.lastPercent);
                        }
                    }
                    return read;
                }

                private void __constructor__(long l, int n, long l2, RandomAccessFile randomAccessFile, ProgressListener progressListener) {
                    this.$$robo$$android_os_RecoverySystem_1$__constructor__(l, n, l2, randomAccessFile, progressListener);
                }
                {
                    this.val$fileLen = l;
                    this.val$commentSize = n;
                    this.val$startTimeMillis = l2;
                    this.val$raf = randomAccessFile;
                    this.val$listenerForInner = progressListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RecoverySystem_1$__constructor__(long int long java.io.RandomAccessFile android.os.RecoverySystem$ProgressListener ), 0, this, l, n, l2, randomAccessFile, progressListener);
                }

                @Override
                public int read() throws IOException {
                    return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_RecoverySystem_1$read(), 0, this);
                }

                @Override
                public int read(byte[] byArray, int n, int n2) throws IOException {
                    return (int)InvokeDynamicSupport.bootstrap("read", $$robo$$android_os_RecoverySystem_1$read(byte[] int int ), 0, this, byArray, n, n2);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
            boolean interrupted = Thread.interrupted();
            if (listener != null) {
                listener.onProgress(100);
            }
            if (interrupted) {
                throw new SignatureException("verification was interrupted");
            }
            if (verifyResult == null) {
                throw new SignatureException("signature digest verification failed");
            }
        }
        if (!RecoverySystem.readAndVerifyPackageCompatibilityEntry(packageFile)) {
            throw new SignatureException("package compatibility verification failed");
        }
    }

    private static final boolean $$robo$$android_os_RecoverySystem$verifyPackageCompatibility(InputStream inputStream) throws IOException {
        ZipEntry entry;
        ArrayList<String> list = new ArrayList<String>();
        ZipInputStream zis = new ZipInputStream(inputStream);
        while ((entry = zis.getNextEntry()) != null) {
            long entrySize = entry.getSize();
            if (entrySize > Integer.MAX_VALUE || entrySize < 0L) {
                throw new IOException("invalid entry size (" + entrySize + ") in the compatibility file");
            }
            byte[] bytes = new byte[(int)entrySize];
            Streams.readFully(zis, bytes);
            list.add(new String(bytes, StandardCharsets.UTF_8));
        }
        if (list.isEmpty()) {
            throw new IOException("no entries found in the compatibility file");
        }
        return VintfObject.verify(list.toArray(new String[list.size()])) == 0;
    }

    private static final boolean $$robo$$android_os_RecoverySystem$readAndVerifyPackageCompatibilityEntry(File packageFile) throws IOException {
        try (ZipFile zip = new ZipFile(packageFile);){
            ZipEntry entry = zip.getEntry("compatibility.zip");
            if (entry == null) {
                boolean bl = true;
                return bl;
            }
            InputStream inputStream = zip.getInputStream(entry);
            boolean bl = RecoverySystem.verifyPackageCompatibility(inputStream);
            return bl;
        }
    }

    @SuppressLint(value={"Doclava125"})
    private static final boolean $$robo$$android_os_RecoverySystem$verifyPackageCompatibility(File compatibilityFile) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(compatibilityFile);){
            boolean bl = RecoverySystem.verifyPackageCompatibility(inputStream);
            return bl;
        }
    }

    private static final void $$robo$$android_os_RecoverySystem$processPackage(Context context, File packageFile, ProgressListener listener, Handler handler) throws IOException {
        String filename = packageFile.getCanonicalPath();
        if (!filename.startsWith("/data/")) {
            return;
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        ShadowedObject progressListener = null;
        if (listener != null) {
            Handler progressHandler = handler != null ? handler : new Handler(context.getMainLooper());
            progressListener = new ShadowedObject(progressHandler, listener){
                public transient /* synthetic */ Object __robo_data__;
                int lastProgress;
                long lastPublishTime;
                /* synthetic */ Handler val$progressHandler;
                /* synthetic */ ProgressListener val$listener;

                private void $$robo$$android_os_RecoverySystem_2$__constructor__(Handler handler, ProgressListener progressListener) {
                    this.lastProgress = 0;
                    this.lastPublishTime = (long)InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
                }

                private final void $$robo$$android_os_RecoverySystem_2$onProgress(int progress) {
                    CallSite now = InvokeDynamicSupport.bootstrapIntrinsic("currentTimeMillis", "java.lang.System");
                    this.val$progressHandler.post(new Runnable(this, progress, (long)now){
                        public transient /* synthetic */ Object __robo_data__;
                        /* synthetic */ int val$progress;
                        /* synthetic */ long val$now;
                        /* synthetic */ 2 this$0;

                        private void $$robo$$android_os_RecoverySystem_2_1$__constructor__(2 this$0, int n, long l) {
                        }

                        private final void $$robo$$android_os_RecoverySystem_2_1$run() {
                            if (this.val$progress > this.this$0.lastProgress && this.val$now - this.this$0.lastPublishTime > 500L) {
                                this.this$0.lastProgress = this.val$progress;
                                this.this$0.lastPublishTime = this.val$now;
                                this.this$0.val$listener.onProgress(this.val$progress);
                            }
                        }

                        private void __constructor__(2 var1_1, int n, long l) {
                            this.$$robo$$android_os_RecoverySystem_2_1$__constructor__(var1_1, n, l);
                        }
                        {
                            this.this$0 = var1_1;
                            this.val$progress = n;
                            this.val$now = l;
                            this.$$robo$init();
                            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RecoverySystem_2_1$__constructor__(android.os.RecoverySystem$2 int long ), 0, this, var1_1, n, l);
                        }

                        @Override
                        public void run() {
                            InvokeDynamicSupport.bootstrap("run", $$robo$$android_os_RecoverySystem_2_1$run(), 0, this);
                        }
                        {
                            this.$$robo$init();
                        }

                        protected /* synthetic */ void $$robo$init() {
                            if (this.__robo_data__ == null) {
                                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                            }
                        }

                        public /* synthetic */ Object $$robo$getData() {
                            return this.__robo_data__;
                        }
                    });
                }

                private void __constructor__(Handler handler, ProgressListener progressListener) {
                    this.$$robo$$android_os_RecoverySystem_2$__constructor__(handler, progressListener);
                }
                {
                    this.val$progressHandler = handler;
                    this.val$listener = progressListener;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RecoverySystem_2$__constructor__(android.os.Handler android.os.RecoverySystem$ProgressListener ), 0, this, handler, progressListener);
                }

                @Override
                public void onProgress(int n) {
                    InvokeDynamicSupport.bootstrap("onProgress", $$robo$$android_os_RecoverySystem_2$onProgress(int ), 0, this, n);
                }
                {
                    this.$$robo$init();
                }

                @Override
                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                @Override
                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            };
        }
        if (!rs.uncrypt(filename, (IRecoverySystemProgressListener)progressListener)) {
            throw new IOException("process package failed");
        }
    }

    private static final void $$robo$$android_os_RecoverySystem$processPackage(Context context, File packageFile, ProgressListener listener) throws IOException {
        RecoverySystem.processPackage(context, packageFile, listener, null);
    }

    private static final void $$robo$$android_os_RecoverySystem$installPackage(Context context, File packageFile) throws IOException {
        RecoverySystem.installPackage(context, packageFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void $$robo$$android_os_RecoverySystem$installPackage(Context context, File packageFile, boolean processed) throws IOException {
        Object object = sRequestLock;
        synchronized (object) {
            WindowManager wm;
            RecoverySystem rs;
            LOG_FILE.delete();
            UNCRYPT_PACKAGE_FILE.delete();
            String filename = packageFile.getCanonicalPath();
            Log.w("RecoverySystem", "!!! REBOOTING TO INSTALL " + filename + " !!!");
            boolean securityUpdate = filename.endsWith("_s.zip");
            if (filename.startsWith("/data/")) {
                if (processed) {
                    if (!BLOCK_MAP_FILE.exists()) {
                        Log.e("RecoverySystem", "Package claimed to have been processed but failed to find the block map file.");
                        throw new IOException("Failed to find block map file");
                    }
                } else {
                    try (FileWriter uncryptFile = new FileWriter(UNCRYPT_PACKAGE_FILE);){
                        uncryptFile.write(filename + "\n");
                    }
                    if (!UNCRYPT_PACKAGE_FILE.setReadable(true, false) || !UNCRYPT_PACKAGE_FILE.setWritable(true, false)) {
                        Log.e("RecoverySystem", "Error setting permission for " + UNCRYPT_PACKAGE_FILE);
                    }
                    BLOCK_MAP_FILE.delete();
                }
                filename = "@/cache/recovery/block.map";
            }
            String filenameArg = "--update_package=" + filename + "\n";
            String localeArg = "--locale=" + Locale.getDefault().toLanguageTag() + "\n";
            String securityArg = "--security\n";
            String command = filenameArg + localeArg;
            if (securityUpdate) {
                command = command + "--security\n";
            }
            if (!(rs = (RecoverySystem)context.getSystemService("recovery")).setupBcb(command)) {
                throw new IOException("Setup BCB failed");
            }
            PowerManager pm = (PowerManager)context.getSystemService("power");
            String reason = "recovery-update";
            if (context.getPackageManager().hasSystemFeature("android.software.leanback") && (wm = (WindowManager)context.getSystemService("window")).getDefaultDisplay().getState() != 2) {
                reason = reason + ",quiescent";
            }
            pm.reboot(reason);
            throw new IOException("Reboot failed (no permissions?)");
        }
    }

    private static final void $$robo$$android_os_RecoverySystem$scheduleUpdateOnBoot(Context context, File packageFile) throws IOException {
        RecoverySystem rs;
        String filename = packageFile.getCanonicalPath();
        boolean securityUpdate = filename.endsWith("_s.zip");
        if (filename.startsWith("/data/")) {
            filename = "@/cache/recovery/block.map";
        }
        String filenameArg = "--update_package=" + filename + "\n";
        String localeArg = "--locale=" + Locale.getDefault().toLanguageTag() + "\n";
        String securityArg = "--security\n";
        String command = filenameArg + localeArg;
        if (securityUpdate) {
            command = command + "--security\n";
        }
        if (!(rs = (RecoverySystem)context.getSystemService("recovery")).setupBcb(command)) {
            throw new IOException("schedule update on boot failed");
        }
    }

    private static final void $$robo$$android_os_RecoverySystem$cancelScheduledUpdate(Context context) throws IOException {
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        if (!rs.clearBcb()) {
            throw new IOException("cancel scheduled update failed");
        }
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeUserData(Context context) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, context.getPackageName(), false);
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeUserData(Context context, String reason) throws IOException {
        RecoverySystem.rebootWipeUserData(context, false, reason, false);
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeUserData(Context context, boolean shutdown) throws IOException {
        RecoverySystem.rebootWipeUserData(context, shutdown, context.getPackageName(), false);
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeUserData(Context context, boolean shutdown, String reason, boolean force) throws IOException {
        UserManager um = (UserManager)context.getSystemService("user");
        if (!force && um.hasUserRestriction("no_factory_reset")) {
            throw new SecurityException("Wiping data is not allowed for this user.");
        }
        ConditionVariable condition = new ConditionVariable();
        Intent intent = new Intent("android.intent.action.MASTER_CLEAR_NOTIFICATION");
        intent.addFlags(0x11000000);
        context.sendOrderedBroadcastAsUser(intent, UserHandle.SYSTEM, "android.permission.MASTER_CLEAR", (BroadcastReceiver)new ShadowedObject(condition){
            public transient /* synthetic */ Object __robo_data__;
            /* synthetic */ ConditionVariable val$condition;

            private void $$robo$$android_os_RecoverySystem_3$__constructor__(ConditionVariable conditionVariable) {
            }

            private final void $$robo$$android_os_RecoverySystem_3$onReceive(Context context, Intent intent) {
                this.val$condition.open();
            }

            private void __constructor__(ConditionVariable conditionVariable) {
                this.$$robo$$android_os_RecoverySystem_3$__constructor__(conditionVariable);
            }
            {
                this.val$condition = conditionVariable;
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RecoverySystem_3$__constructor__(android.os.ConditionVariable ), 0, this, conditionVariable);
            }

            @Override
            public void onReceive(Context context, Intent intent) {
                InvokeDynamicSupport.bootstrap("onReceive", $$robo$$android_os_RecoverySystem_3$onReceive(android.content.Context android.content.Intent ), 0, this, context, intent);
            }
            {
                this.$$robo$init();
            }

            @Override
            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            @Override
            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        }, null, 0, null, null);
        condition.block();
        String shutdownArg = null;
        if (shutdown) {
            shutdownArg = "--shutdown_after";
        }
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + Locale.getDefault().toLanguageTag();
        RecoverySystem.bootCommand(context, shutdownArg, "--wipe_data", reasonArg, localeArg);
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootPromptAndWipeUserData(Context context, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + Locale.getDefault().toString();
        RecoverySystem.bootCommand(context, null, "--prompt_and_wipe_data", reasonArg, localeArg);
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeCache(Context context) throws IOException {
        RecoverySystem.rebootWipeCache(context, context.getPackageName());
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeCache(Context context, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String localeArg = "--locale=" + Locale.getDefault().toLanguageTag();
        RecoverySystem.bootCommand(context, "--wipe_cache", reasonArg, localeArg);
    }

    private static final void $$robo$$android_os_RecoverySystem$rebootWipeAb(Context context, File packageFile, String reason) throws IOException {
        String reasonArg = null;
        if (!TextUtils.isEmpty(reason)) {
            reasonArg = "--reason=" + RecoverySystem.sanitizeArg(reason);
        }
        String filename = packageFile.getCanonicalPath();
        String filenameArg = "--wipe_package=" + filename;
        String localeArg = "--locale=" + Locale.getDefault().toLanguageTag();
        RecoverySystem.bootCommand(context, "--wipe_ab", filenameArg, reasonArg, localeArg);
    }

    private static final void $$robo$$android_os_RecoverySystem$bootCommand(Context context, String ... args) throws IOException {
        LOG_FILE.delete();
        StringBuilder command = new StringBuilder();
        for (String arg : args) {
            if (TextUtils.isEmpty(arg)) continue;
            command.append(arg);
            command.append("\n");
        }
        RecoverySystem rs = (RecoverySystem)context.getSystemService("recovery");
        rs.rebootRecoveryWithCommand(command.toString());
        throw new IOException("Reboot failed (no permissions?)");
    }

    private static final void $$robo$$android_os_RecoverySystem$parseLastInstallLog(Context context) {
        try (BufferedReader in = new BufferedReader(new FileReader(LAST_INSTALL_FILE));){
            String line = null;
            int bytesWrittenInMiB = -1;
            int bytesStashedInMiB = -1;
            int timeTotal = -1;
            int uncryptTime = -1;
            int sourceVersion = -1;
            int temperature_start = -1;
            int temperature_end = -1;
            int temperature_max = -1;
            while ((line = in.readLine()) != null) {
                int scaled;
                long parsedNum;
                int numIndex = line.indexOf(58);
                if (numIndex == -1 || numIndex + 1 >= line.length()) continue;
                String numString = line.substring(numIndex + 1).trim();
                try {
                    parsedNum = Long.parseLong(numString);
                }
                catch (NumberFormatException ignored) {
                    Log.e("RecoverySystem", "Failed to parse numbers in " + line);
                    continue;
                }
                int MiB = 0x100000;
                try {
                    scaled = line.startsWith("bytes") ? Math.toIntExact(parsedNum / 0x100000L) : Math.toIntExact(parsedNum);
                }
                catch (ArithmeticException ignored) {
                    Log.e("RecoverySystem", "Number overflows in " + line);
                    continue;
                }
                if (line.startsWith("time")) {
                    timeTotal = scaled;
                    continue;
                }
                if (line.startsWith("uncrypt_time")) {
                    uncryptTime = scaled;
                    continue;
                }
                if (line.startsWith("source_build")) {
                    sourceVersion = scaled;
                    continue;
                }
                if (line.startsWith("bytes_written")) {
                    bytesWrittenInMiB = bytesWrittenInMiB == -1 ? scaled : bytesWrittenInMiB + scaled;
                    continue;
                }
                if (line.startsWith("bytes_stashed")) {
                    bytesStashedInMiB = bytesStashedInMiB == -1 ? scaled : bytesStashedInMiB + scaled;
                    continue;
                }
                if (line.startsWith("temperature_start")) {
                    temperature_start = scaled;
                    continue;
                }
                if (line.startsWith("temperature_end")) {
                    temperature_end = scaled;
                    continue;
                }
                if (!line.startsWith("temperature_max")) continue;
                temperature_max = scaled;
            }
            if (timeTotal != -1) {
                MetricsLogger.histogram(context, "ota_time_total", timeTotal);
            }
            if (uncryptTime != -1) {
                MetricsLogger.histogram(context, "ota_uncrypt_time", uncryptTime);
            }
            if (sourceVersion != -1) {
                MetricsLogger.histogram(context, "ota_source_version", sourceVersion);
            }
            if (bytesWrittenInMiB != -1) {
                MetricsLogger.histogram(context, "ota_written_in_MiBs", bytesWrittenInMiB);
            }
            if (bytesStashedInMiB != -1) {
                MetricsLogger.histogram(context, "ota_stashed_in_MiBs", bytesStashedInMiB);
            }
            if (temperature_start != -1) {
                MetricsLogger.histogram(context, "ota_temperature_start", temperature_start);
            }
            if (temperature_end != -1) {
                MetricsLogger.histogram(context, "ota_temperature_end", temperature_end);
            }
            if (temperature_max != -1) {
                MetricsLogger.histogram(context, "ota_temperature_max", temperature_max);
            }
        }
        catch (IOException e) {
            Log.e("RecoverySystem", "Failed to read lines in last_install", e);
        }
    }

    private static final String $$robo$$android_os_RecoverySystem$handleAftermath(Context context) {
        boolean reservePackage;
        String log = null;
        try {
            log = FileUtils.readTextFile(LOG_FILE, -65536, "...\n");
        }
        catch (FileNotFoundException e) {
            Log.i("RecoverySystem", "No recovery log file");
        }
        catch (IOException e) {
            Log.e("RecoverySystem", "Error reading recovery log", e);
        }
        if (log != null) {
            RecoverySystem.parseLastInstallLog(context);
        }
        if (!(reservePackage = BLOCK_MAP_FILE.exists()) && UNCRYPT_PACKAGE_FILE.exists()) {
            String filename = null;
            try {
                filename = FileUtils.readTextFile(UNCRYPT_PACKAGE_FILE, 0, null);
            }
            catch (IOException e) {
                Log.e("RecoverySystem", "Error reading uncrypt file", e);
            }
            if (filename != null && filename.startsWith("/data")) {
                if (UNCRYPT_PACKAGE_FILE.delete()) {
                    Log.i("RecoverySystem", "Deleted: " + filename);
                } else {
                    Log.e("RecoverySystem", "Can't delete: " + filename);
                }
            }
        }
        String[] names = RECOVERY_DIR.list();
        for (int i = 0; names != null && i < names.length; ++i) {
            if (names[i].startsWith("last_") || reservePackage && names[i].equals(BLOCK_MAP_FILE.getName()) || reservePackage && names[i].equals(UNCRYPT_PACKAGE_FILE.getName())) continue;
            RecoverySystem.recursiveDelete(new File(RECOVERY_DIR, names[i]));
        }
        return log;
    }

    private static final void $$robo$$android_os_RecoverySystem$recursiveDelete(File name) {
        if (name.isDirectory()) {
            String[] files = name.list();
            for (int i = 0; files != null && i < files.length; ++i) {
                File f = new File(name, files[i]);
                RecoverySystem.recursiveDelete(f);
            }
        }
        if (!name.delete()) {
            Log.e("RecoverySystem", "Can't delete: " + name);
        } else {
            Log.i("RecoverySystem", "Deleted: " + name);
        }
    }

    private final boolean $$robo$$android_os_RecoverySystem$uncrypt(String packageFile, IRecoverySystemProgressListener listener) {
        try {
            return this.mService.uncrypt(packageFile, listener);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_os_RecoverySystem$setupBcb(String command) {
        try {
            return this.mService.setupBcb(command);
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final boolean $$robo$$android_os_RecoverySystem$clearBcb() {
        try {
            return this.mService.clearBcb();
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    private final void $$robo$$android_os_RecoverySystem$rebootRecoveryWithCommand(String command) {
        try {
            this.mService.rebootRecoveryWithCommand(command);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private static final String $$robo$$android_os_RecoverySystem$sanitizeArg(String arg) {
        arg = arg.replace('\u0000', '?');
        arg = arg.replace('\n', '?');
        return arg;
    }

    private void $$robo$$android_os_RecoverySystem$__constructor__() {
        this.mService = null;
    }

    private void $$robo$$android_os_RecoverySystem$__constructor__(IRecoverySystem service) {
        this.mService = service;
    }

    static void __staticInitializer__() {
        DEFAULT_KEYSTORE = new File("/system/etc/security/otacerts.zip");
        RECOVERY_DIR = new File("/cache/recovery");
        LOG_FILE = new File(RECOVERY_DIR, "log");
        LAST_INSTALL_FILE = new File(RECOVERY_DIR, "last_install");
        BLOCK_MAP_FILE = new File(RECOVERY_DIR, "block.map");
        UNCRYPT_PACKAGE_FILE = new File(RECOVERY_DIR, "uncrypt_file");
        UNCRYPT_STATUS_FILE = new File(RECOVERY_DIR, "uncrypt_status");
        sRequestLock = new Object();
    }

    private static HashSet<X509Certificate> getTrustedCerts(File file) throws IOException, GeneralSecurityException {
        return InvokeDynamicSupport.bootstrapStatic("getTrustedCerts", $$robo$$android_os_RecoverySystem$getTrustedCerts(java.io.File ), 0, (File)file);
    }

    public static void verifyPackage(File file, ProgressListener progressListener, File file2) throws IOException, GeneralSecurityException {
        InvokeDynamicSupport.bootstrapStatic("verifyPackage", $$robo$$android_os_RecoverySystem$verifyPackage(java.io.File android.os.RecoverySystem$ProgressListener java.io.File ), 0, (File)file, (ProgressListener)progressListener, (File)file2);
    }

    private static boolean verifyPackageCompatibility(InputStream inputStream) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyPackageCompatibility", $$robo$$android_os_RecoverySystem$verifyPackageCompatibility(java.io.InputStream ), 0, (InputStream)inputStream);
    }

    private static boolean readAndVerifyPackageCompatibilityEntry(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("readAndVerifyPackageCompatibilityEntry", $$robo$$android_os_RecoverySystem$readAndVerifyPackageCompatibilityEntry(java.io.File ), 0, (File)file);
    }

    public static boolean verifyPackageCompatibility(File file) throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("verifyPackageCompatibility", $$robo$$android_os_RecoverySystem$verifyPackageCompatibility(java.io.File ), 0, (File)file);
    }

    public static void processPackage(Context context, File file, ProgressListener progressListener, Handler handler) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("processPackage", $$robo$$android_os_RecoverySystem$processPackage(android.content.Context java.io.File android.os.RecoverySystem$ProgressListener android.os.Handler ), 0, (Context)context, (File)file, (ProgressListener)progressListener, (Handler)handler);
    }

    public static void processPackage(Context context, File file, ProgressListener progressListener) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("processPackage", $$robo$$android_os_RecoverySystem$processPackage(android.content.Context java.io.File android.os.RecoverySystem$ProgressListener ), 0, (Context)context, (File)file, (ProgressListener)progressListener);
    }

    public static void installPackage(Context context, File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("installPackage", $$robo$$android_os_RecoverySystem$installPackage(android.content.Context java.io.File ), 0, (Context)context, (File)file);
    }

    public static void installPackage(Context context, File file, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("installPackage", $$robo$$android_os_RecoverySystem$installPackage(android.content.Context java.io.File boolean ), 0, (Context)context, (File)file, (boolean)bl);
    }

    public static void scheduleUpdateOnBoot(Context context, File file) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("scheduleUpdateOnBoot", $$robo$$android_os_RecoverySystem$scheduleUpdateOnBoot(android.content.Context java.io.File ), 0, (Context)context, (File)file);
    }

    public static void cancelScheduledUpdate(Context context) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("cancelScheduledUpdate", $$robo$$android_os_RecoverySystem$cancelScheduledUpdate(android.content.Context ), 0, (Context)context);
    }

    public static void rebootWipeUserData(Context context) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeUserData", $$robo$$android_os_RecoverySystem$rebootWipeUserData(android.content.Context ), 0, (Context)context);
    }

    public static void rebootWipeUserData(Context context, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeUserData", $$robo$$android_os_RecoverySystem$rebootWipeUserData(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static void rebootWipeUserData(Context context, boolean bl) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeUserData", $$robo$$android_os_RecoverySystem$rebootWipeUserData(android.content.Context boolean ), 0, (Context)context, (boolean)bl);
    }

    public static void rebootWipeUserData(Context context, boolean bl, String string2, boolean bl2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeUserData", $$robo$$android_os_RecoverySystem$rebootWipeUserData(android.content.Context boolean java.lang.String boolean ), 0, (Context)context, (boolean)bl, (String)string2, (boolean)bl2);
    }

    public static void rebootPromptAndWipeUserData(Context context, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootPromptAndWipeUserData", $$robo$$android_os_RecoverySystem$rebootPromptAndWipeUserData(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static void rebootWipeCache(Context context) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeCache", $$robo$$android_os_RecoverySystem$rebootWipeCache(android.content.Context ), 0, (Context)context);
    }

    public static void rebootWipeCache(Context context, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeCache", $$robo$$android_os_RecoverySystem$rebootWipeCache(android.content.Context java.lang.String ), 0, (Context)context, (String)string2);
    }

    public static void rebootWipeAb(Context context, File file, String string2) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("rebootWipeAb", $$robo$$android_os_RecoverySystem$rebootWipeAb(android.content.Context java.io.File java.lang.String ), 0, (Context)context, (File)file, (String)string2);
    }

    private static void bootCommand(Context context, String ... stringArray) throws IOException {
        InvokeDynamicSupport.bootstrapStatic("bootCommand", $$robo$$android_os_RecoverySystem$bootCommand(android.content.Context java.lang.String[] ), 0, (Context)context, (String[])stringArray);
    }

    private static void parseLastInstallLog(Context context) {
        InvokeDynamicSupport.bootstrapStatic("parseLastInstallLog", $$robo$$android_os_RecoverySystem$parseLastInstallLog(android.content.Context ), 0, (Context)context);
    }

    public static String handleAftermath(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("handleAftermath", $$robo$$android_os_RecoverySystem$handleAftermath(android.content.Context ), 0, (Context)context);
    }

    private static void recursiveDelete(File file) {
        InvokeDynamicSupport.bootstrapStatic("recursiveDelete", $$robo$$android_os_RecoverySystem$recursiveDelete(java.io.File ), 0, (File)file);
    }

    private boolean uncrypt(String string2, IRecoverySystemProgressListener iRecoverySystemProgressListener) {
        return (boolean)InvokeDynamicSupport.bootstrap("uncrypt", $$robo$$android_os_RecoverySystem$uncrypt(java.lang.String android.os.IRecoverySystemProgressListener ), 0, this, string2, iRecoverySystemProgressListener);
    }

    private boolean setupBcb(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("setupBcb", $$robo$$android_os_RecoverySystem$setupBcb(java.lang.String ), 0, this, string2);
    }

    private boolean clearBcb() {
        return (boolean)InvokeDynamicSupport.bootstrap("clearBcb", $$robo$$android_os_RecoverySystem$clearBcb(), 0, this);
    }

    private void rebootRecoveryWithCommand(String string2) {
        InvokeDynamicSupport.bootstrap("rebootRecoveryWithCommand", $$robo$$android_os_RecoverySystem$rebootRecoveryWithCommand(java.lang.String ), 0, this, string2);
    }

    private static String sanitizeArg(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("sanitizeArg", $$robo$$android_os_RecoverySystem$sanitizeArg(java.lang.String ), 0, (String)string2);
    }

    private void __constructor__() {
        this.$$robo$$android_os_RecoverySystem$__constructor__();
    }

    public RecoverySystem() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RecoverySystem$__constructor__(), 0, this);
    }

    private void __constructor__(IRecoverySystem iRecoverySystem) {
        this.$$robo$$android_os_RecoverySystem$__constructor__(iRecoverySystem);
    }

    public RecoverySystem(IRecoverySystem iRecoverySystem) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_RecoverySystem$__constructor__(android.os.IRecoverySystem ), 0, this, iRecoverySystem);
    }

    static {
        RobolectricInternals.classInitializing(RecoverySystem.class);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RecoverySystem)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static interface ProgressListener
    extends InstrumentedInterface {
        public void onProgress(int var1);
    }
}

