/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.annotation.IntDef;
import android.os.Binder;
import android.os.Handler;
import android.os.Message;
import android.os.SystemClock;
import android.util.Log;
import android.util.Printer;
import android.util.SparseArray;
import android.util.proto.ProtoOutputStream;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import org.robolectric.internal.bytecode.InstrumentedInterface;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class MessageQueue
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "MessageQueue";
    private static boolean DEBUG = false;
    private boolean mQuitAllowed;
    private long mPtr;
    Message mMessages;
    private ArrayList<IdleHandler> mIdleHandlers;
    private SparseArray<FileDescriptorRecord> mFileDescriptorRecords;
    private IdleHandler[] mPendingIdleHandlers;
    private boolean mQuitting;
    private boolean mBlocked;
    private int mNextBarrierToken;

    private static final long $$robo$$android_os_MessageQueue$nativeInit() {
        return 0L;
    }

    private static final void $$robo$$android_os_MessageQueue$nativeDestroy(long l) {
    }

    private final void $$robo$$android_os_MessageQueue$nativePollOnce(long l, int n) {
    }

    private static final void $$robo$$android_os_MessageQueue$nativeWake(long l) {
    }

    private static final boolean $$robo$$android_os_MessageQueue$nativeIsPolling(long l) {
        return false;
    }

    private static final void $$robo$$android_os_MessageQueue$nativeSetFileDescriptorEvents(long l, int n, int n2) {
    }

    private void $$robo$$android_os_MessageQueue$__constructor__(boolean quitAllowed) {
        this.mIdleHandlers = new ArrayList();
        this.mQuitAllowed = quitAllowed;
        this.mPtr = MessageQueue.nativeInit();
    }

    private final void $$robo$$android_os_MessageQueue$finalize() throws Throwable {
        try {
            this.dispose();
        }
        finally {
            super.finalize();
        }
    }

    private final void $$robo$$android_os_MessageQueue$dispose() {
        if (this.mPtr != 0L) {
            MessageQueue.nativeDestroy(this.mPtr);
            this.mPtr = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$isIdle() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            return this.mMessages == null || now < this.mMessages.when;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$addIdleHandler(IdleHandler handler) {
        if (handler == null) {
            throw new NullPointerException("Can't add a null IdleHandler");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.add(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeIdleHandler(IdleHandler handler) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.mIdleHandlers.remove(handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$isPolling() {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            return this.isPollingLocked();
        }
    }

    private final boolean $$robo$$android_os_MessageQueue$isPollingLocked() {
        return !this.mQuitting && MessageQueue.nativeIsPolling(this.mPtr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$addOnFileDescriptorEventListener(FileDescriptor fd, int events, OnFileDescriptorEventListener listener) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, events, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeOnFileDescriptorEventListener(FileDescriptor fd) {
        if (fd == null) {
            throw new IllegalArgumentException("fd must not be null");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            this.updateOnFileDescriptorEventListenerLocked(fd, 0, null);
        }
    }

    private final void $$robo$$android_os_MessageQueue$updateOnFileDescriptorEventListenerLocked(FileDescriptor fd, int events, OnFileDescriptorEventListener listener) {
        CallSite fdNum = InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)fd);
        int index = -1;
        FileDescriptorRecord record = null;
        if (this.mFileDescriptorRecords != null && (index = this.mFileDescriptorRecords.indexOfKey((int)fdNum)) >= 0 && (record = this.mFileDescriptorRecords.valueAt(index)) != null && record.mEvents == events) {
            return;
        }
        if (events != 0) {
            events |= 4;
            if (record == null) {
                if (this.mFileDescriptorRecords == null) {
                    this.mFileDescriptorRecords = new SparseArray();
                }
                record = new FileDescriptorRecord(fd, events, listener);
                this.mFileDescriptorRecords.put((int)fdNum, record);
            } else {
                record.mListener = listener;
                record.mEvents = events;
                ++record.mSeq;
            }
            MessageQueue.nativeSetFileDescriptorEvents(this.mPtr, (int)fdNum, events);
        } else if (record != null) {
            record.mEvents = 0;
            this.mFileDescriptorRecords.removeAt(index);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_MessageQueue$dispatchEvents(int fd, int events) {
        int seq;
        OnFileDescriptorEventListener listener;
        int oldWatchedEvents;
        FileDescriptorRecord record;
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            record = this.mFileDescriptorRecords.get(fd);
            if (record == null) {
                return 0;
            }
            oldWatchedEvents = record.mEvents;
            if ((events &= oldWatchedEvents) == 0) {
                return oldWatchedEvents;
            }
            listener = record.mListener;
            seq = record.mSeq;
        }
        int newWatchedEvents = listener.onFileDescriptorEvents(record.mDescriptor, events);
        if (newWatchedEvents != 0) {
            newWatchedEvents |= 4;
        }
        if (newWatchedEvents != oldWatchedEvents) {
            MessageQueue messageQueue2 = this;
            synchronized (messageQueue2) {
                int index = this.mFileDescriptorRecords.indexOfKey(fd);
                if (index >= 0 && this.mFileDescriptorRecords.valueAt(index) == record && record.mSeq == seq) {
                    record.mEvents = newWatchedEvents;
                    if (newWatchedEvents == 0) {
                        this.mFileDescriptorRecords.removeAt(index);
                    }
                }
            }
        }
        return newWatchedEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final Message $$robo$$android_os_MessageQueue$next() {
        long ptr = this.mPtr;
        if (ptr == 0L) {
            return null;
        }
        int pendingIdleHandlerCount = -1;
        int nextPollTimeoutMillis = 0;
        while (true) {
            if (nextPollTimeoutMillis != 0) {
                Binder.flushPendingCommands();
            }
            this.nativePollOnce(ptr, nextPollTimeoutMillis);
            MessageQueue messageQueue = this;
            synchronized (messageQueue) {
                long now;
                block21: {
                    now = SystemClock.uptimeMillis();
                    Message prevMsg = null;
                    Message msg = this.mMessages;
                    if (msg != null && msg.target == null) {
                        do {
                            prevMsg = msg;
                        } while ((msg = msg.next) != null && !msg.isAsynchronous());
                    }
                    if (msg != null) {
                        if (now < msg.when) {
                            nextPollTimeoutMillis = (int)Math.min(msg.when - now, Integer.MAX_VALUE);
                            break block21;
                        } else {
                            this.mBlocked = false;
                            if (prevMsg != null) {
                                prevMsg.next = msg.next;
                            } else {
                                this.mMessages = msg.next;
                            }
                            msg.next = null;
                            msg.markInUse();
                            return msg;
                        }
                    }
                    nextPollTimeoutMillis = -1;
                }
                if (this.mQuitting) {
                    this.dispose();
                    return null;
                }
                if (pendingIdleHandlerCount < 0 && (this.mMessages == null || now < this.mMessages.when)) {
                    pendingIdleHandlerCount = this.mIdleHandlers.size();
                }
                if (pendingIdleHandlerCount <= 0) {
                    this.mBlocked = true;
                    continue;
                }
                if (this.mPendingIdleHandlers == null) {
                    this.mPendingIdleHandlers = new IdleHandler[Math.max(pendingIdleHandlerCount, 4)];
                }
                this.mPendingIdleHandlers = this.mIdleHandlers.toArray(this.mPendingIdleHandlers);
            }
            for (int i = 0; i < pendingIdleHandlerCount; ++i) {
                IdleHandler idler = this.mPendingIdleHandlers[i];
                this.mPendingIdleHandlers[i] = null;
                boolean keep = false;
                try {
                    keep = idler.queueIdle();
                }
                catch (Throwable t) {
                    Log.wtf("MessageQueue", "IdleHandler threw exception", t);
                }
                if (keep) continue;
                MessageQueue messageQueue2 = this;
                synchronized (messageQueue2) {
                    this.mIdleHandlers.remove(idler);
                    continue;
                }
            }
            pendingIdleHandlerCount = 0;
            nextPollTimeoutMillis = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$quit(boolean safe) {
        if (!this.mQuitAllowed) {
            throw new IllegalStateException("Main thread not allowed to quit.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            if (this.mQuitting) {
                return;
            }
            this.mQuitting = true;
            if (safe) {
                this.removeAllFutureMessagesLocked();
            } else {
                this.removeAllMessagesLocked();
            }
            MessageQueue.nativeWake(this.mPtr);
        }
    }

    private final int $$robo$$android_os_MessageQueue$postSyncBarrier() {
        return this.postSyncBarrier(SystemClock.uptimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final int $$robo$$android_os_MessageQueue$postSyncBarrier(long when) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            int token = this.mNextBarrierToken++;
            Message msg = Message.obtain();
            msg.markInUse();
            msg.when = when;
            msg.arg1 = token;
            Message prev = null;
            Message p = this.mMessages;
            if (when != 0L) {
                while (p != null && p.when <= when) {
                    prev = p;
                    p = p.next;
                }
            }
            if (prev != null) {
                msg.next = p;
                prev.next = msg;
            } else {
                msg.next = p;
                this.mMessages = msg;
            }
            return token;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeSyncBarrier(int token) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            Message prev = null;
            Message p = this.mMessages;
            while (p != null && (p.target != null || p.arg1 != token)) {
                prev = p;
                p = p.next;
            }
            if (p == null) {
                throw new IllegalStateException("The specified message queue synchronization  barrier token has not been posted or has already been removed.");
            }
            if (prev != null) {
                prev.next = p.next;
                needWake = false;
            } else {
                this.mMessages = p.next;
                needWake = this.mMessages == null || this.mMessages.target != null;
            }
            p.recycleUnchecked();
            if (needWake && !this.mQuitting) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$enqueueMessage(Message msg, long when) {
        if (msg.target == null) {
            throw new IllegalArgumentException("Message must have a target.");
        }
        if (msg.isInUse()) {
            throw new IllegalStateException(msg + " This message is already in use.");
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            boolean needWake;
            if (this.mQuitting) {
                IllegalStateException e = new IllegalStateException(msg.target + " sending message to a Handler on a dead thread");
                Log.w("MessageQueue", e.getMessage(), e);
                msg.recycle();
                return false;
            }
            msg.markInUse();
            msg.when = when;
            Message p = this.mMessages;
            if (p == null || when == 0L || when < p.when) {
                msg.next = p;
                this.mMessages = msg;
                needWake = this.mBlocked;
            } else {
                needWake = this.mBlocked && p.target == null && msg.isAsynchronous();
                while (true) {
                    Message prev = p;
                    p = p.next;
                    if (p == null || when < p.when) break;
                    if (!needWake || !p.isAsynchronous()) continue;
                    needWake = false;
                }
                msg.next = p;
                prev.next = msg;
            }
            if (needWake) {
                MessageQueue.nativeWake(this.mPtr);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$hasMessages(Handler h, int what, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.what == what && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$hasMessages(Handler h, Runnable r, Object object) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h && p.callback == r && (object == null || p.obj == object)) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_os_MessageQueue$hasMessages(Handler h) {
        if (h == null) {
            return false;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message p = this.mMessages;
            while (p != null) {
                if (p.target == h) {
                    return true;
                }
                p = p.next;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeMessages(Handler h, int what, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.what == what && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.what == what && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeMessages(Handler h, Runnable r, Object object) {
        if (h == null || r == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && p.callback == r && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && n.callback == r && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$removeCallbacksAndMessages(Handler h, Object object) {
        if (h == null) {
            return;
        }
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message n;
            Message p = this.mMessages;
            while (p != null && p.target == h && (object == null || p.obj == object)) {
                this.mMessages = n = p.next;
                p.recycleUnchecked();
                p = n;
            }
            while (p != null) {
                n = p.next;
                if (n != null && n.target == h && (object == null || n.obj == object)) {
                    Message nn = n.next;
                    n.recycleUnchecked();
                    p.next = nn;
                    continue;
                }
                p = n;
            }
        }
    }

    private final void $$robo$$android_os_MessageQueue$removeAllMessagesLocked() {
        Message p = this.mMessages;
        while (p != null) {
            Message n = p.next;
            p.recycleUnchecked();
            p = n;
        }
        this.mMessages = null;
    }

    private final void $$robo$$android_os_MessageQueue$removeAllFutureMessagesLocked() {
        long now = SystemClock.uptimeMillis();
        Message p = this.mMessages;
        if (p != null) {
            if (p.when > now) {
                this.removeAllMessagesLocked();
            } else {
                Message n;
                while (true) {
                    if ((n = p.next) == null) {
                        return;
                    }
                    if (n.when > now) break;
                    p = n;
                }
                p.next = null;
                do {
                    p = n;
                    n = p.next;
                    p.recycleUnchecked();
                } while (n != null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$dump(Printer pw, String prefix, Handler h) {
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            long now = SystemClock.uptimeMillis();
            int n = 0;
            Message msg = this.mMessages;
            while (msg != null) {
                if (h == null || h == msg.target) {
                    pw.println(prefix + "Message " + n + ": " + msg.toString(now));
                }
                ++n;
                msg = msg.next;
            }
            pw.println(prefix + "(Total messages: " + n + ", polling=" + this.isPollingLocked() + ", quitting=" + this.mQuitting + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_os_MessageQueue$writeToProto(ProtoOutputStream proto, long fieldId) {
        long messageQueueToken = proto.start(fieldId);
        MessageQueue messageQueue = this;
        synchronized (messageQueue) {
            Message msg = this.mMessages;
            while (msg != null) {
                msg.writeToProto(proto, 0x21100000001L);
                msg = msg.next;
            }
            proto.write(1155346202626L, this.isPollingLocked());
            proto.write(1155346202627L, this.mQuitting);
        }
        proto.end(messageQueueToken);
    }

    private static final native /* synthetic */ long $$robo$$nativeInit$nativeBinding();

    private static long nativeInit() {
        return (long)InvokeDynamicSupport.bootstrapStatic("nativeInit", $$robo$$android_os_MessageQueue$nativeInit(), 1);
    }

    private static final native /* synthetic */ void $$robo$$nativeDestroy$nativeBinding(long var0);

    private static void nativeDestroy(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeDestroy", $$robo$$android_os_MessageQueue$nativeDestroy(long ), 1, (long)l);
    }

    private final native /* synthetic */ void $$robo$$nativePollOnce$nativeBinding(long var1, int var3);

    private void nativePollOnce(long l, int n) {
        InvokeDynamicSupport.bootstrap("nativePollOnce", $$robo$$android_os_MessageQueue$nativePollOnce(long int ), 1, this, l, n);
    }

    private static final native /* synthetic */ void $$robo$$nativeWake$nativeBinding(long var0);

    private static void nativeWake(long l) {
        InvokeDynamicSupport.bootstrapStatic("nativeWake", $$robo$$android_os_MessageQueue$nativeWake(long ), 1, (long)l);
    }

    private static final native /* synthetic */ boolean $$robo$$nativeIsPolling$nativeBinding(long var0);

    private static boolean nativeIsPolling(long l) {
        return (boolean)InvokeDynamicSupport.bootstrapStatic("nativeIsPolling", $$robo$$android_os_MessageQueue$nativeIsPolling(long ), 1, (long)l);
    }

    private static final native /* synthetic */ void $$robo$$nativeSetFileDescriptorEvents$nativeBinding(long var0, int var2, int var3);

    private static void nativeSetFileDescriptorEvents(long l, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("nativeSetFileDescriptorEvents", $$robo$$android_os_MessageQueue$nativeSetFileDescriptorEvents(long int int ), 1, (long)l, (int)n, (int)n2);
    }

    private void __constructor__(boolean bl) {
        this.$$robo$$android_os_MessageQueue$__constructor__(bl);
    }

    MessageQueue(boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MessageQueue$__constructor__(boolean ), 0, this, bl);
    }

    protected void finalize() throws Throwable {
        InvokeDynamicSupport.bootstrap("finalize", $$robo$$android_os_MessageQueue$finalize(), 0, this);
    }

    private void dispose() {
        InvokeDynamicSupport.bootstrap("dispose", $$robo$$android_os_MessageQueue$dispose(), 0, this);
    }

    public boolean isIdle() {
        return (boolean)InvokeDynamicSupport.bootstrap("isIdle", $$robo$$android_os_MessageQueue$isIdle(), 0, this);
    }

    public void addIdleHandler(IdleHandler idleHandler) {
        InvokeDynamicSupport.bootstrap("addIdleHandler", $$robo$$android_os_MessageQueue$addIdleHandler(android.os.MessageQueue$IdleHandler ), 0, this, idleHandler);
    }

    public void removeIdleHandler(IdleHandler idleHandler) {
        InvokeDynamicSupport.bootstrap("removeIdleHandler", $$robo$$android_os_MessageQueue$removeIdleHandler(android.os.MessageQueue$IdleHandler ), 0, this, idleHandler);
    }

    public boolean isPolling() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPolling", $$robo$$android_os_MessageQueue$isPolling(), 0, this);
    }

    private boolean isPollingLocked() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPollingLocked", $$robo$$android_os_MessageQueue$isPollingLocked(), 0, this);
    }

    public void addOnFileDescriptorEventListener(FileDescriptor fileDescriptor, int n, OnFileDescriptorEventListener onFileDescriptorEventListener) {
        InvokeDynamicSupport.bootstrap("addOnFileDescriptorEventListener", $$robo$$android_os_MessageQueue$addOnFileDescriptorEventListener(java.io.FileDescriptor int android.os.MessageQueue$OnFileDescriptorEventListener ), 0, this, fileDescriptor, n, onFileDescriptorEventListener);
    }

    public void removeOnFileDescriptorEventListener(FileDescriptor fileDescriptor) {
        InvokeDynamicSupport.bootstrap("removeOnFileDescriptorEventListener", $$robo$$android_os_MessageQueue$removeOnFileDescriptorEventListener(java.io.FileDescriptor ), 0, this, fileDescriptor);
    }

    private void updateOnFileDescriptorEventListenerLocked(FileDescriptor fileDescriptor, int n, OnFileDescriptorEventListener onFileDescriptorEventListener) {
        InvokeDynamicSupport.bootstrap("updateOnFileDescriptorEventListenerLocked", $$robo$$android_os_MessageQueue$updateOnFileDescriptorEventListenerLocked(java.io.FileDescriptor int android.os.MessageQueue$OnFileDescriptorEventListener ), 0, this, fileDescriptor, n, onFileDescriptorEventListener);
    }

    private int dispatchEvents(int n, int n2) {
        return (int)InvokeDynamicSupport.bootstrap("dispatchEvents", $$robo$$android_os_MessageQueue$dispatchEvents(int int ), 0, this, n, n2);
    }

    Message next() {
        return InvokeDynamicSupport.bootstrap("next", $$robo$$android_os_MessageQueue$next(), 0, this);
    }

    void quit(boolean bl) {
        InvokeDynamicSupport.bootstrap("quit", $$robo$$android_os_MessageQueue$quit(boolean ), 0, this, bl);
    }

    public int postSyncBarrier() {
        return (int)InvokeDynamicSupport.bootstrap("postSyncBarrier", $$robo$$android_os_MessageQueue$postSyncBarrier(), 0, this);
    }

    private int postSyncBarrier(long l) {
        return (int)InvokeDynamicSupport.bootstrap("postSyncBarrier", $$robo$$android_os_MessageQueue$postSyncBarrier(long ), 0, this, l);
    }

    public void removeSyncBarrier(int n) {
        InvokeDynamicSupport.bootstrap("removeSyncBarrier", $$robo$$android_os_MessageQueue$removeSyncBarrier(int ), 0, this, n);
    }

    boolean enqueueMessage(Message message, long l) {
        return (boolean)InvokeDynamicSupport.bootstrap("enqueueMessage", $$robo$$android_os_MessageQueue$enqueueMessage(android.os.Message long ), 0, this, message, l);
    }

    boolean hasMessages(Handler handler, int n, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_MessageQueue$hasMessages(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    boolean hasMessages(Handler handler, Runnable runnable, Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_MessageQueue$hasMessages(android.os.Handler java.lang.Runnable java.lang.Object ), 0, this, handler, runnable, object);
    }

    boolean hasMessages(Handler handler) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasMessages", $$robo$$android_os_MessageQueue$hasMessages(android.os.Handler ), 0, this, handler);
    }

    void removeMessages(Handler handler, int n, Object object) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_os_MessageQueue$removeMessages(android.os.Handler int java.lang.Object ), 0, this, handler, n, object);
    }

    void removeMessages(Handler handler, Runnable runnable, Object object) {
        InvokeDynamicSupport.bootstrap("removeMessages", $$robo$$android_os_MessageQueue$removeMessages(android.os.Handler java.lang.Runnable java.lang.Object ), 0, this, handler, runnable, object);
    }

    void removeCallbacksAndMessages(Handler handler, Object object) {
        InvokeDynamicSupport.bootstrap("removeCallbacksAndMessages", $$robo$$android_os_MessageQueue$removeCallbacksAndMessages(android.os.Handler java.lang.Object ), 0, this, handler, object);
    }

    private void removeAllMessagesLocked() {
        InvokeDynamicSupport.bootstrap("removeAllMessagesLocked", $$robo$$android_os_MessageQueue$removeAllMessagesLocked(), 0, this);
    }

    private void removeAllFutureMessagesLocked() {
        InvokeDynamicSupport.bootstrap("removeAllFutureMessagesLocked", $$robo$$android_os_MessageQueue$removeAllFutureMessagesLocked(), 0, this);
    }

    void dump(Printer printer, String string2, Handler handler) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_os_MessageQueue$dump(android.util.Printer java.lang.String android.os.Handler ), 0, this, printer, string2, handler);
    }

    void writeToProto(ProtoOutputStream protoOutputStream, long l) {
        InvokeDynamicSupport.bootstrap("writeToProto", $$robo$$android_os_MessageQueue$writeToProto(android.util.proto.ProtoOutputStream long ), 0, this, protoOutputStream, l);
    }

    public /* synthetic */ MessageQueue() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MessageQueue)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private static final class FileDescriptorRecord
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public FileDescriptor mDescriptor;
        public int mEvents;
        public OnFileDescriptorEventListener mListener;
        public int mSeq;

        private void $$robo$$android_os_MessageQueue_FileDescriptorRecord$__constructor__(FileDescriptor descriptor, int events, OnFileDescriptorEventListener listener) {
            this.mDescriptor = descriptor;
            this.mEvents = events;
            this.mListener = listener;
        }

        private void __constructor__(FileDescriptor fileDescriptor, int n, OnFileDescriptorEventListener onFileDescriptorEventListener) {
            this.$$robo$$android_os_MessageQueue_FileDescriptorRecord$__constructor__(fileDescriptor, n, onFileDescriptorEventListener);
        }

        public FileDescriptorRecord(FileDescriptor fileDescriptor, int n, OnFileDescriptorEventListener onFileDescriptorEventListener) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_MessageQueue_FileDescriptorRecord$__constructor__(java.io.FileDescriptor int android.os.MessageQueue$OnFileDescriptorEventListener ), 0, this, fileDescriptor, n, onFileDescriptorEventListener);
        }

        public /* synthetic */ FileDescriptorRecord() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (FileDescriptorRecord)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static interface OnFileDescriptorEventListener
    extends InstrumentedInterface {
        public static final int EVENT_INPUT = 1;
        public static final int EVENT_OUTPUT = 2;
        public static final int EVENT_ERROR = 4;

        public int onFileDescriptorEvents(FileDescriptor var1, int var2);

        @Retention(value=RetentionPolicy.SOURCE)
        @IntDef(flag=true, value={1L, 2L, 4L})
        public static @interface Events {
        }
    }

    public static interface IdleHandler
    extends InstrumentedInterface {
        public boolean queueIdle();
    }
}

