/*
 * Decompiled with CFR 0.152.
 */
package android.os;

import android.content.Context;
import android.os.IIncidentManager;
import android.os.IncidentReportArgs;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.util.Slog;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class IncidentManager
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "incident";
    private Context mContext;

    private void $$robo$$android_os_IncidentManager$__constructor__(Context context) {
        this.mContext = context;
    }

    private final void $$robo$$android_os_IncidentManager$reportIncident(IncidentReportArgs args) {
        IIncidentManager service = IIncidentManager.Stub.asInterface(ServiceManager.getService("incident"));
        if (service == null) {
            Slog.e("incident", "reportIncident can't find incident binder service");
            return;
        }
        try {
            service.reportIncident(args);
        }
        catch (RemoteException ex) {
            Slog.e("incident", "reportIncident failed", ex);
        }
    }

    private final void $$robo$$android_os_IncidentManager$reportIncident(String settingName, byte[] headerProto) {
        IncidentReportArgs args;
        String setting = Settings.System.getString(this.mContext.getContentResolver(), settingName);
        try {
            args = IncidentReportArgs.parseSetting(setting);
        }
        catch (IllegalArgumentException ex) {
            Slog.w("incident", "Bad value for incident report setting '" + settingName + "'", ex);
            return;
        }
        if (args == null) {
            Slog.i("incident", "Incident report requested but disabled: " + settingName);
            return;
        }
        args.addHeader(headerProto);
        IIncidentManager service = IIncidentManager.Stub.asInterface(ServiceManager.getService("incident"));
        if (service == null) {
            Slog.e("incident", "reportIncident can't find incident binder service");
            return;
        }
        Slog.i("incident", "Taking incident report: " + settingName);
        try {
            service.reportIncident(args);
        }
        catch (RemoteException ex) {
            Slog.e("incident", "reportIncident failed", ex);
        }
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_os_IncidentManager$__constructor__(context);
    }

    public IncidentManager(Context context) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_os_IncidentManager$__constructor__(android.content.Context ), 0, this, context);
    }

    public void reportIncident(IncidentReportArgs incidentReportArgs) {
        InvokeDynamicSupport.bootstrap("reportIncident", $$robo$$android_os_IncidentManager$reportIncident(android.os.IncidentReportArgs ), 0, this, incidentReportArgs);
    }

    public void reportIncident(String string2, byte[] byArray) {
        InvokeDynamicSupport.bootstrap("reportIncident", $$robo$$android_os_IncidentManager$reportIncident(java.lang.String byte[] ), 0, this, string2, byArray);
    }

    public /* synthetic */ IncidentManager() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (IncidentManager)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

