/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.FormatException;
import android.nfc.INfcTag;
import android.nfc.NdefMessage;
import android.nfc.Tag;
import android.nfc.TagLostException;
import android.nfc.tech.BasicTagTechnology;
import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.errorprone.annotations.DoNotMock;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class Ndef
extends BasicTagTechnology
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NFC";
    public static int NDEF_MODE_READ_ONLY = 1;
    public static int NDEF_MODE_READ_WRITE = 2;
    public static int NDEF_MODE_UNKNOWN = 3;
    public static String EXTRA_NDEF_MSG = "ndefmsg";
    public static String EXTRA_NDEF_MAXLENGTH = "ndefmaxlength";
    public static String EXTRA_NDEF_CARDSTATE = "ndefcardstate";
    public static String EXTRA_NDEF_TYPE = "ndeftype";
    public static int TYPE_OTHER = -1;
    public static int TYPE_1 = 1;
    public static int TYPE_2 = 2;
    public static int TYPE_3 = 3;
    public static int TYPE_4 = 4;
    public static int TYPE_MIFARE_CLASSIC = 101;
    public static int TYPE_ICODE_SLI = 102;
    public static String UNKNOWN = "android.ndef.unknown";
    public static String NFC_FORUM_TYPE_1 = "org.nfcforum.ndef.type1";
    public static String NFC_FORUM_TYPE_2 = "org.nfcforum.ndef.type2";
    public static String NFC_FORUM_TYPE_3 = "org.nfcforum.ndef.type3";
    public static String NFC_FORUM_TYPE_4 = "org.nfcforum.ndef.type4";
    public static String MIFARE_CLASSIC = "com.nxp.ndef.mifareclassic";
    public static String ICODE_SLI = "com.nxp.ndef.icodesli";
    private int mMaxNdefSize;
    private int mCardState;
    private NdefMessage mNdefMsg;
    private int mNdefType;

    private static final Ndef $$robo$$android_nfc_tech_Ndef$get(Tag tag) {
        if (!tag.hasTech(6)) {
            return null;
        }
        try {
            return new Ndef(tag);
        }
        catch (RemoteException e) {
            return null;
        }
    }

    private void $$robo$$android_nfc_tech_Ndef$__constructor__(Tag tag) throws RemoteException {
        Bundle extras = tag.getTechExtras(6);
        if (extras == null) {
            throw new NullPointerException("NDEF tech extras are null.");
        }
        this.mMaxNdefSize = extras.getInt("ndefmaxlength");
        this.mCardState = extras.getInt("ndefcardstate");
        this.mNdefMsg = (NdefMessage)extras.getParcelable("ndefmsg");
        this.mNdefType = extras.getInt("ndeftype");
    }

    private final NdefMessage $$robo$$android_nfc_tech_Ndef$getCachedNdefMessage() {
        return this.mNdefMsg;
    }

    private final String $$robo$$android_nfc_tech_Ndef$getType() {
        switch (this.mNdefType) {
            case 1: {
                return "org.nfcforum.ndef.type1";
            }
            case 2: {
                return "org.nfcforum.ndef.type2";
            }
            case 3: {
                return "org.nfcforum.ndef.type3";
            }
            case 4: {
                return "org.nfcforum.ndef.type4";
            }
            case 101: {
                return "com.nxp.ndef.mifareclassic";
            }
            case 102: {
                return "com.nxp.ndef.icodesli";
            }
        }
        return "android.ndef.unknown";
    }

    private final int $$robo$$android_nfc_tech_Ndef$getMaxSize() {
        return this.mMaxNdefSize;
    }

    private final boolean $$robo$$android_nfc_tech_Ndef$isWritable() {
        return this.mCardState == 2;
    }

    private final NdefMessage $$robo$$android_nfc_tech_Ndef$getNdefMessage() throws IOException, FormatException {
        this.checkConnected();
        try {
            INfcTag tagService = this.mTag.getTagService();
            if (tagService == null) {
                throw new IOException("Mock tags don't support this operation.");
            }
            int serviceHandle = this.mTag.getServiceHandle();
            if (tagService.isNdef(serviceHandle)) {
                NdefMessage msg = tagService.ndefRead(serviceHandle);
                if (msg == null && !tagService.isPresent(serviceHandle)) {
                    throw new TagLostException();
                }
                return msg;
            }
            if (!tagService.isPresent(serviceHandle)) {
                throw new TagLostException();
            }
            return null;
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            return null;
        }
    }

    private final void $$robo$$android_nfc_tech_Ndef$writeNdefMessage(NdefMessage msg) throws IOException, FormatException {
        block9: {
            this.checkConnected();
            try {
                INfcTag tagService = this.mTag.getTagService();
                if (tagService == null) {
                    throw new IOException("Mock tags don't support this operation.");
                }
                int serviceHandle = this.mTag.getServiceHandle();
                if (tagService.isNdef(serviceHandle)) {
                    int errorCode = tagService.ndefWrite(serviceHandle, msg);
                    switch (errorCode) {
                        case 0: {
                            break;
                        }
                        case -1: {
                            throw new IOException();
                        }
                        case -8: {
                            throw new FormatException();
                        }
                        default: {
                            throw new IOException();
                        }
                    }
                    break block9;
                }
                throw new IOException("Tag is not ndef");
            }
            catch (RemoteException e) {
                Log.e("NFC", "NFC service dead", e);
            }
        }
    }

    private final boolean $$robo$$android_nfc_tech_Ndef$canMakeReadOnly() {
        INfcTag tagService = this.mTag.getTagService();
        if (tagService == null) {
            return false;
        }
        try {
            return tagService.canMakeReadOnly(this.mNdefType);
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            return false;
        }
    }

    private final boolean $$robo$$android_nfc_tech_Ndef$makeReadOnly() throws IOException {
        this.checkConnected();
        try {
            INfcTag tagService = this.mTag.getTagService();
            if (tagService == null) {
                return false;
            }
            if (tagService.isNdef(this.mTag.getServiceHandle())) {
                int errorCode = tagService.ndefMakeReadOnly(this.mTag.getServiceHandle());
                switch (errorCode) {
                    case 0: {
                        return true;
                    }
                    case -1: {
                        throw new IOException();
                    }
                    case -8: {
                        return false;
                    }
                }
                throw new IOException();
            }
            throw new IOException("Tag is not ndef");
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            return false;
        }
    }

    public static Ndef get(Tag tag) {
        return InvokeDynamicSupport.bootstrapStatic("get", $$robo$$android_nfc_tech_Ndef$get(android.nfc.Tag ), 0, (Tag)tag);
    }

    private void __constructor__(Tag tag) throws RemoteException {
        this.$$robo$$android_nfc_tech_Ndef$__constructor__(tag);
    }

    public Ndef(Tag tag) throws RemoteException {
        super(tag, 6);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_tech_Ndef$__constructor__(android.nfc.Tag ), 0, this, tag);
    }

    public NdefMessage getCachedNdefMessage() {
        return InvokeDynamicSupport.bootstrap("getCachedNdefMessage", $$robo$$android_nfc_tech_Ndef$getCachedNdefMessage(), 0, this);
    }

    public String getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_nfc_tech_Ndef$getType(), 0, this);
    }

    public int getMaxSize() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxSize", $$robo$$android_nfc_tech_Ndef$getMaxSize(), 0, this);
    }

    public boolean isWritable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isWritable", $$robo$$android_nfc_tech_Ndef$isWritable(), 0, this);
    }

    public NdefMessage getNdefMessage() throws IOException, FormatException {
        return InvokeDynamicSupport.bootstrap("getNdefMessage", $$robo$$android_nfc_tech_Ndef$getNdefMessage(), 0, this);
    }

    public void writeNdefMessage(NdefMessage ndefMessage) throws IOException, FormatException {
        InvokeDynamicSupport.bootstrap("writeNdefMessage", $$robo$$android_nfc_tech_Ndef$writeNdefMessage(android.nfc.NdefMessage ), 0, this, ndefMessage);
    }

    public boolean canMakeReadOnly() {
        return (boolean)InvokeDynamicSupport.bootstrap("canMakeReadOnly", $$robo$$android_nfc_tech_Ndef$canMakeReadOnly(), 0, this);
    }

    public boolean makeReadOnly() throws IOException {
        return (boolean)InvokeDynamicSupport.bootstrap("makeReadOnly", $$robo$$android_nfc_tech_Ndef$makeReadOnly(), 0, this);
    }

    public /* synthetic */ Ndef() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Ndef)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

