/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.tech;

import android.nfc.Tag;
import android.nfc.TransceiveResult;
import android.nfc.tech.TagTechnology;
import android.os.RemoteException;
import android.util.Log;
import java.io.IOException;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public abstract class BasicTagTechnology
implements TagTechnology,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "NFC";
    Tag mTag;
    boolean mIsConnected;
    int mSelectedTechnology;

    private void $$robo$$android_nfc_tech_BasicTagTechnology$__constructor__(Tag tag, int tech) throws RemoteException {
        this.mTag = tag;
        this.mSelectedTechnology = tech;
    }

    private final Tag $$robo$$android_nfc_tech_BasicTagTechnology$getTag() {
        return this.mTag;
    }

    private final void $$robo$$android_nfc_tech_BasicTagTechnology$checkConnected() {
        if (this.mTag.getConnectedTechnology() != this.mSelectedTechnology || this.mTag.getConnectedTechnology() == -1) {
            throw new IllegalStateException("Call connect() first!");
        }
    }

    private final boolean $$robo$$android_nfc_tech_BasicTagTechnology$isConnected() {
        if (!this.mIsConnected) {
            return false;
        }
        try {
            return this.mTag.getTagService().isPresent(this.mTag.getServiceHandle());
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            return false;
        }
    }

    private final void $$robo$$android_nfc_tech_BasicTagTechnology$connect() throws IOException {
        try {
            int errorCode = this.mTag.getTagService().connect(this.mTag.getServiceHandle(), this.mSelectedTechnology);
            if (errorCode != 0) {
                if (errorCode == -21) {
                    throw new UnsupportedOperationException("Connecting to this technology is not supported by the NFC adapter.");
                }
                throw new IOException();
            }
            this.mTag.setConnectedTechnology(this.mSelectedTechnology);
            this.mIsConnected = true;
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            throw new IOException("NFC service died");
        }
    }

    private final void $$robo$$android_nfc_tech_BasicTagTechnology$reconnect() throws IOException {
        if (!this.mIsConnected) {
            throw new IllegalStateException("Technology not connected yet");
        }
        try {
            int errorCode = this.mTag.getTagService().reconnect(this.mTag.getServiceHandle());
            if (errorCode != 0) {
                this.mIsConnected = false;
                this.mTag.setTechnologyDisconnected();
                throw new IOException();
            }
        }
        catch (RemoteException e) {
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
            Log.e("NFC", "NFC service dead", e);
            throw new IOException("NFC service died");
        }
    }

    private final void $$robo$$android_nfc_tech_BasicTagTechnology$close() throws IOException {
        try {
            this.mTag.getTagService().resetTimeouts();
            this.mTag.getTagService().reconnect(this.mTag.getServiceHandle());
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
        }
        finally {
            this.mIsConnected = false;
            this.mTag.setTechnologyDisconnected();
        }
    }

    private final int $$robo$$android_nfc_tech_BasicTagTechnology$getMaxTransceiveLengthInternal() {
        try {
            return this.mTag.getTagService().getMaxTransceiveLength(this.mSelectedTechnology);
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            return 0;
        }
    }

    private final byte[] $$robo$$android_nfc_tech_BasicTagTechnology$transceive(byte[] data, boolean raw2) throws IOException {
        this.checkConnected();
        try {
            TransceiveResult result = this.mTag.getTagService().transceive(this.mTag.getServiceHandle(), data, raw2);
            if (result == null) {
                throw new IOException("transceive failed");
            }
            return result.getResponseOrThrow();
        }
        catch (RemoteException e) {
            Log.e("NFC", "NFC service dead", e);
            throw new IOException("NFC service died");
        }
    }

    private void __constructor__(Tag tag, int n) throws RemoteException {
        this.$$robo$$android_nfc_tech_BasicTagTechnology$__constructor__(tag, n);
    }

    BasicTagTechnology(Tag tag, int n) throws RemoteException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_tech_BasicTagTechnology$__constructor__(android.nfc.Tag int ), 0, this, tag, n);
    }

    @Override
    public Tag getTag() {
        return InvokeDynamicSupport.bootstrap("getTag", $$robo$$android_nfc_tech_BasicTagTechnology$getTag(), 0, this);
    }

    void checkConnected() {
        InvokeDynamicSupport.bootstrap("checkConnected", $$robo$$android_nfc_tech_BasicTagTechnology$checkConnected(), 0, this);
    }

    @Override
    public boolean isConnected() {
        return (boolean)InvokeDynamicSupport.bootstrap("isConnected", $$robo$$android_nfc_tech_BasicTagTechnology$isConnected(), 0, this);
    }

    @Override
    public void connect() throws IOException {
        InvokeDynamicSupport.bootstrap("connect", $$robo$$android_nfc_tech_BasicTagTechnology$connect(), 0, this);
    }

    @Override
    public void reconnect() throws IOException {
        InvokeDynamicSupport.bootstrap("reconnect", $$robo$$android_nfc_tech_BasicTagTechnology$reconnect(), 0, this);
    }

    @Override
    public void close() throws IOException {
        InvokeDynamicSupport.bootstrap("close", $$robo$$android_nfc_tech_BasicTagTechnology$close(), 0, this);
    }

    int getMaxTransceiveLengthInternal() {
        return (int)InvokeDynamicSupport.bootstrap("getMaxTransceiveLengthInternal", $$robo$$android_nfc_tech_BasicTagTechnology$getMaxTransceiveLengthInternal(), 0, this);
    }

    byte[] transceive(byte[] byArray, boolean bl) throws IOException {
        return InvokeDynamicSupport.bootstrap("transceive", $$robo$$android_nfc_tech_BasicTagTechnology$transceive(byte[] boolean ), 0, this, byArray, bl);
    }

    public /* synthetic */ BasicTagTechnology() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (BasicTagTechnology)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

