/*
 * Decompiled with CFR 0.152.
 */
package android.nfc.cardemulation;

import android.content.ComponentName;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import android.nfc.cardemulation.AidGroup;
import android.nfc.cardemulation.CardEmulation;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.Xml;
import com.android.internal.R;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;
import org.xmlpull.v1.XmlPullParserException;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class ApduServiceInfo
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    static String TAG = "ApduServiceInfo";
    ResolveInfo mService;
    String mDescription;
    boolean mOnHost;
    HashMap<String, AidGroup> mStaticAidGroups;
    HashMap<String, AidGroup> mDynamicAidGroups;
    boolean mRequiresDeviceUnlock;
    int mBannerResourceId;
    int mUid;
    String mSettingsActivityName;
    public static Parcelable.Creator<ApduServiceInfo> CREATOR;

    private void $$robo$$android_nfc_cardemulation_ApduServiceInfo$__constructor__(ResolveInfo info, boolean onHost, String description, ArrayList<AidGroup> staticAidGroups, ArrayList<AidGroup> dynamicAidGroups, boolean requiresUnlock, int bannerResource, int uid, String settingsActivityName) {
        this.mService = info;
        this.mDescription = description;
        this.mStaticAidGroups = new HashMap();
        this.mDynamicAidGroups = new HashMap();
        this.mOnHost = onHost;
        this.mRequiresDeviceUnlock = requiresUnlock;
        for (AidGroup aidGroup : staticAidGroups) {
            this.mStaticAidGroups.put(aidGroup.category, aidGroup);
        }
        for (AidGroup aidGroup : dynamicAidGroups) {
            this.mDynamicAidGroups.put(aidGroup.category, aidGroup);
        }
        this.mBannerResourceId = bannerResource;
        this.mUid = uid;
        this.mSettingsActivityName = settingsActivityName;
    }

    private void $$robo$$android_nfc_cardemulation_ApduServiceInfo$__constructor__(PackageManager pm, ResolveInfo info, boolean onHost) throws XmlPullParserException, IOException {
        ServiceInfo si = info.serviceInfo;
        try (XmlResourceParser parser = null;){
            TypedArray sa;
            if (onHost) {
                parser = si.loadXmlMetaData(pm, "android.nfc.cardemulation.host_apdu_service");
                if (parser == null) {
                    throw new XmlPullParserException("No android.nfc.cardemulation.host_apdu_service meta-data");
                }
            } else {
                parser = si.loadXmlMetaData(pm, "android.nfc.cardemulation.off_host_apdu_service");
                if (parser == null) {
                    throw new XmlPullParserException("No android.nfc.cardemulation.off_host_apdu_service meta-data");
                }
            }
            int eventType = parser.getEventType();
            while (eventType != 2 && eventType != 1) {
                eventType = parser.next();
            }
            String tagName = parser.getName();
            if (onHost && !"host-apdu-service".equals(tagName)) {
                throw new XmlPullParserException("Meta-data does not start with <host-apdu-service> tag");
            }
            if (!onHost && !"offhost-apdu-service".equals(tagName)) {
                throw new XmlPullParserException("Meta-data does not start with <offhost-apdu-service> tag");
            }
            Resources res = pm.getResourcesForApplication(si.applicationInfo);
            AttributeSet attrs = Xml.asAttributeSet(parser);
            if (onHost) {
                sa = res.obtainAttributes(attrs, R.styleable.HostApduService);
                this.mService = info;
                this.mDescription = sa.getString(0);
                this.mRequiresDeviceUnlock = sa.getBoolean(2, false);
                this.mBannerResourceId = sa.getResourceId(3, -1);
                this.mSettingsActivityName = sa.getString(1);
                sa.recycle();
            } else {
                sa = res.obtainAttributes(attrs, R.styleable.OffHostApduService);
                this.mService = info;
                this.mDescription = sa.getString(0);
                this.mRequiresDeviceUnlock = false;
                this.mBannerResourceId = sa.getResourceId(2, -1);
                this.mSettingsActivityName = sa.getString(1);
                sa.recycle();
            }
            this.mStaticAidGroups = new HashMap();
            this.mDynamicAidGroups = new HashMap();
            this.mOnHost = onHost;
            int depth = parser.getDepth();
            AidGroup currentGroup = null;
            while (((eventType = parser.next()) != 3 || parser.getDepth() > depth) && eventType != 1) {
                String aid;
                TypedArray a;
                tagName = parser.getName();
                if (eventType == 2 && "aid-group".equals(tagName) && currentGroup == null) {
                    TypedArray groupAttrs = res.obtainAttributes(attrs, R.styleable.AidGroup);
                    String groupCategory = groupAttrs.getString(1);
                    String groupDescription = groupAttrs.getString(0);
                    if (!"payment".equals(groupCategory)) {
                        groupCategory = "other";
                    }
                    if ((currentGroup = this.mStaticAidGroups.get(groupCategory)) != null) {
                        if (!"other".equals(groupCategory)) {
                            Log.e("ApduServiceInfo", "Not allowing multiple aid-groups in the " + groupCategory + " category");
                            currentGroup = null;
                        }
                    } else {
                        currentGroup = new AidGroup(groupCategory, groupDescription);
                    }
                    groupAttrs.recycle();
                    continue;
                }
                if (eventType == 3 && "aid-group".equals(tagName) && currentGroup != null) {
                    if (currentGroup.aids.size() > 0) {
                        if (!this.mStaticAidGroups.containsKey(currentGroup.category)) {
                            this.mStaticAidGroups.put(currentGroup.category, currentGroup);
                        }
                    } else {
                        Log.e("ApduServiceInfo", "Not adding <aid-group> with empty or invalid AIDs");
                    }
                    currentGroup = null;
                    continue;
                }
                if (eventType == 2 && "aid-filter".equals(tagName) && currentGroup != null) {
                    a = res.obtainAttributes(attrs, R.styleable.AidFilter);
                    aid = a.getString(0).toUpperCase();
                    if (CardEmulation.isValidAid(aid) && !currentGroup.aids.contains(aid)) {
                        currentGroup.aids.add(aid);
                    } else {
                        Log.e("ApduServiceInfo", "Ignoring invalid or duplicate aid: " + aid);
                    }
                    a.recycle();
                    continue;
                }
                if (eventType != 2 || !"aid-prefix-filter".equals(tagName) || currentGroup == null) continue;
                a = res.obtainAttributes(attrs, R.styleable.AidFilter);
                aid = a.getString(0).toUpperCase();
                if (CardEmulation.isValidAid(aid = aid.concat("*")) && !currentGroup.aids.contains(aid)) {
                    currentGroup.aids.add(aid);
                } else {
                    Log.e("ApduServiceInfo", "Ignoring invalid or duplicate aid: " + aid);
                }
                a.recycle();
            }
        }
        this.mUid = si.applicationInfo.uid;
    }

    private final ComponentName $$robo$$android_nfc_cardemulation_ApduServiceInfo$getComponent() {
        return new ComponentName(this.mService.serviceInfo.packageName, this.mService.serviceInfo.name);
    }

    private final List<String> $$robo$$android_nfc_cardemulation_ApduServiceInfo$getAids() {
        ArrayList<String> aids = new ArrayList<String>();
        for (AidGroup group : this.getAidGroups()) {
            aids.addAll(group.aids);
        }
        return aids;
    }

    private final List<String> $$robo$$android_nfc_cardemulation_ApduServiceInfo$getPrefixAids() {
        ArrayList<String> prefixAids = new ArrayList<String>();
        for (AidGroup group : this.getAidGroups()) {
            for (String aid : group.aids) {
                if (!aid.endsWith("*")) continue;
                prefixAids.add(aid);
            }
        }
        return prefixAids;
    }

    private final AidGroup $$robo$$android_nfc_cardemulation_ApduServiceInfo$getDynamicAidGroupForCategory(String category) {
        return this.mDynamicAidGroups.get(category);
    }

    private final boolean $$robo$$android_nfc_cardemulation_ApduServiceInfo$removeDynamicAidGroupForCategory(String category) {
        return this.mDynamicAidGroups.remove(category) != null;
    }

    private final ArrayList<AidGroup> $$robo$$android_nfc_cardemulation_ApduServiceInfo$getAidGroups() {
        ArrayList<AidGroup> groups = new ArrayList<AidGroup>();
        for (Map.Entry<String, AidGroup> entry : this.mDynamicAidGroups.entrySet()) {
            groups.add(entry.getValue());
        }
        for (Map.Entry<String, AidGroup> entry : this.mStaticAidGroups.entrySet()) {
            if (this.mDynamicAidGroups.containsKey(entry.getKey())) continue;
            groups.add(entry.getValue());
        }
        return groups;
    }

    private final String $$robo$$android_nfc_cardemulation_ApduServiceInfo$getCategoryForAid(String aid) {
        ArrayList<AidGroup> groups = this.getAidGroups();
        for (AidGroup group : groups) {
            if (!group.aids.contains(aid.toUpperCase())) continue;
            return group.category;
        }
        return null;
    }

    private final boolean $$robo$$android_nfc_cardemulation_ApduServiceInfo$hasCategory(String category) {
        return this.mStaticAidGroups.containsKey(category) || this.mDynamicAidGroups.containsKey(category);
    }

    private final boolean $$robo$$android_nfc_cardemulation_ApduServiceInfo$isOnHost() {
        return this.mOnHost;
    }

    private final boolean $$robo$$android_nfc_cardemulation_ApduServiceInfo$requiresUnlock() {
        return this.mRequiresDeviceUnlock;
    }

    private final String $$robo$$android_nfc_cardemulation_ApduServiceInfo$getDescription() {
        return this.mDescription;
    }

    private final int $$robo$$android_nfc_cardemulation_ApduServiceInfo$getUid() {
        return this.mUid;
    }

    private final void $$robo$$android_nfc_cardemulation_ApduServiceInfo$setOrReplaceDynamicAidGroup(AidGroup aidGroup) {
        this.mDynamicAidGroups.put(aidGroup.getCategory(), aidGroup);
    }

    private final CharSequence $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadLabel(PackageManager pm) {
        return this.mService.loadLabel(pm);
    }

    private final CharSequence $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadAppLabel(PackageManager pm) {
        try {
            return pm.getApplicationLabel(pm.getApplicationInfo(this.mService.resolvePackageName, 128));
        }
        catch (PackageManager.NameNotFoundException e) {
            return null;
        }
    }

    private final Drawable $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadIcon(PackageManager pm) {
        return this.mService.loadIcon(pm);
    }

    private final Drawable $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadBanner(PackageManager pm) {
        try {
            Resources res = pm.getResourcesForApplication(this.mService.serviceInfo.packageName);
            Drawable banner = res.getDrawable(this.mBannerResourceId);
            return banner;
        }
        catch (Resources.NotFoundException e) {
            Log.e("ApduServiceInfo", "Could not load banner.");
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Log.e("ApduServiceInfo", "Could not load banner.");
            return null;
        }
    }

    private final String $$robo$$android_nfc_cardemulation_ApduServiceInfo$getSettingsActivityName() {
        return this.mSettingsActivityName;
    }

    private final String $$robo$$android_nfc_cardemulation_ApduServiceInfo$toString() {
        StringBuilder out = new StringBuilder("ApduService: ");
        out.append(this.getComponent());
        out.append(", description: " + this.mDescription);
        out.append(", Static AID Groups: ");
        for (AidGroup aidGroup : this.mStaticAidGroups.values()) {
            out.append(aidGroup.toString());
        }
        out.append(", Dynamic AID Groups: ");
        for (AidGroup aidGroup : this.mDynamicAidGroups.values()) {
            out.append(aidGroup.toString());
        }
        return out.toString();
    }

    private final boolean $$robo$$android_nfc_cardemulation_ApduServiceInfo$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ApduServiceInfo)) {
            return false;
        }
        ApduServiceInfo thatService = (ApduServiceInfo)o;
        return thatService.getComponent().equals(this.getComponent());
    }

    private final int $$robo$$android_nfc_cardemulation_ApduServiceInfo$hashCode() {
        return this.getComponent().hashCode();
    }

    private final int $$robo$$android_nfc_cardemulation_ApduServiceInfo$describeContents() {
        return 0;
    }

    private final void $$robo$$android_nfc_cardemulation_ApduServiceInfo$writeToParcel(Parcel dest, int flags) {
        this.mService.writeToParcel(dest, flags);
        dest.writeString(this.mDescription);
        dest.writeInt(this.mOnHost ? 1 : 0);
        dest.writeInt(this.mStaticAidGroups.size());
        if (this.mStaticAidGroups.size() > 0) {
            dest.writeTypedList(new ArrayList<AidGroup>(this.mStaticAidGroups.values()));
        }
        dest.writeInt(this.mDynamicAidGroups.size());
        if (this.mDynamicAidGroups.size() > 0) {
            dest.writeTypedList(new ArrayList<AidGroup>(this.mDynamicAidGroups.values()));
        }
        dest.writeInt(this.mRequiresDeviceUnlock ? 1 : 0);
        dest.writeInt(this.mBannerResourceId);
        dest.writeInt(this.mUid);
        dest.writeString(this.mSettingsActivityName);
    }

    private final void $$robo$$android_nfc_cardemulation_ApduServiceInfo$dump(FileDescriptor fd, PrintWriter pw, String[] args) {
        pw.println("    " + this.getComponent() + " (Description: " + this.getDescription() + ")");
        pw.println("    Static AID groups:");
        for (AidGroup group : this.mStaticAidGroups.values()) {
            pw.println("        Category: " + group.category);
            for (String aid : group.aids) {
                pw.println("            AID: " + aid);
            }
        }
        pw.println("    Dynamic AID groups:");
        for (AidGroup group : this.mDynamicAidGroups.values()) {
            pw.println("        Category: " + group.category);
            for (String aid : group.aids) {
                pw.println("            AID: " + aid);
            }
        }
        pw.println("    Settings Activity: " + this.mSettingsActivityName);
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<ApduServiceInfo>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_nfc_cardemulation_ApduServiceInfo_1$__constructor__() {
            }

            private final ApduServiceInfo $$robo$$android_nfc_cardemulation_ApduServiceInfo_1$createFromParcel(Parcel source) {
                ResolveInfo info = ResolveInfo.CREATOR.createFromParcel(source);
                String description = source.readString();
                boolean onHost = source.readInt() != 0;
                ArrayList<AidGroup> staticAidGroups = new ArrayList<AidGroup>();
                int numStaticGroups = source.readInt();
                if (numStaticGroups > 0) {
                    source.readTypedList(staticAidGroups, AidGroup.CREATOR);
                }
                ArrayList<AidGroup> dynamicAidGroups = new ArrayList<AidGroup>();
                int numDynamicGroups = source.readInt();
                if (numDynamicGroups > 0) {
                    source.readTypedList(dynamicAidGroups, AidGroup.CREATOR);
                }
                boolean requiresUnlock = source.readInt() != 0;
                int bannerResource = source.readInt();
                int uid = source.readInt();
                String settingsActivityName = source.readString();
                return new ApduServiceInfo(info, onHost, description, staticAidGroups, dynamicAidGroups, requiresUnlock, bannerResource, uid, settingsActivityName);
            }

            private final ApduServiceInfo[] $$robo$$android_nfc_cardemulation_ApduServiceInfo_1$newArray(int size) {
                return new ApduServiceInfo[size];
            }

            private void __constructor__() {
                this.$$robo$$android_nfc_cardemulation_ApduServiceInfo_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_ApduServiceInfo_1$__constructor__(), 0, this);
            }

            @Override
            public ApduServiceInfo createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_nfc_cardemulation_ApduServiceInfo_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public ApduServiceInfo[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_nfc_cardemulation_ApduServiceInfo_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(ResolveInfo resolveInfo, boolean bl, String string2, ArrayList<AidGroup> arrayList, ArrayList<AidGroup> arrayList2, boolean bl2, int n, int n2, String string3) {
        this.$$robo$$android_nfc_cardemulation_ApduServiceInfo$__constructor__(resolveInfo, bl, string2, arrayList, arrayList2, bl2, n, n2, string3);
    }

    public ApduServiceInfo(ResolveInfo resolveInfo, boolean bl, String string2, ArrayList<AidGroup> arrayList, ArrayList<AidGroup> arrayList2, boolean bl2, int n, int n2, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_ApduServiceInfo$__constructor__(android.content.pm.ResolveInfo boolean java.lang.String java.util.ArrayList<android.nfc.cardemulation.AidGroup> java.util.ArrayList<android.nfc.cardemulation.AidGroup> boolean int int java.lang.String ), 0, this, resolveInfo, bl, string2, arrayList, arrayList2, bl2, n, n2, string3);
    }

    private void __constructor__(PackageManager packageManager, ResolveInfo resolveInfo, boolean bl) throws XmlPullParserException, IOException {
        this.$$robo$$android_nfc_cardemulation_ApduServiceInfo$__constructor__(packageManager, resolveInfo, bl);
    }

    public ApduServiceInfo(PackageManager packageManager, ResolveInfo resolveInfo, boolean bl) throws XmlPullParserException, IOException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_cardemulation_ApduServiceInfo$__constructor__(android.content.pm.PackageManager android.content.pm.ResolveInfo boolean ), 0, this, packageManager, resolveInfo, bl);
    }

    public ComponentName getComponent() {
        return InvokeDynamicSupport.bootstrap("getComponent", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getComponent(), 0, this);
    }

    public List<String> getAids() {
        return InvokeDynamicSupport.bootstrap("getAids", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getAids(), 0, this);
    }

    public List<String> getPrefixAids() {
        return InvokeDynamicSupport.bootstrap("getPrefixAids", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getPrefixAids(), 0, this);
    }

    public AidGroup getDynamicAidGroupForCategory(String string2) {
        return InvokeDynamicSupport.bootstrap("getDynamicAidGroupForCategory", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getDynamicAidGroupForCategory(java.lang.String ), 0, this, string2);
    }

    public boolean removeDynamicAidGroupForCategory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeDynamicAidGroupForCategory", $$robo$$android_nfc_cardemulation_ApduServiceInfo$removeDynamicAidGroupForCategory(java.lang.String ), 0, this, string2);
    }

    public ArrayList<AidGroup> getAidGroups() {
        return InvokeDynamicSupport.bootstrap("getAidGroups", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getAidGroups(), 0, this);
    }

    public String getCategoryForAid(String string2) {
        return InvokeDynamicSupport.bootstrap("getCategoryForAid", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getCategoryForAid(java.lang.String ), 0, this, string2);
    }

    public boolean hasCategory(String string2) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasCategory", $$robo$$android_nfc_cardemulation_ApduServiceInfo$hasCategory(java.lang.String ), 0, this, string2);
    }

    public boolean isOnHost() {
        return (boolean)InvokeDynamicSupport.bootstrap("isOnHost", $$robo$$android_nfc_cardemulation_ApduServiceInfo$isOnHost(), 0, this);
    }

    public boolean requiresUnlock() {
        return (boolean)InvokeDynamicSupport.bootstrap("requiresUnlock", $$robo$$android_nfc_cardemulation_ApduServiceInfo$requiresUnlock(), 0, this);
    }

    public String getDescription() {
        return InvokeDynamicSupport.bootstrap("getDescription", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getDescription(), 0, this);
    }

    public int getUid() {
        return (int)InvokeDynamicSupport.bootstrap("getUid", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getUid(), 0, this);
    }

    public void setOrReplaceDynamicAidGroup(AidGroup aidGroup) {
        InvokeDynamicSupport.bootstrap("setOrReplaceDynamicAidGroup", $$robo$$android_nfc_cardemulation_ApduServiceInfo$setOrReplaceDynamicAidGroup(android.nfc.cardemulation.AidGroup ), 0, this, aidGroup);
    }

    public CharSequence loadLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadLabel", $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadLabel(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public CharSequence loadAppLabel(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadAppLabel", $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadAppLabel(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadIcon(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadIcon", $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadIcon(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public Drawable loadBanner(PackageManager packageManager) {
        return InvokeDynamicSupport.bootstrap("loadBanner", $$robo$$android_nfc_cardemulation_ApduServiceInfo$loadBanner(android.content.pm.PackageManager ), 0, this, packageManager);
    }

    public String getSettingsActivityName() {
        return InvokeDynamicSupport.bootstrap("getSettingsActivityName", $$robo$$android_nfc_cardemulation_ApduServiceInfo$getSettingsActivityName(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_nfc_cardemulation_ApduServiceInfo$toString(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_nfc_cardemulation_ApduServiceInfo$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_nfc_cardemulation_ApduServiceInfo$hashCode(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_nfc_cardemulation_ApduServiceInfo$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_nfc_cardemulation_ApduServiceInfo$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_nfc_cardemulation_ApduServiceInfo$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    static {
        RobolectricInternals.classInitializing(ApduServiceInfo.class);
    }

    public /* synthetic */ ApduServiceInfo() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ApduServiceInfo)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

