/*
 * Decompiled with CFR 0.152.
 */
package android.nfc;

import android.content.Intent;
import android.net.Uri;
import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class NdefRecord
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static short TNF_EMPTY = 0;
    public static short TNF_WELL_KNOWN = 1;
    public static short TNF_MIME_MEDIA = 2;
    public static short TNF_ABSOLUTE_URI = 3;
    public static short TNF_EXTERNAL_TYPE = 4;
    public static short TNF_UNKNOWN = 5;
    public static short TNF_UNCHANGED = 6;
    public static short TNF_RESERVED = 7;
    public static byte[] RTD_TEXT;
    public static byte[] RTD_URI;
    public static byte[] RTD_SMART_POSTER;
    public static byte[] RTD_ALTERNATIVE_CARRIER;
    public static byte[] RTD_HANDOVER_CARRIER;
    public static byte[] RTD_HANDOVER_REQUEST;
    public static byte[] RTD_HANDOVER_SELECT;
    public static byte[] RTD_ANDROID_APP;
    private static byte FLAG_MB = -128;
    private static byte FLAG_ME = 64;
    private static byte FLAG_CF = 32;
    private static byte FLAG_SR = 16;
    private static byte FLAG_IL = 8;
    private static String[] URI_PREFIX_MAP;
    private static int MAX_PAYLOAD_SIZE = 0xA00000;
    private static byte[] EMPTY_BYTE_ARRAY;
    private short mTnf;
    private byte[] mType;
    private byte[] mId;
    private byte[] mPayload;
    public static Parcelable.Creator<NdefRecord> CREATOR;

    private static final NdefRecord $$robo$$android_nfc_NdefRecord$createApplicationRecord(String packageName) {
        if (packageName == null) {
            throw new NullPointerException("packageName is null");
        }
        if (packageName.length() == 0) {
            throw new IllegalArgumentException("packageName is empty");
        }
        return new NdefRecord(4, RTD_ANDROID_APP, null, packageName.getBytes(StandardCharsets.UTF_8));
    }

    private static final NdefRecord $$robo$$android_nfc_NdefRecord$createUri(Uri uri) {
        if (uri == null) {
            throw new NullPointerException("uri is null");
        }
        String uriString = (uri = uri.normalizeScheme()).toString();
        if (uriString.length() == 0) {
            throw new IllegalArgumentException("uri is empty");
        }
        byte prefix = 0;
        for (int i = 1; i < URI_PREFIX_MAP.length; ++i) {
            if (!uriString.startsWith(URI_PREFIX_MAP[i])) continue;
            prefix = (byte)i;
            uriString = uriString.substring(URI_PREFIX_MAP[i].length());
            break;
        }
        byte[] uriBytes = uriString.getBytes(StandardCharsets.UTF_8);
        byte[] recordBytes = new byte[uriBytes.length + 1];
        recordBytes[0] = prefix;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])uriBytes, (int)0, (byte[])recordBytes, (int)1, (int)uriBytes.length);
        return new NdefRecord(1, RTD_URI, null, recordBytes);
    }

    private static final NdefRecord $$robo$$android_nfc_NdefRecord$createUri(String uriString) {
        return NdefRecord.createUri(Uri.parse(uriString));
    }

    private static final NdefRecord $$robo$$android_nfc_NdefRecord$createMime(String mimeType, byte[] mimeData) {
        if (mimeType == null) {
            throw new NullPointerException("mimeType is null");
        }
        if ((mimeType = Intent.normalizeMimeType(mimeType)).length() == 0) {
            throw new IllegalArgumentException("mimeType is empty");
        }
        int slashIndex = mimeType.indexOf(47);
        if (slashIndex == 0) {
            throw new IllegalArgumentException("mimeType must have major type");
        }
        if (slashIndex == mimeType.length() - 1) {
            throw new IllegalArgumentException("mimeType must have minor type");
        }
        byte[] typeBytes = mimeType.getBytes(StandardCharsets.US_ASCII);
        return new NdefRecord(2, typeBytes, null, mimeData);
    }

    private static final NdefRecord $$robo$$android_nfc_NdefRecord$createExternal(String domain, String type, byte[] data) {
        if (domain == null) {
            throw new NullPointerException("domain is null");
        }
        if (type == null) {
            throw new NullPointerException("type is null");
        }
        domain = domain.trim().toLowerCase(Locale.ROOT);
        type = type.trim().toLowerCase(Locale.ROOT);
        if (domain.length() == 0) {
            throw new IllegalArgumentException("domain is empty");
        }
        if (type.length() == 0) {
            throw new IllegalArgumentException("type is empty");
        }
        byte[] byteDomain = domain.getBytes(StandardCharsets.UTF_8);
        byte[] byteType = type.getBytes(StandardCharsets.UTF_8);
        byte[] b = new byte[byteDomain.length + 1 + byteType.length];
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])byteDomain, (int)0, (byte[])b, (int)0, (int)byteDomain.length);
        b[byteDomain.length] = 58;
        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])byteType, (int)0, (byte[])b, (int)(byteDomain.length + 1), (int)byteType.length);
        return new NdefRecord(4, b, null, data);
    }

    private static final NdefRecord $$robo$$android_nfc_NdefRecord$createTextRecord(String languageCode, String text) {
        if (text == null) {
            throw new NullPointerException("text is null");
        }
        byte[] textBytes = text.getBytes(StandardCharsets.UTF_8);
        byte[] languageCodeBytes = null;
        languageCodeBytes = languageCode != null && !languageCode.isEmpty() ? languageCode.getBytes(StandardCharsets.US_ASCII) : Locale.getDefault().getLanguage().getBytes(StandardCharsets.US_ASCII);
        if (languageCodeBytes.length >= 64) {
            throw new IllegalArgumentException("language code is too long, must be <64 bytes.");
        }
        ByteBuffer buffer = ByteBuffer.allocate(1 + languageCodeBytes.length + textBytes.length);
        byte status = (byte)(languageCodeBytes.length & 0xFF);
        buffer.put(status);
        buffer.put(languageCodeBytes);
        buffer.put(textBytes);
        return new NdefRecord(1, RTD_TEXT, null, buffer.array());
    }

    private void $$robo$$android_nfc_NdefRecord$__constructor__(short tnf, byte[] type, byte[] id2, byte[] payload) {
        String message;
        if (type == null) {
            type = EMPTY_BYTE_ARRAY;
        }
        if (id2 == null) {
            id2 = EMPTY_BYTE_ARRAY;
        }
        if (payload == null) {
            payload = EMPTY_BYTE_ARRAY;
        }
        if ((message = NdefRecord.validateTnf(tnf, type, id2, payload)) != null) {
            throw new IllegalArgumentException(message);
        }
        this.mTnf = tnf;
        this.mType = type;
        this.mId = id2;
        this.mPayload = payload;
    }

    @Deprecated
    private void $$robo$$android_nfc_NdefRecord$__constructor__(byte[] data) throws FormatException {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        NdefRecord[] rs = NdefRecord.parse(buffer, true);
        if (buffer.remaining() > 0) {
            throw new FormatException("data too long");
        }
        this.mTnf = rs[0].mTnf;
        this.mType = rs[0].mType;
        this.mId = rs[0].mId;
        this.mPayload = rs[0].mPayload;
    }

    private final short $$robo$$android_nfc_NdefRecord$getTnf() {
        return this.mTnf;
    }

    private final byte[] $$robo$$android_nfc_NdefRecord$getType() {
        return (byte[])this.mType.clone();
    }

    private final byte[] $$robo$$android_nfc_NdefRecord$getId() {
        return (byte[])this.mId.clone();
    }

    private final byte[] $$robo$$android_nfc_NdefRecord$getPayload() {
        return (byte[])this.mPayload.clone();
    }

    @Deprecated
    private final byte[] $$robo$$android_nfc_NdefRecord$toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(this.getByteLength());
        this.writeToByteBuffer(buffer, true, true);
        return buffer.array();
    }

    private final String $$robo$$android_nfc_NdefRecord$toMimeType() {
        switch (this.mTnf) {
            case 1: {
                if (!Arrays.equals(this.mType, RTD_TEXT)) break;
                return "text/plain";
            }
            case 2: {
                String mimeType = new String(this.mType, StandardCharsets.US_ASCII);
                return Intent.normalizeMimeType(mimeType);
            }
        }
        return null;
    }

    private final Uri $$robo$$android_nfc_NdefRecord$toUri() {
        return this.toUri(false);
    }

    private final Uri $$robo$$android_nfc_NdefRecord$toUri(boolean inSmartPoster) {
        switch (this.mTnf) {
            case 1: {
                if (Arrays.equals(this.mType, RTD_SMART_POSTER) && !inSmartPoster) {
                    try {
                        NdefMessage nestedMessage = new NdefMessage(this.mPayload);
                        for (NdefRecord nestedRecord : nestedMessage.getRecords()) {
                            Uri uri = nestedRecord.toUri(true);
                            if (uri == null) continue;
                            return uri;
                        }
                        break;
                    }
                    catch (FormatException nestedMessage) {
                        break;
                    }
                }
                if (!Arrays.equals(this.mType, RTD_URI)) break;
                Uri wktUri = this.parseWktUri();
                return wktUri != null ? wktUri.normalizeScheme() : null;
            }
            case 3: {
                Uri uri = Uri.parse(new String(this.mType, StandardCharsets.UTF_8));
                return uri.normalizeScheme();
            }
            case 4: {
                if (inSmartPoster) break;
                return Uri.parse("vnd.android.nfc://ext/" + new String(this.mType, StandardCharsets.US_ASCII));
            }
        }
        return null;
    }

    private final Uri $$robo$$android_nfc_NdefRecord$parseWktUri() {
        if (this.mPayload.length < 2) {
            return null;
        }
        int prefixIndex = this.mPayload[0] & 0xFFFFFFFF;
        if (prefixIndex < 0 || prefixIndex >= URI_PREFIX_MAP.length) {
            return null;
        }
        String prefix = URI_PREFIX_MAP[prefixIndex];
        String suffix = new String(Arrays.copyOfRange(this.mPayload, 1, this.mPayload.length), StandardCharsets.UTF_8);
        return Uri.parse(prefix + suffix);
    }

    private static final NdefRecord[] $$robo$$android_nfc_NdefRecord$parse(ByteBuffer buffer, boolean ignoreMbMe) throws FormatException {
        ArrayList<NdefRecord> records = new ArrayList<NdefRecord>();
        try {
            byte[] type = null;
            byte[] id2 = null;
            byte[] payload = null;
            ArrayList<byte[]> chunks = new ArrayList<byte[]>();
            boolean inChunk = false;
            int chunkTnf = -1;
            boolean me = false;
            while (!me) {
                int idLength;
                byte flag = buffer.get();
                boolean mb = (flag & 0xFFFFFF80) != 0;
                me = (flag & 0x40) != 0;
                boolean cf = (flag & 0x20) != 0;
                boolean sr = (flag & 0x10) != 0;
                boolean il = (flag & 8) != 0;
                int tnf = flag & 7;
                if (!(mb || records.size() != 0 || inChunk || ignoreMbMe)) {
                    throw new FormatException("expected MB flag");
                }
                if (mb && (records.size() != 0 || inChunk) && !ignoreMbMe) {
                    throw new FormatException("unexpected MB flag");
                }
                if (inChunk && il) {
                    throw new FormatException("unexpected IL flag in non-leading chunk");
                }
                if (cf && me) {
                    throw new FormatException("unexpected ME flag in non-trailing chunk");
                }
                if (inChunk && tnf != 6) {
                    throw new FormatException("expected TNF_UNCHANGED in non-leading chunk");
                }
                if (!inChunk && tnf == 6) {
                    throw new FormatException("unexpected TNF_UNCHANGED in first chunk or unchunked record");
                }
                int typeLength = buffer.get() & 0xFF;
                long payloadLength = sr ? (long)(buffer.get() & 0xFF) : (long)buffer.getInt() & 0xFFFFFFFFL;
                int n = idLength = il ? buffer.get() & 0xFF : 0;
                if (inChunk && typeLength != 0) {
                    throw new FormatException("expected zero-length type in non-leading chunk");
                }
                if (!inChunk) {
                    type = typeLength > 0 ? new byte[typeLength] : EMPTY_BYTE_ARRAY;
                    id2 = idLength > 0 ? new byte[idLength] : EMPTY_BYTE_ARRAY;
                    buffer.get(type);
                    buffer.get(id2);
                }
                NdefRecord.ensureSanePayloadSize(payloadLength);
                payload = payloadLength > 0L ? new byte[(int)payloadLength] : EMPTY_BYTE_ARRAY;
                buffer.get(payload);
                if (cf && !inChunk) {
                    if (typeLength == 0 && tnf != 5) {
                        throw new FormatException("expected non-zero type length in first chunk");
                    }
                    chunks.clear();
                    chunkTnf = tnf;
                }
                if (cf || inChunk) {
                    chunks.add(payload);
                }
                if (!cf && inChunk) {
                    payloadLength = 0L;
                    for (byte[] p : chunks) {
                        payloadLength += (long)p.length;
                    }
                    NdefRecord.ensureSanePayloadSize(payloadLength);
                    payload = new byte[(int)payloadLength];
                    int i = 0;
                    for (byte[] p : chunks) {
                        InvokeDynamicSupport.bootstrapIntrinsic("arraycopy", "java.lang.System", (byte[])p, (int)0, (byte[])payload, (int)i, (int)p.length);
                        i += p.length;
                    }
                    tnf = chunkTnf;
                }
                if (cf) {
                    inChunk = true;
                    continue;
                }
                inChunk = false;
                String error = NdefRecord.validateTnf((short)tnf, type, id2, payload);
                if (error != null) {
                    throw new FormatException(error);
                }
                records.add(new NdefRecord((short)tnf, type, id2, payload));
                if (!ignoreMbMe) continue;
                break;
            }
        }
        catch (BufferUnderflowException e) {
            throw new FormatException("expected more data", e);
        }
        return records.toArray(new NdefRecord[records.size()]);
    }

    private static final void $$robo$$android_nfc_NdefRecord$ensureSanePayloadSize(long size) throws FormatException {
        if (size > 0xA00000L) {
            throw new FormatException("payload above max limit: " + size + " > " + 0xA00000);
        }
    }

    private static final String $$robo$$android_nfc_NdefRecord$validateTnf(short tnf, byte[] type, byte[] id2, byte[] payload) {
        switch (tnf) {
            case 0: {
                if (type.length != 0 || id2.length != 0 || payload.length != 0) {
                    return "unexpected data in TNF_EMPTY record";
                }
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
            case 5: 
            case 7: {
                if (type.length != 0) {
                    return "unexpected type field in TNF_UNKNOWN or TNF_RESERVEd record";
                }
                return null;
            }
            case 6: {
                return "unexpected TNF_UNCHANGED in first chunk or logical record";
            }
        }
        return String.format("unexpected tnf value: 0x%02x", tnf);
    }

    private final void $$robo$$android_nfc_NdefRecord$writeToByteBuffer(ByteBuffer buffer, boolean mb, boolean me) {
        boolean sr;
        boolean bl = sr = this.mPayload.length < 256;
        boolean il = this.mTnf == 0 ? true : this.mId.length > 0;
        byte flags = (byte)((mb ? -128 : 0) | (me ? 64 : 0) | (sr ? 16 : 0) | (il ? 8 : 0) | this.mTnf);
        buffer.put(flags);
        buffer.put((byte)this.mType.length);
        if (sr) {
            buffer.put((byte)this.mPayload.length);
        } else {
            buffer.putInt(this.mPayload.length);
        }
        if (il) {
            buffer.put((byte)this.mId.length);
        }
        buffer.put(this.mType);
        buffer.put(this.mId);
        buffer.put(this.mPayload);
    }

    private final int $$robo$$android_nfc_NdefRecord$getByteLength() {
        boolean il;
        boolean sr;
        int length = 3 + this.mType.length + this.mId.length + this.mPayload.length;
        boolean bl = sr = this.mPayload.length < 256;
        boolean bl2 = this.mTnf == 0 ? true : (il = this.mId.length > 0);
        if (!sr) {
            length += 3;
        }
        if (il) {
            ++length;
        }
        return length;
    }

    private final int $$robo$$android_nfc_NdefRecord$describeContents() {
        return 0;
    }

    private final void $$robo$$android_nfc_NdefRecord$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mTnf);
        dest.writeInt(this.mType.length);
        dest.writeByteArray(this.mType);
        dest.writeInt(this.mId.length);
        dest.writeByteArray(this.mId);
        dest.writeInt(this.mPayload.length);
        dest.writeByteArray(this.mPayload);
    }

    private final int $$robo$$android_nfc_NdefRecord$hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.mId);
        result = 31 * result + Arrays.hashCode(this.mPayload);
        result = 31 * result + this.mTnf;
        result = 31 * result + Arrays.hashCode(this.mType);
        return result;
    }

    private final boolean $$robo$$android_nfc_NdefRecord$equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NdefRecord other = (NdefRecord)obj;
        if (!Arrays.equals(this.mId, other.mId)) {
            return false;
        }
        if (!Arrays.equals(this.mPayload, other.mPayload)) {
            return false;
        }
        if (this.mTnf != other.mTnf) {
            return false;
        }
        return Arrays.equals(this.mType, other.mType);
    }

    private final String $$robo$$android_nfc_NdefRecord$toString() {
        StringBuilder b = new StringBuilder(String.format("NdefRecord tnf=%X", this.mTnf));
        if (this.mType.length > 0) {
            b.append(" type=").append((CharSequence)NdefRecord.bytesToString(this.mType));
        }
        if (this.mId.length > 0) {
            b.append(" id=").append((CharSequence)NdefRecord.bytesToString(this.mId));
        }
        if (this.mPayload.length > 0) {
            b.append(" payload=").append((CharSequence)NdefRecord.bytesToString(this.mPayload));
        }
        return b.toString();
    }

    private static final StringBuilder $$robo$$android_nfc_NdefRecord$bytesToString(byte[] bs) {
        StringBuilder s = new StringBuilder();
        for (byte b : bs) {
            s.append(String.format("%02X", b));
        }
        return s;
    }

    static void __staticInitializer__() {
        RTD_TEXT = new byte[]{84};
        RTD_URI = new byte[]{85};
        RTD_SMART_POSTER = new byte[]{83, 112};
        RTD_ALTERNATIVE_CARRIER = new byte[]{97, 99};
        RTD_HANDOVER_CARRIER = new byte[]{72, 99};
        RTD_HANDOVER_REQUEST = new byte[]{72, 114};
        RTD_HANDOVER_SELECT = new byte[]{72, 115};
        RTD_ANDROID_APP = "android.com:pkg".getBytes();
        URI_PREFIX_MAP = new String[]{"", "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:", "urn:nfc:"};
        EMPTY_BYTE_ARRAY = new byte[0];
        CREATOR = new Parcelable.Creator<NdefRecord>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_nfc_NdefRecord_1$__constructor__() {
            }

            private final NdefRecord $$robo$$android_nfc_NdefRecord_1$createFromParcel(Parcel in) {
                short tnf = (short)in.readInt();
                int typeLength = in.readInt();
                byte[] type = new byte[typeLength];
                in.readByteArray(type);
                int idLength = in.readInt();
                byte[] id2 = new byte[idLength];
                in.readByteArray(id2);
                int payloadLength = in.readInt();
                byte[] payload = new byte[payloadLength];
                in.readByteArray(payload);
                return new NdefRecord(tnf, type, id2, payload);
            }

            private final NdefRecord[] $$robo$$android_nfc_NdefRecord_1$newArray(int size) {
                return new NdefRecord[size];
            }

            private void __constructor__() {
                this.$$robo$$android_nfc_NdefRecord_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NdefRecord_1$__constructor__(), 0, this);
            }

            @Override
            public NdefRecord createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_nfc_NdefRecord_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NdefRecord[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_nfc_NdefRecord_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static NdefRecord createApplicationRecord(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createApplicationRecord", $$robo$$android_nfc_NdefRecord$createApplicationRecord(java.lang.String ), 0, (String)string2);
    }

    public static NdefRecord createUri(Uri uri) {
        return InvokeDynamicSupport.bootstrapStatic("createUri", $$robo$$android_nfc_NdefRecord$createUri(android.net.Uri ), 0, (Uri)uri);
    }

    public static NdefRecord createUri(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("createUri", $$robo$$android_nfc_NdefRecord$createUri(java.lang.String ), 0, (String)string2);
    }

    public static NdefRecord createMime(String string2, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createMime", $$robo$$android_nfc_NdefRecord$createMime(java.lang.String byte[] ), 0, (String)string2, (byte[])byArray);
    }

    public static NdefRecord createExternal(String string2, String string3, byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("createExternal", $$robo$$android_nfc_NdefRecord$createExternal(java.lang.String java.lang.String byte[] ), 0, (String)string2, (String)string3, (byte[])byArray);
    }

    public static NdefRecord createTextRecord(String string2, String string3) {
        return InvokeDynamicSupport.bootstrapStatic("createTextRecord", $$robo$$android_nfc_NdefRecord$createTextRecord(java.lang.String java.lang.String ), 0, (String)string2, (String)string3);
    }

    private void __constructor__(short s, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.$$robo$$android_nfc_NdefRecord$__constructor__(s, byArray, byArray2, byArray3);
    }

    public NdefRecord(short s, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NdefRecord$__constructor__(short byte[] byte[] byte[] ), 0, this, s, byArray, byArray2, byArray3);
    }

    private void __constructor__(byte[] byArray) throws FormatException {
        this.$$robo$$android_nfc_NdefRecord$__constructor__(byArray);
    }

    public NdefRecord(byte[] byArray) throws FormatException {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_nfc_NdefRecord$__constructor__(byte[] ), 0, this, byArray);
    }

    public short getTnf() {
        return (short)InvokeDynamicSupport.bootstrap("getTnf", $$robo$$android_nfc_NdefRecord$getTnf(), 0, this);
    }

    public byte[] getType() {
        return InvokeDynamicSupport.bootstrap("getType", $$robo$$android_nfc_NdefRecord$getType(), 0, this);
    }

    public byte[] getId() {
        return InvokeDynamicSupport.bootstrap("getId", $$robo$$android_nfc_NdefRecord$getId(), 0, this);
    }

    public byte[] getPayload() {
        return InvokeDynamicSupport.bootstrap("getPayload", $$robo$$android_nfc_NdefRecord$getPayload(), 0, this);
    }

    @Deprecated
    public byte[] toByteArray() {
        return InvokeDynamicSupport.bootstrap("toByteArray", $$robo$$android_nfc_NdefRecord$toByteArray(), 0, this);
    }

    public String toMimeType() {
        return InvokeDynamicSupport.bootstrap("toMimeType", $$robo$$android_nfc_NdefRecord$toMimeType(), 0, this);
    }

    public Uri toUri() {
        return InvokeDynamicSupport.bootstrap("toUri", $$robo$$android_nfc_NdefRecord$toUri(), 0, this);
    }

    private Uri toUri(boolean bl) {
        return InvokeDynamicSupport.bootstrap("toUri", $$robo$$android_nfc_NdefRecord$toUri(boolean ), 0, this, bl);
    }

    private Uri parseWktUri() {
        return InvokeDynamicSupport.bootstrap("parseWktUri", $$robo$$android_nfc_NdefRecord$parseWktUri(), 0, this);
    }

    static NdefRecord[] parse(ByteBuffer byteBuffer, boolean bl) throws FormatException {
        return InvokeDynamicSupport.bootstrapStatic("parse", $$robo$$android_nfc_NdefRecord$parse(java.nio.ByteBuffer boolean ), 0, (ByteBuffer)byteBuffer, (boolean)bl);
    }

    private static void ensureSanePayloadSize(long l) throws FormatException {
        InvokeDynamicSupport.bootstrapStatic("ensureSanePayloadSize", $$robo$$android_nfc_NdefRecord$ensureSanePayloadSize(long ), 0, (long)l);
    }

    static String validateTnf(short s, byte[] byArray, byte[] byArray2, byte[] byArray3) {
        return InvokeDynamicSupport.bootstrapStatic("validateTnf", $$robo$$android_nfc_NdefRecord$validateTnf(short byte[] byte[] byte[] ), 0, (short)s, (byte[])byArray, (byte[])byArray2, (byte[])byArray3);
    }

    void writeToByteBuffer(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        InvokeDynamicSupport.bootstrap("writeToByteBuffer", $$robo$$android_nfc_NdefRecord$writeToByteBuffer(java.nio.ByteBuffer boolean boolean ), 0, this, byteBuffer, bl, bl2);
    }

    int getByteLength() {
        return (int)InvokeDynamicSupport.bootstrap("getByteLength", $$robo$$android_nfc_NdefRecord$getByteLength(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_nfc_NdefRecord$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_nfc_NdefRecord$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_nfc_NdefRecord$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_nfc_NdefRecord$equals(java.lang.Object ), 0, this, object);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_nfc_NdefRecord$toString(), 0, this);
    }

    private static StringBuilder bytesToString(byte[] byArray) {
        return InvokeDynamicSupport.bootstrapStatic("bytesToString", $$robo$$android_nfc_NdefRecord$bytesToString(byte[] ), 0, (byte[])byArray);
    }

    static {
        RobolectricInternals.classInitializing(NdefRecord.class);
    }

    public /* synthetic */ NdefRecord() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NdefRecord)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

