/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi.aware;

import android.annotation.IntDef;
import android.net.wifi.aware.Characteristics;
import android.net.wifi.aware.TlvBufferUtils;
import android.net.wifi.aware.WifiAwareUtils;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.errorprone.annotations.DoNotMock;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import libcore.util.HexEncoding;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

@DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
public class PublishConfig
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static int PUBLISH_TYPE_UNSOLICITED = 0;
    public static int PUBLISH_TYPE_SOLICITED = 1;
    public byte[] mServiceName;
    public byte[] mServiceSpecificInfo;
    public byte[] mMatchFilter;
    public int mPublishType;
    public int mTtlSec;
    public boolean mEnableTerminateNotification;
    public static Parcelable.Creator<PublishConfig> CREATOR;

    private void $$robo$$android_net_wifi_aware_PublishConfig$__constructor__(byte[] serviceName, byte[] serviceSpecificInfo, byte[] matchFilter, int publishType, int ttlSec, boolean enableTerminateNotification) {
        this.mServiceName = serviceName;
        this.mServiceSpecificInfo = serviceSpecificInfo;
        this.mMatchFilter = matchFilter;
        this.mPublishType = publishType;
        this.mTtlSec = ttlSec;
        this.mEnableTerminateNotification = enableTerminateNotification;
    }

    private final String $$robo$$android_net_wifi_aware_PublishConfig$toString() {
        return "PublishConfig [mServiceName='" + this.mServiceName + ", mServiceSpecificInfo='" + (this.mServiceSpecificInfo == null ? "null" : (Object)HexEncoding.encode(this.mServiceSpecificInfo)) + ", mMatchFilter=" + new TlvBufferUtils.TlvIterable(0, 1, this.mMatchFilter).toString() + ", mPublishType=" + this.mPublishType + ", mTtlSec=" + this.mTtlSec + ", mEnableTerminateNotification=" + this.mEnableTerminateNotification + "]";
    }

    private final int $$robo$$android_net_wifi_aware_PublishConfig$describeContents() {
        return 0;
    }

    private final void $$robo$$android_net_wifi_aware_PublishConfig$writeToParcel(Parcel dest, int flags) {
        dest.writeByteArray(this.mServiceName);
        dest.writeByteArray(this.mServiceSpecificInfo);
        dest.writeByteArray(this.mMatchFilter);
        dest.writeInt(this.mPublishType);
        dest.writeInt(this.mTtlSec);
        dest.writeInt(this.mEnableTerminateNotification ? 1 : 0);
    }

    private final boolean $$robo$$android_net_wifi_aware_PublishConfig$equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PublishConfig)) {
            return false;
        }
        PublishConfig lhs = (PublishConfig)o;
        return Arrays.equals(this.mServiceName, lhs.mServiceName) && Arrays.equals(this.mServiceSpecificInfo, lhs.mServiceSpecificInfo) && Arrays.equals(this.mMatchFilter, lhs.mMatchFilter) && this.mPublishType == lhs.mPublishType && this.mTtlSec == lhs.mTtlSec && this.mEnableTerminateNotification == lhs.mEnableTerminateNotification;
    }

    private final int $$robo$$android_net_wifi_aware_PublishConfig$hashCode() {
        int result = 17;
        result = 31 * result + Arrays.hashCode(this.mServiceName);
        result = 31 * result + Arrays.hashCode(this.mServiceSpecificInfo);
        result = 31 * result + Arrays.hashCode(this.mMatchFilter);
        result = 31 * result + this.mPublishType;
        result = 31 * result + this.mTtlSec;
        result = 31 * result + (this.mEnableTerminateNotification ? 1 : 0);
        return result;
    }

    private final void $$robo$$android_net_wifi_aware_PublishConfig$assertValid(Characteristics characteristics) throws IllegalArgumentException {
        WifiAwareUtils.validateServiceName(this.mServiceName);
        if (!TlvBufferUtils.isValid(this.mMatchFilter, 0, 1)) {
            throw new IllegalArgumentException("Invalid txFilter configuration - LV fields do not match up to length");
        }
        if (this.mPublishType < 0 || this.mPublishType > 1) {
            throw new IllegalArgumentException("Invalid publishType - " + this.mPublishType);
        }
        if (this.mTtlSec < 0) {
            throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
        }
        if (characteristics != null) {
            int maxServiceNameLength = characteristics.getMaxServiceNameLength();
            if (maxServiceNameLength != 0 && this.mServiceName.length > maxServiceNameLength) {
                throw new IllegalArgumentException("Service name longer than supported by device characteristics");
            }
            int maxServiceSpecificInfoLength = characteristics.getMaxServiceSpecificInfoLength();
            if (maxServiceSpecificInfoLength != 0 && this.mServiceSpecificInfo != null && this.mServiceSpecificInfo.length > maxServiceSpecificInfoLength) {
                throw new IllegalArgumentException("Service specific info longer than supported by device characteristics");
            }
            int maxMatchFilterLength = characteristics.getMaxMatchFilterLength();
            if (maxMatchFilterLength != 0 && this.mMatchFilter != null && this.mMatchFilter.length > maxMatchFilterLength) {
                throw new IllegalArgumentException("Match filter longer than supported by device characteristics");
            }
        }
    }

    static void __staticInitializer__() {
        CREATOR = new Parcelable.Creator<PublishConfig>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_wifi_aware_PublishConfig_1$__constructor__() {
            }

            private final PublishConfig[] $$robo$$android_net_wifi_aware_PublishConfig_1$newArray(int size) {
                return new PublishConfig[size];
            }

            private final PublishConfig $$robo$$android_net_wifi_aware_PublishConfig_1$createFromParcel(Parcel in) {
                byte[] serviceName = in.createByteArray();
                byte[] ssi = in.createByteArray();
                byte[] matchFilter = in.createByteArray();
                int publishType = in.readInt();
                int ttlSec = in.readInt();
                boolean enableTerminateNotification = in.readInt() != 0;
                return new PublishConfig(serviceName, ssi, matchFilter, publishType, ttlSec, enableTerminateNotification);
            }

            private void __constructor__() {
                this.$$robo$$android_net_wifi_aware_PublishConfig_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_PublishConfig_1$__constructor__(), 0, this);
            }

            public PublishConfig[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_wifi_aware_PublishConfig_1$newArray(int ), 0, this, n);
            }

            @Override
            public PublishConfig createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_wifi_aware_PublishConfig_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    private void __constructor__(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, boolean bl) {
        this.$$robo$$android_net_wifi_aware_PublishConfig$__constructor__(byArray, byArray2, byArray3, n, n2, bl);
    }

    public PublishConfig(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2, boolean bl) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_PublishConfig$__constructor__(byte[] byte[] byte[] int int boolean ), 0, this, byArray, byArray2, byArray3, n, n2, bl);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_wifi_aware_PublishConfig$toString(), 0, this);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_wifi_aware_PublishConfig$describeContents(), 0, this);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_wifi_aware_PublishConfig$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_wifi_aware_PublishConfig$equals(java.lang.Object ), 0, this, object);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_wifi_aware_PublishConfig$hashCode(), 0, this);
    }

    public void assertValid(Characteristics characteristics) throws IllegalArgumentException {
        InvokeDynamicSupport.bootstrap("assertValid", $$robo$$android_net_wifi_aware_PublishConfig$assertValid(android.net.wifi.aware.Characteristics ), 0, this, characteristics);
    }

    static {
        RobolectricInternals.classInitializing(PublishConfig.class);
    }

    public /* synthetic */ PublishConfig() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (PublishConfig)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    public static final class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private byte[] mServiceName;
        private byte[] mServiceSpecificInfo;
        private byte[] mMatchFilter;
        private int mPublishType;
        private int mTtlSec;
        private boolean mEnableTerminateNotification;

        private void $$robo$$android_net_wifi_aware_PublishConfig_Builder$__constructor__() {
            this.mPublishType = 0;
            this.mTtlSec = 0;
            this.mEnableTerminateNotification = true;
        }

        private final Builder $$robo$$android_net_wifi_aware_PublishConfig_Builder$setServiceName(String serviceName) {
            if (serviceName == null) {
                throw new IllegalArgumentException("Invalid service name - must be non-null");
            }
            this.mServiceName = serviceName.getBytes(StandardCharsets.UTF_8);
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_PublishConfig_Builder$setServiceSpecificInfo(byte[] serviceSpecificInfo) {
            this.mServiceSpecificInfo = serviceSpecificInfo;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_PublishConfig_Builder$setMatchFilter(List<byte[]> matchFilter) {
            this.mMatchFilter = new TlvBufferUtils.TlvConstructor(0, 1).allocateAndPut(matchFilter).getArray();
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_PublishConfig_Builder$setPublishType(int publishType) {
            if (publishType < 0 || publishType > 1) {
                throw new IllegalArgumentException("Invalid publishType - " + publishType);
            }
            this.mPublishType = publishType;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_PublishConfig_Builder$setTtlSec(int ttlSec) {
            if (ttlSec < 0) {
                throw new IllegalArgumentException("Invalid ttlSec - must be non-negative");
            }
            this.mTtlSec = ttlSec;
            return this;
        }

        private final Builder $$robo$$android_net_wifi_aware_PublishConfig_Builder$setTerminateNotificationEnabled(boolean enable) {
            this.mEnableTerminateNotification = enable;
            return this;
        }

        private final PublishConfig $$robo$$android_net_wifi_aware_PublishConfig_Builder$build() {
            return new PublishConfig(this.mServiceName, this.mServiceSpecificInfo, this.mMatchFilter, this.mPublishType, this.mTtlSec, this.mEnableTerminateNotification);
        }

        private void __constructor__() {
            this.$$robo$$android_net_wifi_aware_PublishConfig_Builder$__constructor__();
        }

        public Builder() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_aware_PublishConfig_Builder$__constructor__(), 0, this);
        }

        public Builder setServiceName(String string2) {
            return InvokeDynamicSupport.bootstrap("setServiceName", $$robo$$android_net_wifi_aware_PublishConfig_Builder$setServiceName(java.lang.String ), 0, this, string2);
        }

        public Builder setServiceSpecificInfo(byte[] byArray) {
            return InvokeDynamicSupport.bootstrap("setServiceSpecificInfo", $$robo$$android_net_wifi_aware_PublishConfig_Builder$setServiceSpecificInfo(byte[] ), 0, this, byArray);
        }

        public Builder setMatchFilter(List<byte[]> list) {
            return InvokeDynamicSupport.bootstrap("setMatchFilter", $$robo$$android_net_wifi_aware_PublishConfig_Builder$setMatchFilter(java.util.List<byte[]> ), 0, this, list);
        }

        public Builder setPublishType(int n) {
            return InvokeDynamicSupport.bootstrap("setPublishType", $$robo$$android_net_wifi_aware_PublishConfig_Builder$setPublishType(int ), 0, this, n);
        }

        public Builder setTtlSec(int n) {
            return InvokeDynamicSupport.bootstrap("setTtlSec", $$robo$$android_net_wifi_aware_PublishConfig_Builder$setTtlSec(int ), 0, this, n);
        }

        public Builder setTerminateNotificationEnabled(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setTerminateNotificationEnabled", $$robo$$android_net_wifi_aware_PublishConfig_Builder$setTerminateNotificationEnabled(boolean ), 0, this, bl);
        }

        public PublishConfig build() {
            return InvokeDynamicSupport.bootstrap("build", $$robo$$android_net_wifi_aware_PublishConfig_Builder$build(), 0, this);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    @IntDef(value={0L, 1L})
    public static @interface PublishTypes {
    }
}

