/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.content.Context;
import android.net.INetworkScoreCache;
import android.net.NetworkKey;
import android.net.ScoredNetwork;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiManager;
import android.os.Handler;
import android.os.Process;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.util.Preconditions;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class WifiNetworkScoreCache
extends INetworkScoreCache.Stub
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG = "WifiNetworkScoreCache";
    private static boolean DBG;
    public static int INVALID_NETWORK_SCORE = -128;
    @GuardedBy(value="mCacheLock")
    private CacheListener mListener;
    private Context mContext;
    private Object mCacheLock;
    private Map<String, ScoredNetwork> mNetworkCache;

    private void $$robo$$android_net_wifi_WifiNetworkScoreCache$__constructor__(Context context) {
    }

    private void $$robo$$android_net_wifi_WifiNetworkScoreCache$__constructor__(Context context, CacheListener listener) {
        this.mCacheLock = new Object();
        this.mContext = context.getApplicationContext();
        this.mListener = listener;
        this.mNetworkCache = new HashMap<String, ScoredNetwork>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiNetworkScoreCache$updateScores(List<ScoredNetwork> networks) {
        if (networks == null || networks.isEmpty()) {
            return;
        }
        if (DBG) {
            Log.d("WifiNetworkScoreCache", "updateScores list size=" + networks.size());
        }
        boolean changed = false;
        Object object = this.mNetworkCache;
        synchronized (object) {
            for (ScoredNetwork network : networks) {
                String networkKey = this.buildNetworkKey(network);
                if (networkKey == null) {
                    if (!DBG) continue;
                    Log.d("WifiNetworkScoreCache", "Failed to build network key for ScoredNetwork" + network);
                    continue;
                }
                this.mNetworkCache.put(networkKey, network);
                changed = true;
            }
        }
        object = this.mCacheLock;
        synchronized (object) {
            if (this.mListener != null && changed) {
                this.mListener.post(networks);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiNetworkScoreCache$clearScores() {
        Map<String, ScoredNetwork> map = this.mNetworkCache;
        synchronized (map) {
            this.mNetworkCache.clear();
        }
    }

    private final boolean $$robo$$android_net_wifi_WifiNetworkScoreCache$isScoredNetwork(ScanResult result) {
        return this.getScoredNetwork(result) != null;
    }

    private final boolean $$robo$$android_net_wifi_WifiNetworkScoreCache$hasScoreCurve(ScanResult result) {
        ScoredNetwork network = this.getScoredNetwork(result);
        return network != null && network.rssiCurve != null;
    }

    private final int $$robo$$android_net_wifi_WifiNetworkScoreCache$getNetworkScore(ScanResult result) {
        int score = -128;
        ScoredNetwork network = this.getScoredNetwork(result);
        if (network != null && network.rssiCurve != null) {
            score = network.rssiCurve.lookupScore(result.level);
            if (DBG) {
                Log.d("WifiNetworkScoreCache", "getNetworkScore found scored network " + network.networkKey + " score " + Integer.toString(score) + " RSSI " + result.level);
            }
        }
        return score;
    }

    private final boolean $$robo$$android_net_wifi_WifiNetworkScoreCache$getMeteredHint(ScanResult result) {
        ScoredNetwork network = this.getScoredNetwork(result);
        return network != null && network.meteredHint;
    }

    private final int $$robo$$android_net_wifi_WifiNetworkScoreCache$getNetworkScore(ScanResult result, boolean isActiveNetwork) {
        int score = -128;
        ScoredNetwork network = this.getScoredNetwork(result);
        if (network != null && network.rssiCurve != null) {
            score = network.rssiCurve.lookupScore(result.level, isActiveNetwork);
            if (DBG) {
                Log.d("WifiNetworkScoreCache", "getNetworkScore found scored network " + network.networkKey + " score " + Integer.toString(score) + " RSSI " + result.level + " isActiveNetwork " + isActiveNetwork);
            }
        }
        return score;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScoredNetwork $$robo$$android_net_wifi_WifiNetworkScoreCache$getScoredNetwork(ScanResult result) {
        String key = this.buildNetworkKey(result);
        if (key == null) {
            return null;
        }
        Map<String, ScoredNetwork> map = this.mNetworkCache;
        synchronized (map) {
            ScoredNetwork network = this.mNetworkCache.get(key);
            return network;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ScoredNetwork $$robo$$android_net_wifi_WifiNetworkScoreCache$getScoredNetwork(NetworkKey networkKey) {
        String key = this.buildNetworkKey(networkKey);
        if (key == null) {
            if (DBG) {
                Log.d("WifiNetworkScoreCache", "Could not build key string for Network Key: " + networkKey);
            }
            return null;
        }
        Map<String, ScoredNetwork> map = this.mNetworkCache;
        synchronized (map) {
            return this.mNetworkCache.get(key);
        }
    }

    private final String $$robo$$android_net_wifi_WifiNetworkScoreCache$buildNetworkKey(ScoredNetwork network) {
        if (network == null) {
            return null;
        }
        return this.buildNetworkKey(network.networkKey);
    }

    private final String $$robo$$android_net_wifi_WifiNetworkScoreCache$buildNetworkKey(NetworkKey networkKey) {
        if (networkKey == null) {
            return null;
        }
        if (networkKey.wifiKey == null) {
            return null;
        }
        if (networkKey.type == 1) {
            String key = networkKey.wifiKey.ssid;
            if (key == null) {
                return null;
            }
            if (networkKey.wifiKey.bssid != null) {
                key = key + networkKey.wifiKey.bssid;
            }
            return key;
        }
        return null;
    }

    private final String $$robo$$android_net_wifi_WifiNetworkScoreCache$buildNetworkKey(ScanResult result) {
        if (result == null || result.SSID == null) {
            return null;
        }
        StringBuilder key = new StringBuilder("\"");
        key.append(result.SSID);
        key.append("\"");
        if (result.BSSID != null) {
            key.append(result.BSSID);
        }
        return key.toString();
    }

    private final void $$robo$$android_net_wifi_WifiNetworkScoreCache$dump(FileDescriptor fd, PrintWriter writer, String[] args) {
        this.mContext.enforceCallingOrSelfPermission("android.permission.DUMP", "WifiNetworkScoreCache");
        String header = String.format("WifiNetworkScoreCache (%s/%d)", this.mContext.getPackageName(), Process.myUid());
        writer.println(header);
        writer.println("  All score curves:");
        for (ScoredNetwork score : this.mNetworkCache.values()) {
            writer.println("    " + score);
        }
        writer.println("  Current network scores:");
        WifiManager wifiManager = (WifiManager)this.mContext.getSystemService("wifi");
        for (ScanResult scanResult : wifiManager.getScanResults()) {
            writer.println("    " + this.buildNetworkKey(scanResult) + ": " + this.getNetworkScore(scanResult));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiNetworkScoreCache$registerListener(CacheListener listener) {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mListener = listener;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_wifi_WifiNetworkScoreCache$unregisterListener() {
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mListener = null;
        }
    }

    static void __staticInitializer__() {
        DBG = Log.isLoggable("WifiNetworkScoreCache", 3);
    }

    private void __constructor__(Context context) {
        this.$$robo$$android_net_wifi_WifiNetworkScoreCache$__constructor__(context);
    }

    public WifiNetworkScoreCache(Context context) {
        this(context, null);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiNetworkScoreCache$__constructor__(android.content.Context ), 0, this, context);
    }

    private void __constructor__(Context context, CacheListener cacheListener) {
        this.$$robo$$android_net_wifi_WifiNetworkScoreCache$__constructor__(context, cacheListener);
    }

    public WifiNetworkScoreCache(Context context, CacheListener cacheListener) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiNetworkScoreCache$__constructor__(android.content.Context android.net.wifi.WifiNetworkScoreCache$CacheListener ), 0, this, context, cacheListener);
    }

    @Override
    public void updateScores(List<ScoredNetwork> list) {
        InvokeDynamicSupport.bootstrap("updateScores", $$robo$$android_net_wifi_WifiNetworkScoreCache$updateScores(java.util.List<android.net.ScoredNetwork> ), 0, this, list);
    }

    @Override
    public void clearScores() {
        InvokeDynamicSupport.bootstrap("clearScores", $$robo$$android_net_wifi_WifiNetworkScoreCache$clearScores(), 0, this);
    }

    public boolean isScoredNetwork(ScanResult scanResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("isScoredNetwork", $$robo$$android_net_wifi_WifiNetworkScoreCache$isScoredNetwork(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public boolean hasScoreCurve(ScanResult scanResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("hasScoreCurve", $$robo$$android_net_wifi_WifiNetworkScoreCache$hasScoreCurve(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public int getNetworkScore(ScanResult scanResult) {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkScore", $$robo$$android_net_wifi_WifiNetworkScoreCache$getNetworkScore(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public boolean getMeteredHint(ScanResult scanResult) {
        return (boolean)InvokeDynamicSupport.bootstrap("getMeteredHint", $$robo$$android_net_wifi_WifiNetworkScoreCache$getMeteredHint(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public int getNetworkScore(ScanResult scanResult, boolean bl) {
        return (int)InvokeDynamicSupport.bootstrap("getNetworkScore", $$robo$$android_net_wifi_WifiNetworkScoreCache$getNetworkScore(android.net.wifi.ScanResult boolean ), 0, this, scanResult, bl);
    }

    public ScoredNetwork getScoredNetwork(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrap("getScoredNetwork", $$robo$$android_net_wifi_WifiNetworkScoreCache$getScoredNetwork(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    public ScoredNetwork getScoredNetwork(NetworkKey networkKey) {
        return InvokeDynamicSupport.bootstrap("getScoredNetwork", $$robo$$android_net_wifi_WifiNetworkScoreCache$getScoredNetwork(android.net.NetworkKey ), 0, this, networkKey);
    }

    private String buildNetworkKey(ScoredNetwork scoredNetwork) {
        return InvokeDynamicSupport.bootstrap("buildNetworkKey", $$robo$$android_net_wifi_WifiNetworkScoreCache$buildNetworkKey(android.net.ScoredNetwork ), 0, this, scoredNetwork);
    }

    private String buildNetworkKey(NetworkKey networkKey) {
        return InvokeDynamicSupport.bootstrap("buildNetworkKey", $$robo$$android_net_wifi_WifiNetworkScoreCache$buildNetworkKey(android.net.NetworkKey ), 0, this, networkKey);
    }

    private String buildNetworkKey(ScanResult scanResult) {
        return InvokeDynamicSupport.bootstrap("buildNetworkKey", $$robo$$android_net_wifi_WifiNetworkScoreCache$buildNetworkKey(android.net.wifi.ScanResult ), 0, this, scanResult);
    }

    @Override
    protected void dump(FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        InvokeDynamicSupport.bootstrap("dump", $$robo$$android_net_wifi_WifiNetworkScoreCache$dump(java.io.FileDescriptor java.io.PrintWriter java.lang.String[] ), 0, this, fileDescriptor, printWriter, stringArray);
    }

    public void registerListener(CacheListener cacheListener) {
        InvokeDynamicSupport.bootstrap("registerListener", $$robo$$android_net_wifi_WifiNetworkScoreCache$registerListener(android.net.wifi.WifiNetworkScoreCache$CacheListener ), 0, this, cacheListener);
    }

    public void unregisterListener() {
        InvokeDynamicSupport.bootstrap("unregisterListener", $$robo$$android_net_wifi_WifiNetworkScoreCache$unregisterListener(), 0, this);
    }

    static {
        RobolectricInternals.classInitializing(WifiNetworkScoreCache.class);
    }

    public /* synthetic */ WifiNetworkScoreCache() {
        this.$$robo$init();
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (WifiNetworkScoreCache)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public static abstract class CacheListener
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Handler mHandler;

        private void $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener$__constructor__(Handler handler) {
            Preconditions.checkNotNull(handler);
            this.mHandler = handler;
        }

        private final void $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener$post(List<ScoredNetwork> updatedNetworks) {
            this.mHandler.post(new Runnable(this, updatedNetworks){
                public transient /* synthetic */ Object __robo_data__;
                /* synthetic */ List val$updatedNetworks;
                /* synthetic */ CacheListener this$0;

                private void $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener_1$__constructor__(CacheListener this$0, List list) {
                }

                private final void $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener_1$run() {
                    this.this$0.networkCacheUpdated(this.val$updatedNetworks);
                }

                private void __constructor__(CacheListener cacheListener, List list) {
                    this.$$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener_1$__constructor__(cacheListener, list);
                }
                {
                    this.this$0 = cacheListener;
                    this.val$updatedNetworks = list;
                    this.$$robo$init();
                    InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener_1$__constructor__(android.net.wifi.WifiNetworkScoreCache$CacheListener java.util.List ), 0, this, cacheListener, list);
                }

                @Override
                public void run() {
                    InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener_1$run(), 0, this);
                }
                {
                    this.$$robo$init();
                }

                protected /* synthetic */ void $$robo$init() {
                    if (this.__robo_data__ == null) {
                        this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                    }
                }

                public /* synthetic */ Object $$robo$getData() {
                    return this.__robo_data__;
                }
            });
        }

        public abstract void networkCacheUpdated(List<ScoredNetwork> var1);

        private void __constructor__(Handler handler) {
            this.$$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener$__constructor__(handler);
        }

        public CacheListener(Handler handler) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener$__constructor__(android.os.Handler ), 0, this, handler);
        }

        void post(List<ScoredNetwork> list) {
            InvokeDynamicSupport.bootstrap("post", $$robo$$android_net_wifi_WifiNetworkScoreCache_CacheListener$post(java.util.List<android.net.ScoredNetwork> ), 0, this, list);
        }

        public /* synthetic */ CacheListener() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (CacheListener)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

