/*
 * Decompiled with CFR 0.152.
 */
package android.net.wifi;

import android.os.Parcel;
import java.io.ByteArrayInputStream;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class ParcelUtil
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;

    private void $$robo$$android_net_wifi_ParcelUtil$__constructor__() {
    }

    private static final void $$robo$$android_net_wifi_ParcelUtil$writePrivateKey(Parcel dest, PrivateKey key) {
        if (key == null) {
            dest.writeString(null);
            return;
        }
        dest.writeString(key.getAlgorithm());
        dest.writeByteArray(key.getEncoded());
    }

    private static final PrivateKey $$robo$$android_net_wifi_ParcelUtil$readPrivateKey(Parcel in) {
        String algorithm = in.readString();
        if (algorithm == null) {
            return null;
        }
        byte[] userKeyBytes = in.createByteArray();
        try {
            KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(userKeyBytes));
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            return null;
        }
    }

    private static final void $$robo$$android_net_wifi_ParcelUtil$writeCertificate(Parcel dest, X509Certificate cert) {
        byte[] certBytes = null;
        if (cert != null) {
            try {
                certBytes = cert.getEncoded();
            }
            catch (CertificateEncodingException certificateEncodingException) {
                // empty catch block
            }
        }
        dest.writeByteArray(certBytes);
    }

    private static final X509Certificate $$robo$$android_net_wifi_ParcelUtil$readCertificate(Parcel in) {
        byte[] certBytes = in.createByteArray();
        if (certBytes == null) {
            return null;
        }
        try {
            CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
            return (X509Certificate)cFactory.generateCertificate(new ByteArrayInputStream(certBytes));
        }
        catch (CertificateException e) {
            return null;
        }
    }

    private static final void $$robo$$android_net_wifi_ParcelUtil$writeCertificates(Parcel dest, X509Certificate[] certs) {
        if (certs == null || certs.length == 0) {
            dest.writeInt(0);
            return;
        }
        dest.writeInt(certs.length);
        for (int i = 0; i < certs.length; ++i) {
            ParcelUtil.writeCertificate(dest, certs[i]);
        }
    }

    private static final X509Certificate[] $$robo$$android_net_wifi_ParcelUtil$readCertificates(Parcel in) {
        int length = in.readInt();
        if (length == 0) {
            return null;
        }
        X509Certificate[] certs = new X509Certificate[length];
        for (int i = 0; i < length; ++i) {
            certs[i] = ParcelUtil.readCertificate(in);
        }
        return certs;
    }

    private void __constructor__() {
        this.$$robo$$android_net_wifi_ParcelUtil$__constructor__();
    }

    public ParcelUtil() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_wifi_ParcelUtil$__constructor__(), 0, this);
    }

    public static void writePrivateKey(Parcel parcel, PrivateKey privateKey) {
        InvokeDynamicSupport.bootstrapStatic("writePrivateKey", $$robo$$android_net_wifi_ParcelUtil$writePrivateKey(android.os.Parcel java.security.PrivateKey ), 0, (Parcel)parcel, (PrivateKey)privateKey);
    }

    public static PrivateKey readPrivateKey(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readPrivateKey", $$robo$$android_net_wifi_ParcelUtil$readPrivateKey(android.os.Parcel ), 0, (Parcel)parcel);
    }

    public static void writeCertificate(Parcel parcel, X509Certificate x509Certificate) {
        InvokeDynamicSupport.bootstrapStatic("writeCertificate", $$robo$$android_net_wifi_ParcelUtil$writeCertificate(android.os.Parcel java.security.cert.X509Certificate ), 0, (Parcel)parcel, (X509Certificate)x509Certificate);
    }

    public static X509Certificate readCertificate(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readCertificate", $$robo$$android_net_wifi_ParcelUtil$readCertificate(android.os.Parcel ), 0, (Parcel)parcel);
    }

    public static void writeCertificates(Parcel parcel, X509Certificate[] x509CertificateArray) {
        InvokeDynamicSupport.bootstrapStatic("writeCertificates", $$robo$$android_net_wifi_ParcelUtil$writeCertificates(android.os.Parcel java.security.cert.X509Certificate[] ), 0, (Parcel)parcel, (X509Certificate[])x509CertificateArray);
    }

    public static X509Certificate[] readCertificates(Parcel parcel) {
        return InvokeDynamicSupport.bootstrapStatic("readCertificates", $$robo$$android_net_wifi_ParcelUtil$readCertificates(android.os.Parcel ), 0, (Parcel)parcel);
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (ParcelUtil)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

