/*
 * Decompiled with CFR 0.152.
 */
package android.net.ip;

import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.NetworkUtils;
import android.net.TrafficStats;
import android.system.ErrnoException;
import android.system.Os;
import android.system.OsConstants;
import android.system.StructTimeval;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;
import com.google.errorprone.annotations.DoNotMock;
import java.io.FileDescriptor;
import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import libcore.io.IoBridge;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class RouterAdvertisementDaemon
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static String TAG;
    private static byte ICMPV6_ND_ROUTER_SOLICIT;
    private static byte ICMPV6_ND_ROUTER_ADVERT;
    private static int MIN_RA_HEADER_SIZE = 16;
    private static int MIN_RTR_ADV_INTERVAL_SEC = 300;
    private static int MAX_RTR_ADV_INTERVAL_SEC = 600;
    private static int DEFAULT_LIFETIME = 3600;
    private static int MIN_DELAY_BETWEEN_RAS_SEC = 3;
    private static int MAX_URGENT_RTR_ADVERTISEMENTS = 5;
    private static int DAY_IN_SECONDS = 86400;
    private static byte[] ALL_NODES;
    private String mIfName;
    private int mIfIndex;
    private byte[] mHwAddr;
    private InetSocketAddress mAllNodes;
    private Object mLock;
    @GuardedBy(value="mLock")
    private byte[] mRA;
    @GuardedBy(value="mLock")
    private int mRaLength;
    @GuardedBy(value="mLock")
    private DeprecatedInfoTracker mDeprecatedInfoTracker;
    @GuardedBy(value="mLock")
    private RaParams mRaParams;
    private volatile FileDescriptor mSocket;
    private volatile MulticastTransmitter mMulticastTransmitter;
    private volatile UnicastResponder mUnicastResponder;

    private void $$robo$$android_net_ip_RouterAdvertisementDaemon$__constructor__(String ifname, int ifindex, byte[] hwaddr) {
        this.mLock = new Object();
        this.mRA = new byte[1280];
        this.mIfName = ifname;
        this.mIfIndex = ifindex;
        this.mHwAddr = hwaddr;
        this.mAllNodes = new InetSocketAddress(RouterAdvertisementDaemon.getAllNodesForScopeId(this.mIfIndex), 0);
        this.mDeprecatedInfoTracker = new DeprecatedInfoTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_RouterAdvertisementDaemon$buildNewRa(RaParams deprecatedParams, RaParams newParams) {
        Object object = this.mLock;
        synchronized (object) {
            if (deprecatedParams != null) {
                this.mDeprecatedInfoTracker.putPrefixes(deprecatedParams.prefixes);
                this.mDeprecatedInfoTracker.putDnses(deprecatedParams.dnses);
            }
            if (newParams != null) {
                this.mDeprecatedInfoTracker.removePrefixes(newParams.prefixes);
                this.mDeprecatedInfoTracker.removeDnses(newParams.dnses);
            }
            this.mRaParams = newParams;
            this.assembleRaLocked();
        }
        this.maybeNotifyMulticastTransmitter();
    }

    private final boolean $$robo$$android_net_ip_RouterAdvertisementDaemon$start() {
        if (!this.createSocket()) {
            return false;
        }
        this.mMulticastTransmitter = new MulticastTransmitter(this);
        this.mMulticastTransmitter.start();
        this.mUnicastResponder = new UnicastResponder(this);
        this.mUnicastResponder.start();
        return true;
    }

    private final void $$robo$$android_net_ip_RouterAdvertisementDaemon$stop() {
        this.closeSocket();
        this.mMulticastTransmitter = null;
        this.mUnicastResponder = null;
    }

    private final void $$robo$$android_net_ip_RouterAdvertisementDaemon$assembleRaLocked() {
        ByteBuffer ra = ByteBuffer.wrap(this.mRA);
        ra.order(ByteOrder.BIG_ENDIAN);
        boolean shouldSendRA = false;
        try {
            RouterAdvertisementDaemon.putHeader(ra, this.mRaParams != null && this.mRaParams.hasDefaultRoute);
            RouterAdvertisementDaemon.putSlla(ra, this.mHwAddr);
            this.mRaLength = ra.position();
            if (this.mRaParams != null) {
                RouterAdvertisementDaemon.putMtu(ra, this.mRaParams.mtu);
                this.mRaLength = ra.position();
                for (IpPrefix ipp : this.mRaParams.prefixes) {
                    RouterAdvertisementDaemon.putPio(ra, ipp, 3600, 3600);
                    this.mRaLength = ra.position();
                    shouldSendRA = true;
                }
                if (this.mRaParams.dnses.size() > 0) {
                    RouterAdvertisementDaemon.putRdnss(ra, this.mRaParams.dnses, 3600);
                    this.mRaLength = ra.position();
                    shouldSendRA = true;
                }
            }
            for (IpPrefix ipp : this.mDeprecatedInfoTracker.getPrefixes()) {
                RouterAdvertisementDaemon.putPio(ra, ipp, 0, 0);
                this.mRaLength = ra.position();
                shouldSendRA = true;
            }
            Set<Inet6Address> deprecatedDnses = this.mDeprecatedInfoTracker.getDnses();
            if (!deprecatedDnses.isEmpty()) {
                RouterAdvertisementDaemon.putRdnss(ra, deprecatedDnses, 0);
                this.mRaLength = ra.position();
                shouldSendRA = true;
            }
        }
        catch (BufferOverflowException e) {
            Log.e(TAG, "Could not construct new RA: " + e);
        }
        if (!shouldSendRA) {
            this.mRaLength = 0;
        }
    }

    private final void $$robo$$android_net_ip_RouterAdvertisementDaemon$maybeNotifyMulticastTransmitter() {
        MulticastTransmitter m = this.mMulticastTransmitter;
        if (m != null) {
            m.hup();
        }
    }

    private static final Inet6Address $$robo$$android_net_ip_RouterAdvertisementDaemon$getAllNodesForScopeId(int scopeId) {
        try {
            return Inet6Address.getByAddress("ff02::1", ALL_NODES, scopeId);
        }
        catch (UnknownHostException uhe) {
            Log.wtf(TAG, "Failed to construct ff02::1 InetAddress: " + uhe);
            return null;
        }
    }

    private static final byte $$robo$$android_net_ip_RouterAdvertisementDaemon$asByte(int value) {
        return (byte)value;
    }

    private static final short $$robo$$android_net_ip_RouterAdvertisementDaemon$asShort(int value) {
        return (short)value;
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putHeader(ByteBuffer ra, boolean hasDefaultRoute) {
        int DEFAULT_HOPLIMIT = 64;
        ra.put(ICMPV6_ND_ROUTER_ADVERT).put(RouterAdvertisementDaemon.asByte(0)).putShort(RouterAdvertisementDaemon.asShort(0)).put((byte)64).put(hasDefaultRoute ? RouterAdvertisementDaemon.asByte(8) : RouterAdvertisementDaemon.asByte(0)).putShort(hasDefaultRoute ? RouterAdvertisementDaemon.asShort(3600) : RouterAdvertisementDaemon.asShort(0)).putInt(0).putInt(0);
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putSlla(ByteBuffer ra, byte[] slla) {
        if (slla == null || slla.length != 6) {
            return;
        }
        boolean ND_OPTION_SLLA = true;
        boolean SLLA_NUM_8OCTETS = true;
        ra.put((byte)1).put((byte)1).put(slla);
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putExpandedFlagsOption(ByteBuffer ra) {
        int ND_OPTION_EFO = 26;
        boolean EFO_NUM_8OCTETS = true;
        ra.put((byte)26).put((byte)1).putShort(RouterAdvertisementDaemon.asShort(0)).putInt(0);
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putMtu(ByteBuffer ra, int mtu) {
        int ND_OPTION_MTU = 5;
        boolean MTU_NUM_8OCTETS = true;
        ra.put((byte)5).put((byte)1).putShort(RouterAdvertisementDaemon.asShort(0)).putInt(mtu < 1280 ? 1280 : mtu);
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putPio(ByteBuffer ra, IpPrefix ipp, int validTime, int preferredTime) {
        int prefixLength = ipp.getPrefixLength();
        if (prefixLength != 64) {
            return;
        }
        int ND_OPTION_PIO = 3;
        int PIO_NUM_8OCTETS = 4;
        if (validTime < 0) {
            validTime = 0;
        }
        if (preferredTime < 0) {
            preferredTime = 0;
        }
        if (preferredTime > validTime) {
            preferredTime = validTime;
        }
        byte[] addr = ipp.getAddress().getAddress();
        ra.put((byte)3).put((byte)4).put(RouterAdvertisementDaemon.asByte(prefixLength)).put(RouterAdvertisementDaemon.asByte(192)).putInt(validTime).putInt(preferredTime).putInt(0).put(addr);
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putRio(ByteBuffer ra, IpPrefix ipp) {
        int prefixLength = ipp.getPrefixLength();
        if (prefixLength > 64) {
            return;
        }
        int ND_OPTION_RIO = 24;
        byte RIO_NUM_8OCTETS = RouterAdvertisementDaemon.asByte(prefixLength == 0 ? 1 : (prefixLength <= 8 ? 2 : 3));
        byte[] addr = ipp.getAddress().getAddress();
        ra.put((byte)24).put(RIO_NUM_8OCTETS).put(RouterAdvertisementDaemon.asByte(prefixLength)).put(RouterAdvertisementDaemon.asByte(24)).putInt(3600);
        if (prefixLength > 0) {
            ra.put(addr, 0, prefixLength <= 64 ? 8 : 16);
        }
    }

    private static final void $$robo$$android_net_ip_RouterAdvertisementDaemon$putRdnss(ByteBuffer ra, Set<Inet6Address> dnses, int lifetime) {
        HashSet<Inet6Address> filteredDnses = new HashSet<Inet6Address>();
        for (Inet6Address dns : dnses) {
            if (!new LinkAddress(dns, 64).isGlobalPreferred()) continue;
            filteredDnses.add(dns);
        }
        if (filteredDnses.isEmpty()) {
            return;
        }
        int ND_OPTION_RDNSS = 25;
        byte RDNSS_NUM_8OCTETS = RouterAdvertisementDaemon.asByte(dnses.size() * 2 + 1);
        ra.put((byte)25).put(RDNSS_NUM_8OCTETS).putShort(RouterAdvertisementDaemon.asShort(0)).putInt(lifetime);
        for (Inet6Address dns : filteredDnses) {
            ra.put(dns.getAddress());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean $$robo$$android_net_ip_RouterAdvertisementDaemon$createSocket() {
        int SEND_TIMEOUT_MS = 300;
        int oldTag = TrafficStats.getAndSetThreadStatsTag(-248);
        try {
            this.mSocket = Os.socket(OsConstants.AF_INET6, OsConstants.SOCK_RAW, OsConstants.IPPROTO_ICMPV6);
            Os.setsockoptTimeval(this.mSocket, OsConstants.SOL_SOCKET, OsConstants.SO_SNDTIMEO, StructTimeval.fromMillis(300L));
            Os.setsockoptIfreq(this.mSocket, OsConstants.SOL_SOCKET, OsConstants.SO_BINDTODEVICE, this.mIfName);
            NetworkUtils.protectFromVpn(this.mSocket);
            NetworkUtils.setupRaSocket(this.mSocket, this.mIfIndex);
        }
        catch (ErrnoException | IOException e) {
            Log.e(TAG, "Failed to create RA daemon socket: " + e);
            boolean bl = false;
            return bl;
        }
        finally {
            TrafficStats.setThreadStatsTag(oldTag);
        }
        return true;
    }

    private final void $$robo$$android_net_ip_RouterAdvertisementDaemon$closeSocket() {
        if (this.mSocket != null) {
            try {
                IoBridge.closeAndSignalBlockedThreads(this.mSocket);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.mSocket = null;
    }

    private final boolean $$robo$$android_net_ip_RouterAdvertisementDaemon$isSocketValid() {
        FileDescriptor s = this.mSocket;
        return s != null && s.valid();
    }

    private final boolean $$robo$$android_net_ip_RouterAdvertisementDaemon$isSuitableDestination(InetSocketAddress dest) {
        if (this.mAllNodes.equals(dest)) {
            return true;
        }
        InetAddress destip = dest.getAddress();
        return destip instanceof Inet6Address && destip.isLinkLocalAddress() && ((Inet6Address)destip).getScopeId() == this.mIfIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void $$robo$$android_net_ip_RouterAdvertisementDaemon$maybeSendRA(InetSocketAddress dest) {
        block7: {
            if (dest == null || !this.isSuitableDestination(dest)) {
                dest = this.mAllNodes;
            }
            try {
                Object object = this.mLock;
                synchronized (object) {
                    if (this.mRaLength < 16) {
                        return;
                    }
                    Os.sendto(this.mSocket, this.mRA, 0, this.mRaLength, 0, dest);
                }
                Log.d(TAG, "RA sendto " + dest.getAddress().getHostAddress());
            }
            catch (ErrnoException | SocketException e) {
                if (!this.isSocketValid()) break block7;
                Log.e(TAG, "sendto error: " + e);
            }
        }
    }

    static void __staticInitializer__() {
        TAG = RouterAdvertisementDaemon.class.getSimpleName();
        ICMPV6_ND_ROUTER_SOLICIT = RouterAdvertisementDaemon.asByte(133);
        ICMPV6_ND_ROUTER_ADVERT = RouterAdvertisementDaemon.asByte(134);
        ALL_NODES = new byte[]{-1, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1};
    }

    private void __constructor__(String string2, int n, byte[] byArray) {
        this.$$robo$$android_net_ip_RouterAdvertisementDaemon$__constructor__(string2, n, byArray);
    }

    public RouterAdvertisementDaemon(String string2, int n, byte[] byArray) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_RouterAdvertisementDaemon$__constructor__(java.lang.String int byte[] ), 0, this, string2, n, byArray);
    }

    public void buildNewRa(RaParams raParams, RaParams raParams2) {
        InvokeDynamicSupport.bootstrap("buildNewRa", $$robo$$android_net_ip_RouterAdvertisementDaemon$buildNewRa(android.net.ip.RouterAdvertisementDaemon$RaParams android.net.ip.RouterAdvertisementDaemon$RaParams ), 0, this, raParams, raParams2);
    }

    public boolean start() {
        return (boolean)InvokeDynamicSupport.bootstrap("start", $$robo$$android_net_ip_RouterAdvertisementDaemon$start(), 0, this);
    }

    public void stop() {
        InvokeDynamicSupport.bootstrap("stop", $$robo$$android_net_ip_RouterAdvertisementDaemon$stop(), 0, this);
    }

    private void assembleRaLocked() {
        InvokeDynamicSupport.bootstrap("assembleRaLocked", $$robo$$android_net_ip_RouterAdvertisementDaemon$assembleRaLocked(), 0, this);
    }

    private void maybeNotifyMulticastTransmitter() {
        InvokeDynamicSupport.bootstrap("maybeNotifyMulticastTransmitter", $$robo$$android_net_ip_RouterAdvertisementDaemon$maybeNotifyMulticastTransmitter(), 0, this);
    }

    private static Inet6Address getAllNodesForScopeId(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getAllNodesForScopeId", $$robo$$android_net_ip_RouterAdvertisementDaemon$getAllNodesForScopeId(int ), 0, (int)n);
    }

    private static byte asByte(int n) {
        return (byte)InvokeDynamicSupport.bootstrapStatic("asByte", $$robo$$android_net_ip_RouterAdvertisementDaemon$asByte(int ), 0, (int)n);
    }

    private static short asShort(int n) {
        return (short)InvokeDynamicSupport.bootstrapStatic("asShort", $$robo$$android_net_ip_RouterAdvertisementDaemon$asShort(int ), 0, (int)n);
    }

    private static void putHeader(ByteBuffer byteBuffer, boolean bl) {
        InvokeDynamicSupport.bootstrapStatic("putHeader", $$robo$$android_net_ip_RouterAdvertisementDaemon$putHeader(java.nio.ByteBuffer boolean ), 0, (ByteBuffer)byteBuffer, (boolean)bl);
    }

    private static void putSlla(ByteBuffer byteBuffer, byte[] byArray) {
        InvokeDynamicSupport.bootstrapStatic("putSlla", $$robo$$android_net_ip_RouterAdvertisementDaemon$putSlla(java.nio.ByteBuffer byte[] ), 0, (ByteBuffer)byteBuffer, (byte[])byArray);
    }

    private static void putExpandedFlagsOption(ByteBuffer byteBuffer) {
        InvokeDynamicSupport.bootstrapStatic("putExpandedFlagsOption", $$robo$$android_net_ip_RouterAdvertisementDaemon$putExpandedFlagsOption(java.nio.ByteBuffer ), 0, (ByteBuffer)byteBuffer);
    }

    private static void putMtu(ByteBuffer byteBuffer, int n) {
        InvokeDynamicSupport.bootstrapStatic("putMtu", $$robo$$android_net_ip_RouterAdvertisementDaemon$putMtu(java.nio.ByteBuffer int ), 0, (ByteBuffer)byteBuffer, (int)n);
    }

    private static void putPio(ByteBuffer byteBuffer, IpPrefix ipPrefix, int n, int n2) {
        InvokeDynamicSupport.bootstrapStatic("putPio", $$robo$$android_net_ip_RouterAdvertisementDaemon$putPio(java.nio.ByteBuffer android.net.IpPrefix int int ), 0, (ByteBuffer)byteBuffer, (IpPrefix)ipPrefix, (int)n, (int)n2);
    }

    private static void putRio(ByteBuffer byteBuffer, IpPrefix ipPrefix) {
        InvokeDynamicSupport.bootstrapStatic("putRio", $$robo$$android_net_ip_RouterAdvertisementDaemon$putRio(java.nio.ByteBuffer android.net.IpPrefix ), 0, (ByteBuffer)byteBuffer, (IpPrefix)ipPrefix);
    }

    private static void putRdnss(ByteBuffer byteBuffer, Set<Inet6Address> set, int n) {
        InvokeDynamicSupport.bootstrapStatic("putRdnss", $$robo$$android_net_ip_RouterAdvertisementDaemon$putRdnss(java.nio.ByteBuffer java.util.Set<java.net.Inet6Address> int ), 0, (ByteBuffer)byteBuffer, set, (int)n);
    }

    private boolean createSocket() {
        return (boolean)InvokeDynamicSupport.bootstrap("createSocket", $$robo$$android_net_ip_RouterAdvertisementDaemon$createSocket(), 0, this);
    }

    private void closeSocket() {
        InvokeDynamicSupport.bootstrap("closeSocket", $$robo$$android_net_ip_RouterAdvertisementDaemon$closeSocket(), 0, this);
    }

    private boolean isSocketValid() {
        return (boolean)InvokeDynamicSupport.bootstrap("isSocketValid", $$robo$$android_net_ip_RouterAdvertisementDaemon$isSocketValid(), 0, this);
    }

    private boolean isSuitableDestination(InetSocketAddress inetSocketAddress) {
        return (boolean)InvokeDynamicSupport.bootstrap("isSuitableDestination", $$robo$$android_net_ip_RouterAdvertisementDaemon$isSuitableDestination(java.net.InetSocketAddress ), 0, this, inetSocketAddress);
    }

    private void maybeSendRA(InetSocketAddress inetSocketAddress) {
        InvokeDynamicSupport.bootstrap("maybeSendRA", $$robo$$android_net_ip_RouterAdvertisementDaemon$maybeSendRA(java.net.InetSocketAddress ), 0, this, inetSocketAddress);
    }

    static {
        RobolectricInternals.classInitializing(RouterAdvertisementDaemon.class);
    }

    public /* synthetic */ RouterAdvertisementDaemon() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RouterAdvertisementDaemon)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class MulticastTransmitter
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private Random mRandom;
        private AtomicInteger mUrgentAnnouncements;
        /* synthetic */ RouterAdvertisementDaemon this$0;

        private void $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$__constructor__(RouterAdvertisementDaemon routerAdvertisementDaemon) {
            this.mRandom = new Random();
            this.mUrgentAnnouncements = new AtomicInteger(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$run() {
            while (this.this$0.isSocketValid()) {
                try {
                    Thread.sleep(this.getNextMulticastTransmitDelayMs());
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.this$0.maybeSendRA(this.this$0.mAllNodes);
                Object object = this.this$0.mLock;
                synchronized (object) {
                    if (this.this$0.mDeprecatedInfoTracker.decrementCounters()) {
                        this.this$0.assembleRaLocked();
                    }
                }
            }
        }

        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$hup() {
            this.mUrgentAnnouncements.set(4);
            this.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final int $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$getNextMulticastTransmitDelaySec() {
            boolean deprecationInProgress = false;
            Object object = this.this$0.mLock;
            synchronized (object) {
                if (this.this$0.mRaLength < 16) {
                    return 86400;
                }
                deprecationInProgress = !this.this$0.mDeprecatedInfoTracker.isEmpty();
            }
            int urgentPending = this.mUrgentAnnouncements.getAndDecrement();
            if (urgentPending > 0 || deprecationInProgress) {
                return 3;
            }
            return 300 + this.mRandom.nextInt(300);
        }

        private final long $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$getNextMulticastTransmitDelayMs() {
            return 1000L * (long)this.getNextMulticastTransmitDelaySec();
        }

        private /* synthetic */ void $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$__constructor__(RouterAdvertisementDaemon x0, 1 x1) {
        }

        private void __constructor__(RouterAdvertisementDaemon routerAdvertisementDaemon) {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$__constructor__(routerAdvertisementDaemon);
        }

        private MulticastTransmitter(RouterAdvertisementDaemon routerAdvertisementDaemon) {
            this.this$0 = routerAdvertisementDaemon;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$__constructor__(android.net.ip.RouterAdvertisementDaemon ), 0, this, routerAdvertisementDaemon);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$run(), 0, this);
        }

        public void hup() {
            InvokeDynamicSupport.bootstrap("hup", $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$hup(), 0, this);
        }

        private int getNextMulticastTransmitDelaySec() {
            return (int)InvokeDynamicSupport.bootstrap("getNextMulticastTransmitDelaySec", $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$getNextMulticastTransmitDelaySec(), 0, this);
        }

        private long getNextMulticastTransmitDelayMs() {
            return (long)InvokeDynamicSupport.bootstrap("getNextMulticastTransmitDelayMs", $$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$getNextMulticastTransmitDelayMs(), 0, this);
        }

        private /* synthetic */ void __constructor__(RouterAdvertisementDaemon routerAdvertisementDaemon, 1 var2_2) {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_MulticastTransmitter$__constructor__(routerAdvertisementDaemon, var2_2);
        }

        public /* synthetic */ MulticastTransmitter() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (MulticastTransmitter)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    @DoNotMock(value="This class is final. Consider using the real thing, or adding/enhancing a Robolectric shadow for it.")
    private final class UnicastResponder
    extends Thread
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private InetSocketAddress solicitor;
        private byte[] mSolication;
        /* synthetic */ RouterAdvertisementDaemon this$0;

        private void $$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$__constructor__(RouterAdvertisementDaemon routerAdvertisementDaemon) {
            this.solicitor = new InetSocketAddress();
            this.mSolication = new byte[1280];
        }

        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$run() {
            while (this.this$0.isSocketValid()) {
                block4: {
                    try {
                        int rval = Os.recvfrom(this.this$0.mSocket, this.mSolication, 0, this.mSolication.length, 0, this.solicitor);
                        if (rval < 1) continue;
                        if (this.mSolication[0] != ICMPV6_ND_ROUTER_SOLICIT) {
                        }
                        break block4;
                    }
                    catch (ErrnoException | SocketException e) {
                        if (!this.this$0.isSocketValid()) continue;
                        Log.e(TAG, "recvfrom error: " + e);
                    }
                    continue;
                }
                this.this$0.maybeSendRA(this.solicitor);
            }
        }

        private /* synthetic */ void $$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$__constructor__(RouterAdvertisementDaemon x0, 1 x1) {
        }

        private void __constructor__(RouterAdvertisementDaemon routerAdvertisementDaemon) {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$__constructor__(routerAdvertisementDaemon);
        }

        private UnicastResponder(RouterAdvertisementDaemon routerAdvertisementDaemon) {
            this.this$0 = routerAdvertisementDaemon;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$__constructor__(android.net.ip.RouterAdvertisementDaemon ), 0, this, routerAdvertisementDaemon);
        }

        @Override
        public void run() {
            InvokeDynamicSupport.bootstrap("run", $$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$run(), 0, this);
        }

        private /* synthetic */ void __constructor__(RouterAdvertisementDaemon routerAdvertisementDaemon, 1 var2_2) {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_UnicastResponder$__constructor__(routerAdvertisementDaemon, var2_2);
        }

        public /* synthetic */ UnicastResponder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (UnicastResponder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private static class DeprecatedInfoTracker
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private HashMap<IpPrefix, Integer> mPrefixes;
        private HashMap<Inet6Address, Integer> mDnses;

        private void $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$__constructor__() {
            this.mPrefixes = new HashMap();
            this.mDnses = new HashMap();
        }

        private final Set<IpPrefix> $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$getPrefixes() {
            return this.mPrefixes.keySet();
        }

        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$putPrefixes(Set<IpPrefix> prefixes) {
            for (IpPrefix ipp : prefixes) {
                this.mPrefixes.put(ipp, 5);
            }
        }

        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$removePrefixes(Set<IpPrefix> prefixes) {
            for (IpPrefix ipp : prefixes) {
                this.mPrefixes.remove(ipp);
            }
        }

        private final Set<Inet6Address> $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$getDnses() {
            return this.mDnses.keySet();
        }

        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$putDnses(Set<Inet6Address> dnses) {
            for (Inet6Address dns : dnses) {
                this.mDnses.put(dns, 5);
            }
        }

        private final void $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$removeDnses(Set<Inet6Address> dnses) {
            for (Inet6Address dns : dnses) {
                this.mDnses.remove(dns);
            }
        }

        private final boolean $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$isEmpty() {
            return this.mPrefixes.isEmpty() && this.mDnses.isEmpty();
        }

        private final boolean $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$decrementCounters() {
            boolean removed = this.decrementCounter(this.mPrefixes);
            return removed |= this.decrementCounter(this.mDnses);
        }

        private final <T> boolean $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$decrementCounter(HashMap<T, Integer> map) {
            boolean removed = false;
            Iterator<Map.Entry<T, Integer>> it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<T, Integer> kv = it.next();
                if (kv.getValue() == 0) {
                    it.remove();
                    removed = true;
                    continue;
                }
                kv.setValue(kv.getValue() - 1);
            }
            return removed;
        }

        private /* synthetic */ void $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$__constructor__(1 x0) {
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$__constructor__();
        }

        private DeprecatedInfoTracker() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$__constructor__(), 0, this);
        }

        Set<IpPrefix> getPrefixes() {
            return InvokeDynamicSupport.bootstrap("getPrefixes", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$getPrefixes(), 0, this);
        }

        void putPrefixes(Set<IpPrefix> set) {
            InvokeDynamicSupport.bootstrap("putPrefixes", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$putPrefixes(java.util.Set<android.net.IpPrefix> ), 0, this, set);
        }

        void removePrefixes(Set<IpPrefix> set) {
            InvokeDynamicSupport.bootstrap("removePrefixes", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$removePrefixes(java.util.Set<android.net.IpPrefix> ), 0, this, set);
        }

        Set<Inet6Address> getDnses() {
            return InvokeDynamicSupport.bootstrap("getDnses", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$getDnses(), 0, this);
        }

        void putDnses(Set<Inet6Address> set) {
            InvokeDynamicSupport.bootstrap("putDnses", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$putDnses(java.util.Set<java.net.Inet6Address> ), 0, this, set);
        }

        void removeDnses(Set<Inet6Address> set) {
            InvokeDynamicSupport.bootstrap("removeDnses", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$removeDnses(java.util.Set<java.net.Inet6Address> ), 0, this, set);
        }

        boolean isEmpty() {
            return (boolean)InvokeDynamicSupport.bootstrap("isEmpty", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$isEmpty(), 0, this);
        }

        private boolean decrementCounters() {
            return (boolean)InvokeDynamicSupport.bootstrap("decrementCounters", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$decrementCounters(), 0, this);
        }

        private <T> boolean decrementCounter(HashMap<T, Integer> hashMap) {
            return (boolean)InvokeDynamicSupport.bootstrap("decrementCounter", $$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$decrementCounter(java.util.HashMap<T, java.lang.Integer> ), 0, this, hashMap);
        }

        private /* synthetic */ void __constructor__(1 var1_1) {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_DeprecatedInfoTracker$__constructor__(var1_1);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (DeprecatedInfoTracker)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    public static class RaParams
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        public boolean hasDefaultRoute;
        public int mtu;
        public HashSet<IpPrefix> prefixes;
        public HashSet<Inet6Address> dnses;

        private void $$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$__constructor__() {
            this.hasDefaultRoute = false;
            this.mtu = 1280;
            this.prefixes = new HashSet();
            this.dnses = new HashSet();
        }

        private void $$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$__constructor__(RaParams other) {
            this.hasDefaultRoute = other.hasDefaultRoute;
            this.mtu = other.mtu;
            this.prefixes = (HashSet)other.prefixes.clone();
            this.dnses = (HashSet)other.dnses.clone();
        }

        private static final RaParams $$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$getDeprecatedRaParams(RaParams oldRa, RaParams newRa) {
            RaParams newlyDeprecated = new RaParams();
            if (oldRa != null) {
                for (IpPrefix ipp : oldRa.prefixes) {
                    if (newRa != null && newRa.prefixes.contains(ipp)) continue;
                    newlyDeprecated.prefixes.add(ipp);
                }
                for (Inet6Address dns : oldRa.dnses) {
                    if (newRa != null && newRa.dnses.contains(dns)) continue;
                    newlyDeprecated.dnses.add(dns);
                }
            }
            return newlyDeprecated;
        }

        private void __constructor__() {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$__constructor__();
        }

        public RaParams() {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$__constructor__(), 0, this);
        }

        private void __constructor__(RaParams raParams) {
            this.$$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$__constructor__(raParams);
        }

        public RaParams(RaParams raParams) {
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$__constructor__(android.net.ip.RouterAdvertisementDaemon$RaParams ), 0, this, raParams);
        }

        public static RaParams getDeprecatedRaParams(RaParams raParams, RaParams raParams2) {
            return InvokeDynamicSupport.bootstrapStatic("getDeprecatedRaParams", $$robo$$android_net_ip_RouterAdvertisementDaemon_RaParams$getDeprecatedRaParams(android.net.ip.RouterAdvertisementDaemon$RaParams android.net.ip.RouterAdvertisementDaemon$RaParams ), 0, (RaParams)raParams, (RaParams)raParams2);
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (RaParams)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

