/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.content.pm.IPackageManager;
import android.content.pm.PackageManager;
import android.net.IConnectivityManager;
import android.net.IpPrefix;
import android.net.LinkAddress;
import android.net.Network;
import android.net.NetworkUtils;
import android.net.RouteInfo;
import android.os.Binder;
import android.os.IBinder;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.UserHandle;
import android.system.OsConstants;
import com.android.internal.net.VpnConfig;
import java.io.FileDescriptor;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.ShadowedObject;

public class VpnService
extends Service
implements ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    public static String SERVICE_INTERFACE = "android.net.VpnService";

    private void $$robo$$android_net_VpnService$__constructor__() {
    }

    private static final IConnectivityManager $$robo$$android_net_VpnService$getService() {
        return IConnectivityManager.Stub.asInterface(ServiceManager.getService("connectivity"));
    }

    private static final Intent $$robo$$android_net_VpnService$prepare(Context context) {
        try {
            if (VpnService.getService().prepareVpn(context.getPackageName(), null, UserHandle.myUserId())) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        return VpnConfig.getIntentForConfirmation();
    }

    private static final void $$robo$$android_net_VpnService$prepareAndAuthorize(Context context) {
        IConnectivityManager cm = VpnService.getService();
        String packageName = context.getPackageName();
        try {
            int userId = UserHandle.myUserId();
            if (!cm.prepareVpn(packageName, null, userId)) {
                cm.prepareVpn(null, packageName, userId);
            }
            cm.setVpnPackageAuthorization(packageName, userId, true);
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private final boolean $$robo$$android_net_VpnService$protect(int socket) {
        return NetworkUtils.protectFromVpn(socket);
    }

    private final boolean $$robo$$android_net_VpnService$protect(Socket socket) {
        return this.protect((int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)((Object)InvokeDynamicSupport.bootstrapIntrinsic("getFileDescriptor$", "java.net.Socket", (Socket)socket))));
    }

    private final boolean $$robo$$android_net_VpnService$protect(DatagramSocket socket) {
        return this.protect((int)InvokeDynamicSupport.bootstrapIntrinsic("getInt$", "java.io.FileDescriptor", (FileDescriptor)socket.getFileDescriptor$()));
    }

    private final boolean $$robo$$android_net_VpnService$addAddress(InetAddress address, int prefixLength) {
        VpnService.check(address, prefixLength);
        try {
            return VpnService.getService().addVpnAddress(address.getHostAddress(), prefixLength);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    private final boolean $$robo$$android_net_VpnService$removeAddress(InetAddress address, int prefixLength) {
        VpnService.check(address, prefixLength);
        try {
            return VpnService.getService().removeVpnAddress(address.getHostAddress(), prefixLength);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    private final boolean $$robo$$android_net_VpnService$setUnderlyingNetworks(Network[] networks) {
        try {
            return VpnService.getService().setUnderlyingNetworksForVpn(networks);
        }
        catch (RemoteException e) {
            throw new IllegalStateException(e);
        }
    }

    private final IBinder $$robo$$android_net_VpnService$onBind(Intent intent) {
        if (intent != null && "android.net.VpnService".equals(intent.getAction())) {
            return new Callback(this);
        }
        return null;
    }

    private final void $$robo$$android_net_VpnService$onRevoke() {
        this.stopSelf();
    }

    private static final void $$robo$$android_net_VpnService$check(InetAddress address, int prefixLength) {
        if (address.isLoopbackAddress()) {
            throw new IllegalArgumentException("Bad address");
        }
        if (address instanceof Inet4Address) {
            if (prefixLength < 0 || prefixLength > 32) {
                throw new IllegalArgumentException("Bad prefixLength");
            }
        } else if (address instanceof Inet6Address) {
            if (prefixLength < 0 || prefixLength > 128) {
                throw new IllegalArgumentException("Bad prefixLength");
            }
        } else {
            throw new IllegalArgumentException("Unsupported family");
        }
    }

    private void __constructor__() {
        this.$$robo$$android_net_VpnService$__constructor__();
    }

    public VpnService() {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_VpnService$__constructor__(), 0, this);
    }

    private static IConnectivityManager getService() {
        return InvokeDynamicSupport.bootstrapStatic("getService", $$robo$$android_net_VpnService$getService(), 0);
    }

    public static Intent prepare(Context context) {
        return InvokeDynamicSupport.bootstrapStatic("prepare", $$robo$$android_net_VpnService$prepare(android.content.Context ), 0, (Context)context);
    }

    public static void prepareAndAuthorize(Context context) {
        InvokeDynamicSupport.bootstrapStatic("prepareAndAuthorize", $$robo$$android_net_VpnService$prepareAndAuthorize(android.content.Context ), 0, (Context)context);
    }

    public boolean protect(int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("protect", $$robo$$android_net_VpnService$protect(int ), 0, this, n);
    }

    public boolean protect(Socket socket) {
        return (boolean)InvokeDynamicSupport.bootstrap("protect", $$robo$$android_net_VpnService$protect(java.net.Socket ), 0, this, socket);
    }

    public boolean protect(DatagramSocket datagramSocket) {
        return (boolean)InvokeDynamicSupport.bootstrap("protect", $$robo$$android_net_VpnService$protect(java.net.DatagramSocket ), 0, this, datagramSocket);
    }

    public boolean addAddress(InetAddress inetAddress, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("addAddress", $$robo$$android_net_VpnService$addAddress(java.net.InetAddress int ), 0, this, inetAddress, n);
    }

    public boolean removeAddress(InetAddress inetAddress, int n) {
        return (boolean)InvokeDynamicSupport.bootstrap("removeAddress", $$robo$$android_net_VpnService$removeAddress(java.net.InetAddress int ), 0, this, inetAddress, n);
    }

    public boolean setUnderlyingNetworks(Network[] networkArray) {
        return (boolean)InvokeDynamicSupport.bootstrap("setUnderlyingNetworks", $$robo$$android_net_VpnService$setUnderlyingNetworks(android.net.Network[] ), 0, this, networkArray);
    }

    @Override
    public IBinder onBind(Intent intent) {
        return InvokeDynamicSupport.bootstrap("onBind", $$robo$$android_net_VpnService$onBind(android.content.Intent ), 0, this, intent);
    }

    public void onRevoke() {
        InvokeDynamicSupport.bootstrap("onRevoke", $$robo$$android_net_VpnService$onRevoke(), 0, this);
    }

    private static void check(InetAddress inetAddress, int n) {
        InvokeDynamicSupport.bootstrapStatic("check", $$robo$$android_net_VpnService$check(java.net.InetAddress int ), 0, (InetAddress)inetAddress, (int)n);
    }

    @Override
    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (VpnService)this);
        }
    }

    @Override
    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }

    public class Builder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        private VpnConfig mConfig;
        private List<LinkAddress> mAddresses;
        private List<RouteInfo> mRoutes;
        /* synthetic */ VpnService this$0;

        private void $$robo$$android_net_VpnService_Builder$__constructor__(VpnService this$0) {
            this.mConfig = new VpnConfig();
            this.mAddresses = new ArrayList<LinkAddress>();
            this.mRoutes = new ArrayList<RouteInfo>();
            this.mConfig.user = this$0.getClass().getName();
        }

        private final Builder $$robo$$android_net_VpnService_Builder$setSession(String session) {
            this.mConfig.session = session;
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$setConfigureIntent(PendingIntent intent) {
            this.mConfig.configureIntent = intent;
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$setMtu(int mtu) {
            if (mtu <= 0) {
                throw new IllegalArgumentException("Bad mtu");
            }
            this.mConfig.mtu = mtu;
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addAddress(InetAddress address, int prefixLength) {
            VpnService.check(address, prefixLength);
            if (address.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            this.mAddresses.add(new LinkAddress(address, prefixLength));
            this.mConfig.updateAllowedFamilies(address);
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addAddress(String address, int prefixLength) {
            return this.addAddress(InetAddress.parseNumericAddress((String)address), prefixLength);
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addRoute(InetAddress address, int prefixLength) {
            int offset;
            VpnService.check(address, prefixLength);
            byte[] bytes = address.getAddress();
            if (offset < bytes.length) {
                int n = offset;
                bytes[n] = (byte)(bytes[n] << prefixLength % 8);
                for (offset = prefixLength / 8; offset < bytes.length; ++offset) {
                    if (bytes[offset] == 0) continue;
                    throw new IllegalArgumentException("Bad address");
                }
            }
            this.mRoutes.add(new RouteInfo(new IpPrefix(address, prefixLength), null));
            this.mConfig.updateAllowedFamilies(address);
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addRoute(String address, int prefixLength) {
            return this.addRoute(InetAddress.parseNumericAddress((String)address), prefixLength);
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addDnsServer(InetAddress address) {
            if (address.isLoopbackAddress() || address.isAnyLocalAddress()) {
                throw new IllegalArgumentException("Bad address");
            }
            if (this.mConfig.dnsServers == null) {
                this.mConfig.dnsServers = new ArrayList<String>();
            }
            this.mConfig.dnsServers.add(address.getHostAddress());
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addDnsServer(String address) {
            return this.addDnsServer(InetAddress.parseNumericAddress((String)address));
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addSearchDomain(String domain) {
            if (this.mConfig.searchDomains == null) {
                this.mConfig.searchDomains = new ArrayList<String>();
            }
            this.mConfig.searchDomains.add(domain);
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$allowFamily(int family) {
            if (family == OsConstants.AF_INET) {
                this.mConfig.allowIPv4 = true;
            } else if (family == OsConstants.AF_INET6) {
                this.mConfig.allowIPv6 = true;
            } else {
                throw new IllegalArgumentException(family + " is neither " + OsConstants.AF_INET + " nor " + OsConstants.AF_INET6);
            }
            return this;
        }

        private final void $$robo$$android_net_VpnService_Builder$verifyApp(String packageName) throws PackageManager.NameNotFoundException {
            IPackageManager pm = IPackageManager.Stub.asInterface(ServiceManager.getService("package"));
            try {
                pm.getApplicationInfo(packageName, 0, UserHandle.getCallingUserId());
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addAllowedApplication(String packageName) throws PackageManager.NameNotFoundException {
            if (this.mConfig.disallowedApplications != null) {
                throw new UnsupportedOperationException("addDisallowedApplication already called");
            }
            this.verifyApp(packageName);
            if (this.mConfig.allowedApplications == null) {
                this.mConfig.allowedApplications = new ArrayList<String>();
            }
            this.mConfig.allowedApplications.add(packageName);
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$addDisallowedApplication(String packageName) throws PackageManager.NameNotFoundException {
            if (this.mConfig.allowedApplications != null) {
                throw new UnsupportedOperationException("addAllowedApplication already called");
            }
            this.verifyApp(packageName);
            if (this.mConfig.disallowedApplications == null) {
                this.mConfig.disallowedApplications = new ArrayList<String>();
            }
            this.mConfig.disallowedApplications.add(packageName);
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$allowBypass() {
            this.mConfig.allowBypass = true;
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$setBlocking(boolean blocking) {
            this.mConfig.blocking = blocking;
            return this;
        }

        private final Builder $$robo$$android_net_VpnService_Builder$setUnderlyingNetworks(Network[] networks) {
            this.mConfig.underlyingNetworks = networks != null ? (Network[])networks.clone() : null;
            return this;
        }

        private final ParcelFileDescriptor $$robo$$android_net_VpnService_Builder$establish() {
            this.mConfig.addresses = this.mAddresses;
            this.mConfig.routes = this.mRoutes;
            try {
                return VpnService.getService().establishVpn(this.mConfig);
            }
            catch (RemoteException e) {
                throw new IllegalStateException(e);
            }
        }

        private void __constructor__(VpnService vpnService) {
            this.$$robo$$android_net_VpnService_Builder$__constructor__(vpnService);
        }

        public Builder(VpnService vpnService) {
            this.this$0 = vpnService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_VpnService_Builder$__constructor__(android.net.VpnService ), 0, this, vpnService);
        }

        public Builder setSession(String string2) {
            return InvokeDynamicSupport.bootstrap("setSession", $$robo$$android_net_VpnService_Builder$setSession(java.lang.String ), 0, this, string2);
        }

        public Builder setConfigureIntent(PendingIntent pendingIntent) {
            return InvokeDynamicSupport.bootstrap("setConfigureIntent", $$robo$$android_net_VpnService_Builder$setConfigureIntent(android.app.PendingIntent ), 0, this, pendingIntent);
        }

        public Builder setMtu(int n) {
            return InvokeDynamicSupport.bootstrap("setMtu", $$robo$$android_net_VpnService_Builder$setMtu(int ), 0, this, n);
        }

        public Builder addAddress(InetAddress inetAddress, int n) {
            return InvokeDynamicSupport.bootstrap("addAddress", $$robo$$android_net_VpnService_Builder$addAddress(java.net.InetAddress int ), 0, this, inetAddress, n);
        }

        public Builder addAddress(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("addAddress", $$robo$$android_net_VpnService_Builder$addAddress(java.lang.String int ), 0, this, string2, n);
        }

        public Builder addRoute(InetAddress inetAddress, int n) {
            return InvokeDynamicSupport.bootstrap("addRoute", $$robo$$android_net_VpnService_Builder$addRoute(java.net.InetAddress int ), 0, this, inetAddress, n);
        }

        public Builder addRoute(String string2, int n) {
            return InvokeDynamicSupport.bootstrap("addRoute", $$robo$$android_net_VpnService_Builder$addRoute(java.lang.String int ), 0, this, string2, n);
        }

        public Builder addDnsServer(InetAddress inetAddress) {
            return InvokeDynamicSupport.bootstrap("addDnsServer", $$robo$$android_net_VpnService_Builder$addDnsServer(java.net.InetAddress ), 0, this, inetAddress);
        }

        public Builder addDnsServer(String string2) {
            return InvokeDynamicSupport.bootstrap("addDnsServer", $$robo$$android_net_VpnService_Builder$addDnsServer(java.lang.String ), 0, this, string2);
        }

        public Builder addSearchDomain(String string2) {
            return InvokeDynamicSupport.bootstrap("addSearchDomain", $$robo$$android_net_VpnService_Builder$addSearchDomain(java.lang.String ), 0, this, string2);
        }

        public Builder allowFamily(int n) {
            return InvokeDynamicSupport.bootstrap("allowFamily", $$robo$$android_net_VpnService_Builder$allowFamily(int ), 0, this, n);
        }

        private void verifyApp(String string2) throws PackageManager.NameNotFoundException {
            InvokeDynamicSupport.bootstrap("verifyApp", $$robo$$android_net_VpnService_Builder$verifyApp(java.lang.String ), 0, this, string2);
        }

        public Builder addAllowedApplication(String string2) throws PackageManager.NameNotFoundException {
            return InvokeDynamicSupport.bootstrap("addAllowedApplication", $$robo$$android_net_VpnService_Builder$addAllowedApplication(java.lang.String ), 0, this, string2);
        }

        public Builder addDisallowedApplication(String string2) throws PackageManager.NameNotFoundException {
            return InvokeDynamicSupport.bootstrap("addDisallowedApplication", $$robo$$android_net_VpnService_Builder$addDisallowedApplication(java.lang.String ), 0, this, string2);
        }

        public Builder allowBypass() {
            return InvokeDynamicSupport.bootstrap("allowBypass", $$robo$$android_net_VpnService_Builder$allowBypass(), 0, this);
        }

        public Builder setBlocking(boolean bl) {
            return InvokeDynamicSupport.bootstrap("setBlocking", $$robo$$android_net_VpnService_Builder$setBlocking(boolean ), 0, this, bl);
        }

        public Builder setUnderlyingNetworks(Network[] networkArray) {
            return InvokeDynamicSupport.bootstrap("setUnderlyingNetworks", $$robo$$android_net_VpnService_Builder$setUnderlyingNetworks(android.net.Network[] ), 0, this, networkArray);
        }

        public ParcelFileDescriptor establish() {
            return InvokeDynamicSupport.bootstrap("establish", $$robo$$android_net_VpnService_Builder$establish(), 0, this);
        }

        public /* synthetic */ Builder() {
            this.$$robo$init();
        }

        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Builder)this);
            }
        }

        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }

    private class Callback
    extends Binder
    implements ShadowedObject {
        public transient /* synthetic */ Object __robo_data__;
        /* synthetic */ VpnService this$0;

        private void $$robo$$android_net_VpnService_Callback$__constructor__(VpnService vpnService) {
        }

        private final boolean $$robo$$android_net_VpnService_Callback$onTransact(int code, Parcel data, Parcel reply, int flags) {
            if (code == 0xFFFFFF) {
                this.this$0.onRevoke();
                return true;
            }
            return false;
        }

        private /* synthetic */ void $$robo$$android_net_VpnService_Callback$__constructor__(VpnService x0, 1 x1) {
        }

        private void __constructor__(VpnService vpnService) {
            this.$$robo$$android_net_VpnService_Callback$__constructor__(vpnService);
        }

        private Callback(VpnService vpnService) {
            this.this$0 = vpnService;
            this.$$robo$init();
            InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_VpnService_Callback$__constructor__(android.net.VpnService ), 0, this, vpnService);
        }

        @Override
        protected boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) {
            return (boolean)InvokeDynamicSupport.bootstrap("onTransact", $$robo$$android_net_VpnService_Callback$onTransact(int android.os.Parcel android.os.Parcel int ), 0, this, n, parcel, parcel2, n2);
        }

        private /* synthetic */ void __constructor__(VpnService vpnService, 1 var2_2) {
            this.$$robo$$android_net_VpnService_Callback$__constructor__(vpnService, var2_2);
        }

        public /* synthetic */ Callback() {
            this.$$robo$init();
        }

        @Override
        protected /* synthetic */ void $$robo$init() {
            if (this.__robo_data__ == null) {
                this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (Callback)this);
            }
        }

        @Override
        public /* synthetic */ Object $$robo$getData() {
            return this.__robo_data__;
        }
    }
}

