/*
 * Decompiled with CFR 0.152.
 */
package android.net;

import android.net.NetworkIdentity;
import android.net.wifi.WifiInfo;
import android.os.Parcel;
import android.os.Parcelable;
import android.telephony.TelephonyManager;
import android.util.BackupUtils;
import com.android.internal.util.ArrayUtils;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import org.robolectric.internal.bytecode.InvokeDynamicSupport;
import org.robolectric.internal.bytecode.RobolectricInternals;
import org.robolectric.internal.bytecode.ShadowedObject;

public class NetworkTemplate
implements Parcelable,
ShadowedObject {
    public transient /* synthetic */ Object __robo_data__;
    private static int BACKUP_VERSION = 1;
    public static int MATCH_MOBILE_ALL = 1;
    @Deprecated
    public static int MATCH_MOBILE_3G_LOWER = 2;
    @Deprecated
    public static int MATCH_MOBILE_4G = 3;
    public static int MATCH_WIFI = 4;
    public static int MATCH_ETHERNET = 5;
    public static int MATCH_MOBILE_WILDCARD = 6;
    public static int MATCH_WIFI_WILDCARD = 7;
    public static int MATCH_BLUETOOTH = 8;
    public static int MATCH_PROXY = 9;
    private static boolean sForceAllNetworkTypes;
    private int mMatchRule;
    private String mSubscriberId;
    private String[] mMatchSubscriberIds;
    private String mNetworkId;
    public static Parcelable.Creator<NetworkTemplate> CREATOR;

    private static final void $$robo$$android_net_NetworkTemplate$forceAllNetworkTypes() {
        sForceAllNetworkTypes = true;
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateMobileAll(String subscriberId) {
        return new NetworkTemplate(1, subscriberId, null);
    }

    @Deprecated
    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateMobile3gLower(String subscriberId) {
        return new NetworkTemplate(2, subscriberId, null);
    }

    @Deprecated
    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateMobile4g(String subscriberId) {
        return new NetworkTemplate(3, subscriberId, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateMobileWildcard() {
        return new NetworkTemplate(6, null, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateWifiWildcard() {
        return new NetworkTemplate(7, null, null);
    }

    @Deprecated
    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateWifi() {
        return NetworkTemplate.buildTemplateWifiWildcard();
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateWifi(String networkId) {
        return new NetworkTemplate(4, null, networkId);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateEthernet() {
        return new NetworkTemplate(5, null, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateBluetooth() {
        return new NetworkTemplate(8, null, null);
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$buildTemplateProxy() {
        return new NetworkTemplate(9, null, null);
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(int matchRule, String subscriberId, String networkId) {
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(int matchRule, String subscriberId, String[] matchSubscriberIds, String networkId) {
        this.mMatchRule = matchRule;
        this.mSubscriberId = subscriberId;
        this.mMatchSubscriberIds = matchSubscriberIds;
        this.mNetworkId = networkId;
    }

    private void $$robo$$android_net_NetworkTemplate$__constructor__(Parcel in) {
        this.mMatchRule = in.readInt();
        this.mSubscriberId = in.readString();
        this.mMatchSubscriberIds = in.createStringArray();
        this.mNetworkId = in.readString();
    }

    private final void $$robo$$android_net_NetworkTemplate$writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mMatchRule);
        dest.writeString(this.mSubscriberId);
        dest.writeStringArray(this.mMatchSubscriberIds);
        dest.writeString(this.mNetworkId);
    }

    private final int $$robo$$android_net_NetworkTemplate$describeContents() {
        return 0;
    }

    private final String $$robo$$android_net_NetworkTemplate$toString() {
        StringBuilder builder = new StringBuilder("NetworkTemplate: ");
        builder.append("matchRule=").append(NetworkTemplate.getMatchRuleName(this.mMatchRule));
        if (this.mSubscriberId != null) {
            builder.append(", subscriberId=").append(NetworkIdentity.scrubSubscriberId(this.mSubscriberId));
        }
        if (this.mMatchSubscriberIds != null) {
            builder.append(", matchSubscriberIds=").append(Arrays.toString(NetworkIdentity.scrubSubscriberId(this.mMatchSubscriberIds)));
        }
        if (this.mNetworkId != null) {
            builder.append(", networkId=").append(this.mNetworkId);
        }
        return builder.toString();
    }

    private final int $$robo$$android_net_NetworkTemplate$hashCode() {
        return Objects.hash(this.mMatchRule, this.mSubscriberId, this.mNetworkId);
    }

    private final boolean $$robo$$android_net_NetworkTemplate$equals(Object obj) {
        if (obj instanceof NetworkTemplate) {
            NetworkTemplate other = (NetworkTemplate)obj;
            return this.mMatchRule == other.mMatchRule && Objects.equals(this.mSubscriberId, other.mSubscriberId) && Objects.equals(this.mNetworkId, other.mNetworkId);
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$isMatchRuleMobile() {
        switch (this.mMatchRule) {
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$isPersistable() {
        switch (this.mMatchRule) {
            case 6: 
            case 7: {
                return false;
            }
        }
        return true;
    }

    private final int $$robo$$android_net_NetworkTemplate$getMatchRule() {
        return this.mMatchRule;
    }

    private final String $$robo$$android_net_NetworkTemplate$getSubscriberId() {
        return this.mSubscriberId;
    }

    private final String $$robo$$android_net_NetworkTemplate$getNetworkId() {
        return this.mNetworkId;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matches(NetworkIdentity ident) {
        switch (this.mMatchRule) {
            case 1: {
                return this.matchesMobile(ident);
            }
            case 2: {
                return this.matchesMobile3gLower(ident);
            }
            case 3: {
                return this.matchesMobile4g(ident);
            }
            case 4: {
                return this.matchesWifi(ident);
            }
            case 5: {
                return this.matchesEthernet(ident);
            }
            case 6: {
                return this.matchesMobileWildcard(ident);
            }
            case 7: {
                return this.matchesWifiWildcard(ident);
            }
            case 8: {
                return this.matchesBluetooth(ident);
            }
            case 9: {
                return this.matchesProxy(ident);
            }
        }
        throw new IllegalArgumentException("unknown network template");
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesMobile(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return (sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered) && !ArrayUtils.isEmpty(this.mMatchSubscriberIds) && ArrayUtils.contains(this.mMatchSubscriberIds, ident.mSubscriberId);
    }

    @Deprecated
    private final boolean $$robo$$android_net_NetworkTemplate$matchesMobile3gLower(NetworkIdentity ident) {
        NetworkTemplate.ensureSubtypeAvailable();
        if (ident.mType == 6) {
            return false;
        }
        if (this.matchesMobile(ident)) {
            switch (TelephonyManager.getNetworkClass(ident.mSubType)) {
                case 0: 
                case 1: 
                case 2: {
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    private final boolean $$robo$$android_net_NetworkTemplate$matchesMobile4g(NetworkIdentity ident) {
        NetworkTemplate.ensureSubtypeAvailable();
        if (ident.mType == 6) {
            return true;
        }
        if (this.matchesMobile(ident)) {
            switch (TelephonyManager.getNetworkClass(ident.mSubType)) {
                case 3: {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesWifi(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: {
                return Objects.equals(WifiInfo.removeDoubleQuotes(this.mNetworkId), WifiInfo.removeDoubleQuotes(ident.mNetworkId));
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesEthernet(NetworkIdentity ident) {
        return ident.mType == 9;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesMobileWildcard(NetworkIdentity ident) {
        if (ident.mType == 6) {
            return true;
        }
        return sForceAllNetworkTypes || ident.mType == 0 && ident.mMetered;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesWifiWildcard(NetworkIdentity ident) {
        switch (ident.mType) {
            case 1: 
            case 13: {
                return true;
            }
        }
        return false;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesBluetooth(NetworkIdentity ident) {
        return ident.mType == 7;
    }

    private final boolean $$robo$$android_net_NetworkTemplate$matchesProxy(NetworkIdentity ident) {
        return ident.mType == 16;
    }

    private static final String $$robo$$android_net_NetworkTemplate$getMatchRuleName(int matchRule) {
        switch (matchRule) {
            case 2: {
                return "MOBILE_3G_LOWER";
            }
            case 3: {
                return "MOBILE_4G";
            }
            case 1: {
                return "MOBILE_ALL";
            }
            case 4: {
                return "WIFI";
            }
            case 5: {
                return "ETHERNET";
            }
            case 6: {
                return "MOBILE_WILDCARD";
            }
            case 7: {
                return "WIFI_WILDCARD";
            }
            case 8: {
                return "BLUETOOTH";
            }
            case 9: {
                return "PROXY";
            }
        }
        return "UNKNOWN";
    }

    private static final void $$robo$$android_net_NetworkTemplate$ensureSubtypeAvailable() {
        throw new IllegalArgumentException("Unable to enforce 3G_LOWER template on combined data.");
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$normalize(NetworkTemplate template, String[] merged) {
        if (template.isMatchRuleMobile() && ArrayUtils.contains(merged, template.mSubscriberId)) {
            return new NetworkTemplate(template.mMatchRule, merged[0], merged, template.mNetworkId);
        }
        return template;
    }

    private final byte[] $$robo$$android_net_NetworkTemplate$getBytesForBackup() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(baos);
        out.writeInt(1);
        out.writeInt(this.mMatchRule);
        BackupUtils.writeString(out, this.mSubscriberId);
        BackupUtils.writeString(out, this.mNetworkId);
        return baos.toByteArray();
    }

    private static final NetworkTemplate $$robo$$android_net_NetworkTemplate$getNetworkTemplateFromBackup(DataInputStream in) throws IOException, BackupUtils.BadVersionException {
        int version = in.readInt();
        if (version < 1 || version > 1) {
            throw new BackupUtils.BadVersionException("Unknown Backup Serialization Version");
        }
        int matchRule = in.readInt();
        String subscriberId = BackupUtils.readString(in);
        String networkId = BackupUtils.readString(in);
        return new NetworkTemplate(matchRule, subscriberId, networkId);
    }

    private /* synthetic */ void $$robo$$android_net_NetworkTemplate$__constructor__(Parcel x0, 1 x1) {
    }

    static void __staticInitializer__() {
        sForceAllNetworkTypes = false;
        CREATOR = new Parcelable.Creator<NetworkTemplate>(){
            public transient /* synthetic */ Object __robo_data__;

            private void $$robo$$android_net_NetworkTemplate_1$__constructor__() {
            }

            private final NetworkTemplate $$robo$$android_net_NetworkTemplate_1$createFromParcel(Parcel in) {
                return new NetworkTemplate(in);
            }

            private final NetworkTemplate[] $$robo$$android_net_NetworkTemplate_1$newArray(int size) {
                return new NetworkTemplate[size];
            }

            private void __constructor__() {
                this.$$robo$$android_net_NetworkTemplate_1$__constructor__();
            }
            {
                this.$$robo$init();
                InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate_1$__constructor__(), 0, this);
            }

            @Override
            public NetworkTemplate createFromParcel(Parcel parcel) {
                return InvokeDynamicSupport.bootstrap("createFromParcel", $$robo$$android_net_NetworkTemplate_1$createFromParcel(android.os.Parcel ), 0, this, parcel);
            }

            public NetworkTemplate[] newArray(int n) {
                return InvokeDynamicSupport.bootstrap("newArray", $$robo$$android_net_NetworkTemplate_1$newArray(int ), 0, this, n);
            }

            protected /* synthetic */ void $$robo$init() {
                if (this.__robo_data__ == null) {
                    this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", this);
                }
            }

            public /* synthetic */ Object $$robo$getData() {
                return this.__robo_data__;
            }
        };
    }

    public static void forceAllNetworkTypes() {
        InvokeDynamicSupport.bootstrapStatic("forceAllNetworkTypes", $$robo$$android_net_NetworkTemplate$forceAllNetworkTypes(), 0);
    }

    public static NetworkTemplate buildTemplateMobileAll(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateMobileAll", $$robo$$android_net_NetworkTemplate$buildTemplateMobileAll(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateMobile3gLower(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateMobile3gLower", $$robo$$android_net_NetworkTemplate$buildTemplateMobile3gLower(java.lang.String ), 0, (String)string2);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateMobile4g(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateMobile4g", $$robo$$android_net_NetworkTemplate$buildTemplateMobile4g(java.lang.String ), 0, (String)string2);
    }

    public static NetworkTemplate buildTemplateMobileWildcard() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateMobileWildcard", $$robo$$android_net_NetworkTemplate$buildTemplateMobileWildcard(), 0);
    }

    public static NetworkTemplate buildTemplateWifiWildcard() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateWifiWildcard", $$robo$$android_net_NetworkTemplate$buildTemplateWifiWildcard(), 0);
    }

    @Deprecated
    public static NetworkTemplate buildTemplateWifi() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateWifi", $$robo$$android_net_NetworkTemplate$buildTemplateWifi(), 0);
    }

    public static NetworkTemplate buildTemplateWifi(String string2) {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateWifi", $$robo$$android_net_NetworkTemplate$buildTemplateWifi(java.lang.String ), 0, (String)string2);
    }

    public static NetworkTemplate buildTemplateEthernet() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateEthernet", $$robo$$android_net_NetworkTemplate$buildTemplateEthernet(), 0);
    }

    public static NetworkTemplate buildTemplateBluetooth() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateBluetooth", $$robo$$android_net_NetworkTemplate$buildTemplateBluetooth(), 0);
    }

    public static NetworkTemplate buildTemplateProxy() {
        return InvokeDynamicSupport.bootstrapStatic("buildTemplateProxy", $$robo$$android_net_NetworkTemplate$buildTemplateProxy(), 0);
    }

    private void __constructor__(int n, String string2, String string3) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(n, string2, string3);
    }

    public NetworkTemplate(int n, String string2, String string3) {
        this(n, string2, new String[]{string2}, string3);
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(int java.lang.String java.lang.String ), 0, this, n, string2, string3);
    }

    private void __constructor__(int n, String string2, String[] stringArray, String string3) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(n, string2, stringArray, string3);
    }

    public NetworkTemplate(int n, String string2, String[] stringArray, String string3) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(int java.lang.String java.lang.String[] java.lang.String ), 0, this, n, string2, stringArray, string3);
    }

    private void __constructor__(Parcel parcel) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(parcel);
    }

    private NetworkTemplate(Parcel parcel) {
        this.$$robo$init();
        InvokeDynamicSupport.bootstrap("__constructor__", $$robo$$android_net_NetworkTemplate$__constructor__(android.os.Parcel ), 0, this, parcel);
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        InvokeDynamicSupport.bootstrap("writeToParcel", $$robo$$android_net_NetworkTemplate$writeToParcel(android.os.Parcel int ), 0, this, parcel, n);
    }

    @Override
    public int describeContents() {
        return (int)InvokeDynamicSupport.bootstrap("describeContents", $$robo$$android_net_NetworkTemplate$describeContents(), 0, this);
    }

    public String toString() {
        return InvokeDynamicSupport.bootstrap("toString", $$robo$$android_net_NetworkTemplate$toString(), 0, this);
    }

    public int hashCode() {
        return (int)InvokeDynamicSupport.bootstrap("hashCode", $$robo$$android_net_NetworkTemplate$hashCode(), 0, this);
    }

    public boolean equals(Object object) {
        return (boolean)InvokeDynamicSupport.bootstrap("equals", $$robo$$android_net_NetworkTemplate$equals(java.lang.Object ), 0, this, object);
    }

    public boolean isMatchRuleMobile() {
        return (boolean)InvokeDynamicSupport.bootstrap("isMatchRuleMobile", $$robo$$android_net_NetworkTemplate$isMatchRuleMobile(), 0, this);
    }

    public boolean isPersistable() {
        return (boolean)InvokeDynamicSupport.bootstrap("isPersistable", $$robo$$android_net_NetworkTemplate$isPersistable(), 0, this);
    }

    public int getMatchRule() {
        return (int)InvokeDynamicSupport.bootstrap("getMatchRule", $$robo$$android_net_NetworkTemplate$getMatchRule(), 0, this);
    }

    public String getSubscriberId() {
        return InvokeDynamicSupport.bootstrap("getSubscriberId", $$robo$$android_net_NetworkTemplate$getSubscriberId(), 0, this);
    }

    public String getNetworkId() {
        return InvokeDynamicSupport.bootstrap("getNetworkId", $$robo$$android_net_NetworkTemplate$getNetworkId(), 0, this);
    }

    public boolean matches(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matches", $$robo$$android_net_NetworkTemplate$matches(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesMobile(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMobile", $$robo$$android_net_NetworkTemplate$matchesMobile(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    @Deprecated
    private boolean matchesMobile3gLower(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMobile3gLower", $$robo$$android_net_NetworkTemplate$matchesMobile3gLower(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    @Deprecated
    private boolean matchesMobile4g(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMobile4g", $$robo$$android_net_NetworkTemplate$matchesMobile4g(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesWifi(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesWifi", $$robo$$android_net_NetworkTemplate$matchesWifi(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesEthernet(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesEthernet", $$robo$$android_net_NetworkTemplate$matchesEthernet(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesMobileWildcard(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesMobileWildcard", $$robo$$android_net_NetworkTemplate$matchesMobileWildcard(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesWifiWildcard(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesWifiWildcard", $$robo$$android_net_NetworkTemplate$matchesWifiWildcard(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesBluetooth(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesBluetooth", $$robo$$android_net_NetworkTemplate$matchesBluetooth(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private boolean matchesProxy(NetworkIdentity networkIdentity) {
        return (boolean)InvokeDynamicSupport.bootstrap("matchesProxy", $$robo$$android_net_NetworkTemplate$matchesProxy(android.net.NetworkIdentity ), 0, this, networkIdentity);
    }

    private static String getMatchRuleName(int n) {
        return InvokeDynamicSupport.bootstrapStatic("getMatchRuleName", $$robo$$android_net_NetworkTemplate$getMatchRuleName(int ), 0, (int)n);
    }

    private static void ensureSubtypeAvailable() {
        InvokeDynamicSupport.bootstrapStatic("ensureSubtypeAvailable", $$robo$$android_net_NetworkTemplate$ensureSubtypeAvailable(), 0);
    }

    public static NetworkTemplate normalize(NetworkTemplate networkTemplate, String[] stringArray) {
        return InvokeDynamicSupport.bootstrapStatic("normalize", $$robo$$android_net_NetworkTemplate$normalize(android.net.NetworkTemplate java.lang.String[] ), 0, (NetworkTemplate)networkTemplate, (String[])stringArray);
    }

    public byte[] getBytesForBackup() throws IOException {
        return InvokeDynamicSupport.bootstrap("getBytesForBackup", $$robo$$android_net_NetworkTemplate$getBytesForBackup(), 0, this);
    }

    public static NetworkTemplate getNetworkTemplateFromBackup(DataInputStream dataInputStream) throws IOException, BackupUtils.BadVersionException {
        return InvokeDynamicSupport.bootstrapStatic("getNetworkTemplateFromBackup", $$robo$$android_net_NetworkTemplate$getNetworkTemplateFromBackup(java.io.DataInputStream ), 0, (DataInputStream)dataInputStream);
    }

    private /* synthetic */ void __constructor__(Parcel parcel, 1 var2_2) {
        this.$$robo$$android_net_NetworkTemplate$__constructor__(parcel, var2_2);
    }

    static {
        RobolectricInternals.classInitializing(NetworkTemplate.class);
    }

    public /* synthetic */ NetworkTemplate() {
        this.$$robo$init();
    }

    protected /* synthetic */ void $$robo$init() {
        if (this.__robo_data__ == null) {
            this.__robo_data__ = InvokeDynamicSupport.bootstrapInit("initializing", (NetworkTemplate)this);
        }
    }

    public /* synthetic */ Object $$robo$getData() {
        return this.__robo_data__;
    }
}

